/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.Timer;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.Tool;

public class DataTrackSupport {
    public static final String HOST = "localhost";
    public static final int PORT = 1099;
    private static Tool remoteTool;
    private static Tool supportTool;
    private static XMLControl messageControl;
    private static Timer timer;
    private static PropertyChangeSupport support;
    private static HashSet<String> dataNames;
    private static boolean connected;

    static {
        support = new SwingPropertyChangeSupport(new Object());
        dataNames = new HashSet();
    }

    private DataTrackSupport() {
    }

    public static boolean connect(final int n, PropertyChangeListener propertyChangeListener) {
        if (!DataTrackSupport.isTrackerAvailable()) {
            return false;
        }
        support.removePropertyChangeListener(propertyChangeListener);
        support.addPropertyChangeListener(propertyChangeListener);
        if (DataTrackSupport.getRemoteTool() != null) {
            if (connected) {
                return true;
            }
            return DataTrackSupport.sendHandshake(n);
        }
        String string = (String)OSPRuntime.getPreference("TRACKER_HOME");
        String string2 = new File(string, "tracker.jar").getAbsolutePath();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("java");
        arrayList.add("-classpath");
        arrayList.add(string2);
        arrayList.add("org.opensourcephysics.cabrillo.tracker.deploy.TrackerStarter");
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        String string3 = "launching Tracker with command ";
        for (String string4 : arrayList) {
            string3 = String.valueOf(string3) + string4 + " ";
        }
        OSPLog.config(string3);
        DataTrackSupport.startProcess(processBuilder);
        if (timer == null) {
            timer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DataTrackSupport.getRemoteTool() != null) {
                        timer.stop();
                        DataTrackSupport.sendHandshake(n);
                    }
                }
            });
        }
        timer.setInitialDelay(1000);
        timer.setRepeats(true);
        timer.start();
        return true;
    }

    public static boolean sendData(int n, Data data) {
        if (data == null) {
            return false;
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("data", data);
        return DataTrackSupport.sendMessage(n, treeMap);
    }

    public static boolean sendAppendedData(int n, Data data) {
        if (data == null) {
            return false;
        }
        if (!dataNames.contains(data.getName())) {
            return DataTrackSupport.sendData(n, data);
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("data", data);
        treeMap.put("append", true);
        return DataTrackSupport.sendMessage(n, treeMap);
    }

    public static boolean sendMessage(int n, Map<String, Object> map) {
        Tool tool = DataTrackSupport.getRemoteTool();
        if (tool == null) {
            return false;
        }
        XMLControl xMLControl = DataTrackSupport.getMessageControl(n);
        Data data = null;
        for (String string : map.keySet()) {
            Object object = map.get(string);
            if (string.equals("data")) {
                data = (Data)object;
            }
            xMLControl.setValue(string, object);
        }
        try {
            tool.send(new LocalJob(xMLControl.toXML()), DataTrackSupport.getSupportTool());
        }
        catch (RemoteException remoteException) {
            return false;
        }
        if (data != null) {
            dataNames.add(data.getName());
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTrackerAvailable() {
        String string = (String)OSPRuntime.getPreference("TRACKER_HOME");
        if (string == null) {
            return false;
        }
        File file = new File(string, "tracker.jar");
        if (!file.exists()) {
            return false;
        }
        try {
            String string2;
            int n;
            Object object;
            String string3;
            JarFile jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            Iterator<Object> iterator = attributes.keySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (!(string3 = (object = iterator.next()).toString()).contains("Build-Date") || (n = Integer.parseInt((string2 = attributes.getValue(string3)).substring(string2.length() - 4, string2.length()))) >= 2015);
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDataRequested() {
        return System.getenv("DATA_REQUESTED") != null;
    }

    private static boolean sendHandshake(int n) {
        XMLControl xMLControl = DataTrackSupport.getMessageControl(n);
        xMLControl.setValue("handshake", true);
        xMLControl.setValue("jar_path", OSPRuntime.getLaunchJarPath());
        try {
            remoteTool.send(new LocalJob(xMLControl.toXML()), DataTrackSupport.getSupportTool());
        }
        catch (RemoteException remoteException) {
            return false;
        }
        return true;
    }

    private static void startProcess(final ProcessBuilder processBuilder) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    String string;
                    Process process = processBuilder.start();
                    InputStream inputStream = process.getInputStream();
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    while ((string = bufferedReader.readLine()) != null) {
                        System.out.println(string);
                    }
                    bufferedReader.close();
                    int n = process.waitFor();
                    if (n > 0) {
                        inputStreamReader = new InputStreamReader(process.getErrorStream());
                        bufferedReader = new BufferedReader(inputStreamReader);
                        while ((string = bufferedReader.readLine()) != null) {
                            System.err.println(string);
                        }
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        new Thread(runnable).start();
    }

    private static Tool getRemoteTool() {
        if (remoteTool == null) {
            try {
                Registry registry = LocateRegistry.getRegistry(HOST, 1099);
                remoteTool = (Tool)registry.lookup("DataTrackTool");
                return remoteTool;
            }
            catch (Exception exception) {}
        }
        return remoteTool;
    }

    private static Tool getSupportTool() {
        if (supportTool == null) {
            try {
                supportTool = new SupportTool();
            }
            catch (RemoteException remoteException) {}
        }
        return supportTool;
    }

    public static XMLControl getMessageControl(int n) {
        if (messageControl == null) {
            messageControl = new XMLControlElement(new Message());
        }
        for (String string : messageControl.getPropertyNames()) {
            messageControl.setValue(string, null);
        }
        messageControl.setValue("sourceID", n);
        return messageControl;
    }

    private static class Message {
        private Message() {
        }
    }

    private static class SupportTool
    extends UnicastRemoteObject
    implements Tool {
        protected SupportTool() throws RemoteException {
        }

        @Override
        public void send(Job job, Tool tool) throws RemoteException {
            XMLControlElement xMLControlElement = new XMLControlElement();
            xMLControlElement.readXML(job.getXML());
            if (xMLControlElement.failedToRead()) {
                return;
            }
            int n = xMLControlElement.getInt("sourceID");
            if (xMLControlElement.getBoolean("handshake")) {
                connected = true;
                support.firePropertyChange("tracker_ready", (Object)n, null);
            } else if (xMLControlElement.getBoolean("exiting")) {
                remoteTool = null;
                connected = false;
                support.firePropertyChange("tracker_exited", null, null);
            }
        }
    }
}

