/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPCombo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLTableInspector;
import org.opensourcephysics.controls.XMLTableModel;
import org.opensourcephysics.display.CellBorder;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ArrayInspector;

public class XMLTable
extends JTable {
    static final Color LIGHT_BLUE = new Color(196, 196, 255);
    XMLTableModel tableModel;
    XMLCellRenderer xmlRenderer = new XMLCellRenderer();
    XMLValueEditor valueEditor = new XMLValueEditor();
    Color defaultBackgroundColor = Color.white;
    Map<String, Color> cellColors = new HashMap<String, Color>();
    Map<String, Color> selectedCellColors = new HashMap<String, Color>();
    Map<String, Color> editingCellColors = new HashMap<String, Color>();
    Color defaultEditingColor;
    PropertyChangeListener comboListener;

    public XMLTable(XMLControl xMLControl) {
        this.tableModel = new XMLTableModel(xMLControl);
        this.init();
    }

    public XMLTable(XMLTableModel xMLTableModel) {
        this.tableModel = xMLTableModel;
        this.init();
    }

    public XMLControl getControl() {
        return this.tableModel.control;
    }

    public void setEditable(boolean bl) {
        this.tableModel.editable = bl;
    }

    public boolean isEditable() {
        return this.tableModel.editable;
    }

    public void setEditable(String string, boolean bl) {
        if (!bl) {
            this.tableModel.uneditablePropNames.add(string);
        } else {
            this.tableModel.uneditablePropNames.remove(string);
        }
    }

    public boolean isEditable(String string) {
        return !this.tableModel.uneditablePropNames.contains(string);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.tableModel.editable && this.tableModel.isCellEditable(n, n2);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.xmlRenderer != null) {
            this.xmlRenderer.setFont(font);
            this.valueEditor.field.setFont(font);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (XMLTable.this.getTableHeader().getHeight() > 0) {
                        XMLTable.this.setRowHeight(XMLTable.this.getTableHeader().getHeight());
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setSelectedColor(String string, Color color) {
        this.selectedCellColors.put(string, color);
    }

    public Color getSelectedColor(String string) {
        Color color = this.selectedCellColors.get(string);
        return color == null ? LIGHT_BLUE : color;
    }

    public void setBackgroundColor(String string, Color color) {
        this.cellColors.put(string, color);
    }

    public Color getBackgroundColor(String string) {
        Color color = this.cellColors.get(string);
        return color == null ? this.defaultBackgroundColor : color;
    }

    public void setEditingColor(String string, Color color) {
        this.editingCellColors.put(string, color);
    }

    public Color getEditingColor(String string) {
        Color color = this.editingCellColors.get(string);
        return color == null ? this.defaultEditingColor : color;
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        return this.xmlRenderer;
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        return this.valueEditor;
    }

    public void refresh() {
        Runnable runnable = new Runnable(){

            @Override
            public synchronized void run() {
                XMLTable.this.tableChanged(new TableModelEvent(XMLTable.this.tableModel, -1));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.firePropertyChange("tableData", null, tableModelEvent);
        super.tableChanged(tableModelEvent);
    }

    public void addControlListener(String string, Object object) {
        this.addControlListener(null, string, object);
    }

    public void addControlListener(String string, String string2, final Object object) {
        Class[] classArray = new Class[]{String.class};
        try {
            final Method method = object.getClass().getMethod(string2, classArray);
            this.tableModel.addTableModelListener(new TableModelListener(string){
                final String par;
                {
                    this.par = string;
                }

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (tableModelEvent.getType() != 0 || tableModelEvent.getColumn() != 1 || tableModelEvent.getFirstRow() < 0) {
                        return;
                    }
                    String string = XMLTable.this.getValueAt(tableModelEvent.getFirstRow(), 0).toString();
                    if (this.par == null || this.par.equals(string)) {
                        Object[] objectArray = new Object[]{string};
                        try {
                            method.invoke(object, objectArray);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(String.valueOf(ControlsRes.getString("XMLTable.ErrorMessage.NoMethod")) + " " + string2 + "()");
        }
    }

    private void init() {
        this.setModel(this.tableModel);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setForeground(Color.BLACK);
        this.setGridColor(Color.BLACK);
        InputMap inputMap = this.getInputMap(1);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
        final Action action = this.getActionMap().get(inputMap.get(keyStroke));
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                action.actionPerformed(actionEvent);
                JTable jTable = (JTable)actionEvent.getSource();
                int n = jTable.getRowCount();
                int n2 = jTable.getSelectedRow();
                int n3 = jTable.getSelectedColumn();
                while (!jTable.isCellEditable(n2, n3)) {
                    if (n3 == 0) {
                        n3 = 1;
                    } else {
                        ++n2;
                    }
                    if (n2 == n) {
                        n2 = 0;
                    }
                    if (n2 == jTable.getSelectedRow() && n3 == jTable.getSelectedColumn()) break;
                }
                jTable.changeSelection(n2, n3, false, false);
            }
        };
        this.getActionMap().put(inputMap.get(keyStroke), abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPanel jPanel;
                JTable jTable = (JTable)actionEvent.getSource();
                int n = jTable.getSelectedRow();
                int n2 = jTable.getSelectedColumn();
                jTable.editCellAt(n, n2, actionEvent);
                Component component = jTable.getEditorComponent();
                if (component instanceof JPanel && (component = (jPanel = (JPanel)component).getComponent(0)) instanceof JTextField) {
                    JTextField jTextField = (JTextField)component;
                    OSPCombo oSPCombo = null;
                    Object object = XMLTable.this.tableModel.getValueAt(n, n2);
                    if (object instanceof XMLControl) {
                        final XMLControl xMLControl = (XMLControl)object;
                        if (xMLControl.getObjectClass() == OSPCombo.class) {
                            oSPCombo = (OSPCombo)xMLControl.loadObject(null);
                        } else if (xMLControl.getObjectClass() == Boolean.class) {
                            Boolean bl = (Boolean)xMLControl.loadObject(null);
                            int n3 = bl != false ? 0 : 1;
                            oSPCombo = new OSPCombo(new String[]{"true", "false"}, n3);
                            oSPCombo.addPropertyChangeListener("value", new PropertyChangeListener(){

                                @Override
                                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                    OSPCombo oSPCombo = (OSPCombo)propertyChangeEvent.getSource();
                                    Boolean bl = new Boolean(oSPCombo.getSelectedIndex() == 0);
                                    xMLControl.saveObject(bl);
                                }
                            });
                        }
                    }
                    if (oSPCombo == null) {
                        jTextField.requestFocus();
                        jTextField.selectAll();
                    } else {
                        oSPCombo.row = n;
                        oSPCombo.column = n2;
                        oSPCombo.removePropertyChangeListener("index", XMLTable.this.comboListener);
                        oSPCombo.addPropertyChangeListener("index", XMLTable.this.comboListener);
                        oSPCombo.showPopup(jTextField);
                    }
                }
            }
        };
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(10, 0);
        this.getActionMap().put(inputMap.get(keyStroke2), abstractAction2);
        this.comboListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                OSPCombo oSPCombo = (OSPCombo)propertyChangeEvent.getSource();
                int n = (Integer)propertyChangeEvent.getOldValue();
                if (n != oSPCombo.getSelectedIndex()) {
                    oSPCombo.firePropertyChange("value", n, oSPCombo.getSelectedIndex());
                    XMLTable.this.tableModel.fireTableCellUpdated(oSPCombo.row, oSPCombo.column);
                }
                oSPCombo.removePropertyChangeListener("index", this);
                XMLTable.this.valueEditor.stopCellEditing();
            }
        };
    }

    private boolean isInspectable(XMLProperty xMLProperty) {
        if (xMLProperty.getPropertyType().equals("object")) {
            return true;
        }
        if (xMLProperty.getPropertyType().equals("array")) {
            return ArrayInspector.canInspect(xMLProperty);
        }
        return xMLProperty.getPropertyType().equals("collection");
    }

    class XMLCellRenderer
    extends DefaultTableCellRenderer {
        Color lightGreen = new Color(204, 255, 204);
        Color lightGray = UIManager.getColor("Panel.background");
        Font font = new JTextField().getFont();

        public XMLCellRenderer() {
            this.setOpaque(true);
            this.setForeground(Color.black);
            this.setFont(this.font);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setForeground(Color.BLACK);
            if (object == null) {
                object = "";
            }
            String string = (String)XMLTable.this.tableModel.getValueAt(n, 0);
            Class<?> clazz = null;
            Object object2 = null;
            if (n2 == 0) {
                if (bl) {
                    this.setBackground(LIGHT_BLUE);
                } else {
                    this.setBackground(this.lightGray);
                }
                this.setHorizontalAlignment(2);
                String string2 = object.toString();
                if (OSPRuntime.getTranslator() != null) {
                    string2 = OSPRuntime.getTranslator().getProperty(XMLTable.this, string2);
                }
                this.setText(string2);
                this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 2));
                return this;
            }
            if (object instanceof XMLProperty) {
                XMLProperty xMLProperty = (XMLProperty)object;
                XMLProperty xMLProperty2 = xMLProperty.getParentProperty();
                clazz = xMLProperty2.getPropertyClass();
                String string3 = XML.getSimpleClassName(clazz);
                XMLControl xMLControl = (XMLControl)xMLProperty2.getParentProperty();
                object2 = xMLControl.getObject(xMLProperty2.getPropertyName());
                if (xMLProperty2.getPropertyType().equals("array")) {
                    Object object3 = object2;
                    Class<?> clazz2 = object3.getClass().getComponentType();
                    int n3 = Array.getLength(object3);
                    int n4 = string3.indexOf("[]") + 1;
                    string3 = String.valueOf(string3.substring(0, n4)) + n3 + string3.substring(n4);
                    while (clazz2.getComponentType() != null) {
                        clazz2 = clazz2.getComponentType();
                        if ((object3 = Array.get(object3, 0)) == null) break;
                        n3 = Array.getLength(object3);
                        n4 = string3.indexOf("[]", n4) + 1;
                        string3 = String.valueOf(string3.substring(0, n4)) + n3 + string3.substring(n4);
                    }
                }
                if (clazz != OSPCombo.class && clazz != Boolean.class && clazz != Character.class) {
                    this.setText(string3);
                    this.setBackground(XMLTable.this.isInspectable(xMLProperty2) ? this.lightGreen : this.lightGray);
                    this.setBorder(new CellBorder(new Color(240, 240, 240)));
                    this.setHorizontalAlignment(0);
                    if (bl && XMLTable.this.isInspectable(xMLProperty2)) {
                        this.setBackground(XMLTable.this.getSelectedColor(string));
                        this.setForeground(Color.RED);
                    }
                    return this;
                }
            }
            if (bl) {
                this.setBackground(XMLTable.this.getSelectedColor(string));
                this.setForeground(Color.RED);
            } else {
                this.setBackground(XMLTable.this.getBackgroundColor(string));
            }
            this.setHorizontalAlignment(2);
            if (clazz == OSPCombo.class || clazz == Boolean.class || clazz == Character.class) {
                this.setText(object2.toString());
            } else {
                this.setText(object.toString());
            }
            this.setBorder(new CellBorder(new Color(240, 240, 240)));
            if (!XMLTable.this.tableModel.editable || XMLTable.this.tableModel.uneditablePropNames.contains(string)) {
                this.setForeground(Color.GRAY);
            }
            return this;
        }
    }

    class XMLValueEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JPanel panel = new JPanel(new BorderLayout());
        JTextField field = new JTextField();
        int keepFocus = -2;
        OSPCombo combo;

        XMLValueEditor() {
            XMLTable.this.defaultEditingColor = this.field.getSelectionColor();
            this.panel.add((Component)this.field, "Center");
            this.panel.setOpaque(false);
            this.field.setBorder(BorderFactory.createLineBorder(new Color(128, 128, 128), 1));
            this.field.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    XMLValueEditor.this.stopCellEditing();
                    XMLValueEditor.this.keepFocus = -2;
                }
            });
            this.field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        XMLValueEditor.this.stopCellEditing();
                        XMLValueEditor.this.keepFocus = -2;
                    } else if (XMLValueEditor.this.field.isEnabled()) {
                        XMLValueEditor.this.field.setBackground(Color.yellow);
                    }
                }
            });
            this.field.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    int n;
                    if (focusEvent.isTemporary()) {
                        return;
                    }
                    if (XMLValueEditor.this.field.getBackground() != ((XMLValueEditor)XMLValueEditor.this).XMLTable.this.defaultBackgroundColor) {
                        XMLValueEditor.this.stopCellEditing();
                    }
                    if (XMLValueEditor.this.keepFocus == (n = XMLTable.this.getSelectedRow())) {
                        XMLValueEditor.this.keepFocus = -2;
                    } else {
                        XMLTable.this.requestFocusInWindow();
                    }
                }
            });
            this.field.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (XMLValueEditor.this.combo != null) {
                        if (XMLValueEditor.this.combo.getPropertyChangeListeners("index").length > 0) {
                            XMLValueEditor.this.combo.removePropertyChangeListener("index", ((XMLValueEditor)XMLValueEditor.this).XMLTable.this.comboListener);
                            XMLValueEditor.this.combo.setVisible(false);
                            XMLValueEditor.this.stopCellEditing();
                        } else {
                            XMLValueEditor.this.combo.removePropertyChangeListener("index", ((XMLValueEditor)XMLValueEditor.this).XMLTable.this.comboListener);
                            XMLValueEditor.this.combo.addPropertyChangeListener("index", ((XMLValueEditor)XMLValueEditor.this).XMLTable.this.comboListener);
                            XMLValueEditor.this.combo.showPopup(XMLValueEditor.this.field);
                        }
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.combo = null;
            String string = (String)XMLTable.this.tableModel.getValueAt(n, 0);
            this.field.setBackground(XMLTable.this.defaultBackgroundColor);
            this.field.setSelectionColor(XMLTable.this.getEditingColor(string));
            final int n3 = n;
            final int n4 = n2;
            if (object instanceof XMLControl) {
                final XMLControl xMLControl = (XMLControl)object;
                if (xMLControl.getObjectClass() == Color.class) {
                    Color color = (Color)xMLControl.loadObject(null);
                    String string2 = ControlsRes.getString("XMLTable.ColorChooser.Title");
                    Color color2 = JColorChooser.showDialog(null, string2, color);
                    if (color2 != null && !color.equals(color2)) {
                        xMLControl.saveObject(color2);
                        XMLTable.this.tableModel.fireTableCellUpdated(n, n2);
                    }
                    return null;
                }
                if (xMLControl.getObjectClass() == Character.class) {
                    Character c = (Character)xMLControl.loadObject(null);
                    this.field.setEditable(true);
                    this.field.setText(c.toString());
                    return this.panel;
                }
                if (xMLControl.getObjectClass() == OSPCombo.class) {
                    this.combo = (OSPCombo)xMLControl.loadObject(null);
                    this.combo.row = n;
                    this.combo.column = n2;
                    this.field.setText(this.combo.toString());
                    this.field.setEditable(false);
                    return this.panel;
                }
                if (xMLControl.getObjectClass() == Boolean.class) {
                    Boolean bl2 = (Boolean)xMLControl.loadObject(null);
                    int n5 = bl2 != false ? 0 : 1;
                    this.combo = new OSPCombo(new String[]{"true", "false"}, n5);
                    this.combo.row = n;
                    this.combo.column = n2;
                    this.field.setText(bl2.toString());
                    this.field.setEditable(false);
                    this.combo.addPropertyChangeListener("value", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            OSPCombo oSPCombo = (OSPCombo)propertyChangeEvent.getSource();
                            Boolean bl = new Boolean(oSPCombo.getSelectedIndex() == 0);
                            xMLControl.saveObject(bl);
                        }
                    });
                    return this.panel;
                }
                XMLTableInspector xMLTableInspector = new XMLTableInspector(xMLControl, XMLTable.this.isEditable());
                xMLTableInspector.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("xmlData")) {
                            ((XMLValueEditor)XMLValueEditor.this).XMLTable.this.tableModel.fireTableCellUpdated(n3, n4);
                        }
                    }
                });
                Container container = XMLTable.this.getTopLevelAncestor();
                Point point = container.getLocationOnScreen();
                xMLTableInspector.setLocation(point.x + 30, point.y + 30);
                xMLTableInspector.setVisible(true);
                return null;
            }
            if (object instanceof XMLProperty) {
                Point point;
                Container container;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                XMLProperty xMLProperty = (XMLProperty)object;
                XMLProperty xMLProperty2 = xMLProperty.getParentProperty();
                if (xMLProperty2.getPropertyType().equals("collection")) {
                    object6 = xMLProperty2.getPropertyName();
                    if ((xMLProperty2 = xMLProperty2.getParentProperty()) instanceof XMLControl) {
                        object5 = new XMLControlElement();
                        object4 = (Collection)((XMLControl)xMLProperty2).getObject((String)object6);
                        object3 = object4.iterator();
                        int n6 = 0;
                        while (object3.hasNext()) {
                            object2 = object3.next();
                            object5.setValue("item_" + n6, object2);
                            ++n6;
                        }
                        object2 = new XMLTableInspector((XMLControl)object5);
                        ((Dialog)object2).setTitle(String.valueOf(ControlsRes.getString("XMLTable.Inspector.Title")) + (String)object6 + "\"");
                        container = XMLTable.this.getTopLevelAncestor();
                        point = container.getLocationOnScreen();
                        ((Window)object2).setLocation(point.x + 30, point.y + 30);
                        ((Dialog)object2).setVisible(true);
                        container.transferFocus();
                    }
                }
                if ((object5 = ArrayInspector.getInspector((XMLProperty)(object6 = xMLProperty.getParentProperty()))) != null) {
                    object4 = object6.getPropertyName();
                    xMLProperty2 = object6.getParentProperty();
                    while (!(xMLProperty2 instanceof XMLControl)) {
                        object4 = xMLProperty2.getPropertyName();
                        object6 = xMLProperty2;
                        xMLProperty2 = xMLProperty2.getParentProperty();
                    }
                    object3 = (XMLControl)xMLProperty2;
                    Object object7 = object4;
                    object2 = ((ArrayInspector)object5).getArray();
                    ((ArrayInspector)object5).setEditable(XMLTable.this.tableModel.editable);
                    ((Window)object5).addPropertyChangeListener(new PropertyChangeListener((XMLControl)object3, (String)object7, object2, n3, n4){
                        private final /* synthetic */ XMLControl val$arrayControl;
                        private final /* synthetic */ String val$arrayName;
                        private final /* synthetic */ Object val$arrayObj;
                        private final /* synthetic */ int val$rowNumber;
                        private final /* synthetic */ int val$colNumber;
                        {
                            this.val$arrayControl = xMLControl;
                            this.val$arrayName = string;
                            this.val$arrayObj = object;
                            this.val$rowNumber = n;
                            this.val$colNumber = n2;
                        }

                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if (propertyChangeEvent.getPropertyName().equals("cell")) {
                                this.val$arrayControl.setValue(this.val$arrayName, this.val$arrayObj);
                            } else if (propertyChangeEvent.getPropertyName().equals("arrayData")) {
                                ((XMLValueEditor)XMLValueEditor.this).XMLTable.this.tableModel.fireTableCellUpdated(this.val$rowNumber, this.val$colNumber);
                            }
                        }
                    });
                    container = XMLTable.this.getTopLevelAncestor();
                    point = container.getLocationOnScreen();
                    ((Window)object5).setLocation(point.x + 30, point.y + 30);
                    ((Dialog)object5).setVisible(true);
                    container.transferFocus();
                }
                return null;
            }
            this.field.setEditable(true);
            if (object != null) {
                this.field.setText(object.toString());
            }
            return this.panel;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                XMLControl xMLControl;
                int n;
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                XMLTable xMLTable = (XMLTable)mouseEvent.getSource();
                this.keepFocus = n = xMLTable.rowAtPoint(mouseEvent.getPoint());
                Object object = XMLTable.this.tableModel.getValueAt(n, 1);
                if (object instanceof XMLControl && ((xMLControl = (XMLControl)object).getObjectClass() == OSPCombo.class || xMLControl.getObjectClass() == Boolean.class || xMLControl.getObjectClass() == Character.class)) {
                    return true;
                }
                if (object instanceof String || mouseEvent.getClickCount() == 2) {
                    return true;
                }
            } else if (eventObject instanceof ActionEvent) {
                this.keepFocus = -2;
                return true;
            }
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            XMLTable.this.requestFocusInWindow();
            if (this.field.getBackground() != XMLTable.this.defaultBackgroundColor) {
                this.field.setBackground(XMLTable.this.defaultBackgroundColor);
                return this.field.getText();
            }
            return null;
        }
    }
}

