/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker.deploy;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.opensourcephysics.cabrillo.tracker.deploy.TrackerJarFilter;
import org.opensourcephysics.cabrillo.tracker.deploy.WinRegistry;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.DiagnosticsForXuggle;
import org.opensourcephysics.tools.ExtensionsManager;

public class TrackerStarter {
    public static final String PREFERRED_TRACKER_JAR = "PREFERRED_TRACKER_JAR";
    public static final String PREFERRED_MEMORY_SIZE = "PREFERRED_MEMORY_SIZE";
    public static final String TRACKER_RELAUNCH = "TRACKER_RELAUNCH";
    public static final String LOG_FILE_NAME = "tracker_start.log";
    public static final int DEFAULT_MEMORY_SIZE = 256;
    static String prefsFileName = ".tracker.prefs";
    static String newline = "\n";
    static String encoding = "UTF-8";
    static String exceptions = "";
    static String qtJavaWarning;
    static String xuggleWarning;
    static String starterWarning;
    static String trackerHome;
    static String userHome;
    static String javaHome;
    static String xuggleHome;
    static String userDocuments;
    static String startLogPath;
    static FilenameFilter trackerJarFilter;
    static File codeBaseDir;
    static File starterJarFile;
    static double launchVersionNumber;
    static String launchVersionString;
    static String trackerJarPath;
    static int memorySize;
    static int preferredMemorySize;
    static String[] executables;
    static String logText;
    static String javaCommand;
    static String preferredVM;
    static String snapshot;
    static boolean debug;
    static boolean log;
    static boolean use32BitMode;
    static boolean relaunching;
    static int port;
    static Timer timer;

    static {
        trackerJarFilter = new TrackerJarFilter();
        logText = "";
        javaCommand = "java";
        snapshot = "-snapshot";
        debug = false;
        log = true;
        use32BitMode = false;
        relaunching = false;
        port = 12321;
        try {
            newline = System.getProperty("line.separator", "\n");
            URL uRL = TrackerStarter.class.getProtectionDomain().getCodeSource().getLocation();
            starterJarFile = new File(uRL.toURI());
            codeBaseDir = starterJarFile.getParentFile();
        }
        catch (Exception exception) {
            exceptions = String.valueOf(exceptions) + exception.getClass().getSimpleName() + ": " + exception.getMessage() + newline;
        }
        try {
            userHome = System.getProperty("user.home");
            javaHome = System.getProperty("java.home");
            if (OSPRuntime.isWindows()) {
                userDocuments = WinRegistry.readString(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Personal");
            } else {
                userDocuments = String.valueOf(userHome) + "/Documents";
                if (!new File(userDocuments).exists()) {
                    userDocuments = null;
                }
            }
        }
        catch (Exception exception) {
            exceptions = String.valueOf(exceptions) + exception.getClass().getSimpleName() + ": " + exception.getMessage() + newline;
        }
    }

    public static void main(String[] stringArray) {
        relaunching = false;
        logText = "";
        TrackerStarter.logMessage("launch initiated by user");
        TrackerStarter.launchTracker(stringArray);
    }

    public static void launchTracker(String[] stringArray) {
        String string;
        String string2 = null;
        if (stringArray != null && stringArray.length > 0) {
            string2 = "";
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                string = stringArray2[n2];
                string2 = String.valueOf(string2) + "\"" + string + "\" ";
                ++n2;
            }
        }
        TrackerStarter.logMessage("launching with main arguments: " + string2);
        string = null;
        try {
            trackerHome = TrackerStarter.findTrackerHome(true);
        }
        catch (Exception exception) {
            exceptions = String.valueOf(exceptions) + exception.getClass().getSimpleName() + ": " + exception.getMessage() + newline;
        }
        if (trackerHome == null) {
            TrackerStarter.exitGracefully(null);
        }
        try {
            xuggleHome = TrackerStarter.findXuggleHome(trackerHome, true);
        }
        catch (Exception exception) {
            exceptions = String.valueOf(exceptions) + exception.getClass().getSimpleName() + ": " + exception.getMessage() + newline;
        }
        TrackerStarter.loadPreferences();
        try {
            string = TrackerStarter.getTrackerJarPath();
        }
        catch (Exception exception) {
            exceptions = String.valueOf(exceptions) + exception.getClass().getSimpleName() + ": " + exception.getMessage() + newline;
        }
        if (string == null) {
            TrackerStarter.exitGracefully(null);
        }
        boolean bl = true;
        try {
            memorySize = preferredMemorySize;
            TrackerStarter.startTracker(string, stringArray);
        }
        catch (Exception exception) {
            bl = false;
            exceptions = String.valueOf(exceptions) + exception.getClass().getSimpleName() + ": " + exception.getMessage() + newline;
        }
        catch (Error error) {
            bl = false;
            exceptions = String.valueOf(exceptions) + error.getClass().getSimpleName() + ": " + error.getMessage() + newline;
        }
        if (!bl) {
            TrackerStarter.exitGracefully(string);
        }
    }

    public static void relaunch(final String[] stringArray, boolean bl) {
        relaunching = bl;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                logText = "";
                TrackerStarter.logMessage("relaunch initiated by Tracker");
                TrackerStarter.launchTracker(stringArray);
            }
        };
        new Thread(runnable).start();
    }

    public static String findTrackerHome(boolean bl) throws Exception {
        Object object;
        if (codeBaseDir != null) {
            if (bl) {
                TrackerStarter.logMessage("code base: " + codeBaseDir.getPath());
            }
            try {
                object = codeBaseDir.list(trackerJarFilter);
                if (object != null && ((Object)object).length > 0) {
                    trackerHome = codeBaseDir.getPath();
                    if (bl) {
                        TrackerStarter.logMessage("code base accepted as trackerhome based on contents");
                    }
                }
            }
            catch (Exception exception) {
                exceptions = String.valueOf(exceptions) + exception.getClass().getSimpleName() + ": " + exception.getMessage() + newline;
            }
        }
        if (trackerHome == null) {
            object = new File(null, "tracker.jar");
            String string = ((File)object).getAbsoluteFile().getParent();
            if (TrackerStarter.fileExists(((File)object).getAbsolutePath())) {
                trackerHome = string;
                if (bl) {
                    TrackerStarter.logMessage("parent directory accepted as trackerhome based on contents");
                }
            }
        }
        if (trackerHome == null) {
            try {
                trackerHome = System.getenv("TRACKER_HOME");
            }
            catch (Exception exception) {
                exceptions = String.valueOf(exceptions) + exception.getClass().getSimpleName() + ": " + exception.getMessage() + newline;
            }
            if (bl) {
                TrackerStarter.logMessage("environment variable TRACKER_HOME: " + trackerHome);
            }
            if (trackerHome != null && !TrackerStarter.fileExists(trackerHome)) {
                trackerHome = null;
                if (bl) {
                    TrackerStarter.logMessage("TRACKER_HOME directory no longer exists");
                }
            }
        }
        if (trackerHome == null) {
            throw new NullPointerException("trackerhome not found");
        }
        if (bl) {
            TrackerStarter.logMessage("using trackerhome: " + trackerHome);
        }
        return trackerHome;
    }

    public static XMLControl findPreferences() {
        Control control = null;
        String string = null;
        block0: for (String string2 : OSPRuntime.getDefaultSearchPaths()) {
            int n = 0;
            while (n < 2) {
                String string3;
                String string4 = prefsFileName;
                if (n == 1) {
                    string4 = string4.substring(1);
                }
                if (!(control = new XMLControlElement(string3 = new File(string2, string4).getAbsolutePath())).failedToRead() && control.getObjectClassName().endsWith("Preferences")) {
                    string = string3;
                    break block0;
                }
                ++n;
            }
        }
        if (string != null) {
            control.setValue("prefsPath", string);
            return control;
        }
        return null;
    }

    public static String findXuggleHome(String string, boolean bl) throws Exception {
        if (string != null) {
            File file = new File(string);
            File file2 = new File(file, "Xuggle");
            if (!file2.exists() || !file2.isDirectory()) {
                file2 = new File(file.getParentFile(), "Xuggle");
            }
            if (!(file2.exists() && file2.isDirectory() || !OSPRuntime.isMac())) {
                file2 = new File("/usr/local/xuggler");
            }
            if (file2.exists() && file2.isDirectory()) {
                xuggleHome = file2.getPath();
                if (bl) {
                    TrackerStarter.logMessage("xugglehome found relative to trackerhome: " + xuggleHome);
                }
            }
        }
        if (xuggleHome == null) {
            try {
                xuggleHome = System.getenv("XUGGLE_HOME");
            }
            catch (Exception exception) {
                exceptions = String.valueOf(exceptions) + exception.getClass().getSimpleName() + ": " + exception.getMessage() + newline;
            }
            if (bl) {
                TrackerStarter.logMessage("environment variable XUGGLE_HOME: " + xuggleHome);
            }
            if (xuggleHome != null && !TrackerStarter.fileExists(xuggleHome)) {
                xuggleHome = null;
                if (bl) {
                    TrackerStarter.logMessage("XUGGLE_HOME directory no longer exists");
                }
            }
        }
        if (xuggleHome == null) {
            throw new NullPointerException("xugglehome not found");
        }
        if (bl) {
            TrackerStarter.logMessage("using xugglehome: " + xuggleHome);
        }
        return xuggleHome;
    }

    private static void exitGracefully(String string) {
        if (timer != null) {
            timer.stop();
        }
        if (exceptions.equals("")) {
            exceptions = "None";
        }
        String string2 = "";
        if (startLogPath != null) {
            string2 = "For more information see " + startLogPath + newline;
        }
        if (string != null) {
            JOptionPane.showMessageDialog(null, "Tracker could not be started automatically due to" + newline + "the problem(s) listed below.  However, you may be able to" + newline + "start it directly by double-clicking the jar file" + newline + string + "." + newline + newline + string2 + "For trouble-shooting or to download the latest installer," + newline + "please see http://physlets.org/tracker/." + newline + newline + "Problems:" + newline + exceptions, "TrackerStarter Vers 4.91: Error Starting Tracker", 0);
        } else if (trackerHome == null) {
            if (codeBaseDir != null) {
                JOptionPane.showMessageDialog(null, "It appears you have an incomplete Tracker installation, since" + newline + "no directory named \"Tracker\" could be found and " + newline + "no tracker.jar or tracker-x.xx.jar file exists in " + newline + codeBaseDir + newline + newline + string2 + "For trouble-shooting or to download the latest installer," + newline + "please see http://physlets.org/tracker/." + newline + newline + "Problems:" + newline + exceptions, "TrackerStarter Vers 4.91: Error Starting Tracker", 0);
            } else {
                JOptionPane.showMessageDialog(null, "It appears you have an incomplete Tracker installation, since" + newline + "no directory named \"Tracker\" could be found and " + newline + "no tracker.jar or tracker-x.xx.jar file exists in the current directory." + newline + newline + string2 + "For trouble-shooting or to download the latest installer," + newline + "please see http://physlets.org/tracker/." + newline + newline + "Problems:" + newline + exceptions, "TrackerStarter Vers 4.91: Error Starting Tracker", 0);
            }
        } else {
            String string3 = OSPRuntime.isMac() ? codeBaseDir.getAbsolutePath() : trackerHome;
            JOptionPane.showMessageDialog(null, "No tracker.jar or tracker-x.xx.jar was found in" + newline + string3 + newline + newline + string2 + "For trouble-shooting or to download the latest installer," + newline + "please see http://physlets.org/tracker/." + newline + newline + "Problems:" + newline + exceptions, "TrackerStarter Vers 4.91: Error Starting Tracker", 0);
        }
        TrackerStarter.writeUserLog();
        TrackerStarter.writeCodeBaseLog();
        System.exit(0);
    }

    private static void loadPreferences() {
        trackerJarPath = null;
        boolean bl = false;
        XMLControl xMLControl = TrackerStarter.findPreferences();
        if (xMLControl == null) {
            TrackerStarter.logMessage("no preferences file found");
            return;
        }
        String string = xMLControl.getString("prefsPath");
        if (!xMLControl.failedToRead()) {
            Object object;
            String string2;
            TrackerStarter.logMessage("loading starter preferences from: " + string);
            use32BitMode = xMLControl.getBoolean("32-bit");
            String string3 = null;
            String string4 = System.getProperty(PREFERRED_TRACKER_JAR);
            if (string4 != null) {
                bl = true;
                trackerJarPath = string4;
                string3 = XML.getName(trackerJarPath);
                TrackerStarter.logMessage("system property PREFERRED_TRACKER_JAR = " + string4);
            } else if (xMLControl.getPropertyNames().contains("tracker_jar")) {
                bl = true;
                string3 = xMLControl.getString("tracker_jar");
            }
            if (string3 != null && !string3.equals("tracker.jar")) {
                int n = string3.indexOf(".jar");
                string2 = string3.substring(8, n);
                object = string2;
                int n2 = string2.toLowerCase().indexOf(snapshot);
                if (n2 > -1) {
                    string2 = string2.substring(0, n2);
                }
                try {
                    launchVersionNumber = Double.parseDouble(string2);
                    launchVersionString = object;
                    TrackerStarter.logMessage("preferred version: " + launchVersionString);
                }
                catch (Exception exception) {
                    TrackerStarter.logMessage("version number could not be parsed: " + string2);
                }
            }
            preferredVM = null;
            if (xMLControl.getPropertyNames().contains("java_vm")) {
                bl = true;
                preferredVM = xMLControl.getString("java_vm");
            }
            if (preferredVM != null) {
                File file = OSPRuntime.getJavaFile(preferredVM);
                if (file != null && file.exists()) {
                    javaCommand = XML.stripExtension(file.getPath());
                    TrackerStarter.logMessage("preferred java VM: " + javaCommand);
                } else {
                    TrackerStarter.logMessage("preferred java VM invalid--using default instead");
                    preferredVM = null;
                    javaCommand = "java";
                }
            }
            if (xMLControl.getPropertyNames().contains("run")) {
                bl = true;
                executables = (String[])xMLControl.getObject("run");
                int n = 0;
                while (n < executables.length) {
                    string2 = executables[n];
                    if (string2 != null) {
                        object = new File(trackerHome, string2);
                        if (!((File)object).exists() && !((File)(object = new File(string2))).exists()) {
                            object = null;
                            TrackerStarter.logMessage("executable file not found: " + string2);
                        }
                        if (object != null) {
                            try {
                                TrackerStarter.logMessage("executing " + ((File)object).getAbsolutePath());
                                ProcessBuilder processBuilder = new ProcessBuilder(((File)object).getAbsolutePath());
                                processBuilder.directory(new File(trackerHome));
                                Process process = processBuilder.start();
                                process.waitFor();
                            }
                            catch (Exception exception) {
                                TrackerStarter.logMessage("execution failed: " + exception.getClass().getSimpleName() + " " + exception.getMessage());
                            }
                        }
                    }
                    ++n;
                }
            }
            preferredMemorySize = 0;
            string4 = System.getProperty(PREFERRED_MEMORY_SIZE);
            if (string4 != null) {
                bl = true;
                try {
                    preferredMemorySize = Integer.parseInt(string4);
                    TrackerStarter.logMessage("system property PREFERRED_MEMORY_SIZE = " + string4);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (xMLControl.getPropertyNames().contains("memory_size")) {
                preferredMemorySize = xMLControl.getInt("memory_size");
            }
            if (preferredMemorySize > 0) {
                TrackerStarter.logMessage("preferred memory size: " + preferredMemorySize + " MB");
            } else {
                preferredMemorySize = 256;
                TrackerStarter.logMessage("using default memory size: " + preferredMemorySize + " MB");
            }
            if (!bl) {
                TrackerStarter.logMessage("no starter preferences found in " + string);
            }
        }
    }

    private static String getTrackerJarPath() throws Exception {
        File file;
        String string;
        String string2;
        block16: {
            if (trackerJarPath != null) {
                return trackerJarPath;
            }
            string2 = null;
            String string3 = string = OSPRuntime.isMac() ? codeBaseDir.getAbsolutePath() : trackerHome;
            if (OSPRuntime.isMac()) {
                TrackerStarter.logMessage("Mac OSX: looking for tracker jars in " + string);
            } else if (OSPRuntime.isWindows()) {
                TrackerStarter.logMessage("Windows: looking for tracker jars in " + string);
            } else {
                TrackerStarter.logMessage("Linux: looking for tracker jars in " + string);
            }
            try {
                String string4;
                file = new File(string);
                String[] stringArray = file.list(trackerJarFilter);
                if (stringArray == null || stringArray.length <= 0) break block16;
                String string5 = "tracker jars found: ";
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    string4 = stringArray2[n2];
                    string5 = String.valueOf(string5) + string4 + ", ";
                    ++n2;
                }
                TrackerStarter.logMessage(string5.substring(0, string5.length() - 2));
                string4 = null;
                String string6 = null;
                double d = 0.0;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if ("tracker.jar".equals(stringArray[n3].toLowerCase())) {
                        string4 = stringArray[n3];
                    }
                    try {
                        double d2;
                        String string7 = stringArray[n3].substring(8);
                        String string8 = string7 = string7.substring(0, string7.length() - 4);
                        int n4 = string7.toLowerCase().indexOf(snapshot);
                        if (n4 > -1) {
                            string7 = string7.substring(0, n4);
                        }
                        if ((d2 = Double.parseDouble(string7)) == launchVersionNumber && string8.equals(launchVersionString)) {
                            File file2 = new File(string, stringArray[n3]);
                            TrackerStarter.logMessage("using tracker jar: " + file2.getAbsolutePath());
                            return file2.getAbsolutePath();
                        }
                        if (d2 > d) {
                            d = d2;
                            string6 = stringArray[n3];
                        }
                    }
                    catch (Exception exception) {}
                    ++n3;
                }
                string2 = string4 != null ? string4 : string6;
            }
            catch (Exception exception) {
                exceptions = String.valueOf(exceptions) + exception.getClass().getSimpleName() + ": " + exception.getMessage() + newline;
                TrackerStarter.logMessage(exception.toString());
                string2 = "tracker.jar";
            }
        }
        if (string2 != null && (file = new File(string, string2)).exists()) {
            TrackerStarter.logMessage("using tracker jar: " + file.getAbsolutePath());
            return file.getAbsolutePath();
        }
        throw new NullPointerException("No Tracker jar files found in " + string);
    }

    private static void startTracker(String string, String[] stringArray) throws Exception {
        String string2;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (javaCommand.equals("java") && javaHome != null) {
            javaCommand = String.valueOf(XML.forwardSlash(javaHome)) + "/bin/java";
        }
        arrayList.add(javaCommand);
        if (memorySize > 0) {
            arrayList.add("-Xms32m");
            arrayList.add("-Xmx" + memorySize + "m");
        }
        if (OSPRuntime.isMac()) {
            arrayList.add(use32BitMode ? "-d32" : "-d64");
            arrayList.add("-Xdock:name=Tracker");
        }
        arrayList.add("-jar");
        arrayList.add(string);
        if (stringArray != null && stringArray.length > 0) {
            String[] object22 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = object22[n2];
                if (object != null) {
                    arrayList.add((String)object);
                }
                ++n2;
            }
        }
        object = new ProcessBuilder(arrayList);
        Map<String, String> map = ((ProcessBuilder)object).environment();
        if (memorySize < preferredMemorySize) {
            map.put("MEMORY_SIZE", String.valueOf(memorySize));
            TrackerStarter.logMessage("setting environment variable MEMORY_SIZE = " + String.valueOf(memorySize));
        } else {
            map.remove("MEMORY_SIZE");
        }
        map.remove("XUGGLE_WARNING");
        map.remove("QTJAVA_WARNING");
        if (starterWarning != null) {
            map.put("STARTER_WARNING", starterWarning);
        } else {
            map.remove("STARTER_WARNING");
        }
        if (trackerHome != null) {
            map.put("TRACKER_HOME", trackerHome);
            TrackerStarter.logMessage("setting TRACKER_HOME = " + trackerHome);
        }
        if (xuggleHome != null && new File(xuggleHome).exists()) {
            map.put("XUGGLE_HOME", xuggleHome);
            TrackerStarter.logMessage("setting XUGGLE_HOME = " + xuggleHome);
            String string3 = OSPRuntime.isWindows() ? "Path" : (OSPRuntime.isMac() ? "DYLD_LIBRARY_PATH" : "LD_LIBRARY_PATH");
            String string4 = OSPRuntime.isWindows() ? "bin" : "lib";
            String string5 = String.valueOf(xuggleHome) + File.separator + string4;
            if (new File(string5).exists()) {
                string2 = map.get(string3);
                if (string2 == null) {
                    string2 = "";
                }
                if (!string2.startsWith(string5)) {
                    string2 = String.valueOf(string5) + File.pathSeparator + string2;
                }
                map.put(string3, string2);
                TrackerStarter.logMessage("setting " + string3 + " = " + string2);
            }
        }
        if (relaunching) {
            map.put(TRACKER_RELAUNCH, "true");
        } else {
            map.remove(TRACKER_RELAUNCH);
        }
        String string6 = "";
        for (String string7 : arrayList) {
            string6 = String.valueOf(string6) + string7 + " ";
        }
        TrackerStarter.logMessage("executing command: " + string6);
        TrackerStarter.writeCodeBaseLog();
        startLogPath = TrackerStarter.writeUserLog();
        if (startLogPath != null) {
            map.put("START_LOG", startLogPath);
        }
        if (timer == null) {
            timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
            timer.setRepeats(false);
            timer.start();
        } else {
            timer.restart();
        }
        Process process = ((ProcessBuilder)object).start();
        int n = process.waitFor();
        if (n > 0) {
            string2 = "";
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                String string8 = bufferedReader.readLine();
                while (string8 != null && string8.length() > 0) {
                    string2 = String.valueOf(string2) + "\n      " + string8;
                    string8 = bufferedReader.readLine();
                }
                bufferedReader.close();
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                string8 = bufferedReader.readLine();
                while (string8 != null && string8.length() > 0) {
                    string2 = String.valueOf(string2) + "\n      " + string8;
                    string8 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            TrackerStarter.logMessage("failed to start with memory size " + memorySize + "MB due to the following errors:" + string2);
            if (string2.indexOf("heap") > -1) {
                if ((memorySize = (int)((double)memorySize * 0.95)) < 64) {
                    exceptions = String.valueOf(exceptions) + string2 + newline;
                    TrackerStarter.exitGracefully(string);
                }
                TrackerStarter.logMessage("try to start with smaller memory size " + memorySize + "MB");
                TrackerStarter.startTracker(string, stringArray);
            } else if (string2.indexOf("32-bit") > -1) {
                use32BitMode = false;
                TrackerStarter.logMessage("try to start in 64-bit mode");
                starterWarning = "The Java VM was started in 64-bit mode (32-bit not support).";
                TrackerStarter.startTracker(string, stringArray);
            } else {
                exceptions = String.valueOf(exceptions) + string2 + newline;
                TrackerStarter.exitGracefully(string);
            }
        } else {
            System.exit(0);
        }
    }

    private static String writeUserLog() {
        if ("".equals(logText) || trackerHome == null) {
            return null;
        }
        File file = null;
        if (new File(trackerHome).canWrite()) {
            file = new File(trackerHome, LOG_FILE_NAME);
        }
        if (userDocuments != null && new File(userDocuments).canWrite()) {
            file = new File(String.valueOf(userDocuments) + "/Tracker").canWrite() ? new File(String.valueOf(userDocuments) + "/Tracker", LOG_FILE_NAME) : new File(userDocuments, LOG_FILE_NAME);
        }
        if (file == null) {
            return null;
        }
        TrackerStarter.addLogHeader();
        TrackerStarter.logMessage("writing start log to " + file.getAbsolutePath());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Charset charset = Charset.forName(encoding);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, charset);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(logText);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return file.getAbsolutePath();
    }

    private static void addLogHeader() {
        if (!logText.startsWith("TrackerStarter")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss  MMM dd yyyy");
            Calendar calendar = Calendar.getInstance();
            logText = "TrackerStarter version 4.91  " + simpleDateFormat.format(calendar.getTime()) + newline + newline + logText;
        }
    }

    private static void writeCodeBaseLog() {
        if (codeBaseDir != null && codeBaseDir.canWrite()) {
            TrackerStarter.addLogHeader();
            File file = new File(codeBaseDir, LOG_FILE_NAME);
            TrackerStarter.logMessage("writing start log to " + file.getAbsolutePath());
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                Charset charset = Charset.forName(encoding);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, charset);
                BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                bufferedWriter.write(logText);
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean fileExists(String string) {
        File file = new File(string);
        try {
            if (file.exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            exceptions = String.valueOf(exceptions) + exception.getClass().getSimpleName() + ": " + exception.getMessage() + newline;
        }
        catch (Error error) {
            exceptions = String.valueOf(exceptions) + error.getClass().getSimpleName() + ": " + error.getMessage() + newline;
        }
        return false;
    }

    private static void logMessage(String string) {
        if (log) {
            logText = String.valueOf(logText) + " - " + string + newline;
        }
        if (debug) {
            System.out.println(string);
        }
    }

    @Deprecated
    private static void refreshVideoEngines() throws Exception {
        Object object;
        File file;
        String string;
        File file2;
        ExtensionsManager extensionsManager = ExtensionsManager.getManager();
        if (extensionsManager.copyXuggleJarsTo(file2 = new File(string = preferredVM != null ? preferredVM : javaHome, "lib/ext"))) {
            TrackerStarter.logMessage("copied xuggle jars to " + file2.getAbsolutePath());
        } else {
            file = new File(file2, "xuggle-xuggler.jar");
            if (file.exists()) {
                TrackerStarter.logMessage("xuggle jars found in " + file2.getAbsolutePath());
            } else {
                object = System.getenv("XUGGLE_HOME");
                if (object == null || !new File(String.valueOf(object) + "/share/java/jars/xuggle-xuggler.jar").exists()) {
                    String string2 = "xuggle jars not found";
                    string2 = object == null ? String.valueOf(string2) + ": XUGGLE_HOME is undefined" : String.valueOf(string2) + " in " + (String)object;
                    TrackerStarter.logMessage(string2);
                } else {
                    String string3 = new File(String.valueOf(object) + "/share/java/jars").getAbsolutePath();
                    TrackerStarter.logMessage("unable to copy xuggle jars from " + string3 + " to " + file2.getAbsolutePath());
                    xuggleWarning = "Some video engine files could not be copied automatically.";
                    xuggleWarning = String.valueOf(xuggleWarning) + "\nThe video engine may not work unless they are copied manually.";
                    xuggleWarning = String.valueOf(xuggleWarning) + "\n\nFiles to copy: ";
                    String[] stringArray = DiagnosticsForXuggle.getXuggleJarNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string4 = stringArray[n2];
                        xuggleWarning = String.valueOf(xuggleWarning) + string4 + ", ";
                        ++n2;
                    }
                    xuggleWarning = xuggleWarning.substring(0, xuggleWarning.lastIndexOf(", "));
                    xuggleWarning = String.valueOf(xuggleWarning) + "\nCopy from: " + string3;
                    xuggleWarning = String.valueOf(xuggleWarning) + "\nCopy to: " + file2;
                }
            }
        }
        if (extensionsManager.copyQTJavaTo(file2)) {
            TrackerStarter.logMessage("copied QTJava.zip to " + file2.getAbsolutePath());
        } else {
            file = new File(file2, "QTJava.zip");
            if (file.exists()) {
                TrackerStarter.logMessage("QTJava.zip found in " + file2.getAbsolutePath());
            } else {
                object = extensionsManager.getQTJavaZip();
                if (object == null) {
                    TrackerStarter.logMessage("QTJava.zip not found");
                } else {
                    if (System.getProperty("os.name", "").toLowerCase().contains("vista")) {
                        return;
                    }
                    TrackerStarter.logMessage("unable to copy " + ((File)object).getAbsolutePath() + " to " + file2.getAbsolutePath());
                    qtJavaWarning = "Some video engine files could not be copied automatically.";
                    qtJavaWarning = String.valueOf(qtJavaWarning) + "\nThe video engine may not work unless they are copied manually.";
                    qtJavaWarning = String.valueOf(qtJavaWarning) + "\n\nFiles to copy: QTJava.zip";
                    qtJavaWarning = String.valueOf(qtJavaWarning) + "\nCopy from: " + ((File)object).getParent();
                    qtJavaWarning = String.valueOf(qtJavaWarning) + "\nCopy to: " + file2;
                }
            }
        }
    }
}

