/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.cabrillo.tracker.ArrowFootprint;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.cabrillo.tracker.VectorStep;
import org.opensourcephysics.cabrillo.tracker.VectorSumInspector;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;

public class VectorSum
extends Vector {
    protected Vector[] vectors;
    protected ArrayList<String> vectorNames = new ArrayList();
    protected JMenuItem inspectorItem;
    protected Map<Integer, TPoint> tails = new HashMap<Integer, TPoint>();
    protected VectorSumInspector inspector;

    public VectorSum() {
        this(new Vector[0]);
    }

    public VectorSum(Vector[] vectorArray) {
        this.defaultColors = new Color[]{new Color(51, 204, 51)};
        this.setName(TrackerRes.getString("VectorSum.New.Name"));
        this.setFootprints(new Footprint[]{LineFootprint.getFootprint("Footprint.BoldArrow"), LineFootprint.getFootprint("Footprint.Arrow"), LineFootprint.getFootprint("Footprint.BigArrow")});
        this.defaultFootprint = this.getFootprint();
        Footprint[] footprintArray = this.getFootprints();
        int n = 0;
        while (n < footprintArray.length) {
            if (footprintArray[n] instanceof ArrowFootprint) {
                ArrowFootprint arrowFootprint = (ArrowFootprint)footprintArray[n];
                arrowFootprint.setDashArray(LineFootprint.DASHED_LINE);
            }
            ++n;
        }
        this.vectors = vectorArray;
        this.setColor(this.defaultColors[0]);
        n = 0;
        while (n < vectorArray.length) {
            vectorArray[n].addPropertyChangeListener(this);
            ++n;
        }
        this.locked = true;
        if (vectorArray.length == 0) {
            this.hint = TrackerRes.getString("VectorSum.Empty.Hint");
        }
        this.update();
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.vectorNames.isEmpty() && drawingPanel.getClass().equals(TrackerPanel.class)) {
            TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
            for (String string : this.vectorNames) {
                for (Vector vector : trackerPanel.getDrawables(Vector.class)) {
                    if (!vector.getName().equals(string)) continue;
                    this.addVector(vector);
                }
            }
            this.vectorNames.clear();
        }
        super.draw(drawingPanel, graphics);
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        Interactive interactive = super.findInteractive(drawingPanel, n, n2);
        this.hint = interactive instanceof VectorStep.Handle ? TrackerRes.getString("Vector.Handle.Hint") : (this.vectors.length == 0 ? TrackerRes.getString("CenterOfMass.Empty.Hint") : null);
        return interactive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVector(Vector vector) {
        Vector[] vectorArray = this.vectors;
        synchronized (this.vectors) {
            int n = 0;
            while (n < this.vectors.length) {
                if (this.vectors[n] == vector) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                ++n;
            }
            Vector[] vectorArray2 = new Vector[this.vectors.length + 1];
            System.arraycopy(this.vectors, 0, vectorArray2, 0, this.vectors.length);
            vectorArray2[this.vectors.length] = vector;
            this.vectors = vectorArray2;
            vector.addPropertyChangeListener(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.update();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVector(Vector vector) {
        Vector[] vectorArray = this.vectors;
        synchronized (this.vectors) {
            int n = 0;
            while (n < this.vectors.length) {
                if (this.vectors[n] == vector) {
                    vector.removePropertyChangeListener(this);
                    Vector[] vectorArray2 = new Vector[this.vectors.length - 1];
                    System.arraycopy(this.vectors, 0, vectorArray2, 0, n);
                    System.arraycopy(this.vectors, n + 1, vectorArray2, n, vectorArray2.length - n);
                    this.vectors = vectorArray2;
                    break;
                }
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.update();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector[] getVectors() {
        Vector[] vectorArray = this.vectors;
        synchronized (this.vectors) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (Vector[])this.vectors.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(Vector vector) {
        Vector[] vectorArray = this.vectors;
        synchronized (this.vectors) {
            int n = 0;
            while (true) {
                if (n >= this.vectors.length) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                if (this.vectors[n] == vector) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                ++n;
            }
        }
    }

    @Override
    public Step createStep(int n, double d, double d2, double d3, double d4) {
        if (this.isLocked()) {
            this.tails.put(new Integer(n), new TPoint(d, d2));
            this.update(n);
            return this.getStep(n);
        }
        return super.createStep(n, d, d2, d3, d4);
    }

    @Override
    public void setFontLevel(int n) {
        super.setFontLevel(n);
        if (this.inspector != null && this.inspector.isVisible()) {
            this.inspector.setVisible(true);
        }
    }

    @Override
    public void setLocked(boolean bl) {
    }

    @Override
    public boolean isStepComplete(int n) {
        return true;
    }

    @Override
    public boolean isDependent() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        TTrack tTrack;
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("track") && propertyChangeEvent.getNewValue() == null && (tTrack = (TTrack)propertyChangeEvent.getOldValue()) instanceof Vector) {
            this.removeVector((Vector)tTrack);
        }
        if (propertyChangeEvent.getSource() instanceof Vector) {
            if (string.equals("step")) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                this.update(n);
            }
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        if (this.inspector != null) {
            this.inspector.dispose();
        }
    }

    private void update() {
        int n = this.getSteps().length;
        int n2 = 0;
        while (n2 < n) {
            this.update(n2);
            ++n2;
        }
    }

    private void update(int n) {
        VectorStep vectorStep;
        if (this.vectors.length == 0) {
            this.locked = false;
            VectorStep vectorStep2 = (VectorStep)this.deleteStep(n);
            if (vectorStep2 != null) {
                vectorStep2.attach(null);
                this.repaint(vectorStep2);
            }
            this.locked = true;
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < this.vectors.length) {
            vectorStep = (VectorStep)this.vectors[n2].getStep(n);
            if (vectorStep == null) {
                if (this.getStep(n) != null) {
                    this.locked = false;
                    VectorStep vectorStep3 = (VectorStep)this.deleteStep(n);
                    this.tails.put(new Integer(n), vectorStep3.getTail());
                    vectorStep3.attach(null);
                    this.repaint(vectorStep3);
                    this.locked = true;
                }
                return;
            }
            d += vectorStep.getXComponent();
            d2 += vectorStep.getYComponent();
            ++n2;
        }
        VectorStep vectorStep4 = (VectorStep)this.getStep(n);
        if (vectorStep4 == null) {
            this.locked = false;
            vectorStep = null;
            Integer n3 = new Integer(n);
            TPoint tPoint = this.tails.get(n3);
            if (tPoint != null) {
                vectorStep = (VectorStep)this.createStep(n, tPoint.getX(), tPoint.getY(), d, d2);
                this.tails.remove(n3);
            } else {
                vectorStep = (VectorStep)this.createStep(n, 0.0, 0.0, d, d2);
                for (TrackerPanel trackerPanel : this.panels) {
                    vectorStep.attach(trackerPanel.getSnapPoint());
                }
            }
            vectorStep.setTipEnabled(false);
            vectorStep.setDefaultPointIndex(2);
            this.repaint(vectorStep);
            this.locked = true;
        } else {
            this.locked = false;
            vectorStep4.setXYComponents(d, d2);
            this.locked = true;
        }
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel) {
        this.inspectorItem = new JMenuItem(TrackerRes.getString("VectorSum.MenuItem.Inspector"));
        this.inspectorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VectorSumInspector vectorSumInspector = VectorSum.this.getInspector();
                vectorSumInspector.updateDisplay();
                vectorSumInspector.setVisible(true);
            }
        });
        JMenu jMenu = super.getMenu(trackerPanel);
        jMenu.remove(this.lockedItem);
        jMenu.remove(this.autoAdvanceItem);
        jMenu.remove(this.markByDefaultItem);
        jMenu.insert(this.inspectorItem, 0);
        if (jMenu.getItemCount() > 1) {
            jMenu.insertSeparator(1);
        }
        JMenuItem jMenuItem = this.inspectorItem;
        int n = jMenu.getItemCount();
        int n2 = 1;
        while (n2 < n) {
            JMenuItem jMenuItem2 = jMenu.getItem(n2);
            if (jMenuItem2 == null && jMenuItem == null) {
                jMenu.remove(n2 - 1);
                --n2;
                --n;
            }
            jMenuItem = jMenuItem2;
            ++n2;
        }
        return jMenu;
    }

    @Override
    public ArrayList<Component> getToolbarPointComponents(TrackerPanel trackerPanel, TPoint tPoint) {
        ArrayList<Component> arrayList = super.getToolbarPointComponents(trackerPanel, tPoint);
        this.xField.setEnabled(false);
        this.yField.setEnabled(false);
        return arrayList;
    }

    @Override
    public String toString() {
        return String.valueOf(TrackerRes.getString("VectorSum.Name")) + " \"" + this.name + "\"";
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public VectorSumInspector getInspector() {
        if (this.inspector == null) {
            this.inspector = new VectorSumInspector(this);
            this.inspector.setLocation(200, 200);
        }
        return this.inspector;
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            VectorSum vectorSum = (VectorSum)object;
            ArrayList<String> arrayList = new ArrayList<String>();
            Vector[] vectorArray = vectorSum.getVectors();
            int n = 0;
            while (n < vectorArray.length) {
                arrayList.add(vectorArray[n].getName());
                ++n;
            }
            xMLControl.setValue("vectors", arrayList);
            XML.getLoader(Vector.class).saveObject(xMLControl, object);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new VectorSum();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            VectorSum vectorSum = (VectorSum)object;
            XML.getLoader(Vector.class).loadObject(xMLControl, object);
            ArrayList arrayList = (ArrayList)ArrayList.class.cast(xMLControl.getObject("vectors"));
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                vectorSum.vectorNames.add(iterator.next().toString());
            }
            return object;
        }
    }
}

