/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.StepSet;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TTrackBar;
import org.opensourcephysics.cabrillo.tracker.TrackProperties;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;

public class Undo {
    private static Map<TrackerPanel, Undo> undomap = new HashMap<TrackerPanel, Undo>();
    protected UndoableEditSupport undoSupport;
    protected UndoManager undoManager = new UndoManager();

    private Undo() {
        this.undoManager.setLimit(20);
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
        XML.setLoader(TrackProperties.class, TrackProperties.getLoader());
    }

    public static boolean canUndo(TrackerPanel trackerPanel) {
        return Undo.getUndo((TrackerPanel)trackerPanel).undoManager.canUndo();
    }

    public static void undo(TrackerPanel trackerPanel) {
        Undo.getUndo((TrackerPanel)trackerPanel).undoManager.undo();
        Undo.refreshMenus(trackerPanel);
        trackerPanel.repaint();
    }

    public static boolean canRedo(TrackerPanel trackerPanel) {
        return Undo.getUndo((TrackerPanel)trackerPanel).undoManager.canRedo();
    }

    public static void redo(TrackerPanel trackerPanel) {
        Undo.getUndo((TrackerPanel)trackerPanel).undoManager.redo();
        Undo.refreshMenus(trackerPanel);
        trackerPanel.repaint();
    }

    protected static void postTrackDelete(TTrack tTrack) {
        TrackerPanel trackerPanel = tTrack.trackerPanel;
        if (trackerPanel == null) {
            return;
        }
        Undo undo = Undo.getUndo(trackerPanel);
        undo.getClass();
        TrackDelete trackDelete = undo.new TrackDelete(trackerPanel, tTrack);
        Undo.getUndo((TrackerPanel)trackerPanel).undoSupport.postEdit(trackDelete);
        Undo.refreshMenus(trackerPanel);
    }

    protected static void postTrackClear(TrackerPanel trackerPanel, List<String> list) {
        Undo undo = Undo.getUndo(trackerPanel);
        undo.getClass();
        TrackClear trackClear = undo.new TrackClear(trackerPanel, list);
        Undo.getUndo((TrackerPanel)trackerPanel).undoSupport.postEdit(trackClear);
        Undo.refreshMenus(trackerPanel);
    }

    protected static void postTrackEdit(TTrack tTrack, XMLControl xMLControl) {
        TrackerPanel trackerPanel = tTrack.trackerPanel;
        if (trackerPanel == null) {
            return;
        }
        Undo undo = Undo.getUndo(trackerPanel);
        undo.getClass();
        TrackEdit trackEdit = undo.new TrackEdit(tTrack, xMLControl);
        Undo.getUndo((TrackerPanel)trackerPanel).undoSupport.postEdit(trackEdit);
        Undo.refreshMenus(trackerPanel);
    }

    protected static void postMultiTrackEdit(ArrayList<Object[]> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        TTrack tTrack = (TTrack)arrayList.get(0)[0];
        TrackerPanel trackerPanel = tTrack.trackerPanel;
        if (trackerPanel == null) {
            return;
        }
        AbstractUndoableEdit abstractUndoableEdit = null;
        for (Object[] objectArray : arrayList) {
            tTrack = (TTrack)objectArray[0];
            XMLControl xMLControl = (XMLControl)objectArray[1];
            if (abstractUndoableEdit == null) {
                Undo undo = Undo.getUndo(trackerPanel);
                undo.getClass();
                abstractUndoableEdit = undo.new TrackEdit(tTrack, xMLControl);
                continue;
            }
            Undo undo = Undo.getUndo(trackerPanel);
            undo.getClass();
            TrackEdit trackEdit = undo.new TrackEdit(tTrack, xMLControl);
            Undo undo2 = Undo.getUndo(trackerPanel);
            undo2.getClass();
            abstractUndoableEdit = undo2.new CompoundEdit(trackEdit, abstractUndoableEdit);
        }
        Undo.getUndo((TrackerPanel)trackerPanel).undoSupport.postEdit(abstractUndoableEdit);
        Undo.refreshMenus(trackerPanel);
    }

    protected static void postStepEdit(Step step, XMLControl xMLControl) {
        TrackerPanel trackerPanel = step.getTrack().trackerPanel;
        if (trackerPanel == null) {
            return;
        }
        Undo undo = Undo.getUndo(trackerPanel);
        undo.getClass();
        StepEdit stepEdit = undo.new StepEdit(step, xMLControl);
        Undo.getUndo((TrackerPanel)trackerPanel).undoSupport.postEdit(stepEdit);
        Undo.refreshMenus(trackerPanel);
    }

    protected static void postStepSetEdit(StepSet stepSet, XMLControl xMLControl) {
        TrackerPanel trackerPanel = stepSet.trackerPanel;
        Undo undo = Undo.getUndo(trackerPanel);
        undo.getClass();
        StepSetEdit stepSetEdit = undo.new StepSetEdit(stepSet, xMLControl);
        Undo.getUndo((TrackerPanel)trackerPanel).undoSupport.postEdit(stepSetEdit);
        stepSet.setChanged(false);
        Undo.refreshMenus(trackerPanel);
    }

    protected static void postCoordsEdit(TrackerPanel trackerPanel, XMLControl xMLControl) {
        Undo undo = Undo.getUndo(trackerPanel);
        undo.getClass();
        CoordsEdit coordsEdit = undo.new CoordsEdit(trackerPanel, xMLControl);
        Undo.getUndo((TrackerPanel)trackerPanel).undoSupport.postEdit(coordsEdit);
        Undo.refreshMenus(trackerPanel);
    }

    protected static void postTrackAndCoordsEdit(TTrack tTrack, XMLControl xMLControl, XMLControl xMLControl2) {
        TrackerPanel trackerPanel = tTrack.trackerPanel;
        if (trackerPanel == null) {
            return;
        }
        Undo undo = Undo.getUndo(trackerPanel);
        undo.getClass();
        CoordsEdit coordsEdit = undo.new CoordsEdit(trackerPanel, xMLControl2);
        Undo undo2 = Undo.getUndo(trackerPanel);
        undo2.getClass();
        TrackEdit trackEdit = undo2.new TrackEdit(tTrack, xMLControl);
        Undo undo3 = Undo.getUndo(trackerPanel);
        undo3.getClass();
        CompoundEdit compoundEdit = undo3.new CompoundEdit(coordsEdit, trackEdit);
        Undo.getUndo((TrackerPanel)trackerPanel).undoSupport.postEdit(compoundEdit);
        Undo.refreshMenus(trackerPanel);
    }

    protected static void postImageVideoEdit(TrackerPanel trackerPanel, String[] stringArray, int n, int n2, boolean bl) {
        Undo undo = Undo.getUndo(trackerPanel);
        undo.getClass();
        ImageVideoEdit imageVideoEdit = undo.new ImageVideoEdit(trackerPanel, stringArray, n, n2, bl);
        Undo.getUndo((TrackerPanel)trackerPanel).undoSupport.postEdit(imageVideoEdit);
        Undo.refreshMenus(trackerPanel);
    }

    protected static void postVideoReplace(TrackerPanel trackerPanel, XMLControl xMLControl) {
        Undo undo = Undo.getUndo(trackerPanel);
        undo.getClass();
        VideoReplace videoReplace = undo.new VideoReplace(trackerPanel, xMLControl);
        Undo.getUndo((TrackerPanel)trackerPanel).undoSupport.postEdit(videoReplace);
        Undo.refreshMenus(trackerPanel);
    }

    protected static void postFilterDelete(TrackerPanel trackerPanel, Filter filter) {
        Undo undo = Undo.getUndo(trackerPanel);
        undo.getClass();
        FilterDelete filterDelete = undo.new FilterDelete(trackerPanel, filter);
        Undo.getUndo((TrackerPanel)trackerPanel).undoSupport.postEdit(filterDelete);
        Undo.refreshMenus(trackerPanel);
    }

    protected static void postFilterEdit(TrackerPanel trackerPanel, Filter filter, XMLControl xMLControl) {
        Undo undo = Undo.getUndo(trackerPanel);
        undo.getClass();
        FilterEdit filterEdit = undo.new FilterEdit(trackerPanel, filter, xMLControl);
        Undo.getUndo((TrackerPanel)trackerPanel).undoSupport.postEdit(filterEdit);
        Undo.refreshMenus(trackerPanel);
    }

    protected static void postFilterClear(TrackerPanel trackerPanel, List<String> list) {
        Undo undo = Undo.getUndo(trackerPanel);
        undo.getClass();
        FilterClear filterClear = undo.new FilterClear(trackerPanel, list);
        Undo.getUndo((TrackerPanel)trackerPanel).undoSupport.postEdit(filterClear);
        Undo.refreshMenus(trackerPanel);
    }

    protected static void postTrackDisplayEdit(TTrack tTrack, XMLControl xMLControl) {
        TrackerPanel trackerPanel = tTrack.trackerPanel;
        if (trackerPanel == null) {
            return;
        }
        Undo undo = Undo.getUndo(trackerPanel);
        undo.getClass();
        TrackDisplayEdit trackDisplayEdit = undo.new TrackDisplayEdit(tTrack, xMLControl);
        Undo.getUndo((TrackerPanel)trackerPanel).undoSupport.postEdit(trackDisplayEdit);
        Undo.refreshMenus(trackerPanel);
    }

    private static Undo getUndo(TrackerPanel trackerPanel) {
        Undo undo = undomap.get(trackerPanel);
        if (undo == null) {
            undo = new Undo();
            undomap.put(trackerPanel, undo);
        }
        return undo;
    }

    private static void refreshMenus(TrackerPanel trackerPanel) {
        TMenuBar tMenuBar = TMenuBar.getMenuBar(trackerPanel);
        if (tMenuBar != null) {
            tMenuBar.refresh();
        }
    }

    protected class CompoundEdit
    extends AbstractUndoableEdit {
        UndoableEdit editA;
        UndoableEdit editB;

        protected CompoundEdit(UndoableEdit undoableEdit, UndoableEdit undoableEdit2) {
            this.editA = undoableEdit;
            this.editB = undoableEdit2;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.editA.undo();
            this.editB.undo();
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            this.editA.redo();
            this.editB.redo();
        }
    }

    protected class CoordsEdit
    extends TEdit {
        private CoordsEdit(TrackerPanel trackerPanel, XMLControl xMLControl) {
            super(trackerPanel, trackerPanel.getCoords(), xMLControl);
        }

        @Override
        protected void load(String string) {
            XMLControlElement xMLControlElement = new XMLControlElement(string);
            ImageCoordSystem imageCoordSystem = this.panel.getCoords();
            xMLControlElement.loadObject(imageCoordSystem);
        }
    }

    protected class FilterClear
    extends AbstractUndoableEdit {
        List<String> xml;
        TrackerPanel panel;

        private FilterClear(TrackerPanel trackerPanel, List<String> list) {
            this.xml = list;
            this.panel = trackerPanel;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            Video video = this.panel.getVideo();
            if (video != null) {
                Iterator<String> iterator = this.xml.iterator();
                while (iterator.hasNext()) {
                    XMLControlElement xMLControlElement = new XMLControlElement(iterator.next());
                    Filter filter = (Filter)xMLControlElement.loadObject(null);
                    video.getFilterStack().addFilter(filter);
                }
            }
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            Video video = this.panel.getVideo();
            if (video != null) {
                video.getFilterStack().clear();
            }
        }
    }

    protected class FilterDelete
    extends AbstractUndoableEdit {
        String xml;
        TrackerPanel panel;
        int i;
        Filter filter;

        private FilterDelete(TrackerPanel trackerPanel, Filter filter) {
            this.xml = new XMLControlElement(filter).toXML();
            this.panel = trackerPanel;
            this.i = this.panel.getVideo().getFilterStack().lastIndexRemoved();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            Video video = this.panel.getVideo();
            if (video != null) {
                XMLControlElement xMLControlElement = new XMLControlElement(this.xml);
                this.filter = (Filter)xMLControlElement.loadObject(null);
                video.getFilterStack().insertFilter(this.filter, this.i);
            }
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            Video video = this.panel.getVideo();
            if (video != null) {
                video.getFilterStack().removeFilter(this.filter);
                this.i = video.getFilterStack().lastIndexRemoved();
            }
        }
    }

    protected class FilterEdit
    extends TEdit {
        int filterIndex;
        int frameNumber;

        private FilterEdit(TrackerPanel trackerPanel, Filter filter, XMLControl xMLControl) {
            super(trackerPanel, filter, xMLControl);
            this.filterIndex = trackerPanel.getVideo().getFilterStack().getFilters().indexOf(filter);
            this.frameNumber = trackerPanel.getFrameNumber();
        }

        @Override
        protected void load(String string) {
            XMLControlElement xMLControlElement = new XMLControlElement(string);
            Video video = this.panel.getVideo();
            if (video != null) {
                ArrayList<Filter> arrayList = video.getFilterStack().getFilters();
                if (this.filterIndex >= arrayList.size()) {
                    return;
                }
                Filter filter = arrayList.get(this.filterIndex);
                xMLControlElement.loadObject(filter);
                VideoClip videoClip = this.panel.getPlayer().getVideoClip();
                this.panel.getPlayer().setStepNumber(videoClip.frameToStep(this.frameNumber));
            }
        }
    }

    protected class ImageVideoEdit
    extends AbstractUndoableEdit {
        String[] paths;
        TrackerPanel panel;
        int n;
        int step;
        boolean added;

        private ImageVideoEdit(TrackerPanel trackerPanel, String[] stringArray, int n, int n2, boolean bl) {
            this.panel = trackerPanel;
            this.paths = stringArray;
            this.n = n;
            this.step = n2;
            this.added = bl;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (this.added) {
                this.removeImages();
            } else {
                this.addImages();
            }
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            if (this.added) {
                this.addImages();
            } else {
                this.removeImages();
            }
        }

        private void addImages() {
            if (this.paths == null || this.paths.length == 0) {
                return;
            }
            try {
                int n = this.n;
                int n2 = 0;
                while (n2 < this.paths.length) {
                    String string = this.paths[n2];
                    if (string != null) {
                        ImageVideo imageVideo = (ImageVideo)this.panel.getVideo();
                        imageVideo.insert(string, n, false);
                        VideoClip videoClip = this.panel.getPlayer().getVideoClip();
                        videoClip.setStepCount(imageVideo.getFrameCount());
                        int n3 = this.panel.getPlayer().getVideoClip().frameToStep(n++);
                        this.panel.getPlayer().setStepNumber(n3);
                    }
                    ++n2;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private void removeImages() {
            if (this.panel.getVideo() instanceof ImageVideo) {
                ImageVideo imageVideo = (ImageVideo)this.panel.getVideo();
                int n = 0;
                while (n < this.paths.length) {
                    imageVideo.remove(this.n);
                    ++n;
                }
                n = imageVideo.getFrameCount();
                VideoClip videoClip = this.panel.getPlayer().getVideoClip();
                videoClip.setStepCount(n);
                this.panel.getPlayer().setStepNumber(this.step);
            }
        }
    }

    protected class StepEdit
    extends TEdit {
        Step step;

        private StepEdit(Step step, XMLControl xMLControl) {
            super(step.getTrack().trackerPanel, step, xMLControl);
            this.step = step;
        }

        @Override
        protected void load(String string) {
            XMLControlElement xMLControlElement = new XMLControlElement(string);
            xMLControlElement.loadObject(this.step);
            this.step.erase();
            TTrackBar.getTrackbar(this.panel).refresh();
        }
    }

    protected class StepSetEdit
    extends TEdit {
        private StepSetEdit(StepSet stepSet, XMLControl xMLControl) {
            super(stepSet.trackerPanel, stepSet, xMLControl);
        }

        @Override
        protected void load(String string) {
            XMLControlElement xMLControlElement = new XMLControlElement(string);
            StepSet stepSet = new StepSet(this.panel);
            xMLControlElement.loadObject(stepSet);
        }
    }

    protected abstract class TEdit
    extends AbstractUndoableEdit {
        String undo;
        String redo;
        TrackerPanel panel;

        protected TEdit(TrackerPanel trackerPanel, Object object, XMLControl xMLControl) {
            this.panel = trackerPanel;
            this.undo = xMLControl.toXML();
            xMLControl.saveObject(object);
            this.redo = xMLControl.toXML();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.load(this.undo);
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            this.load(this.redo);
        }

        abstract void load(String var1);
    }

    protected class TrackClear
    extends AbstractUndoableEdit {
        List<String> xml;
        TrackerPanel panel;

        private TrackClear(TrackerPanel trackerPanel, List<String> list) {
            this.xml = list;
            this.panel = trackerPanel;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            Iterator<String> iterator = this.xml.iterator();
            while (iterator.hasNext()) {
                XMLControlElement xMLControlElement = new XMLControlElement(iterator.next());
                TTrack tTrack = (TTrack)xMLControlElement.loadObject(null);
                this.panel.addTrack(tTrack);
            }
            this.panel.requestFocus();
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            this.panel.clearTracks();
        }
    }

    protected class TrackDelete
    extends AbstractUndoableEdit {
        String xml;
        TTrack track;
        TrackerPanel panel;

        private TrackDelete(TrackerPanel trackerPanel, TTrack tTrack) {
            XMLControlElement xMLControlElement = new XMLControlElement(tTrack);
            this.xml = xMLControlElement.toXML();
            this.panel = trackerPanel;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            XMLControlElement xMLControlElement = new XMLControlElement(this.xml);
            this.track = (TTrack)xMLControlElement.loadObject(null);
            this.panel.addTrack(this.track);
            this.panel.requestFocus();
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            this.panel.removeTrack(this.track);
            this.track = null;
        }
    }

    protected class TrackDisplayEdit
    extends TEdit {
        String undoName;
        String redoName;
        String trackName;

        private TrackDisplayEdit(TTrack tTrack, XMLControl xMLControl) {
            super(tTrack.trackerPanel, new TrackProperties(tTrack), xMLControl);
            xMLControl = new XMLControlElement(this.undo);
            TrackProperties trackProperties = (TrackProperties)xMLControl.loadObject(null);
            this.undoName = tTrack.getName();
            this.redoName = trackProperties.name;
        }

        @Override
        public void undo() throws CannotUndoException {
            this.trackName = this.undoName;
            super.undo();
        }

        @Override
        public void redo() throws CannotUndoException {
            this.trackName = this.redoName;
            super.redo();
        }

        @Override
        protected void load(String string) {
            XMLControlElement xMLControlElement = new XMLControlElement(string);
            TrackProperties trackProperties = (TrackProperties)xMLControlElement.loadObject(null);
            TTrack tTrack = this.panel.getTrack(this.trackName);
            tTrack.setFootprint(trackProperties.footprint);
            tTrack.setColor(trackProperties.color);
            tTrack.setName(trackProperties.name);
        }
    }

    protected class TrackEdit
    extends TEdit {
        String trackName;

        private TrackEdit(TTrack tTrack, XMLControl xMLControl) {
            super(tTrack.trackerPanel, tTrack, xMLControl);
            this.trackName = tTrack.getName();
        }

        @Override
        protected void load(String string) {
            XMLControlElement xMLControlElement = new XMLControlElement(string);
            TTrack tTrack = this.panel.getTrack(this.trackName);
            xMLControlElement.loadObject(tTrack);
            tTrack.erase();
            tTrack.firePropertyChange("steps", null, null);
            tTrack.firePropertyChange("text_column", null, null);
        }
    }

    protected class VideoReplace
    extends TEdit {
        private VideoReplace(TrackerPanel trackerPanel, XMLControl xMLControl) {
            super(trackerPanel, trackerPanel.getPlayer().getVideoClip(), xMLControl);
        }

        @Override
        public void undo() throws CannotUndoException {
            Video video = this.panel.getVideo();
            if (video instanceof ImageVideo) {
                ((ImageVideo)video).saveInvalidImages();
            }
            this.redo = new XMLControlElement(this.panel.getPlayer().getVideoClip()).toXML();
            super.undo();
            this.load(this.undo);
        }

        @Override
        public void redo() throws CannotUndoException {
            Video video = this.panel.getVideo();
            if (video instanceof ImageVideo) {
                ((ImageVideo)video).saveInvalidImages();
            }
            this.undo = new XMLControlElement(this.panel.getPlayer().getVideoClip()).toXML();
            super.redo();
            this.load(this.redo);
        }

        @Override
        protected void load(String string) {
            XMLControlElement xMLControlElement = new XMLControlElement(string);
            VideoClip videoClip = (VideoClip)xMLControlElement.loadObject(null);
            this.panel.getPlayer().setVideoClip(videoClip);
        }
    }
}

