/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.cabrillo.tracker.Configuration;
import org.opensourcephysics.cabrillo.tracker.DataTrackTool;
import org.opensourcephysics.cabrillo.tracker.ExportZipDialog;
import org.opensourcephysics.cabrillo.tracker.PrefsDialog;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrackBar;
import org.opensourcephysics.cabrillo.tracker.TrackDataBuilder;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.deploy.TrackerStarter;
import org.opensourcephysics.controls.ConsoleLevel;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.Diagnostics;
import org.opensourcephysics.tools.DiagnosticsForThreads;
import org.opensourcephysics.tools.DiagnosticsForXuggle;
import org.opensourcephysics.tools.ExtensionsManager;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class Tracker {
    public static final String VERSION = "4.91";
    public static final ImageIcon TRACKER_ICON;
    public static final ImageIcon TRACKER_ICON_256;
    static final String THETA;
    static final String OMEGA;
    static final String ALPHA;
    static final String DEGREES = "\u00ba";
    static final Level DEFAULT_LOG_LEVEL;
    static boolean timeLogEnabled;
    static boolean testOn;
    static String trackerHome;
    static String[] fullConfig;
    static Set<String> defaultConfig;
    static boolean xuggleCopied;
    static String[] mainArgs;
    static JFrame splash;
    static Icon trackerLogoIcon;
    static Icon ospLogoIcon;
    static JLabel tipOfTheDayLabel;
    static JProgressBar progressBar;
    static String counterPath;
    static String newerVersion;
    static String copyright;
    static String trackerWebsite;
    static String author;
    static String osp;
    static AbstractAction aboutQTAction;
    static AbstractAction aboutXuggleAction;
    static AbstractAction aboutThreadsAction;
    static Action aboutTrackerAction;
    static Action readmeAction;
    static Action aboutJavaAction;
    static Action startLogAction;
    static Action trackerPrefsAction;
    private static Tracker tracker;
    static String readmeFileName;
    static JDialog readmeDialog;
    static JDialog startLogDialog;
    static JDialog trackerPrefsDialog;
    static JTextArea trackerPrefsTextArea;
    static String prefsPath;
    public static String rootXMLPath;
    static Cursor zoomInCursor;
    static Cursor zoomOutCursor;
    static Cursor grabCursor;
    static Cursor grabbedCursor;
    static boolean showHints;
    static boolean startupHintShown;
    static String pdfHelpPath;
    static JButton pdfHelpButton;
    static ArrayList<String> recentFiles;
    static int minimumMemorySize;
    static int requestedMemorySize;
    static int originalMemoryRequest;
    static long lastMillisChecked;
    static boolean is64BitVM;
    protected static Locale[] locales;
    static Locale defaultLocale;
    static ArrayList<String> checkForUpgradeChoices;
    static Map<String, Integer> checkForUpgradeIntervals;
    static Collection<String> dataFunctionControlStrings;
    static Collection<String> initialAutoloadSearchPaths;
    static Map<String, ArrayList<XMLControl>> dataFunctionControls;
    static FileFilter xmlFilter;
    static boolean qtLoading;
    static boolean qtLoaded;
    static Registry registry;
    static DataTrackTool dataTrackTool;
    static boolean toolRegistered;
    static boolean toolNotFound;
    static Level preferredLogLevel;
    static boolean showHintsByDefault;
    static int recentFilesSize;
    static int preferredMemorySize;
    static String lookAndFeel;
    static String preferredLocale;
    static String preferredJRE;
    static String preferredJRE32;
    static String preferredJRE64;
    static String preferredTrackerJar;
    static int checkForUpgradeInterval;
    static int preferredFontLevel;
    static int preferredFontLevelPlus;
    static boolean isRadians;
    static boolean isXuggleFast;
    static boolean engineKnown;
    static boolean warnXuggleError;
    static boolean warnNoVideoEngine;
    static boolean use32BitMode;
    static boolean warnVariableDuration;
    static String[] prelaunchExecutables;
    static Map<String, String[]> autoloadMap;
    static String[] preferredAutoloadSearchPaths;
    private TFrame frame;

    static {
        Object object;
        XML.setLoader(Preferences.class, new Preferences.Loader());
        TRACKER_ICON = new ImageIcon(Tracker.class.getResource("resources/images/tracker_icon_32.png"));
        TRACKER_ICON_256 = new ImageIcon(Tracker.class.getResource("resources/images/tracker_icon_256.png"));
        THETA = TeXParser.parseTeX("$\\theta");
        OMEGA = TeXParser.parseTeX("$\\omega");
        ALPHA = TeXParser.parseTeX("$\\alpha");
        DEFAULT_LOG_LEVEL = ConsoleLevel.OUT_CONSOLE;
        timeLogEnabled = false;
        testOn = false;
        fullConfig = new String[]{"file.new", "file.open", "file.close", "file.import", "file.export", "file.save", "file.saveAs", "file.print", "file.library", "edit.copyObject", "edit.copyData", "edit.copyImage", "edit.paste", "edit.matSize", "edit.clear", "edit.undoRedo", "video.import", "video.close", "video.visible", "video.filters", "pageView.edit", "notes.edit", "new.pointMass", "new.cm", "new.vector", "new.vectorSum", "new.lineProfile", "new.RGBRegion", "new.analyticParticle", "new.clone", "new.circleFitter", "new.dynamicParticle", "new.dynamicTwoBody", "new.dataTrack", "new.tapeMeasure", "new.protractor", "calibration.stick", "calibration.tape", "calibration.points", "calibration.offsetOrigin", "track.name", "track.description", "track.color", "track.footprint", "track.visible", "track.locked", "track.delete", "track.autoAdvance", "track.markByDefault", "track.autotrack", "coords.locked", "coords.origin", "coords.angle", "data.algorithm", "coords.scale", "coords.refFrame", "button.x", "button.v", "button.a", "button.trails", "button.labels", "button.stretch", "button.clipSettings", "button.xMass", "button.axes", "button.path", "config.saveWithData", "data.builder", "data.tool"};
        counterPath = "http://physlets.org/tracker/counter/counter.php?";
        copyright = "Copyright (c) 2016 Douglas Brown";
        trackerWebsite = "physlets.org/tracker";
        author = "Douglas Brown";
        osp = "Open Source Physics";
        readmeFileName = "tracker_README.txt";
        rootXMLPath = "";
        showHints = true;
        pdfHelpPath = "/tracker_help.pdf";
        recentFiles = new ArrayList();
        minimumMemorySize = 32;
        requestedMemorySize = -1;
        originalMemoryRequest = 0;
        dataFunctionControlStrings = new HashSet<String>();
        initialAutoloadSearchPaths = new TreeSet<String>();
        dataFunctionControls = new TreeMap<String, ArrayList<XMLControl>>();
        preferredLogLevel = DEFAULT_LOG_LEVEL;
        showHintsByDefault = true;
        recentFilesSize = 6;
        preferredMemorySize = -1;
        checkForUpgradeInterval = 0;
        preferredFontLevel = 0;
        preferredFontLevelPlus = 0;
        engineKnown = true;
        warnXuggleError = true;
        warnNoVideoEngine = true;
        use32BitMode = false;
        warnVariableDuration = true;
        prelaunchExecutables = new String[0];
        autoloadMap = new TreeMap<String, String[]>();
        defaultLocale = Locale.getDefault();
        trackerHome = System.getenv("TRACKER_HOME");
        if (trackerHome == null) {
            try {
                trackerHome = TrackerStarter.findTrackerHome(false);
            }
            catch (Exception exception) {}
        }
        String string = "/org/opensourcephysics/cabrillo/tracker/resources/images/tracker_logo.png";
        trackerLogoIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/cabrillo/tracker/resources/images/osp_logo_url.png";
        ospLogoIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/cabrillo/tracker/resources/images/grab.gif";
        Image image = ResourceLoader.getImage(string);
        grabCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(14, 10), "Grab");
        string = "/org/opensourcephysics/cabrillo/tracker/resources/images/grabbing.gif";
        image = ResourceLoader.getImage(string);
        grabbedCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(12, 8), "Grabbed");
        locales = new Locale[]{Locale.ENGLISH, new Locale("ar"), new Locale("cs"), new Locale("in"), new Locale("da"), Locale.GERMAN, new Locale("el", "GR"), new Locale("es"), new Locale("fi"), Locale.FRENCH, new Locale("iw", "IL"), Locale.ITALIAN, new Locale("ko"), new Locale("pt", "PT"), new Locale("pt", "BR"), new Locale("sk"), new Locale("sl"), new Locale("sv"), Locale.TAIWAN, Locale.CHINA};
        Tracker.setDefaultConfig(Tracker.getFullConfig());
        Tracker.loadPreferences();
        Timer timer = new Timer(10000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Tracker.loadCurrentVersion(false, true);
                    }
                };
                Thread thread = new Thread(runnable);
                thread.setPriority(5);
                thread.setDaemon(true);
                thread.start();
            }
        });
        timer.setRepeats(false);
        timer.start();
        xmlFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null || file.isDirectory()) {
                    return false;
                }
                String string = XML.getExtension(file.getName());
                return string != null && "xml".equals(string.toLowerCase());
            }
        };
        Tracker.autoloadDataFunctions();
        checkForUpgradeChoices = new ArrayList();
        checkForUpgradeIntervals = new HashMap<String, Integer>();
        String string2 = "PrefsDialog.Upgrades.Always";
        checkForUpgradeChoices.add(string2);
        checkForUpgradeIntervals.put(string2, 0);
        string2 = "PrefsDialog.Upgrades.Weekly";
        checkForUpgradeChoices.add(string2);
        checkForUpgradeIntervals.put(string2, 7);
        string2 = "PrefsDialog.Upgrades.Monthly";
        checkForUpgradeChoices.add(string2);
        checkForUpgradeIntervals.put(string2, 30);
        string2 = "PrefsDialog.Upgrades.Never";
        checkForUpgradeChoices.add(string2);
        checkForUpgradeIntervals.put(string2, 10000);
        Color color = new Color(153, 0, 0);
        Color color2 = new Color(51, 51, 102);
        Color color3 = new Color(116, 147, 179);
        Color color4 = new Color(83, 105, 128);
        Color color5 = new Color(169, 193, 217);
        Color color6 = new Color(250, 250, 230);
        splash = new JFrame("Tracker");
        splash.setIconImage(TRACKER_ICON.getImage());
        splash.setUndecorated(true);
        splash.setAlwaysOnTop(true);
        splash.setResizable(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(color6);
        jPanel.setBorder(BorderFactory.createBevelBorder(0, color3, color4));
        splash.setContentPane(jPanel);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            Point mouseLoc;
            Point splashLoc;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.splashLoc = splash.getLocation();
                this.mouseLoc = mouseEvent.getPoint();
                this.mouseLoc.x += this.splashLoc.x;
                this.mouseLoc.y += this.splashLoc.y;
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                Point point = splash.getLocation();
                point.x += mouseEvent.getPoint().x;
                point.y += mouseEvent.getPoint().y;
                splash.setLocation(this.splashLoc.x + point.x - this.mouseLoc.x, this.splashLoc.y + point.y - this.mouseLoc.y);
            }
        };
        jPanel.addMouseListener(mouseInputAdapter);
        jPanel.addMouseMotionListener(mouseInputAdapter);
        JLabel jLabel = new JLabel(trackerLogoIcon);
        jLabel.setBorder(BorderFactory.createEmptyBorder(12, 24, 4, 24));
        jPanel.add((Component)jLabel, "North");
        String string3 = TrackerRes.getString("Tracker.Splash.HelpMessage");
        string3 = String.valueOf(string3) + " " + TrackerRes.getString("TMenuBar.Menu.Help");
        string3 = String.valueOf(string3) + "|" + TrackerRes.getString("TMenuBar.MenuItem.GettingStarted");
        tipOfTheDayLabel = new JLabel(string3);
        tipOfTheDayLabel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
        Font font = tipOfTheDayLabel.getFont().deriveFont(0).deriveFont(14.0f);
        tipOfTheDayLabel.setFont(font);
        tipOfTheDayLabel.setForeground(color);
        tipOfTheDayLabel.setAlignmentX(0.5f);
        progressBar = new JProgressBar(0, 100);
        progressBar.setValue(0);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(12, 50, 16, 50));
        jPanel2.add((Component)progressBar, "Center");
        jPanel2.setOpaque(false);
        Box box = Box.createVerticalBox();
        box.add(tipOfTheDayLabel);
        box.add(jPanel2);
        jPanel.add((Component)box, "Center");
        String string4 = String.valueOf(author) + "   " + osp + "   Ver " + VERSION;
        if (VERSION.length() > 5 || testOn) {
            string4 = String.valueOf(string4) + " BETA";
        }
        JLabel jLabel2 = new JLabel(string4);
        jLabel2.setForeground(color2);
        font = font.deriveFont(1).deriveFont(10.0f);
        jLabel2.setFont(font);
        jLabel2.setHorizontalAlignment(0);
        jLabel2.setOpaque(false);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBackground(new Color(212, 230, 247));
        jPanel3.add((Component)jLabel2, "Center");
        jPanel3.setBorder(BorderFactory.createLineBorder(color5));
        jPanel.add((Component)jPanel3, "South");
        splash.pack();
        Dimension dimension = splash.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension2.width / 2;
        int n2 = 3 * dimension2.height / 5;
        splash.setLocation(n - dimension.width / 2, n2 - dimension.height / 2);
        String[] stringArray = VideoIO.VIDEO_EXTENSIONS;
        int n3 = VideoIO.VIDEO_EXTENSIONS.length;
        int n4 = 0;
        while (n4 < n3) {
            object = stringArray[n4];
            ResourceLoader.addExtractExtension((String)object);
            ++n4;
        }
        is64BitVM = OSPRuntime.getVMBitness() == 64;
        try {
            object = "org.opensourcephysics.media.xuggle.XuggleIO";
            Class<?> clazz = Class.forName((String)object);
            Method method = clazz.getMethod("registerWithVideoIO", null);
            method.invoke(null, null);
        }
        catch (Exception exception) {}
        if (!OSPRuntime.isLinux()) {
            object = new Runnable(){

                @Override
                public void run() {
                    try {
                        Object object;
                        qtLoading = true;
                        String string = "org.opensourcephysics.media.quicktime.QTVideoType";
                        Class<?> clazz = Class.forName(string);
                        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
                        Constructor<?> constructor = null;
                        Constructor<?> constructor2 = null;
                        int n = 0;
                        while (n < constructorArray.length) {
                            object = constructorArray[n].getGenericParameterTypes();
                            if (((Type[])object).length == 0) {
                                constructor = constructorArray[n];
                            } else if (((Type[])object).length == 1 && object[0].equals(VideoFileFilter.class)) {
                                constructor2 = constructorArray[n];
                            }
                            ++n;
                        }
                        if (constructor == null) {
                            throw new Exception("QuickTime not found");
                        }
                        VideoType videoType = (VideoType)constructor.newInstance(new Object[0]);
                        VideoIO.addVideoEngine(videoType);
                        if (constructor2 == null) {
                            qtLoaded = true;
                            return;
                        }
                        String[] stringArray = VideoIO.VIDEO_EXTENSIONS;
                        int n2 = VideoIO.VIDEO_EXTENSIONS.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            object = stringArray[n3];
                            VideoFileFilter videoFileFilter = new VideoFileFilter((String)object, new String[]{object});
                            videoType = (VideoType)constructor2.newInstance(videoFileFilter);
                            VideoIO.addVideoType(videoType);
                            ++n3;
                        }
                        qtLoaded = true;
                    }
                    catch (Exception exception) {
                        OSPLog.config("QuickTime exception: " + exception.toString());
                        qtLoading = false;
                    }
                    catch (Error error) {
                        OSPLog.config("QuickTime error: " + error.toString());
                        qtLoading = false;
                    }
                }
            };
            Thread thread = new Thread((Runnable)object);
            thread.setPriority(5);
            thread.setDaemon(true);
            thread.start();
        }
        VideoIO.setDefaultXMLExtension("trk");
        pdfHelpButton = new JButton(TrackerRes.getString("Tracker.Button.PDFHelp"));
        pdfHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = new URL("http://" + trackerWebsite + pdfHelpPath);
                    OSPDesktop.displayURL(uRL.toString());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        object = new Runnable(){

            @Override
            public void run() {
                ExtensionsManager.getManager().getAllJREs(32);
            }
        };
        new Thread((Runnable)object).start();
    }

    public static Tracker getTracker() {
        if (tracker == null) {
            OSPLog.fine("creating shared Tracker");
            tracker = new Tracker(null, false, false);
        }
        return tracker;
    }

    public Tracker() {
        this(null, true, true);
    }

    public Tracker(Video video) {
        this.createFrame();
        TrackerPanel trackerPanel = new TrackerPanel(video);
        this.frame.addTab(trackerPanel);
    }

    private Tracker(String[] stringArray, boolean bl, boolean bl2) {
        splash.setVisible(bl2);
        this.createFrame();
        Tracker.setProgress(5);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    String string = XML.getName(stringArray[n]);
                    Tracker.splash(String.valueOf(TrackerRes.getString("Tracker.Splash.Loading")) + " \"" + string + "\"");
                    if ((stringArray[n].endsWith(".trk") || stringArray[n].endsWith(".trz")) && stringArray[n].indexOf("/") != -1 && rootXMLPath.equals("")) {
                        rootXMLPath = stringArray[n].substring(0, stringArray[n].lastIndexOf("/") + 1);
                        OSPLog.fine("Setting rootPath: " + rootXMLPath);
                    }
                    TrackerIO.open(stringArray[n], this.frame);
                }
                ++n;
            }
        } else if (bl) {
            TrackerPanel trackerPanel = new TrackerPanel();
            this.frame.addTab(trackerPanel);
            JSplitPane jSplitPane = this.frame.getSplitPane(trackerPanel, 0);
            jSplitPane.setDividerLocation(this.frame.defaultRightDivider);
            if (showHints) {
                startupHintShown = true;
                trackerPanel.setMessage(TrackerRes.getString("Tracker.Startup.Hint"));
            }
            Tracker.setProgress(100);
        }
    }

    public TFrame getFrame() {
        return this.frame;
    }

    private void createFrame() {
        Tracker.createActions();
        Tracker.setProgress(5);
        OSPRuntime.setLookAndFeel(true, lookAndFeel);
        this.frame = new TFrame();
        Diagnostics.setDialogOwner(this.frame);
        DiagnosticsForXuggle.setDialogOwner(this.frame);
        if (OSPRuntime.applet == null) {
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    Object object;
                    boolean bl;
                    Object object2;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    if (preferredAutoloadSearchPaths != null) {
                        object2 = preferredAutoloadSearchPaths;
                        bl = preferredAutoloadSearchPaths.length;
                        boolean bl2 = false;
                        while (bl2 < bl) {
                            object = object2[bl2];
                            arrayList.add(object);
                            bl2 += 1;
                        }
                    } else {
                        arrayList.addAll(Tracker.getDefaultAutoloadSearchPaths());
                    }
                    object = autoloadMap.keySet().iterator();
                    while (object.hasNext()) {
                        String string = object.next();
                        String string2 = XML.getDirectoryPath(string);
                        boolean bl3 = false;
                        for (String string3 : arrayList) {
                            boolean bl2 = bl3 = bl3 || string2.equals(string3);
                        }
                        if (bl3 && new File(string).exists()) continue;
                        object.remove();
                    }
                    Tracker.savePreferences();
                    if (((Tracker)Tracker.this).frame.libraryBrowser != null) {
                        boolean bl5;
                        boolean bl3 = bl5 = !((Tracker)Tracker.this).frame.libraryBrowser.exit();
                        if (bl5) {
                            final int n = Tracker.this.frame.getDefaultCloseOperation();
                            bl = Tracker.this.frame.wishesToExit();
                            Tracker.this.frame.setDefaultCloseOperation(0);
                            object2 = new Runnable(){

                                @Override
                                public void run() {
                                    if (bl) {
                                        Tracker.this.frame.setDefaultCloseOperation(3);
                                    }
                                    Tracker.this.frame.setDefaultCloseOperation(n);
                                }
                            };
                            EventQueue.invokeLater((Runnable)object2);
                            return;
                        }
                    }
                    int n = Tracker.this.frame.getTabCount() - 1;
                    while (n >= 0) {
                        try {
                            if (!Tracker.this.frame.getTrackerPanel(n).save()) {
                                final int n2 = Tracker.this.frame.getDefaultCloseOperation();
                                bl = Tracker.this.frame.wishesToExit();
                                Tracker.this.frame.setDefaultCloseOperation(0);
                                object2 = new Runnable(){

                                    @Override
                                    public void run() {
                                        if (bl) {
                                            Tracker.this.frame.setDefaultCloseOperation(3);
                                        }
                                        Tracker.this.frame.setDefaultCloseOperation(n2);
                                    }
                                };
                                EventQueue.invokeLater((Runnable)object2);
                                return;
                            }
                            Tracker.this.frame.removeTab(Tracker.this.frame.getTrackerPanel(n));
                        }
                        catch (Exception exception) {}
                        --n;
                    }
                    Tracker.this.frame.setVisible(false);
                    dataTrackTool.trackerExiting();
                    Tracker.unregisterRemoteTool(dataTrackTool);
                    if (Tracker.this.frame.wishesToExit() && Tracker.this.frame.getDefaultCloseOperation() == 2) {
                        System.exit(0);
                    }
                }
            });
        }
    }

    public static Image getOSXDockImage() {
        return TRACKER_ICON_256.getImage();
    }

    public static void showAboutTracker() {
        String string;
        String string2 = System.getProperty("line.separator", "\n");
        String string3 = VERSION;
        if (string3.length() > 5 || testOn) {
            string3 = String.valueOf(string3) + " BETA";
        }
        if ((string = OSPRuntime.getLaunchJarBuildDate()) != null) {
            string3 = String.valueOf(string3) + "   " + string;
        }
        String string4 = "Tracker " + string3 + string2 + copyright + string2 + trackerWebsite + string2 + string2 + TrackerRes.getString("Tracker.About.ProjectOf") + string2 + "Open Source Physics" + string2 + "www.opensourcephysics.org" + string2;
        String string5 = TrackerRes.getString("Tracker.About.Translator");
        if (!string5.equals("")) {
            string4 = String.valueOf(string4) + string2 + TrackerRes.getString("Tracker.About.TranslationBy") + " " + string5 + string2;
        }
        JOptionPane.showMessageDialog(null, string4, TrackerRes.getString("Tracker.Dialog.AboutTracker.Title"), 1);
    }

    public static Map<String, ArrayList<String[]>> findDataFunctions(String string) {
        TreeMap<String, ArrayList<String[]>> treeMap = new TreeMap<String, ArrayList<String[]>>();
        if (string == null) {
            return treeMap;
        }
        File file = new File(string);
        if (!file.exists()) {
            return treeMap;
        }
        File[] fileArray = file.listFiles(xmlFilter);
        if (fileArray != null) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz;
                File file2 = fileArray2[n2];
                XMLControlElement xMLControlElement = new XMLControlElement(file2.getPath());
                if (!xMLControlElement.failedToRead() && (clazz = xMLControlElement.getObjectClass()) != null && TrackDataBuilder.class.isAssignableFrom(clazz)) {
                    ArrayList<String[]> arrayList = new ArrayList<String[]>();
                    for (Object object : xMLControlElement.getPropertyContent()) {
                        XMLControl[] xMLControlArray;
                        if (!(object instanceof XMLProperty) || !((XMLProperty)object).getPropertyName().equals("functions")) continue;
                        XMLControl[] xMLControlArray2 = xMLControlArray = ((XMLProperty)object).getChildControls();
                        int n3 = xMLControlArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            XMLControl xMLControl = xMLControlArray2[n4];
                            String string2 = xMLControl.getString("description");
                            ArrayList arrayList2 = (ArrayList)xMLControl.getObject("functions");
                            if (string2 != null && arrayList2 != null && !arrayList2.isEmpty()) {
                                for (String[] stringArray : arrayList2) {
                                    String[] stringArray2 = new String[3];
                                    System.arraycopy(stringArray, 0, stringArray2, 0, 2);
                                    String string3 = XML.getExtension(string2);
                                    String string4 = TrackerRes.getString(String.valueOf(string3) + ".Name");
                                    if (!string4.startsWith("!")) {
                                        string3 = string4;
                                    }
                                    stringArray2[2] = string3;
                                    arrayList.add(stringArray2);
                                }
                            }
                            ++n4;
                        }
                    }
                    treeMap.put(file2.getName(), arrayList);
                }
                ++n2;
            }
        }
        return treeMap;
    }

    protected static void createActions() {
        aboutTrackerAction = new AbstractAction(TrackerRes.getString("Tracker.Action.AboutTracker"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracker.showAboutTracker();
            }
        };
        readmeAction = new AbstractAction(String.valueOf(TrackerRes.getString("Tracker.Readme")) + "...", null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (readmeDialog == null && trackerHome != null) {
                    String string = System.getProperty("file.separator", "/");
                    String string2 = String.valueOf(trackerHome) + string + readmeFileName;
                    String string3 = ResourceLoader.getString(string2);
                    if (string3 == null || "".equals(string3)) {
                        string3 = String.valueOf(TrackerRes.getString("Tracker.Readme.NotFound")) + ": " + string2;
                        JOptionPane.showMessageDialog(null, string3, TrackerRes.getString("Tracker.Readme.NotFound"), 2);
                        return;
                    }
                    readmeDialog = new JDialog(null, true);
                    readmeDialog.setTitle(TrackerRes.getString("Tracker.Readme"));
                    JTextArea jTextArea = new JTextArea();
                    jTextArea.setEditable(false);
                    jTextArea.setTabSize(2);
                    jTextArea.setLineWrap(true);
                    jTextArea.setWrapStyleWord(true);
                    JScrollPane jScrollPane = new JScrollPane(jTextArea);
                    readmeDialog.setContentPane(jScrollPane);
                    jTextArea.setText(string3);
                    jTextArea.setCaretPosition(0);
                    readmeDialog.setSize(600, 600);
                    FontSizer.setFonts(readmeDialog, FontSizer.getLevel());
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    int n = (dimension.width - Tracker.readmeDialog.getBounds().width) / 2;
                    int n2 = (dimension.height - Tracker.readmeDialog.getBounds().height) / 2;
                    readmeDialog.setLocation(n, n2);
                }
                readmeDialog.setVisible(true);
            }
        };
        final String string = System.getenv("START_LOG");
        if (string != null) {
            startLogAction = new AbstractAction(String.valueOf(TrackerRes.getString("Tracker.StartLog")) + "...", null){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (startLogDialog == null) {
                        String string2 = ResourceLoader.getString(string);
                        if (string2 == null || "".equals(string2)) {
                            string2 = String.valueOf(TrackerRes.getString("Tracker.StartLog.NotFound")) + ": " + string;
                            JOptionPane.showMessageDialog(null, string2, TrackerRes.getString("Tracker.startLogPath.NotFound"), 2);
                            return;
                        }
                        startLogDialog = new JDialog(null, true);
                        startLogDialog.setTitle(TrackerRes.getString("Tracker.StartLog"));
                        JTextArea jTextArea = new JTextArea();
                        jTextArea.setEditable(false);
                        jTextArea.setTabSize(2);
                        jTextArea.setLineWrap(true);
                        jTextArea.setWrapStyleWord(true);
                        JScrollPane jScrollPane = new JScrollPane(jTextArea);
                        startLogDialog.setContentPane(jScrollPane);
                        jTextArea.setText(string2);
                        jTextArea.setCaretPosition(0);
                        FontSizer.setFonts(startLogDialog, FontSizer.getLevel());
                        startLogDialog.setSize(600, 600);
                        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                        int n = (dimension.width - Tracker.startLogDialog.getBounds().width) / 2;
                        int n2 = (dimension.height - Tracker.startLogDialog.getBounds().height) / 2;
                        startLogDialog.setLocation(n, n2);
                    }
                    startLogDialog.setVisible(true);
                }
            };
        }
        if (prefsPath != null) {
            trackerPrefsAction = new AbstractAction(String.valueOf(TrackerRes.getString("Tracker.Prefs.MenuItem.Text")) + "...", null){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (trackerPrefsDialog == null) {
                        String string = ResourceLoader.getString(prefsPath);
                        if (string == null || "".equals(string)) {
                            string = String.valueOf(TrackerRes.getString("Tracker.Prefs.NotFound")) + ": " + prefsPath;
                            JOptionPane.showMessageDialog(null, string, TrackerRes.getString("Tracker.Prefs.NotFound"), 2);
                            return;
                        }
                        trackerPrefsDialog = new JDialog(null, true);
                        trackerPrefsDialog.setTitle(String.valueOf(TrackerRes.getString("ConfigInspector.Title")) + ": " + XML.forwardSlash(prefsPath));
                        trackerPrefsTextArea = new JTextArea();
                        trackerPrefsTextArea.setEditable(false);
                        trackerPrefsTextArea.setTabSize(2);
                        trackerPrefsTextArea.setLineWrap(true);
                        trackerPrefsTextArea.setWrapStyleWord(true);
                        JScrollPane jScrollPane = new JScrollPane(trackerPrefsTextArea);
                        trackerPrefsDialog.setContentPane(jScrollPane);
                        trackerPrefsTextArea.setText(string);
                        trackerPrefsTextArea.setCaretPosition(0);
                        FontSizer.setFonts(trackerPrefsDialog, FontSizer.getLevel());
                        trackerPrefsDialog.setSize(800, 400);
                        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                        int n = (dimension.width - Tracker.trackerPrefsDialog.getBounds().width) / 2;
                        int n2 = (dimension.height - Tracker.trackerPrefsDialog.getBounds().height) / 2;
                        trackerPrefsDialog.setLocation(n, n2);
                    } else {
                        String string = ResourceLoader.getString(prefsPath);
                        trackerPrefsTextArea.setText(string);
                        trackerPrefsTextArea.setCaretPosition(0);
                    }
                    trackerPrefsDialog.setVisible(true);
                }
            };
        }
        aboutJavaAction = new AbstractAction(TrackerRes.getString("Tracker.Action.AboutJava"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Diagnostics.aboutJava();
            }
        };
        aboutQTAction = new AbstractAction(TrackerRes.getString("Tracker.Action.AboutQT"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Diagnostics.aboutQTJava("Tracker");
            }
        };
        aboutXuggleAction = new AbstractAction(TrackerRes.getString("Tracker.Action.AboutXuggle"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsForXuggle.aboutXuggle("Tracker");
            }
        };
        aboutThreadsAction = new AbstractAction(TrackerRes.getString("Tracker.Action.AboutThreads"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsForThreads.aboutThreads();
            }
        };
    }

    protected static Set<String> getFullConfig() {
        TreeSet<String> treeSet = new TreeSet<String>();
        String[] stringArray = fullConfig;
        int n = fullConfig.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            treeSet.add(string);
            ++n2;
        }
        return treeSet;
    }

    protected static Set<String> getDefaultConfig() {
        if (defaultConfig == null) {
            defaultConfig = Tracker.getFullConfig();
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : defaultConfig) {
            treeSet.add(string);
        }
        return treeSet;
    }

    protected static void setDefaultConfig(Set<String> set) {
        if (defaultConfig == null) {
            defaultConfig = new TreeSet<String>();
        }
        defaultConfig.clear();
        for (String string : set) {
            defaultConfig.add(string);
        }
    }

    protected static void autoloadDataFunctions() {
        dataFunctionControls.clear();
        for (String string : Tracker.getInitialSearchPaths()) {
            File[] fileArray;
            File file;
            if (string == null || !(file = new File(string)).exists() || (fileArray = file.listFiles(xmlFilter)) == null) continue;
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz;
                File file2 = fileArray2[n2];
                XMLControlElement xMLControlElement = new XMLControlElement(file2.getPath());
                if (!xMLControlElement.failedToRead() && (clazz = xMLControlElement.getObjectClass()) != null && TrackDataBuilder.class.isAssignableFrom(clazz)) {
                    for (Object object : xMLControlElement.getPropertyContent()) {
                        Object object2;
                        XMLControl[] xMLControlArray;
                        if (!(object instanceof XMLProperty) || !((XMLProperty)object).getPropertyName().equals("functions")) continue;
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        XMLControl[] xMLControlArray2 = xMLControlArray = ((XMLProperty)object).getChildControls();
                        int n3 = xMLControlArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            object2 = xMLControlArray2[n4];
                            String string2 = object2.getString("description");
                            ArrayList arrayList2 = (ArrayList)object2.getObject("functions");
                            if (string2 != null && arrayList2 != null && !arrayList2.isEmpty()) {
                                arrayList.add(object2);
                            }
                            ++n4;
                        }
                        object2 = XML.forwardSlash(file2.getAbsolutePath());
                        dataFunctionControls.put((String)object2, arrayList);
                    }
                }
                ++n2;
            }
        }
    }

    public static Collection<String> getDefaultAutoloadSearchPaths() {
        return OSPRuntime.getDefaultSearchPaths();
    }

    protected static Collection<String> getInitialSearchPaths() {
        block4: {
            if (!initialAutoloadSearchPaths.isEmpty()) break block4;
            if (preferredAutoloadSearchPaths != null) {
                String[] stringArray = preferredAutoloadSearchPaths;
                int n = preferredAutoloadSearchPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    initialAutoloadSearchPaths.add(string);
                    ++n2;
                }
            } else {
                for (String string : Tracker.getDefaultAutoloadSearchPaths()) {
                    initialAutoloadSearchPaths.add(string);
                }
            }
        }
        return initialAutoloadSearchPaths;
    }

    protected static void setPreferredLocale(String string) {
        if (string == null) {
            Locale.setDefault(defaultLocale);
            preferredLocale = null;
        } else {
            Locale[] localeArray = locales;
            int n = locales.length;
            int n2 = 0;
            while (n2 < n) {
                Locale locale = localeArray[n2];
                if (locale.toString().equals(string)) {
                    Locale.setDefault(locale);
                    preferredLocale = string;
                    break;
                }
                ++n2;
            }
        }
    }

    protected static void setCache(String string) {
        File file = string == null || string.trim().equals("") ? ResourceLoader.getDefaultOSPCache() : new File(string);
        ResourceLoader.setOSPCache(file);
    }

    protected static boolean updateResources() {
        Object object;
        boolean bl = false;
        try {
            object = new File(TrackerStarter.findTrackerHome(false));
            bl = ExtensionsManager.getManager().copyXuggleJarsTo((File)object);
        }
        catch (Exception exception) {}
        if (OSPRuntime.isMac()) {
            return bl;
        }
        object = System.getProperty("java.home");
        File file = new File((String)object, "lib/ext");
        if (file.exists()) {
            bl = ExtensionsManager.getManager().copyQTJavaTo(file) || bl;
        }
        return bl;
    }

    protected static boolean areEqual(Set<?> set, Set<?> set2) {
        for (Object obj : set) {
            if (set2.contains(obj)) continue;
            return false;
        }
        for (Object obj : set2) {
            if (set.contains(obj)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void loadCurrentVersion(boolean bl, boolean bl2) {
        double d;
        if (!ResourceLoader.isURLAvailable("http://www.opensourcephysics.org")) {
            return;
        }
        if (!bl) {
            long l = System.currentTimeMillis();
            long l2 = (l - lastMillisChecked) / 86400000L;
            if (lastMillisChecked == 0L) {
                lastMillisChecked = System.currentTimeMillis();
            }
            double d2 = d = checkForUpgradeInterval == 0 ? 0.1 : (double)checkForUpgradeInterval;
            if ((double)l2 < d) {
                return;
            }
        }
        double d3 = Double.parseDouble(VERSION);
        String string = Tracker.getPHPPageName(bl2);
        String string2 = Tracker.loginGetLatestVersion(string);
        try {
            while (string2 != null) {
                if (string2.length() <= 0) {
                    return;
                }
                try {
                    d = Double.parseDouble(string2);
                    if (d > d3) {
                        newerVersion = string2;
                    }
                    string2 = null;
                }
                catch (Exception exception) {
                    string2 = string2.substring(1);
                }
            }
            return;
        }
        catch (Exception exception) {}
    }

    private static String getPHPPageName(boolean bl) {
        String string = "version";
        if (bl) {
            Locale locale = Locale.getDefault();
            String string2 = locale.getLanguage();
            String string3 = locale.getCountry();
            String string4 = VideoIO.getEngine();
            String string5 = "unknownOS";
            try {
                string5 = System.getProperty("os.name", "unknownOS").toLowerCase();
            }
            catch (SecurityException securityException) {}
            string5 = string5.replace(" ", "");
            string = "log_4.91_" + string5 + "_" + string4;
            if (!"".equals(string2)) {
                if (!"".equals(string3)) {
                    string2 = String.valueOf(string2) + "-" + string3;
                }
                string = String.valueOf(string) + "_" + string2;
            }
        }
        return string;
    }

    private static String loginGetLatestVersion(String string) {
        String string2 = String.valueOf(counterPath) + "page=" + string;
        try {
            URL uRL = new URL(string2);
            Resource resource = new Resource(uRL);
            String string3 = resource.getString();
            OSPLog.finer(String.valueOf(string2) + ":   " + string3);
            return string3;
        }
        catch (Exception exception) {
            return VERSION;
        }
    }

    protected static void loadPreferences() {
        XMLControl xMLControl = TrackerStarter.findPreferences();
        if (xMLControl != null) {
            prefsPath = xMLControl.getString("prefsPath");
            if (prefsPath != null) {
                OSPLog.getOSPLog();
                OSPLog.info("loading preferences from " + XML.getAbsolutePath(new File(prefsPath)));
            }
            xMLControl.loadObject(null);
            return;
        }
    }

    protected static String savePreferences() {
        String string;
        XMLControlElement xMLControlElement = new XMLControlElement(new Preferences());
        xMLControlElement.write(prefsPath);
        File file = new File(".tracker.prefs");
        if (file.exists() && file.canWrite()) {
            xMLControlElement.write(file.getAbsolutePath());
        }
        if (trackerHome != null) {
            OSPRuntime.setPreference("TRACKER_HOME", trackerHome);
        }
        if ((string = System.getenv("XUGGLE_HOME")) != null) {
            OSPRuntime.setPreference("XUGGLE_HOME", string);
        }
        OSPRuntime.savePreferences();
        return prefsPath;
    }

    protected static Cursor getZoomInCursor() {
        if (zoomInCursor == null) {
            String string = "/org/opensourcephysics/cabrillo/tracker/resources/images/zoom_in.gif";
            Image image = ResourceLoader.getImage(string);
            zoomInCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(12, 12), "Zoom In");
        }
        return zoomInCursor;
    }

    protected static Cursor getZoomOutCursor() {
        if (zoomOutCursor == null) {
            String string = "/org/opensourcephysics/cabrillo/tracker/resources/images/zoom_out.gif";
            Image image = ResourceLoader.getImage(string);
            zoomOutCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(12, 12), "Zoom Out");
        }
        return zoomOutCursor;
    }

    public static void main(String[] stringArray) {
        boolean bl;
        Object object;
        boolean bl2 = false;
        JarFile jarFile = OSPRuntime.getLaunchJar();
        try {
            Attributes attributes = jarFile.getManifest().getMainAttributes();
            object = attributes.getValue("Main-Class");
            bl2 = object.toString().endsWith("Tracker");
        }
        catch (Exception exception) {}
        boolean bl3 = bl = stringArray != null && stringArray.length > 0 && "relaunch".equals(stringArray[stringArray.length - 1]);
        if (bl) {
            object = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 0, object, 0, ((String[])object).length);
            stringArray = object;
        } else {
            object = System.getenv("TRACKER_RELAUNCH");
            bl = "true".equals(object);
        }
        object = System.getenv("MEMORY_SIZE");
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        long l = memoryMXBean.getHeapMemoryUsage().getMax() / 0x100000L;
        if (!bl) {
            String string = System.getProperty("java.home");
            string = String.valueOf(XML.forwardSlash(string)) + "/bin/java";
            String string2 = preferredJRE;
            if (string2 != null) {
                File file = OSPRuntime.getJavaFile(string2);
                string2 = file != null && file.exists() ? XML.stripExtension(XML.forwardSlash(file.getPath())) : null;
            }
            boolean bl4 = string2 != null && !string.equals(string2);
            boolean bl5 = Tracker.updateResources();
            if (object != null) {
                originalMemoryRequest = requestedMemorySize;
                requestedMemorySize = Integer.parseInt((String)object);
            }
            boolean bl6 = requestedMemorySize > 10 && (l < (long)(9 * requestedMemorySize / 10) || l > (long)(11 * requestedMemorySize / 10));
            boolean bl7 = false;
            try {
                String string3 = TrackerStarter.findTrackerHome(false);
                String string4 = System.getenv("TRACKER_HOME");
                if (string3 != null && !string3.equals(string4)) {
                    bl7 = true;
                } else {
                    String string5 = TrackerStarter.findXuggleHome(string3, false);
                    String string6 = System.getenv("XUGGLE_HOME");
                    if (string5 != null && !string5.equals(string6)) {
                        bl7 = true;
                    } else if (string5 != null) {
                        String string7 = OSPRuntime.isWindows() ? "bin" : "lib";
                        String string8 = String.valueOf(string5) + File.separator + string7;
                        String string9 = OSPRuntime.isWindows() ? "Path" : (OSPRuntime.isMac() ? "DYLD_LIBRARY_PATH" : "LD_LIBRARY_PATH");
                        String string10 = System.getenv(string9);
                        if (string10 == null || !string10.contains(string8)) {
                            bl7 = true;
                        }
                    }
                }
            }
            catch (Exception exception) {}
            if (bl2 && (bl4 || bl6 || bl7 || bl5)) {
                mainArgs = stringArray;
                if (requestedMemorySize <= 10) {
                    requestedMemorySize = 256;
                }
                System.setProperty("PREFERRED_MEMORY_SIZE", String.valueOf(requestedMemorySize));
                System.setProperty("PREFERRED_TRACKER_JAR", OSPRuntime.getLaunchJarPath());
                TrackerStarter.relaunch(mainArgs, true);
                return;
            }
        }
        preferredMemorySize = requestedMemorySize;
        if (requestedMemorySize < 0) {
            requestedMemorySize = (int)(l + 2L);
        }
        Tracker.start(stringArray);
    }

    private static void start(String[] stringArray) {
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        Object object5;
        Tracker tracker = null;
        tracker = stringArray == null || stringArray.length == 0 ? new Tracker() : new Tracker(stringArray, true, true);
        if (OSPRuntime.isMac()) {
            object5 = "org.opensourcephysics.cabrillo.tracker.deploy.OSXServices";
            try {
                object4 = Class.forName((String)object5);
                object3 = ((Class)object4).getConstructor(Tracker.class);
                ((Constructor)object3).newInstance(tracker);
            }
            catch (Exception exception) {}
        }
        FontSizer.setLevel(preferredFontLevel);
        object5 = tracker.getFrame();
        ((TFrame)object5).setVisible(true);
        ((OSPFrame)object5).setDefaultCloseOperation(3);
        object4 = new Runnable((TFrame)object5){
            private final /* synthetic */ TFrame val$frame;
            {
                this.val$frame = tFrame;
            }

            @Override
            public void run() {
                try {
                    dataTrackTool = new DataTrackTool(this.val$frame);
                    Tracker.registerRemoteTool(dataTrackTool);
                }
                catch (RemoteException remoteException) {}
            }
        };
        new Thread((Runnable)object4).start();
        object3 = Launcher.activeNode;
        if (object3 != null) {
            ((OSPFrame)object5).setDefaultCloseOperation(1);
        }
        TTrackBar.refreshMemoryButton();
        if (originalMemoryRequest > requestedMemorySize) {
            JOptionPane.showMessageDialog((Component)object5, String.valueOf(TrackerRes.getString("Tracker.Dialog.MemoryReduced.Message1")) + " " + originalMemoryRequest + "MB\n" + TrackerRes.getString("Tracker.Dialog.MemoryReduced.Message2") + " " + requestedMemorySize + "MB.\n\n" + TrackerRes.getString("Tracker.Dialog.MemoryReduced.Message3"), TrackerRes.getString("Tracker.Dialog.MemoryReduced.Title"), 1);
        }
        if (warnNoVideoEngine && VideoIO.getDefaultEngine().equals("none")) {
            Object object6;
            n = VideoIO.guessXuggleVersion() != 0.0 ? 1 : 0;
            boolean bl = ExtensionsManager.getManager().getQTJavaZip() != null;
            object2 = new ArrayList();
            boolean bl2 = false;
            if (n == 0 && !bl) {
                ((ArrayList)object2).add(TrackerRes.getString("Tracker.Dialog.NoVideoEngine.Message1"));
                ((ArrayList)object2).add(TrackerRes.getString("Tracker.Dialog.NoVideoEngine.Message2"));
                ((ArrayList)object2).add(" ");
                ((ArrayList)object2).add(TrackerRes.getString("Tracker.Dialog.NoVideoEngine.Message3"));
            } else if (OSPRuntime.isWindows() && ExtensionsManager.getManager().getDefaultJRE(32) == null) {
                ((ArrayList)object2).add(TrackerRes.getString("Tracker.Dialog.SwitchTo32BitVM.Message1"));
                ((ArrayList)object2).add(TrackerRes.getString("Tracker.Dialog.SwitchTo32BitVM.Message2"));
                ((ArrayList)object2).add(" ");
                ((ArrayList)object2).add(TrackerRes.getString("Tracker.Dialog.Install32BitVM.Message"));
                ((ArrayList)object2).add(TrackerRes.getString("PrefsDialog.Dialog.No32bitVM.Message"));
            } else if (OSPRuntime.isWindows() && OSPRuntime.getVMBitness() == 64) {
                ((ArrayList)object2).add(TrackerRes.getString("Tracker.Dialog.SwitchTo32BitVM.Message1"));
                ((ArrayList)object2).add(TrackerRes.getString("Tracker.Dialog.SwitchTo32BitVM.Message2"));
                ((ArrayList)object2).add(" ");
                ((ArrayList)object2).add(TrackerRes.getString("Tracker.Dialog.SwitchTo32BitVM.Question"));
                bl2 = true;
            } else {
                ((ArrayList)object2).add(TrackerRes.getString("Tracker.Dialog.EngineProblems.Message1"));
                ((ArrayList)object2).add(TrackerRes.getString("Tracker.Dialog.EngineProblems.Message2"));
            }
            object = Box.createVerticalBox();
            Object[] objectArray = ((ArrayList)object2).iterator();
            while (objectArray.hasNext()) {
                object6 = (String)objectArray.next();
                ((Container)object).add(new JLabel((String)object6));
            }
            ((Container)object).add(new JLabel("  "));
            object6 = new JCheckBox(TrackerRes.getString("Tracker.Dialog.NoVideoEngine.Checkbox"));
            ((AbstractButton)object6).addActionListener(new ActionListener((JCheckBox)object6){
                private final /* synthetic */ JCheckBox val$checkbox;
                {
                    this.val$checkbox = jCheckBox;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    warnNoVideoEngine = !this.val$checkbox.isSelected();
                }
            });
            ((Container)object).add((Component)object6);
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            if (bl2) {
                objectArray = new Object[]{TrackerRes.getString("Tracker.Dialog.Button.RelaunchNow"), TrackerRes.getString("Tracker.Dialog.Button.ContinueWithoutEngine")};
                int n2 = JOptionPane.showOptionDialog((Component)object5, object, TrackerRes.getString("Tracker.Dialog.NoVideoEngine.Title"), 0, 2, null, objectArray, objectArray[0]);
                if (n2 == 0) {
                    Runnable runnable = new Runnable((TFrame)object5){
                        private final /* synthetic */ TFrame val$frame;
                        {
                            this.val$frame = tFrame;
                        }

                        @Override
                        public void run() {
                            PrefsDialog prefsDialog = this.val$frame.getPrefsDialog();
                            prefsDialog.relaunch32Bit();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            } else {
                JOptionPane.showMessageDialog((Component)object5, object, TrackerRes.getString("Tracker.Dialog.NoVideoEngine.Title"), 1);
            }
        }
        if (System.getenv("STARTER_WARNING") != null) {
            n = OSPRuntime.getVMBitness();
            use32BitMode = n == 32;
            String string = System.getenv("STARTER_WARNING");
            object2 = string.split("\n");
            Box box = Box.createVerticalBox();
            Object object7 = object2;
            int n3 = ((String[])object7).length;
            int n4 = 0;
            while (n4 < n3) {
                object = object7[n4];
                box.add(new JLabel((String)object));
                ++n4;
            }
            box.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            JOptionPane.showMessageDialog(null, box, TrackerRes.getString("Tracker.Dialog.StarterWarning.Title"), 2);
        }
    }

    protected static void splash(String string) {
        if (tipOfTheDayLabel != null) {
            tipOfTheDayLabel.setText(string);
        }
    }

    protected static void setProgress(int n) {
        progressBar.setValue(n);
    }

    protected static void logTime(String string) {
        if (timeLogEnabled) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ss.SSS");
            Calendar calendar = Calendar.getInstance();
            OSPLog.info(String.valueOf(simpleDateFormat.format(calendar.getTime())) + ": " + string);
        }
    }

    protected static boolean registerRemoteTool(Remote remote) {
        String string = remote.getClass().getSimpleName();
        try {
            if (registry == null) {
                registry = LocateRegistry.createRegistry(1099);
            }
            registry.rebind(string, remote);
            OSPLog.fine(String.valueOf(string) + " successfully registered");
            return true;
        }
        catch (Exception exception) {
            OSPLog.warning(exception.getMessage());
            return false;
        }
    }

    protected static boolean unregisterRemoteTool(Remote remote) {
        if (registry == null || remote == null) {
            return false;
        }
        try {
            String string = remote.getClass().getSimpleName();
            registry.unbind(string);
            OSPLog.fine(String.valueOf(string) + " successfully unregistered");
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addRecent(String string, boolean bl) {
        ArrayList<String> arrayList = recentFiles;
        synchronized (arrayList) {
            while (recentFiles.contains(string)) {
                recentFiles.remove(string);
            }
            if (bl) {
                recentFiles.add(string);
            } else {
                recentFiles.add(0, string);
            }
            while (recentFiles.size() > recentFilesSize) {
                recentFiles.remove(recentFiles.size() - 1);
            }
        }
    }

    protected static void setRecentSize(int n) {
        n = Math.min(n, 12);
        recentFilesSize = Math.max(n, 0);
        while (recentFiles.size() > recentFilesSize) {
            recentFiles.remove(recentFiles.size() - 1);
        }
    }

    static class Preferences {
        Preferences() {
        }

        public static XML.ObjectLoader getLoader() {
            return new Loader();
        }

        static class Loader
        implements XML.ObjectLoader {
            Loader() {
            }

            @Override
            public void saveObject(XMLControl xMLControl, Object object) {
                Object object2;
                if (!preferredLogLevel.equals(DEFAULT_LOG_LEVEL)) {
                    xMLControl.setValue("log_level", preferredLogLevel.getName());
                }
                if (!showHintsByDefault) {
                    xMLControl.setValue("show_hints", showHintsByDefault);
                }
                if (isRadians) {
                    xMLControl.setValue("radians", isRadians);
                }
                if (isXuggleFast) {
                    xMLControl.setValue("xuggle_fast", isXuggleFast);
                }
                if (!warnNoVideoEngine) {
                    xMLControl.setValue("warn_no_engine", warnNoVideoEngine);
                }
                if (!warnVariableDuration) {
                    xMLControl.setValue("warn_variable_frame_duration", warnVariableDuration);
                }
                if (!warnXuggleError) {
                    xMLControl.setValue("warn_xuggle_error", warnXuggleError);
                }
                String string = preferredTrackerJar == null ? "tracker.jar" : preferredTrackerJar;
                xMLControl.setValue("tracker_jar", string);
                if (preferredJRE != null) {
                    xMLControl.setValue("java_vm", preferredJRE);
                }
                if (preferredJRE32 != null) {
                    xMLControl.setValue("java_vm_32", preferredJRE32);
                }
                if (preferredJRE64 != null) {
                    xMLControl.setValue("java_vm_64", preferredJRE64);
                }
                if (use32BitMode) {
                    xMLControl.setValue("32-bit", use32BitMode);
                }
                if (preferredMemorySize > -1) {
                    xMLControl.setValue("memory_size", preferredMemorySize);
                }
                if (lookAndFeel != null) {
                    xMLControl.setValue("look_feel", lookAndFeel);
                }
                if (prelaunchExecutables.length > 0) {
                    xMLControl.setValue("run", prelaunchExecutables);
                }
                if (preferredLocale != null) {
                    xMLControl.setValue("locale", preferredLocale);
                }
                if (preferredFontLevel > 0) {
                    xMLControl.setValue("font_size", preferredFontLevel);
                    xMLControl.setValue("font_size_plus", preferredFontLevelPlus);
                }
                if (ResourceLoader.getOSPCache() != null) {
                    File file = ResourceLoader.getOSPCache();
                    xMLControl.setValue("cache", file.getPath());
                }
                xMLControl.setValue("upgrade_interval", checkForUpgradeInterval);
                int n = (int)(lastMillisChecked / 1000L);
                xMLControl.setValue("last_checked", n);
                JFileChooser jFileChooser = VideoIO.getChooser();
                File file = jFileChooser.getCurrentDirectory();
                String string2 = System.getProperty("user.dir");
                if (!file.getAbsolutePath().equals(string2)) {
                    xMLControl.setValue("file_chooser_directory", XML.getAbsolutePath(file));
                }
                if (VideoIO.getEngine().equals("QT")) {
                    xMLControl.setValue("qt_preferred", true);
                }
                if (engineKnown) {
                    xMLControl.setValue("video_engine", VideoIO.getEngine());
                }
                if (!VideoIO.getPreferredExportExtension().equals("mp4")) {
                    xMLControl.setValue("export_extension", VideoIO.getPreferredExportExtension());
                }
                if (!ExportZipDialog.preferredExtension.equals("jpg")) {
                    xMLControl.setValue("zip_export_extension", ExportZipDialog.preferredExtension);
                }
                if (recentFilesSize != 6) {
                    xMLControl.setValue("max_recent", recentFilesSize);
                }
                if (!recentFiles.isEmpty()) {
                    xMLControl.setValue("recent_files", recentFiles);
                }
                if (preferredAutoloadSearchPaths != null) {
                    xMLControl.setValue("autoload_search_paths", preferredAutoloadSearchPaths);
                }
                if (!autoloadMap.isEmpty()) {
                    object2 = new String[autoloadMap.size()][];
                    int n2 = 0;
                    for (String string3 : autoloadMap.keySet()) {
                        String[] stringArray = autoloadMap.get(string3);
                        String[] stringArray2 = new String[stringArray.length + 1];
                        stringArray2[0] = string3;
                        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
                        object2[n2] = stringArray2;
                        ++n2;
                    }
                    xMLControl.setValue("autoload_exclusions", object2);
                }
                if (!dataFunctionControlStrings.isEmpty()) {
                    xMLControl.setValue("data_functions", dataFunctionControlStrings);
                }
                if (defaultConfig != null && !Tracker.areEqual(defaultConfig, Tracker.getFullConfig())) {
                    object2 = new Configuration(defaultConfig);
                    xMLControl.setValue("configuration", object2);
                }
            }

            @Override
            public Object createObject(XMLControl xMLControl) {
                return new Preferences();
            }

            @Override
            public Object loadObject(XMLControl xMLControl, Object object) {
                Object object2;
                Object object3;
                Level level = OSPLog.parseLevel(xMLControl.getString("log_level"));
                if (level != null) {
                    preferredLogLevel = level;
                    OSPLog.setLevel(level);
                    if (level == Level.ALL) {
                        OSPLog.showLogInvokeLater();
                    }
                }
                isRadians = xMLControl.getBoolean("radians");
                isXuggleFast = xMLControl.getBoolean("xuggle_fast");
                if (xMLControl.getPropertyNames().contains("warn_no_engine")) {
                    warnNoVideoEngine = xMLControl.getBoolean("warn_no_engine");
                }
                if (xMLControl.getPropertyNames().contains("warn_xuggle_error")) {
                    warnXuggleError = xMLControl.getBoolean("warn_xuggle_error");
                }
                if (xMLControl.getPropertyNames().contains("warn_variable_frame_duration")) {
                    warnVariableDuration = xMLControl.getBoolean("warn_variable_frame_duration");
                }
                if (xMLControl.getPropertyNames().contains("show_hints")) {
                    showHintsByDefault = xMLControl.getBoolean("show_hints");
                    showHints = showHintsByDefault;
                    boolean bl = startupHintShown = !showHints;
                }
                if (xMLControl.getPropertyNames().contains("java_vm")) {
                    preferredJRE = xMLControl.getString("java_vm");
                }
                preferredJRE32 = xMLControl.getString("java_vm_32");
                preferredJRE64 = xMLControl.getString("java_vm_64");
                use32BitMode = xMLControl.getBoolean("32-bit");
                if (xMLControl.getPropertyNames().contains("memory_size")) {
                    requestedMemorySize = xMLControl.getInt("memory_size");
                }
                if (xMLControl.getPropertyNames().contains("look_feel")) {
                    lookAndFeel = xMLControl.getString("look_feel");
                }
                if (xMLControl.getPropertyNames().contains("run")) {
                    prelaunchExecutables = (String[])xMLControl.getObject("run");
                }
                if (xMLControl.getPropertyNames().contains("locale")) {
                    Tracker.setPreferredLocale(xMLControl.getString("locale"));
                }
                if (xMLControl.getPropertyNames().contains("font_size")) {
                    preferredFontLevel = xMLControl.getInt("font_size");
                    preferredFontLevelPlus = xMLControl.getInt("font_size_plus");
                    if (preferredFontLevelPlus == Integer.MIN_VALUE) {
                        preferredFontLevelPlus = 0;
                    }
                }
                if (ResourceLoader.getOSPCache() == null) {
                    Tracker.setCache(xMLControl.getString("cache"));
                }
                if (xMLControl.getPropertyNames().contains("upgrade_interval")) {
                    checkForUpgradeInterval = xMLControl.getInt("upgrade_interval");
                    lastMillisChecked = (long)xMLControl.getInt("last_checked") * 1000L;
                }
                if (xMLControl.getPropertyNames().contains("file_chooser_directory")) {
                    OSPRuntime.chooserDir = xMLControl.getString("file_chooser_directory");
                }
                VideoIO.setEngine(xMLControl.getString("video_engine"));
                VideoIO.setPreferredExportExtension(xMLControl.getString("export_extension"));
                if (xMLControl.getPropertyNames().contains("zip_export_extension")) {
                    ExportZipDialog.preferredExtension = xMLControl.getString("zip_export_extension");
                }
                if (xMLControl.getPropertyNames().contains("max_recent")) {
                    recentFilesSize = xMLControl.getInt("max_recent");
                }
                if (xMLControl.getPropertyNames().contains("recent_files")) {
                    object3 = (String[][])ArrayList.class.cast(xMLControl.getObject("recent_files"));
                    Iterator iterator = ((ArrayList)object3).iterator();
                    while (iterator.hasNext()) {
                        object2 = iterator.next();
                        Tracker.addRecent(object2.toString(), true);
                    }
                }
                preferredAutoloadSearchPaths = (String[])xMLControl.getObject("autoload_search_paths");
                if (xMLControl.getPropertyNames().contains("autoload_exclusions")) {
                    object3 = (String[][])xMLControl.getObject("autoload_exclusions");
                    String[][] stringArray = object3;
                    int n = ((String[][])object3).length;
                    int n2 = 0;
                    while (n2 < n) {
                        object2 = stringArray[n2];
                        String string = XML.forwardSlash(object2[0]);
                        String[] stringArray2 = new String[((E)object2).length - 1];
                        System.arraycopy(object2, 1, stringArray2, 0, stringArray2.length);
                        autoloadMap.put(string, stringArray2);
                        ++n2;
                    }
                }
                if (xMLControl.getPropertyNames().contains("data_functions")) {
                    object3 = (Collection)xMLControl.getObject("data_functions");
                    dataFunctionControlStrings.addAll((Collection<String>)object3);
                }
                if ((object3 = xMLControl.getChildControl("configuration")) != null) {
                    object2 = (Configuration)object3.loadObject(null);
                    Tracker.setDefaultConfig(((Configuration)object2).enabled);
                }
                preferredTrackerJar = xMLControl.getString("tracker_jar");
                return object;
            }
        }
    }
}

