/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.LineProfile;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.RGBRegion;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.AbstractAutoloadManager;
import org.opensourcephysics.tools.DataFunctionPanel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.TristateCheckBox;

public class TrackDataBuilder
extends FunctionTool {
    private TrackerPanel trackerPanel;
    private JButton loadButton;
    private JButton saveButton;
    private JButton autoloadButton;
    private AutoloadManager autoloadManager;

    protected TrackDataBuilder(TrackerPanel trackerPanel) {
        super(trackerPanel);
        this.trackerPanel = trackerPanel;
        this.createButtons();
        this.setToolbarComponents(new Component[]{this.loadButton, this.saveButton, Box.createHorizontalGlue(), this.autoloadButton});
        this.setHelpPath("data_builder_help.html");
        this.addPropertyChangeListener("panel", trackerPanel);
        this.addPropertyChangeListener("function", trackerPanel);
        this.addPropertyChangeListener("visible", trackerPanel);
        ArrayList<Drawable> arrayList = trackerPanel.getSystemDrawables();
        for (TTrack tTrack : trackerPanel.getTracks()) {
            if (arrayList.contains(tTrack)) continue;
            FunctionPanel functionPanel = this.createFunctionPanel(tTrack);
            this.addPanel(tTrack.getName(), functionPanel);
        }
    }

    protected void createButtons() {
        String string = "/org/opensourcephysics/resources/tools/images/open.gif";
        Icon icon = ResourceLoader.getIcon(string);
        this.loadButton = new JButton(icon);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = OSPRuntime.createChooser(TrackerRes.getString("TrackerPanel.DataBuilder.Load.Title"), TrackerRes.getString("TrackerPanel.DataBuilder.Chooser.XMLFiles"), new String[]{"xml"});
                int n = jFileChooser.showOpenDialog(TrackDataBuilder.this);
                if (n == 0) {
                    OSPRuntime.chooserDir = jFileChooser.getCurrentDirectory().toString();
                    String string = jFileChooser.getSelectedFile().getAbsolutePath();
                    XMLControlElement xMLControlElement = new XMLControlElement(string);
                    if (xMLControlElement.failedToRead()) {
                        JOptionPane.showMessageDialog(TrackDataBuilder.this.trackerPanel.getTFrame(), TrackerRes.getString("Tracker.Dialog.Invalid.Message"), TrackerRes.getString("Tracker.Dialog.Invalid.Title"), 0);
                        return;
                    }
                    Class<?> clazz = xMLControlElement.getObjectClass();
                    if (DataFunctionPanel.class.isAssignableFrom(clazz)) {
                        FunctionPanel functionPanel = TrackDataBuilder.this.getSelectedPanel();
                        Class<?> clazz2 = null;
                        Class<?> clazz3 = null;
                        try {
                            clazz2 = Class.forName(functionPanel.getDescription());
                            clazz3 = Class.forName(xMLControlElement.getString("description"));
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                        String string2 = TrackerRes.getString("TrackerPanel.DataBuilder.TrackType.Unknown");
                        if (clazz3 != null) {
                            string2 = TrackerRes.getString(String.valueOf(clazz3.getSimpleName()) + ".Name").toLowerCase();
                        }
                        if (clazz3 != clazz2) {
                            String string3 = TrackerRes.getString(String.valueOf(clazz2.getSimpleName()) + ".Name").toLowerCase();
                            JOptionPane.showMessageDialog(TrackDataBuilder.this.trackerPanel.getTFrame(), String.valueOf(TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.WrongTrackType.Message1")) + " \"" + string2 + ".\"" + "\n" + TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.WrongTrackType.Message2") + " \"" + string3 + ".\"", TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.WrongTrackType.Title"), 0);
                            return;
                        }
                        if (TrackDataBuilder.this.choosePanelDataFunctions(xMLControlElement, "Load", null)) {
                            ArrayList<FunctionPanel> arrayList = new ArrayList<FunctionPanel>();
                            for (String objectArray : TrackDataBuilder.this.getPanelNames()) {
                                FunctionPanel functionPanel2 = TrackDataBuilder.this.getPanel(objectArray);
                                try {
                                    clazz2 = Class.forName(functionPanel2.getDescription());
                                }
                                catch (ClassNotFoundException classNotFoundException) {}
                                if (clazz2 != clazz3) continue;
                                arrayList.add(functionPanel2);
                            }
                            n = 1;
                            if (arrayList.size() > 1) {
                                Object[] object22 = new String[]{TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.Load.Button.All"), String.valueOf(TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.Load.Button.Only")) + " " + functionPanel.getName(), TrackerRes.getString("Dialog.Button.Cancel")};
                                n = JOptionPane.showOptionDialog(TrackDataBuilder.this, String.valueOf(TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.Load.Message")) + " \"" + string2 + "\"?", TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.Load.Title"), -1, 3, null, object22, object22[0]);
                            }
                            if (n == 0) {
                                for (FunctionPanel functionPanel3 : arrayList) {
                                    xMLControlElement.loadObject(functionPanel3);
                                }
                            } else if (n == 1) {
                                xMLControlElement.loadObject(functionPanel);
                            }
                        }
                    } else if (TrackDataBuilder.class.isAssignableFrom(clazz)) {
                        Object object;
                        Object object322;
                        FunctionPanel functionPanel = TrackDataBuilder.this.getSelectedPanel();
                        String string4 = functionPanel.getDescription();
                        Object object4 = null;
                        block6: for (Object object322 : xMLControlElement.getPropertyContent()) {
                            XMLControl[] xMLControlArray;
                            if (!(object322 instanceof XMLProperty) || !((XMLProperty)object322).getPropertyName().equals("functions")) continue;
                            XMLControl[] xMLControlArray2 = xMLControlArray = ((XMLProperty)object322).getChildControls();
                            int n2 = xMLControlArray.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                object = xMLControlArray2[n3];
                                String string2 = object.getString("description");
                                if (string2 != null && string4 != null && string4.equals(string2)) {
                                    object4 = object;
                                    break block6;
                                }
                                ++n3;
                            }
                        }
                        object322 = TrackerRes.getString("TrackerPanel.DataBuilder.TrackType.Unknown");
                        if (string4 != null) {
                            object322 = TrackerRes.getString(String.valueOf(XML.getExtension(string4)) + ".Name").toLowerCase();
                        }
                        if (object4 == null) {
                            JOptionPane.showMessageDialog(TrackDataBuilder.this.trackerPanel.getTFrame(), String.valueOf(TrackerRes.getString("TrackDataBuilder.Dialog.NoFunctionsFound.Message")) + " \"" + (String)object322 + ".\"", TrackerRes.getString("TrackDataBuilder.Dialog.NoFunctionsFound.Title"), 0);
                            return;
                        }
                        if (TrackDataBuilder.this.choosePanelDataFunctions((XMLControl)object4, "Load", null)) {
                            ArrayList arrayList = new ArrayList();
                            for (String string3 : TrackDataBuilder.this.getPanelNames()) {
                                FunctionPanel functionPanel4 = TrackDataBuilder.this.getPanel(string3);
                                if (!string4.equalsIgnoreCase(functionPanel4.getDescription())) continue;
                                arrayList.add(functionPanel4);
                            }
                            n = 1;
                            if (arrayList.size() > 1) {
                                Object[] objectArray = new String[]{TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.Load.Button.All"), String.valueOf(TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.Load.Button.Only")) + " " + functionPanel.getName(), TrackerRes.getString("Dialog.Button.Cancel")};
                                n = JOptionPane.showOptionDialog(TrackDataBuilder.this, String.valueOf(TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.Load.Message")) + " \"" + (String)object322 + "\"?", TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.Load.Title"), -1, 3, null, objectArray, objectArray[0]);
                            }
                            if (n == 0) {
                                object = arrayList.iterator();
                                while (object.hasNext()) {
                                    FunctionPanel functionPanel5 = (FunctionPanel)object.next();
                                    object4.loadObject(functionPanel5);
                                }
                            } else if (n == 1) {
                                object4.loadObject(functionPanel);
                            }
                        }
                    } else {
                        JOptionPane.showMessageDialog(TrackDataBuilder.this.trackerPanel.getTFrame(), TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.WrongType.Message"), TrackerRes.getString("TrackerPanel.DataBuilder.Dialog.WrongType.Title"), 0);
                    }
                }
            }
        });
        string = "/org/opensourcephysics/resources/tools/images/save.gif";
        Icon icon2 = ResourceLoader.getIcon(string);
        this.saveButton = new JButton(icon2);
        final ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser;
                int n;
                XMLControlElement xMLControlElement = new XMLControlElement(TrackDataBuilder.this);
                if (TrackDataBuilder.this.chooseBuilderDataFunctions(xMLControlElement, "Save", null) && (n = (jFileChooser = OSPRuntime.createChooser(TrackerRes.getString("TrackerPanel.DataBuilder.Save.Title"), TrackerRes.getString("TrackerPanel.DataBuilder.Chooser.XMLFiles"), new String[]{"xml"})).showSaveDialog(TrackDataBuilder.this)) == 0) {
                    OSPRuntime.chooserDir = jFileChooser.getCurrentDirectory().toString();
                    File file = jFileChooser.getSelectedFile();
                    String string = file.getAbsolutePath();
                    if (!"xml".equals(XML.getExtension(string))) {
                        string = String.valueOf(XML.stripExtension(string)) + ".xml";
                        file = new File(string);
                    }
                    if (!TrackerIO.canWrite(file)) {
                        return;
                    }
                    xMLControlElement.write(string);
                }
            }
        };
        final ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser;
                int n;
                XMLControlElement xMLControlElement = new XMLControlElement(TrackDataBuilder.this.getSelectedPanel());
                if (TrackDataBuilder.this.choosePanelDataFunctions(xMLControlElement, "Save", null) && (n = (jFileChooser = OSPRuntime.createChooser(TrackerRes.getString("TrackerPanel.DataBuilder.Save.Title"), TrackerRes.getString("TrackerPanel.DataBuilder.Chooser.XMLFiles"), new String[]{"xml"})).showSaveDialog(TrackDataBuilder.this)) == 0) {
                    OSPRuntime.chooserDir = jFileChooser.getCurrentDirectory().toString();
                    File file = jFileChooser.getSelectedFile();
                    String string = file.getAbsolutePath();
                    if (!"xml".equals(XML.getExtension(string))) {
                        string = String.valueOf(XML.stripExtension(string)) + ".xml";
                        file = new File(string);
                    }
                    if (!TrackerIO.canWrite(file)) {
                        return;
                    }
                    xMLControlElement.write(string);
                }
            }
        };
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(TrackerRes.getString("TrackDataBuilder.MenuItem.SaveAll.Text"));
                jMenuItem.setToolTipText(TrackerRes.getString("TrackDataBuilder.MenuItem.SaveAll.Tooltip"));
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(actionListener);
                String string = " " + TrackDataBuilder.this.getSelectedPanel().getName();
                jMenuItem = new JMenuItem(String.valueOf(TrackerRes.getString("TrackDataBuilder.MenuItem.SaveOnly.Text")) + string);
                jMenuItem.setToolTipText(TrackerRes.getString("TrackDataBuilder.MenuItem.SaveOnly.Tooltip"));
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(actionListener2);
                FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                jPopupMenu.show(TrackDataBuilder.this.saveButton, 0, TrackDataBuilder.this.saveButton.getHeight());
            }
        });
        this.autoloadButton = new JButton();
        this.autoloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutoloadManager autoloadManager = TrackDataBuilder.this.getAutoloadManager();
                autoloadManager.refreshAutoloadData();
                autoloadManager.setVisible(true);
            }
        });
    }

    @Override
    protected void refreshGUI() {
        super.refreshGUI();
        this.dropdown.setToolTipText(TrackerRes.getString("TrackerPanel.DataBuilder.Dropdown.Tooltip"));
        this.setTitle(TrackerRes.getString("TrackerPanel.DataBuilder.Title"));
        if (this.loadButton != null) {
            FunctionPanel functionPanel = this.getSelectedPanel();
            this.loadButton.setEnabled(functionPanel != null);
            this.saveButton.setEnabled(functionPanel != null);
            this.loadButton.setToolTipText(TrackerRes.getString("TrackerPanel.DataBuilder.Button.Load.Tooltip"));
            this.saveButton.setToolTipText(TrackerRes.getString("TrackerPanel.DataBuilder.Button.Save.Tooltip"));
            this.autoloadButton.setText(String.valueOf(TrackerRes.getString("TrackerPanel.DataBuilder.Button.Autoload")) + "...");
            this.autoloadButton.setToolTipText(TrackerRes.getString("TrackerPanel.DataBuilder.Button.Autoload.Tooltip"));
        }
        this.setFontLevel(FontSizer.getLevel());
        if (this.autoloadManager != null) {
            this.autoloadManager.refreshGUI();
        }
    }

    protected FunctionPanel createFunctionPanel(TTrack tTrack) {
        DataFunctionPanel dataFunctionPanel = new DataFunctionPanel(tTrack.getData(this.trackerPanel));
        dataFunctionPanel.setIcon(tTrack.getFootprint().getIcon(21, 16));
        Class<?> clazz = tTrack.getClass();
        if (PointMass.class.isAssignableFrom(clazz)) {
            dataFunctionPanel.setDescription(PointMass.class.getName());
        } else if (Vector.class.isAssignableFrom(clazz)) {
            dataFunctionPanel.setDescription(Vector.class.getName());
        } else if (RGBRegion.class.isAssignableFrom(clazz)) {
            dataFunctionPanel.setDescription(RGBRegion.class.getName());
        } else if (LineProfile.class.isAssignableFrom(clazz)) {
            dataFunctionPanel.setDescription(LineProfile.class.getName());
        } else {
            dataFunctionPanel.setDescription(clazz.getName());
        }
        final ParamEditor paramEditor = dataFunctionPanel.getParamEditor();
        if (tTrack instanceof PointMass) {
            final PointMass pointMass = (PointMass)tTrack;
            Parameter parameter = (Parameter)paramEditor.getObject("m");
            if (parameter == null) {
                parameter = new Parameter("m", String.valueOf(pointMass.getMass()));
                parameter.setDescription(TrackerRes.getString("ParticleModel.Parameter.Mass.Description"));
                paramEditor.addObject(parameter, false);
            }
            parameter.setNameEditable(false);
            paramEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("m".equals(propertyChangeEvent.getOldValue())) {
                        Parameter parameter = (Parameter)paramEditor.getObject("m");
                        if (pointMass.getMass() != parameter.getValue()) {
                            pointMass.setMass(parameter.getValue());
                            pointMass.massField.setValue(pointMass.getMass());
                        }
                    }
                }
            });
            pointMass.addPropertyChangeListener("mass", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Parameter parameter = (Parameter)paramEditor.getObject("m");
                    double d = (Double)propertyChangeEvent.getNewValue();
                    if (d != parameter.getValue()) {
                        paramEditor.setExpression("m", String.valueOf(d), false);
                    }
                }
            });
        }
        return dataFunctionPanel;
    }

    @Override
    public void setFontLevel(int n) {
        if (this.autoloadButton == null) {
            return;
        }
        n = Math.max(0, n);
        Object[] objectArray = new Object[]{this.loadButton, this.saveButton, this.autoloadButton};
        FontSizer.setFonts(objectArray, n);
        for (String string : this.panels.keySet()) {
            TTrack tTrack = this.trackerPanel.getTrack(string);
            FunctionPanel functionPanel = (FunctionPanel)this.panels.get(string);
            if (tTrack == null || functionPanel == null) continue;
            functionPanel.setIcon(tTrack.getFootprint().getIcon(21, 16));
        }
        super.setFontLevel(n);
        this.validate();
        this.autoloadButton.revalidate();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.setFontLevel(FontSizer.getLevel());
        }
        super.setVisible(bl);
    }

    @Override
    public FunctionPanel addPanel(String string, FunctionPanel functionPanel) {
        Object object;
        Object object2;
        super.addPanel(string, functionPanel);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(functionPanel.getDescription());
        }
        catch (ClassNotFoundException classNotFoundException) {}
        for (String string2 : Tracker.dataFunctionControlStrings) {
            object2 = new XMLControlElement(string2);
            object = null;
            try {
                object = Class.forName(object2.getString("description"));
            }
            catch (Exception exception) {}
            if (object != clazz) continue;
            object2.loadObject(functionPanel);
        }
        for (String string2 : Tracker.dataFunctionControls.keySet()) {
            object2 = Tracker.dataFunctionControls.get(string2);
            Iterator iterator = ((ArrayList)object2).iterator();
            while (iterator.hasNext()) {
                object = (XMLControl)iterator.next();
                Class<?> clazz2 = null;
                try {
                    clazz2 = Class.forName(object.getString("description"));
                }
                catch (Exception exception) {}
                if (clazz2 != clazz) continue;
                XMLControlElement xMLControlElement = new XMLControlElement((XMLControl)object);
                this.eliminateExcludedFunctions(xMLControlElement, string2);
                FunctionEditor functionEditor = functionPanel.getFunctionEditor();
                boolean bl = functionEditor.getConfirmChanges();
                functionEditor.setConfirmChanges(false);
                xMLControlElement.loadObject(functionPanel);
                functionEditor.setConfirmChanges(bl);
            }
        }
        return functionPanel;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean choosePanelDataFunctions(XMLControl xMLControl, String string, Collection<String[]> collection) {
        void e;
        Object object2;
        ListChooser listChooser = new ListChooser(TrackerRes.getString("TrackerPanel.DataBuilder." + string + ".Title"), TrackerRes.getString("TrackerPanel.DataBuilder." + string + ".Message"), this);
        listChooser.setSeparator(" = ");
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        ArrayList arrayList5 = (ArrayList)xMLControl.getObject("functions");
        for (Object object2 : arrayList5) {
            String[] stringArray = (String[])object2;
            arrayList.add(stringArray);
            arrayList2.add(stringArray);
            arrayList3.add(stringArray[0]);
            arrayList4.add(stringArray[1]);
        }
        object2 = new boolean[arrayList2.size()];
        boolean n = false;
        while (e < ((E)object2).length) {
            object2[e] = true;
            ++e;
        }
        if (listChooser.choose((Collection<?>)arrayList2, (Collection<String>)arrayList3, (Collection<?>)arrayList4, (boolean[])object2)) {
            for (Object e2 : arrayList) {
                if (arrayList2.contains(e2)) continue;
                arrayList5.remove(e2);
            }
            xMLControl.setValue("functions", arrayList5);
            return true;
        }
        return false;
    }

    protected boolean chooseBuilderDataFunctions(XMLControl xMLControl, String string, Collection<String[]> collection) {
        ArrayList arrayList;
        Object object;
        Object object222;
        Iterator<Object> iterator;
        Object object422;
        ListChooser listChooser = new ListChooser(TrackerRes.getString("TrackerPanel.DataBuilder." + string + ".Title"), TrackerRes.getString("TrackerPanel.DataBuilder." + string + ".Message"), this);
        listChooser.setSeparator(" = ");
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        ArrayList<String[]> arrayList3 = new ArrayList<String[]>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        TreeMap<String, String[]> treeMap = new TreeMap<String, String[]>();
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        TreeMap treeMap3 = new TreeMap();
        for (Object object422 : xMLControl.getPropertyContent()) {
            if (!(object422 instanceof XMLProperty)) continue;
            iterator = (XMLProperty)object422;
            XMLControl[] object32 = iterator.getChildControls();
            int n = object32.length;
            int n2 = 0;
            while (n2 < n) {
                object222 = object32[n2];
                if (object222.getObjectClass() == DataFunctionPanel.class) {
                    Object object2;
                    Object object3;
                    Iterator iterator2 = object222.getString("description");
                    treeMap.put((String)((Object)iterator2), (String[])object222);
                    object = (ArrayList<Object>)treeMap3.get(iterator2);
                    if (object == null) {
                        object = new ArrayList<Object>();
                        treeMap3.put((String)((Object)iterator2), object);
                    }
                    arrayList = (ArrayList)object222.getObject("functions");
                    Parameter[] parameterArray = arrayList.iterator();
                    block2: while (parameterArray.hasNext()) {
                        object3 = (String[])parameterArray.next();
                        Iterator iterator3 = ((ArrayList)object).iterator();
                        while (iterator3.hasNext()) {
                            object2 = (String[])iterator3.next();
                            if (object2[0].equals(object3[0])) continue block2;
                        }
                        ((ArrayList)object).add(object3);
                    }
                    object3 = (ArrayList)treeMap2.get(iterator2);
                    if (object3 == null) {
                        object3 = new ArrayList();
                        treeMap2.put((String)((Object)iterator2), object3);
                    }
                    Parameter[] parameterArray2 = parameterArray = (Parameter[])object222.getObject("user_parameters");
                    int n3 = parameterArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        block23: {
                            object2 = parameterArray2[n4];
                            if (!((String)((Object)iterator2)).endsWith("PointMass") || !((Parameter)object2).getName().equals("m")) {
                                Iterator iterator4 = ((ArrayList)object3).iterator();
                                while (iterator4.hasNext()) {
                                    Parameter parameter = (Parameter)iterator4.next();
                                    if (!parameter.getName().equals(((Parameter)object2).getName())) {
                                        continue;
                                    }
                                    break block23;
                                }
                                ((ArrayList)object3).add(object2);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        for (Object object422 : treeMap3.keySet()) {
            iterator = (ArrayList)treeMap3.get(object422);
            Iterator iterator5 = ((ArrayList)((Object)iterator)).iterator();
            while (iterator5.hasNext()) {
                object222 = (String[])iterator5.next();
                arrayList2.add((String[])object222);
                arrayList3.add((String[])object222);
                arrayList4.add(object222[0]);
                arrayList5.add(object222[1]);
                String object7 = XML.getExtension((String)object422);
                String string2 = TrackerRes.getString(String.valueOf(object7) + ".Name");
                if (!string2.startsWith("!")) {
                    object7 = string2;
                }
                arrayList6.add("[" + object7 + "]");
            }
        }
        object422 = new boolean[arrayList3.size()];
        int n = 0;
        while (n < ((Object)object422).length) {
            object422[n] = true;
            ++n;
        }
        if (listChooser.choose(arrayList3, arrayList4, arrayList5, arrayList6, (boolean[])object422)) {
            for (String[] stringArray : arrayList2) {
                if (arrayList3.contains(stringArray)) continue;
                for (Object object222 : treeMap.keySet()) {
                    ArrayList arrayList7 = (ArrayList)treeMap3.get(object222);
                    arrayList7.remove(stringArray);
                }
            }
            for (String string2 : treeMap.keySet()) {
                object222 = (ArrayList)treeMap3.get(string2);
                ArrayList arrayList8 = (ArrayList)treeMap2.get(string2);
                Parameter[] parameterArray = arrayList8.toArray(new Parameter[arrayList8.size()]);
                XMLControl xMLControl2 = (XMLControl)treeMap.get(string2);
                xMLControl2.setValue("functions", object222);
                xMLControl2.setValue("user_parameters", parameterArray);
            }
            for (Object object8 : xMLControl.getPropertyContent()) {
                if (!(object8 instanceof XMLProperty) || !((XMLProperty)object8).getPropertyName().equals("functions")) continue;
                object222 = (XMLProperty)object8;
                List<Object> list = object222.getPropertyContent();
                ArrayList arrayList9 = new ArrayList();
                for (Object e : list) {
                    object = ((XMLProperty)e).getChildControls()[0];
                    if (!treeMap.values().contains(object)) {
                        arrayList9.add(e);
                        continue;
                    }
                    arrayList = (ArrayList)object.getObject("functions");
                    if (arrayList != null && !arrayList.isEmpty()) continue;
                    arrayList9.add(e);
                }
                for (Object e : arrayList9) {
                    list.remove(e);
                }
            }
            return true;
        }
        return false;
    }

    private void eliminateExcludedFunctions(XMLControl xMLControl, String string) {
        for (Object object : xMLControl.getPropertyContent()) {
            if (!(object instanceof XMLProperty) || !((XMLProperty)object).getPropertyName().equals("functions")) continue;
            XMLProperty xMLProperty = (XMLProperty)object;
            List<Object> list = xMLProperty.getPropertyContent();
            ArrayList<XMLProperty> arrayList = new ArrayList<XMLProperty>();
            for (Object object2 : list) {
                XMLProperty xMLProperty2 = (XMLProperty)object2;
                XMLProperty xMLProperty3 = (XMLProperty)xMLProperty2.getPropertyContent().get(0);
                String string2 = (String)xMLProperty3.getPropertyContent().get(0);
                if (!this.isFunctionExcluded(string, string2)) continue;
                arrayList.add(xMLProperty2);
            }
            for (XMLProperty xMLProperty4 : arrayList) {
                list.remove(xMLProperty4);
            }
        }
    }

    private boolean isFunctionExcluded(String string, String string2) {
        String[] stringArray = Tracker.autoloadMap.get(string);
        if (stringArray == null) {
            return false;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            if (string3.equals("*")) {
                return true;
            }
            if (string3.equals(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected AutoloadManager getAutoloadManager() {
        if (this.autoloadManager == null) {
            this.autoloadManager = new AutoloadManager(this);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - this.autoloadManager.getBounds().width) / 2;
            int n2 = (dimension.height - this.autoloadManager.getBounds().height) / 2;
            this.autoloadManager.setLocation(n, n2);
            if (!Tracker.dataFunctionControlStrings.isEmpty()) {
                String string;
                ArrayList<String> arrayList = OSPRuntime.getDefaultSearchPaths();
                String string2 = string = arrayList.size() > 0 ? arrayList.get(0) : null;
                if (string != null) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            int n = JOptionPane.showConfirmDialog(TrackDataBuilder.this, String.valueOf(TrackerRes.getString("TrackDataBuilder.Dialog.ConvertAutoload.Message1")) + "\n" + TrackerRes.getString("TrackDataBuilder.Dialog.ConvertAutoload.Message2") + "\n\n" + TrackerRes.getString("TrackDataBuilder.Dialog.ConvertAutoload.Message3"), TrackerRes.getString("TrackDataBuilder.Dialog.ConvertAutoload.Title"), 0);
                            if (n == 0) {
                                TrackDataBuilder trackDataBuilder = new TrackDataBuilder(new TrackerPanel());
                                int n2 = 0;
                                for (String object2 : Tracker.dataFunctionControlStrings) {
                                    XMLControlElement xMLControlElement = new XMLControlElement(object2);
                                    DataFunctionPanel dataFunctionPanel = new DataFunctionPanel(new DatasetManager());
                                    xMLControlElement.loadObject(dataFunctionPanel);
                                    trackDataBuilder.addPanelWithoutAutoloading("panel" + n2, dataFunctionPanel);
                                    ++n2;
                                }
                                File file = new File(string, "TrackerConvertedAutoloadFunctions.xml");
                                XMLControlElement xMLControlElement = new XMLControlElement(trackDataBuilder);
                                xMLControlElement.write(file.getAbsolutePath());
                                Tracker.dataFunctionControlStrings.clear();
                                TrackDataBuilder.this.autoloadManager.refreshAutoloadData();
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
        }
        this.autoloadManager.setFontLevel(FontSizer.getLevel());
        return this.autoloadManager;
    }

    protected void addPanelWithoutAutoloading(String string, FunctionPanel functionPanel) {
        super.addPanel(string, functionPanel);
    }

    class AutoloadManager
    extends AbstractAutoloadManager {
        public AutoloadManager(JDialog jDialog) {
            super(jDialog);
        }

        @Override
        public void setVisible(boolean bl) {
            super.setVisible(bl);
            if (!bl) {
                Collection<String> collection = this.getSearchPaths();
                Collection<String> collection2 = Tracker.getDefaultAutoloadSearchPaths();
                boolean bl2 = collection.size() == collection2.size();
                for (String string : collection) {
                    boolean bl3 = bl2 = bl2 && collection2.contains(string);
                }
                Tracker.preferredAutoloadSearchPaths = bl2 ? null : collection.toArray(new String[collection.size()]);
            }
        }

        @Override
        protected void refreshGUI() {
            this.refreshAutoloadData();
            super.refreshGUI();
            String string = String.valueOf(TrackDataBuilder.this.getTitle()) + " " + this.getTitle();
            this.setTitle(string);
            this.setInstructions(String.valueOf(TrackerRes.getString("TrackDataBuilder.Instructions.SelectToAutoload")) + "\n\n" + TrackerRes.getString("TrackDataBuilder.Instructions.WhereDefined") + " " + TrackerRes.getString("TrackDataBuilder.Instructions.HowToAddFunction") + " " + TrackerRes.getString("TrackDataBuilder.Instructions.HowToAddDirectory"));
        }

        protected String getLocalizedTrackName(String string) {
            String string2 = XML.getExtension(string);
            String string3 = TrackerRes.getString(String.valueOf(string2) + ".Name");
            if (!string3.startsWith("!")) {
                string2 = string3;
            }
            return string2;
        }

        @Override
        protected void setFunctionSelected(String string, String[] stringArray, boolean bl) {
            Object object;
            int n;
            String[] stringArray2 = Tracker.autoloadMap.get(string);
            String[] stringArray3 = null;
            if (!bl) {
                if (stringArray2 == null) {
                    stringArray3 = new String[]{stringArray[0]};
                } else {
                    n = stringArray2.length;
                    stringArray3 = new String[n + 1];
                    System.arraycopy(stringArray2, 0, stringArray3, 0, n);
                    stringArray3[n] = stringArray[0];
                }
            } else if (stringArray2 != null && (n = stringArray2.length) > 1) {
                ArrayList arrayList = new ArrayList();
                String[] stringArray4 = stringArray2;
                int n2 = stringArray2.length;
                int n3 = 0;
                while (n3 < n2) {
                    object = stringArray4[n3];
                    if (!((String)object).equals(stringArray[0])) {
                        arrayList.add(object);
                    }
                    ++n3;
                }
                stringArray3 = arrayList.toArray(new String[arrayList.size()]);
            }
            Tracker.autoloadMap.remove(string);
            if (stringArray3 != null) {
                Tracker.autoloadMap.put(string, stringArray3);
            }
            Tracker.autoloadDataFunctions();
            this.refreshAutoloadData();
            for (String string2 : TrackDataBuilder.this.getPanelNames()) {
                object = (DataFunctionPanel)TrackDataBuilder.this.getPanel(string2);
                TrackDataBuilder.this.addPanel(string2, (FunctionPanel)object);
            }
        }

        @Override
        protected boolean isFunctionSelected(String string, String[] stringArray) {
            String[] stringArray2 = Tracker.autoloadMap.get(string);
            if (stringArray2 == null) {
                return true;
            }
            String[] stringArray3 = stringArray2;
            int n = stringArray2.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray3[n2];
                if (string2.equals("*")) {
                    return false;
                }
                if (string2.equals(stringArray[0])) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Override
        protected void setFileSelected(String string, boolean bl) {
            Tracker.autoloadMap.remove(string);
            if (!bl) {
                String[] object = new String[]{"*"};
                Tracker.autoloadMap.put(string, object);
            }
            Tracker.autoloadDataFunctions();
            this.refreshAutoloadData();
            for (String string2 : TrackDataBuilder.this.getPanelNames()) {
                DataFunctionPanel dataFunctionPanel = (DataFunctionPanel)TrackDataBuilder.this.getPanel(string2);
                TrackDataBuilder.this.addPanel(string2, dataFunctionPanel);
            }
        }

        @Override
        protected TristateCheckBox.State getFileSelectionState(String string) {
            String[] stringArray = Tracker.autoloadMap.get(string);
            if (stringArray == null) {
                return TristateCheckBox.SELECTED;
            }
            if (stringArray[0].equals("*")) {
                return TristateCheckBox.NOT_SELECTED;
            }
            return TristateCheckBox.PART_SELECTED;
        }

        @Override
        protected void refreshAutoloadData() {
            TreeMap<String, Map<String, ArrayList<String[]>>> treeMap = new TreeMap<String, Map<String, ArrayList<String[]>>>();
            for (String string : this.getSearchPaths()) {
                Map<String, ArrayList<String[]>> map = Tracker.findDataFunctions(string);
                treeMap.put(string, map);
            }
            this.setAutoloadData(treeMap);
        }

        @Override
        public Collection<String> getSearchPaths() {
            Collection<String> collection = super.getSearchPaths();
            if (collection.isEmpty() && !this.initialized) {
                this.initialized = true;
                for (String string : Tracker.getInitialSearchPaths()) {
                    collection.add(string);
                    this.addSearchPath(string);
                }
            }
            return collection;
        }
    }
}

