/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PlotTrackView;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TableTView;
import org.opensourcephysics.cabrillo.tracker.TrackPlottingPanel;
import org.opensourcephysics.cabrillo.tracker.TrackRenderer;
import org.opensourcephysics.cabrillo.tracker.TrackView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.tools.FontSizer;

public abstract class TrackChooserTView
extends JPanel
implements TView {
    protected TrackerPanel trackerPanel;
    protected Map<TTrack, TrackView> trackViews = new HashMap<TTrack, TrackView>();
    protected Map<Object, TTrack> tracks = new HashMap<Object, TTrack>();
    protected JComboBox dropdown;
    protected ArrayList<Component> toolbarComponents = new ArrayList();
    protected boolean refreshing;
    protected TTrack selectedTrack;
    protected JPanel noData;
    protected JLabel noDataLabel;

    protected TrackChooserTView(TrackerPanel trackerPanel) {
        super(new CardLayout());
        this.trackerPanel = trackerPanel;
        this.init();
        this.setBackground(trackerPanel.getBackground());
        this.dropdown = new JComboBox(){

            @Override
            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                Dimension dimension2 = this.getPreferredSize();
                dimension.width = dimension2.width;
                Dimension dimension3 = this.getMinimumSize();
                Container container = this.getParent().getParent();
                if (container instanceof TViewChooser) {
                    int n = ((TViewChooser)container).chooserButton.getHeight();
                    dimension.height = Math.max(n, dimension3.height);
                }
                return dimension;
            }
        };
        this.dropdown.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 1));
        this.toolbarComponents.add(this.dropdown);
        TrackRenderer trackRenderer = new TrackRenderer();
        this.dropdown.setRenderer(trackRenderer);
        this.dropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TrackChooserTView.this.refreshing) {
                    return;
                }
                Object object = TrackChooserTView.this.dropdown.getSelectedItem();
                TTrack tTrack = TrackChooserTView.this.tracks.get(object);
                String string = (String)((Object[])object)[1];
                if (tTrack != null) {
                    Serializable serializable;
                    Object object3;
                    TrackChooserTView.this.trackerPanel.changed = true;
                    TrackView trackView = TrackChooserTView.this.getTrackView(tTrack);
                    TTrack tTrack2 = TrackChooserTView.this.selectedTrack;
                    TrackView trackView2 = null;
                    if (tTrack2 != null) {
                        trackView2 = TrackChooserTView.this.getTrackView(tTrack2);
                        tTrack2.removePropertyChangeListener("step", trackView2);
                        tTrack2.removePropertyChangeListener("steps", trackView2);
                        if (trackView2 instanceof PlotTrackView) {
                            object3 = (PlotTrackView)trackView2;
                            serializable = ((PlotTrackView)object3).plots[0];
                            for (TTrack object22 : ((TrackPlottingPanel)serializable).guests) {
                                object22.removePropertyChangeListener("step", trackView2);
                                object22.removePropertyChangeListener("steps", trackView2);
                            }
                        }
                    }
                    tTrack.addPropertyChangeListener("step", trackView);
                    tTrack.addPropertyChangeListener("steps", trackView);
                    if (trackView instanceof PlotTrackView) {
                        object3 = (PlotTrackView)trackView;
                        serializable = ((PlotTrackView)object3).plots[0];
                        for (TTrack tTrack3 : ((TrackPlottingPanel)serializable).guests) {
                            tTrack3.addPropertyChangeListener("step", trackView);
                            tTrack3.addPropertyChangeListener("steps", trackView);
                        }
                    }
                    TrackChooserTView.this.selectedTrack = tTrack;
                    object3 = TrackChooserTView.this.trackerPanel.getSelectedStep();
                    if (object3 != null && ((Step)object3).getTrack() == tTrack) {
                        trackView.refresh(((Step)object3).getFrameNumber());
                    } else {
                        trackView.refresh(TrackChooserTView.this.trackerPanel.getFrameNumber());
                    }
                    serializable = (CardLayout)TrackChooserTView.this.getLayout();
                    ((CardLayout)serializable).show(TrackChooserTView.this, string);
                    TrackChooserTView.this.repaint();
                    TrackChooserTView.this.firePropertyChange("trackview", trackView, trackView2);
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "track", null, tTrack);
                    for (TTrack tTrack4 : TrackChooserTView.this.trackViews.keySet()) {
                        TrackView trackView3 = TrackChooserTView.this.trackViews.get(tTrack4);
                        trackView3.propertyChange(propertyChangeEvent);
                    }
                }
            }
        });
        this.noData = new JPanel();
        this.noDataLabel = new JLabel();
        Font font = new JTextField().getFont();
        this.noDataLabel.setFont(font);
        this.noData.add(this.noDataLabel);
        this.noData.setBackground(this.getBackground());
        this.noData.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem(String.valueOf(TrackerRes.getString("Dialog.Button.Help")) + "...");
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (TrackChooserTView.this instanceof TableTView) {
                                (this).TrackChooserTView.this.trackerPanel.getTFrame().showHelp("datatable", 0);
                            } else {
                                (this).TrackChooserTView.this.trackerPanel.getTFrame().showHelp("plot", 0);
                            }
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                    jPopupMenu.show(TrackChooserTView.this.noData, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    @Override
    public void refresh() {
        Tracker.logTime(String.valueOf(this.getClass().getSimpleName()) + this.hashCode() + " refresh");
        this.refreshing = true;
        TTrack tTrack = this.getSelectedTrack();
        TTrack tTrack2 = null;
        HashMap<TTrack, TrackView> hashMap = new HashMap<TTrack, TrackView>();
        this.removeAll();
        this.tracks.clear();
        this.dropdown.removeAllItems();
        for (TTrack tTrack3 : this.trackerPanel.getTracks()) {
            TrackView trackView;
            if (!tTrack3.isViewable()) continue;
            if (tTrack2 == null) {
                tTrack2 = tTrack3;
            }
            if ((trackView = this.getTrackView(tTrack3)) == null) {
                trackView = this.createTrackView(tTrack3);
            }
            trackView.refreshGUI();
            hashMap.put(tTrack3, trackView);
            Object[] objectArray = new Object[]{trackView.getIcon(), tTrack3.getName()};
            this.dropdown.addItem(objectArray);
            this.add((Component)trackView, tTrack3.getName());
            this.tracks.put(objectArray, tTrack3);
        }
        this.validate();
        this.trackViews = hashMap;
        this.refreshing = false;
        if (tTrack != null && this.getTrackView(tTrack) != null) {
            this.setSelectedTrack(tTrack);
        } else {
            this.setSelectedTrack(tTrack2);
        }
        this.dropdown.setToolTipText(TrackerRes.getString("TrackChooserTView.DropDown.Tooltip"));
    }

    protected void refreshMenus() {
    }

    @Override
    public void init() {
        this.cleanup();
        this.trackerPanel.addPropertyChangeListener("track", this);
        this.trackerPanel.addPropertyChangeListener("transform", this);
        this.trackerPanel.addPropertyChangeListener("stepnumber", this);
        this.trackerPanel.addPropertyChangeListener("image", this);
        this.trackerPanel.addPropertyChangeListener("data", this);
        this.trackerPanel.addPropertyChangeListener("radian_angles", this);
        this.trackerPanel.addPropertyChangeListener("function", this);
        for (TTrack tTrack : this.trackerPanel.getTracks()) {
            tTrack.addPropertyChangeListener("name", this);
            tTrack.addPropertyChangeListener("color", this);
            tTrack.addPropertyChangeListener("footprint", this);
            tTrack.addPropertyChangeListener("data", this);
        }
    }

    @Override
    public void cleanup() {
        this.trackerPanel.removePropertyChangeListener("track", this);
        this.trackerPanel.removePropertyChangeListener("transform", this);
        this.trackerPanel.removePropertyChangeListener("stepnumber", this);
        this.trackerPanel.removePropertyChangeListener("image", this);
        this.trackerPanel.removePropertyChangeListener("data", this);
        this.trackerPanel.removePropertyChangeListener("radian_angles", this);
        this.trackerPanel.removePropertyChangeListener("function", this);
        for (TTrack tTrack : this.trackerPanel.getTracks()) {
            tTrack.removePropertyChangeListener("name", this);
            tTrack.removePropertyChangeListener("color", this);
            tTrack.removePropertyChangeListener("footprint", this);
            tTrack.removePropertyChangeListener("data", this);
        }
    }

    @Override
    public TrackerPanel getTrackerPanel() {
        return this.trackerPanel;
    }

    public TTrack getSelectedTrack() {
        return this.selectedTrack;
    }

    public void setSelectedTrack(TTrack tTrack) {
        if (tTrack == null) {
            this.add((Component)this.noData, "noData");
            this.selectedTrack = null;
            return;
        }
        if (!tTrack.isViewable() || !this.trackerPanel.containsTrack(tTrack)) {
            return;
        }
        if (tTrack == this.selectedTrack && this.tracks.get(this.dropdown.getSelectedItem()) == tTrack) {
            return;
        }
        for (Object object : this.tracks.keySet()) {
            if (this.tracks.get(object) != tTrack) continue;
            tTrack.removePropertyChangeListener("stepnumber", this);
            tTrack.removePropertyChangeListener("image", this);
            tTrack.removePropertyChangeListener("name", this);
            tTrack.removePropertyChangeListener("color", this);
            tTrack.removePropertyChangeListener("footprint", this);
            tTrack.removePropertyChangeListener("data", this);
            tTrack.addPropertyChangeListener("stepnumber", this);
            tTrack.addPropertyChangeListener("image", this);
            tTrack.addPropertyChangeListener("name", this);
            tTrack.addPropertyChangeListener("color", this);
            tTrack.addPropertyChangeListener("footprint", this);
            tTrack.addPropertyChangeListener("data", this);
            this.dropdown.setSelectedItem(object);
            break;
        }
    }

    public TrackView getTrackView(TTrack tTrack) {
        return this.trackViews.get(tTrack);
    }

    @Override
    public abstract String getViewName();

    @Override
    public ArrayList<Component> getToolBarComponents() {
        this.toolbarComponents.clear();
        TrackView trackView = this.getTrackView(this.getSelectedTrack());
        if (trackView != null) {
            this.toolbarComponents.add(trackView.getViewButton());
        }
        if (this.dropdown.getItemCount() > 0) {
            this.toolbarComponents.add(this.dropdown);
        }
        if (trackView != null) {
            this.toolbarComponents.addAll(trackView.getToolBarComponents());
        }
        return this.toolbarComponents;
    }

    @Override
    public boolean isCustomState() {
        if (this.tracks.size() > 1) {
            for (TTrack object2 : this.trackerPanel.getUserTracks()) {
                if (!object2.isViewable()) continue;
                if (object2 == this.selectedTrack) break;
                return true;
            }
        }
        Iterator<TTrack> iterator = this.trackViews.keySet().iterator();
        while (iterator.hasNext()) {
            TrackView trackView = this.trackViews.get(iterator.next());
            if (!trackView.isCustomState()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("track")) {
            Container container;
            TTrack tTrack = (TTrack)propertyChangeEvent.getOldValue();
            if (tTrack != null) {
                tTrack.removePropertyChangeListener("name", this);
                tTrack.removePropertyChangeListener("color", this);
                tTrack.removePropertyChangeListener("footprint", this);
                tTrack.removePropertyChangeListener("data", this);
                container = this.trackViews.get(tTrack);
                if (container != null) {
                    ((TrackView)container).dispose();
                }
            }
            this.refresh();
            container = this.trackerPanel.getTFrame();
            if (container != null) {
                container.repaint();
            }
            if ((tTrack = (TTrack)propertyChangeEvent.getNewValue()) != null) {
                this.setSelectedTrack(tTrack);
            }
        } else if (string.equals("transform")) {
            TTrack tTrack = this.getSelectedTrack();
            if (tTrack != null && this.getTrackView(tTrack) != null) {
                Object object;
                if (tTrack instanceof ParticleModel && ((ImageCoordSystem)(object = this.trackerPanel.getCoords())).isAdjusting()) {
                    return;
                }
                object = this.getTrackView(tTrack);
                ((TrackView)object).refresh(this.trackerPanel.getFrameNumber());
            }
        } else if (string.equals("data")) {
            TTrack tTrack = this.getSelectedTrack();
            if (tTrack != null && this.getTrackView(tTrack) != null) {
                TrackView trackView = this.getTrackView(tTrack);
                trackView.refresh(this.trackerPanel.getFrameNumber());
            }
        } else if (string.equals("function") || string.equals("radian_angles")) {
            for (TTrack tTrack : this.trackerPanel.getTracks()) {
                if (this.getTrackView(tTrack) == null) continue;
                TrackView trackView = this.getTrackView(tTrack);
                trackView.refreshGUI();
                trackView.refresh(this.trackerPanel.getFrameNumber());
            }
        } else if (string.equals("stepnumber") || string.equals("image")) {
            TTrack tTrack = this.getSelectedTrack();
            if (tTrack != null && this.getTrackView(tTrack) != null) {
                TrackView trackView = this.getTrackView(tTrack);
                trackView.refresh(this.trackerPanel.getFrameNumber());
            }
        } else if (string.equals("color") || string.equals("name") || string.equals("footprint")) {
            this.refresh();
        }
    }

    protected abstract TrackView createTrackView(TTrack var1);

    protected TTrack getTrack(String string) {
        for (TTrack tTrack : this.trackerPanel.getTracks()) {
            if (!tTrack.getName().equals(string)) continue;
            return tTrack;
        }
        return null;
    }
}

