/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import org.opensourcephysics.cabrillo.tracker.MainTView;
import org.opensourcephysics.cabrillo.tracker.PageTView;
import org.opensourcephysics.cabrillo.tracker.PlotTView;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TableTView;
import org.opensourcephysics.cabrillo.tracker.TrackChooserTView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.WorldTView;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.tools.FontSizer;

public class TViewChooser
extends JPanel
implements PropertyChangeListener {
    protected static Icon maxIcon = new ResizableIcon(Tracker.class.getResource("resources/images/maximize.gif"));
    protected static Icon restoreIcon = new ResizableIcon(Tracker.class.getResource("resources/images/restore.gif"));
    protected TrackerPanel trackerPanel;
    protected ArrayList<TView> views = new ArrayList();
    protected TView selectedView;
    protected JPanel viewPanel;
    protected JToolBar toolbar;
    protected JButton chooserButton;
    protected Component toolbarFiller = Box.createHorizontalGlue();
    protected JButton maximizeButton;
    protected JPopupMenu popup = new JPopupMenu();
    protected int[] dividerLocs = new int[4];
    protected int dividerSize;
    protected boolean maximized;

    public TViewChooser(TrackerPanel trackerPanel) {
        super(new BorderLayout());
        this.trackerPanel = trackerPanel;
        this.trackerPanel.addPropertyChangeListener("track", this);
        this.viewPanel = new JPanel(new CardLayout());
        this.viewPanel.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.viewPanel, "Center");
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TViewChooser.this.toolbar.requestFocusInWindow();
                if (mouseEvent.getClickCount() == 2) {
                    TViewChooser.this.maximizeButton.doClick(0);
                }
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    final TView tView = TViewChooser.this.getSelectedView();
                    if (tView == null) {
                        return;
                    }
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem(String.valueOf(TrackerRes.getString("Dialog.Button.Help")) + "...");
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (tView instanceof PageTView) {
                                (this).TViewChooser.this.trackerPanel.getTFrame().showHelp("textview", 0);
                            } else if (tView instanceof TableTView) {
                                (this).TViewChooser.this.trackerPanel.getTFrame().showHelp("datatable", 0);
                            } else if (tView instanceof PlotTView) {
                                (this).TViewChooser.this.trackerPanel.getTFrame().showHelp("plot", 0);
                            } else if (tView instanceof WorldTView) {
                                (this).TViewChooser.this.trackerPanel.getTFrame().showHelp("GUI", 0);
                            }
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                    jPopupMenu.show(TViewChooser.this.toolbar, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.toolbar.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.toolbar, "North");
        this.chooserButton = new TButton(){

            @Override
            protected JPopupMenu getPopup() {
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = actionEvent.getActionCommand();
                        TViewChooser.this.setSelectedView(TViewChooser.this.getView(string));
                    }
                };
                TViewChooser.this.popup.removeAll();
                for (TView tView : TViewChooser.this.getViews()) {
                    String string = tView.getViewName();
                    JMenuItem jMenuItem = new JMenuItem(string, new ResizableIcon(tView.getViewIcon()));
                    jMenuItem.setActionCommand(string);
                    jMenuItem.addActionListener(actionListener);
                    TViewChooser.this.popup.add(jMenuItem);
                }
                FontSizer.setFonts(TViewChooser.this.popup, FontSizer.getLevel());
                return TViewChooser.this.popup;
            }
        };
        Border border = BorderFactory.createEmptyBorder(7, 3, 7, 3);
        Border border2 = BorderFactory.createEtchedBorder();
        this.maximizeButton = new TButton(maxIcon, restoreIcon);
        this.maximizeButton.setBorder(BorderFactory.createCompoundBorder(border2, border));
        this.maximizeButton.setToolTipText(TrackerRes.getString("TViewChooser.Maximize.Tooltip"));
        this.maximizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TViewChooser.this.maximized) {
                    TViewChooser.this.maximize();
                } else {
                    TViewChooser.this.restore();
                }
                TViewChooser.this.maximizeButton.setSelected(TViewChooser.this.maximized);
                TViewChooser.this.maximizeButton.setToolTipText(TViewChooser.this.maximized ? TrackerRes.getString("TViewChooser.Restore.Tooltip") : TrackerRes.getString("TViewChooser.Maximize.Tooltip"));
            }
        });
        this.createDefaultViews();
        this.refresh();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public TrackerPanel getTrackerPanel() {
        return this.trackerPanel;
    }

    public void addView(TView tView) {
        if (tView == null || tView.getTrackerPanel() != this.trackerPanel) {
            return;
        }
        if (this.getView(tView.getClass()) != null) {
            return;
        }
        this.views.add(tView);
        tView.cleanup();
        this.refreshViewPanel();
    }

    public void addView(int n, TView tView) {
        if (tView.getTrackerPanel() != this.trackerPanel) {
            return;
        }
        if (this.getView(tView.getClass()) != null) {
            return;
        }
        this.views.add(n, tView);
        tView.cleanup();
        this.refreshViewPanel();
    }

    public void removeView(TView tView) {
        this.views.remove(tView);
        if (tView == this.selectedView) {
            this.selectedView = null;
        }
        this.refreshViewPanel();
    }

    public Collection<TView> getViews() {
        return this.views;
    }

    public TView getView(String string) {
        for (TView tView : this.getViews()) {
            if (!tView.getViewName().equals(string)) continue;
            return tView;
        }
        return null;
    }

    public Collection<TView> getViews(Class<? extends TView> clazz) {
        ArrayList<TView> arrayList = new ArrayList<TView>();
        for (TView tView : arrayList) {
            if (!clazz.isInstance(tView)) continue;
            arrayList.add(tView);
        }
        return arrayList;
    }

    public TView getView(Class<?> clazz) {
        for (TView tView : this.getViews()) {
            if (tView.getClass() != clazz) continue;
            return tView;
        }
        return null;
    }

    public TView getSelectedView() {
        return this.selectedView;
    }

    public void setSelectedView(TView tView) {
        if (tView == null || this.selectedView == tView) {
            return;
        }
        if (!this.getViews().contains(tView)) {
            this.addView(tView);
        }
        this.trackerPanel.changed = true;
        TTrack tTrack = null;
        if (this.selectedView != null) {
            this.selectedView.cleanup();
            ((JComponent)((Object)this.selectedView)).removePropertyChangeListener("trackview", this);
            if (this.selectedView instanceof TrackChooserTView) {
                tTrack = ((TrackChooserTView)this.selectedView).getSelectedTrack();
            }
        }
        this.selectedView = tView;
        this.selectedView.init();
        ((JComponent)((Object)this.selectedView)).addPropertyChangeListener("trackview", this);
        if (this.selectedView instanceof TrackChooserTView) {
            ((TrackChooserTView)this.selectedView).setSelectedTrack(tTrack);
        }
        this.selectedView.refresh();
        this.chooserButton.setIcon(new ResizableIcon(this.selectedView.getViewIcon()));
        CardLayout cardLayout = (CardLayout)this.viewPanel.getLayout();
        cardLayout.show(this.viewPanel, this.selectedView.getViewName());
        this.repaint();
        this.refreshToolbar();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("track")) {
            if (this.selectedView != null) {
                this.selectedView.propertyChange(propertyChangeEvent);
                this.refreshToolbar();
            }
        } else if (string.equals("trackview")) {
            this.refreshToolbar();
        }
    }

    public void refresh() {
        this.chooserButton.setToolTipText(TrackerRes.getString("TViewChooser.Button.Choose.Tooltip"));
        for (TView tView : this.getViews()) {
            tView.refresh();
        }
    }

    public void refreshMenus() {
        for (TView tView : this.getViews()) {
            if (!(tView instanceof TrackChooserTView)) continue;
            TrackChooserTView trackChooserTView = (TrackChooserTView)tView;
            trackChooserTView.refreshMenus();
        }
    }

    public void maximize() {
        Component component;
        if (this.maximized) {
            return;
        }
        TFrame tFrame = this.trackerPanel.getTFrame();
        MainTView mainTView = tFrame.getMainView(this.trackerPanel);
        boolean bl = false;
        Component[] componentArray = mainTView.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            component = componentArray[n2];
            bl = bl || component == mainTView.getPlayerBar();
            ++n2;
        }
        if (bl) {
            component = mainTView.getPlayerBar();
            this.add(component, "South");
            ((JToolBar)component).setFloatable(false);
        }
        int n3 = 0;
        while (n3 < this.dividerLocs.length) {
            JSplitPane jSplitPane = tFrame.getSplitPane(this.trackerPanel, n3);
            this.dividerLocs[n3] = jSplitPane.getDividerLocation();
            if (jSplitPane.getDividerSize() > 0) {
                this.dividerSize = jSplitPane.getDividerSize();
            }
            jSplitPane.setDividerSize(0);
            ++n3;
        }
        this.maximized = true;
        Container[] containerArray = tFrame.getViews(this.trackerPanel);
        int n4 = 0;
        while (n4 < containerArray.length) {
            if (this == containerArray[n4]) {
                switch (n4) {
                    case 0: {
                        tFrame.setDividerLocation(this.trackerPanel, 0, 0.0);
                        tFrame.setDividerLocation(this.trackerPanel, 1, 1.0);
                        break;
                    }
                    case 1: {
                        tFrame.setDividerLocation(this.trackerPanel, 0, 0.0);
                        tFrame.setDividerLocation(this.trackerPanel, 1, 0.0);
                        break;
                    }
                    case 2: {
                        tFrame.setDividerLocation(this.trackerPanel, 0, 1.0);
                        tFrame.setDividerLocation(this.trackerPanel, 2, 0.0);
                        tFrame.setDividerLocation(this.trackerPanel, 3, 0.0);
                        break;
                    }
                    case 3: {
                        tFrame.setDividerLocation(this.trackerPanel, 0, 1.0);
                        tFrame.setDividerLocation(this.trackerPanel, 2, 0.0);
                        tFrame.setDividerLocation(this.trackerPanel, 3, 1.0);
                    }
                }
            }
            ++n4;
        }
    }

    public void restore() {
        Component component;
        TFrame tFrame = this.trackerPanel.getTFrame();
        MainTView mainTView = tFrame.getMainView(this.trackerPanel);
        boolean bl = false;
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            component = componentArray[n2];
            bl = bl || component == mainTView.getPlayerBar();
            ++n2;
        }
        if (bl) {
            component = mainTView.getPlayerBar();
            mainTView.add(component, "South");
            ((JToolBar)component).setFloatable(true);
        }
        int n3 = 0;
        while (n3 < this.dividerLocs.length) {
            JSplitPane jSplitPane = tFrame.getSplitPane(this.trackerPanel, n3);
            jSplitPane.setDividerSize(this.dividerSize);
            tFrame.setDividerLocation(this.trackerPanel, n3, this.dividerLocs[n3]);
            ++n3;
        }
        this.maximized = false;
    }

    protected void createDefaultViews() {
        this.addView(new PlotTView(this.trackerPanel));
        this.addView(new TableTView(this.trackerPanel));
        WorldTView worldTView = new WorldTView(this.trackerPanel);
        this.addView(worldTView);
        this.addView(new PageTView(this.trackerPanel));
    }

    protected void refreshToolbar() {
        this.toolbar.removeAll();
        this.toolbar.add(this.chooserButton);
        ArrayList<Component> arrayList = this.selectedView.getToolBarComponents();
        if (arrayList != null) {
            for (Component component : arrayList) {
                this.toolbar.add(component);
            }
        }
        this.toolbar.add(this.toolbarFiller);
        this.toolbar.add(this.maximizeButton);
        FontSizer.setFonts(this.toolbar, FontSizer.getLevel());
        this.toolbar.repaint();
    }

    private void refreshViewPanel() {
        this.viewPanel.removeAll();
        for (TView tView : this.getViews()) {
            String string = tView.getViewName();
            this.viewPanel.add((Component)((JComponent)((Object)tView)), string);
        }
        if (this.selectedView != null && this.getViews().contains(this.selectedView)) {
            this.setSelectedView(this.selectedView);
        } else {
            Iterator<TView> iterator = this.getViews().iterator();
            if (iterator.hasNext()) {
                this.setSelectedView(iterator.next());
            }
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            TViewChooser tViewChooser = (TViewChooser)object;
            xMLControl.setValue("selected_view", tViewChooser.selectedView);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            TViewChooser tViewChooser = (TViewChooser)object;
            TView tView = (TView)xMLControl.getObject("selected_view");
            if (tView != null) {
                tViewChooser.setSelectedView(tView);
            }
            return object;
        }
    }
}

