/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import org.opensourcephysics.cabrillo.tracker.AnalyticParticle;
import org.opensourcephysics.cabrillo.tracker.Calibration;
import org.opensourcephysics.cabrillo.tracker.CenterOfMass;
import org.opensourcephysics.cabrillo.tracker.CenterOfMassInspector;
import org.opensourcephysics.cabrillo.tracker.CircleFitter;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.DataTrackTool;
import org.opensourcephysics.cabrillo.tracker.DynamicParticle;
import org.opensourcephysics.cabrillo.tracker.DynamicParticlePolar;
import org.opensourcephysics.cabrillo.tracker.DynamicSystem;
import org.opensourcephysics.cabrillo.tracker.DynamicSystemInspector;
import org.opensourcephysics.cabrillo.tracker.ExportZipDialog;
import org.opensourcephysics.cabrillo.tracker.LineProfile;
import org.opensourcephysics.cabrillo.tracker.OffsetOrigin;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PropertiesDialog;
import org.opensourcephysics.cabrillo.tracker.Protractor;
import org.opensourcephysics.cabrillo.tracker.ProtractorStep;
import org.opensourcephysics.cabrillo.tracker.RGBRegion;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.cabrillo.tracker.VectorSum;
import org.opensourcephysics.cabrillo.tracker.VectorSumInspector;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.FilterStack;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class TActions {
    static Map<TrackerPanel, Map<String, AbstractAction>> actionMaps = new HashMap<TrackerPanel, Map<String, AbstractAction>>();
    static String newline = System.getProperty("line.separator", "\n");

    private TActions() {
    }

    public static Action getAction(String string, TrackerPanel trackerPanel) {
        return TActions.getActions(trackerPanel).get(string);
    }

    public static void clear() {
        actionMaps.clear();
    }

    public static Map<String, AbstractAction> getActions(final TrackerPanel trackerPanel) {
        Map<String, AbstractAction> map = actionMaps.get(trackerPanel);
        if (map != null) {
            return map;
        }
        map = new HashMap<String, AbstractAction>();
        actionMaps.put(trackerPanel, map);
        AbstractAction abstractAction = new AbstractAction(TrackerRes.getString("TActions.Action.ClearTracks"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                ArrayList<String> arrayList = new ArrayList<String>();
                boolean bl = false;
                ArrayList<Drawable> arrayList2 = trackerPanel.getSystemDrawables();
                for (TTrack tTrack : trackerPanel.getTracks()) {
                    if (arrayList2.contains(tTrack)) continue;
                    arrayList.add(new XMLControlElement(tTrack).toXML());
                    boolean bl2 = bl = bl || tTrack.isLocked() && !tTrack.isDependent();
                }
                if (bl && (n = JOptionPane.showConfirmDialog(trackerPanel, TrackerRes.getString("TActions.Dialog.DeleteLockedTracks.Message"), TrackerRes.getString("TActions.Dialog.DeleteLockedTracks.Title"), 0, 2)) != 0) {
                    return;
                }
                Undo.postTrackClear(trackerPanel, arrayList);
                trackerPanel.clearTracks();
            }
        };
        map.put("clearTracks", abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(TrackerRes.getString("TActions.Action.NewTab"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame tFrame = trackerPanel.getTFrame();
                if (tFrame != null) {
                    TrackerPanel trackerPanel2 = new TrackerPanel();
                    tFrame.addTab(trackerPanel2);
                    tFrame.setSelectedTab(trackerPanel2);
                    JSplitPane jSplitPane = tFrame.getSplitPane(trackerPanel2, 0);
                    jSplitPane.setDividerLocation(tFrame.defaultRightDivider);
                    tFrame.refresh();
                }
            }
        };
        map.put("newTab", abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction(TrackerRes.getString("TActions.Action.Paste")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TrackerIO.pasteXML(trackerPanel)) {
                    String string = DataTool.paste();
                    trackerPanel.importData(string, null);
                }
            }
        };
        map.put("paste", abstractAction3);
        ResizableIcon resizableIcon = new ResizableIcon(Tracker.class.getResource("resources/images/open.gif"));
        AbstractAction abstractAction4 = new AbstractAction(TrackerRes.getString("TActions.Action.Open"), resizableIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                trackerPanel.setSelectedPoint(null);
                trackerPanel.setMouseCursor(Cursor.getPredefinedCursor(3));
                TFrame tFrame = trackerPanel.getTFrame();
                if (tFrame != null) {
                    tFrame.setCursor(Cursor.getPredefinedCursor(3));
                    TrackerIO.open(null, tFrame);
                    tFrame.setCursor(Cursor.getDefaultCursor());
                }
            }
        };
        map.put("open", abstractAction4);
        AbstractAction abstractAction5 = new AbstractAction(TrackerRes.getString("TActions.Action.OpenURL")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = JOptionPane.showInputDialog(trackerPanel.getTFrame(), String.valueOf(TrackerRes.getString("TActions.Dialog.OpenURL.Message")) + ":                             ", TrackerRes.getString("TActions.Dialog.OpenURL.Title"), -1, null, null, null);
                if (object == null || object.toString().trim().equals("")) {
                    return;
                }
                Resource resource = ResourceLoader.getResource(object.toString().trim());
                if (resource == null || resource.getURL() == null) {
                    JOptionPane.showMessageDialog(trackerPanel.getTFrame(), String.valueOf(TrackerRes.getString("TActions.Dialog.URLResourceNotFound.Message")) + "\n\"" + object.toString().trim() + "\"", TrackerRes.getString("TActions.Dialog.URLResourceNotFound.Title"), 0);
                    return;
                }
                URL uRL = resource.getURL();
                trackerPanel.setSelectedPoint(null);
                trackerPanel.setMouseCursor(Cursor.getPredefinedCursor(3));
                TFrame tFrame = trackerPanel.getTFrame();
                if (tFrame != null) {
                    tFrame.setCursor(Cursor.getPredefinedCursor(3));
                    TrackerIO.open(uRL, tFrame);
                    tFrame.setCursor(Cursor.getDefaultCursor());
                }
            }
        };
        map.put("openURL", abstractAction5);
        resizableIcon = new ResizableIcon(Tracker.class.getResource("resources/images/open_catalog.gif"));
        AbstractAction abstractAction6 = new AbstractAction(TrackerRes.getString("TActions.Action.OpenBrowser"), resizableIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame tFrame = trackerPanel.getTFrame();
                if (tFrame != null) {
                    tFrame.getLibraryBrowser().setVisible(true);
                }
            }
        };
        map.put("openBrowser", abstractAction6);
        AbstractAction abstractAction7 = new AbstractAction(TrackerRes.getString("TActions.Action.Properties")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame tFrame = trackerPanel.getTFrame();
                if (tFrame != null) {
                    tFrame.getPropertiesDialog(trackerPanel).setVisible(true);
                }
            }
        };
        map.put("properties", abstractAction7);
        AbstractAction abstractAction8 = new AbstractAction(TrackerRes.getString("TActions.Action.Close")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame tFrame = trackerPanel.getTFrame();
                if (tFrame != null) {
                    tFrame.removeTab(trackerPanel);
                }
            }
        };
        map.put("close", abstractAction8);
        AbstractAction abstractAction9 = new AbstractAction(TrackerRes.getString("TActions.Action.CloseAll")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame tFrame = trackerPanel.getTFrame();
                if (tFrame != null) {
                    tFrame.removeAllTabs();
                }
            }
        };
        map.put("closeAll", abstractAction9);
        AbstractAction abstractAction10 = new AbstractAction(TrackerRes.getString("TActions.Action.ImportTRK")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackerIO.importFile(trackerPanel);
            }
        };
        map.put("import", abstractAction10);
        AbstractAction abstractAction11 = new AbstractAction(TrackerRes.getString("TActions.Action.ImportData")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TActions.getAction("dataTrack", trackerPanel).actionPerformed(actionEvent);
            }
        };
        map.put("importData", abstractAction11);
        resizableIcon = new ResizableIcon(Tracker.class.getResource("resources/images/save.gif"));
        AbstractAction abstractAction12 = new AbstractAction(TrackerRes.getString("TActions.Action.Save"), resizableIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackerIO.save(trackerPanel.getDataFile(), trackerPanel);
                trackerPanel.refreshNotesDialog();
            }
        };
        map.put("save", abstractAction12);
        AbstractAction abstractAction13 = new AbstractAction(TrackerRes.getString("TActions.Action.SaveAs"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackerIO.save(null, trackerPanel);
                trackerPanel.refreshNotesDialog();
            }
        };
        map.put("saveAs", abstractAction13);
        resizableIcon = new ResizableIcon(Tracker.class.getResource("resources/images/save_zip.gif"));
        AbstractAction abstractAction14 = new AbstractAction(String.valueOf(TrackerRes.getString("TActions.Action.SaveZip")) + "...", resizableIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportZipDialog exportZipDialog = ExportZipDialog.getDialog(trackerPanel);
                exportZipDialog.setVisible(true);
            }
        };
        map.put("saveZip", abstractAction14);
        AbstractAction abstractAction15 = new AbstractAction(TrackerRes.getString("TActions.Action.SaveFrame"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackerIO.saveTabset(null, trackerPanel.getTFrame());
                trackerPanel.refreshNotesDialog();
            }
        };
        map.put("saveTabsetAs", abstractAction15);
        AbstractAction abstractAction16 = new AbstractAction(TrackerRes.getString("TActions.Action.SaveVideoAs")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackerIO.saveVideo(null, trackerPanel);
            }
        };
        map.put("saveVideo", abstractAction16);
        AbstractAction abstractAction17 = new AbstractAction(TrackerRes.getString("TActions.Action.ImportTRK")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackerIO.exportFile(trackerPanel);
            }
        };
        map.put("export", abstractAction17);
        AbstractAction abstractAction18 = new AbstractAction(TrackerRes.getString("TActions.Action.Delete"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TTrack tTrack = trackerPanel.getTrack(actionEvent.getActionCommand());
                if (tTrack != null) {
                    tTrack.delete();
                }
            }
        };
        map.put("deleteTrack", abstractAction18);
        AbstractAction abstractAction19 = new AbstractAction(TrackerRes.getString("TActions.Action.Config"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame tFrame = trackerPanel.getTFrame();
                tFrame.showPrefsDialog();
            }
        };
        map.put("config", abstractAction19);
        resizableIcon = new ResizableIcon(Tracker.class.getResource("resources/images/axes.gif"));
        AbstractAction abstractAction20 = new AbstractAction(TrackerRes.getString("TActions.Action.AxesVisible"), resizableIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoordAxes coordAxes = trackerPanel.getAxes();
                if (coordAxes == null) {
                    return;
                }
                boolean bl = !coordAxes.isVisible();
                coordAxes.setVisible(bl);
                trackerPanel.setSelectedPoint(null);
                trackerPanel.hideMouseBox();
                if (bl && trackerPanel.getSelectedTrack() == null) {
                    trackerPanel.setSelectedTrack(coordAxes);
                } else if (!bl && trackerPanel.getSelectedTrack() == coordAxes) {
                    trackerPanel.setSelectedTrack(null);
                }
                trackerPanel.repaint();
            }
        };
        map.put("axesVisible", abstractAction20);
        AbstractAction abstractAction21 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Video video = trackerPanel.getVideo();
                if (video == null) {
                    return;
                }
                FilterStack filterStack = video.getFilterStack();
                Filter filter = null;
                Map<String, Class<? extends Filter>> map = trackerPanel.getFilters();
                Class<? extends Filter> clazz = map.get(actionEvent.getActionCommand());
                if (clazz != null) {
                    try {
                        filter = clazz.newInstance();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (filter != null) {
                        filterStack.addFilter(filter);
                        filter.setVideoPanel(trackerPanel);
                        JDialog jDialog = filter.getInspector();
                        if (jDialog != null) {
                            FontSizer.setFonts(jDialog, FontSizer.getLevel());
                            jDialog.pack();
                            jDialog.setVisible(true);
                        }
                    }
                }
                trackerPanel.repaint();
            }
        };
        map.put("videoFilter", abstractAction21);
        AbstractAction abstractAction22 = new AbstractAction(TrackerRes.getString("TActions.AboutVideo"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame tFrame = trackerPanel.getTFrame();
                if (tFrame != null) {
                    PropertiesDialog propertiesDialog = tFrame.getPropertiesDialog(trackerPanel);
                    if (trackerPanel.getVideo() != null) {
                        propertiesDialog.tabbedPane.setSelectedIndex(1);
                    }
                    propertiesDialog.setVisible(true);
                }
            }
        };
        map.put("aboutVideo", abstractAction22);
        AbstractAction abstractAction23 = new AbstractAction(TrackerRes.getString("TActions.Action.Print"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new TrackerIO.ComponentImage(trackerPanel).print();
            }
        };
        map.put("print", abstractAction23);
        AbstractAction abstractAction24 = new AbstractAction(TrackerRes.getString("TActions.Action.Exit"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame tFrame = trackerPanel.getTFrame();
                if (tFrame != null) {
                    int n = 0;
                    while (n < tFrame.getTabCount()) {
                        try {
                            if (!tFrame.getTrackerPanel(n).save()) {
                                return;
                            }
                        }
                        catch (Exception exception) {}
                        ++n;
                    }
                }
                System.exit(0);
            }
        };
        map.put("exit", abstractAction24);
        AbstractAction abstractAction25 = new AbstractAction(TrackerRes.getString("PointMass.Name"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PointMass pointMass = new PointMass();
                pointMass.setDefaultNameAndColor(trackerPanel, " ");
                trackerPanel.addTrack(pointMass);
                trackerPanel.setSelectedPoint(null);
                trackerPanel.setSelectedTrack(pointMass);
                trackerPanel.getPlayer().setStepNumber(0);
                ArrayList<CenterOfMass> arrayList = trackerPanel.getDrawables(CenterOfMass.class);
                if (arrayList.size() == 1) {
                    CenterOfMass centerOfMass = arrayList.get(0);
                    int n = JOptionPane.showConfirmDialog(trackerPanel, "Add " + pointMass.getName() + " to center of mass \"" + centerOfMass.getName() + "\"?" + newline + "Note: \"" + centerOfMass.getName() + "\" will disappear until  " + pointMass.getName() + " is marked!", TrackerRes.getString("TActions.Dialog.NewPointMass.Title"), 0, 3);
                    if (n == 0) {
                        centerOfMass.addMass(pointMass);
                    }
                }
            }
        };
        map.put("pointMass", abstractAction25);
        AbstractAction abstractAction26 = new AbstractAction(TrackerRes.getString("CenterOfMass.Name"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CenterOfMass centerOfMass = new CenterOfMass();
                centerOfMass.setDefaultNameAndColor(trackerPanel, " ");
                trackerPanel.addTrack(centerOfMass);
                trackerPanel.setSelectedPoint(null);
                trackerPanel.setSelectedTrack(centerOfMass);
                CenterOfMassInspector centerOfMassInspector = centerOfMass.getInspector();
                centerOfMassInspector.setVisible(true);
            }
        };
        map.put("cm", abstractAction26);
        AbstractAction abstractAction27 = new AbstractAction(TrackerRes.getString("Vector.Name"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Vector vector = new Vector();
                vector.setDefaultNameAndColor(trackerPanel, " ");
                trackerPanel.addTrack(vector);
                trackerPanel.setSelectedPoint(null);
                trackerPanel.setSelectedTrack(vector);
                trackerPanel.getPlayer().setStepNumber(0);
            }
        };
        map.put("vector", abstractAction27);
        AbstractAction abstractAction28 = new AbstractAction(TrackerRes.getString("VectorSum.Name"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VectorSum vectorSum = new VectorSum();
                vectorSum.setDefaultNameAndColor(trackerPanel, " ");
                trackerPanel.addTrack(vectorSum);
                trackerPanel.setSelectedPoint(null);
                trackerPanel.setSelectedTrack(vectorSum);
                VectorSumInspector vectorSumInspector = vectorSum.getInspector();
                vectorSumInspector.setVisible(true);
            }
        };
        map.put("vectorSum", abstractAction28);
        AbstractAction abstractAction29 = new AbstractAction(TrackerRes.getString("OffsetOrigin.Name"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OffsetOrigin offsetOrigin = new OffsetOrigin();
                offsetOrigin.setDefaultNameAndColor(trackerPanel, " ");
                trackerPanel.addTrack(offsetOrigin);
                trackerPanel.setSelectedPoint(null);
                trackerPanel.setSelectedTrack(offsetOrigin);
                trackerPanel.getAxes().setVisible(true);
            }
        };
        map.put("offsetOrigin", abstractAction29);
        AbstractAction abstractAction30 = new AbstractAction(TrackerRes.getString("Calibration.Name"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Calibration calibration = new Calibration();
                calibration.setDefaultNameAndColor(trackerPanel, " ");
                trackerPanel.addTrack(calibration);
                trackerPanel.setSelectedPoint(null);
                trackerPanel.setSelectedTrack(calibration);
                trackerPanel.getAxes().setVisible(true);
            }
        };
        map.put("calibration", abstractAction30);
        AbstractAction abstractAction31 = new AbstractAction(TrackerRes.getString("LineProfile.Name"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LineProfile lineProfile = new LineProfile();
                lineProfile.setDefaultNameAndColor(trackerPanel, " ");
                trackerPanel.addTrack(lineProfile);
                trackerPanel.setSelectedPoint(null);
                trackerPanel.setSelectedTrack(lineProfile);
            }
        };
        map.put("lineProfile", abstractAction31);
        AbstractAction abstractAction32 = new AbstractAction(TrackerRes.getString("RGBRegion.Name"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RGBRegion rGBRegion = new RGBRegion();
                rGBRegion.setDefaultNameAndColor(trackerPanel, " ");
                trackerPanel.addTrack(rGBRegion);
                trackerPanel.setSelectedPoint(null);
                trackerPanel.setSelectedTrack(rGBRegion);
                trackerPanel.getPlayer().setStepNumber(0);
            }
        };
        map.put("rgbRegion", abstractAction32);
        AbstractAction abstractAction33 = new AbstractAction(TrackerRes.getString("AnalyticParticle.Name"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyticParticle analyticParticle = new AnalyticParticle();
                analyticParticle.setDefaultNameAndColor(trackerPanel, " ");
                trackerPanel.addTrack(analyticParticle);
                trackerPanel.setSelectedPoint(null);
                trackerPanel.setSelectedTrack(analyticParticle);
                FunctionTool functionTool = analyticParticle.getInspector();
                analyticParticle.setStartFrame(trackerPanel.getPlayer().getVideoClip().getStartFrameNumber());
                functionTool.setVisible(true);
            }
        };
        map.put("analyticParticle", abstractAction33);
        AbstractAction abstractAction34 = new AbstractAction(TrackerRes.getString("DynamicParticle.Name"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicParticle dynamicParticle = new DynamicParticle();
                dynamicParticle.setDefaultNameAndColor(trackerPanel, " ");
                trackerPanel.addTrack(dynamicParticle);
                trackerPanel.setSelectedPoint(null);
                trackerPanel.setSelectedTrack(dynamicParticle);
                FunctionTool functionTool = dynamicParticle.getInspector();
                dynamicParticle.setStartFrame(trackerPanel.getPlayer().getVideoClip().getStartFrameNumber());
                functionTool.setVisible(true);
            }
        };
        map.put("dynamicParticle", abstractAction34);
        AbstractAction abstractAction35 = new AbstractAction(TrackerRes.getString("DynamicParticlePolar.Name"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicParticlePolar dynamicParticlePolar = new DynamicParticlePolar();
                dynamicParticlePolar.setDefaultNameAndColor(trackerPanel, " ");
                trackerPanel.addTrack(dynamicParticlePolar);
                trackerPanel.setSelectedPoint(null);
                trackerPanel.setSelectedTrack(dynamicParticlePolar);
                FunctionTool functionTool = dynamicParticlePolar.getInspector();
                dynamicParticlePolar.setStartFrame(trackerPanel.getPlayer().getVideoClip().getStartFrameNumber());
                functionTool.setVisible(true);
            }
        };
        map.put("dynamicParticlePolar", abstractAction35);
        AbstractAction abstractAction36 = new AbstractAction(TrackerRes.getString("DynamicSystem.Name"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicSystem dynamicSystem = new DynamicSystem();
                dynamicSystem.setDefaultNameAndColor(trackerPanel, " ");
                trackerPanel.addTrack(dynamicSystem);
                trackerPanel.setSelectedPoint(null);
                trackerPanel.setSelectedTrack(dynamicSystem);
                FunctionTool functionTool = dynamicSystem.getInspector();
                dynamicSystem.setStartFrame(trackerPanel.getPlayer().getVideoClip().getStartFrameNumber());
                functionTool.setVisible(true);
                DynamicSystemInspector dynamicSystemInspector = dynamicSystem.getSystemInspector();
                dynamicSystemInspector.setVisible(true);
            }
        };
        map.put("dynamicSystem", abstractAction36);
        AbstractAction abstractAction37 = new AbstractAction(TrackerRes.getString("ParticleDataTrack.Name"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File[] fileArray = TrackerIO.getChooserFiles("open data");
                if (fileArray == null) {
                    return;
                }
                String string = fileArray[0].getAbsolutePath();
                String string2 = XML.getExtension(string);
                if ("jar".equals(string2)) {
                    if (!DataTrackTool.isDataSource(string)) {
                        String string3 = String.valueOf(TrackerRes.getString("TActions.Action.DataTrack.Unsupported.JarFile")) + " \"" + XML.getName(string) + "\" ";
                        JOptionPane.showMessageDialog(trackerPanel.getTFrame(), String.valueOf(string3) + TrackerRes.getString("TActions.Action.DataTrack.Unsupported.Message") + ".", TrackerRes.getString("TActions.Action.DataTrack.Unsupported.Title"), 2);
                        return;
                    }
                    DataTrackTool.launchDataSource(string, true);
                } else {
                    trackerPanel.importData(string, null);
                }
            }
        };
        map.put("dataTrack", abstractAction37);
        String string = TrackerRes.getString("TapeMeasure.Name");
        AbstractAction abstractAction38 = new AbstractAction(string, null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TapeMeasure tapeMeasure = new TapeMeasure();
                tapeMeasure.setReadOnly(true);
                tapeMeasure.setDefaultNameAndColor(trackerPanel, " ");
                Rectangle rectangle = trackerPanel.getMat().mat;
                double d = rectangle.width / 2;
                double d2 = rectangle.height / 2;
                tapeMeasure.createStep(0, d - 50.0, d2 - 20.0, d + 50.0, d2 - 20.0);
                trackerPanel.addTrack(tapeMeasure);
                trackerPanel.setSelectedPoint(null);
                trackerPanel.setSelectedTrack(tapeMeasure);
            }
        };
        map.put("tape", abstractAction38);
        AbstractAction abstractAction39 = new AbstractAction(TrackerRes.getString("Protractor.Name"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Protractor protractor = new Protractor();
                protractor.setDefaultNameAndColor(trackerPanel, " ");
                Rectangle rectangle = trackerPanel.getMat().mat;
                double d = rectangle.width / 2;
                double d2 = rectangle.height / 2;
                ProtractorStep protractorStep = (ProtractorStep)protractor.getStep(0);
                protractorStep.handle.setXY(d, d2 - 30.0);
                trackerPanel.addTrack(protractor);
                trackerPanel.setSelectedPoint(null);
                trackerPanel.setSelectedTrack(protractor);
            }
        };
        map.put("protractor", abstractAction39);
        AbstractAction abstractAction40 = new AbstractAction(TrackerRes.getString("CircleFitter.Name"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CircleFitter circleFitter = new CircleFitter();
                circleFitter.setDefaultNameAndColor(trackerPanel, " ");
                trackerPanel.addTrack(circleFitter);
                trackerPanel.setSelectedPoint(null);
                trackerPanel.setSelectedTrack(circleFitter);
                circleFitter.getInspector().setVisible(true);
            }
        };
        map.put("circleFitter", abstractAction40);
        AbstractAction abstractAction41 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                TTrack tTrack = trackerPanel.getTrack(string);
                if (tTrack != null) {
                    Object object2;
                    int n = 1;
                    try {
                        object2 = string.substring(string.length() - 1);
                        n = Integer.parseInt((String)object2) + 1;
                        string = string.substring(0, string.length() - 1);
                    }
                    catch (Exception exception) {}
                    object2 = new HashSet();
                    for (TTrack object3 : trackerPanel.getTracks()) {
                        object2.add(object3.getName());
                    }
                    try {
                        while (object2.contains(String.valueOf(string) + n)) {
                            ++n;
                        }
                    }
                    catch (Exception exception) {}
                    XMLControlElement xMLControlElement = new XMLControlElement(tTrack);
                    xMLControlElement.setValue("name", String.valueOf(string) + n);
                    StringSelection stringSelection = new StringSelection(xMLControlElement.toXML());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, stringSelection);
                    TrackerIO.pasteXML(trackerPanel);
                }
            }
        };
        map.put("cloneTrack", abstractAction41);
        AbstractAction abstractAction42 = new AbstractAction(TrackerRes.getString("TActions.Action.ClearFilters"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Video video = trackerPanel.getVideo();
                if (video != null) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (Filter filter : video.getFilterStack().getFilters()) {
                        arrayList.add(new XMLControlElement(filter).toXML());
                    }
                    video.getFilterStack().clear();
                    Undo.postFilterClear(trackerPanel, arrayList);
                }
            }
        };
        map.put("clearFilters", abstractAction42);
        AbstractAction abstractAction43 = new AbstractAction(TrackerRes.getString("TActions.Action.ImportVideo"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackerIO.importVideo(trackerPanel);
            }
        };
        map.put("openVideo", abstractAction43);
        AbstractAction abstractAction44 = new AbstractAction(TrackerRes.getString("TActions.Action.CloseVideo"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                trackerPanel.setVideo(null);
                trackerPanel.repaint();
                trackerPanel.setImageSize(640.0, 480.0);
                TMenuBar.getMenuBar(trackerPanel).refresh();
            }
        };
        map.put("closeVideo", abstractAction44);
        AbstractAction abstractAction45 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                trackerPanel.setReferenceFrame(jMenuItem.getActionCommand());
            }
        };
        map.put("refFrame", abstractAction45);
        return map;
    }
}

