/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.util.HashSet;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;

public class StepSet
extends HashSet<Step> {
    TrackerPanel trackerPanel;
    boolean changed;
    XMLControl undoControl;

    public StepSet(TrackerPanel trackerPanel) {
        this.trackerPanel = trackerPanel;
    }

    @Override
    public boolean add(Step step) {
        if (!(step instanceof PositionStep)) {
            return false;
        }
        boolean bl = super.add(step);
        if (bl) {
            this.setChanged(false);
        }
        return bl;
    }

    @Override
    public boolean remove(Object object) {
        if (!(object instanceof PositionStep)) {
            return false;
        }
        boolean bl = super.remove(object);
        if (bl) {
            this.setChanged(false);
        }
        return bl;
    }

    public void setChanged(boolean bl) {
        if (bl && !this.changed) {
            this.undoControl = new XMLControlElement(this);
        }
        this.changed = bl;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public XMLControl getUndoControl() {
        return this.undoControl;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            StepSet stepSet = (StepSet)object;
            String[][] stringArray = new String[stepSet.size()][3];
            int n = 0;
            for (Step step : stepSet) {
                String string = new XMLControlElement(step).toXML();
                String[] stringArray2 = new String[]{step.getTrack().getName(), String.valueOf(step.getFrameNumber()), string};
                stringArray[n++] = stringArray2;
            }
            xMLControl.setValue("steps", stringArray);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            StepSet stepSet = (StepSet)object;
            String[][] stringArray = (String[][])xMLControl.getObject("steps");
            TrackerPanel trackerPanel = stepSet.trackerPanel;
            String[][] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                Step step;
                String[] stringArray3 = stringArray2[n2];
                TTrack tTrack = trackerPanel.getTrack(stringArray3[0]);
                if (tTrack != null && (step = tTrack.getStep(n3 = Integer.parseInt(stringArray3[1]))) != null) {
                    String string = stringArray3[2];
                    if (string.indexOf("<![CDATA[") != -1) {
                        string = string.substring(string.indexOf("<![CDATA[") + "<![CDATA[".length(), string.indexOf("]]>"));
                    }
                    XMLControlElement xMLControlElement = new XMLControlElement(string);
                    xMLControlElement.loadObject(step);
                    step.erase();
                }
                ++n2;
            }
            return object;
        }
    }
}

