/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TTrackBar;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.deploy.TrackerJarFilter;
import org.opensourcephysics.cabrillo.tracker.deploy.TrackerStarter;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.ExtensionsManager;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ResourceLoader;

public class PrefsDialog
extends JDialog {
    static final Color MEDIUM_RED = new Color(255, 120, 140);
    protected static boolean webStartWarningShown;
    protected static String userHome;
    protected static String javaHome;
    protected static FilenameFilter trackerJarFilter;
    protected static File codeBaseDir;
    protected TrackerPanel trackerPanel;
    protected TFrame frame;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JButton allButton;
    protected JButton noneButton;
    protected JButton applyButton;
    protected JButton saveButton;
    protected JButton relaunchButton;
    protected JButton clearRecentButton;
    protected JButton checkForUpgradeButton;
    protected JButton clearHostButton;
    protected JButton browseCacheButton;
    protected JButton clearCacheButton;
    protected JButton setCacheButton;
    protected JButton setRunButton;
    protected JTextField cacheField;
    protected JTextField runField;
    protected JPanel checkPanel;
    protected JPanel mainButtonBar;
    protected JTabbedPane tabbedPane;
    protected JPanel configPanel;
    protected JPanel runtimePanel;
    protected JPanel videoPanel;
    protected JPanel generalPanel;
    protected JPanel displayPanel;
    protected TitledBorder checkPanelBorder;
    protected TitledBorder lfSubPanelBorder;
    protected TitledBorder langSubPanelBorder;
    protected TitledBorder hintsSubPanelBorder;
    protected TitledBorder unitsSubPanelBorder;
    protected TitledBorder versionSubPanelBorder;
    protected TitledBorder jreSubPanelBorder;
    protected TitledBorder memorySubPanelBorder;
    protected TitledBorder runSubPanelBorder;
    protected TitledBorder videoTypeSubPanelBorder;
    protected TitledBorder xuggleSpeedSubPanelBorder;
    protected TitledBorder warningsSubPanelBorder;
    protected TitledBorder recentSubPanelBorder;
    protected TitledBorder cacheSubPanelBorder;
    protected TitledBorder logLevelSubPanelBorder;
    protected TitledBorder upgradeSubPanelBorder;
    protected TitledBorder fontSubPanelBorder;
    protected IntegerField memoryField;
    protected JLabel memoryLabel;
    protected JLabel recentSizeLabel;
    protected JLabel lookFeelLabel;
    protected JLabel cacheLabel;
    protected JLabel versionLabel;
    protected JLabel runLabel;
    protected JCheckBox defaultMemoryCheckbox;
    protected JCheckBox hintsCheckbox;
    protected JCheckBox vidWarningCheckbox;
    protected JCheckBox xuggleErrorCheckbox;
    protected JCheckBox variableDurationCheckBox;
    protected int memorySize = Tracker.requestedMemorySize;
    protected JSpinner recentSizeSpinner;
    protected JSpinner runSpinner;
    protected JComboBox lookFeelDropdown;
    protected JComboBox languageDropdown;
    protected JComboBox jreDropdown;
    protected JComboBox checkForUpgradeDropdown;
    protected JComboBox versionDropdown;
    protected JComboBox logLevelDropdown;
    protected JComboBox fontSizeDropdown;
    protected JRadioButton vm32Button;
    protected JRadioButton vm64Button;
    protected JRadioButton xuggleButton;
    protected JRadioButton qtButton;
    protected JRadioButton noEngineButton;
    protected JRadioButton radiansButton;
    protected JRadioButton degreesButton;
    protected JRadioButton xuggleFastButton;
    protected JRadioButton xuggleSlowButton;
    protected String[] trackerVersions;
    protected String recent32bitVM;
    protected String recent64bitVM;
    protected String recentEngine;
    private boolean refreshing = false;
    protected boolean relaunching = false;
    protected Set<String> prevEnabled = new TreeSet<String>();
    protected int prevMemory;
    protected int prevRecentCount;
    protected int prevUpgradeInterval;
    protected int prevFontLevel;
    protected String prevLookFeel;
    protected String prevLocaleName;
    protected String prevJRE;
    protected String prevTrackerJar;
    protected String prevEngine;
    protected boolean prevHints;
    protected boolean prevRadians;
    protected boolean prevFastXuggle;
    protected boolean prevWarnNoVideoEngine;
    protected boolean prevWarnXuggleError;
    protected boolean prevWarnXuggleVersion;
    protected boolean prevClearCacheOnExit;
    protected boolean prevUse32BitVM;
    protected boolean prevWarnCopyFailed;
    protected File prevCache;
    protected String[] prevExecutables;

    static {
        trackerJarFilter = new TrackerJarFilter();
        try {
            userHome = System.getProperty("user.home");
            javaHome = System.getProperty("java.home");
            URL uRL = TrackerStarter.class.getProtectionDomain().getCodeSource().getLocation();
            File file = new File(uRL.toURI());
            codeBaseDir = file.getParentFile();
        }
        catch (Exception exception) {}
    }

    public PrefsDialog(TrackerPanel trackerPanel, TFrame tFrame) {
        super((Frame)tFrame, false);
        this.trackerPanel = trackerPanel;
        this.frame = tFrame;
        this.setTitle(TrackerRes.getString("ConfigInspector.Title"));
        this.findTrackerJars();
        this.createGUI();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.savePrevious();
            this.findTrackerJars();
            this.refreshGUI();
        }
    }

    public void setFontLevel(int n) {
        JComboBox[] jComboBoxArray;
        FontSizer.setFonts(this, n);
        Object[] objectArray = new Object[]{this.checkPanelBorder, this.lfSubPanelBorder, this.langSubPanelBorder, this.hintsSubPanelBorder, this.unitsSubPanelBorder, this.versionSubPanelBorder, this.jreSubPanelBorder, this.memorySubPanelBorder, this.runSubPanelBorder, this.videoTypeSubPanelBorder, this.xuggleSpeedSubPanelBorder, this.warningsSubPanelBorder, this.recentSubPanelBorder, this.cacheSubPanelBorder, this.logLevelSubPanelBorder, this.upgradeSubPanelBorder, this.fontSubPanelBorder};
        FontSizer.setFonts(objectArray, n);
        JComboBox[] jComboBoxArray2 = jComboBoxArray = new JComboBox[]{this.lookFeelDropdown, this.languageDropdown, this.jreDropdown, this.checkForUpgradeDropdown, this.versionDropdown, this.logLevelDropdown};
        int n2 = jComboBoxArray.length;
        int n3 = 0;
        while (n3 < n2) {
            JComboBox jComboBox = jComboBoxArray2[n3];
            int n4 = jComboBox.getSelectedIndex();
            Object[] objectArray2 = new Object[jComboBox.getItemCount()];
            int n5 = 0;
            while (n5 < objectArray2.length) {
                objectArray2[n5] = jComboBox.getItemAt(n5);
                ++n5;
            }
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray2);
            jComboBox.setModel(defaultComboBoxModel);
            jComboBox.setSelectedItem(n4);
            ++n3;
        }
    }

    private void findTrackerJars() {
        if (Tracker.trackerHome == null || codeBaseDir == null) {
            this.trackerVersions = new String[]{"0"};
            return;
        }
        String string = OSPRuntime.isMac() ? codeBaseDir.getAbsolutePath() : Tracker.trackerHome;
        File file = new File(string);
        String[] stringArray = file.list(trackerJarFilter);
        if (stringArray != null && stringArray.length > 0) {
            TreeSet<String> treeSet = new TreeSet<String>();
            int n = 0;
            while (n < stringArray.length) {
                if ("tracker.jar".equals(stringArray[n].toLowerCase())) {
                    treeSet.add("0");
                } else {
                    treeSet.add(stringArray[n].substring(8, stringArray[n].length() - 4));
                }
                ++n;
            }
            this.trackerVersions = treeSet.toArray(new String[treeSet.size()]);
        }
    }

    private void createGUI() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Serializable serializable;
        JComponent jComponent;
        this.tabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        jPanel.add((Component)this.tabbedPane, "Center");
        this.okButton = new JButton();
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsDialog.this.applyPrefs();
                PrefsDialog.this.setVisible(false);
                if (PrefsDialog.this.frame != null) {
                    PrefsDialog.this.frame.refresh();
                }
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsDialog.this.revert();
                PrefsDialog.this.setVisible(false);
                if (PrefsDialog.this.frame != null) {
                    PrefsDialog.this.frame.refresh();
                }
            }
        });
        this.relaunchButton = new JButton();
        this.relaunchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsDialog.this.applyPrefs();
                ArrayList<String> arrayList = new ArrayList<String>();
                int n = 0;
                while (n < PrefsDialog.this.frame.getTabCount()) {
                    TrackerPanel trackerPanel = PrefsDialog.this.frame.getTrackerPanel(n);
                    if (!trackerPanel.save()) {
                        return;
                    }
                    File file = trackerPanel.getDataFile();
                    if (file != null) {
                        String string = file.getAbsolutePath();
                        arrayList.add(string);
                    }
                    ++n;
                }
                String[] stringArray = arrayList.isEmpty() ? null : arrayList.toArray(new String[0]);
                TrackerStarter.relaunch(stringArray, false);
            }
        });
        this.configPanel = new JPanel(new BorderLayout());
        this.tabbedPane.addTab(null, this.configPanel);
        Color color = Color.WHITE;
        int n = 1 + Tracker.getFullConfig().size() / 2;
        this.checkPanel = new JPanel(new GridLayout(n, 2));
        this.checkPanel.setBackground(color);
        this.checkPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("ConfigInspector.Border.Title"));
        this.checkPanel.setBorder(this.checkPanelBorder);
        for (String object72 : Tracker.getFullConfig()) {
            jComponent = new JCheckBoxMenuItem(object72);
            jComponent.setOpaque(false);
            this.checkPanel.add(jComponent);
        }
        JScrollPane jScrollPane = new JScrollPane(this.checkPanel);
        jScrollPane.setPreferredSize(new Dimension(380, 200));
        this.configPanel.add((Component)jScrollPane, "Center");
        this.applyButton = new JButton();
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsDialog.this.updateConfig();
                PrefsDialog.this.refreshGUI();
                PrefsDialog.this.frame.refresh();
            }
        });
        this.allButton = new JButton();
        this.allButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component[] componentArray = PrefsDialog.this.checkPanel.getComponents();
                int n = 0;
                while (n < componentArray.length) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)componentArray[n];
                    jCheckBoxMenuItem.setSelected(true);
                    ++n;
                }
            }
        });
        this.noneButton = new JButton();
        this.noneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component[] componentArray = PrefsDialog.this.checkPanel.getComponents();
                int n = 0;
                while (n < componentArray.length) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)componentArray[n];
                    jCheckBoxMenuItem.setSelected(false);
                    ++n;
                }
            }
        });
        this.saveButton = new JButton();
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsDialog.this.saveConfigAsDefault();
            }
        });
        jComponent = new JPanel();
        jComponent.add(this.allButton);
        jComponent.add(this.noneButton);
        jComponent.add(this.applyButton);
        jComponent.add(this.saveButton);
        this.configPanel.add((Component)jComponent, "North");
        Border border = BorderFactory.createEtchedBorder();
        this.displayPanel = new JPanel(new BorderLayout());
        this.tabbedPane.addTab(null, this.displayPanel);
        Box box = Box.createVerticalBox();
        this.displayPanel.add((Component)box, "Center");
        JPanel jPanel2 = new JPanel();
        box.add(jPanel2);
        jPanel2.setBackground(color);
        this.lfSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.LookFeel.BorderTitle"));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(border, this.lfSubPanelBorder));
        this.lookFeelDropdown = new JComboBox();
        this.lookFeelDropdown.addItem("DEFAULT".toLowerCase());
        String string = "DEFAULT";
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string2 : OSPRuntime.LOOK_AND_FEEL_TYPES.keySet()) {
            if (string2.equals("DEFAULT")) continue;
            treeSet.add(string2.toLowerCase());
            if (!string2.equals(Tracker.lookAndFeel)) continue;
            string = string2.toLowerCase();
        }
        for (String string3 : treeSet) {
            this.lookFeelDropdown.addItem(string3);
        }
        this.lookFeelDropdown.setSelectedItem(string);
        this.lookFeelDropdown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = PrefsDialog.this.lookFeelDropdown.getSelectedItem().toString().toUpperCase();
                if (!string.equals(Tracker.lookAndFeel)) {
                    Tracker.lookAndFeel = string;
                }
            }
        });
        jPanel2.add(this.lookFeelDropdown);
        JPanel jPanel3 = new JPanel();
        box.add(jPanel3);
        jPanel3.setBackground(color);
        this.langSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.Language.BorderTitle"));
        jPanel3.setBorder(BorderFactory.createCompoundBorder(border, this.langSubPanelBorder));
        this.languageDropdown = new JComboBox();
        Object object5 = TrackerRes.getString("PrefsDialog.Language.Default");
        this.languageDropdown.addItem(object5);
        Locale[] localeArray = Tracker.locales;
        int n2 = Tracker.locales.length;
        int n3 = 0;
        while (n3 < n2) {
            serializable = localeArray[n3];
            String string4 = OSPRuntime.getDisplayLanguage((Locale)serializable);
            this.languageDropdown.addItem(string4);
            if (((Locale)serializable).equals(Locale.getDefault()) && ((Locale)serializable).toString().equals(Tracker.preferredLocale)) {
                object5 = string4;
            }
            ++n3;
        }
        this.languageDropdown.setSelectedItem(object5);
        this.languageDropdown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = PrefsDialog.this.languageDropdown.getSelectedItem().toString();
                if (string.equals(TrackerRes.getString("PrefsDialog.Language.Default"))) {
                    Tracker.setPreferredLocale(null);
                } else {
                    Locale[] localeArray = Tracker.locales;
                    int n = Tracker.locales.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Locale locale = localeArray[n2];
                        if (string.equals(OSPRuntime.getDisplayLanguage(locale))) {
                            Tracker.setPreferredLocale(locale.toString());
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
        jPanel3.add(this.languageDropdown);
        serializable = new JPanel();
        box.add((Component)serializable);
        ((JComponent)serializable).setBackground(color);
        this.fontSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.FontSize.BorderTitle"));
        ((JComponent)serializable).setBorder(BorderFactory.createCompoundBorder(border, this.fontSubPanelBorder));
        this.fontSizeDropdown = new JComboBox();
        String string5 = TrackerRes.getString("TMenuBar.MenuItem.DefaultFontSize");
        this.fontSizeDropdown.addItem(string5);
        n2 = Tracker.preferredFontLevel + Tracker.preferredFontLevelPlus;
        int n4 = Math.max(n2, 6);
        int n5 = 1;
        while (n5 <= n4) {
            object4 = "+" + n5;
            this.fontSizeDropdown.addItem(object4);
            ++n5;
        }
        this.fontSizeDropdown.setSelectedIndex(n2);
        this.fontSizeDropdown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = PrefsDialog.this.fontSizeDropdown.getSelectedIndex();
                Tracker.preferredFontLevel = Math.min(n, 3);
                Tracker.preferredFontLevelPlus = n - Tracker.preferredFontLevel;
            }
        });
        ((Container)serializable).add(this.fontSizeDropdown);
        this.hintsCheckbox = new JCheckBox();
        this.hintsCheckbox.setOpaque(false);
        this.hintsCheckbox.setSelected(Tracker.showHintsByDefault);
        this.hintsCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracker.showHintsByDefault = PrefsDialog.this.hintsCheckbox.isSelected();
            }
        });
        JPanel jPanel4 = new JPanel();
        box.add(jPanel4);
        jPanel4.setBackground(color);
        this.hintsSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.Hints.BorderTitle"));
        jPanel4.setBorder(BorderFactory.createCompoundBorder(border, this.hintsSubPanelBorder));
        jPanel4.add(this.hintsCheckbox);
        object4 = new JPanel();
        box.add((Component)object4);
        ((JComponent)object4).setBackground(color);
        this.unitsSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("TMenuBar.Menu.AngleUnits"));
        ((JComponent)object4).setBorder(BorderFactory.createCompoundBorder(border, this.unitsSubPanelBorder));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.radiansButton = new JRadioButton();
        this.radiansButton.setOpaque(false);
        this.radiansButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        this.radiansButton.setSelected(Tracker.isRadians);
        buttonGroup.add(this.radiansButton);
        this.degreesButton = new JRadioButton();
        this.degreesButton.setOpaque(false);
        this.degreesButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        this.degreesButton.setSelected(!Tracker.isRadians);
        buttonGroup.add(this.degreesButton);
        ((Container)object4).add(this.radiansButton);
        ((Container)object4).add(this.degreesButton);
        this.runtimePanel = new JPanel(new BorderLayout());
        this.tabbedPane.addTab(null, this.runtimePanel);
        box = Box.createVerticalBox();
        this.runtimePanel.add((Component)box, "Center");
        JPanel jPanel5 = new JPanel();
        box.add(jPanel5);
        jPanel5.setBackground(color);
        this.versionSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.Version.BorderTitle"));
        jPanel5.setBorder(BorderFactory.createCompoundBorder(border, this.versionSubPanelBorder));
        int n6 = 0;
        this.versionDropdown = new JComboBox();
        int n7 = 0;
        while (n7 < this.trackerVersions.length) {
            object3 = this.trackerVersions[n7];
            if (((String)object3).equals("0")) {
                object2 = TrackerRes.getString("PrefsDialog.Version.Default");
                this.versionDropdown.addItem(object2);
            } else {
                this.versionDropdown.addItem(object3);
            }
            if (Tracker.preferredTrackerJar != null && Tracker.preferredTrackerJar.indexOf("tracker-") > -1 && Tracker.preferredTrackerJar.indexOf((String)object3) > -1) {
                n6 = n7;
            }
            ++n7;
        }
        this.versionDropdown.setSelectedIndex(n6);
        this.versionDropdown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Object object = PrefsDialog.this.versionDropdown.getSelectedItem();
                String string = null;
                if (object != null && !TrackerRes.getString("PrefsDialog.Version.Default").equals(object)) {
                    string = "tracker-" + object + ".jar";
                }
                if (string == null && Tracker.preferredTrackerJar != null) {
                    Tracker.preferredTrackerJar = null;
                } else if (string != null && !string.equals(Tracker.preferredTrackerJar)) {
                    Tracker.preferredTrackerJar = string;
                }
            }
        });
        jPanel5.add(this.versionDropdown);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        box.add(jPanel6);
        jPanel6.setBackground(color);
        this.jreSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.JRE.BorderTitle"));
        jPanel6.setBorder(BorderFactory.createCompoundBorder(border, this.jreSubPanelBorder));
        object3 = new JPanel();
        ((JComponent)object3).setBackground(color);
        jPanel6.add((Component)object3, "North");
        object2 = new JPanel();
        ((JComponent)object2).setBackground(color);
        jPanel6.add((Component)object2, "South");
        int n8 = OSPRuntime.getVMBitness();
        Tracker.use32BitMode = n8 == 32;
        this.vm32Button = new JRadioButton();
        this.vm32Button.setOpaque(false);
        this.vm32Button.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        this.vm32Button.setSelected(n8 == 32);
        this.vm32Button.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!PrefsDialog.this.vm32Button.isSelected()) {
                    return;
                }
                if (OSPRuntime.isMac()) {
                    Tracker.use32BitMode = true;
                    PrefsDialog.this.refreshJREDropdown(32);
                    if (PrefsDialog.this.qtButton.isSelected()) {
                        return;
                    }
                    int n = JOptionPane.showConfirmDialog(PrefsDialog.this.trackerPanel.getTFrame(), TrackerRes.getString("PrefsDialog.Dialog.SwitchTo32.Message"), TrackerRes.getString("PrefsDialog.Dialog.SwitchEngine.Title"), 2, 1, null);
                    if (n == 0) {
                        PrefsDialog.this.qtButton.setSelected(true);
                    } else {
                        Tracker.use32BitMode = false;
                        PrefsDialog.this.vm64Button.setSelected(true);
                    }
                } else if (OSPRuntime.isWindows()) {
                    PrefsDialog.this.refreshJREDropdown(32);
                    if (PrefsDialog.this.noEngineButton.isSelected()) {
                        Tracker.engineKnown = false;
                    }
                }
            }
        });
        ((Container)object3).add(this.vm32Button);
        this.vm64Button = new JRadioButton();
        this.vm64Button.setOpaque(false);
        this.vm64Button.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 0));
        this.vm64Button.setSelected(n8 == 64);
        this.vm64Button.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!PrefsDialog.this.vm64Button.isSelected()) {
                    return;
                }
                double d = VideoIO.guessXuggleVersion();
                if (OSPRuntime.isMac()) {
                    Tracker.use32BitMode = false;
                    PrefsDialog.this.refreshJREDropdown(64);
                    if (PrefsDialog.this.xuggleButton.isSelected() || PrefsDialog.this.noEngineButton.isSelected()) {
                        return;
                    }
                    if (d == 0.0) {
                        int n = JOptionPane.showConfirmDialog(PrefsDialog.this.trackerPanel.getTFrame(), String.valueOf(TrackerRes.getString("PrefsDialog.Dialog.NoEngineIn64bitVM.Message1")) + "\n" + TrackerRes.getString("PrefsDialog.Dialog.NoEngineIn64bitVM.Message2") + "\n\n" + TrackerRes.getString("PrefsDialog.Dialog.NoEngineIn64bitVM.Question"), TrackerRes.getString("PrefsDialog.Dialog.NoEngineIn64bitVM.Title"), 0, 2, null);
                        if (n == 0) {
                            PrefsDialog.this.noEngineButton.setSelected(true);
                        } else {
                            PrefsDialog.this.vm32Button.setSelected(true);
                        }
                        return;
                    }
                    int n = JOptionPane.showConfirmDialog(PrefsDialog.this.trackerPanel.getTFrame(), TrackerRes.getString("PrefsDialog.Dialog.SwitchTo64.Message"), TrackerRes.getString("PrefsDialog.Dialog.SwitchEngine.Title"), 2, 1, null);
                    if (n == 0) {
                        PrefsDialog.this.xuggleButton.setSelected(true);
                    } else {
                        Tracker.use32BitMode = true;
                        PrefsDialog.this.vm32Button.setSelected(true);
                    }
                } else if (OSPRuntime.isWindows()) {
                    PrefsDialog.this.refreshJREDropdown(64);
                    if (PrefsDialog.this.xuggleButton.isSelected() && d == 5.4) {
                        return;
                    }
                    if (PrefsDialog.this.noEngineButton.isSelected()) {
                        return;
                    }
                    if (d == 0.0 || d == 3.4) {
                        int n = JOptionPane.showConfirmDialog(PrefsDialog.this.trackerPanel.getTFrame(), String.valueOf(TrackerRes.getString("PrefsDialog.Dialog.NoEngineIn64bitVM.Message1")) + "\n" + TrackerRes.getString("PrefsDialog.Dialog.NoEngineIn64bitVM.Message2") + "\n\n" + TrackerRes.getString("PrefsDialog.Dialog.NoEngineIn64bitVM.Question"), TrackerRes.getString("PrefsDialog.Dialog.NoEngineIn64bitVM.Title"), 0, 2, null);
                        if (n == 0) {
                            PrefsDialog.this.noEngineButton.setSelected(true);
                        } else {
                            PrefsDialog.this.vm32Button.setSelected(true);
                        }
                        return;
                    }
                    PrefsDialog.this.xuggleButton.setSelected(true);
                    JOptionPane.showMessageDialog(PrefsDialog.this.trackerPanel.getTFrame(), TrackerRes.getString("PrefsDialog.Dialog.SwitchToXuggle.Message"), TrackerRes.getString("PrefsDialog.Dialog.SwitchToXuggle.Title"), 1);
                }
            }
        });
        ((Container)object3).add(this.vm64Button);
        this.jreDropdown = new JComboBox();
        String string6 = Tracker.preferredJRE;
        if (string6 == null && this.vm64Button.isSelected()) {
            string6 = Tracker.preferredJRE64;
        }
        if (string6 == null && this.vm32Button.isSelected()) {
            string6 = Tracker.preferredJRE32;
        }
        if (string6 == null) {
            string6 = System.getProperty("java.home");
        }
        this.jreDropdown.addItem(string6);
        this.jreDropdown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (PrefsDialog.this.refreshing) {
                    return;
                }
                Object object = PrefsDialog.this.jreDropdown.getSelectedItem();
                if (object == null) {
                    return;
                }
                if (PrefsDialog.this.vm64Button.isSelected()) {
                    PrefsDialog.this.recent64bitVM = object.toString();
                } else {
                    PrefsDialog.this.recent32bitVM = object.toString();
                }
            }
        });
        ((Container)object2).add(this.jreDropdown);
        this.refreshJREDropdown(n8);
        Border border2 = BorderFactory.createEtchedBorder();
        Border border3 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        border2 = BorderFactory.createCompoundBorder(border2, border3);
        JPanel jPanel7 = new JPanel();
        box.add(jPanel7);
        jPanel7.setBackground(color);
        this.memorySubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.Memory.BorderTitle"));
        jPanel7.setBorder(BorderFactory.createCompoundBorder(border, this.memorySubPanelBorder));
        jPanel7.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PrefsDialog.this.requestFocusInWindow();
            }
        });
        this.defaultMemoryCheckbox = new JCheckBox();
        this.defaultMemoryCheckbox.setOpaque(false);
        this.memoryLabel = new JLabel("MB");
        this.memoryField = new IntegerField(4);
        this.memoryField.setMinValue(Tracker.minimumMemorySize);
        this.memoryField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (PrefsDialog.this.memorySize != PrefsDialog.this.memoryField.getIntValue()) {
                    PrefsDialog.this.memorySize = PrefsDialog.this.memoryField.getIntValue();
                }
            }
        });
        this.memoryField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (PrefsDialog.this.defaultMemoryCheckbox.isSelected()) {
                    PrefsDialog.this.defaultMemoryCheckbox.doClick(0);
                }
            }
        });
        this.memoryField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsDialog.this.memorySize = PrefsDialog.this.memoryField.getIntValue();
            }
        });
        this.defaultMemoryCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = PrefsDialog.this.defaultMemoryCheckbox.isSelected();
                if (bl) {
                    PrefsDialog.this.memoryField.setEnabled(false);
                    PrefsDialog.this.memoryLabel.setEnabled(false);
                    PrefsDialog.this.memoryField.setText(null);
                } else {
                    PrefsDialog.this.memoryField.setEnabled(true);
                    PrefsDialog.this.memoryLabel.setEnabled(true);
                    PrefsDialog.this.memoryField.setValue(PrefsDialog.this.memorySize);
                    PrefsDialog.this.memoryField.requestFocusInWindow();
                    PrefsDialog.this.memoryField.selectAll();
                }
            }
        });
        if (Tracker.preferredMemorySize > -1) {
            this.memoryField.setValue(Tracker.preferredMemorySize);
        } else {
            this.defaultMemoryCheckbox.setSelected(true);
            this.memoryField.setEnabled(false);
            this.memoryLabel.setEnabled(false);
            this.memoryField.setText(null);
        }
        jPanel7.add(this.defaultMemoryCheckbox);
        jPanel7.add(Box.createRigidArea(new Dimension(40, 1)));
        jPanel7.add(this.memoryField);
        jPanel7.add(this.memoryLabel);
        JPanel jPanel8 = new JPanel();
        box.add(jPanel8);
        jPanel8.setBackground(color);
        this.runSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.Run.BorderTitle"));
        jPanel8.setBorder(BorderFactory.createCompoundBorder(border, this.runSubPanelBorder));
        final AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = PrefsDialog.this.runField.getText();
                int n = (Integer)PrefsDialog.this.runSpinner.getValue();
                ArrayList<String> arrayList = new ArrayList<String>();
                if (Tracker.prelaunchExecutables.length > n) {
                    if (string.equals(Tracker.prelaunchExecutables[n])) {
                        return;
                    }
                    if ("".equals(string)) {
                        Tracker.prelaunchExecutables[n] = string;
                        string = null;
                    } else {
                        Tracker.prelaunchExecutables[n] = string;
                        string = null;
                    }
                }
                String[] stringArray = Tracker.prelaunchExecutables;
                int n2 = Tracker.prelaunchExecutables.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string2 = stringArray[n3];
                    if (string2 != null && !"".equals(string2) && !arrayList.contains(string2)) {
                        arrayList.add(string2);
                    }
                    ++n3;
                }
                if (string != null && !"".equals(string) && !arrayList.contains(string)) {
                    arrayList.add(string);
                }
                Tracker.prelaunchExecutables = arrayList.toArray(new String[0]);
                int n4 = 0;
                while (n4 < Tracker.prelaunchExecutables.length) {
                    if (Tracker.prelaunchExecutables[n4].equals(string)) {
                        PrefsDialog.this.runSpinner.setValue(n4);
                        break;
                    }
                    ++n4;
                }
                PrefsDialog.this.refreshTextFields();
            }
        };
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0, 0, 6, 1);
        this.runSpinner = new JSpinner(spinnerNumberModel);
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this.runSpinner);
        this.runSpinner.setEditor(numberEditor);
        this.runSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (PrefsDialog.this.runField.getBackground() == Color.yellow) {
                    abstractAction.actionPerformed(null);
                } else {
                    PrefsDialog.this.refreshTextFields();
                }
            }
        });
        jPanel8.add(this.runSpinner);
        this.runField = new JTextField(27);
        jPanel8.add(this.runField);
        this.runField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                PrefsDialog.this.runField.setBackground(Color.yellow);
            }
        });
        this.runField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (PrefsDialog.this.runField.getBackground() == Color.yellow) {
                    abstractAction.actionPerformed(null);
                }
            }
        });
        this.runField.addActionListener(abstractAction);
        ImageIcon imageIcon = new ImageIcon(Tracker.class.getResource("resources/images/open.gif"));
        this.setRunButton = new TButton(imageIcon);
        this.setRunButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                int n = 1;
                File file2 = Tracker.trackerHome == null ? new File(".") : new File(Tracker.trackerHome);
                JFileChooser jFileChooser = PrefsDialog.getFileChooser(file2, false);
                jFileChooser.setDialogTitle(TrackerRes.getString("PrefsDialog.FileChooser.Title.Run"));
                n = jFileChooser.showOpenDialog(PrefsDialog.this);
                if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    PrefsDialog.this.runField.setText(file.getPath());
                    abstractAction.actionPerformed(null);
                }
            }
        });
        this.setRunButton.setBorder(border2);
        this.setRunButton.setContentAreaFilled(false);
        jPanel8.add(this.setRunButton);
        this.videoPanel = new JPanel(new BorderLayout());
        this.tabbedPane.addTab(null, this.videoPanel);
        box = Box.createVerticalBox();
        this.videoPanel.add((Component)box, "Center");
        JPanel jPanel9 = new JPanel();
        box.add(jPanel9);
        jPanel9.setBackground(color);
        this.videoTypeSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.VideoPref.BorderTitle"));
        jPanel9.setBorder(BorderFactory.createCompoundBorder(border, this.videoTypeSubPanelBorder));
        boolean bl = VideoIO.isEngineInstalled("Xuggle");
        this.xuggleButton = new JRadioButton();
        this.xuggleButton.setOpaque(false);
        this.xuggleButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        this.xuggleButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PrefsDialog.this.xuggleFastButton.setEnabled(PrefsDialog.this.xuggleButton.isSelected());
                PrefsDialog.this.xuggleSlowButton.setEnabled(PrefsDialog.this.xuggleButton.isSelected());
                PrefsDialog.this.xuggleErrorCheckbox.setEnabled(PrefsDialog.this.xuggleButton.isSelected());
                if (!PrefsDialog.this.xuggleButton.isSelected()) {
                    return;
                }
                Tracker.engineKnown = true;
                if (OSPRuntime.isMac() && PrefsDialog.this.vm32Button.isSelected()) {
                    int n = JOptionPane.showConfirmDialog(PrefsDialog.this.trackerPanel.getTFrame(), TrackerRes.getString("PrefsDialog.Dialog.SwitchToXuggle64.Message"), TrackerRes.getString("PrefsDialog.Dialog.SwitchVM.Title"), 2, 1, null);
                    if (n == 0) {
                        PrefsDialog.this.vm64Button.setSelected(true);
                    } else if (PrefsDialog.this.recentEngine.equals("QT")) {
                        PrefsDialog.this.qtButton.setSelected(true);
                    } else if (PrefsDialog.this.recentEngine.equals("none")) {
                        PrefsDialog.this.noEngineButton.setSelected(true);
                    }
                } else if (OSPRuntime.isWindows() && VideoIO.guessXuggleVersion() == 3.4 && PrefsDialog.this.vm64Button.isSelected()) {
                    boolean bl;
                    boolean bl2 = bl = ExtensionsManager.getManager().getDefaultJRE(32) != null;
                    if (bl) {
                        PrefsDialog.this.vm32Button.setSelected(true);
                        JOptionPane.showMessageDialog(PrefsDialog.this.trackerPanel.getTFrame(), TrackerRes.getString("PrefsDialog.Dialog.SwitchToXuggle32.Message"), TrackerRes.getString("PrefsDialog.Dialog.SwitchVM.Title"), 1);
                    } else {
                        Object[] objectArray = new Object[]{TrackerRes.getString("PrefsDialog.Button.ShowHelpNow"), TrackerRes.getString("Dialog.Button.OK")};
                        int n = JOptionPane.showOptionDialog(PrefsDialog.this.trackerPanel.getTFrame(), String.valueOf(TrackerRes.getString("PrefsDialog.Dialog.No32bitVMXuggle.Message")) + "\n" + TrackerRes.getString("PrefsDialog.Dialog.No32bitVM.Message"), TrackerRes.getString("PrefsDialog.Dialog.No32bitVM.Title"), 0, 2, null, objectArray, objectArray[0]);
                        PrefsDialog.this.noEngineButton.setSelected(true);
                        if (n == 0) {
                            PrefsDialog.this.trackerPanel.getTFrame().showHelp("install", 0);
                        }
                    }
                }
                if (PrefsDialog.this.xuggleButton.isSelected()) {
                    PrefsDialog.this.recentEngine = "Xuggle";
                }
            }
        });
        this.xuggleButton.setEnabled(bl);
        this.qtButton = new JRadioButton();
        this.qtButton.setOpaque(false);
        this.qtButton.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 0));
        this.qtButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl;
                if (!PrefsDialog.this.qtButton.isSelected()) {
                    return;
                }
                if (PrefsDialog.this.vm32Button.isSelected()) {
                    return;
                }
                Tracker.engineKnown = true;
                boolean bl2 = bl = OSPRuntime.isMac() || ExtensionsManager.getManager().getDefaultJRE(32) != null;
                if (bl) {
                    int n = JOptionPane.showConfirmDialog(PrefsDialog.this.trackerPanel.getTFrame(), TrackerRes.getString("PrefsDialog.Dialog.SwitchToQT.Message"), TrackerRes.getString("PrefsDialog.Dialog.SwitchVM.Title"), 2, 1, null);
                    if (n == 0) {
                        PrefsDialog.this.vm32Button.setSelected(true);
                    } else if (PrefsDialog.this.recentEngine.equals("Xuggle")) {
                        PrefsDialog.this.xuggleButton.setSelected(true);
                    } else if (PrefsDialog.this.recentEngine.equals("none")) {
                        PrefsDialog.this.noEngineButton.setSelected(true);
                    }
                } else {
                    Object[] objectArray = new Object[]{TrackerRes.getString("PrefsDialog.Button.ShowHelpNow"), TrackerRes.getString("Dialog.Button.OK")};
                    int n = JOptionPane.showOptionDialog(PrefsDialog.this.trackerPanel.getTFrame(), String.valueOf(TrackerRes.getString("PrefsDialog.Dialog.No32bitVMQT.Message")) + "\n" + TrackerRes.getString("PrefsDialog.Dialog.No32bitVM.Message"), TrackerRes.getString("PrefsDialog.Dialog.No32bitVM.Title"), 0, 2, null, objectArray, objectArray[0]);
                    PrefsDialog.this.noEngineButton.setSelected(true);
                    if (n == 0) {
                        PrefsDialog.this.trackerPanel.getTFrame().showHelp("install", 0);
                    }
                }
                if (PrefsDialog.this.qtButton.isSelected()) {
                    PrefsDialog.this.recentEngine = "QT";
                }
            }
        });
        this.qtButton.setEnabled(VideoIO.isEngineInstalled("QT"));
        this.noEngineButton = new JRadioButton();
        this.noEngineButton.setOpaque(false);
        this.noEngineButton.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 0));
        this.noEngineButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!PrefsDialog.this.noEngineButton.isSelected()) {
                    return;
                }
                PrefsDialog.this.recentEngine = "none";
                VideoIO.setEngine("none");
                Tracker.engineKnown = true;
            }
        });
        jPanel9.add(this.xuggleButton);
        jPanel9.add(this.qtButton);
        jPanel9.add(this.noEngineButton);
        JPanel jPanel10 = new JPanel();
        box.add(jPanel10);
        jPanel10.setBackground(color);
        this.xuggleSpeedSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.Xuggle.Speed.BorderTitle"));
        if (!bl) {
            this.xuggleSpeedSubPanelBorder.setTitleColor(new Color(153, 153, 153));
        }
        jPanel10.setBorder(BorderFactory.createCompoundBorder(border, this.xuggleSpeedSubPanelBorder));
        buttonGroup = new ButtonGroup();
        this.xuggleFastButton = new JRadioButton();
        this.xuggleFastButton.setOpaque(false);
        this.xuggleFastButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        this.xuggleFastButton.setSelected(bl && Tracker.isXuggleFast);
        buttonGroup.add(this.xuggleFastButton);
        this.xuggleSlowButton = new JRadioButton();
        this.xuggleSlowButton.setOpaque(false);
        this.xuggleSlowButton.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 0));
        this.xuggleSlowButton.setSelected(bl && !Tracker.isXuggleFast);
        buttonGroup.add(this.xuggleSlowButton);
        jPanel10.add(this.xuggleFastButton);
        jPanel10.add(this.xuggleSlowButton);
        this.vidWarningCheckbox = new JCheckBox();
        this.vidWarningCheckbox.setOpaque(false);
        this.vidWarningCheckbox.setSelected(Tracker.warnNoVideoEngine);
        this.vidWarningCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracker.warnNoVideoEngine = PrefsDialog.this.vidWarningCheckbox.isSelected();
            }
        });
        this.xuggleErrorCheckbox = new JCheckBox();
        this.xuggleErrorCheckbox.setOpaque(false);
        this.xuggleErrorCheckbox.setSelected(Tracker.warnXuggleError);
        this.xuggleErrorCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracker.warnXuggleError = PrefsDialog.this.xuggleErrorCheckbox.isSelected();
            }
        });
        this.variableDurationCheckBox = new JCheckBox();
        this.variableDurationCheckBox.setOpaque(false);
        this.variableDurationCheckBox.setSelected(Tracker.warnVariableDuration);
        this.variableDurationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracker.warnVariableDuration = PrefsDialog.this.variableDurationCheckBox.isSelected();
            }
        });
        JPanel jPanel11 = new JPanel(new BorderLayout());
        box.add(jPanel11);
        jPanel11.setBackground(color);
        this.warningsSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.NoVideoWarning.BorderTitle"));
        jPanel11.setBorder(BorderFactory.createCompoundBorder(border, this.warningsSubPanelBorder));
        JPanel jPanel12 = new JPanel();
        jPanel12.setBackground(color);
        jPanel11.add((Component)jPanel12, "North");
        JPanel jPanel13 = new JPanel();
        jPanel13.setBackground(color);
        JPanel jPanel14 = new JPanel();
        jPanel14.setBackground(color);
        JPanel jPanel15 = new JPanel(new BorderLayout());
        jPanel15.add((Component)jPanel13, "North");
        jPanel15.add((Component)jPanel14, "Center");
        jPanel11.add((Component)jPanel15, "Center");
        jPanel12.add(this.vidWarningCheckbox);
        jPanel12.add(this.variableDurationCheckBox);
        jPanel13.add(this.xuggleErrorCheckbox);
        if (VideoIO.getEngine().equals("QT") && VideoIO.getVideoType("QT", null) != null) {
            this.qtButton.setSelected(true);
        } else if (VideoIO.getEngine().equals("Xuggle") && VideoIO.getVideoType("Xuggle", null) != null) {
            this.xuggleButton.setSelected(true);
        } else {
            this.noEngineButton.setSelected(true);
        }
        this.generalPanel = new JPanel(new BorderLayout());
        this.tabbedPane.addTab(null, this.generalPanel);
        box = Box.createVerticalBox();
        this.generalPanel.add((Component)box, "Center");
        JPanel jPanel16 = new JPanel();
        box.add(jPanel16);
        jPanel16.setBackground(color);
        this.recentSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.RecentFiles.BorderTitle"));
        jPanel16.setBorder(BorderFactory.createCompoundBorder(border, this.recentSubPanelBorder));
        this.clearRecentButton = new JButton();
        this.clearRecentButton.setEnabled(!Tracker.recentFiles.isEmpty());
        this.clearRecentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracker.recentFiles.clear();
                if (PrefsDialog.this.trackerPanel != null) {
                    TMenuBar.getMenuBar(PrefsDialog.this.trackerPanel).refresh();
                }
                PrefsDialog.this.clearRecentButton.setEnabled(false);
            }
        });
        jPanel16.add(this.clearRecentButton);
        JPanel jPanel17 = new JPanel();
        jPanel17.setOpaque(false);
        jPanel17.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        n = Tracker.recentFilesSize;
        spinnerNumberModel = new SpinnerNumberModel(n, 0, 12, 1);
        this.recentSizeSpinner = new JSpinner(spinnerNumberModel);
        numberEditor = new JSpinner.NumberEditor(this.recentSizeSpinner, "0");
        numberEditor.getTextField().setHorizontalAlignment(2);
        this.recentSizeSpinner.setEditor(numberEditor);
        jPanel17.add(this.recentSizeSpinner);
        this.recentSizeLabel = new JLabel();
        jPanel17.add(this.recentSizeLabel);
        jPanel16.add(jPanel17);
        JPanel jPanel18 = new JPanel(new BorderLayout());
        box.add(jPanel18);
        jPanel18.setBackground(color);
        this.cacheSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.CacheFiles.BorderTitle"));
        jPanel18.setBorder(BorderFactory.createCompoundBorder(border, this.cacheSubPanelBorder));
        JPanel jPanel19 = new JPanel();
        jPanel19.setBackground(color);
        this.cacheLabel = new JLabel();
        jPanel19.add(this.cacheLabel);
        this.cacheField = new JTextField(27);
        jPanel19.add(this.cacheField);
        final AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = XML.stripExtension(PrefsDialog.this.cacheField.getText());
                Tracker.setCache(string);
                PrefsDialog.this.refreshTextFields();
            }
        };
        this.cacheField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                PrefsDialog.this.cacheField.setBackground(Color.yellow);
            }
        });
        this.cacheField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (PrefsDialog.this.cacheField.getBackground() == Color.yellow) {
                    abstractAction2.actionPerformed(null);
                }
            }
        });
        this.cacheField.addActionListener(abstractAction2);
        this.browseCacheButton = new TButton(imageIcon);
        this.browseCacheButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = ResourceLoader.getOSPCache();
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.open(file);
                }
                catch (IOException iOException) {}
            }
        });
        this.browseCacheButton.setBorder(border2);
        this.browseCacheButton.setContentAreaFilled(false);
        jPanel19.add(this.browseCacheButton);
        jPanel18.add((Component)jPanel19, "North");
        JPanel jPanel20 = new JPanel();
        jPanel20.setBackground(color);
        this.clearHostButton = new JButton();
        this.clearHostButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = ResourceLoader.getOSPCache();
                if (file == null) {
                    return;
                }
                final File[] fileArray = file.listFiles(ResourceLoader.OSP_CACHE_FILTER);
                JPopupMenu jPopupMenu = new JPopupMenu();
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        File[] fileArray2 = fileArray;
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray2[n2];
                            if (file.getAbsolutePath().equals(actionEvent.getActionCommand())) {
                                ResourceLoader.clearOSPCacheHost(file);
                                PrefsDialog.this.refreshTextFields();
                                return;
                            }
                            ++n2;
                        }
                    }
                };
                File[] fileArray2 = fileArray;
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file2 = fileArray2[n2];
                    String string = file2.getName().substring(4).replace('_', '.');
                    long l = PrefsDialog.this.getFileSize(file2);
                    long l2 = l / 0x100000L;
                    if (l > 0L) {
                        string = l2 > 0L ? String.valueOf(string) + " (" + l2 + " MB)" : String.valueOf(string) + " (" + l / 1024L + " kB)";
                    }
                    JMenuItem jMenuItem = new JMenuItem(string);
                    jMenuItem.setActionCommand(file2.getAbsolutePath());
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(actionListener);
                    ++n2;
                }
                FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                jPopupMenu.show(PrefsDialog.this.clearHostButton, 0, PrefsDialog.this.clearHostButton.getHeight());
            }
        });
        jPanel20.add(this.clearHostButton);
        this.clearCacheButton = new JButton();
        this.clearCacheButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = ResourceLoader.getOSPCache();
                ResourceLoader.clearOSPCache(file, false);
                PrefsDialog.this.refreshTextFields();
            }
        });
        jPanel20.add(this.clearCacheButton);
        this.setCacheButton = new JButton();
        this.setCacheButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = ResourceLoader.chooseOSPCache(PrefsDialog.this.trackerPanel.getTFrame());
                if (file != null) {
                    PrefsDialog.this.cacheField.setText(file.getPath());
                    abstractAction2.actionPerformed(null);
                }
            }
        });
        jPanel20.add(this.setCacheButton);
        jPanel18.add((Component)jPanel20, "South");
        this.checkForUpgradeButton = new JButton();
        this.checkForUpgradeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracker.loadCurrentVersion(true, false);
                Tracker.lastMillisChecked = System.currentTimeMillis();
                if (PrefsDialog.this.trackerPanel != null) {
                    TTrackBar.getTrackbar(PrefsDialog.this.trackerPanel).refresh();
                }
                String string = TrackerRes.getString("PrefsDialog.Dialog.NewVersion.None.Message");
                if (Tracker.newerVersion != null) {
                    string = String.valueOf(TrackerRes.getString("PrefsDialog.Dialog.NewVersion.Message1")) + " " + Tracker.newerVersion + " " + TrackerRes.getString("PrefsDialog.Dialog.NewVersion.Message2") + XML.NEW_LINE + Tracker.trackerWebsite;
                }
                JOptionPane.showMessageDialog(PrefsDialog.this, string, TrackerRes.getString("PrefsDialog.Dialog.NewVersion.Title"), 1);
            }
        });
        this.logLevelDropdown = new JComboBox();
        string5 = TrackerRes.getString("PrefsDialog.Version.Default").toUpperCase();
        string5 = String.valueOf(string5) + " (" + Tracker.DEFAULT_LOG_LEVEL.toString().toLowerCase() + ")";
        object5 = string5;
        this.logLevelDropdown.addItem(string5);
        int n9 = OSPLog.levels.length - 1;
        while (n9 >= 0) {
            String string7 = OSPLog.levels[n9].toString();
            this.logLevelDropdown.addItem(string7);
            if (OSPLog.levels[n9].equals(Tracker.preferredLogLevel) && !Tracker.preferredLogLevel.equals(Tracker.DEFAULT_LOG_LEVEL)) {
                object5 = string7;
            }
            --n9;
        }
        this.logLevelDropdown.setSelectedItem(object5);
        this.logLevelDropdown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = PrefsDialog.this.logLevelDropdown.getSelectedItem().toString();
                Level level = OSPLog.parseLevel(string);
                if (level == null) {
                    level = Tracker.DEFAULT_LOG_LEVEL;
                }
                Tracker.preferredLogLevel = level;
            }
        });
        JPanel jPanel21 = new JPanel();
        box.add(jPanel21);
        jPanel21.setBackground(color);
        this.logLevelSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.LogLevel.BorderTitle"));
        jPanel21.setBorder(BorderFactory.createCompoundBorder(border, this.logLevelSubPanelBorder));
        jPanel21.add(this.logLevelDropdown);
        this.checkForUpgradeDropdown = new JComboBox();
        object5 = null;
        for (String string8 : Tracker.checkForUpgradeChoices) {
            object = TrackerRes.getString(string8);
            this.checkForUpgradeDropdown.addItem(object);
            if (!Tracker.checkForUpgradeIntervals.get(string8).equals(Tracker.checkForUpgradeInterval)) continue;
            object5 = object;
        }
        this.checkForUpgradeDropdown.setSelectedItem(object5);
        this.checkForUpgradeDropdown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = PrefsDialog.this.checkForUpgradeDropdown.getSelectedItem().toString();
                for (String string2 : Tracker.checkForUpgradeChoices) {
                    if (!string.equals(TrackerRes.getString(string2))) continue;
                    Tracker.checkForUpgradeInterval = Tracker.checkForUpgradeIntervals.get(string2);
                    break;
                }
            }
        });
        JPanel jPanel22 = new JPanel();
        jPanel22.setOpaque(false);
        jPanel22.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        JPanel jPanel23 = new JPanel();
        box.add(jPanel23);
        jPanel23.setBackground(color);
        this.upgradeSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.Upgrades.BorderTitle"));
        jPanel23.setBorder(BorderFactory.createCompoundBorder(border, this.upgradeSubPanelBorder));
        jPanel23.add(this.checkForUpgradeButton);
        jPanel22.add(this.checkForUpgradeDropdown);
        jPanel23.add(jPanel22);
        this.mainButtonBar = new JPanel();
        this.mainButtonBar.add(this.relaunchButton);
        this.mainButtonBar.add(this.okButton);
        this.mainButtonBar.add(this.cancelButton);
        jPanel.add((Component)this.mainButtonBar, "South");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (PrefsDialog.this.tabbedPane.getSelectedComponent() == PrefsDialog.this.runtimePanel) {
                    PrefsDialog.this.defaultMemoryCheckbox.setEnabled(!OSPRuntime.isWebStart());
                    if (OSPRuntime.isWebStart() && !webStartWarningShown) {
                        webStartWarningShown = true;
                        JOptionPane.showMessageDialog(PrefsDialog.this, TrackerRes.getString("PrefsDialog.Dialog.WebStart.Message"), TrackerRes.getString("PrefsDialog.Dialog.WebStart.Title"), 1);
                    }
                }
            }
        });
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.vm32Button);
        buttonGroup.add(this.vm64Button);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.xuggleButton);
        buttonGroup.add(this.qtButton);
        buttonGroup.add(this.noEngineButton);
        this.xuggleFastButton.setEnabled(this.xuggleButton.isSelected());
        this.xuggleSlowButton.setEnabled(this.xuggleButton.isSelected());
        this.xuggleErrorCheckbox.setEnabled(this.xuggleButton.isSelected());
        if (OSPRuntime.isWindows()) {
            object = new Runnable(){

                @Override
                public void run() {
                    PrefsDialog.this.vm32Button.setEnabled(!ExtensionsManager.getManager().getPublicJREs(32).isEmpty());
                    PrefsDialog.this.vm64Button.setEnabled(!ExtensionsManager.getManager().getPublicJREs(64).isEmpty());
                }
            };
            new Thread((Runnable)object).start();
        } else if (OSPRuntime.isLinux()) {
            int n10 = OSPRuntime.getVMBitness();
            this.vm32Button.setEnabled(n10 == 32);
            this.vm64Button.setEnabled(n10 == 64);
        }
        this.refreshGUI();
    }

    private void savePrevious() {
        this.prevEnabled.clear();
        if (this.trackerPanel != null) {
            this.prevEnabled.addAll(this.trackerPanel.getEnabled());
        }
        this.prevMemory = Tracker.preferredMemorySize;
        this.prevLookFeel = Tracker.lookAndFeel;
        this.prevRecentCount = Tracker.recentFilesSize;
        this.prevLocaleName = Tracker.preferredLocale;
        this.prevFontLevel = Tracker.preferredFontLevel;
        this.prevHints = Tracker.showHintsByDefault;
        this.prevRadians = Tracker.isRadians;
        this.prevFastXuggle = Tracker.isXuggleFast;
        this.prevJRE = Tracker.preferredJRE;
        this.prevTrackerJar = Tracker.preferredTrackerJar;
        this.prevExecutables = Tracker.prelaunchExecutables;
        this.prevWarnNoVideoEngine = Tracker.warnNoVideoEngine;
        this.prevWarnXuggleError = Tracker.warnXuggleError;
        this.prevCache = ResourceLoader.getOSPCache();
        this.prevUpgradeInterval = Tracker.checkForUpgradeInterval;
        this.prevUse32BitVM = Tracker.use32BitMode;
        this.prevEngine = VideoIO.getEngine();
        this.recentEngine = VideoIO.getEngine();
    }

    private void revert() {
        if (this.trackerPanel != null) {
            this.trackerPanel.setEnabled(this.prevEnabled);
        }
        Tracker.preferredMemorySize = this.prevMemory;
        Tracker.lookAndFeel = this.prevLookFeel;
        Tracker.recentFilesSize = this.prevRecentCount;
        Tracker.setPreferredLocale(this.prevLocaleName);
        Tracker.preferredFontLevel = this.prevFontLevel;
        Tracker.showHintsByDefault = this.prevHints;
        Tracker.isRadians = this.prevRadians;
        Tracker.isXuggleFast = this.prevFastXuggle;
        Tracker.preferredJRE = this.prevJRE;
        Tracker.preferredTrackerJar = this.prevTrackerJar;
        Tracker.prelaunchExecutables = this.prevExecutables;
        Tracker.warnNoVideoEngine = this.prevWarnNoVideoEngine;
        Tracker.warnXuggleError = this.prevWarnXuggleError;
        ResourceLoader.setOSPCache(this.prevCache);
        Tracker.checkForUpgradeInterval = this.prevUpgradeInterval;
        Tracker.use32BitMode = this.prevUse32BitVM;
        int n = OSPRuntime.getVMBitness();
        if (n == 32) {
            this.recent32bitVM = null;
            this.vm32Button.setSelected(true);
        } else {
            this.recent64bitVM = null;
            this.vm64Button.setSelected(true);
        }
    }

    private void updateConfig() {
        if (this.trackerPanel == null) {
            return;
        }
        Component[] componentArray = this.checkPanel.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)componentArray[n];
            if (jCheckBoxMenuItem.isSelected()) {
                this.trackerPanel.getEnabled().add(jCheckBoxMenuItem.getText());
            } else {
                this.trackerPanel.getEnabled().remove(jCheckBoxMenuItem.getText());
            }
            ++n;
        }
    }

    protected void refreshGUI() {
        this.cancelButton.setText(TrackerRes.getString("Dialog.Button.Cancel"));
        this.saveButton.setText(TrackerRes.getString("ConfigInspector.Button.SaveAsDefault"));
        this.okButton.setText(TrackerRes.getString("PrefsDialog.Button.Save"));
        this.applyButton.setText(TrackerRes.getString("Dialog.Button.Apply"));
        this.applyButton.setEnabled(this.trackerPanel != null);
        this.allButton.setText(TrackerRes.getString("Dialog.Button.All"));
        this.noneButton.setText(TrackerRes.getString("Dialog.Button.None"));
        this.relaunchButton.setText(TrackerRes.getString("PrefsDialog.Button.Relaunch"));
        this.clearRecentButton.setText(TrackerRes.getString("PrefsDialog.Button.ClearRecent"));
        this.cacheLabel.setText(String.valueOf(TrackerRes.getString("PrefsDialog.Label.Path")) + ":");
        this.clearCacheButton.setToolTipText(TrackerRes.getString("PrefsDialog.Button.ClearCache.Tooltip"));
        this.clearHostButton.setText(TrackerRes.getString("PrefsDialog.Button.ClearHost"));
        this.clearHostButton.setToolTipText(TrackerRes.getString("PrefsDialog.Button.ClearHost.Tooltip"));
        this.setCacheButton.setText(TrackerRes.getString("PrefsDialog.Button.SetCache"));
        this.checkForUpgradeButton.setText(TrackerRes.getString("PrefsDialog.Button.CheckForUpgrade"));
        this.recentSizeLabel.setText(TrackerRes.getString("PrefsDialog.Label.RecentSize"));
        this.defaultMemoryCheckbox.setText(TrackerRes.getString("PrefsDialog.Checkbox.DefaultSize"));
        this.hintsCheckbox.setText(TrackerRes.getString("PrefsDialog.Checkbox.HintsOn"));
        this.vm32Button.setText(TrackerRes.getString("PrefsDialog.Checkbox.32BitVM"));
        this.vm64Button.setText(TrackerRes.getString("PrefsDialog.Checkbox.64BitVM"));
        this.xuggleButton.setText(TrackerRes.getString("PrefsDialog.Button.Xuggle"));
        this.qtButton.setText(TrackerRes.getString("PrefsDialog.Button.QT"));
        this.noEngineButton.setText(TrackerRes.getString("PrefsDialog.Button.NoEngine"));
        this.radiansButton.setText(TrackerRes.getString("TMenuBar.MenuItem.Radians"));
        this.degreesButton.setText(TrackerRes.getString("TMenuBar.MenuItem.Degrees"));
        this.xuggleFastButton.setText(TrackerRes.getString("PrefsDialog.Xuggle.Fast"));
        this.xuggleSlowButton.setText(TrackerRes.getString("PrefsDialog.Xuggle.Slow"));
        this.vidWarningCheckbox.setText(TrackerRes.getString("PrefsDialog.Checkbox.WarnIfNoEngine"));
        this.variableDurationCheckBox.setText(TrackerRes.getString("PrefsDialog.Checkbox.WarnVariableDuration"));
        this.xuggleErrorCheckbox.setText(TrackerRes.getString("PrefsDialog.Checkbox.WarnIfXuggleError"));
        this.setTabTitle(this.configPanel, TrackerRes.getString("PrefsDialog.Tab.Configuration.Title"));
        this.setTabTitle(this.runtimePanel, TrackerRes.getString("PrefsDialog.Tab.Runtime.Title"));
        this.setTabTitle(this.videoPanel, TrackerRes.getString("PrefsDialog.Tab.Video.Title"));
        this.setTabTitle(this.displayPanel, TrackerRes.getString("PrefsDialog.Tab.Display.Title"));
        this.setTabTitle(this.generalPanel, TrackerRes.getString("PrefsDialog.Tab.General.Title"));
        this.refreshTextFields();
        this.setFontLevel(FontSizer.getLevel());
        this.pack();
        this.updateDisplay();
    }

    private void refreshJREDropdown(final int n) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                while (!ExtensionsManager.isReady()) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        String string2;
                        PrefsDialog.this.refreshing = true;
                        (this).PrefsDialog.this.jreDropdown.removeAllItems();
                        ExtensionsManager extensionsManager = ExtensionsManager.getManager();
                        TreeSet<String> treeSet = extensionsManager.getAllJREs(n);
                        for (String string2 : treeSet) {
                            (this).PrefsDialog.this.jreDropdown.addItem(string2);
                        }
                        string2 = null;
                        if (n == 32 && (this).PrefsDialog.this.recent32bitVM != null) {
                            string2 = (this).PrefsDialog.this.recent32bitVM;
                        } else if (n == 64 && (this).PrefsDialog.this.recent64bitVM != null) {
                            string2 = (this).PrefsDialog.this.recent64bitVM;
                        }
                        if (!(string2 != null || (string2 = Tracker.preferredJRE) != null && treeSet.contains(string2))) {
                            String string3 = string2 = n == 32 ? Tracker.preferredJRE32 : Tracker.preferredJRE64;
                            if (string2 == null || !treeSet.contains(string2)) {
                                string2 = extensionsManager.getDefaultJRE(n);
                            }
                        }
                        (this).PrefsDialog.this.jreDropdown.setSelectedItem(string2);
                        if (n == 32) {
                            (this).PrefsDialog.this.recent32bitVM = string2;
                        } else {
                            (this).PrefsDialog.this.recent64bitVM = string2;
                        }
                        PrefsDialog.this.refreshing = false;
                        if (n == 32 && (this).PrefsDialog.this.relaunching && !"cancel".equals((this).PrefsDialog.this.vm32Button.getName())) {
                            (this).PrefsDialog.this.relaunching = false;
                            (this).PrefsDialog.this.relaunchButton.doClick(0);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        };
        new Thread(runnable).start();
    }

    private void refreshTextFields() {
        int n = (Integer)this.runSpinner.getValue();
        if (Tracker.prelaunchExecutables.length > n && Tracker.prelaunchExecutables[n] != null) {
            this.runField.setText(Tracker.prelaunchExecutables[n]);
            this.runField.setToolTipText(Tracker.prelaunchExecutables[n]);
            this.runField.setBackground(new File(Tracker.prelaunchExecutables[n]).exists() ? Color.white : MEDIUM_RED);
        } else {
            this.runField.setText(null);
            this.runField.setToolTipText(null);
            this.runField.setBackground(Color.white);
        }
        String string = TrackerRes.getString("PrefsDialog.Button.ClearCache");
        File file = ResourceLoader.getOSPCache();
        if (file != null) {
            this.cacheField.setText(file.getPath());
            this.cacheField.setToolTipText(file.getAbsolutePath());
            this.cacheField.setBackground(file.canWrite() ? Color.white : MEDIUM_RED);
            long l = this.getFileSize(file);
            long l2 = l / 0x100000L;
            if (l > 0L) {
                string = l2 > 0L ? String.valueOf(string) + " (" + l2 + " MB)" : String.valueOf(string) + " (" + l / 1024L + " kB)";
            }
        } else {
            this.cacheField.setText("");
            this.cacheField.setToolTipText("");
            this.cacheField.setBackground(MEDIUM_RED);
        }
        this.clearCacheButton.setText(string);
        boolean bl = file == null || !file.exists() || file.listFiles(ResourceLoader.OSP_CACHE_FILTER).length == 0;
        this.clearCacheButton.setEnabled(!bl);
        this.clearHostButton.setEnabled(!bl);
    }

    private void applyPrefs() {
        String string;
        this.updateConfig();
        Integer n = (Integer)this.recentSizeSpinner.getValue();
        Tracker.setRecentSize(n);
        if (this.trackerPanel != null) {
            TMenuBar.getMenuBar(this.trackerPanel).refresh();
        }
        Tracker.preferredMemorySize = this.defaultMemoryCheckbox.isSelected() ? -1 : this.memoryField.getIntValue();
        Object object = this.jreDropdown.getSelectedItem();
        if (object != null && !object.equals(Tracker.preferredJRE)) {
            Tracker.preferredJRE = object.toString();
            if (ExtensionsManager.getManager().is32BitVM(Tracker.preferredJRE)) {
                Tracker.preferredJRE32 = Tracker.preferredJRE;
            } else {
                Tracker.preferredJRE64 = Tracker.preferredJRE;
            }
        }
        if (this.xuggleButton.isSelected() && this.xuggleButton.isEnabled()) {
            VideoIO.setEngine("Xuggle");
        } else if (this.qtButton.isSelected() && this.qtButton.isEnabled()) {
            VideoIO.setEngine("QT");
        } else {
            VideoIO.setEngine("none");
        }
        Tracker.isRadians = this.radiansButton.isSelected();
        Tracker.isXuggleFast = this.xuggleFastButton.isSelected();
        if (this.frame != null) {
            this.frame.setAnglesInRadians(Tracker.isRadians);
        }
        if ((string = Tracker.savePreferences()) != null) {
            OSPLog.info("saved tracker preferences in " + XML.getAbsolutePath(new File(string)));
        }
    }

    private void saveConfigAsDefault() {
        Component[] componentArray = this.checkPanel.getComponents();
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = 0;
        while (n < componentArray.length) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)componentArray[n];
            if (jCheckBoxMenuItem.isSelected()) {
                treeSet.add(jCheckBoxMenuItem.getText());
            }
            ++n;
        }
        Tracker.setDefaultConfig(treeSet);
    }

    protected void updateDisplay() {
        Component[] componentArray = this.checkPanel.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)componentArray[n];
            Set<String> set = this.trackerPanel != null ? this.trackerPanel.getEnabled() : Tracker.getDefaultConfig();
            jCheckBoxMenuItem.setSelected(set.contains(jCheckBoxMenuItem.getText()));
            ++n;
        }
        this.defaultMemoryCheckbox.setSelected(Tracker.preferredMemorySize < 0);
        this.memoryField.setEnabled(Tracker.preferredMemorySize >= 0);
        this.memoryLabel.setEnabled(Tracker.preferredMemorySize >= 0);
        if (Tracker.preferredMemorySize >= 0) {
            this.memoryField.setValue(Tracker.preferredMemorySize);
        } else {
            this.memoryField.setText(null);
        }
        if (Tracker.lookAndFeel != null) {
            this.lookFeelDropdown.setSelectedItem(Tracker.lookAndFeel.toLowerCase());
        }
        this.recentSizeSpinner.setValue(Tracker.recentFilesSize);
        this.hintsCheckbox.setSelected(Tracker.showHintsByDefault);
        this.vidWarningCheckbox.setSelected(Tracker.warnNoVideoEngine);
        this.variableDurationCheckBox.setSelected(Tracker.warnVariableDuration);
        this.xuggleErrorCheckbox.setSelected(Tracker.warnXuggleError);
        Object object = Tracker.locales;
        int n2 = Tracker.locales.length;
        int n3 = 0;
        while (n3 < n2) {
            Locale locale = object[n3];
            if (locale.equals(Locale.getDefault())) {
                this.languageDropdown.setSelectedItem(OSPRuntime.getDisplayLanguage(locale));
                break;
            }
            ++n3;
        }
        int n4 = 0;
        n3 = 0;
        n2 = this.versionDropdown.getItemCount();
        while (n3 < n2) {
            object = this.versionDropdown.getItemAt(n3).toString();
            if (Tracker.preferredTrackerJar != null && Tracker.preferredTrackerJar.indexOf((String)object) > -1) {
                n4 = n3;
                break;
            }
            ++n3;
        }
        if (this.versionDropdown.getItemCount() > n4) {
            this.versionDropdown.setSelectedIndex(n4);
        }
        n4 = 0;
        n3 = 0;
        n2 = this.jreDropdown.getItemCount();
        while (n3 < n2) {
            object = this.jreDropdown.getItemAt(n3).toString();
            if (((String)object).equals(Tracker.preferredJRE)) {
                n4 = n3;
                break;
            }
            ++n3;
        }
        if (this.jreDropdown.getItemCount() > n4) {
            this.jreDropdown.setSelectedIndex(n4);
        }
        n4 = 0;
        if (!Tracker.preferredLogLevel.equals(Tracker.DEFAULT_LOG_LEVEL)) {
            n3 = 1;
            n2 = this.logLevelDropdown.getItemCount();
            while (n3 < n2) {
                object = this.logLevelDropdown.getItemAt(n3).toString();
                if (Tracker.preferredLogLevel.toString().equals(object)) {
                    n4 = n3;
                    break;
                }
                ++n3;
            }
        }
        if (this.logLevelDropdown.getItemCount() > n4) {
            this.logLevelDropdown.setSelectedIndex(n4);
        }
        n4 = 0;
        n3 = 1;
        n2 = Tracker.checkForUpgradeChoices.size();
        while (n3 < n2) {
            object = Tracker.checkForUpgradeChoices.get(n3);
            if (Tracker.checkForUpgradeIntervals.get(object) == Tracker.checkForUpgradeInterval) {
                n4 = n3;
                break;
            }
            ++n3;
        }
        if (this.checkForUpgradeDropdown.getItemCount() > n4) {
            this.checkForUpgradeDropdown.setSelectedIndex(n4);
        }
        if (VideoIO.getEngine().equals("QT")) {
            this.qtButton.setSelected(true);
        } else if (VideoIO.getEngine().equals("Xuggle")) {
            this.xuggleButton.setSelected(true);
        }
        this.qtButton.setEnabled(true);
        this.vm32Button.setEnabled(true);
        this.repaint();
    }

    private void setTabTitle(JPanel jPanel, String string) {
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            if (this.tabbedPane.getComponentAt(n) == jPanel) {
                this.tabbedPane.setTitleAt(n, string);
            }
            ++n;
        }
    }

    protected void relaunch32Bit() {
        this.relaunching = true;
        this.vm32Button.setSelected(true);
    }

    private long getFileSize(File file) {
        File[] fileArray;
        if (file == null) {
            return 0L;
        }
        long l = 0L;
        File file2 = ResourceLoader.getOSPCache();
        File[] fileArray2 = fileArray = file.equals(file2) ? file.listFiles(ResourceLoader.OSP_CACHE_FILTER) : file.listFiles();
        if (fileArray == null) {
            return 0L;
        }
        int n = 0;
        while (n < fileArray.length) {
            l = fileArray[n].isDirectory() ? (l += this.getFileSize(fileArray[n])) : (l += fileArray[n].length());
            ++n;
        }
        return l;
    }

    protected static JFileChooser getFileChooser(File file, boolean bl) {
        JFileChooser jFileChooser = new JFileChooser(file);
        if (bl) {
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file == null) {
                        return false;
                    }
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (file.getPath().indexOf("jre") > -1) {
                        return true;
                    }
                    return file.getPath().indexOf("jdk") > -1;
                }

                @Override
                public String getDescription() {
                    return TrackerRes.getString("PrefsDialog.FileFilter.JRE");
                }
            };
            if (OSPRuntime.isMac()) {
                jFileChooser.setFileSelectionMode(2);
            } else {
                jFileChooser.setFileSelectionMode(1);
            }
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.addChoosableFileFilter(fileFilter);
        }
        FontSizer.setFonts(jFileChooser, FontSizer.getLevel());
        return jFileChooser;
    }
}

