/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TrackPlottingPanel;
import org.opensourcephysics.cabrillo.tracker.TrackView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.WorldTView;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.tools.FontSizer;

public class PlotTrackView
extends TrackView {
    protected DatasetManager data;
    protected JComponent mainView;
    protected TrackPlottingPanel[] plots = new TrackPlottingPanel[3];
    protected JButton plotsButton;
    protected JCheckBox linkCheckBox;
    protected JPopupMenu popup;
    protected JRadioButtonMenuItem[] plotCountItems;
    protected ButtonGroup plotCountGroup;
    protected boolean highlightVisible = true;
    protected int defaultPlotCount = 1;
    private boolean isCustom;
    protected boolean xAxesLinked;

    public PlotTrackView(TTrack tTrack, TrackerPanel trackerPanel) {
        super(tTrack, trackerPanel);
        this.data = tTrack.getData(this.trackerPanel);
        this.createGUI();
        int n = 0;
        while (n < this.plots.length) {
            this.highlightVisible = !"false".equals(tTrack.getProperty("highlights"));
            this.plots[n].setXVariable((String)tTrack.getProperty("xVarPlot" + n));
            this.plots[n].setYVariable((String)tTrack.getProperty("yVarPlot" + n));
            boolean bl = !"false".equals(tTrack.getProperty("connectedPlot" + n));
            this.plots[n].dataset.setConnected(bl);
            this.plots[n].linesItem.setSelected(bl);
            boolean bl2 = !"false".equals(tTrack.getProperty("pointsPlot" + n));
            this.plots[n].dataset.setMarkerShape(bl2 ? 2 : 0);
            this.plots[n].pointsItem.setSelected(bl2);
            this.plots[n].dataset.setMarkerColor(tTrack.getColor());
            Double d = (Double)tTrack.getProperty("yMinPlot" + n);
            if (d != null) {
                this.plots[n].setPreferredMinMaxY(d, this.plots[n].getPreferredYMax());
            }
            if ((d = (Double)tTrack.getProperty("yMaxPlot" + n)) != null) {
                this.plots[n].setPreferredMinMaxY(this.plots[n].getPreferredYMin(), d);
            }
            this.plots[n].isCustom = false;
            ++n;
        }
    }

    @Override
    public void refresh(int n) {
        if (!this.isRefreshEnabled()) {
            return;
        }
        Tracker.logTime(String.valueOf(this.getClass().getSimpleName()) + this.hashCode() + " refresh " + n);
        this.track.getData(this.trackerPanel);
        int n2 = 0;
        while (n2 < this.plots.length) {
            HighlightableDataset highlightableDataset = this.plots[n2].getDataset();
            highlightableDataset.setMarkerColor(this.track.getColor());
            if (this.highlightVisible) {
                highlightableDataset.setHighlightColor(this.track.getColor());
                this.plots[n2].setHighlighted(n);
            } else {
                this.plots[n2].setHighlighted(-1);
            }
            this.plots[n2].plotData();
            ++n2;
        }
        this.mainView.repaint();
    }

    @Override
    void refreshGUI() {
        this.linkCheckBox.setText(TrackerRes.getString("PlotTrackView.Checkbox.Synchronize"));
        this.linkCheckBox.setToolTipText(TrackerRes.getString("PlotTrackView.Checkbox.Synchronize.Tooltip"));
        this.plotsButton.setText(TrackerRes.getString("PlotTrackView.Button.PlotCount"));
        this.plotsButton.setToolTipText(TrackerRes.getString("PlotTrackView.Button.PlotCount.ToolTip"));
        this.track.getData(this.trackerPanel);
        int n = 0;
        while (n < this.plots.length) {
            boolean bl = this.plots[n].isCustom;
            this.plots[n].createVarChoices();
            this.plots[n].isCustom = bl;
            ++n;
        }
    }

    @Override
    void dispose() {
    }

    @Override
    public ArrayList<Component> getToolBarComponents() {
        return super.getToolBarComponents();
    }

    @Override
    public JButton getViewButton() {
        return this.plotsButton;
    }

    @Override
    public boolean isCustomState() {
        int n = this.mainView.getComponentCount();
        if (this.isCustom || n != this.defaultPlotCount) {
            return true;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.plots[n2].isCustom) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setPlotCount(int n) {
        if (n == this.mainView.getComponentCount()) {
            return;
        }
        this.track.trackerPanel.changed = true;
        n = Math.min(n, this.plots.length);
        this.plotCountItems[n - 1].setSelected(true);
        this.mainView.removeAll();
        this.mainView.add(this.plots[0]);
        int n2 = 1;
        while (n2 < n) {
            this.mainView.add(this.plots[n2]);
            ++n2;
        }
        this.mainView.validate();
        if (n > 1) {
            this.toolbarComponents.add(this.linkCheckBox);
        } else {
            this.toolbarComponents.remove(this.linkCheckBox);
        }
        Runnable runnable = new Runnable(){

            @Override
            public synchronized void run() {
                TViewChooser tViewChooser = PlotTrackView.this.plots[0].getOwner();
                if (tViewChooser != null) {
                    tViewChooser.refreshToolbar();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public TrackPlottingPanel[] getPlots() {
        int n = this.mainView.getComponentCount();
        TrackPlottingPanel[] trackPlottingPanelArray = new TrackPlottingPanel[n];
        int n2 = 0;
        while (n2 < n) {
            trackPlottingPanelArray[n2] = this.plots[n2];
            ++n2;
        }
        return trackPlottingPanelArray;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("track") && propertyChangeEvent.getNewValue() != null && !(propertyChangeEvent.getSource() instanceof WorldTView)) {
            TrackPlottingPanel trackPlottingPanel;
            TrackPlottingPanel[] trackPlottingPanelArray = this.getPlots();
            int n = trackPlottingPanelArray.length;
            int n2 = 0;
            while (n2 < n) {
                trackPlottingPanel = trackPlottingPanelArray[n2];
                trackPlottingPanel.plotAxes.hideScaleSetter();
                ++n2;
            }
            trackPlottingPanelArray = this.plots;
            n = this.plots.length;
            n2 = 0;
            while (n2 < n) {
                trackPlottingPanel = trackPlottingPanelArray[n2];
                trackPlottingPanel.buildPopupmenu();
                ++n2;
            }
        }
        super.propertyChange(propertyChangeEvent);
    }

    protected void setXAxesLinked(boolean bl) {
        this.xAxesLinked = bl;
        this.linkCheckBox.setSelected(bl);
        if (bl) {
            this.syncXAxesTo(this.plots[0]);
        }
    }

    protected void syncXAxesTo(TrackPlottingPanel trackPlottingPanel) {
        if (!this.xAxesLinked) {
            return;
        }
        this.xAxesLinked = false;
        String string = trackPlottingPanel.getXVariable();
        TrackPlottingPanel[] trackPlottingPanelArray = this.plots;
        int n = this.plots.length;
        int n2 = 0;
        while (n2 < n) {
            TrackPlottingPanel trackPlottingPanel2 = trackPlottingPanelArray[n2];
            if (trackPlottingPanel2 != trackPlottingPanel) {
                double d = trackPlottingPanel.isAutoscaleXMin() ? Double.NaN : trackPlottingPanel.getPreferredXMin();
                double d2 = trackPlottingPanel.isAutoscaleXMax() ? Double.NaN : trackPlottingPanel.getPreferredXMax();
                trackPlottingPanel2.setXVariable(string);
                trackPlottingPanel2.setPreferredMinMaxX(d, d2);
                trackPlottingPanel2.scale();
                trackPlottingPanel2.repaint();
            }
            ++n2;
        }
        this.xAxesLinked = true;
    }

    protected void syncYAxes(TrackPlottingPanel ... trackPlottingPanelArray) {
        TrackPlottingPanel trackPlottingPanel;
        double d = Double.NaN;
        double d2 = Double.NaN;
        boolean bl = false;
        TrackPlottingPanel[] trackPlottingPanelArray2 = trackPlottingPanelArray;
        int n = trackPlottingPanelArray.length;
        int n2 = 0;
        while (n2 < n) {
            trackPlottingPanel = trackPlottingPanelArray2[n2];
            if (!Double.isNaN(d)) {
                bl = true;
            }
            d = Double.isNaN(d) ? trackPlottingPanel.getPreferredYMin() : Math.min(trackPlottingPanel.getPreferredYMin(), d);
            d2 = Double.isNaN(d2) ? trackPlottingPanel.getPreferredYMax() : Math.max(trackPlottingPanel.getPreferredYMax(), d2);
            ++n2;
        }
        if (bl) {
            trackPlottingPanelArray2 = trackPlottingPanelArray;
            n = trackPlottingPanelArray.length;
            n2 = 0;
            while (n2 < n) {
                trackPlottingPanel = trackPlottingPanelArray2[n2];
                trackPlottingPanel.setPreferredMinMaxY(d, d2);
                trackPlottingPanel.scale();
                trackPlottingPanel.repaint();
                ++n2;
            }
        }
    }

    private TrackPlottingPanel createPlotPanel() {
        TrackPlottingPanel trackPlottingPanel = new TrackPlottingPanel(this.track, this.data);
        trackPlottingPanel.enableInspector(true);
        trackPlottingPanel.setAutoscaleX(true);
        trackPlottingPanel.setAutoscaleY(true);
        trackPlottingPanel.setPreferredSize(new Dimension(140, 140));
        trackPlottingPanel.setMinimumSize(new Dimension(100, 100));
        trackPlottingPanel.setPlotTrackView(this);
        return trackPlottingPanel;
    }

    private void createGUI() {
        this.mainView = new JPanel();
        this.mainView.setDoubleBuffered(true);
        this.mainView.setLayout(new BoxLayout(this.mainView, 1));
        int n = 0;
        while (n < this.plots.length) {
            this.plots[n] = this.createPlotPanel();
            ++n;
        }
        n = 0;
        while (n < this.defaultPlotCount) {
            this.mainView.add(this.plots[n]);
            ++n;
        }
        this.setViewportView(this.mainView);
        this.popup = new JPopupMenu();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                PlotTrackView.this.setPlotCount(Integer.parseInt(jMenuItem.getText()));
                PlotTrackView.this.refresh(PlotTrackView.this.trackerPanel.getFrameNumber());
            }
        };
        this.plotCountItems = new JRadioButtonMenuItem[this.plots.length];
        this.plotCountGroup = new ButtonGroup();
        int n2 = 0;
        while (n2 < this.plots.length) {
            this.plotCountItems[n2] = new JRadioButtonMenuItem(String.valueOf(n2 + 1));
            this.plotCountItems[n2].addActionListener(actionListener);
            this.popup.add(this.plotCountItems[n2]);
            this.plotCountGroup.add(this.plotCountItems[n2]);
            ++n2;
        }
        this.plotCountItems[0].setSelected(true);
        this.linkCheckBox = new JCheckBox();
        this.linkCheckBox.setOpaque(false);
        this.linkCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlotTrackView.this.setXAxesLinked(PlotTrackView.this.linkCheckBox.isSelected());
            }
        });
        this.plotsButton = new TButton(){

            @Override
            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                Dimension dimension2 = this.getMinimumSize();
                Container container = this.getParent().getParent();
                if (container instanceof TViewChooser) {
                    int n = ((TViewChooser)container).chooserButton.getHeight();
                    dimension.height = Math.max(n, dimension2.height);
                }
                return dimension;
            }

            @Override
            public JPopupMenu getPopup() {
                FontSizer.setFonts(PlotTrackView.this.popup, FontSizer.getLevel());
                return PlotTrackView.this.popup;
            }
        };
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            PlotTrackView plotTrackView = (PlotTrackView)object;
            xMLControl.setValue("track", plotTrackView.track.getName());
            TrackPlottingPanel[] trackPlottingPanelArray = plotTrackView.getPlots();
            int n = 0;
            while (n < trackPlottingPanelArray.length) {
                xMLControl.setValue("plot" + n, trackPlottingPanelArray[n]);
                ++n;
            }
            xMLControl.setValue("linked", plotTrackView.xAxesLinked);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            PlotTrackView plotTrackView = (PlotTrackView)object;
            plotTrackView.setXAxesLinked(xMLControl.getBoolean("linked"));
            TrackPlottingPanel[] trackPlottingPanelArray = plotTrackView.plots;
            int n = 1;
            int n2 = 0;
            while (n2 < trackPlottingPanelArray.length) {
                XMLControl xMLControl2 = xMLControl.getChildControl("plot" + n2);
                if (xMLControl2 != null) {
                    xMLControl2.loadObject(trackPlottingPanelArray[n2]);
                    n = n2 + 1;
                }
                ++n2;
            }
            plotTrackView.setPlotCount(n);
            plotTrackView.isCustom = true;
            return object;
        }
    }
}

