/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Point;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.PerspectiveTrack;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.media.core.PerspectiveFilter;
import org.opensourcephysics.media.core.TPoint;

public class PerspectiveStep
extends Step {
    public PerspectiveStep(PerspectiveTrack perspectiveTrack, int n, double d, double d2) {
        super(perspectiveTrack, n);
        this.points = new TPoint[]{new Corner(), new Corner(), new Corner(), new Corner()};
        this.screenPoints = new Point[PerspectiveStep.getLength()];
    }

    @Override
    public int getPointIndex(TPoint tPoint) {
        if (tPoint instanceof PerspectiveFilter.Corner) {
            PerspectiveFilter.Corner corner = (PerspectiveFilter.Corner)tPoint;
            PerspectiveTrack perspectiveTrack = (PerspectiveTrack)this.track;
            int n = perspectiveTrack.filter.getCornerIndex(corner);
            if (n < 4) {
                return n;
            }
        }
        int n = 0;
        while (n < this.points.length) {
            if (tPoint == this.points[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public TPoint getDefaultPoint() {
        PerspectiveTrack perspectiveTrack = (PerspectiveTrack)this.track;
        int n = perspectiveTrack.getTargetIndex();
        return perspectiveTrack.filter.getCorner(n);
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.marks.get(trackerPanel);
        if (mark == null) {
            mark = this.footprint.getMark(this.screenPoints);
            this.marks.put(trackerPanel, mark);
        }
        return mark;
    }

    @Override
    public Object clone() {
        PerspectiveStep perspectiveStep = (PerspectiveStep)super.clone();
        perspectiveStep.points = new TPoint[]{new Corner(), new Corner(), new Corner(), new Corner()};
        return perspectiveStep;
    }

    @Override
    public String toString() {
        return "PerspectiveStep";
    }

    public class Corner
    extends TPoint {
        @Override
        public void setXY(double d, double d2) {
            super.setLocation(d, d2);
            PerspectiveTrack perspectiveTrack = (PerspectiveTrack)PerspectiveStep.this.track;
            if (perspectiveTrack.trackerPanel != null) {
                int n = perspectiveTrack.trackerPanel.getFrameNumber();
                perspectiveTrack.support.firePropertyChange("step", null, (Object)n);
            }
        }
    }
}

