/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.desktop.ostermiller.Browser;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LaunchBuilder;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class PageTView
extends JPanel
implements TView {
    protected Icon icon;
    protected TrackerPanel trackerPanel;
    protected ArrayList<TabView> tabs = new ArrayList();
    protected JTabbedPane tabbedPane;
    protected JButton pageButton;
    protected ArrayList<Component> toolbarComponents = new ArrayList();
    protected JDialog nameDialog;
    protected JTextField nameField;
    protected JPanel noTab;
    protected JLabel noTabLabel;
    protected JLabel tabTitleLabel;
    protected Box.Filler filler = (Box.Filler)Box.createHorizontalGlue();
    protected Border titleBorder;
    protected boolean locked;

    static {
        XML.setLoader(TabView.class, new TabLoader());
    }

    protected PageTView(TrackerPanel trackerPanel) {
        this.trackerPanel = trackerPanel;
        this.icon = new ImageIcon(Tracker.class.getResource("resources/images/html.gif"));
        this.setBackground(trackerPanel.getBackground());
        this.createGUI();
        this.refresh();
    }

    @Override
    public void refresh() {
        this.refreshTabs();
        this.removeAll();
        this.pageButton.setText(TrackerRes.getString("PageTView.Button.Page"));
        if (this.tabs.isEmpty()) {
            this.noTabLabel.setText(TrackerRes.getString("TextTView.Label.NoTab"));
            this.add((Component)this.noTab, "Center");
        } else if (this.tabs.size() == 1) {
            this.add((Component)this.tabs.get(0), "Center");
        } else {
            this.add((Component)this.tabbedPane, "Center");
        }
        FontSizer.setFonts(this, FontSizer.getLevel());
        this.validate();
        this.repaint();
    }

    @Override
    public void init() {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public TrackerPanel getTrackerPanel() {
        return this.trackerPanel;
    }

    @Override
    public String getViewName() {
        return TrackerRes.getString("TFrame.View.Text");
    }

    @Override
    public Icon getViewIcon() {
        return this.icon;
    }

    @Override
    public ArrayList<Component> getToolBarComponents() {
        return this.toolbarComponents;
    }

    @Override
    public boolean isCustomState() {
        return this.tabs.size() > 0;
    }

    public void addTab(TabView tabView) {
        this.tabs.add(tabView);
        if (this.trackerPanel != null) {
            this.trackerPanel.changed = true;
        }
        this.refresh();
    }

    public void removeTab(TabView tabView) {
        this.tabs.remove(tabView);
        if (this.trackerPanel != null) {
            this.trackerPanel.changed = true;
        }
        this.refresh();
    }

    public void renameTab(TabView tabView) {
        this.nameDialog = this.getNameDialog();
        this.nameDialog.setTitle(TrackerRes.getString("TextTView.Dialog.TabTitle.Title"));
        this.nameField.setText(tabView.data.title);
        this.nameField.setBackground(Color.white);
        this.nameField.selectAll();
        this.nameDialog.pack();
        Point point = this.getLocationOnScreen();
        point.x += (this.getWidth() - this.nameDialog.getWidth()) / 2;
        point.y -= this.pageButton.getHeight();
        this.nameDialog.setLocation(point);
        this.nameDialog.setVisible(true);
    }

    public TabView getSelectedTab() {
        TabView tabView = (TabView)this.tabbedPane.getSelectedComponent();
        if (tabView == null && !this.tabs.isEmpty()) {
            tabView = this.tabs.get(0);
        }
        return tabView;
    }

    public void setSelectedTab(TabView tabView) {
        if (this.tabs.size() > 1) {
            this.tabbedPane.setSelectedComponent(tabView);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void createGUI() {
        this.setPreferredSize(new Dimension(400, 200));
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setBackground(this.trackerPanel.getBackground());
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PageTView.this.refreshTitle();
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PageTView.this.tabbedPane.requestFocusInWindow();
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    JPopupMenu jPopupMenu = PageTView.this.getPopup(PageTView.this.getSelectedTab());
                    jPopupMenu.show(PageTView.this.tabbedPane, mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getClickCount() == 2 && !PageTView.this.locked && PageTView.this.trackerPanel.isEnabled("pageView.edit")) {
                    PageTView.this.renameTab(PageTView.this.getSelectedTab());
                }
            }
        });
        this.pageButton = new TButton(){

            @Override
            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                Dimension dimension2 = this.getMinimumSize();
                Container container = this.getParent().getParent();
                if (container instanceof TViewChooser) {
                    int n = ((TViewChooser)container).chooserButton.getHeight();
                    dimension.height = Math.max(n, dimension2.height);
                }
                return dimension;
            }

            @Override
            public JPopupMenu getPopup() {
                JPopupMenu jPopupMenu = new JPopupMenu();
                if (!PageTView.this.trackerPanel.isEnabled("pageView.edit")) {
                    JMenuItem jMenuItem = new JMenuItem(TrackerRes.getString("TTrack.MenuItem.Locked"));
                    jMenuItem.setEnabled(false);
                    jPopupMenu.add(jMenuItem);
                    FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                    return jPopupMenu;
                }
                JMenuItem jMenuItem = new JMenuItem(TrackerRes.getString("TextTView.Button.NewTab"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TabView tabView = new TabView(new TabData());
                        int n = (this).PageTView.this.tabs.size() + 1;
                        if (n > 1) {
                            tabView.data.title = String.valueOf(tabView.data.title) + " " + n;
                        }
                        PageTView.this.addTab(tabView);
                        PageTView.this.setSelectedTab(tabView);
                    }
                });
                jMenuItem.setEnabled(!PageTView.this.locked);
                jPopupMenu.add(jMenuItem);
                jMenuItem = new JMenuItem(TrackerRes.getString("TextTView.MenuItem.OpenHTML"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JFileChooser jFileChooser = LaunchBuilder.getHTMLChooser();
                        int n = jFileChooser.showOpenDialog((this).PageTView.this.trackerPanel);
                        if (n == 0) {
                            File file = jFileChooser.getSelectedFile();
                            TabView tabView = PageTView.this.getSelectedTab();
                            if (tabView == null) {
                                tabView = new TabView(new TabData());
                                PageTView.this.addTab(tabView);
                            }
                            tabView.setUndoableText(XML.getAbsolutePath(file));
                            PageTView.this.refresh();
                            OSPRuntime.chooserDir = XML.getDirectoryPath(file.getPath());
                        }
                    }
                });
                jMenuItem.setEnabled(!PageTView.this.locked);
                jPopupMenu.add(jMenuItem);
                jPopupMenu.addSeparator();
                jMenuItem = new JRadioButtonMenuItem(TrackerRes.getString("TTrack.MenuItem.Locked"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                        (this).PageTView.this.locked = jMenuItem.isSelected();
                    }
                });
                jMenuItem.setSelected(PageTView.this.locked);
                jPopupMenu.add(jMenuItem);
                FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                return jPopupMenu;
            }
        };
        this.tabTitleLabel = new JLabel();
        this.tabTitleLabel.setOpaque(false);
        this.tabTitleLabel.setForeground(Color.BLUE.darker());
        this.tabTitleLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if ("".equals(PageTView.this.tabTitleLabel.getText())) {
                    return;
                }
                PageTView.this.tabTitleLabel.requestFocusInWindow();
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    JPopupMenu jPopupMenu = PageTView.this.getPopup(PageTView.this.getSelectedTab());
                    jPopupMenu.show(PageTView.this.tabTitleLabel, mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getClickCount() == 2 && !PageTView.this.locked && PageTView.this.trackerPanel.isEnabled("pageView.edit")) {
                    PageTView.this.renameTab(PageTView.this.getSelectedTab());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (!PageTView.this.locked && PageTView.this.trackerPanel.isEnabled("pageView.edit")) {
                    PageTView.this.tabTitleLabel.setBorder(PageTView.this.titleBorder);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PageTView.this.tabTitleLabel.setBorder(null);
            }
        });
        Border border = BorderFactory.createEmptyBorder(0, 2, 1, 2);
        Border border2 = BorderFactory.createLineBorder(this.tabTitleLabel.getForeground());
        this.titleBorder = BorderFactory.createCompoundBorder(border2, border);
        this.toolbarComponents.add(this.pageButton);
        this.toolbarComponents.add(this.filler);
        this.toolbarComponents.add(this.tabTitleLabel);
        this.noTab = new JPanel();
        this.noTabLabel = new JLabel();
        Font font = new JTextField().getFont();
        this.noTabLabel.setFont(font);
        this.noTab.add(this.noTabLabel);
        this.noTab.setBackground(this.getBackground());
        this.noTab.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem(String.valueOf(TrackerRes.getString("Dialog.Button.Help")) + "...");
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            (this).PageTView.this.trackerPanel.getTFrame().showHelp("textview", 0);
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                    jPopupMenu.show(PageTView.this.noTab, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    protected void refreshTabs() {
        TabView tabView = this.getSelectedTab();
        this.tabbedPane.removeAll();
        for (TabView tabView2 : this.tabs) {
            tabView2.pageView = this;
            tabView2.data.trackerPanel = this.trackerPanel;
            tabView2.refreshView(false);
            this.tabbedPane.addTab(tabView2.data.title, tabView2);
        }
        if (tabView != null && this.tabbedPane.indexOfComponent(tabView) > -1) {
            this.tabbedPane.setSelectedComponent(tabView);
        }
        this.refreshTitle();
        if (this.trackerPanel != null) {
            TToolBar.getToolbar(this.trackerPanel).refresh(false);
        }
    }

    protected void refreshTitle() {
        TabView tabView = this.getSelectedTab();
        this.tabTitleLabel.setText(tabView == null ? null : tabView.data.title);
    }

    protected JPopupMenu getPopup(final TabView tabView) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        String string = null;
        if (this.trackerPanel.isEnabled("pageView.edit")) {
            JMenuItem jMenuItem;
            int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            JMenuItem jMenuItem2 = new JMenuItem(TrackerRes.getString("TextTView.MenuItem.SetTitle"));
            jMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PageTView.this.renameTab(tabView);
                }
            });
            jMenuItem2.setEnabled(!this.locked);
            jPopupMenu.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem(TrackerRes.getString("TextTView.MenuItem.OpenHTML"));
            jMenuItem3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = LaunchBuilder.getHTMLChooser();
                    int n = jFileChooser.showOpenDialog(PageTView.this.trackerPanel);
                    if (n == 0) {
                        File file = jFileChooser.getSelectedFile();
                        tabView.setUndoableText(XML.getAbsolutePath(file));
                        PageTView.this.refresh();
                        OSPRuntime.chooserDir = XML.getDirectoryPath(file.getPath());
                    }
                }
            });
            jMenuItem3.setEnabled(!this.locked);
            jPopupMenu.add(jMenuItem3);
            jPopupMenu.addSeparator();
            string = String.valueOf(TrackerRes.getString("PageTView.MenuItem.ClosePage")) + " \"";
            string = String.valueOf(string) + tabView.data.title + "\"";
            JMenuItem jMenuItem4 = new JMenuItem(string);
            jMenuItem4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PageTView.this.removeTab(tabView);
                }
            });
            jMenuItem4.setEnabled(!this.locked);
            jPopupMenu.add(jMenuItem4);
            if (tabView.data.url != null) {
                string = TrackerRes.getString("PageTView.MenuItem.OpenInBrowser");
                jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        OSPDesktop.displayURL(tabView.data.url.toExternalForm());
                    }
                });
                jPopupMenu.add(jMenuItem);
            }
            if (tabView.undoManager.canUndoOrRedo()) {
                jPopupMenu.addSeparator();
                if (tabView.undoManager.canUndo()) {
                    string = String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.Undo")) + " ";
                    string = String.valueOf(string) + TrackerRes.getString("TextTView.TextEdit.Description");
                    jMenuItem = new JMenuItem(string);
                    jMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, n));
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            tabView.undoManager.undo();
                        }
                    });
                    jMenuItem.setEnabled(!this.locked);
                    jPopupMenu.add(jMenuItem);
                }
                if (tabView.undoManager.canRedo()) {
                    string = String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.Redo")) + " ";
                    string = String.valueOf(string) + TrackerRes.getString("TextTView.TextEdit.Description");
                    jMenuItem = new JMenuItem(string);
                    jMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, n));
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            tabView.undoManager.redo();
                        }
                    });
                    jMenuItem.setEnabled(!this.locked);
                    jPopupMenu.add(jMenuItem);
                }
            }
            jPopupMenu.addSeparator();
        }
        string = String.valueOf(TrackerRes.getString("Dialog.Button.Help")) + "...";
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageTView.this.trackerPanel.getTFrame().showHelp("textview", 0);
            }
        });
        jPopupMenu.add(jMenuItem);
        FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
        return jPopupMenu;
    }

    protected JDialog getNameDialog() {
        if (this.nameDialog == null) {
            this.nameField = new JTextField(20);
            this.nameField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TabView tabView = PageTView.this.getSelectedTab();
                    tabView.data.setTitle(PageTView.this.nameField.getText());
                    PageTView.this.refresh();
                    PageTView.this.nameDialog.setVisible(false);
                }
            });
            this.nameField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    PageTView.this.nameField.setBackground(Color.yellow);
                }
            });
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            jToolBar.add(this.nameField);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jToolBar, "Center");
            this.nameDialog = new JDialog(JOptionPane.getFrameForComponent(this), true);
            this.nameDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    TabView tabView = PageTView.this.getSelectedTab();
                    tabView.data.setTitle(PageTView.this.nameField.getText());
                    PageTView.this.refresh();
                }
            });
            this.nameDialog.setContentPane(jPanel);
            this.nameDialog.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - this.nameDialog.getBounds().width) / 2;
            int n2 = (dimension.height - this.nameDialog.getBounds().height) / 2;
            this.nameDialog.setLocation(n, n2);
        }
        FontSizer.setFonts(this.nameDialog, FontSizer.getLevel());
        return this.nameDialog;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            PageTView pageTView = (PageTView)object;
            xMLControl.setValue("tabs", pageTView.tabs);
            xMLControl.setValue("locked", pageTView.locked);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            PageTView pageTView = (PageTView)object;
            pageTView.locked = xMLControl.getBoolean("locked");
            ArrayList arrayList = (ArrayList)ArrayList.class.cast(xMLControl.getObject("tabs"));
            if (arrayList != null) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    pageTView.addTab((TabView)iterator.next());
                }
            }
            return object;
        }
    }

    public static class TabData {
        String title;
        boolean hyperlinksEnabled = true;
        String text;
        URL url;
        TrackerPanel trackerPanel;

        TabData() {
            this.text = TrackerRes.getString("TextTView.NewTab.Text1");
            this.text = String.valueOf(this.text) + XML.NEW_LINE + XML.NEW_LINE;
            this.text = String.valueOf(this.text) + TrackerRes.getString("TextTView.NewTab.Text2");
            this.title = TrackerRes.getString("TextTView.NewTab.Title");
        }

        TabData(String string, String string2) {
            this.title = string;
            this.setText(string2);
        }

        public void setTitle(String string) {
            if (string == null) {
                return;
            }
            this.title = string;
            if (this.trackerPanel != null) {
                this.trackerPanel.changed = true;
                TToolBar.getToolbar(this.trackerPanel).refresh(false);
            }
        }

        public void setText(String string) {
            if (string == null) {
                return;
            }
            this.text = string;
            this.setURL(string);
        }

        public URL getURL() {
            if (this.url == null) {
                this.setURL(this.text);
            }
            return this.url;
        }

        private void setURL(String string) {
            this.url = null;
            Resource resource = ResourceLoader.getResource(string);
            if (resource != null && resource.getURL() != null) {
                this.url = resource.getURL();
                try {
                    InputStream inputStream = this.url.openStream();
                    inputStream.close();
                }
                catch (Exception exception) {
                    this.url = null;
                }
            }
            if (this.trackerPanel != null) {
                this.trackerPanel.changed = true;
                TToolBar.getToolbar(this.trackerPanel).refresh(false);
            }
        }
    }

    static class TabLoader
    implements XML.ObjectLoader {
        TabLoader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            TabView tabView = (TabView)object;
            TabData tabData = tabView.data;
            xMLControl.setValue("title", tabData.title);
            if (tabData.url == null) {
                xMLControl.setValue("text", tabData.text);
            } else if (tabData.url.getProtocol().equals("file")) {
                TrackerPanel trackerPanel = tabData.trackerPanel;
                File file = trackerPanel.getDataFile();
                if (file != null) {
                    String string = tabData.url.getFile();
                    while (string.startsWith("/")) {
                        string = string.substring(1);
                    }
                    String string2 = XML.getDirectoryPath(XML.getAbsolutePath(file));
                    xMLControl.setValue("text", XML.getPathRelativeTo(string, string2));
                } else {
                    xMLControl.setValue("text", tabData.url.toExternalForm());
                }
            } else {
                xMLControl.setValue("text", tabData.url.toExternalForm());
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            String string = xMLControl.getString("title");
            String string2 = xMLControl.getString("text");
            return new TabView(new TabData(string, string2));
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            return object;
        }
    }

    public static class TabView
    extends JPanel {
        protected TabData data;
        protected JEditorPane displayPane;
        protected JEditorPane editorPane;
        protected JScrollPane scroller;
        protected PageTView pageView;
        protected UndoableEditSupport undoSupport;
        protected UndoManager undoManager;
        protected HyperlinkListener hyperlinkListener;

        TabView(TabData tabData) {
            super(new BorderLayout());
            this.data = tabData;
            class TextView
            extends JTextPane {
                TextView() {
                }

                @Override
                public void paintComponent(Graphics graphics) {
                    if (OSPRuntime.antiAliasText.booleanValue()) {
                        Graphics2D graphics2D = (Graphics2D)graphics;
                        RenderingHints renderingHints = graphics2D.getRenderingHints();
                        renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    super.paintComponent(graphics);
                }
            }
            this.displayPane = new TextView();
            this.displayPane.setEditable(false);
            this.hyperlinkListener = new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (TabView.this.data.hyperlinksEnabled && hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            if (!OSPDesktop.browse(hyperlinkEvent.getURL().toURI())) {
                                Browser.init();
                                Browser.displayURL(hyperlinkEvent.getURL().toString());
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            this.displayPane.addHyperlinkListener(this.hyperlinkListener);
            this.displayPane.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 90 && keyEvent.isControlDown()) {
                        if (TabView.this.undoManager.canUndo()) {
                            TabView.this.undoManager.undo();
                        }
                    } else if (keyEvent.getKeyCode() == 89 && keyEvent.isControlDown() && TabView.this.undoManager.canRedo()) {
                        TabView.this.undoManager.redo();
                    }
                }
            });
            this.displayPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                        JPopupMenu jPopupMenu = TabView.this.pageView.getPopup(TabView.this.pageView.getSelectedTab());
                        jPopupMenu.show(TabView.this.displayPane, mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getClickCount() == 2 && !TabView.this.pageView.locked && TabView.this.pageView.trackerPanel.isEnabled("pageView.edit")) {
                        TabView.this.editorPane.setBackground(Color.white);
                        TabView.this.refreshView(true);
                        TabView.this.editorPane.selectAll();
                    }
                }
            });
            this.editorPane = new TextView();
            this.editorPane.setContentType("text");
            this.editorPane.setEditable(true);
            this.editorPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                        JPopupMenu jPopupMenu = TabView.this.pageView.getPopup(TabView.this.pageView.getSelectedTab());
                        jPopupMenu.show(TabView.this.editorPane, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            this.editorPane.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (TabView.this.editorPane.getBackground().equals(Color.yellow)) {
                        TabView.this.setUndoableText(TabView.this.editorPane.getText());
                    }
                    TabView.this.refreshView(false);
                }
            });
            this.editorPane.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 90 && keyEvent.isControlDown()) {
                        TabView.this.setUndoableText(TabView.this.editorPane.getText());
                        TabView.this.refreshView(false);
                        if (TabView.this.undoManager.canUndo()) {
                            TabView.this.undoManager.undo();
                        }
                    } else if (keyEvent.getKeyCode() == 10 && keyEvent.isShiftDown()) {
                        TabView.this.setUndoableText(TabView.this.editorPane.getText());
                        TabView.this.refreshView(false);
                    } else {
                        TabView.this.editorPane.setBackground(Color.yellow);
                    }
                }
            });
            this.scroller = new JScrollPane(this.displayPane);
            this.add((Component)this.scroller, "Center");
            this.refreshView(false);
            this.undoManager = new UndoManager();
            this.undoSupport = new UndoableEditSupport();
            this.undoSupport.addUndoableEditListener(this.undoManager);
        }

        void refreshView(boolean bl) {
            if (bl) {
                this.scroller.setViewportView(this.editorPane);
                this.editorPane.setText(this.data.text);
                this.editorPane.requestFocusInWindow();
            } else {
                this.editorPane.setBackground(Color.white);
                this.scroller.setViewportView(this.displayPane);
                if (this.data.getURL() != null) {
                    try {
                        this.displayPane.setContentType("text/html");
                        this.displayPane.setPage(this.data.url);
                        if (this.data.url.getRef() != null) {
                            this.displayPane.scrollToReference(this.data.url.getRef());
                        }
                    }
                    catch (IOException iOException) {
                        this.displayPane.setContentType("text");
                        this.displayPane.setText(this.data.text);
                    }
                } else {
                    this.displayPane.setContentType("text");
                    this.displayPane.setText(this.data.text);
                }
                this.displayPane.requestFocusInWindow();
            }
            this.revalidate();
            this.repaint();
        }

        void setUndoableText(String string) {
            if (string == null || string.equals(this.data.text)) {
                return;
            }
            TextEdit textEdit = new TextEdit(this, string, this.data.text);
            this.undoSupport.postEdit(textEdit);
            this.data.setText(string);
        }
    }

    protected static class TextEdit
    extends AbstractUndoableEdit {
        TabView tab;
        String text;
        String prev;

        public TextEdit(TabView tabView, String string, String string2) {
            this.tab = tabView;
            this.text = string;
            this.prev = string2;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.tab.data.setText(this.prev);
            this.tab.refreshView(false);
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            this.tab.data.setText(this.text);
            this.tab.refreshView(false);
        }

        @Override
        public String getPresentationName() {
            return TrackerRes.getString("TextTView.TextEdit.Description");
        }
    }
}

