/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.InitialValueEditor;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class ModelFunctionPanel
extends FunctionPanel {
    InitialValueEditor initEditor;
    ParticleModel model;

    public ModelFunctionPanel(UserFunctionEditor userFunctionEditor, ParticleModel particleModel) {
        super(userFunctionEditor);
        this.model = particleModel;
        this.setName(particleModel.getName());
    }

    @Override
    public String getLabel() {
        return TrackerRes.getString("ModelFunctionPanel.Label");
    }

    @Override
    public String getDisplayName() {
        if (this.model != null) {
            return this.model.getDisplayName();
        }
        return super.getDisplayName();
    }

    public UserFunctionEditor getUserFunctionEditor() {
        return (UserFunctionEditor)this.functionEditor;
    }

    public InitialValueEditor getInitEditor() {
        return this.initEditor;
    }

    @Override
    protected void createGUI() {
        super.createGUI();
        this.initEditor = new InitialValueEditor(this.getParamEditor());
        this.box.add((Component)this.initEditor, 1);
        this.initEditor.addPropertyChangeListener(this);
        this.paramEditor.addPropertyChangeListener(this.initEditor);
        this.functionEditor.addPropertyChangeListener(this.initEditor);
        this.initEditor.addPropertyChangeListener(this.paramEditor);
        this.initEditor.addPropertyChangeListener(this.functionEditor);
        FunctionEditor[] functionEditorArray = new FunctionEditor[]{this.functionEditor, this.initEditor};
        this.paramEditor.setFunctionEditors(functionEditorArray);
    }

    @Override
    public Icon getIcon() {
        if (this.model != null) {
            return this.model.getFootprint().getIcon(21, 16);
        }
        return null;
    }

    @Override
    protected void refreshGUI() {
        super.refreshGUI();
        this.initEditor.refreshGUI();
    }

    @Override
    protected void refreshFunctions() {
        if (this.paramEditor != null) {
            UserFunction[] userFunctionArray = ((UserFunctionEditor)this.functionEditor).getMainFunctions();
            int n = 0;
            while (n < userFunctionArray.length) {
                userFunctionArray[n].setParameters(this.paramEditor.getNames(), this.paramEditor.getValues(), this.paramEditor.getDescriptions());
                ++n;
            }
            userFunctionArray = ((UserFunctionEditor)this.functionEditor).getSupportFunctions();
            n = 0;
            while (n < userFunctionArray.length) {
                userFunctionArray[n].setParameters(this.paramEditor.getNames(), this.paramEditor.getValues(), this.paramEditor.getDescriptions());
                ++n;
            }
        }
        this.initEditor.evaluateAll();
        this.functionEditor.evaluateAll();
    }

    @Override
    protected void clearSelection() {
        super.clearSelection();
        this.initEditor.getTable().clearSelection();
    }

    @Override
    protected void tabToNext(FunctionEditor functionEditor) {
        if (functionEditor == this.paramEditor) {
            this.initEditor.getTable().requestFocusInWindow();
        } else {
            super.tabToNext(functionEditor);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (propertyChangeEvent.getSource() == this.paramEditor && string.equals("edit")) {
            this.initEditor.getTable().selectOnFocus = false;
        }
    }

    @Override
    protected boolean hasInvalidExpressions() {
        return this.functionEditor.containsInvalidExpressions() || this.paramEditor.containsInvalidExpressions() || this.initEditor.containsInvalidExpressions();
    }
}

