/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import org.opensourcephysics.cabrillo.tracker.Derivative;

public class FirstDerivative
implements Derivative {
    private int spill;
    private int start;
    private int step;
    private int count;
    private double[] xDeriv;
    private double[] yDeriv = new double[0];
    private Object[] result = new Object[4];

    @Override
    public Object[] evaluate(Object[] objectArray) {
        int[] nArray = (int[])objectArray[0];
        this.spill = nArray[0];
        this.start = nArray[1];
        this.step = nArray[2];
        this.count = nArray[3];
        double[] dArray = (double[])objectArray[1];
        double[] dArray2 = (double[])objectArray[2];
        boolean[] blArray = (boolean[])objectArray[3];
        if (this.yDeriv.length != dArray.length) {
            this.xDeriv = new double[dArray.length];
            this.result[0] = this.xDeriv;
            this.yDeriv = new double[dArray.length];
            this.result[1] = this.yDeriv;
        }
        int n = this.start;
        int n2 = Math.min(this.start + this.step * (this.count - 1), dArray.length);
        int n3 = n;
        while (n3 <= n2) {
            block7: {
                int n4 = n3 - this.spill * this.step;
                while (n4 <= n3 + this.spill * this.step) {
                    if (n4 < 0 || n4 >= blArray.length || !blArray[n4]) {
                        if (n3 < blArray.length) {
                            this.xDeriv[n3] = Double.NaN;
                            this.yDeriv[n3] = Double.NaN;
                        }
                        break block7;
                    }
                    n4 += this.step;
                }
                if (this.spill == 1) {
                    this.xDeriv[n3] = (-dArray[n3 - this.step] + dArray[n3 + this.step]) / 2.0;
                    this.yDeriv[n3] = (-dArray2[n3 - this.step] + dArray2[n3 + this.step]) / 2.0;
                } else {
                    this.xDeriv[n3] = (-2.0 * dArray[n3 - 2 * this.step] - dArray[n3 - this.step] + dArray[n3 + this.step] + 2.0 * dArray[n3 + 2 * this.step]) / 10.0;
                    this.yDeriv[n3] = (-2.0 * dArray2[n3 - 2 * this.step] - dArray2[n3 - this.step] + dArray2[n3 + this.step] + 2.0 * dArray2[n3 + 2 * this.step]) / 10.0;
                }
            }
            n3 += this.step;
        }
        return this.result;
    }
}

