/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.ImageVideoType;
import org.opensourcephysics.media.core.VideoFileFilter;

public class FileDropHandler
extends TransferHandler {
    static final String URI_LIST_MIME_TYPE = "text/uri-list;class=java.lang.String";
    static FileFilter dataFilter = TrackerIO.trkFileFilter;
    static FileFilter videoFilter = new VideoFileFilter();
    static FileFilter[] imageFilters = new ImageVideoType().getFileFilters();
    TFrame frame;
    DataFlavor uriListFlavor;
    List<?> dropList;
    Component dropComponent;
    DropTargetListener dropListener = new DropListener();

    public FileDropHandler(TFrame tFrame) {
        this.frame = tFrame;
        try {
            this.uriListFlavor = new DataFlavor(URI_LIST_MIME_TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || OSPRuntime.isLinux() && transferSupport.isDataFlavorSupported(this.uriListFlavor)) {
            File file;
            if (this.dropList == null && transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                try {
                    Transferable transferable = transferSupport.getTransferable();
                    this.dropList = this.getFileList(transferable);
                    this.dropComponent = transferSupport.getComponent();
                    this.dropComponent.getDropTarget().addDropTargetListener(this.dropListener);
                }
                catch (Exception exception) {}
            }
            boolean bl = false;
            if (this.dropList != null && this.dropComponent instanceof TrackerPanel && this.dropList.size() == 1 && videoFilter.accept(file = (File)this.dropList.get(0))) {
                bl = true;
            }
            if (!bl) {
                transferSupport.setDropAction(1);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        if (!this.canImport(transferSupport)) {
            return false;
        }
        List<?> list = this.getFileList(transferSupport.getTransferable());
        try {
            int n = 0;
            File[] fileArray = null;
            if (transferSupport.getComponent() instanceof TrackerPanel) {
                fileArray = (File[])transferSupport.getComponent();
            }
            if (fileArray != null) {
                fileArray.setMouseCursor(Cursor.getPredefinedCursor(3));
                this.frame.setCursor(Cursor.getPredefinedCursor(3));
                if (fileArray.getVideo() != null) {
                    n = fileArray.getVideo().getFrameNumber();
                }
            }
            int n2 = 0;
            while (n2 < list.size()) {
                File[] fileArray2;
                final File file = (File)list.get(n2);
                OSPLog.finest("dropped file: " + file.getAbsolutePath());
                if (transferSupport.getDropAction() == 1) {
                    TrackerIO.open(file, this.frame);
                } else if (fileArray != null && fileArray.getVideo() instanceof ImageVideo && this.isImageFile(file)) {
                    fileArray2 = TrackerIO.insertImagesIntoVideo(new File[]{file}, (TrackerPanel)fileArray, n + 1);
                    n += fileArray2.length;
                } else if (fileArray != null && videoFilter.accept(file)) {
                    fileArray2 = fileArray;
                    Runnable runnable = new Runnable((TrackerPanel)fileArray2){
                        private final /* synthetic */ TrackerPanel val$trackerPanel;
                        {
                            this.val$trackerPanel = trackerPanel;
                        }

                        @Override
                        public void run() {
                            TrackerIO.importVideo(file, this.val$trackerPanel, null);
                        }
                    };
                    if (TrackerIO.loadInSeparateThread) {
                        Thread thread = new Thread(runnable);
                        thread.setPriority(5);
                        thread.setDaemon(true);
                        thread.start();
                    } else {
                        runnable.run();
                    }
                } else {
                    JOptionPane.showMessageDialog(this.frame, "\"" + file.getName() + "\" " + TrackerRes.getString("FileDropHandler.Dialog.BadFile.Message"), TrackerRes.getString("FileDropHandler.Dialog.BadFile.Title"), 2);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            this.frame.setCursor(Cursor.getDefaultCursor());
            return false;
        }
        this.frame.setCursor(Cursor.getDefaultCursor());
        return true;
    }

    private List<?> getFileList(Transferable transferable) {
        List list = null;
        try {
            if (OSPRuntime.isLinux()) {
                String string = (String)transferable.getTransferData(this.uriListFlavor);
                list = FileDropHandler.uriListToFileList(string);
            } else {
                Object object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                list = (List)List.class.cast(object);
            }
        }
        catch (Exception exception) {}
        return list;
    }

    private boolean isImageFile(File file) {
        int n = 0;
        while (n < imageFilters.length) {
            if (imageFilters[n].accept(file)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static List<File> uriListToFileList(String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("#")) continue;
            try {
                URI uRI = new URI(string2);
                File file = new File(uRI);
                arrayList.add(file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    private class DropListener
    extends DropTargetAdapter {
        private DropListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            FileDropHandler.this.dropList = null;
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            FileDropHandler.this.dropList = null;
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            FileDropHandler.this.dropList = null;
        }
    }
}

