/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.cabrillo.tracker.PlotTView;
import org.opensourcephysics.cabrillo.tracker.PlotTrackView;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TrackChooserTView;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.WorldTView;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.DeinterlaceFilter;
import org.opensourcephysics.media.core.ImageVideoRecorder;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.ScratchVideoRecorder;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.FontSizer;

public class ExportVideoDialog
extends JDialog {
    protected static ExportVideoDialog videoExporter;
    protected static HashMap<Object, VideoType> formats;
    protected static TreeSet<String> formatDescriptions;
    protected TrackerPanel trackerPanel;
    protected JButton saveAsButton;
    protected JButton closeButton;
    protected JComponent sizePanel;
    protected JComponent viewPanel;
    protected JComponent contentPanel;
    protected JComponent formatPanel;
    protected JComboBox formatDropdown;
    protected JComboBox viewDropdown;
    protected JComboBox sizeDropdown;
    protected JComboBox contentDropdown;
    protected JLabel clipPropertiesLabel;
    protected AffineTransform transform = new AffineTransform();
    protected BufferedImage sizedImage;
    protected HashMap<Object, JComponent> views;
    protected HashMap<Object, Dimension> sizes;
    protected Dimension fullSize;
    protected boolean isRefreshing;
    protected int mainViewContentIndex;
    protected int worldViewContentIndex;
    protected String savedFilePath;
    protected PropertyChangeListener listener;
    protected boolean oddFirst = true;
    protected Object prevContentItem;

    static {
        formats = new HashMap();
        formatDescriptions = new TreeSet();
    }

    public static ExportVideoDialog getDialog(TrackerPanel trackerPanel) {
        ExportVideoDialog.refreshFormats();
        if (videoExporter == null) {
            videoExporter = new ExportVideoDialog(trackerPanel);
        }
        videoExporter.refreshFormatDropdown(VideoIO.getPreferredExportExtension());
        ExportVideoDialog.videoExporter.trackerPanel = trackerPanel;
        videoExporter.refreshGUI();
        return videoExporter;
    }

    public static void refreshFormats() {
        Object object;
        formats.clear();
        formatDescriptions.clear();
        ArrayList<VideoType> arrayList = new ArrayList<VideoType>();
        boolean bl = VideoIO.getEngine().equals("Xuggle") || VideoIO.getEngine().equals("none");
        boolean bl2 = VideoIO.getEngine().equals("QT") || VideoIO.getEngine().equals("none");
        Object[] objectArray = VideoIO.VIDEO_EXTENSIONS;
        int n = VideoIO.VIDEO_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            if (bl) {
                arrayList.add(VideoIO.getVideoType("QT", (String)object));
            }
            if (bl2) {
                arrayList.add(VideoIO.getVideoType("Xuggle", (String)object));
            }
            ++n2;
        }
        objectArray = VideoIO.getVideoTypes();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            if (object.canRecord() && !arrayList.contains(object)) {
                formats.put(object.getDescription(), (VideoType)object);
                formatDescriptions.add(object.getDescription());
            }
            ++n2;
        }
    }

    protected Object[] getFormats() {
        return formatDescriptions.toArray();
    }

    protected void setFormat(Object object) {
        if (object != null) {
            this.formatDropdown.setSelectedItem(object);
        }
    }

    public Object getFormat() {
        return this.formatDropdown.getSelectedItem();
    }

    protected String exportFullSizeVideo(String string) {
        if (this.trackerPanel.getVideo() == null) {
            return null;
        }
        this.viewDropdown.setSelectedIndex(0);
        this.contentDropdown.setSelectedIndex(1);
        this.sizeDropdown.setSelectedIndex(0);
        VideoType videoType = formats.get(this.formatDropdown.getSelectedItem());
        Dimension dimension = this.sizes.get(this.sizeDropdown.getSelectedItem());
        this.render(videoType, dimension, false, string);
        return this.savedFilePath;
    }

    private ExportVideoDialog(TrackerPanel trackerPanel) {
        super((Frame)trackerPanel.getTFrame(), true);
        this.trackerPanel = trackerPanel;
        this.setResizable(false);
        this.createGUI();
        this.refreshGUI();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getBounds().width) / 2;
        int n2 = (dimension.height - this.getBounds().height) / 2;
        this.setLocation(n, n2);
    }

    private void createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        Box box = Box.createVerticalBox();
        jPanel.add((Component)box, "Center");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        this.sizes = new HashMap();
        this.sizePanel = Box.createVerticalBox();
        this.sizeDropdown = new JComboBox();
        this.sizePanel.add(this.sizeDropdown);
        this.views = new HashMap();
        this.viewPanel = new JPanel(new GridLayout(0, 1));
        this.viewDropdown = new JComboBox();
        this.viewPanel.add(this.viewDropdown);
        this.viewDropdown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && !ExportVideoDialog.this.isRefreshing) {
                    ExportVideoDialog.this.refreshDropdowns();
                }
            }
        });
        this.contentPanel = new JPanel(new GridLayout(0, 1));
        this.contentDropdown = new JComboBox();
        this.contentPanel.add(this.contentDropdown);
        this.contentDropdown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (ExportVideoDialog.this.isRefreshing) {
                    return;
                }
                if (itemEvent.getStateChange() == 2) {
                    ExportVideoDialog.this.prevContentItem = itemEvent.getItem();
                }
                if (itemEvent.getStateChange() == 1) {
                    JComponent jComponent = ExportVideoDialog.this.views.get(ExportVideoDialog.this.viewDropdown.getSelectedItem());
                    if (jComponent == ExportVideoDialog.this.trackerPanel) {
                        ExportVideoDialog.this.mainViewContentIndex = ExportVideoDialog.this.contentDropdown.getSelectedIndex();
                    } else if (jComponent instanceof WorldTView) {
                        ExportVideoDialog.this.worldViewContentIndex = ExportVideoDialog.this.contentDropdown.getSelectedIndex();
                    }
                    if (ExportVideoDialog.this.contentDropdown.getSelectedIndex() == 3) {
                        JRadioButton jRadioButton = new JRadioButton(TrackerRes.getString("ExportVideoDialog.Deinterlace.OddFirst"));
                        jRadioButton.setSelected(ExportVideoDialog.this.oddFirst);
                        JRadioButton jRadioButton2 = new JRadioButton(TrackerRes.getString("ExportVideoDialog.Deinterlace.EvenFirst"));
                        jRadioButton2.setSelected(!ExportVideoDialog.this.oddFirst);
                        ButtonGroup buttonGroup = new ButtonGroup();
                        buttonGroup.add(jRadioButton);
                        buttonGroup.add(jRadioButton2);
                        JPanel jPanel = new JPanel();
                        jPanel.add(jRadioButton);
                        jPanel.add(jRadioButton2);
                        int n = JOptionPane.showConfirmDialog(ExportVideoDialog.this, jPanel, TrackerRes.getString("ExportVideoDialog.Deinterlace.Dialog.Title"), 2, -1);
                        if (n == 2 && ExportVideoDialog.this.prevContentItem != null) {
                            ExportVideoDialog.this.contentDropdown.setSelectedItem(ExportVideoDialog.this.prevContentItem);
                            ExportVideoDialog.this.prevContentItem = null;
                            return;
                        }
                        ExportVideoDialog.this.oddFirst = jRadioButton.isSelected();
                    }
                    ExportVideoDialog.this.refreshDropdowns();
                }
            }
        });
        this.formatPanel = new JPanel(new GridLayout(0, 1));
        this.formatDropdown = new JComboBox();
        this.formatPanel.add(this.formatDropdown);
        box.add(jPanel2);
        box.add(jPanel3);
        jPanel2.add(this.viewPanel);
        jPanel2.add(this.contentPanel);
        jPanel3.add(this.sizePanel);
        jPanel3.add(this.formatPanel);
        this.saveAsButton = new JButton();
        this.saveAsButton.setForeground(new Color(0, 0, 102));
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoType videoType = formats.get(ExportVideoDialog.this.formatDropdown.getSelectedItem());
                Dimension dimension = ExportVideoDialog.this.sizes.get(ExportVideoDialog.this.sizeDropdown.getSelectedItem());
                ExportVideoDialog.this.render(videoType, dimension, true, null);
            }
        });
        this.closeButton = new JButton();
        this.closeButton.setForeground(new Color(0, 0, 102));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportVideoDialog.this.setVisible(false);
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel.add((Component)jPanel4, "South");
        jPanel4.add(this.saveAsButton);
        jPanel4.add(this.closeButton);
        this.clipPropertiesLabel = new JLabel();
        this.clipPropertiesLabel.setHorizontalAlignment(0);
        this.clipPropertiesLabel.setBorder(BorderFactory.createEmptyBorder(4, 8, 2, 8));
        jPanel.add((Component)this.clipPropertiesLabel, "North");
    }

    private void refreshGUI() {
        String string;
        String string2;
        String string3 = TrackerRes.getString("ExportVideoDialog.Title");
        this.setTitle(string3);
        VideoClip videoClip = this.trackerPanel.getPlayer().getClipControl().getVideoClip();
        String string4 = MediaRes.getString("Filter.Sum.Label.FrameCount").toLowerCase();
        if (string4.endsWith(":")) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        if ((string2 = MediaRes.getString("ClipInspector.Label.StartFrame").toLowerCase()).endsWith(":")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((string = MediaRes.getString("ClipInspector.Label.StepSize").toLowerCase()).endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        string3 = String.valueOf(TrackerRes.getString("ExportVideoDialog.Label.ClipSettings")) + ": " + string4 + " " + videoClip.getStepCount() + ", " + string2 + " " + videoClip.getStartFrameNumber() + ", " + string + " " + videoClip.getStepSize();
        this.clipPropertiesLabel.setText(string3);
        string3 = TrackerRes.getString("ExportVideoDialog.Subtitle.Size");
        Border border = BorderFactory.createEmptyBorder(0, 4, 6, 4);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string3);
        int n = FontSizer.getLevel();
        FontSizer.setFonts(titledBorder, n);
        this.sizePanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, border));
        string3 = TrackerRes.getString("ExportVideoDialog.Subtitle.View");
        titledBorder = BorderFactory.createTitledBorder(string3);
        FontSizer.setFonts(titledBorder, n);
        this.viewPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, border));
        string3 = TrackerRes.getString("ExportVideoDialog.Subtitle.Content");
        titledBorder = BorderFactory.createTitledBorder(string3);
        FontSizer.setFonts(titledBorder, n);
        this.contentPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, border));
        string3 = TrackerRes.getString("ExportVideoDialog.Subtitle.Format");
        titledBorder = BorderFactory.createTitledBorder(string3);
        FontSizer.setFonts(titledBorder, n);
        this.formatPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, border));
        this.saveAsButton.setText(TrackerRes.getString("ExportVideoDialog.Button.SaveAs"));
        this.closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
        Object object = this.viewDropdown.getSelectedItem();
        this.viewDropdown.removeAllItems();
        String string5 = TrackerRes.getString("TFrame.View.Main");
        string5 = String.valueOf(string5) + " (0)";
        this.views.put(string5, this.trackerPanel);
        this.viewDropdown.addItem(string5);
        Container[] containerArray = this.trackerPanel.getTFrame().getViews(this.trackerPanel);
        int n2 = 0;
        while (n2 < containerArray.length) {
            if (this.trackerPanel.getTFrame().isViewOpen(n2, this.trackerPanel)) {
                String string6 = " (" + (n2 + 1) + ")";
                if (containerArray[n2] instanceof TViewChooser) {
                    JPanel jPanel;
                    TViewChooser tViewChooser = (TViewChooser)containerArray[n2];
                    TView tView = tViewChooser.getSelectedView();
                    if (tView instanceof WorldTView) {
                        string5 = String.valueOf(tView.getViewName()) + string6;
                        jPanel = (WorldTView)tView;
                        this.views.put(string5, jPanel);
                        this.viewDropdown.addItem(string5);
                    } else if (tView instanceof PlotTView) {
                        string5 = String.valueOf(tView.getViewName()) + string6;
                        jPanel = (PlotTView)tView;
                        TTrack tTrack = ((TrackChooserTView)jPanel).getSelectedTrack();
                        if (tTrack != null) {
                            PlotTrackView plotTrackView = (PlotTrackView)((TrackChooserTView)jPanel).getTrackView(tTrack);
                            this.views.put(string5, plotTrackView);
                            this.viewDropdown.addItem(string5);
                        }
                    }
                }
            }
            ++n2;
        }
        string5 = TrackerRes.getString("TMenuBar.MenuItem.CopyFrame");
        this.views.put(string5, (JComponent)this.trackerPanel.getTFrame().getContentPane());
        this.viewDropdown.addItem(string5);
        if (object != null) {
            this.viewDropdown.setSelectedItem(object);
        }
        this.pack();
        this.refreshDropdowns();
    }

    private void refreshDropdowns() {
        this.isRefreshing = true;
        JComponent jComponent = this.views.get(this.viewDropdown.getSelectedItem());
        Video video = this.trackerPanel.getVideo();
        String string = null;
        this.contentDropdown.removeAllItems();
        if (jComponent == this.trackerPanel) {
            if (video != null) {
                string = TrackerRes.getString("ExportVideoDialog.Content.VideoAndGraphics");
                this.contentDropdown.addItem(string);
                string = TrackerRes.getString("ExportVideoDialog.Content.VideoOnly");
                this.contentDropdown.addItem(string);
            }
            string = TrackerRes.getString("ExportVideoDialog.Content.GraphicsOnly");
            this.contentDropdown.addItem(string);
            if (video != null) {
                if (this.trackerPanel.getPlayer().getClipControl().getVideoClip().getStepCount() > 1) {
                    string = TrackerRes.getString("ExportVideoDialog.Content.DeinterlacedVideo");
                    this.contentDropdown.addItem(string);
                }
                this.contentDropdown.setSelectedIndex(this.mainViewContentIndex);
            }
        } else if (jComponent instanceof WorldTView) {
            if (video != null) {
                string = TrackerRes.getString("ExportVideoDialog.Content.VideoAndGraphics");
                this.contentDropdown.addItem(string);
            }
            string = TrackerRes.getString("ExportVideoDialog.Content.GraphicsOnly");
            this.contentDropdown.addItem(string);
            if (video != null) {
                this.contentDropdown.setSelectedIndex(this.worldViewContentIndex);
            }
        } else {
            string = TrackerRes.getString("ExportVideoDialog.Content.GraphicsOnly");
            this.contentDropdown.addItem(string);
        }
        Object object = this.sizeDropdown.getSelectedItem();
        this.sizeDropdown.removeAllItems();
        if (jComponent == this.trackerPanel) {
            Object object2;
            int n = this.contentDropdown.getSelectedIndex();
            if (n == 1 || n == 3) {
                object2 = this.trackerPanel.getVideo().getImage();
                this.fullSize = this.getAcceptedDimension(((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight());
                string = String.valueOf(this.fullSize.width) + "x" + this.fullSize.height;
                string = String.valueOf(string) + " (" + TrackerRes.getString("ExportVideoDialog.VideoSize") + ")";
                this.sizeDropdown.addItem(string);
                this.sizes.put(string, this.fullSize);
            } else {
                object2 = this.trackerPanel.getMat().mat;
                this.fullSize = this.getAcceptedDimension(((Rectangle)object2).width, ((Rectangle)object2).height);
                string = String.valueOf(this.fullSize.width) + "x" + this.fullSize.height;
                string = String.valueOf(string) + " (" + TrackerRes.getString("ExportVideoDialog.MatSize") + ")";
                this.sizeDropdown.addItem(string);
                this.sizes.put(string, this.fullSize);
            }
            object2 = new Dimension(this.fullSize.width * 8 / 10, this.fullSize.height * 8 / 10);
            if (this.isAcceptedDimension(((Dimension)object2).width, ((Dimension)object2).height)) {
                string = String.valueOf(((Dimension)object2).width) + "x" + ((Dimension)object2).height;
                this.sizeDropdown.addItem(string);
                this.sizes.put(string, (Dimension)object2);
            }
            object2 = new Dimension(this.fullSize.width * 3 / 4, this.fullSize.height * 3 / 4);
            if (this.isAcceptedDimension(((Dimension)object2).width, ((Dimension)object2).height)) {
                string = String.valueOf(((Dimension)object2).width) + "x" + ((Dimension)object2).height;
                this.sizeDropdown.addItem(string);
                this.sizes.put(string, (Dimension)object2);
            }
            object2 = new Dimension(this.fullSize.width * 6 / 10, this.fullSize.height * 6 / 10);
            if (this.isAcceptedDimension(((Dimension)object2).width, ((Dimension)object2).height)) {
                string = String.valueOf(((Dimension)object2).width) + "x" + ((Dimension)object2).height;
                this.sizeDropdown.addItem(string);
                this.sizes.put(string, (Dimension)object2);
            }
            object2 = new Dimension(this.fullSize.width / 2, this.fullSize.height / 2);
            if (this.isAcceptedDimension(((Dimension)object2).width, ((Dimension)object2).height)) {
                string = String.valueOf(((Dimension)object2).width) + "x" + ((Dimension)object2).height;
                this.sizeDropdown.addItem(string);
                this.sizes.put(string, (Dimension)object2);
            }
            object2 = new Dimension(this.fullSize.width * 4 / 10, this.fullSize.height * 4 / 10);
            if (this.isAcceptedDimension(((Dimension)object2).width, ((Dimension)object2).height)) {
                string = String.valueOf(((Dimension)object2).width) + "x" + ((Dimension)object2).height;
                this.sizeDropdown.addItem(string);
                this.sizes.put(string, (Dimension)object2);
            }
            object2 = new Dimension(this.fullSize.width * 3 / 8, this.fullSize.height * 3 / 8);
            if (this.isAcceptedDimension(((Dimension)object2).width, ((Dimension)object2).height)) {
                string = String.valueOf(((Dimension)object2).width) + "x" + ((Dimension)object2).height;
                this.sizeDropdown.addItem(string);
                this.sizes.put(string, (Dimension)object2);
            }
            object2 = new Dimension(this.fullSize.width * 3 / 10, this.fullSize.height * 3 / 10);
            if (this.isAcceptedDimension(((Dimension)object2).width, ((Dimension)object2).height)) {
                string = String.valueOf(((Dimension)object2).width) + "x" + ((Dimension)object2).height;
                this.sizeDropdown.addItem(string);
                this.sizes.put(string, (Dimension)object2);
            }
            object2 = new Dimension(this.fullSize.width / 4, this.fullSize.height / 4);
            if (this.isAcceptedDimension(((Dimension)object2).width, ((Dimension)object2).height)) {
                string = String.valueOf(((Dimension)object2).width) + "x" + ((Dimension)object2).height;
                this.sizeDropdown.addItem(string);
                this.sizes.put(string, (Dimension)object2);
            }
            object2 = new Dimension(this.fullSize.width * 2 / 10, this.fullSize.height * 2 / 10);
            if (this.isAcceptedDimension(((Dimension)object2).width, ((Dimension)object2).height)) {
                string = String.valueOf(((Dimension)object2).width) + "x" + ((Dimension)object2).height;
                this.sizeDropdown.addItem(string);
                this.sizes.put(string, (Dimension)object2);
            }
        } else if (jComponent instanceof PlotTrackView) {
            PlotTrackView plotTrackView = (PlotTrackView)jComponent;
            Dimension dimension = plotTrackView.mainView.getSize();
            this.fullSize = this.getAcceptedDimension(dimension.width, dimension.height);
            string = String.valueOf(this.fullSize.width) + "x" + this.fullSize.height;
            this.sizeDropdown.addItem(string);
            this.sizes.put(string, this.fullSize);
        } else {
            Dimension dimension = jComponent.getSize();
            this.fullSize = this.getAcceptedDimension(dimension.width, dimension.height);
            string = String.valueOf(this.fullSize.width) + "x" + this.fullSize.height;
            this.sizeDropdown.addItem(string);
            this.sizes.put(string, this.fullSize);
        }
        if (this.sizes.keySet().contains(object)) {
            this.sizeDropdown.setSelectedItem(object);
        }
        this.isRefreshing = false;
    }

    public void refreshFormatDropdown(String string) {
        String[] stringArray;
        Object object = this.formatDropdown.getSelectedItem();
        boolean bl = false;
        String string2 = null;
        this.formatDropdown.removeAllItems();
        String[] stringArray2 = stringArray = formatDescriptions.toArray(new String[0]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            this.formatDropdown.addItem(string3);
            if (string3.equals(object)) {
                bl = true;
            }
            if (string2 == null && string3.contains("." + string)) {
                string2 = string3;
            }
            ++n2;
        }
        if (string2 != null) {
            this.setFormat(string2);
        } else if (bl) {
            this.setFormat(object);
        }
    }

    public void setFontLevel(int n) {
        JComboBox[] jComboBoxArray;
        FontSizer.setFonts(this, n);
        JComboBox[] jComboBoxArray2 = jComboBoxArray = new JComboBox[]{this.formatDropdown, this.viewDropdown, this.sizeDropdown, this.contentDropdown};
        int n2 = jComboBoxArray.length;
        int n3 = 0;
        while (n3 < n2) {
            JComboBox jComboBox = jComboBoxArray2[n3];
            int n4 = jComboBox.getSelectedIndex();
            Object[] objectArray = new Object[jComboBox.getItemCount()];
            int n5 = 0;
            while (n5 < objectArray.length) {
                objectArray[n5] = jComboBox.getItemAt(n5);
                ++n5;
            }
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
            jComboBox.setModel(defaultComboBoxModel);
            jComboBox.setSelectedItem(n4);
            ++n3;
        }
        this.refreshGUI();
        this.pack();
    }

    private Dimension getAcceptedDimension(int n, int n2) {
        if (!this.isAcceptedDimension(n, n2)) {
            while (n % 16 != 0) {
                ++n;
            }
            while (n2 % 16 != 0) {
                ++n2;
            }
        }
        return new Dimension(n, n2);
    }

    private boolean isAcceptedDimension(int n, int n2) {
        if (n < 160 || n2 < 120) {
            return false;
        }
        if (n % 4 != 0 || n2 % 4 != 0) {
            return false;
        }
        if (1.0 * (double)n2 / (double)n == 0.75) {
            return true;
        }
        if (1.0 * (double)n / (double)n2 == 1.5) {
            return true;
        }
        if (16.0 * (double)n2 / (double)n == 9.0) {
            return true;
        }
        return n % 16 == 0 && n2 % 16 == 0;
    }

    private void setVideoVisible(boolean bl) {
        if (this.trackerPanel.getVideo() == null) {
            return;
        }
        TMenuBar tMenuBar = TMenuBar.getMenuBar(this.trackerPanel);
        JCheckBoxMenuItem jCheckBoxMenuItem = tMenuBar.videoVisibleItem;
        if (jCheckBoxMenuItem.isSelected() != bl) {
            jCheckBoxMenuItem.doClick(0);
        }
    }

    private void render(VideoType videoType, Dimension dimension, boolean bl, String string) {
        String string2;
        Object object;
        Object object2;
        Object object3;
        PlotTrackView plotTrackView;
        Object object4;
        this.setVisible(false);
        this.savedFilePath = null;
        Video video = this.trackerPanel.getVideo();
        boolean bl2 = video != null && video.isVisible();
        double d = this.trackerPanel.getMagnification();
        JComponent jComponent = this.views.get(this.viewDropdown.getSelectedItem());
        if (jComponent == this.trackerPanel && this.contentDropdown.getSelectedIndex() != 1) {
            double d2 = dimension.getWidth() / this.fullSize.getWidth();
            if (d2 != d) {
                this.trackerPanel.setMagnification(d2);
            }
            if (this.contentDropdown.getSelectedIndex() == 0) {
                this.setVideoVisible(true);
            } else if (this.contentDropdown.getSelectedIndex() == 2) {
                this.setVideoVisible(false);
            }
        } else if (jComponent instanceof WorldTView) {
            this.setVideoVisible(this.contentDropdown.getSelectedIndex() == 0);
        } else if (jComponent instanceof PlotTrackView && !((Dimension)(object4 = (plotTrackView = (PlotTrackView)jComponent).getViewport().getExtentSize())).equals(object3 = plotTrackView.getViewport().getView().getSize())) {
            JOptionPane.showMessageDialog(this.trackerPanel, TrackerRes.getString("ExportVideo.Dialog.HiddenPlots.Message"), TrackerRes.getString("ExportVideo.Dialog.HiddenPlots.Title"), 2);
            this.setVisible(true);
            return;
        }
        VideoPlayer videoPlayer = this.trackerPanel.getPlayer();
        videoPlayer.stop();
        videoPlayer.setEnabled(false);
        object4 = videoPlayer.getClipControl();
        object3 = ((ClipControl)object4).getVideoClip();
        int n = ((VideoClip)object3).getStepCount() + 1;
        VideoRecorder videoRecorder = videoType.getRecorder();
        double d3 = videoPlayer.getMeanStepDuration();
        if (this.contentDropdown.getSelectedIndex() == 3) {
            d3 /= 2.0;
        }
        videoRecorder.setFrameDuration(d3);
        if (videoRecorder instanceof ScratchVideoRecorder) {
            object2 = (ScratchVideoRecorder)videoRecorder;
            object = XML.stripExtension(this.trackerPanel.getTitle()).trim();
            string2 = this.viewDropdown.getSelectedItem().toString().trim().toLowerCase();
            int n2 = string2.indexOf(" ");
            if (n2 > -1) {
                string2 = string2.substring(0, n2);
            }
            ((ScratchVideoRecorder)object2).suggestFileName(String.valueOf(object) + "-" + string2);
        }
        if (videoRecorder instanceof ImageVideoRecorder) {
            object2 = (ImageVideoRecorder)videoRecorder;
            ((ImageVideoRecorder)object2).setExpectedFrameCount(((VideoClip)object3).getStepCount());
        }
        try {
            videoRecorder.createVideo(string);
            this.savedFilePath = videoRecorder.getFileName();
            if (this.savedFilePath == null) {
                this.trackerPanel.setMagnification(d);
                this.setVideoVisible(bl2);
                this.setVisible(true);
                videoPlayer.setEnabled(true);
                videoRecorder.reset();
                return;
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.trackerPanel, iOException.getMessage(), "Error", 2);
        }
        if (((VideoClip)object3).getStepCount() == 1) {
            try {
                BufferedImage[] bufferedImageArray = this.getNextImages(dimension);
                int n3 = bufferedImageArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    object2 = bufferedImageArray[n4];
                    videoRecorder.addFrame((Image)object2);
                    ++n4;
                }
                this.savedFilePath = videoRecorder.saveVideo();
                if (this.savedFilePath == null) {
                    videoRecorder.reset();
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.trackerPanel, iOException.getMessage(), "Error", 2);
            }
        } else {
            object2 = XML.getName(videoRecorder.getFileName());
            object = new ProgressMonitor(this.trackerPanel.getTFrame(), String.valueOf(TrackerRes.getString("TActions.SaveClipAs.ProgressMonitor.Message")) + " " + (String)object2, "", 0, n);
            ((ProgressMonitor)object).setMillisToPopup(2000);
            ((ProgressMonitor)object).setProgress(1);
            this.listener = new PropertyChangeListener((ProgressMonitor)object, (ClipControl)object4, d, bl2, videoPlayer, videoRecorder, (VideoClip)object3, n, dimension, bl){
                private final /* synthetic */ ProgressMonitor val$monitor;
                private final /* synthetic */ ClipControl val$playControl;
                private final /* synthetic */ double val$magnification;
                private final /* synthetic */ boolean val$videoIsVisible;
                private final /* synthetic */ VideoPlayer val$player;
                private final /* synthetic */ VideoRecorder val$recorder;
                private final /* synthetic */ VideoClip val$clip;
                private final /* synthetic */ int val$taskLength;
                private final /* synthetic */ Dimension val$size;
                private final /* synthetic */ boolean val$showOpenDialog;
                {
                    this.val$monitor = progressMonitor;
                    this.val$playControl = clipControl;
                    this.val$magnification = d;
                    this.val$videoIsVisible = bl;
                    this.val$player = videoPlayer;
                    this.val$recorder = videoRecorder;
                    this.val$clip = videoClip;
                    this.val$taskLength = n;
                    this.val$size = dimension;
                    this.val$showOpenDialog = bl2;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    final int n = (Integer)propertyChangeEvent.getNewValue() + 1;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (val$monitor.isCanceled()) {
                                ExportVideoDialog.this.firePropertyChange("video_cancelled", null, null);
                                val$monitor.close();
                                val$playControl.removePropertyChangeListener("stepnumber", (this).ExportVideoDialog.this.listener);
                                (this).ExportVideoDialog.this.trackerPanel.setMagnification(val$magnification);
                                ExportVideoDialog.this.setVideoVisible(val$videoIsVisible);
                                val$player.setEnabled(true);
                                val$recorder.reset();
                                return;
                            }
                            if (val$playControl.getStepNumber() == val$clip.getStepCount() - 1) {
                                val$playControl.removePropertyChangeListener("stepnumber", (this).ExportVideoDialog.this.listener);
                            }
                            val$monitor.setProgress(n);
                            String string = String.format(String.valueOf(TrackerRes.getString("TActions.SaveClipAs.ProgressMonitor.Progress")) + " %d%%.\n", n * 100 / val$taskLength);
                            val$monitor.setNote(string);
                            try {
                                Object object;
                                Object object2 = ExportVideoDialog.this.getNextImages(val$size);
                                int n3 = ((BufferedImage[])object2).length;
                                int n2 = 0;
                                while (n2 < n3) {
                                    object = object2[n2];
                                    val$recorder.addFrame((Image)object);
                                    ++n2;
                                }
                                System.gc();
                                if (val$playControl.getStepNumber() == val$clip.getStepCount() - 1) {
                                    (this).ExportVideoDialog.this.savedFilePath = val$recorder.saveVideo();
                                    val$monitor.setProgress(n + 1);
                                    val$recorder.reset();
                                    (this).ExportVideoDialog.this.trackerPanel.setMagnification(val$magnification);
                                    ExportVideoDialog.this.setVideoVisible(val$videoIsVisible);
                                    val$player.setEnabled(true);
                                    object = XML.getExtension((this).ExportVideoDialog.this.savedFilePath);
                                    VideoIO.setPreferredExportExtension((String)object);
                                    TFrame tFrame = (this).ExportVideoDialog.this.trackerPanel.getTFrame();
                                    if (val$showOpenDialog && (n3 = JOptionPane.showConfirmDialog(tFrame, String.valueOf(TrackerRes.getString("ExportVideoDialog.Complete.Message1")) + " " + XML.getName((this).ExportVideoDialog.this.savedFilePath) + XML.NEW_LINE + TrackerRes.getString("ExportVideoDialog.Complete.Message2"), TrackerRes.getString("ExportVideoDialog.Complete.Title"), 0, 3)) == 0) {
                                        tFrame.loadedFiles.remove((this).ExportVideoDialog.this.savedFilePath);
                                        object2 = new File((this).ExportVideoDialog.this.savedFilePath);
                                        Runnable runnable = new Runnable((File)object2, tFrame){
                                            private final /* synthetic */ File val$file;
                                            private final /* synthetic */ TFrame val$frame;
                                            {
                                                this.val$file = file;
                                                this.val$frame = tFrame;
                                            }

                                            @Override
                                            public void run() {
                                                TrackerIO.open(this.val$file, this.val$frame);
                                            }
                                        };
                                        SwingUtilities.invokeLater(runnable);
                                    }
                                    ExportVideoDialog.this.firePropertyChange("video_saved", null, (this).ExportVideoDialog.this.savedFilePath);
                                } else {
                                    val$playControl.step();
                                }
                            }
                            catch (Exception exception) {
                                JOptionPane.showMessageDialog((this).ExportVideoDialog.this.trackerPanel, exception.getMessage(), "Error", 2);
                                val$monitor.close();
                                val$playControl.removePropertyChangeListener("stepnumber", (this).ExportVideoDialog.this.listener);
                                (this).ExportVideoDialog.this.trackerPanel.setMagnification(val$magnification);
                                ExportVideoDialog.this.setVideoVisible(val$videoIsVisible);
                                val$player.setEnabled(true);
                                val$recorder.reset();
                                return;
                            }
                        }
                    };
                    EventQueue.invokeLater(runnable);
                }
            };
            ((ClipControl)object4).addPropertyChangeListener("stepnumber", this.listener);
            if (((ClipControl)object4).getStepNumber() == 0) {
                string2 = String.format(String.valueOf(TrackerRes.getString("TActions.SaveClipAs.ProgressMonitor.Progress")) + " %d%%.\n", 100 / n);
                ((ProgressMonitor)object).setNote(string2);
                try {
                    BufferedImage[] bufferedImageArray = this.getNextImages(dimension);
                    int n5 = bufferedImageArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        BufferedImage bufferedImage = bufferedImageArray[n6];
                        videoRecorder.addFrame(bufferedImage);
                        ++n6;
                    }
                    System.gc();
                    ((ClipControl)object4).step();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.trackerPanel, exception.getMessage(), "Error", 2);
                    ((ProgressMonitor)object).close();
                    this.trackerPanel.setMagnification(d);
                    this.setVideoVisible(bl2);
                    videoPlayer.setEnabled(true);
                    videoRecorder.reset();
                    return;
                }
            } else {
                ((ClipControl)object4).setStepNumber(0);
            }
        }
    }

    private BufferedImage[] getNextImages(Dimension dimension) {
        JComponent jComponent = this.views.get(this.viewDropdown.getSelectedItem());
        if (jComponent == this.trackerPanel) {
            if (this.contentDropdown.getSelectedIndex() == 1) {
                BufferedImage bufferedImage = this.trackerPanel.getVideo().getImage();
                return new BufferedImage[]{this.getResizedImage(bufferedImage, dimension)};
            }
            if (this.contentDropdown.getSelectedIndex() == 3) {
                boolean bl;
                DeinterlaceFilter deinterlaceFilter = (DeinterlaceFilter)this.trackerPanel.getVideo().getFilterStack().getFilter(DeinterlaceFilter.class);
                if (deinterlaceFilter == null) {
                    deinterlaceFilter = new DeinterlaceFilter();
                    this.trackerPanel.getVideo().getFilterStack().addFilter(deinterlaceFilter);
                }
                if ((bl = deinterlaceFilter.isOdd()) != this.oddFirst) {
                    deinterlaceFilter.setOdd(this.oddFirst);
                }
                BufferedImage bufferedImage = this.trackerPanel.getVideo().getImage();
                BufferedImage bufferedImage2 = this.getResizedCopy(bufferedImage, dimension);
                deinterlaceFilter.setOdd(!this.oddFirst);
                bufferedImage = this.trackerPanel.getVideo().getImage();
                BufferedImage bufferedImage3 = this.getResizedCopy(bufferedImage, dimension);
                return new BufferedImage[]{bufferedImage2, bufferedImage3};
            }
            BufferedImage bufferedImage = this.trackerPanel.renderMat();
            return new BufferedImage[]{this.getResizedImage(bufferedImage, dimension)};
        }
        if (jComponent instanceof WorldTView) {
            BufferedImage bufferedImage = (BufferedImage)jComponent.createImage(dimension.width, dimension.height);
            bufferedImage = ((WorldTView)jComponent).render(bufferedImage);
            return new BufferedImage[]{this.getResizedImage(bufferedImage, dimension)};
        }
        if (jComponent instanceof PlotTrackView) {
            jComponent = ((PlotTrackView)jComponent).mainView;
            BufferedImage bufferedImage = (BufferedImage)jComponent.createImage(dimension.width, dimension.height);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            jComponent.paint(graphics2D);
            graphics2D.dispose();
            return new BufferedImage[]{bufferedImage};
        }
        BufferedImage bufferedImage = (BufferedImage)jComponent.createImage(dimension.width, dimension.height);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        jComponent.paint(graphics2D);
        graphics2D.dispose();
        return new BufferedImage[]{bufferedImage};
    }

    private BufferedImage getResizedImage(BufferedImage bufferedImage, Dimension dimension) {
        if (dimension.width == bufferedImage.getWidth() && dimension.height == bufferedImage.getHeight()) {
            return bufferedImage;
        }
        if (this.sizedImage == null || this.sizedImage.getWidth() != dimension.width || this.sizedImage.getHeight() != dimension.height) {
            this.sizedImage = new BufferedImage(dimension.width, dimension.height, bufferedImage.getType());
        }
        Graphics2D graphics2D = this.sizedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(bufferedImage, 0, 0, dimension.width, dimension.height, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        graphics2D.dispose();
        return this.sizedImage;
    }

    private BufferedImage getResizedCopy(BufferedImage bufferedImage, Dimension dimension) {
        BufferedImage bufferedImage2 = new BufferedImage(dimension.width, dimension.height, bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(bufferedImage, 0, 0, dimension.width, dimension.height, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        graphics2D.dispose();
        return bufferedImage2;
    }
}

