/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.cabrillo.tracker.DynamicParticle;
import org.opensourcephysics.cabrillo.tracker.DynamicSystem;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.TActions;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FontSizer;

public class DynamicSystemInspector
extends JDialog
implements PropertyChangeListener {
    protected DynamicSystem system;
    protected TrackerPanel trackerPanel;
    protected boolean isVisible;
    protected int particleCount;
    protected JButton closeButton;
    protected JButton helpButton;
    protected ActionListener changeParticleListener;
    protected JPanel[] particlePanels;
    protected JButton[] changeButtons;
    protected DynamicParticle[] selectedParticles;
    protected JLabel[] particleLabels;
    protected TButton[] particleButtons;
    protected JPanel[] labelPanels;
    protected DynamicParticle newParticle;
    protected TButton systemButton;
    protected MouseListener selectListener;

    public DynamicSystemInspector(DynamicSystem dynamicSystem) {
        super(JOptionPane.getFrameForComponent(dynamicSystem.trackerPanel), false);
        this.system = dynamicSystem;
        this.particleCount = 2;
        this.trackerPanel = this.system.trackerPanel;
        if (this.trackerPanel != null) {
            this.trackerPanel.addPropertyChangeListener("track", this);
            TFrame tFrame = this.trackerPanel.getTFrame();
            if (tFrame != null) {
                tFrame.addPropertyChangeListener("tab", this);
            }
        }
        this.setResizable(false);
        this.createGUI();
        this.initialize();
    }

    public void initialize() {
        FontSizer.setFonts(this, FontSizer.getLevel());
        this.updateDisplay();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("tab")) {
            if (this.trackerPanel != null && propertyChangeEvent.getNewValue() == this.trackerPanel) {
                this.setVisible(this.isVisible);
            } else {
                boolean bl = this.isVisible;
                this.setVisible(false);
                this.isVisible = bl;
            }
        } else if (propertyChangeEvent.getPropertyName().equals("track") && propertyChangeEvent.getNewValue() instanceof DynamicParticle) {
            this.newParticle = (DynamicParticle)propertyChangeEvent.getNewValue();
            this.updateDisplay();
        } else {
            this.updateDisplay();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.isVisible = bl;
    }

    @Override
    public void dispose() {
        if (this.trackerPanel != null) {
            this.trackerPanel.removePropertyChangeListener("track", this);
            for (PointMass propertyChangeListener2 : this.trackerPanel.getDrawables(DynamicParticle.class)) {
                propertyChangeListener2.removePropertyChangeListener("name", this);
                propertyChangeListener2.removePropertyChangeListener("color", this);
                propertyChangeListener2.removePropertyChangeListener("footprint", this);
            }
            TFrame tFrame = this.trackerPanel.getTFrame();
            if (tFrame != null) {
                tFrame.removePropertyChangeListener("tab", this);
            }
        }
        super.dispose();
    }

    private void createGUI() {
        JPanel jPanel;
        this.changeParticleListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem;
                JMenuItem jMenuItem2;
                final JButton jButton = (JButton)actionEvent.getSource();
                final int n = jButton == DynamicSystemInspector.this.changeButtons[0] ? 0 : 1;
                final Action action = TActions.getAction("cloneTrack", DynamicSystemInspector.this.trackerPanel);
                final Action action2 = TActions.getAction("dynamicParticle", DynamicSystemInspector.this.trackerPanel);
                final Action action3 = TActions.getAction("dynamicParticlePolar", DynamicSystemInspector.this.trackerPanel);
                JPopupMenu jPopupMenu = new JPopupMenu();
                boolean bl = false;
                JMenu jMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.Clone"));
                for (DynamicParticle object2 : DynamicSystemInspector.this.trackerPanel.getDrawables(DynamicParticle.class)) {
                    if (object2 instanceof DynamicSystem) continue;
                    jMenuItem2 = new JMenuItem(object2.getName(), object2.getFootprint().getIcon(21, 16));
                    jMenuItem2.setActionCommand(object2.getName());
                    jMenuItem2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            (this).DynamicSystemInspector.this.newParticle = null;
                            action.actionPerformed(actionEvent);
                            if ((this).DynamicSystemInspector.this.newParticle != null) {
                                (this).DynamicSystemInspector.this.newParticle.getInspector();
                                (this).DynamicSystemInspector.this.selectedParticles[n] = (this).DynamicSystemInspector.this.newParticle;
                                DynamicSystemInspector.this.updateSystem();
                            }
                        }
                    });
                    jMenu.add(jMenuItem2);
                    if (object2 == DynamicSystemInspector.this.selectedParticles[0] || object2 == DynamicSystemInspector.this.selectedParticles[1] || object2.system != null) continue;
                    bl = true;
                    jMenuItem = new JMenuItem(object2.getName(), object2.getFootprint().getIcon(21, 16)){

                        @Override
                        public Dimension getPreferredSize() {
                            Dimension dimension = super.getPreferredSize();
                            int n = jButton.getPreferredSize().width - 2;
                            dimension.width = Math.max(n, dimension.width);
                            return dimension;
                        }
                    };
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            (this).DynamicSystemInspector.this.selectedParticles[n] = DynamicSystemInspector.this.getParticle(jMenuItem.getText());
                            DynamicSystemInspector.this.updateSystem();
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                }
                if (bl) {
                    jPopupMenu.addSeparator();
                }
                JMenu jMenu2 = new JMenu(TrackerRes.getString("TrackControl.Button.NewTrack")){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension dimension = super.getPreferredSize();
                        int n = jButton.getPreferredSize().width - 2;
                        dimension.width = Math.max(n, dimension.width);
                        return dimension;
                    }
                };
                jPopupMenu.add(jMenu2);
                jMenuItem2 = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Cartesian"));
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        (this).DynamicSystemInspector.this.newParticle = null;
                        action2.actionPerformed(actionEvent);
                        if ((this).DynamicSystemInspector.this.newParticle != null) {
                            (this).DynamicSystemInspector.this.newParticle.getInspector();
                            (this).DynamicSystemInspector.this.selectedParticles[n] = (this).DynamicSystemInspector.this.newParticle;
                            DynamicSystemInspector.this.updateSystem();
                        }
                    }
                });
                jMenu2.add(jMenuItem2);
                jMenuItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Polar"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        (this).DynamicSystemInspector.this.newParticle = null;
                        action3.actionPerformed(actionEvent);
                        if ((this).DynamicSystemInspector.this.newParticle != null) {
                            (this).DynamicSystemInspector.this.newParticle.getInspector();
                            (this).DynamicSystemInspector.this.selectedParticles[n] = (this).DynamicSystemInspector.this.newParticle;
                            DynamicSystemInspector.this.updateSystem();
                        }
                    }
                });
                jMenu2.add(jMenuItem);
                if (jMenu.getItemCount() > 0) {
                    jPopupMenu.add(jMenu);
                }
                JMenuItem jMenuItem3 = new JMenuItem(TrackerRes.getString("DynamicSystemInspector.ParticleName.None"));
                jMenuItem3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        (this).DynamicSystemInspector.this.newParticle = null;
                        (this).DynamicSystemInspector.this.selectedParticles[n] = null;
                        DynamicSystemInspector.this.updateSystem();
                    }
                });
                jPopupMenu.addSeparator();
                jPopupMenu.add(jMenuItem3);
                FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                jPopupMenu.show(jButton, 0, jButton.getHeight());
            }
        };
        this.selectListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TButton tButton = (TButton)mouseEvent.getSource();
                DynamicParticle dynamicParticle = DynamicSystemInspector.this.getParticle(tButton.getText());
                DynamicSystemInspector.this.trackerPanel.setSelectedTrack(dynamicParticle);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                DynamicSystemInspector.this.closeButton.requestFocusInWindow();
            }
        };
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.setContentPane(jPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        jPanel2.add((Component)jPanel3, "Center");
        this.particlePanels = new JPanel[this.particleCount];
        this.changeButtons = new JButton[this.particleCount];
        this.particleLabels = new JLabel[this.particleCount];
        this.particleButtons = new TButton[this.particleCount];
        this.labelPanels = new JPanel[this.particleCount];
        int n = 0;
        while (n < this.particleCount) {
            this.particlePanels[n] = new JPanel(new BorderLayout());
            jPanel3.add(this.particlePanels[n]);
            this.changeButtons[n] = new JButton();
            this.changeButtons[n].addActionListener(this.changeParticleListener);
            this.particleLabels[n] = new JLabel(TrackerRes.getString("DynamicSystemInspector.ParticleName.None")){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    dimension.height = DynamicSystemInspector.this.systemButton.getPreferredSize().height;
                    return dimension;
                }
            };
            this.particleLabels[n].setHorizontalAlignment(0);
            this.particleLabels[n].setAlignmentX(0.5f);
            this.particleButtons[n] = new TButton();
            this.particleButtons[n].setContentAreaFilled(false);
            this.particleButtons[n].addMouseListener(this.selectListener);
            this.particleButtons[n].setAlignmentX(0.5f);
            this.labelPanels[n] = new JPanel();
            this.labelPanels[n].setLayout(new BoxLayout(this.labelPanels[n], 1));
            this.labelPanels[n].add(this.particleLabels[n]);
            this.particlePanels[n].add((Component)this.labelPanels[n], "North");
            jPanel = new JPanel();
            jPanel.add(this.changeButtons[n]);
            this.particlePanels[n].add((Component)jPanel, "Center");
            ++n;
        }
        this.systemButton = new TButton();
        this.systemButton.setText(this.system.getName());
        this.systemButton.setIcon(this.system.getFootprint().getIcon(21, 16));
        this.systemButton.setContentAreaFilled(false);
        this.systemButton.addMouseListener(this.selectListener);
        this.systemButton.setAlignmentX(0.5f);
        this.helpButton = new JButton();
        this.helpButton.setForeground(new Color(0, 0, 102));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicSystemInspector.this.trackerPanel.getTFrame().showHelp("system", 0);
            }
        });
        this.closeButton = new JButton();
        this.closeButton.setForeground(new Color(0, 0, 102));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicSystemInspector.this.setVisible(false);
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel2.add((Component)jPanel4, "South");
        jPanel4.add(this.helpButton);
        jPanel4.add(this.closeButton);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(this.systemButton);
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 0));
        jPanel2.add((Component)jPanel, "North");
    }

    private void updateSystem() {
        if (this.selectedParticles[0] == null && this.selectedParticles[1] == null) {
            this.system.setParticles(new DynamicParticle[0]);
        } else if (this.selectedParticles[0] == null) {
            this.system.setParticles(new DynamicParticle[]{this.selectedParticles[1]});
        } else if (this.selectedParticles[1] == null) {
            this.system.setParticles(new DynamicParticle[]{this.selectedParticles[0]});
        } else {
            this.system.setParticles(this.selectedParticles);
        }
        if (this.newParticle == null) {
            this.newParticle = this.system;
        }
        this.system.getInspector().setSelectedPanel(this.newParticle.getName());
        this.updateDisplay();
        this.setVisible(true);
    }

    private DynamicParticle getParticle(String string) {
        ArrayList<DynamicParticle> arrayList = this.trackerPanel.getDrawables(DynamicParticle.class);
        for (DynamicParticle dynamicParticle : arrayList) {
            if (!dynamicParticle.getName().equals(string)) continue;
            return dynamicParticle;
        }
        return null;
    }

    protected void updateDisplay() {
        this.setTitle(TrackerRes.getString("DynamicSystemInspector.Title"));
        this.helpButton.setText(TrackerRes.getString("Dialog.Button.Help"));
        this.closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
        this.selectedParticles = new DynamicParticle[this.particleCount];
        this.systemButton.setText(this.system.getName());
        this.systemButton.setIcon(this.system.getFootprint().getIcon(21, 16));
        this.systemButton.setToolTipText(String.valueOf(TrackerRes.getString("TrackControl.Button.Properties.ToolTip")) + " " + this.system.getName());
        boolean bl = true;
        int n = 0;
        while (n < this.particleCount) {
            Border border = BorderFactory.createEtchedBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, String.valueOf(TrackerRes.getString("DynamicSystemInspector.Border.Title")) + " " + (n + 1));
            FontSizer.setFonts(titledBorder, FontSizer.getLevel());
            this.particlePanels[n].setBorder(titledBorder);
            this.changeButtons[n].setText(TrackerRes.getString("DynamicSystemInspector.Button.Change"));
            this.labelPanels[n].removeAll();
            if (this.system.particles.length > n && this.system.particles[n] != null) {
                bl = false;
                this.selectedParticles[n] = this.system.particles[n];
                this.particleButtons[n].setText(this.selectedParticles[n].getName());
                this.particleButtons[n].setIcon(this.selectedParticles[n].getFootprint().getIcon(21, 16));
                this.particleButtons[n].setToolTipText(String.valueOf(TrackerRes.getString("TrackControl.Button.Properties.ToolTip")) + " " + this.selectedParticles[n].getName());
                this.labelPanels[n].setLayout(new BoxLayout(this.labelPanels[n], 1));
                this.labelPanels[n].add(this.particleButtons[n]);
            } else {
                this.selectedParticles[n] = null;
                this.particleLabels[n].setText(TrackerRes.getString("DynamicSystemInspector.ParticleName.None"));
                this.labelPanels[n].setLayout(new BorderLayout());
                this.labelPanels[n].add(this.particleLabels[n]);
            }
            FontSizer.setFonts(this.labelPanels[n], FontSizer.getLevel());
            ++n;
        }
        this.changeButtons[this.particleCount - 1].setEnabled(!bl);
        this.changeButtons[0].requestFocusInWindow();
        this.pack();
        this.repaint();
    }
}

