/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.DynamicFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.DynamicParticle;
import org.opensourcephysics.cabrillo.tracker.DynamicParticlePolar;
import org.opensourcephysics.cabrillo.tracker.DynamicSystemInspector;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PointShapeFootprint;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.PositionVectorFootprint;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.VectorStep;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class DynamicSystem
extends DynamicParticlePolar {
    protected DynamicParticle[] particles = new DynamicParticle[0];
    protected ParticleModel[] models = new ParticleModel[0];
    protected double[] particleState = new double[5];
    protected DynamicSystemInspector systemInspector;
    protected JMenuItem systemInspectorItem;
    protected String[] particleNames = new String[0];
    protected TTrack.StepArray realSteps;
    protected TTrack.StepArray noSteps;
    protected int systemInspectorX = Integer.MIN_VALUE;
    protected int systemInspectorY;
    protected TreeMap<Integer, double[]> relativeStates = new TreeMap();
    protected boolean refreshing = false;

    public DynamicSystem() {
        this(new DynamicParticle[0]);
    }

    public DynamicSystem(DynamicParticle[] dynamicParticleArray) {
        this.defaultColors = new Color[]{new Color(51, 204, 51)};
        this.massField.setMinValue(0.0);
        this.realSteps = this.steps;
        this.noSteps = new TTrack.StepArray(this);
        Parameter parameter = (Parameter)this.getParamEditor().getObject("m");
        parameter.setExpressionEditable(false);
        this.setName(TrackerRes.getString("DynamicSystem.New.Name"));
        this.setFootprints(new Footprint[]{PointShapeFootprint.getFootprint("Footprint.SolidDiamond"), PointShapeFootprint.getFootprint("Footprint.Spot"), PointShapeFootprint.getFootprint("Footprint.SolidTriangle"), PointShapeFootprint.getFootprint("Footprint.SolidCircle"), PointShapeFootprint.getFootprint("Footprint.BoldVerticalLine"), PointShapeFootprint.getFootprint("Footprint.BoldHorizontalLine"), new PositionVectorFootprint(this, "Footprint.BoldPositionVector", 2)});
        this.defaultFootprint = this.getFootprint();
        this.setColor(this.defaultColors[0]);
        this.locked = true;
        this.setParticles(dynamicParticleArray);
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n;
        Cloneable cloneable;
        Object object;
        if (!(drawingPanel instanceof TrackerPanel) || this.trackerPanel == null) {
            return;
        }
        this.panels.add((TrackerPanel)drawingPanel);
        if (this.particleNames.length > 0) {
            object = new ArrayList();
            cloneable = this.trackerPanel.getDrawables(DynamicParticle.class);
            n = 0;
            while (n < this.particleNames.length) {
                for (DynamicParticle object2 : cloneable) {
                    if (!object2.getName().equals(this.particleNames[n])) continue;
                    ((ArrayList)object).add(object2);
                    this.particleNames[n] = null;
                }
                ++n;
            }
            this.setParticles(((ArrayList)object).toArray(new DynamicParticle[0]));
            n = 1;
            String[] stringArray = this.particleNames;
            int n2 = this.particleNames.length;
            int n3 = 0;
            while (n3 < n2) {
                String particleModelArray = stringArray[n3];
                n = particleModelArray == null && n != 0 ? 1 : 0;
                ++n3;
            }
            if (n != 0) {
                this.particleNames = new String[0];
            }
        }
        this.getInspector();
        if (this.systemInspectorX != Integer.MIN_VALUE && this.trackerPanel.getTFrame() != null) {
            this.getSystemInspector();
            object = this.trackerPanel.getTFrame();
            cloneable = Toolkit.getDefaultToolkit().getScreenSize();
            n = Math.max(((Component)object).getLocation().x + this.systemInspectorX, 0);
            n = Math.min(n, ((Dimension)cloneable).width - this.systemInspector.getWidth());
            int n5 = Math.max(((Component)object).getLocation().y + this.systemInspectorY, 0);
            n5 = Math.min(n5, ((Dimension)cloneable).height - this.systemInspector.getHeight());
            this.systemInspector.setLocation(n, n5);
            this.systemInspectorX = Integer.MIN_VALUE;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DynamicSystem.this.systemInspector.setVisible(true);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
        if (this.particles.length == 0) {
            return;
        }
        if (this.trackerPanel.getFrameNumber() > this.lastValidFrame) {
            this.refreshSteps();
        }
        ParticleModel[] particleModelArray = this.getModels();
        n = particleModelArray.length;
        int n5 = 0;
        while (n5 < n) {
            object = particleModelArray[n5];
            ((ParticleModel)object).drawMe(drawingPanel, graphics);
            ++n5;
        }
    }

    @Override
    public String getDisplayName() {
        StringBuffer stringBuffer = new StringBuffer(this.getName());
        stringBuffer.append(" (");
        if (this.particles == null || this.particles.length == 0) {
            stringBuffer.append(TrackerRes.getString("DynamicSystem.Empty"));
        } else {
            int n = 0;
            while (n < this.particles.length) {
                if (n > 0) {
                    stringBuffer.append(" + ");
                }
                stringBuffer.append(this.particles[n].getName());
                ++n;
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel) {
        this.systemInspectorItem = new JMenuItem(TrackerRes.getString("DynamicSystem.MenuItem.Inspector"));
        this.systemInspectorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicSystemInspector dynamicSystemInspector = DynamicSystem.this.getSystemInspector();
                dynamicSystemInspector.updateDisplay();
                dynamicSystemInspector.setVisible(true);
            }
        });
        JMenu jMenu = super.getMenu(trackerPanel);
        jMenu.add((Component)this.systemInspectorItem, 1);
        return jMenu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> arrayList = super.getToolbarTrackComponents(trackerPanel);
        this.massField.setEnabled(false);
        return arrayList;
    }

    @Override
    public double getMass() {
        this.mass = 0.0;
        if (this.particles == null) {
            return this.mass;
        }
        int n = 0;
        while (n < this.particles.length) {
            this.mass += this.particles[n].getMass();
            ++n;
        }
        return this.mass;
    }

    @Override
    public boolean isDependent() {
        return true;
    }

    public boolean addParticle(DynamicParticle dynamicParticle) {
        DynamicParticle[] dynamicParticleArray;
        if (this.particles.length == 2) {
            return false;
        }
        DynamicParticle[] dynamicParticleArray2 = this.particles;
        int n = this.particles.length;
        int n2 = 0;
        while (n2 < n) {
            dynamicParticleArray = dynamicParticleArray2[n2];
            if (dynamicParticleArray == dynamicParticle) {
                return false;
            }
            ++n2;
        }
        dynamicParticleArray = new DynamicParticle[this.particles.length + 1];
        System.arraycopy(this.particles, 0, dynamicParticleArray, 0, this.particles.length);
        dynamicParticleArray[this.particles.length] = dynamicParticle;
        return this.setParticles(dynamicParticleArray);
    }

    public boolean removeParticle(DynamicParticle dynamicParticle) {
        if (this.particles.length == 1 && this.particles[0] == dynamicParticle) {
            return this.setParticles(new DynamicParticle[0]);
        }
        if (this.particles.length == 2) {
            if (this.particles[0] == dynamicParticle) {
                return this.setParticles(new DynamicParticle[]{this.particles[1]});
            }
            if (this.particles[1] == dynamicParticle) {
                return this.setParticles(new DynamicParticle[]{this.particles[0]});
            }
        }
        return false;
    }

    public boolean setParticles(DynamicParticle[] dynamicParticleArray) {
        DynamicParticle dynamicParticle;
        if (dynamicParticleArray == null || dynamicParticleArray.length > 2) {
            return false;
        }
        DynamicParticle[] dynamicParticleArray2 = dynamicParticleArray;
        int n = dynamicParticleArray.length;
        int n2 = 0;
        while (n2 < n) {
            dynamicParticle = dynamicParticleArray2[n2];
            if (dynamicParticle == null) {
                return false;
            }
            ++n2;
        }
        if (dynamicParticleArray.length == 2) {
            dynamicParticle = null;
            if (dynamicParticleArray[0].isBoostedBy(dynamicParticleArray[1])) {
                dynamicParticle = dynamicParticleArray[0];
            } else if (dynamicParticleArray[1].isBoostedBy(dynamicParticleArray[0])) {
                dynamicParticle = dynamicParticleArray[1];
            }
            if (dynamicParticle != null) {
                String string = String.valueOf(TrackerRes.getString("DynamicSystem.Dialog.RemoveBooster.Message1")) + "\n" + TrackerRes.getString("DynamicSystem.Dialog.RemoveBooster.Message2") + " " + dynamicParticle.getName() + "\n" + TrackerRes.getString("DynamicSystem.Dialog.RemoveBooster.Message3");
                n = JOptionPane.showConfirmDialog(this.trackerPanel.getTFrame(), string, TrackerRes.getString("DynamicSystem.Dialog.RemoveBooster.Title"), 2, 2);
                if (n == 0) {
                    dynamicParticle.setBooster(null);
                } else {
                    return false;
                }
            }
        }
        dynamicParticleArray2 = this.particles;
        n = this.particles.length;
        int n3 = 0;
        while (n3 < n) {
            dynamicParticle = dynamicParticleArray2[n3];
            boolean bl = true;
            DynamicParticle[] dynamicParticleArray3 = dynamicParticleArray;
            int n4 = dynamicParticleArray.length;
            int n5 = 0;
            while (n5 < n4) {
                DynamicParticle dynamicParticle2 = dynamicParticleArray3[n5];
                if (dynamicParticle2 == dynamicParticle) {
                    bl = false;
                }
                ++n5;
            }
            if (bl) {
                dynamicParticle.system = null;
                dynamicParticle.inSystem = false;
                dynamicParticle.refreshInitialTime();
                dynamicParticle.removePropertyChangeListener(this);
                dynamicParticle.lastValidFrame = -1;
                dynamicParticle.repaint();
                if (this.systemInspector != null) {
                    dynamicParticle.removePropertyChangeListener("name", this.systemInspector);
                    dynamicParticle.removePropertyChangeListener("color", this.systemInspector);
                    dynamicParticle.removePropertyChangeListener("footprint", this.systemInspector);
                }
            }
            ++n3;
        }
        this.particles = new DynamicParticle[dynamicParticleArray.length];
        System.arraycopy(dynamicParticleArray, 0, this.particles, 0, dynamicParticleArray.length);
        this.state = new double[this.particles.length * 4 + 1];
        this.initialState = new double[this.particles.length * 4 + 1];
        this.models = new ParticleModel[0];
        if (this.systemInspector != null && this.systemInspector.isVisible()) {
            this.systemInspector.updateDisplay();
        }
        this.points = new Point2D[this.particles.length + 1];
        int n6 = 0;
        while (n6 < this.particles.length) {
            this.points[n6] = new Point2D.Double();
            ++n6;
        }
        this.points[this.points.length - 1] = this.point;
        n6 = 0;
        while (n6 < this.particles.length) {
            this.particles[n6].removePropertyChangeListener(this);
            this.particles[n6].addPropertyChangeListener(this);
            this.particles[n6].system = this;
            this.particles[n6].refreshInitialTime();
            if (this.systemInspector != null) {
                this.particles[n6].removePropertyChangeListener("name", this.systemInspector);
                this.particles[n6].removePropertyChangeListener("color", this.systemInspector);
                this.particles[n6].removePropertyChangeListener("footprint", this.systemInspector);
                this.particles[n6].addPropertyChangeListener("name", this.systemInspector);
                this.particles[n6].addPropertyChangeListener("color", this.systemInspector);
                this.particles[n6].addPropertyChangeListener("footprint", this.systemInspector);
            }
            ++n6;
        }
        this.refreshSystemParameters();
        if (this.inspector != null) {
            this.inspector.refreshDropdown(null);
        }
        if (this.particles.length == 0 && this.steps != this.noSteps) {
            this.steps = this.noSteps;
            this.support.firePropertyChange("steps", null, null);
        } else if (this.particles.length > 0 && this.steps != this.realSteps) {
            this.steps = this.realSteps;
            this.support.firePropertyChange("steps", null, null);
        }
        this.lastValidFrame = -1;
        this.repaint();
        return true;
    }

    @Override
    public void delete() {
        this.setParticles(new DynamicParticle[0]);
        super.delete();
    }

    @Override
    public void getRate(double[] dArray, double[] dArray2) {
        dArray2[dArray2.length - 1] = 1.0;
        if (this.particles.length == 0) {
            return;
        }
        if (this.particles.length == 1) {
            double[] dArray3 = this.getState(this.particles[0]);
            double[] dArray4 = this.particles[0].getXYForces(dArray3);
            double d = this.particles[0].getMass();
            dArray2[0] = dArray[1];
            dArray2[1] = dArray4[0] / d;
            dArray2[2] = dArray[3];
            dArray2[3] = dArray4[1] / d;
            return;
        }
        UserFunction[] userFunctionArray = this.getFunctionEditor().getMainFunctions();
        double[] dArray5 = this.getRelativePolarState(dArray);
        double d = Math.cos(dArray5[2]);
        double d2 = Math.sin(dArray5[2]);
        double d3 = userFunctionArray[0].evaluate(dArray5);
        double d4 = userFunctionArray[1].evaluate(dArray5);
        int n = 0;
        while (n < this.particles.length) {
            double[] dArray6 = this.getState(this.particles[n]);
            double[] dArray7 = this.particles[n].getXYForces(dArray6);
            double d5 = this.particles[n].getMass();
            int n2 = n == 0 ? 1 : -1;
            dArray2[4 * n] = dArray[4 * n + 1];
            dArray2[4 * n + 1] = (dArray7[0] + (double)n2 * d3 * d - (double)n2 * d4 * d2) / d5;
            dArray2[4 * n + 2] = dArray[4 * n + 3];
            dArray2[4 * n + 3] = (dArray7[1] + (double)n2 * d3 * d2 + (double)n2 * d4 * d) / d5;
            ++n;
        }
    }

    @Override
    public double[] getInitialValues() {
        double[] dArray = null;
        if (this.initialState.length != this.particles.length * 4 + 1) {
            this.initialState = new double[this.particles.length * 4 + 1];
        }
        int n = 0;
        while (n < this.particles.length) {
            dArray = this.particles[n].getInitialState();
            System.arraycopy(dArray, 0, this.initialState, 4 * n, 4);
            ++n;
        }
        if (dArray != null) {
            this.initialState[this.initialState.length - 1] = dArray[dArray.length - 1];
        } else if (this.trackerPanel != null) {
            double d = this.trackerPanel.getPlayer().getVideoClip().getStartTime();
            this.initialState[this.initialState.length - 1] = d / 1000.0;
        }
        return this.initialState;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("transform")) {
            PointMass pointMass;
            ImageCoordSystem imageCoordSystem = this.trackerPanel.getCoords();
            if (imageCoordSystem instanceof ReferenceFrame && ((pointMass = ((ReferenceFrame)imageCoordSystem).getOriginTrack()) == this || this.particles.length > 0 && pointMass == this.particles[0] || this.particles.length > 1 && pointMass == this.particles[1])) {
                return;
            }
            this.lastValidFrame = -1;
            this.refreshSteps();
        } else {
            super.propertyChange(propertyChangeEvent);
        }
        if (string.equals("mass") || string.equals("function")) {
            this.refreshSystemParameters();
            if (this.trackerPanel != null) {
                this.trackerPanel.repaint();
            }
        } else if (string.equals("name")) {
            this.refreshSystemParameters();
        }
    }

    @Override
    public void setFontLevel(int n) {
        super.setFontLevel(n);
        if (this.systemInspector != null) {
            FontSizer.setFonts(this.systemInspector, n);
            this.systemInspector.updateDisplay();
        }
    }

    public DynamicSystemInspector getSystemInspector() {
        if (this.systemInspector == null) {
            this.systemInspector = new DynamicSystemInspector(this);
            this.systemInspector.setLocation(200, 200);
            this.addPropertyChangeListener("name", this.systemInspector);
            this.addPropertyChangeListener("color", this.systemInspector);
            this.addPropertyChangeListener("footprint", this.systemInspector);
        }
        return this.systemInspector;
    }

    @Override
    public double[] getInitialState() {
        return this.getInitialValues();
    }

    @Override
    protected void refreshData(DatasetManager datasetManager, TrackerPanel trackerPanel) {
        int n = 25;
        if (datasetManager.getDataset(0).getColumnName(0).equals("x")) {
            String string = "t";
            datasetManager.getDataset(0).setXYColumnNames(string, "x");
            datasetManager.getDataset(1).setXYColumnNames(string, "y");
            datasetManager.getDataset(2).setXYColumnNames(string, "r");
            datasetManager.getDataset(3).setXYColumnNames(string, "$\\theta$_{r}");
            datasetManager.getDataset(4).setXYColumnNames(string, "v_{x}");
            datasetManager.getDataset(5).setXYColumnNames(string, "v_{y}");
            datasetManager.getDataset(6).setXYColumnNames(string, "v");
            datasetManager.getDataset(7).setXYColumnNames(string, "$\\theta$_{v}");
            datasetManager.getDataset(8).setXYColumnNames(string, "a_{x}");
            datasetManager.getDataset(9).setXYColumnNames(string, "a_{y}");
            datasetManager.getDataset(10).setXYColumnNames(string, "a");
            datasetManager.getDataset(11).setXYColumnNames(string, "$\\theta$_{a}");
            datasetManager.getDataset(12).setXYColumnNames(string, "$\\theta$");
            datasetManager.getDataset(13).setXYColumnNames(string, "$\\omega$");
            datasetManager.getDataset(14).setXYColumnNames(string, "$\\alpha$");
            datasetManager.getDataset(15).setXYColumnNames(string, "step");
            datasetManager.getDataset(16).setXYColumnNames(string, "frame");
            datasetManager.getDataset(17).setXYColumnNames(string, "p_{x}");
            datasetManager.getDataset(18).setXYColumnNames(string, "p_{y}");
            datasetManager.getDataset(19).setXYColumnNames(string, "p");
            datasetManager.getDataset(20).setXYColumnNames(string, "$\\theta$_{p}");
            datasetManager.getDataset(21).setXYColumnNames(string, "r_{rel}");
            datasetManager.getDataset(22).setXYColumnNames(string, "$\\theta$_{rel}");
            datasetManager.getDataset(23).setXYColumnNames(string, "vr_{rel}");
            datasetManager.getDataset(24).setXYColumnNames(string, "$\\omega$_{rel}");
        }
        this.dataDescriptions = new String[n + 1];
        int n2 = 0;
        while (n2 < n - 3) {
            this.dataDescriptions[n2] = TrackerRes.getString("PointMass.Data.Description." + n2);
            ++n2;
        }
        n2 = 0;
        while (n2 < 4) {
            this.dataDescriptions[n - 3 + n2] = TrackerRes.getString("DynamicSystem.Data.Description." + n2);
            ++n2;
        }
        Object[] objectArray = this.getRotationData();
        double[] dArray = (double[])objectArray[0];
        double[] dArray2 = (double[])objectArray[1];
        double[] dArray3 = (double[])objectArray[2];
        this.dataFrames.clear();
        int n3 = 0;
        while (n3 < n) {
            datasetManager.getDataset(n3).clear();
            ++n3;
        }
        VideoPlayer videoPlayer = trackerPanel.getPlayer();
        VideoClip videoClip = videoPlayer.getVideoClip();
        double d = videoPlayer.getMeanStepDuration() / 1000.0;
        ImageCoordSystem imageCoordSystem = trackerPanel.getCoords();
        Step[] stepArray = this.getSteps();
        int n4 = 0;
        while (n4 < stepArray.length) {
            if (stepArray[n4] != null && videoClip.includesFrame(n4)) {
                VectorStep vectorStep;
                Object object;
                int n5 = videoClip.frameToStep(n4);
                double d2 = videoPlayer.getStepTime(n5) / 1000.0;
                double[] dArray4 = new double[n];
                PositionStep.Position position = ((PositionStep)stepArray[n4]).getPosition();
                Point2D point2D = position.getWorldPosition(trackerPanel);
                dArray4[0] = point2D.getX();
                dArray4[1] = point2D.getY();
                dArray4[2] = point2D.distance(0.0, 0.0);
                dArray4[3] = Math.atan2(point2D.getY(), point2D.getX());
                dArray4[4] = Double.NaN;
                dArray4[5] = Double.NaN;
                dArray4[6] = Double.NaN;
                dArray4[7] = Double.NaN;
                dArray4[8] = Double.NaN;
                dArray4[9] = Double.NaN;
                dArray4[10] = Double.NaN;
                dArray4[11] = Double.NaN;
                dArray4[12] = dArray[n4];
                dArray4[13] = dArray2[n4] / d;
                dArray4[14] = dArray3[n4] / (d * d);
                dArray4[15] = n5;
                dArray4[16] = n4;
                dArray4[17] = Double.NaN;
                dArray4[18] = Double.NaN;
                dArray4[19] = Double.NaN;
                dArray4[20] = Double.NaN;
                dArray4[21] = Double.NaN;
                dArray4[22] = Double.NaN;
                dArray4[23] = Double.NaN;
                dArray4[24] = Double.NaN;
                if (this.particles.length == 2 && (object = (Object)this.relativeStates.get(n4)) != null) {
                    dArray4[21] = (double)object[0];
                    dArray4[22] = (double)object[2];
                    dArray4[23] = (double)object[1];
                    dArray4[24] = (double)object[3];
                }
                if ((object = this.getVelocity(n4, trackerPanel)) != null) {
                    double d3 = ((VectorStep)object).getXComponent();
                    double d4 = ((VectorStep)object).getYComponent();
                    dArray4[4] = imageCoordSystem.imageToWorldXComponent(n4, d3, d4) / d;
                    dArray4[5] = imageCoordSystem.imageToWorldYComponent(n4, d3, d4) / d;
                    double d5 = dArray4[4] * dArray4[4] + dArray4[5] * dArray4[5];
                    dArray4[6] = Math.sqrt(d5);
                    dArray4[7] = Math.atan2(dArray4[5], dArray4[4]);
                    double d6 = this.getMass();
                    dArray4[17] = d6 * dArray4[4];
                    dArray4[18] = d6 * dArray4[5];
                    dArray4[19] = d6 * dArray4[6];
                    dArray4[20] = d6 * dArray4[7];
                }
                if ((vectorStep = this.getAcceleration(n4, trackerPanel)) != null) {
                    double d7 = vectorStep.getXComponent();
                    double d8 = vectorStep.getYComponent();
                    dArray4[8] = imageCoordSystem.imageToWorldXComponent(n4, d7, d8) / (d * d);
                    dArray4[9] = imageCoordSystem.imageToWorldYComponent(n4, d7, d8) / (d * d);
                    dArray4[10] = Math.sqrt(dArray4[8] * dArray4[8] + dArray4[9] * dArray4[9]);
                    dArray4[11] = Math.atan2(dArray4[9], dArray4[8]);
                }
                int n6 = 0;
                while (n6 < n) {
                    datasetManager.getDataset(n6).append(d2, dArray4[n6]);
                    ++n6;
                }
                this.dataFrames.add(new Integer(n4));
            }
            ++n4;
        }
        Double d9 = this.getMass();
        String string = TrackerRes.getString("ParticleModel.Parameter.Mass.Description");
        datasetManager.setConstant("m", d9, d9.toString(), string);
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        if (this.systemInspector != null) {
            this.systemInspector.dispose();
        }
    }

    @Override
    protected void refreshInitialTime() {
        super.refreshInitialTime();
        DynamicParticle[] dynamicParticleArray = this.particles;
        int n = this.particles.length;
        int n2 = 0;
        while (n2 < n) {
            DynamicParticle dynamicParticle = dynamicParticleArray[n2];
            dynamicParticle.refreshInitialTime();
            ++n2;
        }
    }

    protected void refreshSystemParameters() {
        Object object;
        if (this.refreshing) {
            return;
        }
        this.refreshing = true;
        double[] dArray = this.particles.length == 2 ? this.getRelativePolarState(this.getInitialState()) : new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double d = 1.0E-12;
        if (this.trackerPanel != null) {
            d = 0.001 / this.trackerPanel.getCoords().getScaleX(0);
        }
        double d2 = 1.0E-11;
        if (this.trackerPanel != null) {
            d2 = 1000.0 * d / this.trackerPanel.getPlayer().getMeanStepDuration();
        }
        double d3 = 1.0E-5;
        double d4 = 1.0E-4;
        if (this.trackerPanel != null) {
            d4 = 1000.0 * d3 / this.trackerPanel.getPlayer().getMeanStepDuration();
        }
        String string = "_" + TrackerRes.getString("DynamicSystem.Parameter.Name.Relative");
        String string2 = " ";
        if (this.particles.length > 0) {
            string2 = String.valueOf(string2) + TrackerRes.getString("DynamicSystem.Parameter.Of") + " ";
            string2 = String.valueOf(string2) + this.particles[0].getName() + " ";
            string2 = String.valueOf(string2) + TrackerRes.getString("DynamicSystem.Parameter.RelativeTo") + " ";
            string2 = String.valueOf(string2) + (this.particles.length > 1 ? this.particles[1].getName() : this.particles[0].getName());
        }
        String string3 = TrackerRes.getString("DynamicSystem.Parameter.Mass.Description");
        this.getParamEditor().setExpression("m", String.valueOf(this.getMass()), false);
        this.getParamEditor().setDescription("m", string3);
        Parameter parameter = (Parameter)this.getParamEditor().getObject("m1");
        Parameter parameter2 = (Parameter)this.getParamEditor().getObject("m2");
        string3 = TrackerRes.getString("DynamicSystem.Parameter.ParticleMass.Description");
        if (this.particles.length == 0) {
            if (parameter != null) {
                parameter.setNameEditable(true);
                parameter.setExpressionEditable(true);
                this.getParamEditor().removeObject(parameter, false);
            }
            if (parameter2 != null) {
                parameter2.setNameEditable(true);
                parameter2.setExpressionEditable(true);
                this.getParamEditor().removeObject(parameter2, false);
            }
        } else {
            object = FunctionEditor.format(this.particles[0].getMass(), 0.0);
            if (parameter == null) {
                parameter = this.createParameter("m1", (String)object, String.valueOf(string3) + " " + this.particles[0].getName());
                this.getParamEditor().addObject(parameter, 1, false, false);
            } else {
                this.getParamEditor().setExpression("m1", (String)object, false);
            }
            if (this.particles.length > 1) {
                object = FunctionEditor.format(this.particles[1].getMass(), 0.0);
                if (parameter2 == null) {
                    parameter2 = this.createParameter("m2", (String)object, String.valueOf(string3) + " " + this.particles[1].getName());
                    this.getParamEditor().addObject(parameter2, 2, false, false);
                } else {
                    this.getParamEditor().setExpression("m2", (String)object, false);
                }
            } else if (parameter2 != null) {
                parameter2.setNameEditable(true);
                parameter2.setExpressionEditable(true);
                this.getParamEditor().removeObject(parameter2, false);
            }
        }
        Object object2 = this.particles;
        int n = this.particles.length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            if (((DynamicParticle)object).modelBooster != null) {
                ((DynamicParticle)object).modelBooster.setBooster(((DynamicParticle)object).modelBooster.booster);
            }
            ++n2;
        }
        object = (Parameter)this.getInitEditor().getObject("t");
        String string4 = FunctionEditor.format(dArray[0], d);
        string3 = TrackerRes.getString("DynamicParticle.Parameter.InitialR.Description");
        Parameter parameter3 = this.createParameter("r" + string, string4, String.valueOf(string3) + string2);
        string4 = FunctionEditor.format(dArray[2], d3);
        string3 = TrackerRes.getString("DynamicParticle.Parameter.InitialTheta.Description");
        object2 = this.createParameter(String.valueOf(FunctionEditor.THETA) + string, string4, String.valueOf(string3) + string2);
        string4 = FunctionEditor.format(dArray[1], d2);
        string3 = TrackerRes.getString("DynamicParticle.Parameter.InitialVelocityR.Description");
        Parameter parameter4 = this.createParameter("vr" + string, string4, String.valueOf(string3) + string2);
        string4 = FunctionEditor.format(dArray[3], d4);
        string3 = TrackerRes.getString("DynamicParticle.Parameter.InitialOmega.Description");
        Parameter parameter5 = this.createParameter(String.valueOf(FunctionEditor.OMEGA) + string, string4, String.valueOf(string3) + string2);
        this.getInitEditor().setParameters(new Parameter[]{object, parameter3, object2, parameter4, parameter5});
        this.refreshing = false;
    }

    @Override
    protected void setTracePositions(double[] dArray) {
        if (this.particles.length == 0) {
            return;
        }
        int n = 0;
        while (n < this.points.length - 1) {
            this.points[n].setLocation(dArray[4 * n], dArray[4 * n + 2]);
            ++n;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < this.particles.length) {
            double d4 = this.particles[n2].getMass();
            d += d4;
            d2 += d4 * dArray[4 * n2];
            d3 += d4 * dArray[4 * n2 + 2];
            ++n2;
        }
        this.points[this.points.length - 1].setLocation(d2 / d, d3 / d);
    }

    @Override
    protected void initializeFunctionPanel() {
        this.functionEditor = new UserFunctionEditor();
        this.functionPanel = new DynamicFunctionPanel(this.functionEditor, this);
        UserFunction[] userFunctionArray = new UserFunction[2];
        String[] stringArray = new String[]{"r", "vr", FunctionEditor.THETA, FunctionEditor.OMEGA, "t"};
        String string = TrackerRes.getString("DynamicSystem.Force.Name.Internal");
        userFunctionArray[0] = new UserFunction("fr_" + string);
        userFunctionArray[0].setNameEditable(false);
        userFunctionArray[0].setExpression("0", stringArray);
        userFunctionArray[0].setDescription(TrackerRes.getString("DynamicSystem.ForceFunction.R.Description"));
        String string2 = "f" + FunctionEditor.THETA + "_" + string;
        userFunctionArray[1] = new UserFunction(string2);
        userFunctionArray[1].setNameEditable(false);
        userFunctionArray[1].setExpression("0", stringArray);
        userFunctionArray[1].setDescription(TrackerRes.getString("DynamicSystem.ForceFunction.Theta.Description"));
        this.functionEditor.setMainFunctions(userFunctionArray);
        this.createMassAndTimeParameters();
    }

    protected double[] getSystemState(double[] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < this.particleState.length) {
            this.particleState[n] = 0.0;
            ++n;
        }
        this.particleState[4] = dArray[dArray.length - 1];
        if (this.particles.length > 0) {
            n = 0;
            while (n < this.particles.length) {
                double d2 = this.particles[n].getMass();
                d += d2;
                this.particleState[0] = this.particleState[0] + d2 * dArray[4 * n];
                this.particleState[1] = this.particleState[1] + d2 * dArray[4 * n + 1];
                this.particleState[2] = this.particleState[2] + d2 * dArray[4 * n + 2];
                this.particleState[3] = this.particleState[3] + d2 * dArray[4 * n + 3];
                ++n;
            }
            this.particleState[0] = this.particleState[0] / d;
            this.particleState[1] = this.particleState[1] / d;
            this.particleState[2] = this.particleState[2] / d;
            this.particleState[3] = this.particleState[3] / d;
        }
        return this.particleState;
    }

    protected double[] getState(DynamicParticle dynamicParticle) {
        int n = 0;
        while (n < this.particles.length) {
            if (this.particles[n] == dynamicParticle) {
                this.particleState[0] = this.state[4 * n];
                this.particleState[1] = this.state[4 * n + 1];
                this.particleState[2] = this.state[4 * n + 2];
                this.particleState[3] = this.state[4 * n + 3];
                this.particleState[4] = this.state[this.state.length - 1];
                return this.particleState;
            }
            ++n;
        }
        return null;
    }

    @Override
    protected ParticleModel[] getModels() {
        if (this.models.length != this.particles.length + 1) {
            this.models = new ParticleModel[this.particles.length + 1];
            int n = 0;
            while (n < this.models.length - 1) {
                this.models[n] = this.particles[n];
                ++n;
            }
            this.models[this.models.length - 1] = this;
        }
        return this.models;
    }

    protected double[] getRelativePolarState(double[] dArray) {
        double[] dArray2 = new double[5];
        double d = dArray[0] - dArray[4];
        double d2 = dArray[2] - dArray[6];
        double d3 = dArray[1] - dArray[5];
        double d4 = dArray[3] - dArray[7];
        double d5 = Math.sqrt(d * d + d2 * d2);
        double d6 = Math.sqrt(d3 * d3 + d4 * d4);
        double d7 = Math.atan2(d2, d);
        double d8 = Math.atan2(d4, d3);
        double d9 = d8 - d7;
        dArray2[0] = d5;
        dArray2[1] = d5 == 0.0 ? d6 : d6 * Math.cos(d9);
        dArray2[2] = d5 == 0.0 ? d8 : d7;
        dArray2[3] = d5 == 0.0 ? 0.0 : d6 * Math.sin(d9) / d5;
        dArray2[4] = dArray[8];
        double[] dArray3 = new double[dArray2.length];
        System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
        int n = this.trackerPanel.getFrameNumber();
        this.relativeStates.put(n, dArray3);
        return dArray2;
    }

    private Parameter createParameter(String string, String string2, String string3) {
        Parameter parameter = new Parameter(string, string2);
        parameter.setExpressionEditable(false);
        parameter.setNameEditable(false);
        parameter.setDescription(string3);
        return parameter;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            Object object2;
            DynamicSystem dynamicSystem = (DynamicSystem)object;
            if (dynamicSystem.particles.length > 0) {
                object2 = new String[dynamicSystem.particles.length];
                int n = 0;
                while (n < ((String[])object2).length) {
                    object2[n] = dynamicSystem.particles[n].getName();
                    ++n;
                }
                xMLControl.setValue("particles", object2);
            }
            if (dynamicSystem.systemInspector != null && dynamicSystem.systemInspector.isVisible()) {
                object2 = dynamicSystem.systemInspector.getLocation();
                TFrame tFrame = dynamicSystem.trackerPanel.getTFrame();
                xMLControl.setValue("system_inspector_x", object2.x - tFrame.getLocation().x);
                xMLControl.setValue("system_inspector_y", object2.y - tFrame.getLocation().y);
            }
            XML.getLoader(ParticleModel.class).saveObject(xMLControl, object);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new DynamicSystem();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            XML.getLoader(ParticleModel.class).loadObject(xMLControl, object);
            DynamicSystem dynamicSystem = (DynamicSystem)object;
            String[] stringArray = (String[])xMLControl.getObject("particles");
            if (stringArray != null) {
                dynamicSystem.particleNames = stringArray;
            }
            dynamicSystem.systemInspectorX = xMLControl.getInt("system_inspector_x");
            dynamicSystem.systemInspectorY = xMLControl.getInt("system_inspector_y");
            return object;
        }
    }
}

