/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import javax.swing.JOptionPane;
import org.opensourcephysics.cabrillo.tracker.Calibration;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class CalibrationStep
extends Step {
    private Calibration cal;
    protected double worldX0;
    protected double worldY0;
    protected double worldX1 = 1.0;
    protected double worldY1;

    public CalibrationStep(Calibration calibration, int n, double d, double d2) {
        super(calibration, n);
        this.cal = calibration;
        this.screenPoints = new Point[CalibrationStep.getLength()];
        this.points = new TPoint[CalibrationStep.getLength()];
        Position position = new Position(d, d2);
        this.points[0] = position;
    }

    public void addSecondPoint(double d, double d2) {
        Position position = new Position(d, d2);
        this.points[1] = position;
        this.setWorldCoordinates(this.worldX0, this.worldY0, this.worldX1, this.worldY1);
    }

    public Position getPosition(int n) {
        return (Position)this.points[n];
    }

    @Override
    public TPoint getDefaultPoint() {
        if (this.points[1] == null) {
            return this.points[0];
        }
        if (this.cal.trackerPanel.getSelectedPoint() == this.points[0]) {
            return this.points[0];
        }
        return this.points[1];
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.marks.get(trackerPanel);
        TPoint tPoint = null;
        if (mark == null) {
            ImageCoordSystem imageCoordSystem = trackerPanel.getCoords();
            int n = trackerPanel.getFrameNumber();
            int n2 = 0;
            while (n2 < this.points.length) {
                Position position = (Position)this.points[n2];
                if (position != null) {
                    double d = n2 == 0 ? this.worldX0 : this.worldX1;
                    double d2 = n2 == 0 ? this.worldY0 : this.worldY1;
                    double d3 = imageCoordSystem.worldToImageX(n, d, d2);
                    double d4 = imageCoordSystem.worldToImageY(n, d, d2);
                    position.setLocation(d3, d4);
                }
                ++n2;
            }
            tPoint = trackerPanel.getSelectedPoint();
            final Shape[] shapeArray = new Shape[this.points.length];
            int n3 = 0;
            while (n3 < this.points.length) {
                if (this.points[n3] != null) {
                    Point point = this.points[n3].getScreenPosition(trackerPanel);
                    if (tPoint == this.points[n3]) {
                        transform.setToTranslation(point.x, point.y);
                        int n4 = FontSizer.getIntegerFactor();
                        if (n4 > 1) {
                            transform.scale(n4, n4);
                        }
                        shapeArray[n3] = transform.createTransformedShape(selectionShape);
                    } else {
                        shapeArray[n3] = this.footprint.getShape(new Point[]{point});
                    }
                }
                ++n3;
            }
            final Color color = this.footprint.getColor();
            mark = new Mark(){

                @Override
                public void draw(Graphics2D graphics2D, boolean bl) {
                    Paint paint = graphics2D.getPaint();
                    graphics2D.setPaint(color);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    int n = 0;
                    while (n < CalibrationStep.this.points.length) {
                        if (shapeArray[n] != null) {
                            graphics2D.fill(shapeArray[n]);
                        }
                        ++n;
                    }
                    graphics2D.setPaint(paint);
                }

                @Override
                public Rectangle getBounds(boolean bl) {
                    Rectangle rectangle = null;
                    int n = 0;
                    while (n < CalibrationStep.this.points.length) {
                        if (shapeArray[n] != null) {
                            if (rectangle == null) {
                                rectangle = shapeArray[n].getBounds();
                            } else {
                                rectangle.add(shapeArray[n].getBounds());
                            }
                        }
                        ++n;
                    }
                    return rectangle;
                }
            };
            this.marks.put(trackerPanel, mark);
        }
        return mark;
    }

    @Override
    public Object clone() {
        CalibrationStep calibrationStep = (CalibrationStep)super.clone();
        TPoint[] tPointArray = calibrationStep.points;
        CalibrationStep calibrationStep2 = calibrationStep;
        calibrationStep2.getClass();
        tPointArray[0] = calibrationStep2.new Position(this.points[0].x, this.points[0].y);
        if (this.points[1] != null) {
            TPoint[] tPointArray2 = calibrationStep.points;
            CalibrationStep calibrationStep3 = calibrationStep;
            calibrationStep3.getClass();
            tPointArray2[1] = calibrationStep3.new Position(this.points[1].x, this.points[1].y);
        }
        return calibrationStep;
    }

    public boolean setWorldCoordinates(double d, double d2, double d3, double d4) {
        Object object;
        boolean bl;
        if (this.track.isLocked()) {
            return false;
        }
        boolean bl2 = d3 == d;
        boolean bl3 = bl = d4 == d2;
        if (bl2 && this.cal.axes == 2 || bl && this.cal.axes == 0 || bl2 && bl && this.cal.axes == 1) {
            JOptionPane.showMessageDialog(this.track.trackerPanel, TrackerRes.getString("Calibration.Dialog.InvalidCoordinates.Message"), TrackerRes.getString("Calibration.Dialog.InvalidCoordinates.Title"), 2);
            return false;
        }
        if (this.cal.isFixedCoordinates()) {
            object = (CalibrationStep)this.cal.steps.getStep(0);
            ((CalibrationStep)object).worldX0 = d;
            ((CalibrationStep)object).worldY0 = d2;
            ((CalibrationStep)object).worldX1 = d3;
            ((CalibrationStep)object).worldY1 = d4;
            ((Step)object).erase();
            this.cal.refreshStep(this);
        } else {
            this.worldX0 = d;
            this.worldY0 = d2;
            this.worldX1 = d3;
            this.worldY1 = d4;
            this.cal.keyFrames.add(this.n);
        }
        if (this.points[1] != null) {
            this.updateCoords();
        } else if (this.cal.trackerPanel != null) {
            object = this.cal.trackerPanel.getCoords();
            int n = this.cal.trackerPanel.getFrameNumber();
            double d5 = ((ImageCoordSystem)object).getOriginX(n);
            double d6 = ((ImageCoordSystem)object).getOriginY(n);
            double d7 = ((ImageCoordSystem)object).worldToImageX(n, this.worldX0, this.worldY0);
            double d8 = ((ImageCoordSystem)object).worldToImageY(n, this.worldX0, this.worldY0);
            ((ImageCoordSystem)object).setOriginXY(n, d5 + this.points[0].x - d7, d6 + this.points[0].y - d8);
        }
        return true;
    }

    @Override
    public String toString() {
        String string = "Calibration Points Step " + this.n + " [" + format.format(this.worldX0) + ", " + format.format(this.worldY0);
        string = this.points[1] != null ? String.valueOf(string) + ", " + format.format(this.worldX1) + ", " + format.format(this.worldY1) + "]" : String.valueOf(string) + "]";
        return string;
    }

    private void updateCoords() {
        if (this.points[1] == null || this.cal.trackerPanel == null) {
            return;
        }
        if (this.cal.axes == 2) {
            this.updateCoordsXOnly();
            return;
        }
        if (this.cal.axes == 0) {
            this.updateCoordsYOnly();
            return;
        }
        ImageCoordSystem imageCoordSystem = this.cal.trackerPanel.getCoords();
        int n = this.cal.trackerPanel.getFrameNumber();
        double d = this.worldX0;
        double d2 = this.worldY0;
        double d3 = this.worldX1;
        double d4 = this.worldY1;
        double d5 = this.points[0].getX();
        double d6 = this.points[0].getY();
        double d7 = this.points[0].distance(this.points[1]);
        double d8 = this.points[0].angle(this.points[1]);
        double d9 = d3 - d;
        double d10 = d4 - d2;
        double d11 = Math.sqrt(d9 * d9 + d10 * d10);
        double d12 = -Math.atan2(d10, d9);
        double d13 = d7 / d11;
        imageCoordSystem.setScaleXY(n, d13, d13);
        double d14 = d12 - d8;
        imageCoordSystem.setAngle(n, d14);
        double d15 = imageCoordSystem.getOriginX(n);
        double d16 = imageCoordSystem.getOriginY(n);
        double d17 = imageCoordSystem.worldToImageX(n, d, d2) - d5;
        double d18 = imageCoordSystem.worldToImageY(n, d, d2) - d6;
        imageCoordSystem.setOriginXY(n, d15 - d17, d16 - d18);
    }

    private void updateCoordsXOnly() {
        double d;
        double d2;
        double d3;
        double d4;
        ImageCoordSystem imageCoordSystem = this.cal.trackerPanel.getCoords();
        int n = this.cal.trackerPanel.getFrameNumber();
        double d5 = this.worldX0;
        double d6 = this.worldY0;
        double d7 = this.worldX1;
        double d8 = this.points[0].getX();
        double d9 = this.points[0].getY();
        double d10 = this.points[1].getX();
        double d11 = this.points[1].getY();
        double d12 = this.points[0].distance(this.points[1]);
        double d13 = d12 * Math.cos(d4 = (d3 = -this.points[0].angle(this.points[1])) - (d2 = imageCoordSystem.getAngle(n)));
        double d14 = d13 / (d = d7 - d5);
        if (d14 > 0.0) {
            imageCoordSystem.setScaleXY(n, d14, d14);
        } else {
            imageCoordSystem.setScaleXY(n, -d14, -d14);
            imageCoordSystem.setAngle(n, d2 + Math.PI);
        }
        double d15 = imageCoordSystem.getOriginX(n);
        double d16 = imageCoordSystem.getOriginY(n);
        double d17 = imageCoordSystem.worldToImageX(n, d5, d6) - d8;
        double d18 = imageCoordSystem.worldToImageY(n, d5, d6) - d9;
        double d19 = d2 + Math.atan2(d18, d17);
        double d20 = Math.sqrt(d17 * d17 + d18 * d18) * Math.cos(d19);
        double d21 = d20 * Math.cos(d2);
        double d22 = -d20 * Math.sin(d2);
        imageCoordSystem.setOriginXY(n, d15 - d21, d16 - d22);
        this.worldY0 = imageCoordSystem.imageToWorldY(n, d8, d9);
        this.worldY1 = imageCoordSystem.imageToWorldY(n, d10, d11);
    }

    private void updateCoordsYOnly() {
        double d;
        double d2;
        double d3;
        double d4;
        ImageCoordSystem imageCoordSystem = this.cal.trackerPanel.getCoords();
        int n = this.cal.trackerPanel.getFrameNumber();
        double d5 = this.worldX0;
        double d6 = this.worldY0;
        double d7 = this.worldY1;
        double d8 = this.points[0].getX();
        double d9 = this.points[0].getY();
        double d10 = this.points[1].getX();
        double d11 = this.points[1].getY();
        double d12 = this.points[0].distance(this.points[1]);
        double d13 = d12 * Math.sin(d4 = (d3 = -this.points[0].angle(this.points[1])) - (d2 = imageCoordSystem.getAngle(n)));
        double d14 = d13 / (d = d7 - d6);
        if (d14 > 0.0) {
            imageCoordSystem.setScaleXY(n, d14, d14);
        } else {
            imageCoordSystem.setScaleXY(n, -d14, -d14);
            imageCoordSystem.setAngle(n, d2 + Math.PI);
        }
        double d15 = imageCoordSystem.getOriginX(n);
        double d16 = imageCoordSystem.getOriginY(n);
        double d17 = imageCoordSystem.worldToImageX(n, d5, d6) - d8;
        double d18 = imageCoordSystem.worldToImageY(n, d5, d6) - d9;
        double d19 = d2 + Math.atan2(d18, d17);
        double d20 = Math.sqrt(d17 * d17 + d18 * d18) * Math.sin(d19);
        double d21 = d20 * Math.sin(d2);
        double d22 = d20 * Math.cos(d2);
        imageCoordSystem.setOriginXY(n, d15 - d21, d16 - d22);
        this.worldX0 = imageCoordSystem.imageToWorldX(n, d8, d9);
        this.worldX1 = imageCoordSystem.imageToWorldX(n, d10, d11);
    }

    public static int getLength() {
        return 2;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            CalibrationStep calibrationStep = (CalibrationStep)object;
            double[] dArray = new double[]{calibrationStep.worldX0, calibrationStep.worldY0, calibrationStep.worldX1, calibrationStep.worldY1};
            xMLControl.setValue("world_coordinates", dArray);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            CalibrationStep calibrationStep = (CalibrationStep)object;
            double[] dArray = (double[])xMLControl.getObject("world_coordinates");
            if (dArray != null) {
                calibrationStep.worldX0 = dArray[0];
                calibrationStep.worldY0 = dArray[1];
                calibrationStep.worldX1 = dArray[2];
                calibrationStep.worldY1 = dArray[3];
            }
            if (calibrationStep.cal != null) {
                calibrationStep.cal.displayWorldCoordinates();
            }
            return object;
        }
    }

    public class Position
    extends TPoint {
        private double lastX;
        private double lastY;

        public Position(double d, double d2) {
            super.setXY(d, d2);
            this.setCoordsEditTrigger(true);
            if (((CalibrationStep)CalibrationStep.this).cal.trackerPanel != null) {
                ImageCoordSystem imageCoordSystem = ((CalibrationStep)CalibrationStep.this).cal.trackerPanel.getCoords();
                int n = ((CalibrationStep)CalibrationStep.this).cal.trackerPanel.getFrameNumber();
                if (CalibrationStep.this.points[0] == null) {
                    CalibrationStep.this.worldX0 = imageCoordSystem.imageToWorldX(n, d, d2);
                    CalibrationStep.this.worldY0 = imageCoordSystem.imageToWorldY(n, d, d2);
                } else {
                    CalibrationStep.this.worldX1 = imageCoordSystem.imageToWorldX(n, d, d2);
                    CalibrationStep.this.worldY1 = imageCoordSystem.imageToWorldY(n, d, d2);
                }
            }
        }

        @Override
        public void setXY(double d, double d2) {
            int n;
            if (CalibrationStep.this.track.isLocked()) {
                return;
            }
            int n2 = n = this == CalibrationStep.this.points[0] ? 1 : 0;
            if (CalibrationStep.this.points[n] != null && CalibrationStep.this.points[n].getX() == d && CalibrationStep.this.points[n].getY() == d2) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (this.isAdjusting()) {
                this.lastX = d;
                this.lastY = d2;
            }
            double d3 = d - this.getX();
            double d4 = d2 - this.getY();
            super.setXY(d, d2);
            ImageCoordSystem imageCoordSystem = ((CalibrationStep)CalibrationStep.this).cal.trackerPanel.getCoords();
            imageCoordSystem.setAdjusting(this.isAdjusting());
            if (CalibrationStep.this.points[1] != null) {
                CalibrationStep.this.updateCoords();
            } else if (((CalibrationStep)CalibrationStep.this).cal.trackerPanel != null) {
                int n3 = ((CalibrationStep)CalibrationStep.this).cal.trackerPanel.getFrameNumber();
                double d5 = imageCoordSystem.getOriginX(n3);
                double d6 = imageCoordSystem.getOriginY(n3);
                imageCoordSystem.setOriginXY(n3, d5 + d3, d6 + d4);
            }
            if (this.isAdjusting()) {
                CalibrationStep.this.repaint();
            }
        }

        @Override
        public void showCoordinates(VideoPanel videoPanel) {
            if (this == CalibrationStep.this.points[0]) {
                ((CalibrationStep)CalibrationStep.this).cal.xField.setValue(CalibrationStep.this.worldX0);
                ((CalibrationStep)CalibrationStep.this).cal.yField.setValue(CalibrationStep.this.worldY0);
            } else {
                ((CalibrationStep)CalibrationStep.this).cal.x1Field.setValue(CalibrationStep.this.worldX1);
                ((CalibrationStep)CalibrationStep.this).cal.y1Field.setValue(CalibrationStep.this.worldY1);
            }
            super.showCoordinates(videoPanel);
        }

        @Override
        public void setAdjusting(boolean bl) {
            boolean bl2 = this.isAdjusting();
            super.setAdjusting(bl);
            if (bl2 && !bl) {
                this.setXY(this.lastX, this.lastY);
                CalibrationStep.this.track.firePropertyChange("step", null, CalibrationStep.this.n);
            }
        }
    }
}

