/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.test_utils.NameAwareTestClassRunner;
import com.xuggle.xuggler.Converter;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.ITimeValue;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.Utils;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.Random;
import junit.framework.Assert;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=NameAwareTestClassRunner.class)
public class UtilsTest {
    private String mTestName;

    @Before
    public void setUp() {
        this.mTestName = NameAwareTestClassRunner.getTestMethodName();
    }

    @Test
    public void testGetBlankFrame() {
        byte val;
        int i;
        IVideoPicture frame = null;
        int w = 100;
        int h = 200;
        byte y = 62;
        byte u = 15;
        byte v = 33;
        long pts = 102832L;
        frame = Utils.getBlankFrame((int)w, (int)h, (int)y, (int)u, (int)v, (long)pts);
        Assert.assertTrue((String)"got a frame", (frame != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"is complete", (boolean)frame.isComplete());
        Assert.assertTrue((String)"correct pts", (frame.getPts() == pts ? 1 : 0) != 0);
        IBuffer data = frame.getData();
        ByteBuffer buffer = data.getByteBuffer(0, data.getBufferSize());
        Assert.assertNotNull((Object)buffer);
        int lineLength = 0;
        int offset = 0;
        offset = 0;
        lineLength = frame.getDataLineSize(0);
        Assert.assertTrue((String)"incorrect format", (lineLength == w ? 1 : 0) != 0);
        for (i = offset; i < offset + lineLength * h; ++i) {
            val = buffer.get(i);
            Assert.assertTrue((String)("color not set correctly: " + i), (val == y ? 1 : 0) != 0);
        }
        offset = frame.getDataLineSize(0) * h;
        lineLength = frame.getDataLineSize(1);
        Assert.assertTrue((String)"incorrect format", (lineLength == w / 2 ? 1 : 0) != 0);
        for (i = offset; i < offset + lineLength * h / 2; ++i) {
            val = buffer.get(i);
            Assert.assertTrue((String)("color not set correctly: " + i), (val == u ? 1 : 0) != 0);
        }
        offset = frame.getDataLineSize(0) * h + frame.getDataLineSize(1) * h / 2;
        lineLength = frame.getDataLineSize(2);
        Assert.assertTrue((String)"incorrect format", (lineLength == w / 2 ? 1 : 0) != 0);
        for (i = offset; i < offset + lineLength * h / 2; ++i) {
            val = buffer.get(i);
            Assert.assertTrue((String)("color not set correctly: " + i), (val == v ? 1 : 0) != 0);
        }
        for (i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                Assert.assertEquals((short)y, (short)IPixelFormat.getYUV420PPixel((IVideoPicture)frame, (int)i, (int)j, (IPixelFormat.YUVColorComponent)IPixelFormat.YUVColorComponent.YUV_Y));
                Assert.assertEquals((short)u, (short)IPixelFormat.getYUV420PPixel((IVideoPicture)frame, (int)i, (int)j, (IPixelFormat.YUVColorComponent)IPixelFormat.YUVColorComponent.YUV_U));
                Assert.assertEquals((short)v, (short)IPixelFormat.getYUV420PPixel((IVideoPicture)frame, (int)i, (int)j, (IPixelFormat.YUVColorComponent)IPixelFormat.YUVColorComponent.YUV_V));
            }
        }
    }

    @Test
    public void testSamplesToTimeValue() {
        ITimeValue result = Utils.samplesToTimeValue((long)22050L, (int)22050);
        Assert.assertEquals((long)1000L, (long)result.get(ITimeValue.Unit.MILLISECONDS));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSamplesToTimeValueNoSampleRate() {
        Utils.samplesToTimeValue((long)1024L, (int)0);
    }

    @Test
    public void testTimeValueToSamples() {
        ITimeValue input = ITimeValue.make((long)16L, (ITimeValue.Unit)ITimeValue.Unit.SECONDS);
        long result = Utils.timeValueToSamples((ITimeValue)input, (int)44100);
        Assert.assertEquals((long)705600L, (long)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTimeValueToSamplesNoSampleRate() {
        Utils.timeValueToSamples((ITimeValue)ITimeValue.make((long)1L, (ITimeValue.Unit)ITimeValue.Unit.SECONDS), (int)0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTimeValueToSamplesNoTimeValue() {
        Utils.timeValueToSamples(null, (int)22050);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVideoPictureToImageNullInput() {
        Utils.videoPictureToImage(null);
    }

    @Test
    public void testVideoPictureToImageWrongFormatInput() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            return;
        }
        IVideoPicture picture = Utils.getBlankFrame((int)50, (int)50, (int)0);
        Assert.assertEquals((Object)IPixelFormat.Type.YUV420P, (Object)picture.getPixelType());
        Utils.videoPictureToImage((IVideoPicture)picture);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testLGPLBuild() {
        if (IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            throw new UnsupportedOperationException();
        }
        IVideoPicture picture = Utils.getBlankFrame((int)50, (int)50, (int)0);
        Assert.assertEquals((Object)IPixelFormat.Type.YUV420P, (Object)picture.getPixelType());
        Utils.videoPictureToImage((IVideoPicture)picture);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImageToVideoPictureNullInput() {
        Utils.imageToVideoPicture(null, (long)0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImageToVideoPictureWrongFormatInput() {
        BufferedImage image = new BufferedImage(50, 50, 1);
        Utils.imageToVideoPicture((BufferedImage)image, (long)0L);
    }

    @Test
    public void testImageToImageSolidColor() {
        int w = 50;
        int h = 50;
        int gray = Color.GRAY.getRGB();
        BufferedImage image1 = new BufferedImage(w, h, 5);
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                image1.setRGB(x, y, gray);
            }
        }
        BufferedImage image2 = Utils.videoPictureToImage((IVideoPicture)Utils.imageToVideoPicture((BufferedImage)image1, (long)0L));
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int pixel = image2.getRGB(x, y);
                Assert.assertTrue((String)"color value missmatch", (pixel == gray ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testImageToImageRandomColor() {
        int w = 50;
        int h = 50;
        Random rnd = new Random();
        BufferedImage image1 = new BufferedImage(w, h, 5);
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                Color c = new Color(rnd.nextInt(255), rnd.nextInt(255), rnd.nextInt(255));
                image1.setRGB(x, y, c.getRGB());
            }
        }
        BufferedImage image2 = Utils.videoPictureToImage((IVideoPicture)Utils.imageToVideoPicture((BufferedImage)image1, (long)0L));
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int pixel2;
                int pixel1 = image1.getRGB(x, y);
                Assert.assertTrue((String)"color value missmatch", (pixel1 == (pixel2 = image2.getRGB(x, y)) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testPictureToPictureWithRotate() {
        int size = 50;
        int black = Color.BLACK.getRGB();
        int white = Color.WHITE.getRGB();
        BufferedImage image1 = new BufferedImage(size, size, 5);
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                int color = x % 2 == 0 ? black : white;
                image1.setRGB(x, y, color);
            }
        }
        BufferedImage image2 = Utils.videoPictureToImage((IVideoPicture)Utils.imageToVideoPicture((BufferedImage)image1, (long)0L));
        AffineTransform t = AffineTransform.getRotateInstance(1.5707963267948966, image2.getWidth() / 2, image2.getHeight() / 2);
        AffineTransformOp ato = new AffineTransformOp(t, 3);
        BufferedImage image3 = new BufferedImage(size, size, 5);
        ato.filter(image2, image3);
        BufferedImage image4 = Utils.videoPictureToImage((IVideoPicture)Utils.imageToVideoPicture((BufferedImage)image3, (long)0L));
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                int pixel = image4.getRGB(x, y);
                int color = y % 2 == 0 ? black : white;
                Assert.assertTrue((String)"color value missmatch", (pixel == color ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testUtilsCrossHatch() throws ParseException {
        Converter converter = new Converter(){

            protected IVideoPicture alterVideoFrame(IVideoPicture videoFrame) {
                int CROSSHATCH_WIDTH = 20;
                int CROSSHATCH_HEIGHT = 20;
                if (videoFrame.getPts() / Global.DEFAULT_PTS_PER_SECOND % 2L == 1L) {
                    return Utils.getBlankFrame((int)videoFrame.getWidth(), (int)videoFrame.getHeight(), (int)0, (int)0, (int)0, (long)videoFrame.getTimeStamp(), (int)20, (int)20, (int)255, (int)255, (int)255);
                }
                return Utils.getBlankFrame((int)videoFrame.getWidth(), (int)videoFrame.getHeight(), (int)255, (int)255, (int)255, (long)videoFrame.getTimeStamp(), (int)20, (int)20, (int)0, (int)0, (int)0);
            }
        };
        String[] args = new String[]{"--containerformat", "mov", "--acodec", "libmp3lame", "--asamplerate", "22050", "--achannels", "2", "--abitrate", "64000", "--aquality", "0", "--vcodec", "mpeg4", "--vscalefactor", "1.0", "--vbitrate", "300000", "--vbitratetolerance", "12000000", "--vquality", "0", "fixtures/testfile_videoonly_20sec.flv", this.getClass().getName() + "_" + this.mTestName + ".mov"};
        Options options = converter.defineOptions();
        CommandLine cmdLine = converter.parseOptions(options, args);
        Assert.assertTrue((String)"all commandline options successful", (cmdLine != null ? 1 : 0) != 0);
        converter.run(cmdLine);
    }
}

