/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.test_utils.NameAwareTestClassRunner;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=NameAwareTestClassRunner.class)
public class MuxerTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String mTestName;

    @Before
    public void setUp() throws Exception {
        this.mTestName = NameAwareTestClassRunner.getTestMethodName();
        this.log.debug("-----START----- {}", (Object)this.mTestName);
    }

    @After
    public void tearDown() throws Exception {
        this.log.debug("----- END ----- {}", (Object)this.mTestName);
    }

    @Test
    public void testMuxing() {
        IPacket pkt;
        int i;
        IContainer input = IContainer.make();
        int numCopies = 4;
        IContainer[] outputs = new IContainer[4];
        for (int i2 = 0; i2 < outputs.length; ++i2) {
            outputs[i2] = IContainer.make();
            outputs[i2].open(this.getClass().getName() + "_" + this.mTestName + "_" + i2 + ".flv", IContainer.Type.WRITE, null);
        }
        Assert.assertTrue((String)"could not open file", (input.open("fixtures/testfile.flv", IContainer.Type.READ, null) >= 0 ? 1 : 0) != 0);
        int numStreams = input.getNumStreams();
        for (i = 0; i < numStreams; ++i) {
            IStream stream = input.getStream((long)i);
            IStreamCoder coder = stream.getStreamCoder();
            Assert.assertTrue((coder.open() >= 0 ? 1 : 0) != 0);
            for (int j = 0; j < outputs.length; ++j) {
                outputs[j].addNewStream(i);
                IStreamCoder newCoder = IStreamCoder.make((IStreamCoder.Direction)IStreamCoder.Direction.ENCODING, (IStreamCoder)coder);
                Assert.assertTrue((outputs[j].getStream((long)i).setStreamCoder(newCoder) >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)"could not open copied coder", (newCoder.open() >= 0 ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < outputs.length; ++i) {
            Assert.assertTrue((outputs[i].writeHeader() >= 0 ? 1 : 0) != 0);
        }
        int numPktsRead = 0;
        int numPktsWritten = 0;
        while (input.readNextPacket(pkt = IPacket.make()) >= 0) {
            ++numPktsRead;
            for (int i3 = 0; i3 < outputs.length; ++i3) {
                Assert.assertTrue((outputs[i3].writePacket(pkt, false) >= 0 ? 1 : 0) != 0);
                ++numPktsWritten;
            }
        }
        Assert.assertEquals((long)numPktsRead, (long)(numPktsWritten / outputs.length));
        Assert.assertEquals((long)7950L, (long)numPktsRead);
        for (int i4 = 0; i4 < outputs.length; ++i4) {
            Assert.assertTrue((outputs[i4].writeTrailer() >= 0 ? 1 : 0) != 0);
            int streams = outputs[i4].getNumStreams();
            for (int j = 0; j < streams; ++j) {
                Assert.assertTrue((outputs[i4].getStream((long)j).getStreamCoder().close() >= 0 ? 1 : 0) != 0);
            }
            Assert.assertTrue((outputs[i4].close() >= 0 ? 1 : 0) != 0);
        }
    }
}

