/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IMetaData;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class MetaDataTest {
    public static final String AUTHOR_KEY = "TPE1";
    public static final String GENRE_KEY = "TCON";
    public static final String TITLE_KEY = "TIT2";
    public static final String YEAR_KEY = "TYER";
    public static final String ALBUM_KEY = "TALB";
    public static final String COMMENT_KEY = "comment";

    @Test
    public final void testGetKeys() {
        IMetaData meta = IMetaData.make();
        Collection keys = meta.getKeys();
        Assert.assertNotNull((Object)keys);
        Assert.assertEquals((long)0L, (long)keys.size());
        meta.setValue("foo", "bar");
        meta.setValue("bar", "goober");
        keys = meta.getKeys();
        Assert.assertEquals((long)2L, (long)keys.size());
        System.out.println("MetaData = " + meta);
    }

    @Test
    public final void testGetValue() {
        IMetaData meta = IMetaData.make();
        Collection keys = meta.getKeys();
        Assert.assertNotNull((Object)keys);
        Assert.assertEquals((long)0L, (long)keys.size());
        meta.setValue("foo", "bar");
        meta.setValue("bar", "goober");
        keys = meta.getKeys();
        Assert.assertEquals((long)2L, (long)keys.size());
        Assert.assertEquals((Object)"bar", (Object)meta.getValue("FoO", IMetaData.Flags.METADATA_NONE));
        Assert.assertNull((Object)meta.getValue("FoO", IMetaData.Flags.METADATA_MATCH_CASE));
        Assert.assertNull((Object)meta.getValue("notthere"));
    }

    @Test
    public void testGetFromContainer() {
        IContainer container = IContainer.make();
        container.open("fixtures/testfile.mp3", IContainer.Type.READ, null);
        IMetaData meta = container.getMetaData();
        Collection keys = meta.getKeys();
        for (String key : keys) {
            System.out.println(key + " = " + meta.getValue(key));
        }
        Assert.assertNotNull((Object)meta.getValue(AUTHOR_KEY));
        meta.setValue(AUTHOR_KEY, "Your Mom");
        Assert.assertEquals((Object)"Your Mom", (Object)meta.getValue(AUTHOR_KEY));
    }

    @Test
    @Ignore
    public void testSetInContainer() {
        int ret;
        String filename = this.getClass().getName() + ".mp3";
        IContainer container = IContainer.make();
        container.open(filename, IContainer.Type.WRITE, null);
        IStream stream = container.addNewStream(0);
        IStreamCoder coder = stream.getStreamCoder();
        coder.setCodec(ICodec.ID.CODEC_ID_MP3);
        coder.setSampleRate(22050);
        coder.setChannels(1);
        coder.open();
        IMetaData meta = container.getMetaData();
        String author = "Your Mom";
        String genre = "6";
        String title = "Ode to Mothers";
        meta.setValue(TITLE_KEY, title);
        meta.setValue(AUTHOR_KEY, author);
        meta.setValue(GENRE_KEY, genre);
        meta.setValue(YEAR_KEY, "2009");
        meta.setValue(ALBUM_KEY, "So large the sun rotates around her");
        meta.setValue(COMMENT_KEY, "I wonder why genre is blues?");
        container.writeHeader();
        byte[] fakeData = new byte[36864];
        for (int i = 0; i < fakeData.length; ++i) {
            fakeData[i] = (byte)i;
        }
        IBuffer buffer = IBuffer.make(null, (byte[])fakeData, (int)0, (int)fakeData.length);
        IAudioSamples samples = IAudioSamples.make((IBuffer)buffer, (int)coder.getChannels(), (IAudioSamples.Format)coder.getSampleFormat());
        samples.setComplete(true, (long)(fakeData.length / 2), coder.getSampleRate(), coder.getChannels(), coder.getSampleFormat(), 0L);
        IPacket packet = IPacket.make();
        int samplesDecoded = 0;
        while ((ret = coder.encodeAudio(packet, samples, (long)samplesDecoded)) > 0 && (long)(samplesDecoded += ret) < samples.getNumSamples()) {
            if (!packet.isComplete()) continue;
            container.writePacket(packet);
        }
        coder.encodeAudio(packet, null, 0L);
        if (packet.isComplete()) {
            container.writePacket(packet);
        }
        container.writeTrailer();
        coder.close();
        coder.delete();
        stream.delete();
        container.close();
        container.delete();
        container = IContainer.make();
        Assert.assertTrue((container.open(filename, IContainer.Type.READ, null) >= 0 ? 1 : 0) != 0);
        meta = container.getMetaData();
        System.out.println("Metadata = " + meta);
        Assert.assertEquals((Object)author, (Object)meta.getValue(AUTHOR_KEY));
        Assert.assertEquals((Object)"Grunge", (Object)meta.getValue(GENRE_KEY));
        Assert.assertEquals((Object)title, (Object)meta.getValue(TITLE_KEY));
    }

    @Test
    @Ignore
    public void testGetFLVMetaDataContainer() {
        IContainer container = IContainer.make();
        container.open("fixtures/testfile.flv", IContainer.Type.READ, null);
        IMetaData meta = container.getMetaData();
        Collection keys = meta.getKeys();
        for (String key : keys) {
            System.out.println(key + " = " + meta.getValue(key));
        }
        if (keys.size() > 0) {
            Assert.assertEquals((long)11L, (long)keys.size());
            meta.setValue(AUTHOR_KEY, "Your Mom");
            Assert.assertEquals((Object)"Your Mom", (Object)meta.getValue(AUTHOR_KEY));
        }
        container.close();
        meta.delete();
        container.delete();
    }
}

