/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.xuggler.Converter;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IVideoResampler;
import junit.framework.TestCase;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ConverterExhaustiveTest
extends TestCase {
    private Converter converter = null;

    public void testRealTimeConversion() throws ParseException {
        String[] args = new String[]{"--containerformat", "mov", "--acodec", "libfaac", "--asamplerate", "22050", "--achannels", "2", "--abitrate", "64000", "--aquality", "0", "--vcodec", "mpeg4", "--vscalefactor", "1.0", "--vbitrate", "300000", "--vbitratetolerance", "12000000", "--vquality", "0", "--realtime", "fixtures/testfile_videoonly_20sec.flv", ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".mov"};
        this.converter = new Converter();
        Options options = this.converter.defineOptions();
        CommandLine cmdLine = this.converter.parseOptions(options, args);
        ConverterExhaustiveTest.assertTrue((String)"all commandline options successful", (cmdLine != null ? 1 : 0) != 0);
        long startTime = System.nanoTime();
        this.converter.run(cmdLine);
        long endTime = System.nanoTime();
        long delta = endTime - startTime;
        ConverterExhaustiveTest.assertTrue((String)"did not take long enough", (delta >= 18000000000L ? 1 : 0) != 0);
        System.err.println("Total time taken: " + delta);
        ConverterExhaustiveTest.assertTrue((String)"took too long", (delta <= 60000000000L ? 1 : 0) != 0);
    }

    public void testConversionOggVorbisTheora() throws ParseException {
        String[] args = new String[]{"--vcodec", "libtheora", "--acodec", "libvorbis", "fixtures/testfile.flv", ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".ogg"};
        this.converter = new Converter();
        Options options = this.converter.defineOptions();
        CommandLine cmdLine = this.converter.parseOptions(options, args);
        ConverterExhaustiveTest.assertTrue((String)"all commandline options successful", (cmdLine != null ? 1 : 0) != 0);
        this.converter.run(cmdLine);
    }

    public void testIssue165() throws ParseException {
        String[] args = new String[]{"fixtures/youtube_h264_mp3.flv", ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".mov"};
        this.converter = new Converter();
        Options options = this.converter.defineOptions();
        CommandLine cmdLine = this.converter.parseOptions(options, args);
        ConverterExhaustiveTest.assertTrue((String)"all commandline options successful", (cmdLine != null ? 1 : 0) != 0);
        this.converter.run(cmdLine);
    }

    public void testConversionH264() throws ParseException {
        String[] args = new String[]{"--containerformat", "mov", "--acodec", "libmp3lame", "--asamplerate", "22050", "--achannels", "2", "--abitrate", "64000", "--aquality", "0", "--vcodec", "libx264", "--vscalefactor", "2.0", "--vpreset", "fixtures/" + ((Object)((Object)this)).getClass().getName() + ".vpresets.txt", "--vbitrate", "300000", "--vbitratetolerance", "12000000", "--vquality", "0", "fixtures/testfile_videoonly_20sec.flv", ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".mp4"};
        ICodec codec = ICodec.findEncodingCodecByName((String)"libx264");
        if (codec == null) {
            return;
        }
        this.converter = new Converter();
        Options options = this.converter.defineOptions();
        CommandLine cmdLine = this.converter.parseOptions(options, args);
        ConverterExhaustiveTest.assertTrue((String)"all commandline options successful", (cmdLine != null ? 1 : 0) != 0);
        this.converter.run(cmdLine);
    }

    public void testConversionAac() throws ParseException {
        boolean testResampling = IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_IMAGERESCALING);
        if (!testResampling) {
            return;
        }
        String[] args = new String[]{"--containerformat", "mov", "--acodec", "libfaac", "--asamplerate", "22050", "--achannels", "2", "--abitrate", "64000", "--aquality", "0", "--vcodec", "mpeg4", "--vscalefactor", testResampling ? "2.0" : "1.0", "--vbitrate", "300000", "--vbitratetolerance", "12000000", "--vquality", "0", "fixtures/testfile_videoonly_20sec.flv", ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".mov"};
        this.converter = new Converter();
        Options options = this.converter.defineOptions();
        CommandLine cmdLine = this.converter.parseOptions(options, args);
        ConverterExhaustiveTest.assertTrue((String)"all commandline options successful", (cmdLine != null ? 1 : 0) != 0);
        this.converter.run(cmdLine);
    }
}

