/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.JNIMemoryManager;
import com.xuggle.ferry.JNIReference;
import com.xuggle.ferry.RefCountedTester;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class RefCountedTest {
    @Parameterized.Parameters
    public static Collection<Object[]> getModels() {
        LinkedList<Object[]> retval = new LinkedList<Object[]>();
        for (JNIMemoryManager.MemoryModel model : JNIMemoryManager.MemoryModel.values()) {
            retval.add(new Object[]{model});
        }
        return retval;
    }

    public RefCountedTest(JNIMemoryManager.MemoryModel model) {
        JNIMemoryManager.setMemoryModel((JNIMemoryManager.MemoryModel)model);
    }

    @After
    public void tearDown() {
        System.gc();
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException {
        System.gc();
        Thread.sleep(1000L);
        JNIReference.getMgr().gc();
    }

    @Test
    public void testCorrectStartingRefCount() {
        Assert.assertEquals((String)"should be no objects for collection", (long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
        RefCountedTester obj = RefCountedTester.make();
        Assert.assertEquals((String)"starting ref count", (long)1L, (long)obj.getCurrentRefCount());
        obj.delete();
    }

    @Test
    public void testJavaCopyKeepsRefcountConstant() {
        Assert.assertEquals((String)"should be no objects for collection", (long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
        RefCountedTester obj = RefCountedTester.make();
        Assert.assertEquals((String)"starting ref count", (long)1L, (long)obj.getCurrentRefCount());
        RefCountedTester javaCopy = obj;
        Assert.assertEquals((String)"java copy should keep ref the same", (long)1L, (long)javaCopy.getCurrentRefCount());
        javaCopy.delete();
        obj.delete();
        Assert.assertEquals((String)"should be no objects for collection", (long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
    }

    @Test(timeout=20000L)
    public void testNativeCopyRefcountIncrement() throws InterruptedException {
        Assert.assertEquals((String)"should be no objects for collection", (long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
        RefCountedTester obj = RefCountedTester.make();
        Assert.assertEquals((String)"starting ref count", (long)1L, (long)obj.getCurrentRefCount());
        RefCountedTester nativeCopy = RefCountedTester.make((RefCountedTester)obj);
        Assert.assertEquals((String)"native copy should increment", (long)2L, (long)obj.getCurrentRefCount());
        Assert.assertEquals((String)"native copy should increment", (long)2L, (long)nativeCopy.getCurrentRefCount());
        nativeCopy.delete();
        nativeCopy = null;
        Assert.assertEquals((String)"native copy should be decremented", (long)1L, (long)obj.getCurrentRefCount());
        obj.delete();
        obj = null;
        while (JNIReference.getMgr().getNumPinnedObjects() > 0L) {
            byte[] bytes = new byte[0x100000];
            bytes[0] = 0;
            JNIReference.getMgr().gc();
        }
        Assert.assertEquals((String)"should be no objects for collection", (long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
    }

    @Test(timeout=20000L)
    public void testCopyByReference() throws InterruptedException {
        Assert.assertEquals((String)"should be no objects for collection", (long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
        RefCountedTester obj1 = RefCountedTester.make();
        RefCountedTester obj2 = obj1.copyReference();
        Assert.assertTrue((String)"should look like different objects", (obj1 != obj2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"should be equal though", (boolean)obj1.equals((Object)obj2));
        Assert.assertEquals((String)"should have same ref count", (long)obj1.getCurrentRefCount(), (long)obj2.getCurrentRefCount());
        Assert.assertEquals((String)"should have ref count of 2", (long)2L, (long)obj2.getCurrentRefCount());
        obj1.delete();
        obj1 = null;
        Assert.assertEquals((String)"should now have refcount of 1", (long)1L, (long)obj2.getCurrentRefCount());
        obj2.delete();
        obj2 = null;
        while (JNIReference.getMgr().getNumPinnedObjects() > 0L) {
            byte[] bytes = new byte[0x100000];
            bytes[0] = 0;
            JNIReference.getMgr().gc();
        }
        Assert.assertEquals((String)"should be no objects for collection", (long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
    }

    @Test(timeout=20000L)
    public void testGarbageCollectionDoesEventuallyReleaseNativeReferences() throws InterruptedException {
        Assert.assertEquals((String)"should be no objects for collection", (long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
        RefCountedTester obj1 = RefCountedTester.make();
        RefCountedTester obj2 = obj1.copyReference();
        Assert.assertTrue((String)"should look like different objects", (obj1 != obj2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"should be equal though", (boolean)obj1.equals((Object)obj2));
        Assert.assertEquals((String)"should have same ref count", (long)obj1.getCurrentRefCount(), (long)obj2.getCurrentRefCount());
        Assert.assertEquals((String)"should have ref count of 2", (long)2L, (long)obj2.getCurrentRefCount());
        obj1 = null;
        while (JNIReference.getMgr().getNumPinnedObjects() > 1L) {
            byte[] bytes = new byte[0x100000];
            bytes[0] = 0;
            JNIReference.getMgr().gc();
        }
        Assert.assertEquals((String)"should be only the first object for collection", (long)1L, (long)JNIReference.getMgr().getNumPinnedObjects());
        Assert.assertEquals((String)"should have a ref refcount of 1", (long)1L, (long)obj2.getCurrentRefCount());
        obj2.delete();
        Assert.assertEquals((String)"should be no objects for collection", (long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
    }

    @Test(timeout=20000L)
    public void testJNIWeakReferenceFlushQueue() throws InterruptedException {
        Assert.assertEquals((String)"should be no objects for collection", (long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
        RefCountedTester obj1 = RefCountedTester.make();
        Assert.assertEquals((String)"should be no objects for collection", (long)1L, (long)JNIReference.getMgr().getNumPinnedObjects());
        RefCountedTester obj2 = obj1.copyReference();
        Assert.assertEquals((String)"should be no objects for collection", (long)2L, (long)JNIReference.getMgr().getNumPinnedObjects());
        Assert.assertTrue((String)"should look like different objects", (obj1 != obj2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"should be equal though", (boolean)obj1.equals((Object)obj2));
        Assert.assertEquals((String)"should have same ref count", (long)obj1.getCurrentRefCount(), (long)obj2.getCurrentRefCount());
        Assert.assertEquals((String)"should have ref count of 2", (long)2L, (long)obj2.getCurrentRefCount());
        Assert.assertEquals((String)"should be no objects for collection", (long)2L, (long)JNIReference.getMgr().getNumPinnedObjects());
        obj1 = null;
        while (obj2.getCurrentRefCount() > 1L) {
            byte[] bytes = new byte[0x100000];
            bytes[0] = 0;
            JNIReference.getMgr().gc();
        }
        Assert.assertEquals((String)"should now have a ref refcount of 1", (long)1L, (long)obj2.getCurrentRefCount());
        Assert.assertEquals((String)"should be only the first object for collection", (long)1L, (long)JNIReference.getMgr().getNumPinnedObjects());
        obj2.delete();
        Assert.assertEquals((String)"should be no objects for collection", (long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
    }

    @Test(expected=NullPointerException.class)
    public void testDeleteThenCallRaisesException() {
        RefCountedTester obj = RefCountedTester.make();
        obj.delete();
        obj.getCurrentRefCount();
        Assert.assertEquals((String)"should be no objects for collection", (long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
    }
}

