/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.JNIMemoryManager;
import com.xuggle.ferry.JNIReference;
import com.xuggle.ferry.MemoryTestHelper;
import com.xuggle.ferry.RefCounted;
import com.xuggle.ferry.RefCountedTester;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class RefCountedExhaustiveTest {
    @Parameterized.Parameters
    public static Collection<Object[]> getModels() {
        LinkedList<Object[]> retval = new LinkedList<Object[]>();
        for (JNIMemoryManager.MemoryModel model : JNIMemoryManager.MemoryModel.values()) {
            retval.add(new Object[]{model});
        }
        return retval;
    }

    public RefCountedExhaustiveTest(JNIMemoryManager.MemoryModel model) {
        JNIMemoryManager.setMemoryModel((JNIMemoryManager.MemoryModel)model);
    }

    @Before
    public void setUp() {
        JNIMemoryManager.getMgr().flush();
    }

    @Test(timeout=60000L)
    public void testReferenceCountingLoadTestOfDeath() throws InterruptedException {
        Assert.assertEquals((String)"should be no objects for collection", (long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
        RefCountedTester obj = RefCountedTester.make();
        for (int i = 0; i < 1000; ++i) {
            RefCountedTester copy = obj.copyReference();
            Assert.assertNotNull((String)"could not copy reference", (Object)copy);
        }
        obj = null;
        while (JNIReference.getMgr().getNumPinnedObjects() > 0L) {
            MemoryTestHelper.forceJavaHeapWeakReferenceClear();
        }
        Assert.assertEquals((String)"Looks like we leaked an object", (long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testCopyReferenceLoadTest() {
        Assert.assertEquals((long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
        RefCountedTester obj = RefCountedTester.make();
        for (int i = 0; i < 100000; ++i) {
            RefCounted copy = obj.copyReference();
            copy.delete();
        }
        obj.delete();
        Assert.assertEquals((long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyReferenceLoadTestMultiThreaded() throws InterruptedException {
        int i;
        Assert.assertEquals((long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
        RefCountedTester obj = RefCountedTester.make();
        int NUM_THREADS = 100;
        int NUM_ITERS = 10000;
        final AtomicBoolean start = new AtomicBoolean(false);
        Thread[] threads = new Thread[100];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(new Runnable((RefCounted)obj){
                final /* synthetic */ RefCounted val$obj;
                {
                    this.val$obj = refCounted;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    AtomicBoolean atomicBoolean = start;
                    synchronized (atomicBoolean) {
                        while (!start.get()) {
                            try {
                                start.wait();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    for (int i = 0; i < 10000; ++i) {
                        RefCounted copy = this.val$obj.copyReference();
                        copy.delete();
                    }
                }
            }, "thread_" + i);
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        AtomicBoolean i2 = start;
        synchronized (i2) {
            start.set(true);
            start.notifyAll();
        }
        for (int i3 = 0; i3 < threads.length; ++i3) {
            threads[i3].join();
        }
        obj.delete();
        Assert.assertEquals((long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test(timeout=300000L)
    public void testJNIMemoryManagerHeapExpansion() {
        int i;
        LinkedList<RefCountedTester> heldRefs = new LinkedList<RefCountedTester>();
        JNIMemoryManager mgr = JNIMemoryManager.getMgr();
        mgr.flush();
        mgr.setMinimumReferencesToCache(1024);
        int maxItems = 10000;
        for (i = 0; i < maxItems; ++i) {
            heldRefs.add(RefCountedTester.make());
        }
        Assert.assertEquals((String)"didn't pin as many as it should", (long)maxItems, (long)mgr.getNumPinnedObjects());
        heldRefs.clear();
        while (mgr.getNumPinnedObjects() != 0L) {
            MemoryTestHelper.forceJavaHeapWeakReferenceClear();
            mgr.gc(true);
        }
        Assert.assertEquals((String)"didn't pin as many as it should", (long)0L, (long)mgr.getNumPinnedObjects());
        for (i = 0; i < maxItems / 2; ++i) {
            heldRefs.add(RefCountedTester.make());
        }
        Assert.assertEquals((String)"didn't pin as many as it should", (long)(maxItems / 2), (long)mgr.getNumPinnedObjects());
        heldRefs.clear();
        while (mgr.getNumPinnedObjects() != 0L) {
            MemoryTestHelper.forceJavaHeapWeakReferenceClear();
            mgr.gc(true);
        }
        Assert.assertEquals((String)"didn't pin as many as it should", (long)0L, (long)mgr.getNumPinnedObjects());
    }
}

