/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoableEdit;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PrintUtils;
import org.opensourcephysics.tools.EncryptionTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.JarTool;
import org.opensourcephysics.tools.JarTreeDialog;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.LaunchPanel;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.LaunchSaver;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.LauncherUndo;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class LaunchBuilder
extends Launcher {
    static final Color RED = new Color(255, 102, 102);
    static JFileChooser fileChooser;
    static javax.swing.filechooser.FileFilter jarFileFilter;
    static javax.swing.filechooser.FileFilter htmlFileFilter;
    static javax.swing.filechooser.FileFilter pdfFileFilter;
    static javax.swing.filechooser.FileFilter allFileFilter;
    static int maxArgs;
    static File ospJarFolder;
    static Color enabledColor;
    static Color disabledColor;
    Action newTabSetAction;
    Action changeAction;
    Action newTabAction;
    Action addAction;
    Action cutAction;
    Action copyAction;
    Action pasteAction;
    Action importAction;
    Action saveAsAction;
    Action saveAction;
    Action saveAllAction;
    Action saveSetAsAction;
    Action moveUpAction;
    Action moveDownAction;
    Action openJarAction;
    Action searchJarAction;
    Action saveJarAction;
    Action openArgAction;
    Action openModelArgAction;
    Action openURLAction;
    Action openPDFAction;
    Action searchJarForModelAction;
    Action openTabAction;
    Icon openIcon;
    JTabbedPane editorTabs;
    FocusListener focusListener;
    KeyListener keyListener;
    JPanel displayPanel;
    JPanel launchPanel;
    JPanel authorPanel;
    ArrayList<JLabel> labels;
    JTextField titleField;
    JLabel titleLabel;
    JTextField passwordEditor;
    JLabel passwordLabel;
    JTextField nameField;
    JLabel nameLabel;
    JTextField tooltipField;
    JLabel tooltipLabel;
    TitledBorder displayTitle;
    JTextField classField;
    JLabel classLabel;
    JTextField argField;
    JLabel argLabel;
    JSpinner argSpinner;
    JTextField jarField;
    JLabel jarLabel;
    JToolBar displayBar;
    JLabel displayLabel;
    SpinnerNumberModel displaySpinnerModel;
    JSpinner displaySpinner;
    JLabel pathLabel;
    JTextField pathField;
    JButton openDisplayChooserButton;
    JButton showModelArgsButton;
    JDialog modelArgsDialog;
    JTextField modelArgField;
    JLabel modelArgLabel;
    JSpinner modelArgSpinner;
    JButton modelArgCloseButton;
    JButton modelArgClearButton;
    JLabel tabTitleLabel;
    JTextField tabTitleField;
    JPanel urlPanel;
    JTextPane descriptionPane;
    JScrollPane descriptionScroller;
    TitledBorder descriptionTitle;
    JEditorPane htmlPane;
    JScrollPane htmlScroller;
    JSplitPane displaySplitPane;
    JTextField authorField;
    JLabel authorLabel;
    JTextField keywordField;
    JLabel keywordLabel;
    JTextField levelField;
    JLabel levelLabel;
    JTextField languagesField;
    JLabel languagesLabel;
    JTextPane commentPane;
    JScrollPane commentScroller;
    TitledBorder commentTitle;
    TitledBorder optionsTitle;
    TitledBorder securityTitle;
    JCheckBox editorEnabledCheckBox;
    JCheckBox encryptCheckBox;
    JCheckBox onEditCheckBox;
    JCheckBox onLoadCheckBox;
    JCheckBox hideRootCheckBox;
    JCheckBox hiddenCheckBox;
    JCheckBox buttonViewCheckBox;
    JCheckBox singleVMCheckBox;
    JCheckBox showLogCheckBox;
    JCheckBox clearLogCheckBox;
    JCheckBox singletonCheckBox;
    JCheckBox singleAppCheckBox;
    JComboBox levelDropDown;
    String previousClassPath;
    JButton newTabButton;
    JButton addButton;
    JButton cutButton;
    JButton copyButton;
    JButton pasteButton;
    JButton moveUpButton;
    JButton moveDownButton;
    JMenuItem newItem;
    JMenuItem previewItem;
    JMenuItem saveNodeItem;
    JMenuItem saveNodeAsItem;
    JMenuItem saveSetAsItem;
    JMenuItem saveAllItem;
    JMenuItem saveJarItem;
    JMenuItem importItem;
    JMenuItem openTabItem;
    JMenu toolsMenu;
    JMenuItem encryptionToolItem;
    JToolBar toolbar;
    LaunchSaver saver = new LaunchSaver(this);

    static {
        maxArgs = 4;
        enabledColor = UIManager.getColor("Label.foreground");
        if (enabledColor == null) {
            enabledColor = Color.BLACK;
        }
        if ((disabledColor = UIManager.getColor("Label.disabledForeground")) == null) {
            disabledColor = UIManager.getColor("Label.disabledText");
        }
        if (disabledColor == null) {
            disabledColor = Color.LIGHT_GRAY;
        }
    }

    public LaunchBuilder() {
        OSPRuntime.setAuthorMode(true);
        XML.setLoader(NodeSet.class, new NodeSet.Loader());
    }

    public LaunchBuilder(String string) {
        super(string);
        OSPRuntime.setAuthorMode(true);
        XML.setLoader(NodeSet.class, new NodeSet.Loader());
    }

    public LaunchBuilder(boolean bl) {
        super(bl);
        OSPRuntime.setAuthorMode(true);
        XML.setLoader(NodeSet.class, new NodeSet.Loader());
    }

    public LaunchBuilder(String string, boolean bl) {
        super(string, bl);
        OSPRuntime.setAuthorMode(true);
        XML.setLoader(NodeSet.class, new NodeSet.Loader());
    }

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray != null && stringArray.length != 0) {
            string = stringArray[0];
        }
        LaunchBuilder launchBuilder = new LaunchBuilder(string);
        launchBuilder.frame.setVisible(true);
    }

    public String save(LaunchNode launchNode, String string) {
        Object object;
        if (launchNode == null) {
            return null;
        }
        if (string == null || string.trim().equals("")) {
            return this.saveAs(launchNode);
        }
        if (XML.getExtension(string) == null) {
            while (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
            string = String.valueOf(string) + ".xml";
        }
        if (!this.saveOwnedNodes(launchNode)) {
            return null;
        }
        String string2 = string;
        if (!tabSetBasePath.equals("")) {
            string2 = XML.getResolvedPath(string, tabSetBasePath);
        } else {
            object = OSPRuntime.getLaunchJarDirectory();
            string2 = XML.getResolvedPath(string, (String)object);
        }
        object = new File(string2);
        OSPLog.fine(String.valueOf(string) + " = " + ((File)object).getAbsolutePath());
        String string3 = XML.forwardSlash(((File)object).getAbsolutePath());
        String string4 = XML.getDirectoryPath(string3);
        XML.createFolders(string4);
        XMLControlElement xMLControlElement = new XMLControlElement(launchNode);
        xMLControlElement.write(string3);
        if (!xMLControlElement.canWrite) {
            OSPLog.info(String.valueOf(LaunchRes.getString("Dialog.SaveFailed.Message")) + " " + string3);
            JOptionPane.showMessageDialog(null, String.valueOf(LaunchRes.getString("Dialog.SaveFailed.Message")) + " " + string, LaunchRes.getString("Dialog.SaveFailed.Title"), 2);
            return null;
        }
        launchNode.setFileName(string);
        this.changedFiles.remove(launchNode.getFileName());
        return string;
    }

    public String saveAs(LaunchNode launchNode) {
        Object object;
        String string;
        LaunchBuilder.getXMLChooser().setFileFilter(xmlFileFilter);
        if (launchNode.getFileName() != null) {
            string = XML.getResolvedPath(launchNode.getFileName(), tabSetBasePath);
            LaunchBuilder.getXMLChooser().setSelectedFile(new File(string));
        } else {
            string = launchNode.name;
            if (string.equals(LaunchRes.getString("NewNode.Name")) || string.equals(LaunchRes.getString("NewTab.Name"))) {
                string = LaunchRes.getString("NewFile.Name");
            }
            object = XML.getResolvedPath(String.valueOf(string) + ".xml", tabSetBasePath);
            LaunchBuilder.getXMLChooser().setSelectedFile(new File((String)object));
        }
        int n = LaunchBuilder.getXMLChooser().showDialog(null, LaunchRes.getString("FileChooser.SaveAs.Title"));
        if (n == 0) {
            String string2;
            object = LaunchBuilder.getXMLChooser().getSelectedFile();
            String string3 = XML.forwardSlash(((File)object).getParent());
            XML.createFolders(string3);
            if (((File)object).exists()) {
                string2 = XML.forwardSlash(((File)object).getAbsolutePath());
                string2 = XML.getPathRelativeTo(string2, tabSetBasePath);
                if (this.getOpenPaths().contains(string2)) {
                    JOptionPane.showMessageDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.DuplicateFileName.Message")) + " \"" + string2 + "\"", LaunchRes.getString("Dialog.DuplicateFileName.Title"), 2);
                    return null;
                }
                int n2 = JOptionPane.showConfirmDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.ReplaceFile.Message")) + " " + ((File)object).getName() + XML.NEW_LINE + LaunchRes.getString("Dialog.ReplaceFile.Question"), LaunchRes.getString("Dialog.ReplaceFile.Title"), 0);
                if (n2 != 0) {
                    return null;
                }
            }
            string3 = XML.forwardSlash(((File)object).getAbsolutePath());
            string2 = XML.getPathRelativeTo(string3, tabSetBasePath);
            OSPRuntime.chooserDir = XML.getDirectoryPath(string3);
            Map<LaunchPanel, LaunchNode> map = this.getClones(launchNode);
            string3 = this.save(launchNode, string2);
            if (string3 != null) {
                if (launchNode.isRoot()) {
                    int n3 = 0;
                    while (n3 < this.tabbedPane.getTabCount()) {
                        LaunchPanel launchPanel = (LaunchPanel)this.tabbedPane.getComponentAt(n3);
                        if (launchPanel.getRootNode() == launchNode) {
                            this.tabbedPane.setTitleAt(n3, launchNode.toString());
                            break;
                        }
                        ++n3;
                    }
                }
                for (LaunchPanel launchPanel : map.keySet()) {
                    LaunchNode launchNode2 = map.get(launchPanel);
                    launchNode2.setFileName(launchNode.getFileName());
                    if (launchNode2 != launchPanel.getRootNode()) continue;
                    int n4 = this.tabbedPane.indexOfComponent(launchPanel);
                    this.tabbedPane.setTitleAt(n4, launchNode.toString());
                }
                if (this.tabSetName != null) {
                    this.changedFiles.add(this.tabSetName);
                }
            }
            return string3;
        }
        return null;
    }

    protected boolean saveOwnedNodes(LaunchNode launchNode) {
        if (launchNode == null) {
            return false;
        }
        if (launchNode.isSelfContained()) {
            return true;
        }
        LaunchNode[] launchNodeArray = launchNode.getChildOwnedNodes();
        int n = 0;
        while (n < launchNodeArray.length) {
            if (launchNodeArray[n].getChildOwnedNodes().length > 1 && !this.saveOwnedNodes(launchNodeArray[n])) {
                return false;
            }
            if (this.save(launchNodeArray[n], launchNodeArray[n].getFileName()) == null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected String saveTabSetAs() {
        int n;
        this.saver.setBuilder(this);
        this.saver.setVisible(true);
        if (!this.saver.isApproved()) {
            return null;
        }
        String string = XML.getResolvedPath(this.tabSetName, tabSetBasePath);
        File file = new File(string);
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.ReplaceFile.Message")) + " " + file.getName() + XML.NEW_LINE + LaunchRes.getString("Dialog.ReplaceFile.Question"), LaunchRes.getString("Dialog.ReplaceFile.Title"), 0)) != 0) {
            return null;
        }
        this.saveState = this.saver.saveStateCheckBox.isSelected();
        return this.saveTabSet();
    }

    public String saveTabSet() {
        Object object;
        if (this.tabSetName == null) {
            return null;
        }
        if (this.tabSetName.trim().equals("")) {
            return this.saveTabSetAs();
        }
        if (!this.isTabSetWritable()) {
            return this.saveTabSetAs();
        }
        if (!this.selfContained && !this.saveTabs()) {
            return null;
        }
        String string = this.tabSetName;
        if (!tabSetBasePath.equals("")) {
            string = XML.getResolvedPath(this.tabSetName, tabSetBasePath);
        } else {
            object = OSPRuntime.getLaunchJarDirectory();
            string = XML.getResolvedPath(this.tabSetName, (String)object);
        }
        OSPLog.fine(string);
        object = new File(string);
        string = XML.forwardSlash(((File)object).getAbsolutePath());
        String string2 = XML.getDirectoryPath(string);
        XML.createFolders(string2);
        Launcher.LaunchSet launchSet = new Launcher.LaunchSet(this, this.tabSetName);
        XMLControlElement xMLControlElement = new XMLControlElement(launchSet);
        if (xMLControlElement.write(string) == null) {
            return null;
        }
        this.changedFiles.clear();
        this.jarBasePath = null;
        if (this.spawner != null) {
            this.spawner.open(string);
            this.spawner.refreshGUI();
        }
        return string;
    }

    public boolean saveTabs() {
        Component[] componentArray = this.tabbedPane.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            LaunchPanel launchPanel = (LaunchPanel)componentArray[n];
            LaunchNode launchNode = launchPanel.getRootNode();
            if (launchNode.getFileName() != null && !launchNode.getFileName().equals("")) {
                this.save(launchNode, XML.getResolvedPath(launchNode.getFileName(), tabSetBasePath));
            }
            ++n;
        }
        return true;
    }

    protected void refreshSelectedNode() {
        this.refreshNode(this.getSelectedNode());
    }

    protected void refreshNode(LaunchNode launchNode) {
        boolean bl = false;
        if (launchNode != null) {
            boolean bl2;
            Object object;
            String[] stringArray;
            String string;
            LaunchNode launchNode2;
            if (launchNode.isSingleVM() != this.singleVMCheckBox.isSelected()) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeVM"));
                launchNode2 = (LaunchNode)launchNode.getParent();
                if (launchNode2 != null && launchNode2.isSingleVM()) {
                    launchNode.singleVM = false;
                    launchNode.singleVMOff = !this.singleVMCheckBox.isSelected();
                } else {
                    launchNode.singleVM = this.singleVMCheckBox.isSelected();
                    launchNode.singleVMOff = false;
                }
                if (launchNode.isSingleVM()) {
                    this.showLogCheckBox.setSelected(launchNode.showLog);
                    this.clearLogCheckBox.setSelected(launchNode.clearLog);
                    this.singleAppCheckBox.setSelected(launchNode.isSingleApp());
                } else {
                    this.singletonCheckBox.setSelected(launchNode.singleton);
                }
                bl = true;
            }
            if (launchNode.isSingleVM() && launchNode.showLog != this.showLogCheckBox.isSelected()) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeShowLog"));
                launchNode.showLog = this.showLogCheckBox.isSelected();
                bl = true;
            }
            if (launchNode.isSingleVM() && launchNode.isShowLog() && launchNode.clearLog != this.clearLogCheckBox.isSelected()) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeClearLog"));
                launchNode.clearLog = this.clearLogCheckBox.isSelected();
                bl = true;
            }
            if (launchNode.isSingleVM() && launchNode.isSingleApp() != this.singleAppCheckBox.isSelected()) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeSingleApp"));
                launchNode2 = (LaunchNode)launchNode.getParent();
                if (launchNode2 != null && launchNode2.isSingleApp()) {
                    launchNode.singleApp = false;
                    launchNode.singleAppOff = !this.singleAppCheckBox.isSelected();
                } else {
                    launchNode.singleApp = this.singleAppCheckBox.isSelected();
                    launchNode.singleAppOff = false;
                }
                bl = true;
            }
            if (launchNode.singleton != this.singletonCheckBox.isSelected()) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeSingleton"));
                launchNode.singleton = this.singletonCheckBox.isSelected();
                bl = true;
            }
            if (launchNode.hiddenInLauncher != this.hiddenCheckBox.isSelected()) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeHidden"));
                launchNode.hiddenInLauncher = this.hiddenCheckBox.isSelected();
                bl = true;
            }
            if (launchNode.isButtonView() != this.buttonViewCheckBox.isSelected()) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeButtonView"));
                launchNode.setButtonView(this.buttonViewCheckBox.isSelected());
                bl = true;
            }
            if (!launchNode.name.equals(this.nameField.getText())) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeName"));
                launchNode.name = this.nameField.getText();
                bl = true;
            }
            if (!launchNode.tooltip.equals(this.tooltipField.getText())) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeTooltip"));
                launchNode.tooltip = this.tooltipField.getText();
                bl = true;
            }
            if (!launchNode.description.equals(this.descriptionPane.getText())) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeDesc"));
                launchNode.description = this.descriptionPane.getText();
                bl = true;
            }
            int n = (Integer)this.argSpinner.getValue();
            String string2 = this.argField.getText();
            if (!string2.equals("")) {
                launchNode.setMinimumArgLength(n + 1);
            }
            if (launchNode.args.length > n && !string2.equals(launchNode.args[n])) {
                OSPLog.finest(String.valueOf(LaunchRes.getString("Log.Message.ChangeNodeArgs")) + " " + n);
                launchNode.args[n] = string2;
                if (string2.equals("")) {
                    launchNode.setMinimumArgLength(1);
                }
                bl = true;
            }
            if ((string = this.jarField.getText()).equals("") && launchNode.classPath != null || !string.equals("") && !string.equals(launchNode.classPath)) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodePath"));
                launchNode.setClassPath(string.equals("") ? null : string);
                bl = true;
            }
            n = (Integer)this.displaySpinner.getValue();
            LaunchNode.DisplayTab displayTab = launchNode.getDisplayTab(n);
            String string3 = this.pathField.getText();
            if (displayTab == null || displayTab.path != null && !displayTab.path.equals(string3) || string3 != null && !string3.equals(displayTab.path)) {
                stringArray = displayTab == null ? null : displayTab.title;
                object = displayTab == null ? null : displayTab.getModelArgs();
                launchNode.setDisplayTab(n, (String)stringArray, string3, (String[])object);
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeURL"));
                bl = true;
            }
            if (displayTab != null && displayTab.modelClass != null && this.modelArgsDialog.isVisible()) {
                n = (Integer)this.modelArgSpinner.getValue();
                string2 = this.modelArgField.getText();
                if (!string2.equals("")) {
                    displayTab.setMinimumModelArgLength(n + 1);
                }
                if ((stringArray = displayTab.getModelArgs()).length > n && !string2.equals(stringArray[n])) {
                    OSPLog.finest(String.valueOf(LaunchRes.getString("Log.Message.ChangeModelArgs")) + " " + n);
                    stringArray[n] = string2.equals("") ? null : string2;
                    displayTab.setModelArgs(stringArray);
                    if (string2.equals("")) {
                        displayTab.setMinimumModelArgLength(0);
                    }
                    bl = true;
                }
            }
            if ((string3 = this.tabTitleField.getText()).equals("")) {
                string3 = null;
            }
            if (displayTab != null && (displayTab.title != null && !displayTab.title.equals(string3) || string3 != null && !string3.equals(displayTab.title))) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeHTMLTabTitle"));
                launchNode.setDisplayTab(n, string3, displayTab.path, displayTab.getModelArgs());
                bl = true;
            }
            if ((stringArray = this.classField.getText()).equals("")) {
                if (launchNode.launchClassName != null) {
                    launchNode.launchClassName = null;
                    launchNode.launchClass = null;
                    launchNode.launchModelScroller = null;
                    OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeLaunchClass"));
                    bl = true;
                }
            } else if ((!stringArray.equals(launchNode.launchClassName) || !stringArray.equals("") && launchNode.getLaunchClass() == null) && (bl2 = launchNode.setLaunchClass((String)stringArray))) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeLaunchClass"));
                bl = true;
            }
            if (!launchNode.getAuthor().equals(this.authorField.getText())) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeAuthor"));
                launchNode.author = this.authorField.getText();
                bl = true;
            }
            if (!launchNode.keywords.equals(this.keywordField.getText())) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeKeywords"));
                launchNode.keywords = this.keywordField.getText();
                bl = true;
            }
            if (!launchNode.level.equals(this.levelField.getText())) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeLevel"));
                launchNode.level = this.levelField.getText();
                bl = true;
            }
            if (!launchNode.languages.equals(this.languagesField.getText())) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeLanguages"));
                launchNode.languages = this.languagesField.getText();
                bl = true;
            }
            if (!launchNode.comment.equals(this.commentPane.getText())) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeComment"));
                launchNode.comment = this.commentPane.getText();
                bl = true;
            }
            if ((object = (LaunchNode)launchNode.getRoot()) != null) {
                boolean bl3;
                boolean bl4 = this.hideRootCheckBox.isSelected();
                if (bl4 != object.hiddenWhenRoot) {
                    object.hiddenWhenRoot = bl4;
                    OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeRootHidden"));
                    bl = true;
                }
                if ((bl3 = this.editorEnabledCheckBox.isSelected()) != this.editorEnabled) {
                    this.editorEnabled = bl3;
                    OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeEditorEnabled"));
                    if (this.tabSetName != null) {
                        this.changedFiles.add(this.tabSetName);
                    }
                    this.refreshGUI();
                }
            }
            if (bl) {
                OSPLog.fine(String.valueOf(LaunchRes.getString("Log.Message.ChangeNode")) + " \"" + launchNode.toString() + "\"");
                LaunchPanel launchPanel = this.getSelectedTab();
                if (launchPanel != null) {
                    launchPanel.treeModel.nodeChanged(launchNode);
                }
                if (launchNode.getOwner() != null) {
                    this.changedFiles.add(launchNode.getOwner().getFileName());
                } else {
                    this.changedFiles.add(this.tabSetName);
                }
                this.refreshClones(launchNode);
                this.refreshGUI();
            }
        }
    }

    @Override
    public boolean addTab(LaunchNode launchNode) {
        if (launchNode == null) {
            return false;
        }
        OSPLog.finest(launchNode.toString());
        boolean bl = super.addTab(launchNode);
        if (bl) {
            if (this.tabSetName == null) {
                this.tabSetName = LaunchRes.getString("Tabset.Name.New");
            }
            this.changedFiles.add(this.tabSetName);
            this.refreshGUI();
        }
        return bl;
    }

    @Override
    public boolean removeSelectedTab() {
        if (this.tabbedPane.getTabCount() == 1) {
            String[] stringArray = this.undoManager.getLauncherState();
            boolean bl = this.removeAllTabs();
            if (bl && stringArray != null) {
                LauncherUndo launcherUndo = this.undoManager;
                launcherUndo.getClass();
                LauncherUndo.LoadEdit loadEdit = launcherUndo.new LauncherUndo.LoadEdit(null, stringArray);
                this.undoSupport.postEdit(loadEdit);
            }
            return bl;
        }
        LaunchPanel launchPanel = (LaunchPanel)this.tabbedPane.getSelectedComponent();
        if (launchPanel != null && !this.saveChanges(launchPanel)) {
            return false;
        }
        boolean bl = super.removeSelectedTab();
        if (this.tabSetName != null && bl) {
            this.changedFiles.add(this.tabSetName);
            this.refreshGUI();
        }
        return bl;
    }

    protected boolean saveChanges(LaunchPanel launchPanel) {
        LaunchNode launchNode = launchPanel.getRootNode();
        int n = this.tabbedPane.indexOfComponent(launchPanel);
        String string = n > -1 ? this.tabbedPane.getTitleAt(n) : LaunchBuilder.getDisplayName(launchNode.getFileName());
        boolean bl = this.changedFiles.contains(launchNode.getFileName());
        LaunchNode[] launchNodeArray = launchNode.getAllOwnedNodes();
        int n2 = 0;
        while (n2 < launchNodeArray.length) {
            bl = bl || this.changedFiles.contains(launchNodeArray[n2].getFileName());
            ++n2;
        }
        if (bl) {
            n2 = JOptionPane.showConfirmDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.SaveChanges.Tab.Message")) + " \"" + string + "\"" + XML.NEW_LINE + LaunchRes.getString("Dialog.SaveChanges.Question"), LaunchRes.getString("Dialog.SaveChanges.Title"), 1);
            if (n2 == 2) {
                return false;
            }
            if (n2 == 0) {
                this.save(launchNode, launchNode.getFileName());
            }
        }
        return true;
    }

    @Override
    protected boolean removeAllTabs() {
        if (!this.saveAllChanges()) {
            return false;
        }
        return super.removeAllTabs();
    }

    protected boolean saveAllChanges() {
        if (!this.changedFiles.isEmpty() && this.tabbedPane.getTabCount() > 0) {
            String string = LaunchRes.getString("Dialog.SaveChanges.Tabset.Message");
            int n = JOptionPane.showConfirmDialog(this.frame, String.valueOf(string) + "\"" + this.tabSetName + "\"" + XML.NEW_LINE + LaunchRes.getString("Dialog.SaveChanges.Question"), LaunchRes.getString("Dialog.SaveChanges.Title"), 1);
            if (n == 2) {
                return false;
            }
            if (n == 0) {
                if (this.tabSetName.equals(LaunchRes.getString("Tabset.Name.New")) || !this.saveAllItem.isEnabled()) {
                    this.saveTabSetAs();
                } else {
                    this.saveTabSet();
                }
            }
        }
        return true;
    }

    @Override
    protected void refreshStringResources() {
        Rectangle2D rectangle2D;
        super.refreshStringResources();
        this.saver = new LaunchSaver(this);
        this.editorTabs.setTitleAt(0, LaunchRes.getString("Tab.Display"));
        this.editorTabs.setTitleAt(1, LaunchRes.getString("Tab.Launch"));
        this.editorTabs.setTitleAt(2, LaunchRes.getString("Tab.Author"));
        this.displayTitle.setTitle(LaunchRes.getString("Label.DisplayPane"));
        this.commentTitle.setTitle(LaunchRes.getString("Label.Comments"));
        this.descriptionTitle.setTitle(LaunchRes.getString("Label.Description"));
        this.optionsTitle.setTitle(LaunchRes.getString("Label.Options"));
        this.hiddenCheckBox.setText(LaunchRes.getString("Checkbox.Hidden"));
        this.buttonViewCheckBox.setText(LaunchRes.getString("Checkbox.ButtonView"));
        this.nameLabel.setText(LaunchRes.getString("Label.Name"));
        this.tooltipLabel.setText(LaunchRes.getString("Label.Tooltip"));
        this.displayLabel.setText(LaunchRes.getString("Label.Display"));
        this.tabTitleLabel.setText(LaunchRes.getString("Label.TabTitle"));
        this.pathLabel.setText(LaunchRes.getString("Label.Path"));
        this.jarLabel.setText(LaunchRes.getString("Label.Jar"));
        this.classLabel.setText(LaunchRes.getString("Label.Class"));
        this.argLabel.setText(LaunchRes.getString("Label.Args"));
        this.singleVMCheckBox.setText(LaunchRes.getString("Checkbox.SingleVM"));
        this.showLogCheckBox.setText(LaunchRes.getString("Checkbox.ShowLog"));
        this.clearLogCheckBox.setText(LaunchRes.getString("Checkbox.ClearLog"));
        this.singletonCheckBox.setText(LaunchRes.getString("Checkbox.Singleton"));
        this.singleAppCheckBox.setText(LaunchRes.getString("Checkbox.SingleApp"));
        this.authorLabel.setText(LaunchRes.getString("Label.Author"));
        this.keywordLabel.setText(LaunchRes.getString("Label.Keywords"));
        this.levelLabel.setText(LaunchRes.getString("Label.Level"));
        this.languagesLabel.setText(LaunchRes.getString("Label.Languages"));
        this.securityTitle.setTitle(LaunchRes.getString("Label.Security"));
        this.editorEnabledCheckBox.setText(LaunchRes.getString("Checkbox.EditorEnabled"));
        this.encryptCheckBox.setText(LaunchRes.getString("Checkbox.Encrypted"));
        this.passwordLabel.setText(LaunchRes.getString("Label.Password"));
        this.onLoadCheckBox.setText(LaunchRes.getString("Checkbox.PWLoad"));
        this.titleLabel.setText(LaunchRes.getString("Label.Title"));
        this.hideRootCheckBox.setText(LaunchRes.getString("Checkbox.HideRoot"));
        this.previewItem.setText(LaunchRes.getString("Menu.File.Preview"));
        this.encryptionToolItem.setText(LaunchRes.getString("MenuItem.EncryptionTool"));
        this.newItem.setText(LaunchRes.getString("Menu.File.New"));
        this.importItem.setText(LaunchRes.getString("Action.Import"));
        this.saveNodeItem.setText(LaunchRes.getString("Action.SaveNode"));
        this.saveNodeAsItem.setText(LaunchRes.getString("Action.SaveNodeAs"));
        this.saveAllItem.setText(LaunchRes.getString("Action.SaveAll"));
        this.openTabItem.setText(LaunchRes.getString("Action.OpenTab"));
        this.saveSetAsItem.setText(LaunchRes.getString("Action.SaveSetAs"));
        this.toolsMenu.setText(LaunchRes.getString("Menu.Tools"));
        this.newTabButton.setText(LaunchRes.getString("Action.New"));
        this.addButton.setText(LaunchRes.getString("Action.Add"));
        this.cutButton.setText(LaunchRes.getString("Action.Cut"));
        this.copyButton.setText(LaunchRes.getString("Action.Copy"));
        this.pasteButton.setText(LaunchRes.getString("Action.Paste"));
        this.moveUpButton.setText(LaunchRes.getString("Action.Up"));
        this.moveDownButton.setText(LaunchRes.getString("Action.Down"));
        this.showModelArgsButton.setText(LaunchRes.getString("Button.ModelArgs"));
        this.modelArgsDialog.setTitle(LaunchRes.getString("Dialog.ModelArgs.Title"));
        this.modelArgCloseButton.setText(LaunchRes.getString("Dialog.Button.Close"));
        this.modelArgClearButton.setText(LaunchRes.getString("Dialog.Button.Clear"));
        this.modelArgLabel.setText(LaunchRes.getString("Label.Args"));
        this.pathField.setToolTipText(LaunchRes.getString("Display.Path.Tooltip"));
        this.tabTitleField.setToolTipText(LaunchRes.getString("Display.Tab.Title.Tooltip"));
        this.displaySpinner.setToolTipText(LaunchRes.getString("Display.Tab.Number.Tooltip"));
        this.openDisplayChooserButton.setToolTipText(LaunchRes.getString("Button.OpenDisplay.Tooltip"));
        this.showModelArgsButton.setToolTipText(LaunchRes.getString("Button.ModelArgs.Tooltip"));
        this.labels.clear();
        this.labels.add(this.nameLabel);
        this.labels.add(this.tooltipLabel);
        this.labels.add(this.displayLabel);
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        Font font = this.nameLabel.getFont();
        int n = 0;
        for (JLabel iterator : this.labels) {
            Rectangle2D rectangle2D2 = font.getStringBounds(String.valueOf(iterator.getText()) + " ", fontRenderContext);
            n = Math.max(n, (int)rectangle2D2.getWidth() + 1);
        }
        Object object = new Dimension(n, 20);
        for (JLabel jLabel : this.labels) {
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            jLabel.setPreferredSize((Dimension)object);
            jLabel.setHorizontalAlignment(11);
        }
        this.labels.clear();
        this.labels.add(this.jarLabel);
        this.labels.add(this.classLabel);
        this.labels.add(this.argLabel);
        n = 0;
        for (JLabel jLabel : this.labels) {
            rectangle2D = font.getStringBounds(String.valueOf(jLabel.getText()) + " ", fontRenderContext);
            n = Math.max(n, (int)rectangle2D.getWidth() + 1);
        }
        object = new Dimension(n, 20);
        for (JLabel jLabel : this.labels) {
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            jLabel.setPreferredSize((Dimension)object);
            jLabel.setHorizontalAlignment(11);
        }
        this.labels.clear();
        this.labels.add(this.authorLabel);
        this.labels.add(this.keywordLabel);
        this.labels.add(this.levelLabel);
        this.labels.add(this.languagesLabel);
        n = 0;
        for (JLabel jLabel : this.labels) {
            rectangle2D = font.getStringBounds(String.valueOf(jLabel.getText()) + " ", fontRenderContext);
            n = Math.max(n, (int)rectangle2D.getWidth() + 1);
        }
        object = new Dimension(n, 20);
        for (JLabel jLabel : this.labels) {
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            jLabel.setPreferredSize((Dimension)object);
            jLabel.setHorizontalAlignment(11);
        }
    }

    @Override
    protected void refreshGUI() {
        LaunchPanel launchPanel;
        boolean bl;
        Object object;
        Object object2;
        int n;
        boolean bl2;
        LaunchNode launchNode;
        if (this.previousNode != null) {
            launchNode = this.previousNode;
            this.previousNode = null;
            this.refreshNode(launchNode);
        }
        if (this.newNodeSelected) {
            this.argSpinner.setValue(new Integer(0));
            this.displaySpinner.setValue(new Integer(0));
            this.newNodeSelected = false;
        }
        boolean bl3 = bl2 = (launchNode = this.getRootNode()) == null || launchNode.enabled;
        if (!bl2) {
            this.editorTabs.setSelectedIndex(0);
        }
        this.titleField.setText(this.title);
        this.titleField.setBackground(Color.white);
        super.refreshGUI();
        String string = this.frame.getTitle();
        if (this.title != null) {
            string = !this.changedFiles.isEmpty() ? String.valueOf(string) + " [" + this.tabSetName + "*]" : String.valueOf(string) + " [" + this.tabSetName + "]";
        } else if (!this.changedFiles.isEmpty()) {
            if (this.tabbedPane.getTabCount() == 0) {
                this.changedFiles.clear();
            } else {
                string = String.valueOf(string) + "*";
            }
        }
        this.frame.setTitle(string);
        LaunchNode launchNode2 = this.getSelectedNode();
        if (launchNode2 != null) {
            boolean bl4;
            Resource resource;
            Object object3;
            int n2 = 0;
            while (n2 < this.tabbedPane.getTabCount()) {
                launchNode = this.getTab(n2).getRootNode();
                this.tabbedPane.setTitleAt(n2, launchNode.toString());
                ++n2;
            }
            this.hiddenCheckBox.setSelected(launchNode2.isHiddenInLauncher());
            n2 = launchNode2.getParent() != null && ((LaunchNode)launchNode2.getParent()).isHiddenInLauncher() ? 1 : 0;
            this.hiddenCheckBox.setEnabled(n2 == 0 && bl2);
            this.nameField.setText(launchNode2.toString());
            this.nameField.setBackground(Color.white);
            this.tooltipField.setText(launchNode2.tooltip);
            this.tooltipField.setBackground(Color.white);
            this.descriptionPane.setText(launchNode2.description);
            this.descriptionPane.setBackground(Color.white);
            n = (Integer)this.displaySpinner.getValue();
            object2 = launchNode2.getDisplayTab(n);
            object = object2 != null ? ((LaunchNode.DisplayTab)object2).path : null;
            boolean bl5 = object != null && ((LaunchNode.DisplayTab)object2).url == null && ((LaunchNode.DisplayTab)object2).modelClass == null;
            this.pathField.setText((String)object);
            this.pathField.setBackground(bl5 ? RED : Color.white);
            this.displaySpinnerModel.setMaximum(new Integer(launchNode2.getDisplayTabCount()));
            this.displaySpinner.setVisible(launchNode2.getDisplayTab(0) != null);
            bl = object2 != null && ((LaunchNode.DisplayTab)object2).path != null && !((LaunchNode.DisplayTab)object2).path.toLowerCase().endsWith("pdf");
            this.tabTitleLabel.setVisible(bl);
            this.tabTitleField.setVisible(bl);
            this.tabTitleField.setText(object2 != null ? ((LaunchNode.DisplayTab)object2).title : null);
            this.tabTitleField.setBackground(Color.white);
            this.displayBar.remove(this.showModelArgsButton);
            if (object2 != null && (((LaunchNode.DisplayTab)object2).url != null && !((LaunchNode.DisplayTab)object2).url.getPath().toLowerCase().endsWith("pdf") || ((LaunchNode.DisplayTab)object2).getModelScroller() != null)) {
                if (((LaunchNode.DisplayTab)object2).url != null) {
                    this.displaySplitPane.setTopComponent(this.htmlScroller);
                    if (this.htmlPane.getPage() != ((LaunchNode.DisplayTab)object2).url) {
                        try {
                            if (((LaunchNode.DisplayTab)object2).url.getContent() != null) {
                                object3 = ((LaunchNode.DisplayTab)object2).url;
                                Runnable runnable = new Runnable((URL)object3){
                                    private final /* synthetic */ URL val$url;
                                    {
                                        this.val$url = uRL;
                                    }

                                    @Override
                                    public void run() {
                                        try {
                                            LaunchBuilder.this.htmlPane.setPage(this.val$url);
                                        }
                                        catch (IOException iOException) {
                                            OSPLog.fine(String.valueOf(LaunchRes.getString("Log.Message.BadURL")) + " " + this.val$url);
                                        }
                                    }
                                };
                                SwingUtilities.invokeLater(runnable);
                            }
                        }
                        catch (IOException iOException) {
                            this.htmlPane.setText(null);
                        }
                    }
                } else if (((LaunchNode.DisplayTab)object2).getModelScroller() != null) {
                    object3 = ((LaunchNode.DisplayTab)object2).getModelScroller();
                    ((JComponent)object3).setBorder(this.displayTitle);
                    this.displaySplitPane.setTopComponent((Component)object3);
                    this.displayBar.add(this.showModelArgsButton);
                    n = (Integer)this.modelArgSpinner.getValue();
                    if (((LaunchNode.DisplayTab)object2).modelArgs.length > n) {
                        this.modelArgField.setText(((LaunchNode.DisplayTab)object2).modelArgs[n]);
                    } else {
                        this.modelArgField.setText("");
                    }
                    boolean bl6 = this.modelArgField.getText().endsWith(".xml");
                    resource = null;
                    if (bl6) {
                        resource = ResourceLoader.getResource(this.modelArgField.getText());
                        this.modelArgField.setBackground(resource == null ? RED : Color.white);
                    } else {
                        this.modelArgField.setBackground(Color.white);
                    }
                }
            } else if (n == 0 && launchNode2.getLaunchModelScroller() != null) {
                object3 = launchNode2.getLaunchModelScroller();
                ((JComponent)object3).setBorder(this.displayTitle);
                this.displaySplitPane.setTopComponent((Component)object3);
            } else {
                this.displaySplitPane.setTopComponent(this.htmlScroller);
                this.htmlPane.setContentType("text");
                this.htmlPane.setText(null);
            }
            this.displayBar.validate();
            object3 = launchNode2.getClassPath();
            if (!((String)object3).equals(this.previousClassPath)) {
                boolean bl7 = this.getClassChooser().setPath((String)object3);
                this.searchJarAction.setEnabled(bl7);
                this.searchJarForModelAction.setEnabled(bl7);
            }
            this.previousClassPath = launchNode2.getClassPath();
            this.jarField.setText(launchNode2.classPath);
            this.jarField.setBackground(launchNode2.classPath != null && !this.getClassChooser().isLoaded(launchNode2.classPath) ? RED : Color.white);
            this.classField.setText(launchNode2.launchClassName);
            this.classField.setBackground(launchNode2.getLaunchClass() == null && launchNode2.launchClassName != null ? RED : Color.white);
            n = (Integer)this.argSpinner.getValue();
            if (launchNode2.args.length > n) {
                this.argField.setText(launchNode2.args[n]);
            } else {
                this.argField.setText("");
            }
            boolean bl8 = this.argField.getText().endsWith(".xml");
            resource = null;
            if (bl8) {
                resource = ResourceLoader.getResource(this.argField.getText());
                this.argField.setBackground(resource == null ? RED : Color.white);
            } else {
                this.argField.setBackground(Color.white);
            }
            LaunchNode launchNode3 = (LaunchNode)launchNode2.getParent();
            this.singletonCheckBox.setEnabled(launchNode3 == null || !launchNode3.isSingleton());
            this.singletonCheckBox.setSelected(launchNode2.isSingleton());
            this.singleVMCheckBox.setSelected(launchNode2.isSingleVM());
            if (launchNode2.isSingleVM()) {
                this.showLogCheckBox.setEnabled(launchNode3 == null || !launchNode3.isShowLog());
                this.showLogCheckBox.setSelected(launchNode2.isShowLog());
                this.clearLogCheckBox.setEnabled(launchNode3 == null || !launchNode3.isClearLog());
                this.clearLogCheckBox.setSelected(launchNode2.isClearLog());
                this.singleAppCheckBox.setEnabled(true);
                this.singleAppCheckBox.setSelected(launchNode2.isSingleApp());
            } else {
                this.showLogCheckBox.setEnabled(false);
                this.showLogCheckBox.setSelected(false);
                this.clearLogCheckBox.setEnabled(false);
                this.clearLogCheckBox.setSelected(false);
                this.singleAppCheckBox.setEnabled(false);
                this.singleAppCheckBox.setSelected(false);
            }
            this.levelDropDown.setVisible(launchNode2.isShowLog());
            this.clearLogCheckBox.setVisible(launchNode2.isShowLog());
            if (this.levelDropDown.isVisible()) {
                bl4 = launchNode3 == null || !launchNode3.isShowLog();
                this.levelDropDown.setEnabled(false);
                this.levelDropDown.removeAllItems();
                int n3 = 0;
                while (n3 < OSPLog.levels.length) {
                    if (bl4 || OSPLog.levels[n3].intValue() <= launchNode3.getLogLevel().intValue()) {
                        this.levelDropDown.addItem(OSPLog.levels[n3]);
                    }
                    ++n3;
                }
                this.levelDropDown.setSelectedItem(launchNode2.getLogLevel());
                this.levelDropDown.setEnabled(true);
            }
            this.authorField.setText(launchNode2.getAuthor());
            this.authorField.setBackground(Color.white);
            this.keywordField.setText(launchNode2.keywords);
            this.keywordField.setBackground(Color.white);
            this.levelField.setText(launchNode2.level);
            this.levelField.setBackground(Color.white);
            this.languagesField.setText(launchNode2.languages);
            this.languagesField.setBackground(Color.white);
            this.commentPane.setText(launchNode2.comment);
            this.commentPane.setBackground(Color.white);
            bl4 = this.password != null && !this.password.equals("");
            this.onLoadCheckBox.setEnabled(bl4);
            this.onLoadCheckBox.setSelected(bl4 && this.pwRequiredToLoad);
            this.encryptCheckBox.setSelected(this.password != null);
            this.passwordEditor.setEnabled(this.encryptCheckBox.isSelected());
            this.passwordLabel.setEnabled(this.encryptCheckBox.isSelected());
            this.passwordEditor.setText(this.password);
            this.passwordEditor.setBackground(Color.white);
        }
        this.fileMenu.removeAll();
        this.fileMenu.add(this.newItem);
        if (this.undoManager.canReload()) {
            this.fileMenu.add(this.backItem);
        }
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.openItem);
        if (this.openFromJarMenu != null) {
            this.fileMenu.add(this.openFromJarMenu);
        }
        if ((launchPanel = this.getSelectedTab()) != null && !launchPanel.getRootNode().enabled) {
            this.fileMenu.add(this.passwordItem);
        }
        n = this.jarBasePath != null && !this.jarBasePath.equals("") ? 1 : 0;
        this.saveAllItem.setEnabled(n == 0 && this.isTabSetWritable());
        if (launchPanel != null) {
            if (bl2) {
                this.fileMenu.add(this.importItem);
            }
            this.fileMenu.addSeparator();
            if (bl2) {
                this.fileMenu.add(this.closeTabItem);
            }
            this.fileMenu.add(this.closeAllItem);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.previewItem);
            if (bl2) {
                this.fileMenu.addSeparator();
                this.fileMenu.add(this.saveAllItem);
                this.fileMenu.add(this.saveSetAsItem);
                if (OSPRuntime.getLaunchJarName() != null) {
                    this.fileMenu.addSeparator();
                    this.fileMenu.add(this.saveJarItem);
                }
            }
            object2 = new JMenu(DisplayRes.getString("DrawingFrame.Print_menu_title"));
            object = new JMenuItem(DisplayRes.getString("DrawingFrame.PrintFrame_menu_item"));
            JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.SaveFrameAsEPS_menu_item"));
            ((JMenu)object2).add((JMenuItem)object);
            ((JMenu)object2).add(jMenuItem);
            this.fileMenu.add((JMenuItem)object2);
            ((AbstractButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PrintUtils.printComponent(LaunchBuilder.this.frame);
                }
            });
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        PrintUtils.saveComponentAsEPS(LaunchBuilder.this.frame);
                    }
                    catch (IOException iOException) {}
                }
            });
            this.frame.getContentPane().add((Component)this.toolbar, "North");
            launchPanel.dataPanel.add((Component)this.editorTabs, "Center");
            if (this.getRootNode().getChildCount() == 0) {
                this.getRootNode().hiddenWhenRoot = false;
                this.hideRootCheckBox.setEnabled(false);
            } else {
                this.hideRootCheckBox.setEnabled(launchNode2 == null || !launchNode2.isButtonView());
            }
            if (!bl2) {
                this.hideRootCheckBox.setEnabled(false);
            }
            bl = !this.getRootNode().hiddenWhenRoot;
            this.hideRootCheckBox.setSelected(!bl);
            launchPanel.tree.setRootVisible(bl);
            if (this.getSelectedNode() == null && !bl) {
                launchPanel.setSelectedNode((LaunchNode)this.getRootNode().getChildAt(0));
            }
            this.buttonViewCheckBox.setSelected(launchNode2 != null && launchNode2.isButtonView());
            this.buttonViewCheckBox.setEnabled(bl && bl2);
            this.editorEnabledCheckBox.setSelected(this.editorEnabled);
            this.editorTabs.setEnabled(bl2);
            this.nameField.setEnabled(bl2);
            this.tooltipField.setEnabled(bl2);
            this.descriptionPane.setEnabled(bl2);
            this.pathField.setEnabled(bl2);
            this.titleField.setEnabled(bl2);
            this.displaySpinner.setEnabled(bl2);
            this.openDisplayChooserButton.setEnabled(bl2);
            this.titleLabel.setEnabled(bl2);
            this.nameLabel.setEnabled(bl2);
            this.tooltipLabel.setEnabled(bl2);
            this.displayLabel.setEnabled(bl2);
            this.pathLabel.setEnabled(bl2);
            this.newTabButton.setEnabled(bl2);
            this.addButton.setEnabled(bl2);
            this.cutButton.setEnabled(bl2);
            this.copyButton.setEnabled(bl2);
            this.pasteButton.setEnabled(bl2);
            this.moveUpButton.setEnabled(bl2);
            this.moveDownButton.setEnabled(bl2);
            this.tabTitleField.setEnabled(bl2);
            this.htmlScroller.setEnabled(bl2);
            this.showModelArgsButton.setEnabled(bl2);
            this.displayTitle.setTitleColor(bl2 ? enabledColor : disabledColor);
            this.descriptionTitle.setTitleColor(bl2 ? enabledColor : disabledColor);
        } else {
            this.frame.getContentPane().remove(this.toolbar);
        }
        if (this.exitItem != null) {
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.exitItem);
        }
        int n4 = 0;
        while (n4 < this.tabbedPane.getTabCount()) {
            launchNode = this.getTab(n4).getRootNode();
            if (launchNode.getFileName() != null) {
                this.tabbedPane.setIconAt(n4, this.getFileIcon(launchNode));
                this.tabbedPane.setToolTipTextAt(n4, String.valueOf(LaunchRes.getString("ToolTip.FileName")) + " \"" + launchNode.getFileName() + "\"");
            } else {
                this.tabbedPane.setIconAt(n4, null);
                this.tabbedPane.setToolTipTextAt(n4, null);
            }
            ++n4;
        }
    }

    @Override
    protected void createGUI(boolean bl) {
        wInit = 600;
        hInit = 540;
        this.labels = new ArrayList();
        super.createGUI(bl);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                OSPRuntime.setAuthorMode(true);
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                OSPRuntime.setAuthorMode(true);
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                if (LaunchBuilder.this.getSelectedNode() != null) {
                    LaunchBuilder.this.htmlPane.setContentType("text");
                    LaunchBuilder.this.htmlPane.setText(null);
                }
                LaunchBuilder.this.refreshGUI();
            }
        });
        this.tabbedPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                LaunchBuilder.this.refreshGUI();
            }
        });
        String string = "/org/opensourcephysics/resources/tools/images/whitefile.gif";
        whiteFileIcon = LaunchBuilder.loadIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/ghostfile.gif";
        ghostFileIcon = LaunchBuilder.loadIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/redfile.gif";
        redFileIcon = LaunchBuilder.loadIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/yellowfile.gif";
        yellowFileIcon = LaunchBuilder.loadIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/whitefolder.gif";
        whiteFolderIcon = LaunchBuilder.loadIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/redfolder.gif";
        redFolderIcon = LaunchBuilder.loadIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/greenfolder.gif";
        greenFolderIcon = LaunchBuilder.loadIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/yellowfolder.gif";
        yellowFolderIcon = LaunchBuilder.loadIcon(string);
        this.createActions();
        this.titleField = new JTextField();
        this.titleField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    String string = LaunchBuilder.this.titleField.getText();
                    if (string.equals("")) {
                        string = null;
                    }
                    if (string != LaunchBuilder.this.title) {
                        LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                    }
                    LaunchBuilder.this.title = string;
                    LaunchBuilder.this.refreshGUI();
                } else {
                    LaunchBuilder.this.titleField.setBackground(Color.yellow);
                }
            }
        });
        this.titleField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string = LaunchBuilder.this.titleField.getText();
                if (string.equals("")) {
                    string = null;
                }
                if (string != LaunchBuilder.this.title) {
                    LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                }
                LaunchBuilder.this.title = string;
                LaunchBuilder.this.refreshGUI();
            }
        });
        this.nameField = new JTextField();
        this.nameField.addKeyListener(this.keyListener);
        this.nameField.addFocusListener(this.focusListener);
        this.tooltipField = new JTextField();
        this.tooltipField.addKeyListener(this.keyListener);
        this.tooltipField.addFocusListener(this.focusListener);
        this.displayTitle = BorderFactory.createTitledBorder(LaunchRes.getString("Label.DisplayPane"));
        this.classField = new JTextField();
        this.classField.addKeyListener(this.keyListener);
        this.classField.addFocusListener(this.focusListener);
        this.argField = new JTextField();
        this.argField.addKeyListener(this.keyListener);
        this.argField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                XMLControlElement xMLControlElement;
                if (OSPRuntime.isPopupTrigger(mouseEvent) && (xMLControlElement = new XMLControlElement()).read(LaunchBuilder.this.argField.getText()) != null) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem(LaunchRes.getString("MenuItem.EncryptionTool"));
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            EncryptionTool encryptionTool = EncryptionTool.getTool();
                            encryptionTool.open((this).LaunchBuilder.this.argField.getText());
                            encryptionTool.setVisible(true);
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    jPopupMenu.show(LaunchBuilder.this.argField, mouseEvent.getX(), mouseEvent.getY() + 8);
                }
            }
        });
        this.argField.addFocusListener(this.focusListener);
        this.modelArgField = new JTextField();
        this.modelArgField.addKeyListener(this.keyListener);
        this.modelArgField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                XMLControlElement xMLControlElement;
                if (OSPRuntime.isPopupTrigger(mouseEvent) && (xMLControlElement = new XMLControlElement()).read(LaunchBuilder.this.modelArgField.getText()) != null) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem(LaunchRes.getString("MenuItem.EncryptionTool"));
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            EncryptionTool encryptionTool = EncryptionTool.getTool();
                            encryptionTool.open((this).LaunchBuilder.this.modelArgField.getText());
                            encryptionTool.setVisible(true);
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    jPopupMenu.show(LaunchBuilder.this.modelArgField, mouseEvent.getX(), mouseEvent.getY() + 8);
                }
            }
        });
        this.modelArgField.addFocusListener(this.focusListener);
        this.jarField = new JTextField();
        this.jarField.addKeyListener(this.keyListener);
        this.jarField.addFocusListener(this.focusListener);
        this.pathField = new JTextField();
        this.pathField.addKeyListener(this.keyListener);
        this.pathField.addFocusListener(this.focusListener);
        this.tabTitleField = new JTextField();
        this.tabTitleField.addKeyListener(this.keyListener);
        this.tabTitleField.addFocusListener(this.focusListener);
        this.keywordField = new JTextField();
        this.keywordField.addKeyListener(this.keyListener);
        this.keywordField.addFocusListener(this.focusListener);
        this.authorField = new JTextField();
        this.authorField.addKeyListener(this.keyListener);
        this.authorField.addFocusListener(this.focusListener);
        this.levelField = new JTextField();
        this.levelField.addKeyListener(this.keyListener);
        this.levelField.addFocusListener(this.focusListener);
        this.languagesField = new JTextField();
        this.languagesField.addKeyListener(this.keyListener);
        this.languagesField.addFocusListener(this.focusListener);
        this.commentPane = new JTextPane(){

            @Override
            public void paintComponent(Graphics graphics) {
                if (OSPRuntime.antiAliasText.booleanValue()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    RenderingHints renderingHints = graphics2D.getRenderingHints();
                    renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                super.paintComponent(graphics);
            }
        };
        this.commentPane.addKeyListener(this.keyListener);
        this.commentPane.addFocusListener(this.focusListener);
        this.commentScroller = new JScrollPane(this.commentPane);
        this.commentTitle = BorderFactory.createTitledBorder(LaunchRes.getString("Label.Comments"));
        this.commentScroller.setBorder(this.commentTitle);
        this.descriptionPane = new JTextPane();
        this.descriptionPane.addKeyListener(this.keyListener);
        this.descriptionPane.addFocusListener(this.focusListener);
        this.descriptionScroller = new JScrollPane(this.descriptionPane);
        this.descriptionTitle = BorderFactory.createTitledBorder(LaunchRes.getString("Label.Description"));
        this.descriptionScroller.setBorder(this.descriptionTitle);
        this.displaySplitPane = new JSplitPane(0){

            @Override
            public void setDividerLocation(int n) {
                super.setDividerLocation(n);
                double d = this.getDividerLocation();
                this.setName("" + (d /= (double)(this.getHeight() - this.getDividerSize())));
            }

            @Override
            public void setTopComponent(Component component) {
                if (component == this.getTopComponent()) {
                    return;
                }
                int n = this.getLastDividerLocation();
                String string = this.getName();
                super.setTopComponent(component);
                if (string != null) {
                    double d = Double.parseDouble(string);
                    d = Math.max(0.0, d);
                    d = Math.min(1.0, d);
                    this.setDividerLocation(d);
                    this.setLastDividerLocation(n);
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            JViewport jViewport = (this).LaunchBuilder.this.descriptionScroller.getViewport();
                            jViewport.setViewPosition(new Point(0, 0));
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
        };
        this.displaySplitPane.setBottomComponent(this.descriptionScroller);
        this.displaySplitPane.setOneTouchExpandable(true);
        this.displaySplitPane.setResizeWeight(1.0);
        this.htmlPane = new JTextPane(){

            @Override
            public void paintComponent(Graphics graphics) {
                if (OSPRuntime.antiAliasText.booleanValue()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    RenderingHints renderingHints = graphics2D.getRenderingHints();
                    renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                super.paintComponent(graphics);
            }
        };
        this.htmlPane.setEditable(false);
        this.htmlScroller = new JScrollPane(this.htmlPane);
        this.htmlScroller.setBorder(this.displayTitle);
        this.displaySplitPane.setTopComponent(this.htmlScroller);
        this.hiddenCheckBox = new JCheckBox();
        this.hiddenCheckBox.addActionListener(this.changeAction);
        this.hiddenCheckBox.setContentAreaFilled(false);
        this.hiddenCheckBox.setAlignmentX(0.0f);
        this.buttonViewCheckBox = new JCheckBox();
        this.buttonViewCheckBox.addActionListener(this.changeAction);
        this.buttonViewCheckBox.setContentAreaFilled(false);
        this.buttonViewCheckBox.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.nameLabel = new JLabel();
        this.labels.add(this.nameLabel);
        jToolBar.add(this.nameLabel);
        jToolBar.add(this.nameField);
        jToolBar.add(this.hiddenCheckBox);
        jPanel.add((Component)jToolBar, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setFloatable(false);
        this.tooltipLabel = new JLabel();
        jToolBar2.add(this.tooltipLabel);
        jToolBar2.add(this.tooltipField);
        jPanel2.add((Component)jToolBar2, "North");
        this.urlPanel = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.urlPanel, "Center");
        this.displayBar = new JToolBar();
        this.displayBar.setFloatable(false);
        this.displayLabel = new JLabel();
        this.pathLabel = new JLabel();
        this.pathLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.tabTitleLabel = new JLabel();
        this.tabTitleLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.displaySpinnerModel = new SpinnerNumberModel(0, 0, 1, 1);
        this.displaySpinner = new JSpinner(this.displaySpinnerModel);
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this.displaySpinner);
        this.displaySpinner.setEditor(numberEditor);
        this.displaySpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (LaunchBuilder.this.pathField.getBackground() == Color.yellow) {
                    LaunchBuilder.this.refreshSelectedNode();
                } else {
                    LaunchBuilder.this.refreshGUI();
                }
            }
        });
        this.displayBar.add(this.displayLabel);
        this.displayBar.add(this.displaySpinner);
        this.displayBar.add(this.pathLabel);
        this.displayBar.add(this.pathField);
        this.openDisplayChooserButton = new JButton(this.openIcon);
        this.openDisplayChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(LaunchBuilder.this.openURLAction);
                jPopupMenu.add(LaunchBuilder.this.openPDFAction);
                jPopupMenu.add(LaunchBuilder.this.searchJarForModelAction);
                jPopupMenu.show(LaunchBuilder.this.openDisplayChooserButton, 0, LaunchBuilder.this.openDisplayChooserButton.getHeight());
            }
        });
        this.displayBar.add(this.openDisplayChooserButton);
        this.modelArgsDialog = new JDialog((Frame)this.frame, true);
        JToolBar jToolBar3 = new JToolBar();
        jToolBar3.setFloatable(false);
        jToolBar3.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 10));
        this.modelArgLabel = new JLabel();
        this.modelArgLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0, 0, maxArgs - 1, 1);
        this.modelArgSpinner = new JSpinner(spinnerNumberModel);
        numberEditor = new JSpinner.NumberEditor(this.modelArgSpinner);
        this.modelArgSpinner.setEditor(numberEditor);
        this.modelArgSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (LaunchBuilder.this.argField.getBackground() == Color.yellow) {
                    LaunchBuilder.this.refreshSelectedNode();
                } else {
                    LaunchBuilder.this.refreshGUI();
                }
            }
        });
        jToolBar3.add(this.modelArgLabel);
        jToolBar3.add(this.modelArgSpinner);
        jToolBar3.add(this.modelArgField);
        jToolBar3.add(this.openModelArgAction);
        this.modelArgCloseButton = new JButton(LaunchRes.getString("Dialog.Button.Close"));
        this.modelArgCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LaunchBuilder.this.modelArgsDialog.setVisible(false);
            }
        });
        this.modelArgClearButton = new JButton(LaunchRes.getString("Dialog.Button.Clear"));
        this.modelArgClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = (Integer)LaunchBuilder.this.displaySpinner.getValue();
                LaunchNode launchNode = LaunchBuilder.this.getSelectedNode();
                LaunchNode.DisplayTab displayTab = launchNode.getDisplayTab(n);
                if (displayTab != null) {
                    displayTab.setModelArgs(new String[0]);
                    LaunchBuilder.this.refreshGUI();
                }
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.modelArgClearButton);
        jPanel3.add(this.modelArgCloseButton);
        this.modelArgsDialog.add((Component)jToolBar3, "Center");
        this.modelArgsDialog.add((Component)jPanel3, "South");
        this.modelArgsDialog.pack();
        Dimension dimension = this.modelArgsDialog.getSize();
        int n = Math.max(dimension.width, 240);
        this.modelArgsDialog.setSize(n, dimension.height);
        this.showModelArgsButton = new JButton();
        this.showModelArgsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Point point = new Frame().getLocation();
                if (LaunchBuilder.this.modelArgsDialog.getLocation().x == point.x) {
                    LaunchBuilder.this.modelArgsDialog.setLocationRelativeTo(LaunchBuilder.this.showModelArgsButton);
                }
                LaunchBuilder.this.modelArgsDialog.setVisible(true);
            }
        });
        this.displayBar.add(this.tabTitleLabel);
        this.displayBar.add(this.tabTitleField);
        this.urlPanel.add((Component)this.displayBar, "North");
        this.urlPanel.add((Component)this.displaySplitPane, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JToolBar jToolBar4 = new JToolBar();
        jToolBar4.setFloatable(false);
        this.jarLabel = new JLabel();
        this.labels.add(this.jarLabel);
        jToolBar4.add(this.jarLabel);
        jToolBar4.add(this.jarField);
        jToolBar4.add(this.openJarAction);
        jPanel4.add((Component)jToolBar4, "North");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel5, "Center");
        JToolBar jToolBar5 = new JToolBar();
        jToolBar5.setFloatable(false);
        this.classLabel = new JLabel();
        this.labels.add(this.classLabel);
        jToolBar5.add(this.classLabel);
        jToolBar5.add(this.classField);
        jToolBar5.add(this.searchJarAction);
        jPanel5.add((Component)jToolBar5, "North");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel6, "Center");
        JToolBar jToolBar6 = new JToolBar();
        jToolBar6.setFloatable(false);
        this.argLabel = new JLabel();
        this.labels.add(this.argLabel);
        jToolBar6.add(this.argLabel);
        spinnerNumberModel = new SpinnerNumberModel(0, 0, maxArgs - 1, 1);
        this.argSpinner = new JSpinner(spinnerNumberModel);
        numberEditor = new JSpinner.NumberEditor(this.argSpinner);
        this.argSpinner.setEditor(numberEditor);
        this.argSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (LaunchBuilder.this.argField.getBackground() == Color.yellow) {
                    LaunchBuilder.this.refreshSelectedNode();
                } else {
                    LaunchBuilder.this.refreshGUI();
                }
            }
        });
        jToolBar6.add(this.argSpinner);
        jToolBar6.add(this.argField);
        jToolBar6.add(this.openArgAction);
        jPanel6.add((Component)jToolBar6, "North");
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jPanel7, "Center");
        JToolBar jToolBar7 = new JToolBar();
        jToolBar7.setFloatable(false);
        this.singleVMCheckBox = new JCheckBox();
        this.singleVMCheckBox.addActionListener(this.changeAction);
        this.singleVMCheckBox.setContentAreaFilled(false);
        this.singleVMCheckBox.setAlignmentX(0.0f);
        this.showLogCheckBox = new JCheckBox();
        this.showLogCheckBox.addActionListener(this.changeAction);
        this.showLogCheckBox.setContentAreaFilled(false);
        this.showLogCheckBox.setAlignmentX(0.0f);
        this.clearLogCheckBox = new JCheckBox();
        this.clearLogCheckBox.addActionListener(this.changeAction);
        this.clearLogCheckBox.setContentAreaFilled(false);
        this.clearLogCheckBox.setAlignmentX(0.0f);
        this.singletonCheckBox = new JCheckBox();
        this.singletonCheckBox.addActionListener(this.changeAction);
        this.singletonCheckBox.setContentAreaFilled(false);
        this.singletonCheckBox.setAlignmentX(0.0f);
        this.singleAppCheckBox = new JCheckBox();
        this.singleAppCheckBox.addActionListener(this.changeAction);
        this.singleAppCheckBox.setContentAreaFilled(false);
        this.singleAppCheckBox.setAlignmentX(0.0f);
        this.levelDropDown = new JComboBox<Level>(OSPLog.levels);
        this.levelDropDown.setMaximumSize(this.levelDropDown.getMinimumSize());
        this.levelDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LaunchNode launchNode;
                if (LaunchBuilder.this.levelDropDown.isEnabled() && (launchNode = LaunchBuilder.this.getSelectedNode()) != null) {
                    launchNode.setLogLevel((Level)LaunchBuilder.this.levelDropDown.getSelectedItem());
                }
            }
        });
        Box box = Box.createVerticalBox();
        JToolBar jToolBar8 = new JToolBar();
        jToolBar8.setFloatable(false);
        jToolBar8.setAlignmentX(0.0f);
        jToolBar8.add(this.singletonCheckBox);
        jToolBar8.add(Box.createHorizontalGlue());
        box.add(jToolBar8);
        jToolBar8 = new JToolBar();
        jToolBar8.setFloatable(false);
        jToolBar8.setAlignmentX(0.0f);
        jToolBar8.add(this.singleVMCheckBox);
        jToolBar8.add(Box.createHorizontalGlue());
        box.add(jToolBar8);
        jToolBar8 = new JToolBar();
        jToolBar8.setFloatable(false);
        jToolBar8.setAlignmentX(0.0f);
        jToolBar8.add(this.singleAppCheckBox);
        jToolBar8.add(Box.createHorizontalGlue());
        box.add(jToolBar8);
        jToolBar8 = new JToolBar();
        jToolBar8.setFloatable(false);
        jToolBar8.add(this.showLogCheckBox);
        jToolBar8.add(Box.createHorizontalStrut(4));
        jToolBar8.add(this.levelDropDown);
        jToolBar8.add(Box.createHorizontalStrut(4));
        jToolBar8.add(this.clearLogCheckBox);
        jToolBar8.add(Box.createHorizontalGlue());
        jToolBar8.setAlignmentX(0.0f);
        box.add(jToolBar8);
        this.optionsTitle = BorderFactory.createTitledBorder(LaunchRes.getString("Label.Options"));
        Border border = BorderFactory.createLoweredBevelBorder();
        jToolBar7.setBorder(BorderFactory.createCompoundBorder(border, this.optionsTitle));
        jToolBar7.add(box);
        jPanel7.add((Component)jToolBar7, "North");
        JPanel jPanel8 = new JPanel(new BorderLayout());
        JToolBar jToolBar9 = new JToolBar();
        jPanel8.add((Component)jToolBar9, "North");
        jToolBar9.setFloatable(false);
        this.authorLabel = new JLabel();
        this.labels.add(this.authorLabel);
        jToolBar9.add(this.authorLabel);
        jToolBar9.add(this.authorField);
        JPanel jPanel9 = new JPanel(new BorderLayout());
        jPanel8.add((Component)jPanel9, "Center");
        JToolBar jToolBar10 = new JToolBar();
        jPanel9.add((Component)jToolBar10, "North");
        jToolBar10.setFloatable(false);
        this.keywordLabel = new JLabel();
        this.labels.add(this.keywordLabel);
        jToolBar10.add(this.keywordLabel);
        jToolBar10.add(this.keywordField);
        JPanel jPanel10 = new JPanel(new BorderLayout());
        jPanel9.add((Component)jPanel10, "Center");
        JToolBar jToolBar11 = new JToolBar();
        jPanel10.add((Component)jToolBar11, "North");
        jToolBar11.setFloatable(false);
        this.levelLabel = new JLabel();
        this.labels.add(this.levelLabel);
        jToolBar11.add(this.levelLabel);
        jToolBar11.add(this.levelField);
        JPanel jPanel11 = new JPanel(new BorderLayout());
        jPanel10.add((Component)jPanel11, "Center");
        JToolBar jToolBar12 = new JToolBar();
        jPanel11.add((Component)jToolBar12, "North");
        jToolBar12.setFloatable(false);
        this.languagesLabel = new JLabel();
        this.labels.add(this.languagesLabel);
        jToolBar12.add(this.languagesLabel);
        jToolBar12.add(this.languagesField);
        JPanel jPanel12 = new JPanel(new BorderLayout());
        jPanel11.add((Component)jPanel12, "Center");
        JToolBar jToolBar13 = new JToolBar();
        jToolBar13.setFloatable(false);
        jPanel12.add((Component)jToolBar13, "North");
        this.securityTitle = BorderFactory.createTitledBorder(LaunchRes.getString("Label.Security"));
        jToolBar13.setBorder(BorderFactory.createCompoundBorder(border, this.securityTitle));
        Box box2 = Box.createVerticalBox();
        jToolBar13.add(box2);
        jToolBar8 = new JToolBar();
        jToolBar8.setFloatable(false);
        jToolBar8.setAlignmentX(0.0f);
        this.editorEnabledCheckBox = new JCheckBox();
        this.editorEnabledCheckBox.addActionListener(this.changeAction);
        this.editorEnabledCheckBox.setContentAreaFilled(false);
        this.editorEnabledCheckBox.setAlignmentX(0.0f);
        jToolBar8.add(this.editorEnabledCheckBox);
        jToolBar8.add(Box.createHorizontalGlue());
        box2.add(jToolBar8);
        jToolBar8 = new JToolBar();
        jToolBar8.setFloatable(false);
        jToolBar8.setAlignmentX(0.0f);
        this.encryptCheckBox = new JCheckBox();
        this.encryptCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LaunchBuilder.this.encryptCheckBox.isSelected() && LaunchBuilder.this.password == null) {
                    LaunchBuilder.this.password = "";
                } else if (!LaunchBuilder.this.encryptCheckBox.isSelected()) {
                    LaunchBuilder.this.password = null;
                }
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeEncrypted"));
                if (LaunchBuilder.this.tabSetName != null) {
                    LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                }
                LaunchBuilder.this.refreshGUI();
            }
        });
        this.encryptCheckBox.setContentAreaFilled(false);
        jToolBar8.add(this.encryptCheckBox);
        jToolBar8.add(Box.createHorizontalGlue());
        box2.add(jToolBar8);
        jToolBar8 = new JToolBar();
        jToolBar8.setFloatable(false);
        jToolBar8.setAlignmentX(0.0f);
        this.passwordLabel = new JLabel();
        this.passwordLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        jToolBar8.add(this.passwordLabel);
        this.passwordEditor = new JTextField();
        this.passwordEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    String string = LaunchBuilder.this.passwordEditor.getText();
                    if (!(!string.equals("") || LaunchBuilder.this.encryptCheckBox.isSelected() && LaunchBuilder.this.encryptCheckBox.isEnabled())) {
                        string = null;
                    }
                    if (string != LaunchBuilder.this.password) {
                        LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                    }
                    LaunchBuilder.this.password = string;
                    LaunchBuilder.this.refreshGUI();
                } else {
                    LaunchBuilder.this.passwordEditor.setBackground(Color.yellow);
                }
            }
        });
        jToolBar8.add(this.passwordEditor);
        jToolBar8.add(Box.createHorizontalGlue());
        this.onLoadCheckBox = new JCheckBox();
        this.onLoadCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LaunchBuilder.this.pwRequiredToLoad = LaunchBuilder.this.onLoadCheckBox.isSelected();
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangePWRequirement"));
                if (LaunchBuilder.this.tabSetName != null) {
                    LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                }
                LaunchBuilder.this.refreshGUI();
            }
        });
        this.onLoadCheckBox.setContentAreaFilled(false);
        jToolBar8.add(this.onLoadCheckBox);
        box2.add(jToolBar8);
        jPanel12.add((Component)this.commentScroller, "Center");
        this.editorTabs = new JTabbedPane(1);
        this.editorTabs.addTab(LaunchRes.getString("Tab.Display"), jPanel);
        this.editorTabs.addTab(LaunchRes.getString("Tab.Launch"), jPanel4);
        this.editorTabs.addTab(LaunchRes.getString("Tab.Author"), jPanel8);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.toolbar.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.frame.getContentPane().add((Component)this.toolbar, "North");
        this.newTabButton = new JButton(this.newTabAction);
        this.toolbar.add(this.newTabButton);
        this.addButton = new JButton(this.addAction);
        this.toolbar.add(this.addButton);
        this.cutButton = new JButton(this.cutAction);
        this.toolbar.add(this.cutButton);
        this.copyButton = new JButton(this.copyAction);
        this.toolbar.add(this.copyButton);
        this.pasteButton = new JButton(this.pasteAction);
        this.toolbar.add(this.pasteButton);
        this.moveUpButton = new JButton(this.moveUpAction);
        this.toolbar.add(this.moveUpButton);
        this.moveDownButton = new JButton(this.moveDownAction);
        this.toolbar.add(this.moveDownButton);
        this.titleLabel = new JLabel(LaunchRes.getString("Label.Title"));
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        this.toolbar.add(this.titleLabel);
        this.toolbar.add(this.titleField);
        this.toolbar.add(this.buttonViewCheckBox);
        this.hideRootCheckBox = new JCheckBox();
        this.hideRootCheckBox.addActionListener(this.changeAction);
        this.hideRootCheckBox.setContentAreaFilled(false);
        this.toolbar.add(this.hideRootCheckBox);
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.newItem = new JMenuItem(this.newTabSetAction);
        this.newItem.setAccelerator(KeyStroke.getKeyStroke(78, n2));
        this.previewItem = new JMenuItem();
        this.previewItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = tabSetBasePath;
                LaunchBuilder.this.previewing = true;
                Launcher.LaunchSet launchSet = new Launcher.LaunchSet(LaunchBuilder.this, LaunchBuilder.this.tabSetName);
                XMLControlElement xMLControlElement = new XMLControlElement(launchSet);
                xMLControlElement.setValue("filename", LaunchBuilder.this.tabSetName);
                Launcher launcher = new Launcher(xMLControlElement.toXML());
                LaunchNode launchNode = LaunchBuilder.this.getSelectedNode();
                if (launchNode != null) {
                    launcher.setSelectedNode(launchNode.getPathString());
                }
                Point point = LaunchBuilder.this.frame.getLocation();
                launcher.frame.setLocation(point.x + 24, point.y + 24);
                launcher.frame.setVisible(true);
                launcher.frame.setDefaultCloseOperation(2);
                tabSetBasePath = string;
                LaunchBuilder.this.previewing = false;
                launcher.password = LaunchBuilder.this.password;
                launcher.previewing = true;
                launcher.spawner = LaunchBuilder.this;
                launcher.refreshGUI();
            }
        });
        this.importItem = new JMenuItem(this.importAction);
        this.saveJarItem = new JMenuItem(this.saveJarAction);
        this.saveNodeItem = new JMenuItem(this.saveAction);
        this.saveNodeAsItem = new JMenuItem(this.saveAsAction);
        this.saveAllItem = new JMenuItem(this.saveAllAction);
        this.openTabItem = new JMenuItem(this.openTabAction);
        this.saveAllItem.setAccelerator(KeyStroke.getKeyStroke(83, n2));
        this.saveSetAsItem = new JMenuItem(this.saveSetAsAction);
        this.toolsMenu = new JMenu();
        this.frame.getJMenuBar().add((Component)this.toolsMenu, 2);
        this.encryptionToolItem = new JMenuItem();
        this.toolsMenu.add(this.encryptionToolItem);
        this.encryptionToolItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EncryptionTool.getTool().setVisible(true);
            }
        });
        this.tabbedPane.removeMouseListener(this.tabListener);
        this.tabListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (LaunchBuilder.this.contentPane.getTopLevelAncestor() != LaunchBuilder.this.frame) {
                    return;
                }
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem(LaunchRes.getString("MenuItem.Close"));
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            LaunchBuilder.this.removeSelectedTab();
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    jPopupMenu.addSeparator();
                    jMenuItem = new JMenuItem(LaunchRes.getString("Menu.File.SaveAs"));
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            LaunchNode launchNode = LaunchBuilder.this.getSelectedTab().getRootNode();
                            if (LaunchBuilder.this.saveAs(launchNode) != null) {
                                int n = (this).LaunchBuilder.this.tabbedPane.getSelectedIndex();
                                (this).LaunchBuilder.this.tabbedPane.setTitleAt(n, launchNode.toString());
                            }
                            LaunchBuilder.this.refreshGUI();
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    final int n = LaunchBuilder.this.tabbedPane.getSelectedIndex();
                    if (n > 0 || n < LaunchBuilder.this.tabbedPane.getTabCount() - 1) {
                        jPopupMenu.addSeparator();
                    }
                    if (n < LaunchBuilder.this.tabbedPane.getTabCount() - 1) {
                        jMenuItem = new JMenuItem(LaunchRes.getString("Popup.MenuItem.MoveUp"));
                        jMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                LaunchPanel launchPanel = LaunchBuilder.this.getSelectedTab();
                                LaunchNode launchNode = launchPanel.getRootNode();
                                LaunchBuilder.super.removeSelectedTab();
                                (this).LaunchBuilder.this.tabbedPane.insertTab(LaunchBuilder.getDisplayName(launchNode.getFileName()), null, launchPanel, null, n + 1);
                                (this).LaunchBuilder.this.tabbedPane.setSelectedComponent(launchPanel);
                                (this).LaunchBuilder.this.tabs.add(n + 1, launchPanel);
                            }
                        });
                        jPopupMenu.add(jMenuItem);
                    }
                    if (n > 0) {
                        jMenuItem = new JMenuItem(LaunchRes.getString("Popup.MenuItem.MoveDown"));
                        jMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                LaunchPanel launchPanel = LaunchBuilder.this.getSelectedTab();
                                LaunchNode launchNode = launchPanel.getRootNode();
                                LaunchBuilder.super.removeSelectedTab();
                                (this).LaunchBuilder.this.tabbedPane.insertTab(LaunchBuilder.getDisplayName(launchNode.getFileName()), null, launchPanel, null, n - 1);
                                (this).LaunchBuilder.this.tabbedPane.setSelectedComponent(launchPanel);
                                (this).LaunchBuilder.this.tabs.add(n - 1, launchPanel);
                            }
                        });
                        jPopupMenu.add(jMenuItem);
                    }
                    jPopupMenu.show(LaunchBuilder.this.tabbedPane, mouseEvent.getX(), mouseEvent.getY() + 8);
                }
            }
        };
        this.tabbedPane.addMouseListener(this.tabListener);
        this.frame.pack();
        this.displaySplitPane.setDividerLocation(0.7);
    }

    @Override
    protected void setFontLevel(int n) {
        final int n2 = this.displaySplitPane.getLastDividerLocation();
        final String string = this.displaySplitPane.getName();
        FontSizer.setFonts(this.displayTitle, n);
        FontSizer.setFonts(this.commentTitle, n);
        FontSizer.setFonts(this.descriptionTitle, n);
        FontSizer.setFonts(this.optionsTitle, n);
        FontSizer.setFonts(this.securityTitle, n);
        super.setFontLevel(n);
        if (string != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    double d = Double.parseDouble(string);
                    d = Math.max(0.0, d);
                    d = Math.min(1.0, d);
                    LaunchBuilder.this.displaySplitPane.setDividerLocation(d);
                    LaunchBuilder.this.displaySplitPane.setLastDividerLocation(n2);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected void createActions() {
        String string = "/org/opensourcephysics/resources/tools/images/open.gif";
        this.openIcon = LaunchBuilder.loadIcon(string);
        this.openJarAction = new AbstractAction(null, this.openIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = LaunchBuilder.getJARChooser();
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    String string = XML.getRelativePath(file.getPath());
                    String string2 = LaunchBuilder.this.jarField.getText();
                    if (string2.indexOf(string) > -1) {
                        string = null;
                    }
                    if (!string2.equals("")) {
                        string2 = String.valueOf(string2) + ";";
                    }
                    if (string != null) {
                        LaunchBuilder.this.jarField.setText(String.valueOf(string2) + string);
                    }
                    OSPRuntime.chooserDir = XML.getDirectoryPath(file.getPath());
                    LaunchBuilder.this.searchJarAction.setEnabled(true);
                    LaunchBuilder.this.refreshSelectedNode();
                }
            }
        };
        this.searchJarAction = new AbstractAction(null, this.openIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LaunchNode launchNode = LaunchBuilder.this.getSelectedNode();
                if (launchNode != null && LaunchBuilder.this.getClassChooser().chooseClassFor(launchNode)) {
                    if (launchNode.getOwner() != null) {
                        LaunchBuilder.this.changedFiles.add(launchNode.getOwner().getFileName());
                    } else {
                        LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                    }
                    LaunchBuilder.this.refreshClones(launchNode);
                    LaunchBuilder.this.refreshGUI();
                }
            }
        };
        this.searchJarAction.setEnabled(false);
        this.saveJarAction = new AbstractAction(LaunchRes.getString("LaunchBuilder.Action.CreateJar.Name")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(XML.getDirectoryPath(OSPRuntime.getLaunchJarPath()));
                String string = String.valueOf(XML.stripExtension(LaunchBuilder.this.tabSetName)) + ".jar";
                File file2 = new File(file, string);
                final ArrayList<String> arrayList = new ArrayList<String>();
                JarTreeDialog jarTreeDialog = new JarTreeDialog((Frame)LaunchBuilder.this.frame, file);
                arrayList.add(OSPRuntime.getLaunchJarName());
                file.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip") || file.getName().endsWith(".trz") || file.getName().endsWith(".DS_Store") || file.getName().endsWith(".localized") || file.getName().endsWith(".tmp")) {
                            return false;
                        }
                        arrayList.add(file.getName());
                        return true;
                    }
                });
                jarTreeDialog.setSelectionRelativePaths(arrayList.toArray(new String[0]));
                jarTreeDialog.setVisible(true);
                String[] stringArray = jarTreeDialog.getSelectionRelativePaths();
                if (stringArray == null) {
                    return;
                }
                arrayList.clear();
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].equals(OSPRuntime.getLaunchJarName())) {
                        arrayList.add(0, stringArray[n]);
                    } else {
                        arrayList.add(stringArray[n]);
                    }
                    ++n;
                }
                Manifest manifest = JarTool.createManifest("", "org.opensourcephysics.tools.Launcher");
                JarTool.alwaysOverwrite();
                JarTool.setOwnerFrame(LaunchBuilder.this.frame);
                JarTool.getTool().create(arrayList, file, file2, manifest);
            }
        };
        this.openArgAction = new AbstractAction(null, this.openIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = LaunchBuilder.getFileChooser();
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    LaunchBuilder.this.argField.setText(XML.getRelativePath(file.getPath()));
                    OSPRuntime.chooserDir = XML.getDirectoryPath(file.getPath());
                    LaunchBuilder.this.refreshSelectedNode();
                }
            }
        };
        this.openModelArgAction = new AbstractAction(null, this.openIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = LaunchBuilder.getFileChooser();
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    LaunchBuilder.this.modelArgField.setText(XML.getRelativePath(file.getPath()));
                    OSPRuntime.chooserDir = XML.getDirectoryPath(file.getPath());
                    LaunchBuilder.this.refreshSelectedNode();
                }
            }
        };
        this.openURLAction = new AbstractAction(LaunchRes.getString("Popup.MenuItem.OpenHTML")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = LaunchBuilder.getHTMLChooser();
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    LaunchBuilder.this.pathField.setText(XML.getRelativePath(file.getPath()));
                    OSPRuntime.chooserDir = XML.getDirectoryPath(file.getPath());
                    LaunchBuilder.this.refreshSelectedNode();
                }
            }
        };
        this.openPDFAction = new AbstractAction(LaunchRes.getString("Popup.MenuItem.OpenPDF")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = LaunchBuilder.getPDFChooser();
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    LaunchBuilder.this.pathField.setText(XML.getRelativePath(file.getPath()));
                    OSPRuntime.chooserDir = XML.getDirectoryPath(file.getPath());
                    LaunchBuilder.this.refreshSelectedNode();
                }
            }
        };
        this.searchJarForModelAction = new AbstractAction(LaunchRes.getString("Popup.MenuItem.OpenModel")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Class<?> clazz = LaunchBuilder.this.getClassChooser().chooseModel(LaunchBuilder.this.pathField.getText());
                if (clazz != null) {
                    LaunchBuilder.this.pathField.setText(clazz.getName());
                    LaunchBuilder.this.refreshSelectedNode();
                }
            }
        };
        this.searchJarForModelAction.setEnabled(false);
        this.openTabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LaunchNode launchNode = LaunchBuilder.this.getSelectedNode();
                String string = launchNode.toString();
                int n = 0;
                while (n < LaunchBuilder.this.tabbedPane.getComponentCount()) {
                    if (LaunchBuilder.this.tabbedPane.getTitleAt(n).equals(string)) {
                        LaunchBuilder.this.tabbedPane.setSelectedIndex(n);
                        return;
                    }
                    ++n;
                }
                XMLControlElement xMLControlElement = new XMLControlElement(launchNode);
                XMLControlElement xMLControlElement2 = new XMLControlElement(xMLControlElement);
                LaunchNode launchNode2 = (LaunchNode)xMLControlElement2.loadObject(null);
                launchNode2.setFileName(launchNode.getFileName());
                LaunchBuilder.this.addTab(launchNode2);
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.changeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LaunchBuilder.this.refreshSelectedNode();
            }
        };
        this.newTabSetAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = LaunchBuilder.this.undoManager.getLauncherState();
                if (LaunchBuilder.this.removeAllTabs()) {
                    Serializable serializable;
                    if (stringArray != null) {
                        LauncherUndo launcherUndo = LaunchBuilder.this.undoManager;
                        launcherUndo.getClass();
                        serializable = launcherUndo.new LauncherUndo.LoadEdit(null, stringArray);
                        LaunchBuilder.this.undoSupport.postEdit((UndoableEdit)((Object)serializable));
                    }
                    serializable = new LaunchNode(LaunchRes.getString("NewTab.Name"));
                    LaunchBuilder.this.addTab((LaunchNode)serializable);
                }
            }
        };
        this.addAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LaunchNode launchNode = new LaunchNode(LaunchRes.getString("NewNode.Name"));
                LaunchBuilder.this.addChildToSelectedNode(launchNode);
            }
        };
        this.newTabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LaunchNode launchNode = new LaunchNode(LaunchRes.getString("NewTab.Name"));
                LaunchBuilder.this.addTab(launchNode);
            }
        };
        this.cutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LaunchBuilder.this.copyAction.actionPerformed(null);
                LaunchBuilder.this.removeSelectedNodes();
            }
        };
        this.copyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<LaunchNode> arrayList;
                if (LaunchBuilder.this.getSelectedTab() != null && (arrayList = LaunchBuilder.this.getSelectedTab().getSelectedNodes()) != null) {
                    NodeSet nodeSet = new NodeSet(arrayList);
                    XMLControlElement xMLControlElement = new XMLControlElement(nodeSet);
                    StringSelection stringSelection = new StringSelection(xMLControlElement.toXML());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, stringSelection);
                }
            }
        };
        this.pasteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable transferable = clipboard.getContents(null);
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (string != null) {
                        XMLControlElement xMLControlElement = new XMLControlElement();
                        xMLControlElement.readXML(string);
                        if (xMLControlElement.getObjectClass() == NodeSet.class) {
                            NodeSet nodeSet = (NodeSet)xMLControlElement.loadObject(null);
                            for (Object[] objectArray : nodeSet.nodes) {
                                LaunchNode launchNode = (LaunchNode)objectArray[0];
                                if (objectArray.length > 1 && objectArray[1] != null) {
                                    launchNode.setFileName(objectArray[1].toString());
                                }
                                LaunchBuilder.this.addChildToSelectedNode(launchNode);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        this.importAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LaunchBuilder.getXMLChooser().setFileFilter(xmlFileFilter);
                int n = LaunchBuilder.getXMLChooser().showOpenDialog(null);
                if (n == 0) {
                    File file = LaunchBuilder.getXMLChooser().getSelectedFile();
                    String string = file.getAbsolutePath();
                    OSPRuntime.chooserDir = XML.getDirectoryPath(file.getPath());
                    XMLControlElement xMLControlElement = new XMLControlElement(string);
                    if (xMLControlElement.failedToRead()) {
                        OSPLog.info(String.valueOf(LaunchRes.getString("Log.Message.InvalidXML")) + " " + string);
                        JOptionPane.showMessageDialog(null, String.valueOf(LaunchRes.getString("Dialog.InvalidXML.Message")) + " \"" + XML.getName(string) + "\"", LaunchRes.getString("Dialog.InvalidXML.Title"), 2);
                        return;
                    }
                    if (xMLControlElement.getObjectClass() == LaunchNode.class) {
                        LaunchNode launchNode = (LaunchNode)xMLControlElement.loadObject(null);
                        launchNode.setFileName(string);
                        LaunchBuilder.this.addChildToSelectedNode(launchNode);
                    } else {
                        OSPLog.info(String.valueOf(LaunchRes.getString("Log.Message.NotLauncherFile")) + " " + string);
                        JOptionPane.showMessageDialog(null, String.valueOf(LaunchRes.getString("Dialog.NotLauncherFile.Message")) + " \"" + XML.getName(string) + "\"", LaunchRes.getString("Dialog.NotLauncherFile.Title"), 2);
                    }
                }
            }
        };
        this.saveAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LaunchNode launchNode = LaunchBuilder.this.getSelectedNode();
                if (launchNode.getFileName() != null) {
                    LaunchBuilder.this.save(launchNode, launchNode.getFileName());
                    LaunchBuilder.this.refreshGUI();
                }
            }
        };
        this.saveAsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LaunchNode launchNode = LaunchBuilder.this.getSelectedNode();
                LaunchNode launchNode2 = (LaunchNode)launchNode.getParent();
                String string = LaunchBuilder.this.saveAs(launchNode);
                if (string != null) {
                    LaunchBuilder.this.selfContained = false;
                    Enumeration<TreeNode> enumeration = launchNode.pathFromAncestorEnumeration(launchNode.getRoot());
                    while (enumeration.hasMoreElements()) {
                        LaunchNode launchNode3 = (LaunchNode)enumeration.nextElement();
                        launchNode3.setSelfContained(false);
                        launchNode3.parentSelfContained = false;
                    }
                    if (launchNode2 != null) {
                        if (launchNode2.getOwner() != null) {
                            LaunchBuilder.this.changedFiles.add(launchNode2.getOwner().getFileName());
                        }
                        LaunchBuilder.this.refreshClones(launchNode2);
                    }
                }
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.saveAllAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LaunchBuilder.this.tabSetName.equals(LaunchRes.getString("Tabset.Name.New"))) {
                    LaunchBuilder.this.saveTabSetAs();
                } else {
                    LaunchBuilder.this.saveTabSet();
                }
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.saveSetAsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LaunchBuilder.this.saveTabSetAs();
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.moveUpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<LaunchNode> arrayList = LaunchBuilder.this.getSelectedTab().getSelectedNodes();
                if (arrayList == null) {
                    return;
                }
                for (LaunchNode launchNode : arrayList) {
                    int n;
                    LaunchNode launchNode2 = (LaunchNode)launchNode.getParent();
                    if (launchNode2 == null || (n = launchNode2.getIndex(launchNode)) <= 0 || arrayList.contains(launchNode2.getChildBefore(launchNode))) continue;
                    LaunchBuilder.this.getSelectedTab().treeModel.removeNodeFromParent(launchNode);
                    LaunchBuilder.this.getSelectedTab().treeModel.insertNodeInto(launchNode, launchNode2, n - 1);
                    if (launchNode2.getOwner() != null) {
                        LaunchBuilder.this.changedFiles.add(launchNode2.getOwner().getFileName());
                        continue;
                    }
                    LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                }
                LaunchBuilder.this.getSelectedTab().setSelectedNodes(arrayList);
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.moveDownAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<LaunchNode> arrayList = LaunchBuilder.this.getSelectedTab().getSelectedNodes();
                if (arrayList == null) {
                    return;
                }
                int n = arrayList.size() - 1;
                while (n > -1) {
                    int n2;
                    int n3;
                    LaunchNode launchNode = arrayList.get(n);
                    LaunchNode launchNode2 = (LaunchNode)launchNode.getParent();
                    if (launchNode2 != null && (n3 = launchNode2.getIndex(launchNode)) < (n2 = launchNode2.getChildCount()) - 1 && !arrayList.contains(launchNode2.getChildAfter(launchNode))) {
                        LaunchBuilder.this.getSelectedTab().treeModel.removeNodeFromParent(launchNode);
                        LaunchBuilder.this.getSelectedTab().treeModel.insertNodeInto(launchNode, launchNode2, n3 + 1);
                        if (launchNode2.getOwner() != null) {
                            LaunchBuilder.this.changedFiles.add(launchNode2.getOwner().getFileName());
                        } else {
                            LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                        }
                    }
                    --n;
                }
                LaunchBuilder.this.getSelectedTab().setSelectedNodes(arrayList);
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                LaunchBuilder.this.refreshSelectedNode();
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                JComponent jComponent = (JComponent)keyEvent.getSource();
                if (keyEvent.getKeyCode() == 10 && (jComponent != LaunchBuilder.this.descriptionPane && jComponent != LaunchBuilder.this.commentPane || keyEvent.isControlDown() || keyEvent.isShiftDown())) {
                    LaunchBuilder.this.refreshSelectedNode();
                    LaunchBuilder.this.refreshGUI();
                } else {
                    jComponent.setBackground(Color.yellow);
                }
            }
        };
    }

    public void removeSelectedNode() {
        LaunchNode launchNode = this.getSelectedNode();
        if (launchNode == null || launchNode.getParent() == null) {
            return;
        }
        LaunchNode launchNode2 = (LaunchNode)launchNode.getParent();
        this.getSelectedTab().treeModel.removeNodeFromParent(launchNode);
        this.getSelectedTab().setSelectedNode(launchNode2);
        if (launchNode2.getOwner() != null) {
            this.changedFiles.add(launchNode2.getOwner().getFileName());
        } else {
            this.changedFiles.add(this.tabSetName);
        }
        this.refreshClones(launchNode2);
        this.refreshGUI();
    }

    public void removeSelectedNodes() {
        if (this.getSelectedTab() == null) {
            return;
        }
        ArrayList<LaunchNode> arrayList = this.getSelectedTab().getSelectedNodes();
        if (arrayList == null) {
            return;
        }
        LaunchNode launchNode = null;
        for (LaunchNode launchNode2 : arrayList) {
            if (launchNode2.getParent() == null || launchNode2.getRoot() != this.getRootNode()) continue;
            LaunchNode launchNode3 = (LaunchNode)launchNode2.getParent();
            if (launchNode == null) {
                launchNode = launchNode3;
            }
            this.getSelectedTab().treeModel.removeNodeFromParent(launchNode2);
            if (launchNode3.getOwner() != null) {
                this.changedFiles.add(launchNode3.getOwner().getFileName());
            } else {
                this.changedFiles.add(this.tabSetName);
            }
            this.refreshClones(launchNode3);
        }
        if (launchNode != null) {
            this.getSelectedTab().setSelectedNode(launchNode);
            this.refreshGUI();
        }
    }

    public void addChildToSelectedNode(LaunchNode launchNode) {
        LaunchNode launchNode2 = this.getSelectedNode();
        if (launchNode2 != null && launchNode != null) {
            LaunchNode[] launchNodeArray = launchNode.getAllOwnedNodes();
            int n = 0;
            while (n < launchNodeArray.length) {
                LaunchNode launchNode3 = this.getSelectedTab().getClone(launchNodeArray[n]);
                if (launchNode3 != null) {
                    this.getSelectedTab().setSelectedNode(launchNode3);
                    JOptionPane.showMessageDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.DuplicateNode.Message")) + " \"" + launchNode3 + "\"", LaunchRes.getString("Dialog.DuplicateNode.Title"), 2);
                    return;
                }
                ++n;
            }
            this.getSelectedTab().treeModel.insertNodeInto(launchNode, launchNode2, launchNode2.getChildCount());
            this.getSelectedTab().tree.scrollPathToVisible(new TreePath(launchNode.getPath()));
            launchNode.setLaunchClass(launchNode.launchClassName);
            if (launchNode2.getOwner() != null) {
                this.changedFiles.add(launchNode2.getOwner().getFileName());
            } else {
                this.changedFiles.add(this.tabSetName);
            }
            this.refreshClones(launchNode2);
            this.refreshGUI();
        }
    }

    protected void refreshClones(LaunchNode launchNode) {
        Map<LaunchPanel, LaunchNode> map = this.getClones(launchNode);
        this.replaceClones(launchNode, map);
    }

    protected void replaceClones(LaunchNode launchNode, Map<LaunchPanel, LaunchNode> map) {
        if (map.isEmpty()) {
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(launchNode.getOwner());
        for (LaunchPanel launchPanel : map.keySet()) {
            LaunchNode launchNode2 = map.get(launchPanel);
            LaunchNode launchNode3 = (LaunchNode)launchNode2.getParent();
            boolean bl = launchPanel.tree.isExpanded(new TreePath(launchNode2.getPath()));
            if (launchNode3 != null) {
                int n = launchNode3.getIndex(launchNode2);
                launchPanel.treeModel.removeNodeFromParent(launchNode2);
                launchNode2 = (LaunchNode)new XMLControlElement(xMLControlElement).loadObject(null);
                launchNode2.setFileName(launchNode.getFileName());
                launchPanel.treeModel.insertNodeInto(launchNode2, launchNode3, n);
            } else {
                launchNode2 = (LaunchNode)new XMLControlElement(xMLControlElement).loadObject(null);
                launchNode2.setFileName(launchNode.getFileName());
                launchPanel.treeModel.setRoot(launchNode2);
            }
            if (!bl) continue;
            launchPanel.tree.expandPath(new TreePath(launchNode2.getPath()));
        }
    }

    protected Map<LaunchPanel, LaunchNode> getClones(LaunchNode launchNode) {
        HashMap<LaunchPanel, LaunchNode> hashMap = new HashMap<LaunchPanel, LaunchNode>();
        if ((launchNode = launchNode.getOwner()) == null) {
            return hashMap;
        }
        Component[] componentArray = this.tabbedPane.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            LaunchPanel launchPanel = (LaunchPanel)componentArray[n];
            LaunchNode launchNode2 = launchPanel.getClone(launchNode);
            if (launchNode2 != null && launchNode2 != launchNode) {
                hashMap.put(launchPanel, launchNode2);
            }
            ++n;
        }
        return hashMap;
    }

    protected static JFileChooser getJARChooser() {
        LaunchBuilder.getFileChooser().setFileFilter(jarFileFilter);
        return fileChooser;
    }

    public static JFileChooser getHTMLChooser() {
        LaunchBuilder.getFileChooser().setFileFilter(htmlFileFilter);
        return fileChooser;
    }

    public static JFileChooser getPDFChooser() {
        LaunchBuilder.getFileChooser().setFileFilter(pdfFileFilter);
        return fileChooser;
    }

    protected static JFileChooser getFileChooser() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser(new File(OSPRuntime.chooserDir));
            allFileFilter = fileChooser.getFileFilter();
            jarFileFilter = new javax.swing.filechooser.FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file == null) {
                        return false;
                    }
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = null;
                    String string2 = file.getName();
                    int n = string2.lastIndexOf(46);
                    if (n > 0 && n < string2.length() - 1) {
                        string = string2.substring(n + 1).toLowerCase();
                    }
                    return string != null && string.equals("jar");
                }

                @Override
                public String getDescription() {
                    return LaunchRes.getString("FileChooser.JarFilter.Description");
                }
            };
            htmlFileFilter = new javax.swing.filechooser.FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file == null) {
                        return false;
                    }
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = null;
                    String string2 = file.getName();
                    int n = string2.lastIndexOf(46);
                    if (n > 0 && n < string2.length() - 1) {
                        string = string2.substring(n + 1).toLowerCase();
                    }
                    return string != null && (string.equals("htm") || string.equals("html"));
                }

                @Override
                public String getDescription() {
                    return LaunchRes.getString("FileChooser.HTMLFilter.Description");
                }
            };
            pdfFileFilter = new javax.swing.filechooser.FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file == null) {
                        return false;
                    }
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = XML.getExtension(file.getName());
                    return string != null && string.equals("pdf");
                }

                @Override
                public String getDescription() {
                    return LaunchRes.getString("FileChooser.PDFFilter.Description");
                }
            };
        }
        fileChooser.removeChoosableFileFilter(jarFileFilter);
        fileChooser.removeChoosableFileFilter(htmlFileFilter);
        fileChooser.setFileFilter(allFileFilter);
        FontSizer.setFonts(fileChooser, FontSizer.getLevel());
        return fileChooser;
    }

    public static javax.swing.filechooser.FileFilter getHTMLFilter() {
        if (htmlFileFilter == null) {
            LaunchBuilder.getFileChooser();
        }
        return htmlFileFilter;
    }

    public static javax.swing.filechooser.FileFilter getPDFFilter() {
        if (pdfFileFilter == null) {
            LaunchBuilder.getFileChooser();
        }
        return pdfFileFilter;
    }

    @Override
    protected void handleMousePressed(MouseEvent mouseEvent, LaunchPanel launchPanel) {
        super.handleMousePressed(mouseEvent, launchPanel);
        if (OSPRuntime.isPopupTrigger(mouseEvent)) {
            TreePath treePath = launchPanel.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            LaunchNode launchNode = this.getSelectedNode();
            if (launchNode == null) {
                return;
            }
            String string = launchNode.getFileName();
            if (string != null && this.changedFiles.contains(string)) {
                if (this.popup.getComponentCount() != 0) {
                    this.popup.addSeparator();
                }
                this.popup.add(this.saveNodeItem);
            }
            if (this.popup.getComponentCount() != 0) {
                this.popup.addSeparator();
            }
            this.popup.add(this.saveNodeAsItem);
            if (!launchNode.isRoot()) {
                this.popup.addSeparator();
                this.openTabItem.setText(LaunchRes.getString("Action.OpenTab"));
                this.popup.add(this.openTabItem);
            }
            this.popup.show(launchPanel, mouseEvent.getX() + 4, mouseEvent.getY() + 12);
        }
    }

    @Override
    protected void exit() {
        OSPRuntime.setAuthorMode(false);
        if (!this.saveAllChanges()) {
            final int n = this.frame.getDefaultCloseOperation();
            this.frame.setDefaultCloseOperation(0);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    LaunchBuilder.this.frame.setDefaultCloseOperation(n);
                }
            };
            SwingUtilities.invokeLater(runnable);
            return;
        }
        super.exit();
    }

    protected boolean isTabSetWritable() {
        boolean bl;
        String string = XML.getResolvedPath(this.tabSetName, tabSetBasePath);
        Resource resource = ResourceLoader.getResource(string);
        File file = resource == null ? null : resource.getFile();
        boolean bl2 = bl = file == null ? true : file.canWrite();
        if (!this.selfContained) {
            int n = 0;
            while (n < this.tabbedPane.getTabCount()) {
                LaunchNode launchNode = this.getTab(n).getRootNode();
                bl = bl && this.isNodeWritable(launchNode);
                ++n;
            }
        }
        return bl;
    }

    protected boolean isNodeWritable(LaunchNode launchNode) {
        boolean bl;
        File file = launchNode.getFile();
        boolean bl2 = bl = file == null ? true : file.canWrite();
        if (!launchNode.isSelfContained()) {
            LaunchNode[] launchNodeArray = launchNode.getChildOwnedNodes();
            int n = 0;
            while (n < launchNodeArray.length) {
                bl = bl && this.isNodeWritable(launchNodeArray[n]);
                ++n;
            }
        }
        return bl;
    }

    protected static class NodeSet {
        ArrayList<Object[]> nodes = new ArrayList();

        private NodeSet(ArrayList<LaunchNode> arrayList) {
            for (LaunchNode launchNode : arrayList) {
                Object[] objectArray = new Object[]{launchNode, launchNode.getFileName()};
                this.nodes.add(objectArray);
            }
        }

        private NodeSet(XMLControl xMLControl) {
            ArrayList arrayList = (ArrayList)xMLControl.getObject("nodes");
            if (arrayList != null) {
                for (Object e : arrayList) {
                    this.nodes.add((Object[])e);
                }
            }
        }

        public static XML.ObjectLoader getLoader() {
            return new Loader();
        }

        static class Loader
        implements XML.ObjectLoader {
            Loader() {
            }

            @Override
            public void saveObject(XMLControl xMLControl, Object object) {
                NodeSet nodeSet = (NodeSet)object;
                xMLControl.setValue("nodes", nodeSet.nodes);
            }

            @Override
            public Object createObject(XMLControl xMLControl) {
                return new NodeSet(xMLControl);
            }

            @Override
            public Object loadObject(XMLControl xMLControl, Object object) {
                return object;
            }
        }
    }
}

