/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import org.opensourcephysics.numerics.PolynomialLeastSquareFit;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.ToolsRes;

public class KnownPolynomial
extends PolynomialLeastSquareFit
implements KnownFunction {
    String name;
    String description;
    String[] paramNames = new String[]{"A", "B", "C", "D", "E", "F"};
    String[] paramDescriptions;

    KnownPolynomial(double[] dArray, double[] dArray2, int n) {
        super(dArray, dArray2, n);
    }

    KnownPolynomial(double[] dArray) {
        super(dArray);
    }

    @Override
    public int getParameterCount() {
        return this.coefficients.length;
    }

    @Override
    public String getParameterName(int n) {
        return this.paramNames[n];
    }

    @Override
    public String getParameterDescription(int n) {
        if (this.paramDescriptions != null && this.paramDescriptions.length > n) {
            return this.paramDescriptions[n];
        }
        if (this.getParameterCount() == 2) {
            if (n == 0) {
                return ToolsRes.getString("Function.Parameter.Slope.Description");
            }
            return ToolsRes.getString("Function.Parameter.Intercept.Description");
        }
        return null;
    }

    @Override
    public double getParameterValue(int n) {
        return this.coefficients[this.coefficients.length - n - 1];
    }

    @Override
    public void setParameterValue(int n, double d) {
        if (Double.isNaN(d)) {
            return;
        }
        this.coefficients[this.coefficients.length - n - 1] = d;
    }

    @Override
    public void setParameters(String[] stringArray, double[] dArray, String[] stringArray2) {
        int n;
        if (stringArray != null) {
            n = 0;
            while (n < Math.min(stringArray.length, this.getParameterCount())) {
                if (stringArray[n] != null && !"".equals(stringArray[n].trim())) {
                    this.paramNames[n] = stringArray[n];
                }
                ++n;
            }
        }
        this.paramDescriptions = stringArray2;
        if (dArray != null) {
            n = 0;
            while (n < Math.min(dArray.length, this.getParameterCount())) {
                this.setParameterValue(n, dArray[n]);
                ++n;
            }
        }
    }

    @Override
    public String getExpression(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.coefficients.length - 1;
        int n2 = 0;
        while (n2 <= n) {
            stringBuffer.append(this.getParameterName(n2));
            if (n - n2 > 0) {
                stringBuffer.append("*");
                stringBuffer.append(string);
                if (n - n2 > 1) {
                    stringBuffer.append("^");
                    stringBuffer.append(n - n2);
                }
                stringBuffer.append(" + ");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "Poly" + (this.getParameterCount() - 1);
    }

    @Override
    public void setName(String string) {
        if (string != null && !"".equals(string.trim())) {
            this.name = string;
        }
    }

    @Override
    public String getDescription() {
        if (this.description != null && !"".equals(this.description.trim())) {
            return this.description;
        }
        return String.valueOf(ToolsRes.getString("KnownPolynomial.Description")) + " " + (this.getParameterCount() - 1);
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public KnownPolynomial clone() {
        KnownPolynomial knownPolynomial = new KnownPolynomial(this.coefficients);
        knownPolynomial.setName(this.getName());
        knownPolynomial.setDescription(this.getDescription());
        String[] stringArray = new String[this.coefficients.length];
        double[] dArray = new double[this.coefficients.length];
        String[] stringArray2 = new String[this.coefficients.length];
        int n = 0;
        while (n < this.coefficients.length) {
            stringArray[n] = this.getParameterName(n);
            dArray[n] = this.getParameterValue(n);
            stringArray2[n] = this.getParameterDescription(n);
            ++n;
        }
        knownPolynomial.setParameters(stringArray, dArray, stringArray2);
        return knownPolynomial;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof KnownPolynomial)) {
            return false;
        }
        KnownPolynomial knownPolynomial = (KnownPolynomial)object;
        int n = this.getParameterCount();
        if (n != knownPolynomial.getParameterCount()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!this.getParameterName(n2).equals(knownPolynomial.getParameterName(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

