/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.AbstractAutoloadManager;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FitFunctionPanel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.KnownPolynomial;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.TristateCheckBox;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class FitBuilder
extends FunctionTool {
    static JFileChooser chooser;
    static FileFilter xmlFilter;
    static String[] preferredAutoloadSearchPaths;
    static Collection<String> initialAutoloadSearchPaths;
    static Map<String, String[]> autoloadMap;
    protected JButton newFitButton;
    protected JButton deleteFitButton;
    protected JButton cloneFitButton;
    protected JButton loadButton;
    protected JButton saveButton;
    protected JButton autoloadButton;
    protected Component parent;
    protected TreeSet<String> addedFits = new TreeSet();
    protected String defaultFitName;
    protected AutoloadManager autoloadManager;

    static {
        initialAutoloadSearchPaths = new TreeSet<String>();
        autoloadMap = new TreeMap<String, String[]>();
        xmlFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null || file.isDirectory()) {
                    return false;
                }
                String string = XML.getExtension(file.getName());
                return string != null && "xml".equals(string.toLowerCase());
            }
        };
        preferredAutoloadSearchPaths = (String[])OSPRuntime.getPreference("autoload_search_paths");
        String[][] stringArray = (String[][])OSPRuntime.getPreference("autoload_exclusions");
        if (stringArray != null) {
            String[][] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String[] stringArray3 = stringArray2[n2];
                String string = XML.forwardSlash(stringArray3[0]);
                String[] stringArray4 = new String[stringArray3.length - 1];
                System.arraycopy(stringArray3, 1, stringArray4, 0, stringArray4.length);
                autoloadMap.put(string, stringArray4);
                ++n2;
            }
        }
    }

    public FitBuilder(Component component) {
        super(component);
        this.parent = component;
        this.newFitButton = new JButton(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Text"));
        this.newFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Tooltip"));
        this.newFitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = FitBuilder.this.getUniqueName(ToolsRes.getString("DatasetCurveFitter.NewFit.Name"));
                UserFunction userFunction = new UserFunction(string);
                Dataset dataset = null;
                DatasetCurveFitter datasetCurveFitter = FitBuilder.this.getSelectedCurveFitter();
                if (datasetCurveFitter != null) {
                    dataset = datasetCurveFitter.getData();
                }
                String string2 = dataset == null ? "x" : TeXParser.removeSubscripting(dataset.getColumnName(0));
                userFunction.setExpression("0", new String[]{string2});
                FitBuilder.this.addFitFunctionPanel(userFunction);
            }
        });
        this.deleteFitButton = new JButton(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Text"));
        this.deleteFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Tooltip"));
        this.deleteFitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = FitBuilder.this.getSelectedName();
                FitBuilder.this.removePanel(string);
            }
        });
        this.cloneFitButton = new JButton(ToolsRes.getString("DatasetCurveFitter.Button.Clone.Text"));
        this.cloneFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.Clone.Tooltip"));
        this.cloneFitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object22;
                final HashMap<Object, KnownFunction> hashMap = new HashMap<Object, KnownFunction>();
                final ArrayList<Object> arrayList = new ArrayList<Object>();
                for (Object object22 : FitBuilder.this.curveFitters) {
                    int n = 0;
                    while (n < ((DatasetCurveFitter)object22).fitDropDown.getItemCount()) {
                        String string = ((DatasetCurveFitter)object22).fitDropDown.getItemAt(n).toString();
                        if (!arrayList.contains(string)) {
                            arrayList.add(string);
                            hashMap.put(string, ((DatasetCurveFitter)object22).fitMap.get(string));
                        }
                        ++n;
                    }
                }
                object22 = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        for (String string : arrayList) {
                            DatasetCurveFitter datasetCurveFitter;
                            if (!string.equals(actionEvent.getActionCommand()) || (datasetCurveFitter = FitBuilder.this.getSelectedCurveFitter()) == null) continue;
                            KnownFunction knownFunction = (KnownFunction)hashMap.get(string);
                            UserFunction userFunction = datasetCurveFitter.createClone(knownFunction, string);
                            UserFunctionEditor userFunctionEditor = new UserFunctionEditor();
                            userFunctionEditor.setMainFunctions(new UserFunction[]{userFunction});
                            FitFunctionPanel fitFunctionPanel = new FitFunctionPanel(userFunctionEditor);
                            FitBuilder.this.addPanel(userFunction.getName(), fitFunctionPanel);
                        }
                    }
                };
                JPopupMenu jPopupMenu = new JPopupMenu();
                for (String string : arrayList) {
                    JMenuItem jMenuItem = new JMenuItem(string);
                    jMenuItem.setActionCommand(string);
                    jMenuItem.addActionListener((ActionListener)object22);
                    jPopupMenu.add(jMenuItem);
                }
                jPopupMenu.show(FitBuilder.this.cloneFitButton, 0, FitBuilder.this.cloneFitButton.getHeight());
            }
        });
        String string = "/org/opensourcephysics/resources/tools/images/open.gif";
        Icon icon = ResourceLoader.getIcon(string);
        this.loadButton = new JButton(icon);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FitBuilder.this.loadFits();
            }
        });
        string = "/org/opensourcephysics/resources/tools/images/save.gif";
        Icon icon2 = ResourceLoader.getIcon(string);
        this.saveButton = new JButton(icon2);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FitBuilder.this.saveFits();
            }
        });
        this.autoloadButton = new JButton();
        this.autoloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutoloadManager autoloadManager = FitBuilder.this.getAutoloadManager();
                autoloadManager.refreshAutoloadData();
                autoloadManager.setVisible(true);
            }
        });
        this.setToolbarComponents(new Component[]{this.loadButton, this.saveButton, new JToolBar.Separator(), this.newFitButton, this.cloneFitButton, this.deleteFitButton, Box.createHorizontalGlue(), this.autoloadButton});
        for (String string2 : FitBuilder.getInitialSearchPaths()) {
            this.autoloadFits(string2);
        }
    }

    public DatasetCurveFitter getSelectedCurveFitter() {
        DataTool dataTool;
        DataToolTab dataToolTab;
        Window window = this.getOwner();
        if (window != null && window instanceof DataTool && (dataToolTab = (dataTool = (DataTool)window).getSelectedTab()) != null) {
            return dataToolTab.curveFitter;
        }
        return null;
    }

    @Override
    public void refreshDropdown(String string) {
        if (string == null) {
            string = this.defaultFitName;
        }
        this.deleteFitButton.setEnabled(!this.getPanelNames().isEmpty());
        if (this.getPanelNames().isEmpty()) {
            String string2 = ToolsRes.getString("FitFunctionPanel.Label");
            this.dropdownLabel.setText(String.valueOf(string2) + ":");
        }
        super.refreshDropdown(string);
    }

    public boolean addFitFunction(KnownFunction knownFunction) {
        if (knownFunction instanceof UserFunction) {
            String string = knownFunction.getName();
            if (this.addedFits.contains(string)) {
                return true;
            }
            for (String object2 : this.getPanelNames()) {
                FitFunctionPanel fitFunctionPanel = (FitFunctionPanel)this.getPanel(object2);
                if (!string.equals(fitFunctionPanel.originalName)) continue;
                return false;
            }
            FitFunctionPanel fitFunctionPanel = this.addFitFunctionPanel((UserFunction)knownFunction);
            fitFunctionPanel.originalName = string;
            this.addedFits.add(string);
        } else if (knownFunction instanceof KnownPolynomial) {
            UserFunction userFunction = new UserFunction((KnownPolynomial)knownFunction);
            return this.addFitFunction(userFunction);
        }
        return true;
    }

    private String loadFits() {
        int n;
        if (chooser == null) {
            chooser = OSPRuntime.getChooser();
            javax.swing.filechooser.FileFilter[] fileFilterArray = chooser.getChoosableFileFilters();
            int n2 = fileFilterArray.length;
            int n3 = 0;
            while (n3 < n2) {
                javax.swing.filechooser.FileFilter fileFilter = fileFilterArray[n3];
                if (fileFilter.getDescription().toLowerCase().indexOf("xml") > -1) {
                    chooser.setFileFilter(fileFilter);
                    break;
                }
                ++n3;
            }
        }
        if ((n = chooser.showOpenDialog(this)) == 0) {
            OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
            String string = chooser.getSelectedFile().getAbsolutePath();
            return this.loadFits(string, false);
        }
        return null;
    }

    private String loadFits(String string, boolean bl) {
        if (string == null) {
            return this.loadFits();
        }
        XMLControlElement xMLControlElement = new XMLControlElement(string);
        if (xMLControlElement.failedToRead()) {
            JOptionPane.showMessageDialog(this, ToolsRes.getString("Dialog.Invalid.Message"), ToolsRes.getString("Dialog.Invalid.Title"), 0);
            return null;
        }
        Class<?> clazz = xMLControlElement.getObjectClass();
        if (FitBuilder.class.isAssignableFrom(clazz)) {
            if (bl || this.chooseFitFunctions(xMLControlElement, "Load")) {
                xMLControlElement.loadObject(this);
            }
        } else {
            JOptionPane.showMessageDialog(this, ToolsRes.getString("DatasetCurveFitter.FitBuilder.Dialog.WrongType.Message"), ToolsRes.getString("DatasetCurveFitter.FitBuilder.Dialog.WrongType.Title"), 0);
        }
        return string;
    }

    private String saveFits() {
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        if (this.chooseFitFunctions(xMLControlElement, "Save")) {
            int n;
            if (chooser == null) {
                chooser = OSPRuntime.getChooser();
                javax.swing.filechooser.FileFilter[] fileFilterArray = chooser.getChoosableFileFilters();
                n = fileFilterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    javax.swing.filechooser.FileFilter fileFilter = fileFilterArray[n2];
                    if (fileFilter.getDescription().toLowerCase().indexOf("xml") > -1) {
                        chooser.setFileFilter(fileFilter);
                        break;
                    }
                    ++n2;
                }
            }
            FontSizer.setFonts(chooser, FontSizer.getLevel());
            int n3 = chooser.showSaveDialog(this);
            if (n3 == 0) {
                OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
                File file = chooser.getSelectedFile();
                if (file.exists() && (n = JOptionPane.showConfirmDialog(this, String.valueOf(ToolsRes.getString("Tool.Dialog.ReplaceFile.Message")) + " " + file.getName() + "?", ToolsRes.getString("Tool.Dialog.ReplaceFile.Title"), 1)) != 0) {
                    return null;
                }
                return this.saveFits(file.getAbsolutePath(), xMLControlElement);
            }
        }
        return null;
    }

    private String saveFits(String string, XMLControl xMLControl) {
        if (string == null) {
            return this.saveFits();
        }
        if (XML.getExtension(string) == null) {
            string = String.valueOf(string) + ".xml";
        }
        if (xMLControl == null || xMLControl.getObjectClass() != this.getClass()) {
            xMLControl = new XMLControlElement(this);
        }
        xMLControl.write(string);
        return string;
    }

    private void autoloadFits(String string) {
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles(xmlFilter);
        if (fileArray != null) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz;
                File file2 = fileArray2[n2];
                XMLControlElement xMLControlElement = new XMLControlElement(file2.getPath());
                if (!xMLControlElement.failedToRead() && (clazz = xMLControlElement.getObjectClass()) != null && FitBuilder.class.isAssignableFrom(clazz)) {
                    XMLControlElement xMLControlElement2 = new XMLControlElement(xMLControlElement);
                    String string2 = XML.forwardSlash(file2.getAbsolutePath());
                    this.eliminateExcludedFunctions(xMLControlElement2, string2);
                    xMLControlElement2.loadObject(this);
                }
                ++n2;
            }
        }
    }

    private Map<String, ArrayList<String[]>> findFitFunctions(String string) {
        TreeMap<String, ArrayList<String[]>> treeMap = new TreeMap<String, ArrayList<String[]>>();
        if (string == null) {
            return treeMap;
        }
        File file = new File(string);
        if (!file.exists()) {
            return treeMap;
        }
        File[] fileArray = file.listFiles(xmlFilter);
        if (fileArray != null) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz;
                File file2 = fileArray2[n2];
                XMLControlElement xMLControlElement = new XMLControlElement(file2.getPath());
                if (!xMLControlElement.failedToRead() && (clazz = xMLControlElement.getObjectClass()) != null && FitBuilder.class.isAssignableFrom(clazz)) {
                    ArrayList<String[]> arrayList = new ArrayList<String[]>();
                    for (Object object : xMLControlElement.getPropertyContent()) {
                        XMLControl[] xMLControlArray;
                        if (!(object instanceof XMLProperty) || !((XMLProperty)object).getPropertyName().equals("functions")) continue;
                        XMLControl[] xMLControlArray2 = xMLControlArray = ((XMLProperty)object).getChildControls();
                        int n3 = xMLControlArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            XMLControl xMLControl = xMLControlArray2[n4];
                            String string2 = xMLControl.getString("name");
                            String string3 = xMLControl.getString("description");
                            String[] stringArray = new String[]{string2, string3};
                            arrayList.add(stringArray);
                            ++n4;
                        }
                        break block1;
                    }
                    treeMap.put(file2.getName(), arrayList);
                }
                ++n2;
            }
        }
        return treeMap;
    }

    /*
     * Could not resolve type clashes
     */
    protected void eliminateExcludedFunctions(XMLControl xMLControl, String string) {
        for (Object object : xMLControl.getPropertyContent()) {
            if (!(object instanceof XMLProperty) || !((XMLProperty)object).getPropertyName().equals("functions")) continue;
            XMLProperty xMLProperty = (XMLProperty)object;
            List<Object> list = xMLProperty.getPropertyContent();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            XMLControl[] xMLControlArray = xMLProperty.getChildControls();
            int n = 0;
            while (n < xMLControlArray.length) {
                XMLControl xMLControl2 = xMLControlArray[n];
                String string2 = xMLControl2.getString("name");
                if (this.isFunctionExcluded(string, string2)) {
                    arrayList.add(list.get(n));
                }
                ++n;
            }
            for (Object e : arrayList) {
                list.remove(e);
            }
        }
    }

    private boolean isFunctionExcluded(String string, String string2) {
        String[] stringArray = autoloadMap.get(string);
        if (stringArray == null) {
            return false;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            if (string3.equals("*")) {
                return true;
            }
            if (string3.equals(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void refreshGUI() {
        Object object;
        super.refreshGUI();
        this.setTitle(ToolsRes.getString("DatasetCurveFitter.FitBuilder.Title"));
        if (this.getPanelNames().isEmpty()) {
            object = ToolsRes.getString("FitFunctionPanel.Label");
            this.dropdownLabel.setText(String.valueOf(object) + ":");
        }
        if (this.saveButton != null) {
            this.saveButton.setEnabled(!this.getPanelNames().isEmpty());
            this.loadButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.FitBuilder.Button.Load.Tooltip"));
            this.saveButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.FitBuilder.Button.Save.Tooltip"));
            object = (FitFunctionPanel)this.getSelectedPanel();
            this.deleteFitButton.setEnabled(!this.getPanelNames().isEmpty() && ((FitFunctionPanel)object).originalName == null);
            this.newFitButton.setText(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Text"));
            this.newFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Tooltip"));
            this.deleteFitButton.setText(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Text"));
            this.deleteFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Tooltip"));
            DatasetCurveFitter datasetCurveFitter = this.getSelectedCurveFitter();
            this.cloneFitButton.setEnabled(datasetCurveFitter != null);
            this.autoloadButton.setText(String.valueOf(ToolsRes.getString("FitBuilder.Button.Autoload")) + "...");
            this.autoloadButton.setToolTipText(ToolsRes.getString("FitBuilder.Button.Autoload.Tooltip"));
        }
    }

    protected boolean chooseFitFunctions(XMLControl xMLControl, String string) {
        Object object2;
        ListChooser listChooser = new ListChooser(ToolsRes.getString("DatasetCurveFitter.FitBuilder." + string + ".Title"), ToolsRes.getString("DatasetCurveFitter.FitBuilder." + string + ".Message"), this);
        ArrayList<XMLControl> arrayList = new ArrayList<XMLControl>();
        ArrayList<XMLControl> arrayList2 = new ArrayList<XMLControl>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (Object object2 : xMLControl.getPropertyContent()) {
            if (!(object2 instanceof XMLProperty)) continue;
            XMLProperty xMLProperty = (XMLProperty)object2;
            for (Object object3 : xMLProperty.getPropertyContent()) {
                if (!(object3 instanceof XMLProperty)) continue;
                XMLProperty xMLProperty2 = (XMLProperty)object3;
                XMLControl xMLControl2 = xMLProperty2.getChildControls()[0];
                arrayList.add(xMLControl2);
                arrayList2.add(xMLControl2);
                arrayList3.add(xMLControl2.getString("name"));
                String string2 = xMLControl2.getString("description");
                arrayList4.add(string2);
            }
        }
        object2 = new boolean[arrayList2.size()];
        int n = 0;
        while (n < ((Object)object2).length) {
            object2[n] = true;
            ++n;
        }
        if (listChooser.choose(arrayList2, arrayList3, arrayList4, (boolean[])object2)) {
            for (XMLControl xMLControl3 : arrayList) {
                Object object3;
                if (arrayList2.contains(xMLControl3)) continue;
                object3 = xMLControl3.getParentProperty();
                XMLProperty xMLProperty = object3.getParentProperty();
                xMLProperty.getPropertyContent().remove(object3);
            }
            return true;
        }
        return false;
    }

    protected FitFunctionPanel addFitFunctionPanel(UserFunction userFunction) {
        UserFunctionEditor userFunctionEditor = new UserFunctionEditor();
        userFunctionEditor.setMainFunctions(new UserFunction[]{userFunction});
        FitFunctionPanel fitFunctionPanel = new FitFunctionPanel(userFunctionEditor);
        return (FitFunctionPanel)this.addPanel(userFunction.getName(), fitFunctionPanel);
    }

    protected AutoloadManager getAutoloadManager() {
        if (this.autoloadManager == null) {
            this.autoloadManager = new AutoloadManager(this);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - this.autoloadManager.getBounds().width) / 2;
            int n2 = (dimension.height - this.autoloadManager.getBounds().height) / 2;
            this.autoloadManager.setLocation(n, n2);
        }
        this.autoloadManager.setFontLevel(FontSizer.getLevel());
        return this.autoloadManager;
    }

    public static String localize(String string) {
        String string2 = ToolsRes.getString("Function." + string + ".Name");
        if (!string2.startsWith("!")) {
            return string2;
        }
        return string;
    }

    protected static Collection<String> getInitialSearchPaths() {
        block4: {
            if (!initialAutoloadSearchPaths.isEmpty()) break block4;
            if (preferredAutoloadSearchPaths != null) {
                String[] stringArray = preferredAutoloadSearchPaths;
                int n = preferredAutoloadSearchPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    initialAutoloadSearchPaths.add(string);
                    ++n2;
                }
            } else {
                for (String string : OSPRuntime.getDefaultSearchPaths()) {
                    initialAutoloadSearchPaths.add(string);
                }
            }
        }
        return initialAutoloadSearchPaths;
    }

    class AutoloadManager
    extends AbstractAutoloadManager {
        public AutoloadManager(JDialog jDialog) {
            super(jDialog);
        }

        @Override
        public void setVisible(boolean bl) {
            super.setVisible(bl);
            if (!bl) {
                Collection<String> collection = this.getSearchPaths();
                ArrayList<String> arrayList = OSPRuntime.getDefaultSearchPaths();
                boolean bl2 = collection.size() == arrayList.size();
                for (String stringArrayArray2 : collection) {
                    boolean bl3 = bl2 = bl2 && arrayList.contains(stringArrayArray2);
                }
                preferredAutoloadSearchPaths = bl2 ? null : collection.toArray(new String[collection.size()]);
                OSPRuntime.setPreference("autoload_search_paths", preferredAutoloadSearchPaths);
                Iterator<String> iterator = autoloadMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    String string2 = XML.getDirectoryPath(string);
                    boolean bl4 = false;
                    for (String string3 : collection) {
                        boolean bl5 = bl4 = bl4 || string2.equals(string3);
                    }
                    if (bl4 && new File(string).exists()) continue;
                    iterator.remove();
                }
                if (autoloadMap.isEmpty()) {
                    OSPRuntime.setPreference("autoload_exclusions", null);
                } else {
                    String[][] stringArrayArray = new String[autoloadMap.size()][];
                    int n = 0;
                    for (String string2 : autoloadMap.keySet()) {
                        String[] stringArray = autoloadMap.get(string2);
                        String[] stringArray2 = new String[stringArray.length + 1];
                        stringArray2[0] = string2;
                        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
                        stringArrayArray[n] = stringArray2;
                        ++n;
                    }
                    OSPRuntime.setPreference("autoload_exclusions", stringArrayArray);
                }
                OSPRuntime.savePreferences();
            }
        }

        @Override
        protected void setFunctionSelected(String string, String[] stringArray, boolean bl) {
            int n;
            String[] stringArray2 = autoloadMap.get(string);
            String[] stringArray3 = null;
            if (!bl) {
                if (stringArray2 == null) {
                    stringArray3 = new String[]{stringArray[0]};
                } else {
                    n = stringArray2.length;
                    stringArray3 = new String[n + 1];
                    System.arraycopy(stringArray2, 0, stringArray3, 0, n);
                    stringArray3[n] = stringArray[0];
                }
            } else if (stringArray2 != null && (n = stringArray2.length) > 1) {
                ArrayList arrayList = new ArrayList();
                String[] stringArray4 = stringArray2;
                int n2 = stringArray2.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string2 = stringArray4[n3];
                    if (!string2.equals(stringArray[0])) {
                        arrayList.add(string2);
                    }
                    ++n3;
                }
                stringArray3 = arrayList.toArray(new String[arrayList.size()]);
            }
            autoloadMap.remove(string);
            if (stringArray3 != null) {
                autoloadMap.put(string, stringArray3);
            }
            this.refreshAutoloadData();
            for (String string3 : this.getSearchPaths()) {
                FitBuilder.this.autoloadFits(string3);
            }
        }

        @Override
        protected boolean isFunctionSelected(String string, String[] stringArray) {
            String[] stringArray2 = autoloadMap.get(string);
            if (stringArray2 == null) {
                return true;
            }
            String[] stringArray3 = stringArray2;
            int n = stringArray2.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray3[n2];
                if (string2.equals("*")) {
                    return false;
                }
                if (string2.equals(stringArray[0])) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Override
        protected void setFileSelected(String string, boolean bl) {
            autoloadMap.remove(string);
            if (!bl) {
                String[] object = new String[]{"*"};
                autoloadMap.put(string, object);
            }
            this.refreshAutoloadData();
            for (String string2 : this.getSearchPaths()) {
                FitBuilder.this.autoloadFits(string2);
            }
        }

        @Override
        protected TristateCheckBox.State getFileSelectionState(String string) {
            String[] stringArray = autoloadMap.get(string);
            if (stringArray == null) {
                return TristateCheckBox.SELECTED;
            }
            if (stringArray[0].equals("*")) {
                return TristateCheckBox.NOT_SELECTED;
            }
            return TristateCheckBox.PART_SELECTED;
        }

        @Override
        public Collection<String> getSearchPaths() {
            Collection<String> collection = super.getSearchPaths();
            if (collection.isEmpty() && !this.initialized) {
                this.initialized = true;
                for (String string : FitBuilder.getInitialSearchPaths()) {
                    collection.add(string);
                    this.addSearchPath(string);
                }
            }
            return collection;
        }

        @Override
        protected void refreshAutoloadData() {
            TreeMap<String, Map<String, ArrayList<String[]>>> treeMap = new TreeMap<String, Map<String, ArrayList<String[]>>>();
            for (String string : this.getSearchPaths()) {
                Map map = FitBuilder.this.findFitFunctions(string);
                treeMap.put(string, map);
            }
            this.setAutoloadData(treeMap);
        }

        @Override
        protected void refreshGUI() {
            this.refreshAutoloadData();
            super.refreshGUI();
            String string = String.valueOf(FitBuilder.this.getTitle()) + " " + this.getTitle();
            this.setTitle(string);
            this.setInstructions(String.valueOf(ToolsRes.getString("FitBuilder.Instructions.SelectToAutoload")) + "\n\n" + ToolsRes.getString("FitBuilder.Instructions.WhereDefined") + " " + ToolsRes.getString("FitBuilder.Instructions.HowToAddFunction") + " " + ToolsRes.getString("FitBuilder.Instructions.HowToAddDirectory"));
        }
    }
}

