/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.tools.DataFunctionEditor;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;

public class DataFunctionPanel
extends FunctionPanel {
    public DataFunctionPanel(DatasetManager datasetManager) {
        this(new DataFunctionEditor(datasetManager));
    }

    public DataFunctionPanel(DataFunctionEditor dataFunctionEditor) {
        super(dataFunctionEditor);
        String string = dataFunctionEditor.getData().getName();
        this.setName(string.equals("") ? "data" : string);
    }

    public DatasetManager getData() {
        return ((DataFunctionEditor)this.functionEditor).getData();
    }

    @Override
    public String getLabel() {
        return ToolsRes.getString("DataFunctionPanel.SpinnerLabel");
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("edit")) {
            this.refreshFunctions();
            super.propertyChange(propertyChangeEvent);
        } else if (propertyChangeEvent.getPropertyName().equals("function")) {
            if (propertyChangeEvent.getNewValue() != null) {
                DataFunction dataFunction = (DataFunction)propertyChangeEvent.getNewValue();
                this.getData().addDataset(dataFunction);
            } else if (propertyChangeEvent.getOldValue() != null) {
                DataFunction dataFunction = (DataFunction)propertyChangeEvent.getOldValue();
                int n = this.getData().getDatasetIndex(dataFunction.getYColumnName());
                this.getData().removeDataset(n);
            }
            this.refreshFunctions();
            this.refreshGUI();
            if (this.functionTool != null) {
                this.functionTool.refreshGUI();
                this.functionTool.firePropertyChange("function", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void refreshFunctions() {
        void parameter;
        String[] stringArray = this.getData().getConstantNames();
        int n = stringArray.length;
        boolean n2 = false;
        while (parameter < n) {
            String string = stringArray[parameter];
            this.getData().clearConstant(string);
            ++parameter;
        }
        for (Parameter parameter2 : this.paramEditor.getObjects()) {
            String string = parameter2.getName();
            double d = parameter2.getValue();
            this.getData().setConstant(string, d, parameter2.getExpression(), parameter2.getDescription());
        }
        this.functionEditor.evaluateAll();
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            DataFunctionPanel dataFunctionPanel = (DataFunctionPanel)object;
            xMLControl.setValue("description", dataFunctionPanel.getDescription());
            Parameter[] parameterArray = dataFunctionPanel.getParamEditor().getParameters();
            xMLControl.setValue("user_parameters", parameterArray);
            FunctionEditor functionEditor = dataFunctionPanel.getFunctionEditor();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            for (Object object2 : functionEditor.getObjects()) {
                arrayList.add(new String[]{functionEditor.getName(object2), functionEditor.getExpression(object2)});
            }
            xMLControl.setValue("functions", arrayList);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            Object object2;
            DataFunctionPanel dataFunctionPanel = (DataFunctionPanel)object;
            dataFunctionPanel.setDescription(xMLControl.getString("description"));
            Parameter[] parameterArray = (Parameter[])xMLControl.getObject("user_parameters");
            Parameter[] parameterArray2 = dataFunctionPanel.getParamEditor().getParameters();
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            Object object3 = parameterArray2;
            int n = parameterArray2.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = object3[n2];
                arrayList.add((Parameter)object2);
                arrayList2.add(((Parameter)object2).getName());
                ++n2;
            }
            object3 = parameterArray;
            n = parameterArray.length;
            n2 = 0;
            while (n2 < n) {
                object2 = object3[n2];
                if (!arrayList2.contains(((Parameter)object2).getName())) {
                    arrayList.add((Parameter)object2);
                }
                ++n2;
            }
            parameterArray = arrayList.toArray(new Parameter[arrayList.size()]);
            dataFunctionPanel.getParamEditor().setParameters(parameterArray);
            object2 = (ArrayList)xMLControl.getObject("functions");
            FunctionEditor functionEditor = dataFunctionPanel.getFunctionEditor();
            List<Object> list = functionEditor.getObjects();
            object3 = dataFunctionPanel.getData();
            Iterator iterator = ((ArrayList)object2).iterator();
            block2: while (iterator.hasNext()) {
                Object object42;
                Object e = iterator.next();
                String[] stringArray = (String[])e;
                for (Object object42 : list) {
                    DataFunction dataFunction = (DataFunction)object42;
                    if (dataFunction.getYColumnName().equals(stringArray[0]) && dataFunction.getExpression().equals(stringArray[1])) continue block2;
                }
                object42 = new DataFunction((DatasetManager)object3, stringArray[0], stringArray[1]);
                functionEditor.addObject(object42, false);
            }
            return object;
        }
    }
}

