/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.xuggle;

import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.media.core.ScratchVideoRecorder;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.xuggle.XuggleVideoType;
import org.opensourcephysics.tools.DiagnosticsForXuggle;
import org.opensourcephysics.tools.ResourceLoader;

public class XuggleVideoRecorder
extends ScratchVideoRecorder {
    private IContainer outContainer;
    private IStream outStream;
    private IStreamCoder outStreamCoder;
    private IConverter outConverter;
    private Dimension converterDim;

    public XuggleVideoRecorder(XuggleVideoType xuggleVideoType) {
        super(xuggleVideoType);
    }

    @Override
    public void reset() {
        try {
            this.closeStream();
        }
        catch (IOException iOException) {}
        if (this.outConverter != null) {
            this.outConverter.delete();
            this.outConverter = null;
        }
        this.deleteTempFiles();
        super.reset();
        this.scratchFile = null;
    }

    @Override
    protected void finalize() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean append(Image image) {
        BufferedImage bufferedImage;
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (this.dim == null || !this.hasContent && (this.dim.width != n || this.dim.height != n2)) {
            this.dim = new Dimension(n, n2);
        }
        if (this.dim.width != n || this.dim.height != n2 || !(image instanceof BufferedImage)) {
            bufferedImage = new BufferedImage(this.dim.width, this.dim.height, 1);
            int n3 = (this.dim.width - n) / 2;
            int n4 = (this.dim.height - n2) / 2;
            bufferedImage.getGraphics().drawImage(image, n3, n4, null);
            image = bufferedImage;
        }
        bufferedImage = (BufferedImage)image;
        String string = String.valueOf(this.tempFileBasePath) + "_" + this.tempFiles.size() + ".tmp";
        try {
            ImageIO.write((RenderedImage)bufferedImage, this.tempFileType, new BufferedOutputStream(new FileOutputStream(string)));
        }
        catch (Exception exception) {
            return false;
        }
        File file = new File(string);
        if (file.exists()) {
            ArrayList arrayList = this.tempFiles;
            synchronized (arrayList) {
                this.tempFiles.add(file);
            }
            file.deleteOnExit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveScratch() throws IOException {
        VideoFileFilter videoFileFilter = this.videoType.getDefaultFileFilter();
        if (!this.hasContent || !(videoFileFilter instanceof VideoFileFilter)) {
            return;
        }
        IContainerFormat iContainerFormat = IContainerFormat.make();
        VideoFileFilter videoFileFilter2 = videoFileFilter;
        iContainerFormat.setOutputFormat(videoFileFilter2.getContainerType(), null, null);
        IPixelFormat.Type type = IPixelFormat.Type.YUV420P;
        this.openStream(iContainerFormat, type);
        long l = 0L;
        int n = 0;
        ArrayList arrayList = this.tempFiles;
        synchronized (arrayList) {
            for (File file : this.tempFiles) {
                if (!file.exists()) {
                    throw new IOException("temp image file not found");
                }
                BufferedImage bufferedImage = ResourceLoader.getBufferedImage(file.getAbsolutePath(), 5);
                if (bufferedImage == null || bufferedImage.getType() != 5) {
                    throw new IOException("unable to load temp image file");
                }
                this.encodeImage(bufferedImage, type, l);
                l = Math.round((double)(++n) * this.frameDuration * 1000.0);
            }
        }
        this.closeStream();
        this.deleteTempFiles();
        this.hasContent = false;
        this.canRecord = false;
    }

    @Override
    protected boolean startRecording() {
        try {
            this.tempFileBasePath = XML.stripExtension(this.scratchFile.getAbsolutePath());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean openStream(IContainerFormat iContainerFormat, IPixelFormat.Type type) throws IOException {
        boolean bl;
        this.outContainer = IContainer.make();
        if (this.outContainer.open(this.scratchFile.getAbsolutePath(), IContainer.Type.WRITE, iContainerFormat) < 0) {
            OSPLog.finer("Xuggle could not open output file");
            return false;
        }
        String string = "typical." + this.videoType.getDefaultExtension();
        ICodec iCodec = ICodec.guessEncodingCodec(iContainerFormat, null, string, null, ICodec.Type.CODEC_TYPE_VIDEO);
        this.outStream = DiagnosticsForXuggle.getXuggleVersion().startsWith("3.4") ? this.outContainer.addNewStream(0) : this.outContainer.addNewStream(iCodec);
        this.outStreamCoder = this.outStream.getStreamCoder();
        this.outStreamCoder.setNumPicturesInGroupOfPictures(10);
        if (DiagnosticsForXuggle.getXuggleVersion().startsWith("3.4")) {
            this.outStreamCoder.setCodec(iCodec);
        }
        this.outStreamCoder.setBitRate(250000);
        this.outStreamCoder.setPixelType(type);
        if (this.dim == null && this.frameImage != null) {
            this.dim = new Dimension(this.frameImage.getWidth(null), this.frameImage.getHeight(null));
        }
        if (this.dim != null) {
            this.outStreamCoder.setHeight(this.dim.height);
            this.outStreamCoder.setWidth(this.dim.width);
        }
        IRational iRational = IRational.make(1000.0 / this.frameDuration);
        boolean bl2 = bl = string.endsWith(".avi") || string.endsWith(".mpg");
        if (bl && iRational.getDenominator() > 65535) {
            double d = 1000.0 / this.frameDuration;
            int n = 63000;
            int n2 = Math.round(Math.round(d * (double)n));
            iRational = IRational.make(n2, n);
        }
        this.outStreamCoder.setFrameRate(iRational);
        this.outStreamCoder.setTimeBase(IRational.make(iRational.getDenominator(), iRational.getNumerator()));
        if (DiagnosticsForXuggle.getXuggleVersion().startsWith("3.4")) {
            if (this.outStreamCoder.open() < 0) {
                OSPLog.finer("Xuggle could not open stream encoder");
                return false;
            }
        } else if (this.outStreamCoder.open(null, null) < 0) {
            OSPLog.finer("Xuggle could not open stream encoder");
            return false;
        }
        if (this.outContainer.writeHeader() < 0) {
            OSPLog.finer("Xuggle could not write file header");
            return false;
        }
        return true;
    }

    private boolean encodeImage(BufferedImage bufferedImage, IPixelFormat.Type type, long l) throws IOException {
        IVideoPicture iVideoPicture = this.getPicture(bufferedImage, type, l);
        if (iVideoPicture == null) {
            throw new RuntimeException("could not convert to picture");
        }
        IPacket iPacket = IPacket.make();
        if (this.outStreamCoder.encodeVideo(iPacket, iVideoPicture, 0) < 0) {
            throw new RuntimeException("could not encode video");
        }
        if (iPacket.isComplete()) {
            boolean bl = true;
            if (this.outContainer.writePacket(iPacket, bl) < 0) {
                throw new RuntimeException("could not save packet to container");
            }
            return true;
        }
        return false;
    }

    private void closeStream() throws IOException {
        if (this.outContainer != null) {
            if (this.outContainer.writeTrailer() < 0) {
                throw new RuntimeException("could not write trailer to output file");
            }
            this.outStreamCoder.close();
            this.outContainer.close();
            this.outContainer = null;
            this.outStreamCoder = null;
            this.outStream = null;
        }
    }

    private IVideoPicture getPicture(BufferedImage bufferedImage, IPixelFormat.Type type, long l) {
        IVideoPicture iVideoPicture = null;
        try {
            IConverter iConverter = this.getConverter(bufferedImage, type);
            iVideoPicture = iConverter.toPicture(bufferedImage, l);
            iVideoPicture.setQuality(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Error error) {
            error.printStackTrace();
        }
        return iVideoPicture;
    }

    private IConverter getConverter(BufferedImage bufferedImage, IPixelFormat.Type type) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (this.converterDim == null) {
            this.converterDim = new Dimension(n, n2);
        }
        if (this.outConverter == null || n != this.converterDim.width || n2 != this.converterDim.height || this.outConverter.getPictureType() != type) {
            try {
                this.outConverter = ConverterFactory.createConverter(bufferedImage, type);
                this.converterDim = new Dimension(n, n2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                System.err.println(unsupportedOperationException.getMessage());
                unsupportedOperationException.printStackTrace();
            }
        }
        return this.outConverter;
    }

    public static void getSupportedCodecs(String string) {
        IContainerFormat iContainerFormat = IContainerFormat.make();
        iContainerFormat.setOutputFormat(string, null, null);
        List<ICodec.ID> list = iContainerFormat.getOutputCodecsSupported();
        if (list.isEmpty()) {
            System.out.println("no supported codecs for " + string);
        } else {
            System.out.println(String.valueOf(string) + " (" + iContainerFormat + ") supports following codecs:");
            for (ICodec.ID iD : list) {
                ICodec iCodec;
                if (iD == null || (iCodec = ICodec.findEncodingCodec(iD)) == null) continue;
                System.out.println(iCodec);
            }
        }
    }
}

