/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.NumberField;

public class DarkGhostFilter
extends Filter {
    protected int[] pixels;
    protected int[] values;
    private double fade;
    private double defaultFade = 0.05;
    private int w;
    private int h;
    private BufferedImage input;
    private BufferedImage output;
    private BufferedImage source;
    private Graphics2D gIn;
    private Inspector inspector;
    private JLabel fadeLabel;
    private NumberField fadeField;
    private JSlider fadeSlider;

    public DarkGhostFilter() {
        this.setFade(this.defaultFade);
        this.hasInspector = true;
    }

    public void setFade(double d) {
        Double d2 = new Double(this.fade);
        this.fade = Math.min(Math.abs(d), 1.0);
        this.support.firePropertyChange("fade", d2, new Double(d));
    }

    public double getFade() {
        return this.fade;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        super.setEnabled(bl);
        this.source = null;
    }

    @Override
    public BufferedImage getFilteredImage(BufferedImage bufferedImage) {
        if (!this.isEnabled()) {
            return bufferedImage;
        }
        if (bufferedImage != this.source) {
            this.initialize(bufferedImage);
        }
        if (bufferedImage != this.input) {
            this.gIn.drawImage((Image)this.source, 0, 0, null);
        }
        this.setOutputToGhost();
        return this.output;
    }

    @Override
    public JDialog getInspector() {
        Frame frame;
        if (this.inspector == null) {
            this.inspector = new Inspector();
        }
        if (this.inspector.isModal() && this.vidPanel != null && this.frame != (frame = JOptionPane.getFrameForComponent(this.vidPanel))) {
            this.frame = frame;
            if (this.inspector != null) {
                this.inspector.setVisible(false);
            }
            this.inspector = new Inspector();
        }
        this.inspector.initialize();
        return this.inspector;
    }

    @Override
    public void clear() {
        this.source = null;
        this.support.firePropertyChange("image", null, null);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.fadeLabel.setText(MediaRes.getString("Filter.DarkGhost.Label.Fade"));
        this.fadeSlider.setToolTipText(MediaRes.getString("Filter.DarkGhost.ToolTip.Fade"));
        if (this.inspector != null) {
            this.inspector.setTitle(MediaRes.getString("Filter.DarkGhost.Title"));
            this.inspector.pack();
        }
        boolean bl = this.isEnabled();
        this.fadeLabel.setEnabled(bl);
        this.fadeSlider.setEnabled(bl);
        this.fadeField.setEnabled(bl);
    }

    private void initialize(BufferedImage bufferedImage) {
        this.source = bufferedImage;
        this.w = this.source.getWidth();
        this.h = this.source.getHeight();
        this.pixels = new int[this.w * this.h];
        this.values = new int[this.w * this.h];
        if (this.source.getType() == 1) {
            this.input = this.source;
        } else {
            this.input = new BufferedImage(this.w, this.h, 1);
            this.gIn = this.input.createGraphics();
        }
        this.output = new BufferedImage(this.w, this.h, 1);
        this.output.createGraphics().drawImage((Image)this.source, 0, 0, null);
        this.output.getRaster().getDataElements(0, 0, this.w, this.h, this.pixels);
        int n = 0;
        while (n < this.values.length) {
            int n2 = this.pixels[n];
            int n3 = n2 >> 16 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            this.values[n] = (n3 + n4 + n5) / 3;
            ++n;
        }
    }

    private void setOutputToGhost() {
        this.input.getRaster().getDataElements(0, 0, this.w, this.h, this.pixels);
        int n = 0;
        while (n < this.pixels.length) {
            int n2 = (int)(255.0 - (1.0 - this.fade) * (double)(255 - this.values[n]));
            int n3 = this.pixels[n];
            int n4 = n3 >> 16 & 0xFF;
            int n5 = n3 >> 8 & 0xFF;
            int n6 = n3 & 0xFF;
            int n7 = (n4 + n5 + n6) / 3;
            if (n2 < n7) {
                this.pixels[n] = n2 << 16 | n2 << 8 | n2;
                this.values[n] = n2;
            } else {
                this.values[n] = n7;
            }
            ++n;
        }
        this.output.getRaster().setDataElements(0, 0, this.w, this.h, this.pixels);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private class Inspector
    extends JDialog {
        public Inspector() {
            super(DarkGhostFilter.this.frame, !(DarkGhostFilter.this.frame instanceof OSPFrame));
            this.setTitle(MediaRes.getString("Filter.DarkGhost.Title"));
            this.setResizable(false);
            this.createGUI();
            DarkGhostFilter.this.refresh();
            this.pack();
            Rectangle rectangle = this.getBounds();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - rectangle.width) / 2;
            int n2 = (dimension.height - rectangle.height) / 2;
            this.setLocation(n, n2);
        }

        void createGUI() {
            DarkGhostFilter.this.fadeLabel = new JLabel();
            DarkGhostFilter.this.fadeField = new DecimalField(4, 2);
            DarkGhostFilter.this.fadeField.setMaxValue(0.5);
            DarkGhostFilter.this.fadeField.setMinValue(0.0);
            DarkGhostFilter.this.fadeField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DarkGhostFilter.this.setFade(DarkGhostFilter.this.fadeField.getValue());
                    Inspector.this.updateDisplay();
                    DarkGhostFilter.this.fadeField.selectAll();
                }
            });
            DarkGhostFilter.this.fadeField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    DarkGhostFilter.this.fadeField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    DarkGhostFilter.this.setFade(DarkGhostFilter.this.fadeField.getValue());
                    Inspector.this.updateDisplay();
                }
            });
            DarkGhostFilter.this.fadeSlider = new JSlider(0, 0, 0);
            DarkGhostFilter.this.fadeSlider.setMaximum(50);
            DarkGhostFilter.this.fadeSlider.setMinimum(0);
            DarkGhostFilter.this.fadeSlider.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            DarkGhostFilter.this.fadeSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    int n = DarkGhostFilter.this.fadeSlider.getValue();
                    if (n != (int)(DarkGhostFilter.this.getFade() * 100.0)) {
                        DarkGhostFilter.this.setFade((double)n / 100.0);
                        Inspector.this.updateDisplay();
                    }
                }
            });
            GridBagLayout gridBagLayout = new GridBagLayout();
            JPanel jPanel = new JPanel(gridBagLayout);
            this.setContentPane(jPanel);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagLayout.setConstraints(DarkGhostFilter.this.fadeLabel, gridBagConstraints);
            jPanel.add(DarkGhostFilter.this.fadeLabel);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagLayout.setConstraints(DarkGhostFilter.this.fadeField, gridBagConstraints);
            jPanel.add(DarkGhostFilter.this.fadeField);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(DarkGhostFilter.this.fadeSlider, gridBagConstraints);
            jPanel.add(DarkGhostFilter.this.fadeSlider);
            JPanel jPanel2 = new JPanel(new FlowLayout());
            jPanel2.add(DarkGhostFilter.this.ableButton);
            jPanel2.add(DarkGhostFilter.this.clearButton);
            jPanel2.add(DarkGhostFilter.this.closeButton);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
        }

        void initialize() {
            this.updateDisplay();
        }

        void updateDisplay() {
            DarkGhostFilter.this.fadeField.setValue(DarkGhostFilter.this.getFade());
            DarkGhostFilter.this.fadeSlider.setValue((int)(100.0 * DarkGhostFilter.this.getFade()));
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            DarkGhostFilter darkGhostFilter = (DarkGhostFilter)object;
            xMLControl.setValue("fade", darkGhostFilter.getFade());
            if (darkGhostFilter.frame != null && darkGhostFilter.inspector != null && darkGhostFilter.inspector.isVisible()) {
                int n = ((DarkGhostFilter)darkGhostFilter).inspector.getLocation().x - darkGhostFilter.frame.getLocation().x;
                int n2 = ((DarkGhostFilter)darkGhostFilter).inspector.getLocation().y - darkGhostFilter.frame.getLocation().y;
                xMLControl.setValue("inspector_x", n);
                xMLControl.setValue("inspector_y", n2);
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new DarkGhostFilter();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            DarkGhostFilter darkGhostFilter = (DarkGhostFilter)object;
            if (xMLControl.getPropertyNames().contains("fade")) {
                darkGhostFilter.setFade(xMLControl.getDouble("fade"));
            }
            darkGhostFilter.inspectorX = xMLControl.getInt("inspector_x");
            darkGhostFilter.inspectorY = xMLControl.getInt("inspector_y");
            return object;
        }
    }
}

