/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker.deploy;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import java.io.File;
import java.util.List;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.deploy.OSPSocket;

public class OSXServices
implements AboutHandler,
QuitHandler,
PreferencesHandler,
OpenFilesHandler {
    Tracker tracker;
    OSPSocket socket;

    public OSXServices(Tracker tracker) {
        this.tracker = tracker;
        Application application = Application.getApplication();
        application.setDockIconImage(Tracker.getOSXDockImage());
        application.setAboutHandler((AboutHandler)this);
        application.setQuitHandler((QuitHandler)this);
        application.setPreferencesHandler((PreferencesHandler)this);
    }

    public OSXServices(OSPSocket oSPSocket) {
        this.socket = oSPSocket;
        Application application = Application.getApplication();
        application.setDockIconImage(Tracker.getOSXDockImage());
        application.setOpenFileHandler((OpenFilesHandler)this);
    }

    public void handleAbout(AppEvent.AboutEvent aboutEvent) {
        Tracker.showAboutTracker();
    }

    public void openFiles(AppEvent.OpenFilesEvent openFilesEvent) {
        if (this.socket != null) {
            List list = openFilesEvent.getFiles();
            String string = "open: ";
            String string2 = System.getProperty("path.separator");
            for (File file : list) {
                string = String.valueOf(string) + file.getAbsolutePath() + string2;
            }
            try {
                this.socket.send(string);
            }
            catch (Exception exception) {}
        }
    }

    public void handleQuitRequestWith(AppEvent.QuitEvent quitEvent, QuitResponse quitResponse) {
        TFrame tFrame;
        if (this.tracker != null && (tFrame = this.tracker.getFrame()) != null) {
            int n = 0;
            while (n < tFrame.getTabCount()) {
                try {
                    if (!tFrame.getTrackerPanel(n).save()) {
                        quitResponse.cancelQuit();
                    }
                }
                catch (Exception exception) {}
                ++n;
            }
        }
        quitResponse.performQuit();
    }

    public void handlePreferences(AppEvent.PreferencesEvent preferencesEvent) {
        if (this.tracker != null) {
            TFrame tFrame = this.tracker.getFrame();
            tFrame.showPrefsDialog();
        }
    }
}

