/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker.deploy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.JComponent;

public class OSPSocket
extends JComponent {
    public static final String READY = "ready";
    public static final String OPEN = "open: ";
    int portNumber;
    DataOutputStream os;
    DataInputStream is;
    boolean clientReady = false;
    boolean isServer = false;
    boolean terminated = false;

    public OSPSocket(int n, boolean bl) {
        this.portNumber = n;
        this.isServer = bl;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (OSPSocket.this.isServer) {
                        OSPSocket.this.createServer();
                    } else {
                        OSPSocket.this.createClient();
                    }
                }
                catch (Exception exception) {
                    OSPSocket.this.terminated = true;
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
    }

    public void send(String string) throws Exception {
        byte[] byArray = string.getBytes();
        this.os.write(byArray);
        this.os.flush();
    }

    private String receive() throws Exception {
        byte[] byArray = new byte[1024];
        this.is.read(byArray);
        return new String(byArray).trim();
    }

    private void createServer() throws Exception {
        ServerSocket serverSocket = new ServerSocket(this.portNumber);
        Socket socket = serverSocket.accept();
        this.os = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        this.is = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        while (!this.clientReady && !this.terminated) {
            Thread.sleep(100L);
            String string = this.receive();
            if (!READY.equals(string)) continue;
            this.clientReady = true;
        }
    }

    private void createClient() throws Exception {
        Socket socket = new Socket("localhost", this.portNumber);
        this.os = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        this.is = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.send(READY);
        while (!this.terminated) {
            Thread.sleep(100L);
            String string = this.receive();
            this.firePropertyChange("socket", null, string);
        }
    }
}

