/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensourcephysics.cabrillo.tracker.ArrowFootprint;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.VectorChain;
import org.opensourcephysics.cabrillo.tracker.VectorSum;
import org.opensourcephysics.cabrillo.tracker.WorldTView;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class VectorStep
extends Step
implements PropertyChangeListener {
    protected static boolean pointSnapEnabled = true;
    protected static boolean vectorSnapEnabled = true;
    protected static double snapDistance = 8.0;
    protected static Map<TrackerPanel, Set<VectorStep>> vectors = new HashMap<TrackerPanel, Set<VectorStep>>();
    protected static TPoint tipPoint = new TPoint();
    protected static TPoint tailPoint = new TPoint();
    protected TPoint tail;
    protected TPoint tip;
    protected TPoint middle;
    protected Handle handle;
    protected Hinge hinge;
    protected int dx;
    protected int dy;
    protected boolean tipEnabled = true;
    protected Map<TrackerPanel, Shape> tipShapes = new HashMap<TrackerPanel, Shape>();
    protected Map<TrackerPanel, Shape> shaftShapes = new HashMap<TrackerPanel, Shape>();
    protected TPoint attachmentPoint;
    protected VectorChain chain;
    protected boolean brandNew = true;
    protected boolean firePropertyChangeEvents = false;
    protected boolean labelVisible = true;
    protected boolean rolloverVisible = false;
    protected boolean valid;
    protected Map<TrackerPanel, TextLayout> textLayouts = new HashMap<TrackerPanel, TextLayout>();
    protected Map<TrackerPanel, Rectangle> layoutBounds = new HashMap<TrackerPanel, Rectangle>();

    public VectorStep(TTrack tTrack, int n, double d, double d2, double d3, double d4) {
        super(tTrack, n);
        this.tail = new Handle(d, d2);
        this.middle = new TPoint(d, d2){

            @Override
            public int getFrameNumber(VideoPanel videoPanel) {
                return VectorStep.this.n;
            }
        };
        this.tip = new Tip(d, d2);
        this.handle = new Handle(d, d2);
        this.handle.setStepEditTrigger(true);
        this.hinge = new Hinge(d, d2);
        this.points = new TPoint[]{this.tip, this.tail, this.handle, this.hinge, this.middle};
        this.screenPoints = new Point[VectorStep.getLength()];
        this.tip.setLocation(d + d3, d2 + d4);
    }

    public TPoint getTip() {
        return this.tip;
    }

    public TPoint getTail() {
        return this.tail;
    }

    public TPoint getHandle() {
        return this.handle;
    }

    public TPoint getHinge() {
        return this.hinge;
    }

    public void setXComponent(double d) {
        this.tip.setX(this.tail.getX() + d);
    }

    public void setYComponent(double d) {
        this.tip.setY(this.tail.getY() + d);
    }

    public void setXYComponents(double d, double d2) {
        this.tip.setXY(this.tail.getX() + d, this.tail.getY() + d2);
    }

    public double getXComponent() {
        return this.tip.getX() - this.tail.getX();
    }

    public double getYComponent() {
        return this.tip.getY() - this.tail.getY();
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean bl) {
        this.labelVisible = bl;
    }

    public boolean isRolloverVisible() {
        return this.rolloverVisible;
    }

    public void setRolloverVisible(boolean bl) {
        this.rolloverVisible = bl;
    }

    public static void setPointSnapEnabled(boolean bl) {
        pointSnapEnabled = bl;
    }

    public static boolean isPointSnapEnabled() {
        return pointSnapEnabled;
    }

    public static void setVectorSnapEnabled(boolean bl) {
        vectorSnapEnabled = bl;
    }

    public static boolean isVectorSnapEnabled() {
        return vectorSnapEnabled;
    }

    public void snap(TrackerPanel trackerPanel) {
        Set<VectorStep> set;
        TPoint tPoint = null;
        if (pointSnapEnabled) {
            if (this.track instanceof PointMass && (tPoint = ((PositionStep)this.track.getStep(this.n)).getPosition()).distance(this.tail) < snapDistance) {
                this.attach(tPoint);
                return;
            }
            tPoint = trackerPanel.getSnapPoint();
            set = trackerPanel.getAxes();
            if ((this.brandNew || set != null && ((TTrack)((Object)set)).isVisible()) && tPoint.distance(this.tail) < snapDistance) {
                this.attach(tPoint);
                return;
            }
        }
        if (vectorSnapEnabled) {
            if (this.getTrack() instanceof VectorSum) {
                return;
            }
            set = vectors.get(trackerPanel);
            if (set != null) {
                for (VectorStep vectorStep : set) {
                    if (!vectorStep.valid || !this.getTrack().isStepVisible(vectorStep, trackerPanel) || (tPoint = vectorStep.getHinge()).distance(this.tail) > snapDistance || vectorStep == this) continue;
                    VectorChain vectorChain = vectorStep.getChain();
                    if (vectorChain == null) {
                        vectorChain = new VectorChain(vectorStep);
                        vectorChain.add(this);
                        break;
                    }
                    if (vectorChain.getEnd() != vectorStep) continue;
                    vectorChain.add(this);
                    break;
                }
            }
        }
    }

    public VectorChain getChain() {
        return this.chain;
    }

    public void attach(TPoint tPoint) {
        if (this.attachmentPoint != null) {
            this.attachmentPoint.removePropertyChangeListener(this);
        }
        this.attachmentPoint = tPoint;
        if (tPoint == null) {
            return;
        }
        tPoint.addPropertyChangeListener(this);
        if (tPoint.getX() != this.tail.getX() || tPoint.getY() != this.tail.getY()) {
            this.tail.setXY(tPoint.getX(), tPoint.getY());
        }
    }

    public TPoint getAttachmentPoint() {
        return this.attachmentPoint;
    }

    public void setTipEnabled(boolean bl) {
        this.tipEnabled = bl;
    }

    public boolean isTipEnabled() {
        return this.tipEnabled;
    }

    @Override
    public void setFootprint(Footprint footprint) {
        if (footprint.getLength() >= 2) {
            super.setFootprint(footprint);
        }
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (drawingPanel instanceof TrackerPanel) {
            TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.brandNew && !(trackerPanel instanceof WorldTView)) {
                this.snap(trackerPanel);
                this.brandNew = false;
            }
            super.draw(trackerPanel, graphics2D);
            Set<VectorStep> set = vectors.get(trackerPanel);
            if (set == null) {
                set = new HashSet<VectorStep>();
                vectors.put(trackerPanel, set);
            }
            set.add(this);
            if (this.labelVisible) {
                TextLayout textLayout = this.textLayouts.get(trackerPanel);
                Point point = this.getLayoutPosition(trackerPanel, textLayout);
                Paint paint = graphics2D.getPaint();
                Font font = graphics2D.getFont();
                graphics2D.setPaint(this.footprint.getColor());
                graphics2D.setFont(textLayoutFont);
                textLayout.draw(graphics2D, point.x, point.y);
                graphics2D.setPaint(paint);
                graphics2D.setFont(font);
            }
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        this.setHitRectCenter(n, n2);
        Point point = trackerPanel.getSnapPoint().getScreenPosition(trackerPanel);
        if (hitRect.contains(point)) {
            return null;
        }
        Shape shape = this.shaftShapes.get(trackerPanel);
        if (shape != null && shape.intersects(hitRect)) {
            if (this.rolloverVisible && !this.labelVisible) {
                this.labelVisible = true;
                this.repaint();
            }
            if (!trackerPanel.mEvent.isAltDown() && !trackerPanel.mEvent.isShiftDown()) {
                return this.handle;
            }
        }
        if (this.tipEnabled && (shape = this.tipShapes.get(trackerPanel)) != null && shape.intersects(hitRect)) {
            return this.hinge;
        }
        if (this.rolloverVisible && this.labelVisible) {
            this.labelVisible = false;
            this.repaint();
        }
        return null;
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.marks.get(trackerPanel);
        TPoint tPoint = null;
        if (mark == null) {
            Shape[] shapeArray;
            Object object;
            TrackerPanel trackerPanel2;
            WorldTView worldTView;
            this.tip.setLocation(this.tip.getX(), this.tip.getY());
            this.middle.center(this.hinge, this.tail);
            tPoint = trackerPanel.getSelectedPoint();
            Point point = null;
            this.valid = true;
            int n = 0;
            while (n < this.points.length) {
                this.valid = this.valid && !Double.isNaN(this.points[n].getX()) && !Double.isNaN(this.points[n].getY());
                this.screenPoints[n] = this.points[n].getScreenPosition(trackerPanel);
                if (tPoint == this.points[n]) {
                    point = this.screenPoints[n];
                }
                ++n;
            }
            if (trackerPanel instanceof WorldTView && this.attachmentPoint == (worldTView = (WorldTView)trackerPanel).getSnapPoint()) {
                Point point2 = worldTView.getSnapPoint().getScreenPosition(worldTView);
                this.dx = point2.x - this.screenPoints[1].x;
                this.dy = point2.y - this.screenPoints[1].y;
                int n2 = 0;
                while (n2 < this.screenPoints.length) {
                    this.screenPoints[n2].x += this.dx;
                    this.screenPoints[n2].y += this.dy;
                    ++n2;
                }
                if (point != null) {
                    point.x += this.dx;
                    point.y += this.dy;
                }
            }
            if ((trackerPanel2 = trackerPanel) instanceof WorldTView) {
                trackerPanel2 = ((WorldTView)trackerPanel2).getTrackerPanel();
            }
            boolean bl = TToolBar.getToolbar((TrackerPanel)trackerPanel2).xMassButton.isSelected();
            String string = String.valueOf(this.track.getName()) + " ";
            if (this.track instanceof PointMass) {
                object = (PointMass)this.track;
                if (((PointMass)object).isVelocity(this)) {
                    string = bl ? String.valueOf(TrackerRes.getString("VectorStep.Label.Momentum")) + " " : String.valueOf(TrackerRes.getString("VectorStep.Label.Velocity")) + " ";
                } else if (((PointMass)object).isAcceleration(this)) {
                    String string2 = string = bl ? String.valueOf(TrackerRes.getString("VectorStep.Label.NetForce")) + " " : String.valueOf(TrackerRes.getString("VectorStep.Label.Acceleration")) + " ";
                }
            }
            if (((VideoClip)(object = trackerPanel.getPlayer().getVideoClip())).getStepCount() != 1) {
                string = String.valueOf(string) + ((VideoClip)object).frameToStep(this.getFrameNumber());
            }
            TextLayout textLayout = new TextLayout(string, textLayoutFont, frc);
            this.textLayouts.put(trackerPanel, textLayout);
            Point point3 = this.getLayoutPosition(trackerPanel, textLayout);
            Rectangle rectangle = this.layoutBounds.get(trackerPanel);
            if (rectangle == null) {
                rectangle = new Rectangle();
                this.layoutBounds.put(trackerPanel, rectangle);
            }
            Rectangle2D rectangle2D = textLayout.getBounds();
            rectangle.setRect(point3.x, (double)point3.y - rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
            mark = this.footprint.getMark(this.screenPoints);
            if (point != null) {
                transform.setToTranslation(point.x, point.y);
                int n3 = FontSizer.getIntegerFactor();
                if (n3 > 1) {
                    transform.scale(n3, n3);
                }
                shapeArray = this.footprint.getColor();
                final Mark mark2 = mark;
                Shape shape = transform.createTransformedShape(selectionShape);
                mark = new Mark((Color)shapeArray, shape){
                    private final /* synthetic */ Color val$color;
                    private final /* synthetic */ Shape val$selectedShape;
                    {
                        this.val$color = color;
                        this.val$selectedShape = shape;
                    }

                    @Override
                    public void draw(Graphics2D graphics2D, boolean bl) {
                        mark2.draw(graphics2D, bl);
                        Paint paint = graphics2D.getPaint();
                        graphics2D.setPaint(this.val$color);
                        graphics2D.fill(this.val$selectedShape);
                        graphics2D.setPaint(paint);
                    }

                    @Override
                    public Rectangle getBounds(boolean bl) {
                        Rectangle rectangle = this.val$selectedShape.getBounds();
                        rectangle.add(mark2.getBounds(false));
                        return rectangle;
                    }
                };
            }
            final Mark mark3 = mark;
            mark = new Mark(){

                @Override
                public void draw(Graphics2D graphics2D, boolean bl) {
                    if (!VectorStep.this.valid) {
                        return;
                    }
                    mark3.draw(graphics2D, bl);
                }

                @Override
                public Rectangle getBounds(boolean bl) {
                    return mark3.getBounds(bl);
                }
            };
            this.marks.put(trackerPanel, mark);
            if (this.valid) {
                shapeArray = this.footprint.getHitShapes();
                this.tipShapes.put(trackerPanel, shapeArray[0]);
                this.shaftShapes.put(trackerPanel, shapeArray[2]);
            }
        }
        return mark;
    }

    @Override
    public Rectangle getBounds(TrackerPanel trackerPanel) {
        Rectangle rectangle = this.getMark(trackerPanel).getBounds(false);
        rectangle.add(this.layoutBounds.get(trackerPanel));
        return rectangle;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.attachmentPoint) {
            this.tail.setXY(this.attachmentPoint.getX(), this.attachmentPoint.getY());
        }
    }

    public void setFirePropertyChangeEvents(boolean bl) {
        this.firePropertyChangeEvents = bl;
    }

    @Override
    public VectorStep clone() {
        VectorStep vectorStep = (VectorStep)super.clone();
        if (vectorStep != null) {
            TPoint[] tPointArray = vectorStep.points;
            VectorStep vectorStep2 = vectorStep;
            vectorStep2.getClass();
            tPointArray[0] = vectorStep.tip = vectorStep2.new Tip(this.tip.getX(), this.tip.getY());
            TPoint[] tPointArray2 = vectorStep.points;
            VectorStep vectorStep3 = vectorStep;
            vectorStep3.getClass();
            tPointArray2[1] = vectorStep.tail = vectorStep3.new Handle(this.tail.getX(), this.tail.getY());
            TPoint[] tPointArray3 = vectorStep.points;
            VectorStep vectorStep4 = vectorStep;
            vectorStep4.getClass();
            vectorStep.handle = vectorStep4.new Handle(this.handle.getX(), this.handle.getY());
            tPointArray3[2] = vectorStep.handle;
            TPoint[] tPointArray4 = vectorStep.points;
            VectorStep vectorStep5 = vectorStep;
            vectorStep5.getClass();
            vectorStep.hinge = vectorStep5.new Hinge(this.hinge.getX(), this.hinge.getY());
            tPointArray4[3] = vectorStep.hinge;
            vectorStep.points[4] = vectorStep.middle = new TPoint(this.middle.getX(), this.middle.getY()){

                @Override
                public int getFrameNumber(VideoPanel videoPanel) {
                    return VectorStep.this.n;
                }
            };
            vectorStep.tipShapes = new HashMap<TrackerPanel, Shape>();
            vectorStep.shaftShapes = new HashMap<TrackerPanel, Shape>();
            vectorStep.textLayouts = new HashMap<TrackerPanel, TextLayout>();
            vectorStep.layoutBounds = new HashMap<TrackerPanel, Rectangle>();
            vectorStep.setFirePropertyChangeEvents(this.firePropertyChangeEvents);
        }
        return vectorStep;
    }

    @Override
    public String toString() {
        return "VectorStep " + this.n + " [" + format.format(this.tail.x) + ", " + format.format(this.tail.y) + ", " + format.format(this.getXComponent()) + ", " + format.format(this.getYComponent()) + "]";
    }

    private Point getLayoutPosition(TrackerPanel trackerPanel, TextLayout textLayout) {
        Point point = this.middle.getScreenPosition(trackerPanel);
        if (trackerPanel instanceof WorldTView && this.attachmentPoint == ((WorldTView)trackerPanel).getSnapPoint()) {
            point.x += this.dx;
            point.y += this.dy;
        }
        Rectangle2D rectangle2D = textLayout.getBounds();
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        tipPoint.setLocation(this.tip);
        tailPoint.setLocation(this.tail);
        if (!trackerPanel.isDrawingInImageSpace()) {
            AffineTransform affineTransform = trackerPanel.getCoords().getToWorldTransform(this.n);
            affineTransform.transform(tipPoint, tipPoint);
            VectorStep.tipPoint.y = -VectorStep.tipPoint.y;
            affineTransform.transform(tailPoint, tailPoint);
            VectorStep.tailPoint.y = -VectorStep.tailPoint.y;
        }
        double d3 = tailPoint.cos(tipPoint);
        double d4 = tailPoint.sin(tipPoint);
        double d5 = 4.0 + Math.abs(d * d4 / 2.0) + Math.abs(d2 * d3 / 2.0);
        if (d3 >= 0.0) {
            point.setLocation((int)((double)point.x - d5 * d4 - d / 2.0), (int)((double)point.y - d5 * d3 + d2 / 2.0));
        } else {
            point.setLocation((int)((double)point.x + d5 * d4 - d / 2.0), (int)((double)point.y + d5 * d3 + d2 / 2.0));
        }
        return point;
    }

    public static int getLength() {
        return 5;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    class Handle
    extends Step.Handle {
        public Handle(double d, double d2) {
            super(VectorStep.this, d, d2);
            this.setStepEditTrigger(true);
        }

        @Override
        public void setXY(double d, double d2) {
            double d3 = d - this.getX();
            double d4 = d2 - this.getY();
            VectorStep.this.tail.setLocation(VectorStep.this.tail.getX() + d3, VectorStep.this.tail.getY() + d4);
            VectorStep.this.tip.setLocation(VectorStep.this.tip.getX() + d3, VectorStep.this.tip.getY() + d4);
            this.setLocation(d, d2);
            if (VectorStep.this.attachmentPoint != null && VectorStep.this.attachmentPoint.distance(VectorStep.this.tail) > 1.0) {
                if (VectorStep.this.chain != null && VectorStep.this.attachmentPoint instanceof Hinge) {
                    VectorStep.this.chain.breakAt(VectorStep.this);
                } else {
                    VectorStep.this.attach(null);
                }
            }
            if (VectorStep.this.firePropertyChangeEvents) {
                VectorStep.this.track.support.firePropertyChange("step", null, new Integer(VectorStep.this.n));
            }
            VectorStep.this.repaint();
        }

        @Override
        public int getFrameNumber(VideoPanel videoPanel) {
            return VectorStep.this.n;
        }

        @Override
        public void showCoordinates(VideoPanel videoPanel) {
            VectorStep.this.tip.showCoordinates(videoPanel);
            super.showCoordinates(videoPanel);
        }

        public void snap(TrackerPanel trackerPanel) {
            VectorStep.this.snap(trackerPanel);
        }

        @Override
        public void setPositionOnLine(int n, int n2, TrackerPanel trackerPanel) {
            this.setPositionOnLine(n, n2, trackerPanel, VectorStep.this.hinge, VectorStep.this.tail);
            VectorStep.this.repaint();
        }

        public boolean isShort() {
            return VectorStep.this.tip.distanceSq(VectorStep.this.tail) < 25.0;
        }
    }

    class Hinge
    extends TPoint {
        public Hinge(double d, double d2) {
            super(d, d2);
            this.setStepEditTrigger(true);
        }

        @Override
        public void showCoordinates(VideoPanel videoPanel) {
            VectorStep.this.tip.showCoordinates(videoPanel);
            super.showCoordinates(videoPanel);
        }

        public VectorStep getStep() {
            return VectorStep.this;
        }

        public void setHingeLocation() {
            double d = 1.0;
            if (VectorStep.this.footprint instanceof ArrowFootprint) {
                ArrowFootprint arrowFootprint = (ArrowFootprint)VectorStep.this.footprint;
                d = arrowFootprint.getStretch();
            }
            double d2 = VectorStep.this.getTail().getX() + d * (VectorStep.this.getTip().getX() - VectorStep.this.getTail().getX());
            double d3 = VectorStep.this.getTail().getY() + d * (VectorStep.this.getTip().getY() - VectorStep.this.getTail().getY());
            this.setLocation(d2, d3);
        }

        @Override
        public void setXY(double d, double d2) {
            double d3 = 1.0;
            if (VectorStep.this.footprint instanceof ArrowFootprint) {
                ArrowFootprint arrowFootprint = (ArrowFootprint)VectorStep.this.footprint;
                d3 = arrowFootprint.getStretch();
            }
            double d4 = VectorStep.this.getTail().getX() + (d - VectorStep.this.getTail().getX()) / d3;
            double d5 = VectorStep.this.getTail().getY() + (d2 - VectorStep.this.getTail().getY()) / d3;
            VectorStep.this.tip.setXY(d4, d5);
        }

        @Override
        public void setLocation(double d, double d2) {
            int n;
            super.setLocation(d, d2);
            VectorChain vectorChain = VectorStep.this.chain;
            if (vectorChain != null && (n = vectorChain.indexOf(VectorStep.this)) < vectorChain.size() - 1) {
                VectorStep vectorStep = (VectorStep)vectorChain.get(n + 1);
                vectorStep.getTail().setXY(d, d2);
                return;
            }
        }

        @Override
        public int getFrameNumber(VideoPanel videoPanel) {
            return VectorStep.this.n;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            boolean bl;
            VectorStep vectorStep = (VectorStep)object;
            boolean bl2 = bl = vectorStep.attachmentPoint != null;
            if (bl) {
                xMLControl.setValue("snap", bl);
            }
            xMLControl.setValue("xtail", vectorStep.getTail().x);
            xMLControl.setValue("ytail", vectorStep.getTail().y);
            if (!vectorStep.getTrack().isDependent() && !(vectorStep.getTrack() instanceof PointMass)) {
                xMLControl.setValue("xtip", vectorStep.getTip().x);
                xMLControl.setValue("ytip", vectorStep.getTip().y);
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            VectorStep vectorStep = (VectorStep)object;
            double d = xMLControl.getDouble("xtail");
            double d2 = xMLControl.getDouble("ytail");
            vectorStep.getTail().setXY(d, d2);
            if (!vectorStep.getTrack().isDependent() && !(vectorStep.getTrack() instanceof PointMass)) {
                d = xMLControl.getDouble("xtip");
                d2 = xMLControl.getDouble("ytip");
                vectorStep.getTip().setXY(d, d2);
            }
            if (xMLControl.getBoolean("snap")) {
                vectorStep.snap(vectorStep.getTrack().trackerPanel);
            }
            return object;
        }
    }

    class Tip
    extends TPoint {
        public Tip(double d, double d2) {
            super(d, d2);
        }

        @Override
        public void setLocation(double d, double d2) {
            super.setLocation(d, d2);
            VectorStep.this.hinge.setHingeLocation();
        }

        @Override
        public void setXY(double d, double d2) {
            if (VectorStep.this.track.isLocked()) {
                return;
            }
            super.setXY(d, d2);
            if (VectorStep.this.firePropertyChangeEvents) {
                VectorStep.this.track.support.firePropertyChange("step", null, new Integer(VectorStep.this.n));
            }
            VectorStep.this.repaint();
        }

        @Override
        public void showCoordinates(VideoPanel videoPanel) {
            videoPanel.hideMouseBox();
            ImageCoordSystem imageCoordSystem = videoPanel.getCoords();
            double d = imageCoordSystem.imageToWorldXComponent(VectorStep.this.n, VectorStep.this.getXComponent(), VectorStep.this.getYComponent());
            double d2 = imageCoordSystem.imageToWorldYComponent(VectorStep.this.n, VectorStep.this.getXComponent(), VectorStep.this.getYComponent());
            if (VectorStep.this.track instanceof PointMass) {
                TrackerPanel trackerPanel = (TrackerPanel)videoPanel;
                PointMass pointMass = (PointMass)VectorStep.this.track;
                if (pointMass.isVelocity(VectorStep.this)) {
                    double d3 = videoPanel.getPlayer().getStepTime(1) / 1000.0;
                    d /= d3;
                    d2 /= d3;
                } else if (pointMass.isAcceleration(VectorStep.this)) {
                    double d4 = videoPanel.getPlayer().getStepTime(1) / 1000.0;
                    d /= d4 * d4;
                    d2 /= d4 * d4;
                }
                if (TToolBar.getToolbar((TrackerPanel)trackerPanel).xMassButton.isSelected()) {
                    d = pointMass.getMass() * d;
                    d2 = pointMass.getMass() * d2;
                }
            }
            VectorStep.this.track.xField.setValue(d);
            VectorStep.this.track.yField.setValue(d2);
            VectorStep.this.track.magField.setValue(Math.sqrt(d * d + d2 * d2));
            double d5 = Math.atan2(d2, d);
            VectorStep.this.track.angleField.setValue(d5);
            super.showCoordinates(videoPanel);
        }

        @Override
        public int getFrameNumber(VideoPanel videoPanel) {
            return VectorStep.this.n;
        }
    }
}

