/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import org.opensourcephysics.cabrillo.tracker.ArrowFootprint;
import org.opensourcephysics.cabrillo.tracker.AttachmentDialog;
import org.opensourcephysics.cabrillo.tracker.AutoTracker;
import org.opensourcephysics.cabrillo.tracker.Calibration;
import org.opensourcephysics.cabrillo.tracker.CenterOfMass;
import org.opensourcephysics.cabrillo.tracker.Configuration;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.DerivativeAlgorithmDialog;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.LineProfile;
import org.opensourcephysics.cabrillo.tracker.LineProfileStep;
import org.opensourcephysics.cabrillo.tracker.MainTView;
import org.opensourcephysics.cabrillo.tracker.ModelBuilder;
import org.opensourcephysics.cabrillo.tracker.OffsetOrigin;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrack;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PerspectiveTrack;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.RGBRegion;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.StepSet;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMat;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TTrackBar;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.TrackControl;
import org.opensourcephysics.cabrillo.tracker.TrackDataBuilder;
import org.opensourcephysics.cabrillo.tracker.TrackProperties;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.cabrillo.tracker.VectorStep;
import org.opensourcephysics.cabrillo.tracker.VectorSum;
import org.opensourcephysics.cabrillo.tracker.WorldGrid;
import org.opensourcephysics.cabrillo.tracker.WorldTView;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLPropertyElement;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.DataTrack;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.FilterStack;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.PerspectiveFilter;
import org.opensourcephysics.media.core.SumFilter;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoGrabber;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.DataFunctionPanel;
import org.opensourcephysics.tools.DataRefreshTool;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.VideoCaptureTool;

public class TrackerPanel
extends VideoPanel
implements Scrollable {
    public static final double MIN_ZOOM = 0.15;
    public static final double MAX_ZOOM = 12.0;
    public static final double ZOOM_STEP = Math.pow(2.0, 0.16666666666666666);
    public static final double[] ZOOM_LEVELS = new double[]{0.25, 0.5, 1.0, 2.0, 4.0, 8.0};
    public static final String STICK = "Stick";
    public static final String TAPE = "CalibrationTapeMeasure";
    public static final String CALIBRATION = "Calibration";
    public static final String OFFSET = "OffsetOrigin";
    protected static String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    protected double defaultImageBorder;
    protected String description = "";
    protected TPoint selectedPoint;
    protected Step selectedStep;
    protected TrackerPanel selectingPanel;
    protected TTrack selectedTrack;
    protected Rectangle dirty;
    protected AffineTransform prevPixelTransform;
    protected double zoom = 1.0;
    protected JScrollPane scrollPane;
    protected JPopupMenu popup;
    protected Set<String> enabled;
    protected TPoint snapPoint;
    protected TFrame frame;
    protected BufferedImage renderedImage;
    protected BufferedImage matImage;
    protected XMLControl currentState;
    protected XMLControl currentCoords;
    protected XMLControl currentSteps;
    protected TPoint pointState = new TPoint();
    protected MouseEvent mEvent;
    protected JLabel badNameLabel = new JLabel();
    protected TrackDataBuilder dataBuilder;
    protected boolean dataToolVisible;
    protected XMLProperty viewsProperty;
    protected XMLProperty selectedViewsProperty;
    protected double[] dividerLocs;
    protected Point zoomCenter;
    protected Map<Filter, Point> visibleFilters;
    protected int trackControlX = Integer.MIN_VALUE;
    protected int trackControlY;
    protected int infoX = Integer.MIN_VALUE;
    protected int infoY;
    protected JPanel noData = new JPanel();
    protected JLabel[] noDataLabels = new JLabel[2];
    protected boolean isEmpty;
    protected String defaultSavePath;
    protected String openedFromPath;
    protected ModelBuilder modelBuilder;
    protected TrackControl trackControl;
    protected boolean isModelBuilderVisible;
    protected boolean isShiftKeyDown;
    protected boolean isControlKeyDown;
    protected ArrayList<TTrack> calibrationTools = new ArrayList();
    protected Set<TTrack> visibleTools = new HashSet<TTrack>();
    protected String author;
    protected String contact;
    protected AutoTracker autoTracker;
    protected DerivativeAlgorithmDialog algorithmDialog;
    protected AttachmentDialog attachmentDialog;
    protected boolean isAutoRefresh = true;
    protected TreeSet<String> supplementalFilePaths = new TreeSet();
    protected Map<String, String> pageViewFilePaths = new HashMap<String, String>();
    protected StepSet selectedSteps = new StepSet(this);
    protected ActionListener worldDataRefresher;
    protected boolean hideDescriptionWhenLoaded;

    public TrackerPanel() {
        this((Video)null);
    }

    public TrackerPanel(Video video) {
        super(video);
        this.popup = new JPopupMenu(){

            @Override
            public void setVisible(boolean bl) {
                super.setVisible(bl);
                if (!bl) {
                    TrackerPanel.this.zoomBox.hide();
                }
            }
        };
        this.zoomBox.setShowUndraggedBox(false);
        this.removeMouseListener(this.mouseController);
        this.removeMouseMotionListener(this.mouseController);
        this.mouseController = new TMouseController();
        this.addMouseListener(this.mouseController);
        this.addMouseMotionListener(this.mouseController);
        this.badNameLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        Box box = Box.createVerticalBox();
        this.noData.add(box);
        Font font = new JTextField().getFont();
        int n = 0;
        while (n < 2) {
            this.noDataLabels[n] = new JLabel();
            this.noDataLabels[n].setFont(font);
            this.noDataLabels[n].setAlignmentX(0.5f);
            box.add(this.noDataLabels[n]);
            ++n;
        }
        this.noData.setOpaque(false);
        this.player.setInspectorButtonVisible(false);
        this.player.addPropertyChangeListener("stepbutton", this);
        this.player.addPropertyChangeListener("backbutton", this);
        this.player.addPropertyChangeListener("inframe", this);
        this.player.addPropertyChangeListener("outframe", this);
        this.player.addPropertyChangeListener("slider", this);
        this.player.addPropertyChangeListener("playing", this);
        this.configure();
    }

    @Override
    public void setVideo(Video video) {
        PropertyChangeListener propertyChangeListener;
        XMLControlElement xMLControlElement = null;
        boolean bl = true;
        if (this.getVideo() instanceof ImageVideo) {
            propertyChangeListener = (ImageVideo)this.getVideo();
            ((ImageVideo)propertyChangeListener).saveInvalidImages();
            bl = ((ImageVideo)propertyChangeListener).isFileBased();
        }
        if (video != this.getVideo() && bl) {
            xMLControlElement = new XMLControlElement(this.getPlayer().getVideoClip());
        }
        super.setVideo(video, true);
        if (xMLControlElement != null) {
            Undo.postVideoReplace(this, xMLControlElement);
        }
        if ((propertyChangeListener = this.getMat()) != null) {
            ((TMat)propertyChangeListener).refresh();
        }
        if (this.modelBuilder != null) {
            this.modelBuilder.refreshSpinners();
        }
        this.firePropertyChange("image", null, null);
    }

    public String getTitle() {
        String string;
        if (this.getDataFile() != null) {
            return this.getDataFile().getName();
        }
        if (this.defaultFileName != null) {
            return this.defaultFileName;
        }
        if (this.getVideo() != null && (string = (String)this.getVideo().getProperty("name")) != null) {
            int n = (string = XML.forwardSlash(string)).lastIndexOf("/");
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            return string;
        }
        return TrackerRes.getString("TrackerPanel.NewTab.Name");
    }

    public String getToolTipPath() {
        String string;
        if (this.getDataFile() != null) {
            return XML.forwardSlash(this.getDataFile().getPath());
        }
        if (this.getVideo() != null && (string = (String)this.getVideo().getProperty("absolutePath")) != null) {
            return XML.forwardSlash(string);
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        if (string == null) {
            string = "";
        }
        this.description = string;
    }

    public ModelBuilder getModelBuilder() {
        if (this.modelBuilder == null) {
            this.modelBuilder = new ModelBuilder(this);
            this.modelBuilder.setFontLevel(FontSizer.getLevel());
            this.modelBuilder.refreshLayout();
            this.modelBuilder.addPropertyChangeListener("panel", this);
            try {
                Point point = this.getLocationOnScreen();
                TFrame tFrame = this.getTFrame();
                if (tFrame != null) {
                    MainTView mainTView = tFrame.getMainView(this);
                    point = mainTView.getLocationOnScreen();
                }
                this.modelBuilder.setLocation(point.x + 160, point.y);
            }
            catch (Exception exception) {}
        }
        return this.modelBuilder;
    }

    public void addDirtyRegion(Rectangle rectangle) {
        if (this.dirty == null) {
            this.dirty = rectangle;
        } else if (rectangle != null) {
            this.dirty.add(rectangle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintDirtyRegion() {
        if (this.dirty != null) {
            Rectangle rectangle = this.dirty;
            synchronized (rectangle) {
                this.dirty.grow(2, 2);
                this.repaint(this.dirty);
            }
            this.dirty = null;
        }
    }

    public ArrayList<TTrack> getTracks() {
        return this.getDrawables(TTrack.class);
    }

    public ArrayList<TTrack> getUserTracks() {
        ArrayList<TTrack> arrayList = this.getTracks();
        arrayList.remove(this.getAxes());
        arrayList.removeAll(this.calibrationTools);
        ArrayList<PerspectiveTrack> arrayList2 = this.getDrawables(PerspectiveTrack.class);
        arrayList.removeAll(arrayList2);
        return arrayList;
    }

    public TTrack getTrack(String string) {
        for (TTrack tTrack : this.getTracks()) {
            if (!tTrack.getName().equals(string)) continue;
            return tTrack;
        }
        return null;
    }

    public synchronized void addTrack(TTrack tTrack) {
        Object object;
        if (tTrack == null) {
            return;
        }
        if (tTrack.trackerPanel == null) {
            tTrack.setTrackerPanel(this);
        }
        boolean bl = true;
        if (this.getTFrame() != null) {
            tTrack.setAnglesInRadians(this.getTFrame().anglesInRadians);
        }
        if (tTrack instanceof CoordAxes) {
            TMat tMat;
            bl = false;
            if (this.getAxes() != null) {
                this.removeDrawable(this.getAxes());
            }
            super.addDrawable(tTrack);
            this.moveToBack(tTrack);
            object = this.getGrid();
            if (object != null) {
                this.moveToBack((Drawable)object);
            }
            if ((tMat = this.getMat()) != null) {
                this.moveToBack(tMat);
            }
        } else if (this.calibrationTools.contains(tTrack)) {
            bl = false;
            super.addDrawable(tTrack);
        } else if (tTrack instanceof TapeMeasure && !((TapeMeasure)tTrack).isReadOnly()) {
            bl = false;
            this.calibrationTools.add(tTrack);
            this.visibleTools.add(tTrack);
            super.addDrawable(tTrack);
        } else if (tTrack instanceof OffsetOrigin || tTrack instanceof Calibration) {
            bl = false;
            this.calibrationTools.add(tTrack);
            this.visibleTools.add(tTrack);
            super.addDrawable(tTrack);
        } else {
            this.setTrackName(tTrack, tTrack.getName(), false);
            super.addDrawable(tTrack);
        }
        this.addPropertyChangeListener(tTrack);
        tTrack.addPropertyChangeListener("step", this);
        tTrack.addPropertyChangeListener("steps", this);
        tTrack.addPropertyChangeListener("name", this);
        tTrack.addPropertyChangeListener("mass", this);
        tTrack.addPropertyChangeListener("footprint", this);
        tTrack.addPropertyChangeListener("model_start", this);
        tTrack.addPropertyChangeListener("model_end", this);
        if (this.trackControl != null && this.trackControl.isVisible()) {
            this.trackControl.refresh();
        }
        if (this.getDataBuilder() != null && !this.getSystemDrawables().contains(tTrack)) {
            object = this.createFunctionPanel(tTrack);
            this.dataBuilder.addPanel(tTrack.getName(), (FunctionPanel)object);
            this.dataBuilder.setSelectedPanel(tTrack.getName());
        }
        int n = tTrack.getSteps().length;
        n = Math.max(n, this.getCoords().getLength());
        this.getCoords().setLength(n);
        tTrack.setFontLevel(FontSizer.getLevel());
        this.firePropertyChange("track", null, tTrack);
        this.changed = true;
        if (bl && this.getTFrame() != null) {
            TrackControl.getControl(this).setVisible(true);
        }
        if (this.autoTracker != null) {
            this.autoTracker.setTrack(tTrack);
        }
    }

    private FunctionPanel createFunctionPanel(TTrack tTrack) {
        DatasetManager datasetManager = tTrack.getData(this);
        DataFunctionPanel dataFunctionPanel = new DataFunctionPanel(datasetManager);
        dataFunctionPanel.setIcon(tTrack.getFootprint().getIcon(21, 16));
        Class<?> clazz = tTrack.getClass();
        if (PointMass.class.isAssignableFrom(clazz)) {
            dataFunctionPanel.setDescription(PointMass.class.getName());
        } else if (Vector.class.isAssignableFrom(clazz)) {
            dataFunctionPanel.setDescription(Vector.class.getName());
        } else if (RGBRegion.class.isAssignableFrom(clazz)) {
            dataFunctionPanel.setDescription(RGBRegion.class.getName());
        } else if (LineProfile.class.isAssignableFrom(clazz)) {
            dataFunctionPanel.setDescription(LineProfile.class.getName());
        } else {
            dataFunctionPanel.setDescription(clazz.getName());
        }
        final ParamEditor paramEditor = dataFunctionPanel.getParamEditor();
        if (tTrack instanceof PointMass) {
            final PointMass pointMass = (PointMass)tTrack;
            Parameter parameter = (Parameter)paramEditor.getObject("m");
            if (parameter == null) {
                parameter = new Parameter("m", String.valueOf(pointMass.getMass()));
                parameter.setDescription(TrackerRes.getString("ParticleModel.Parameter.Mass.Description"));
                paramEditor.addObject(parameter, false);
            }
            parameter.setNameEditable(false);
            paramEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("m".equals(propertyChangeEvent.getOldValue())) {
                        Parameter parameter = (Parameter)paramEditor.getObject("m");
                        if (pointMass.getMass() != parameter.getValue()) {
                            pointMass.setMass(parameter.getValue());
                            pointMass.massField.setValue(pointMass.getMass());
                        }
                    }
                }
            });
            pointMass.addPropertyChangeListener("mass", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Parameter parameter = (Parameter)paramEditor.getObject("m");
                    double d = (Double)propertyChangeEvent.getNewValue();
                    if (d != parameter.getValue()) {
                        paramEditor.setExpression("m", String.valueOf(d), false);
                    }
                }
            });
        }
        return dataFunctionPanel;
    }

    public synchronized void removeTrack(TTrack tTrack) {
        if (!this.getDrawables(tTrack.getClass()).contains(tTrack)) {
            return;
        }
        this.removePropertyChangeListener(tTrack);
        tTrack.removePropertyChangeListener("step", this);
        tTrack.removePropertyChangeListener("steps", this);
        tTrack.removePropertyChangeListener("name", this);
        tTrack.removePropertyChangeListener("mass", this);
        tTrack.removePropertyChangeListener("footprint", this);
        tTrack.removePropertyChangeListener("model_start", this);
        tTrack.removePropertyChangeListener("model_end", this);
        super.removeDrawable(tTrack);
        if (this.dataBuilder != null) {
            this.dataBuilder.removePanel(tTrack.getName());
        }
        if (this.modelBuilder != null) {
            this.modelBuilder.removePanel(tTrack.getName());
        }
        if (this.getSelectedTrack() == tTrack) {
            this.setSelectedTrack(null);
        }
        this.firePropertyChange("track", tTrack, null);
        this.changed = true;
    }

    public boolean containsTrack(TTrack tTrack) {
        for (TTrack tTrack2 : this.getTracks()) {
            if (tTrack != tTrack2) continue;
            return true;
        }
        return false;
    }

    public void eraseAll() {
        for (TTrack tTrack : this.getTracks()) {
            tTrack.erase();
        }
    }

    public boolean save() {
        int n;
        if (!this.changed) {
            return true;
        }
        if (OSPRuntime.applet != null) {
            return true;
        }
        String string = this.getTitle();
        if (this.getDataFile() == null && (n = string.lastIndexOf(46)) > 0) {
            string = string.substring(0, n);
        }
        if ((n = JOptionPane.showConfirmDialog(this.getTopLevelAncestor(), String.valueOf(TrackerRes.getString("TrackerPanel.Dialog.SaveChanges.Message")) + " \"" + string + "\"?", TrackerRes.getString("TrackerPanel.Dialog.SaveChanges.Title"), 1, 3)) == 0) {
            this.restoreViews();
            File file = VideoIO.save(this.getDataFile(), this);
            if (file == null) {
                return false;
            }
        } else if (n == -1 || n == 2) {
            return false;
        }
        this.changed = false;
        return true;
    }

    @Override
    public ArrayList<Drawable> getDrawables() {
        TMat tMat;
        ArrayList<Drawable> arrayList = super.getDrawables();
        TTrack tTrack = this.getSelectedTrack();
        if (tTrack != null && arrayList.contains(tTrack) && tTrack != this.getAxes()) {
            arrayList.remove(tTrack);
            arrayList.add(tTrack);
        }
        if ((tMat = this.getMat()) != null && arrayList.get(0) != tMat) {
            arrayList.remove(tMat);
            arrayList.add(0, tMat);
        }
        if (this.getVideo() == null && this.getUserTracks().isEmpty()) {
            this.isEmpty = true;
            if (this instanceof WorldTView) {
                this.noDataLabels[0].setText(TrackerRes.getString("WorldTView.Label.NoData"));
                this.noDataLabels[1].setText(null);
            } else {
                this.noDataLabels[0].setText(TrackerRes.getString("TrackerPanel.Message.NoData0"));
                this.noDataLabels[1].setText(TrackerRes.getString("TrackerPanel.Message.NoData1"));
            }
            this.add((Component)this.noData, "North");
        } else {
            this.isEmpty = false;
            this.remove(this.noData);
        }
        return arrayList;
    }

    public ArrayList<Drawable> getSystemDrawables() {
        ArrayList<Drawable> arrayList = new ArrayList<Drawable>();
        Trackable trackable = this.getMat();
        if (trackable != null) {
            arrayList.add(trackable);
        }
        if ((trackable = this.getAxes()) != null) {
            arrayList.add(trackable);
        }
        for (TTrack tTrack : this.calibrationTools) {
            arrayList.add(tTrack);
        }
        return arrayList;
    }

    @Override
    public synchronized void addDrawable(Drawable drawable) {
        if (drawable instanceof TTrack) {
            this.addTrack((TTrack)drawable);
        } else {
            super.addDrawable(drawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveToBack(Drawable drawable) {
        if (drawable != null && this.drawableList.contains(drawable)) {
            ArrayList arrayList = this.drawableList;
            synchronized (arrayList) {
                this.drawableList.remove(drawable);
                if (drawable instanceof TMat) {
                    this.drawableList.add(0, drawable);
                } else {
                    int n;
                    int n2 = n = this.getMat() == null ? 0 : 1;
                    if (this.getVideo() != null) {
                        ++n;
                    }
                    this.drawableList.add(n, drawable);
                }
            }
        }
    }

    @Override
    public synchronized void removeDrawable(Drawable drawable) {
        if (drawable instanceof TTrack) {
            this.removeTrack((TTrack)drawable);
        } else {
            super.removeDrawable(drawable);
        }
    }

    @Override
    public synchronized <T extends Drawable> void removeObjectsOfClass(Class<T> clazz) {
        if (TTrack.class.isAssignableFrom(clazz)) {
            for (TTrack tTrack : this.getObjectOfClass(clazz)) {
                this.removePropertyChangeListener(tTrack);
                tTrack.removePropertyChangeListener("step", this);
                tTrack.removePropertyChangeListener("steps", this);
                tTrack.removePropertyChangeListener("name", this);
                tTrack.removePropertyChangeListener("mass", this);
                tTrack.removePropertyChangeListener("footprint", this);
                tTrack.removePropertyChangeListener("model_start", this);
                tTrack.removePropertyChangeListener("model_end", this);
                this.getTFrame().removePropertyChangeListener("tab", tTrack);
            }
            super.removeObjectsOfClass(clazz);
            this.firePropertyChange("track", null, null);
            this.changed = true;
        } else {
            super.removeObjectsOfClass(clazz);
        }
    }

    @Override
    public synchronized void clear() {
        for (TTrack tTrack : this.getTracks()) {
            tTrack.cleanup();
            this.removePropertyChangeListener(tTrack);
            tTrack.removePropertyChangeListener("step", this);
            tTrack.removePropertyChangeListener("steps", this);
            tTrack.removePropertyChangeListener("name", this);
            tTrack.removePropertyChangeListener("mass", this);
            tTrack.removePropertyChangeListener("footprint", this);
            tTrack.removePropertyChangeListener("model_start", this);
            tTrack.removePropertyChangeListener("model_end", this);
            ImageCoordSystem imageCoordSystem = this.getCoords();
            if (!(imageCoordSystem instanceof ReferenceFrame) || ((ReferenceFrame)imageCoordSystem).getOriginTrack() != tTrack) continue;
            imageCoordSystem = ((ReferenceFrame)imageCoordSystem).getCoords();
            this.setCoords(imageCoordSystem);
        }
        super.clear();
        if (this.dataBuilder != null) {
            this.dataBuilder.clearPanels();
            this.dataBuilder.setVisible(false);
        }
        if (this.modelBuilder != null) {
            this.modelBuilder.clearPanels();
            this.modelBuilder.setVisible(false);
        }
        this.firePropertyChange("track", null, null);
        this.changed = true;
    }

    public synchronized void clearTracks() {
        ArrayList<Drawable> arrayList = this.getSystemDrawables();
        this.clear();
        for (Drawable drawable : arrayList) {
            this.addDrawable(drawable);
        }
    }

    @Override
    public void setCoords(ImageCoordSystem imageCoordSystem) {
        if (imageCoordSystem == null || imageCoordSystem == this.coords) {
            return;
        }
        if (this.video == null) {
            this.coords.removePropertyChangeListener(this);
            this.coords = imageCoordSystem;
            this.coords.addPropertyChangeListener(this);
            int n = this.getFrameNumber();
            this.getSnapPoint().setXY(this.coords.getOriginX(n), this.coords.getOriginY(n));
            this.firePropertyChange("coords", null, this.coords);
            this.firePropertyChange("transform", null, null);
        } else {
            this.video.setCoords(imageCoordSystem);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setReferenceFrame(String string) {
        PointMass object2 = null;
        for (PointMass object3 : this.getDrawables(PointMass.class)) {
            if (!object3.getName().equals(string)) continue;
            object2 = object3;
            break;
        }
        if (object2 != null) {
            void var3_7;
            ImageCoordSystem imageCoordSystem = this.getCoords();
            boolean bl = imageCoordSystem instanceof ReferenceFrame;
            while (var3_7 instanceof ReferenceFrame) {
                ImageCoordSystem imageCoordSystem2 = ((ReferenceFrame)var3_7).getCoords();
            }
            this.setCoords(new ReferenceFrame((ImageCoordSystem)var3_7, object2));
            if (object2 instanceof ParticleModel && bl) {
                ((ParticleModel)object2).lastValidFrame = -1;
                ((ParticleModel)object2).refreshSteps();
            }
            this.setSelectedPoint(null);
            this.repaint();
        } else {
            ImageCoordSystem imageCoordSystem = this.getCoords();
            if (imageCoordSystem instanceof ReferenceFrame) {
                ImageCoordSystem imageCoordSystem3 = ((ReferenceFrame)imageCoordSystem).getCoords();
                this.setCoords(imageCoordSystem3);
                this.setSelectedPoint(null);
                this.repaint();
            }
        }
    }

    public CoordAxes getAxes() {
        ArrayList<CoordAxes> arrayList = this.getDrawables(CoordAxes.class);
        if (!arrayList.isEmpty()) {
            return arrayList.get(0);
        }
        return null;
    }

    public TMat getMat() {
        ArrayList<TMat> arrayList = this.getDrawables(TMat.class);
        if (!arrayList.isEmpty()) {
            return arrayList.get(0);
        }
        return null;
    }

    public WorldGrid getGrid() {
        ArrayList<WorldGrid> arrayList = this.getDrawables(WorldGrid.class);
        if (!arrayList.isEmpty()) {
            return arrayList.get(0);
        }
        return null;
    }

    public TPoint getSnapPoint() {
        if (this.snapPoint == null) {
            this.snapPoint = new TPoint();
        }
        return this.snapPoint;
    }

    public void setSelectedTrack(TTrack tTrack) {
        if (this.selectedTrack == tTrack) {
            return;
        }
        if (tTrack != null && tTrack instanceof ParticleModel && ((ParticleModel)tTrack).refreshing) {
            return;
        }
        TTrack tTrack2 = this.selectedTrack;
        this.selectedTrack = tTrack;
        if (Tracker.showHints && tTrack != null) {
            this.setMessage(tTrack.getMessage());
        } else {
            this.setMessage("");
        }
        this.firePropertyChange("selectedtrack", tTrack2, tTrack);
    }

    public TTrack getSelectedTrack() {
        return this.selectedTrack;
    }

    public void setSelectedPoint(TPoint tPoint) {
        if (tPoint == this.selectedPoint && tPoint == null) {
            return;
        }
        Tracker.logTime("set selected point");
        TPoint tPoint2 = this.selectedPoint;
        if (tPoint2 != null) {
            tPoint2.setAdjusting(false);
        }
        this.selectedPoint = tPoint;
        if (this.currentState != null && tPoint2 != null && tPoint2 != tPoint && (tPoint2.x != this.pointState.x || tPoint2.y != this.pointState.y)) {
            boolean bl = tPoint2.isTrackEditTrigger() && this.getSelectedTrack() != null;
            boolean bl2 = tPoint2.isCoordsEditTrigger();
            if (bl && bl2) {
                Undo.postTrackAndCoordsEdit(this.getSelectedTrack(), this.currentState, this.currentCoords);
            } else if (bl) {
                if (this.selectedSteps.contains(this.getSelectedStep())) {
                    Undo.postStepSetEdit(this.selectedSteps, this.selectedSteps.getUndoControl());
                } else {
                    Undo.postTrackEdit(this.getSelectedTrack(), this.currentState);
                }
            } else if (bl2) {
                Undo.postCoordsEdit(this, this.currentState);
            } else if (tPoint2.isStepEditTrigger()) {
                Undo.postStepEdit(this.selectedStep, this.currentState);
            } else if (tPoint2 instanceof LineProfileStep.LineEnd) {
                tPoint2.setTrackEditTrigger(true);
            }
        }
        if (this.selectedStep != null) {
            this.selectedStep.repaint();
        }
        if (tPoint == null) {
            this.selectedStep = null;
            this.selectingPanel = null;
            this.currentState = null;
            this.currentCoords = null;
        } else {
            TTrack tTrack2 = null;
            Step step = null;
            for (TTrack tTrack2 : this.getTracks()) {
                step = tTrack2.getStep(tPoint, this);
                if (step != null) break;
            }
            this.selectedStep = step;
            if (step == null) {
                boolean bl;
                boolean bl3 = bl = this.autoTracker != null && this.autoTracker.getWizard().isVisible() && (tPoint instanceof AutoTracker.Corner || tPoint instanceof AutoTracker.Handle || tPoint instanceof AutoTracker.Target);
                if (!bl) {
                    this.setSelectedTrack(null);
                }
            } else {
                this.setSelectedTrack(tTrack2);
                step.repaint();
                if (tPoint2 != tPoint) {
                    boolean bl = tPoint.isTrackEditTrigger();
                    boolean bl4 = tPoint.isCoordsEditTrigger();
                    this.pointState.setLocation(tPoint);
                    if (bl && bl4) {
                        this.currentState = new XMLControlElement(tTrack2);
                        this.currentCoords = new XMLControlElement(this.getCoords());
                    } else if (bl) {
                        this.currentState = new XMLControlElement(tTrack2);
                        this.selectedSteps.setChanged(false);
                        if (step instanceof PositionStep) {
                            this.selectedSteps.setChanged(true);
                        }
                    } else if (bl4) {
                        this.currentState = new XMLControlElement(this.getCoords());
                    } else if (tPoint.isStepEditTrigger()) {
                        this.currentState = new XMLControlElement(step);
                    }
                }
            }
            this.selectingPanel = this;
            this.requestFocusInWindow();
        }
        this.firePropertyChange("selectedpoint", tPoint2, tPoint);
    }

    public TPoint getSelectedPoint() {
        return this.selectedPoint;
    }

    public Step getSelectedStep() {
        return this.selectedStep;
    }

    public TrackerPanel getSelectingPanel() {
        return this.selectingPanel;
    }

    public void setMagnification(double d) {
        MainTView mainTView;
        if (Double.isNaN(d)) {
            return;
        }
        if (d == 0.0) {
            return;
        }
        double d2 = this.getMagnification();
        Dimension dimension = this.getPreferredSize();
        Point point = new TPoint(0.0, 0.0).getScreenPosition(this);
        if (dimension.width == 1 && dimension.height == 1) {
            double d3 = this.getImageWidth();
            double d4 = this.getImageHeight();
            Point point2 = new TPoint(d3, d4).getScreenPosition(this);
            dimension.width = point2.x - point.x;
            dimension.height = point2.y - point.y;
        }
        if (d < 0.0) {
            this.setPreferredSize(new Dimension(1, 1));
        } else {
            this.zoom = Math.max(d, 0.15);
            this.zoom = Math.min(this.zoom, 12.0);
            int n = (int)(this.imageWidth * this.zoom);
            int n2 = (int)(this.imageHeight * this.zoom);
            Dimension dimension2 = new Dimension(n, n2);
            this.setPreferredSize(dimension2);
        }
        this.firePropertyChange("magnification", d2, this.getMagnification());
        MainTView mainTView2 = mainTView = this.getTFrame() == null ? null : this.getTFrame().getMainView(this);
        if (mainTView != null) {
            mainTView.scrollPane.revalidate();
            mainTView.scrollToZoomCenter(this.getPreferredSize(), dimension, point);
            this.eraseAll();
            this.repaint();
        }
        this.zoomBox.hide();
    }

    public double getMagnification() {
        if (this.getPreferredSize().width == 1) {
            double d = this.getImageWidth();
            double d2 = this.getImageHeight();
            Dimension dimension = this.getSize();
            return Math.min((double)dimension.width / d, (double)dimension.height / d2);
        }
        return this.zoom;
    }

    @Override
    public void setImageWidth(double d) {
        this.setImageSize(d, this.getImageHeight());
    }

    @Override
    public void setImageHeight(double d) {
        this.setImageSize(this.getImageWidth(), d);
    }

    public void setImageSize(double d, double d2) {
        super.setImageWidth(d);
        super.setImageHeight(d2);
        TMat tMat = this.getMat();
        if (tMat != null) {
            tMat.refresh();
        }
        if (this.getPreferredSize().width > 10) {
            this.setMagnification(this.getMagnification());
        }
        this.eraseAll();
        this.repaint();
        this.firePropertyChange("size", null, null);
    }

    public void setScrollPane(JScrollPane jScrollPane) {
        this.scrollPane = jScrollPane;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 20;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = this.getScrollableUnitIncrement(rectangle, n, n2);
        if (n == 0) {
            return rectangle.width - n3;
        }
        return rectangle.height - n3;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.scrollPane == null) {
            return true;
        }
        Dimension dimension = this.getPreferredSize();
        Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
        return rectangle.width > dimension.width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.scrollPane == null) {
            return true;
        }
        Dimension dimension = this.getPreferredSize();
        Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
        return rectangle.height > dimension.height;
    }

    @Override
    public boolean isShowCoordinates() {
        return this.showCoordinates && this.getSelectedPoint() == null;
    }

    @Override
    public void setMessage(String string) {
        if (!OSPRuntime.isMac()) {
            super.setMessage(string);
        }
    }

    protected DataTrack importData(String string, Object object) {
        if (string == null) {
            JOptionPane.showMessageDialog(this.frame, TrackerRes.getString("TrackerPanel.Dialog.NoData.Message"), TrackerRes.getString("TrackerPanel.Dialog.NoData.Title"), 2);
            return null;
        }
        DatasetManager datasetManager = DataTool.parseData(string, null);
        if (datasetManager != null) {
            return this.importData(datasetManager, object);
        }
        String string2 = string;
        return this.importData(ResourceLoader.getString(string2), (Object)string2);
    }

    @Override
    public DataTrack importData(Data data, Object object) {
        TTrack tTrack;
        if (data == null) {
            return null;
        }
        String string = data.getName();
        if (string == null || string.trim().equals("")) {
            string = TrackerRes.getString("ParticleDataTrack.New.Name");
        }
        if ((tTrack = this.getTrack(string = string.replaceAll("_", " "))) == null || tTrack.getClass() != ParticleDataTrack.class) {
            int n = data.getID();
            for (ParticleDataTrack particleDataTrack : this.getDrawables(ParticleDataTrack.class)) {
                Data data2 = particleDataTrack.getData();
                if (data2 == null || n != data2.getID()) continue;
                tTrack = particleDataTrack;
                break;
            }
        }
        try {
            if (tTrack == null || tTrack.getClass() != ParticleDataTrack.class) {
                tTrack = new ParticleDataTrack(data, object);
                ParticleDataTrack particleDataTrack = (ParticleDataTrack)tTrack;
                int n = this.getDrawables(PointMass.class).size();
                particleDataTrack.setColorToDefault(n);
                particleDataTrack.setName(string);
                this.addTrack(particleDataTrack);
                this.setSelectedPoint(null);
                this.setSelectedTrack(particleDataTrack);
                particleDataTrack.getDataClip().setClipLength(-1);
                VideoClip videoClip = this.getPlayer().getVideoClip();
                particleDataTrack.setStartFrame(videoClip.getStartFrameNumber());
                particleDataTrack.getInspector().setVisible(true);
                particleDataTrack.firePropertyChange("data", null, null);
            } else {
                ParticleDataTrack particleDataTrack = (ParticleDataTrack)tTrack;
                particleDataTrack.setData(data);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, String.valueOf(TrackerRes.getString("TrackerPanel.Dialog.Exception.Message")) + ":" + exception.getClass().getSimpleName() + ": " + exception.getMessage(), TrackerRes.getString("TrackerPanel.Dialog.Exception.Title"), 2);
            OSPLog.warning(String.valueOf(exception.getClass().getSimpleName()) + ": " + exception.getMessage());
            tTrack = null;
        }
        return (DataTrack)((Object)tTrack);
    }

    protected void refreshTrackData() {
        boolean bl = this.isAutoRefresh;
        this.isAutoRefresh = true;
        this.firePropertyChange("transform", null, null);
        this.isAutoRefresh = bl;
    }

    protected MouseEvent getMouseEvent() {
        return this.mouseEvent;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        MainTView mainTView = this.getTFrame().getMainView(this);
        return mainTView.getPopupMenu();
    }

    public AttachmentDialog getAttachmentDialog(TTrack tTrack) {
        if (this.attachmentDialog == null) {
            this.attachmentDialog = new AttachmentDialog(tTrack);
            this.attachmentDialog.setFontLevel(FontSizer.getLevel());
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - this.attachmentDialog.getBounds().width) / 2;
            int n2 = (dimension.height - this.attachmentDialog.getBounds().height) / 2;
            this.attachmentDialog.setLocation(n, n2);
        } else {
            this.attachmentDialog.setFontLevel(FontSizer.getLevel());
            this.attachmentDialog.setMeasuringTool(tTrack);
        }
        return this.attachmentDialog;
    }

    protected FunctionTool getDataBuilder() {
        if (this.dataBuilder == null) {
            this.dataBuilder = new TrackDataBuilder(this);
            this.dataBuilder.setHelpPath("data_builder_help.html");
            this.dataBuilder.addPropertyChangeListener("panel", this);
            this.dataBuilder.addPropertyChangeListener("function", this);
            this.dataBuilder.addPropertyChangeListener("visible", this);
            this.dataBuilder.setFontLevel(FontSizer.getLevel());
        }
        return this.dataBuilder;
    }

    protected DerivativeAlgorithmDialog getAlgorithmDialog() {
        if (this.algorithmDialog == null) {
            this.algorithmDialog = new DerivativeAlgorithmDialog(this);
            this.algorithmDialog.setFontLevel(FontSizer.getLevel());
        }
        return this.algorithmDialog;
    }

    protected void refreshNotesDialog() {
        TFrame tFrame = this.getTFrame();
        if (tFrame != null && tFrame.notesDialog.isVisible()) {
            Object object;
            tFrame.saveNotesAction.actionPerformed(null);
            TTrack tTrack = this.getSelectedTrack();
            if (tTrack != null) {
                tFrame.notesTextPane.setText(tTrack.getDescription());
                tFrame.notesDialog.setName(tTrack.getName());
                tFrame.notesDialog.setTitle(String.valueOf(TrackerRes.getString("TActions.Dialog.Description.Title")) + " \"" + tTrack.getName() + "\"");
            } else {
                tFrame.notesTextPane.setText(this.getDescription());
                tFrame.notesDialog.setName(null);
                object = tFrame.getTabTitle(tFrame.getSelectedTab());
                tFrame.notesDialog.setTitle(String.valueOf(TrackerRes.getString("TActions.Dialog.Description.Title")) + " \"" + (String)object + "\"");
            }
            tFrame.notesTextPane.setBackground(Color.WHITE);
            tFrame.cancelNotesDialogButton.setEnabled(false);
            tFrame.closeNotesDialogButton.setEnabled(true);
            object = tFrame.getTrackerPanel(tFrame.getSelectedTab());
            tFrame.displayWhenLoadedCheckbox.setEnabled(object != null);
            if (object != null) {
                tFrame.displayWhenLoadedCheckbox.setSelected(!((TrackerPanel)object).hideDescriptionWhenLoaded);
            }
            tFrame.notesTextPane.setEditable(this.isEnabled("notes.edit"));
        }
    }

    protected int getAlphabetIndex(String string, String string2) {
        int n = 0;
        while (n < alphabet.length()) {
            String string3 = alphabet.substring(n, n + 1);
            String string4 = String.valueOf(string) + string2 + string3;
            boolean bl = false;
            for (TTrack tTrack : this.getTracks()) {
                String string5 = tTrack.getName();
                boolean bl2 = bl = bl || string4.equals(string5);
            }
            if (!bl) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    protected void restoreViews() {
        Container[] containerArray = this.getTFrame().getViews(this);
        int n = 0;
        while (n < containerArray.length) {
            if (containerArray[n] instanceof TViewChooser) {
                TViewChooser tViewChooser = (TViewChooser)containerArray[n];
                if (tViewChooser.maximized) {
                    tViewChooser.restore();
                    break;
                }
            }
            ++n;
        }
    }

    protected void configure() {
        this.coords.addPropertyChangeListener(this);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 16) {
                    if (!TrackerPanel.this.isShiftKeyDown) {
                        TrackerPanel.this.isShiftKeyDown = true;
                        boolean bl = TrackerPanel.this.setCursorForMarking(true, keyEvent);
                        if (TrackerPanel.this.selectedTrack != null && bl != TrackerPanel.this.selectedTrack.isMarking) {
                            TrackerPanel.this.selectedTrack.setMarking(bl);
                            TrackerPanel.this.selectedTrack.repaint(TrackerPanel.this);
                        }
                    }
                } else if (keyEvent.getKeyCode() == 17) {
                    if (!TrackerPanel.this.isControlKeyDown) {
                        TrackerPanel.this.isControlKeyDown = true;
                        boolean bl = TrackerPanel.this.setCursorForMarking(TrackerPanel.this.isShiftKeyDown, keyEvent);
                        if (TrackerPanel.this.selectedTrack != null && bl != TrackerPanel.this.selectedTrack.isMarking) {
                            TrackerPanel.this.selectedTrack.setMarking(bl);
                            TrackerPanel.this.selectedTrack.repaint(TrackerPanel.this);
                        }
                    }
                } else if (keyEvent.getKeyCode() == 10 && TrackerPanel.this.selectedTrack != null && TrackerPanel.this.getCursor() == TrackerPanel.this.selectedTrack.getMarkingCursor(keyEvent) && TrackerPanel.this.getFrameNumber() > 0) {
                    int n = TrackerPanel.this.getFrameNumber();
                    Step step = TrackerPanel.this.selectedTrack.getStep(n - 1);
                    if (step != null) {
                        Step step2 = null;
                        if (TrackerPanel.this.selectedTrack.getClass() == PointMass.class) {
                            PositionStep.Position position = ((PositionStep)step).getPosition();
                            step2 = TrackerPanel.this.selectedTrack.createStep(n, position.x, position.y);
                        } else if (TrackerPanel.this.selectedTrack.getClass() == Vector.class) {
                            VectorStep vectorStep = (VectorStep)step;
                            TPoint tPoint = vectorStep.getTail();
                            TPoint tPoint2 = vectorStep.getTip();
                            Vector vector = (Vector)TrackerPanel.this.selectedTrack;
                            double d = tPoint2.x - tPoint.x;
                            double d2 = tPoint2.y - tPoint.y;
                            step2 = vector.createStep(n, tPoint.x, tPoint.y, d, d2);
                        }
                        if (step2 != null && TrackerPanel.this.selectedTrack.isAutoAdvance()) {
                            TrackerPanel.this.getPlayer().step();
                            TrackerPanel.this.hideMouseBox();
                        } else {
                            TrackerPanel.this.setMouseCursor(Cursor.getDefaultCursor());
                            if (step2 != null) {
                                TrackerPanel.this.setSelectedPoint(step2.getDefaultPoint());
                                TrackerPanel.this.selectedTrack.repaint(step2);
                            }
                        }
                    }
                } else {
                    TrackerPanel.this.handleKeyPress(keyEvent);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 16) {
                    TrackerPanel.this.isShiftKeyDown = false;
                    boolean bl = TrackerPanel.this.setCursorForMarking(false, keyEvent);
                    if (TrackerPanel.this.selectedTrack != null && bl != TrackerPanel.this.selectedTrack.isMarking) {
                        TrackerPanel.this.selectedTrack.setMarking(bl);
                        TrackerPanel.this.selectedTrack.repaint(TrackerPanel.this);
                    }
                } else if (keyEvent.getKeyCode() == 17) {
                    TrackerPanel.this.isControlKeyDown = false;
                    boolean bl = TrackerPanel.this.setCursorForMarking(TrackerPanel.this.isShiftKeyDown, keyEvent);
                    if (TrackerPanel.this.selectedTrack != null && bl != TrackerPanel.this.selectedTrack.isMarking) {
                        TrackerPanel.this.selectedTrack.setMarking(bl);
                        TrackerPanel.this.selectedTrack.repaint(TrackerPanel.this);
                    }
                }
            }
        });
        this.setDrawingInImageSpace(true);
        this.setPreferredSize(new Dimension(1, 1));
        this.enabled = Tracker.getDefaultConfig();
        this.changed = false;
    }

    protected boolean setCursorForMarking(boolean bl, InputEvent inputEvent) {
        Interactive interactive;
        if (this.getCursor() == Tracker.zoomInCursor || this.getCursor() == Tracker.zoomOutCursor) {
            return false;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        this.selectedTrack = this.getSelectedTrack();
        int n = this.getFrameNumber();
        if (this.selectedTrack != null) {
            bl2 = !this.selectedTrack.isStepComplete(n) && !this.selectedTrack.isLocked() && !this.popup.isVisible();
            bl3 = bl2 && this.selectedTrack.isMarkByDefault() != bl;
        }
        Interactive interactive2 = interactive = this.getTracks().isEmpty() || this.mouseEvent == null ? null : this.getInteractive();
        if (bl3) {
            this.setMouseCursor(this.selectedTrack.getMarkingCursor(inputEvent));
            if (Tracker.showHints) {
                if (this.selectedTrack instanceof PointMass) {
                    if (this.selectedTrack.getStep(n) == null) {
                        this.setMessage(TrackerRes.getString("PointMass.Hint.Marking"));
                    } else {
                        this.setMessage(TrackerRes.getString("PointMass.Remarking.Hint"));
                    }
                } else if (this.selectedTrack instanceof Vector) {
                    if (this.selectedTrack.getStep(n) == null) {
                        this.setMessage(TrackerRes.getString("Vector.Hint.Marking"));
                    } else {
                        this.setMessage(TrackerRes.getString("Vector.Remarking.Hint"));
                    }
                } else if (this.selectedTrack instanceof LineProfile) {
                    this.setMessage(TrackerRes.getString("LineProfile.Hint.Marking"));
                } else if (this.selectedTrack instanceof RGBRegion) {
                    this.setMessage(TrackerRes.getString("RGBRegion.Hint.Marking"));
                }
            } else {
                this.setMessage("");
            }
        } else if (interactive instanceof TPoint) {
            this.setMouseCursor(Cursor.getPredefinedCursor(12));
            for (TTrack tTrack : this.getTracks()) {
                Step step = tTrack.getStep((TPoint)interactive, this);
                if (step == null) continue;
                this.setMessage(tTrack.getMessage());
                break;
            }
        } else {
            this.setMouseCursor(Cursor.getDefaultCursor());
            if (Tracker.showHints && this.selectedTrack != null) {
                this.setMessage(this.selectedTrack.getMessage());
            } else if (!Tracker.startupHintShown || this.getVideo() != null || !this.getUserTracks().isEmpty()) {
                Tracker.startupHintShown = false;
                if (!Tracker.showHints) {
                    this.setMessage("");
                } else if (this.getVideo() == null) {
                    this.setMessage(TrackerRes.getString("TrackerPanel.NoVideo.Hint"));
                } else if (TToolBar.getToolbar((TrackerPanel)this).notYetCalibrated) {
                    if (this.getVideo().getWidth() == 720.0 && this.getVideo().getFilterStack().isEmpty()) {
                        this.setMessage(TrackerRes.getString("TrackerPanel.DVVideo.Hint"));
                    } else if (this.getPlayer().getVideoClip().isDefaultState()) {
                        this.setMessage(TrackerRes.getString("TrackerPanel.SetClip.Hint"));
                    } else {
                        this.setMessage(TrackerRes.getString("TrackerPanel.CalibrateVideo.Hint"));
                    }
                } else if (this.getAxes() != null && this.getAxes().notyetShown) {
                    this.setMessage(TrackerRes.getString("TrackerPanel.ShowAxes.Hint"));
                } else if (this.getUserTracks().isEmpty()) {
                    this.setMessage(TrackerRes.getString("TrackerPanel.NoTracks.Hint"));
                } else {
                    this.setMessage("");
                }
            }
        }
        return bl3;
    }

    protected void handleKeyPress(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 112) {
            TFrame tFrame = this.getTFrame();
            if (tFrame != null) {
                if (this.selectedTrack == null) {
                    tFrame.showHelp("help", 0);
                } else if (this.selectedTrack instanceof CoordAxes) {
                    tFrame.showHelp("axes", 0);
                } else if (this.selectedTrack instanceof TapeMeasure) {
                    tFrame.showHelp("tape", 0);
                } else if (this.selectedTrack instanceof OffsetOrigin) {
                    tFrame.showHelp("offset", 0);
                } else if (this.selectedTrack instanceof Calibration) {
                    tFrame.showHelp("calibration", 0);
                } else if (this.selectedTrack instanceof PointMass) {
                    tFrame.showHelp("pointmass", 0);
                } else if (this.selectedTrack instanceof CenterOfMass) {
                    tFrame.showHelp("cm", 0);
                } else if (this.selectedTrack instanceof Vector) {
                    tFrame.showHelp("vector", 0);
                } else if (this.selectedTrack instanceof VectorSum) {
                    tFrame.showHelp("vectorsum", 0);
                } else if (this.selectedTrack instanceof LineProfile) {
                    tFrame.showHelp("profile", 0);
                } else if (this.selectedTrack instanceof RGBRegion) {
                    tFrame.showHelp("rgbregion", 0);
                } else if (this.selectedTrack instanceof ParticleModel) {
                    tFrame.showHelp("particle", 0);
                }
            }
            return;
        }
        if (keyEvent.getKeyCode() == 32) {
            Step step;
            TTrack tTrack = this.getSelectedTrack();
            if (tTrack != null && (step = this.getSelectedStep()) != null && (step = keyEvent.isControlDown() || keyEvent.isShiftDown() ? tTrack.getPreviousVisibleStep(step, this) : tTrack.getNextVisibleStep(step, this)) != null) {
                TPoint tPoint = step.getDefaultPoint();
                tPoint.showCoordinates(this);
                this.setSelectedPoint(tPoint);
            }
            return;
        }
        if (keyEvent.getKeyCode() == 127) {
            this.deleteSelectedSteps();
            if (this.selectedPoint != null && this.selectingPanel == this) {
                this.deletePoint(this.selectedPoint);
            }
            return;
        }
        double d = keyEvent.isShiftDown() ? 10 : 1;
        double d2 = 0.0;
        double d3 = 0.0;
        switch (keyEvent.getKeyCode()) {
            case 38: {
                d3 = -d;
                break;
            }
            case 40: {
                d3 = d;
                break;
            }
            case 39: {
                d2 = d;
                break;
            }
            case 37: {
                d2 = -d;
            }
        }
        if (d2 == 0.0 && d3 == 0.0) {
            return;
        }
        for (Cloneable cloneable : this.selectedSteps) {
            this.selectedSteps.setChanged(true);
            TPoint tPoint = ((Step)cloneable).points[0];
            if (tPoint == this.selectedPoint) continue;
            Point point = tPoint.getScreenPosition(this);
            point.setLocation((double)point.x + d2, (double)point.y + d3);
            tPoint.setScreenPosition(point.x, point.y, this, keyEvent);
        }
        if (this.selectedPoint != null) {
            Cloneable cloneable;
            cloneable = this.selectedPoint.getScreenPosition(this);
            ((Point)cloneable).setLocation((double)((Point)cloneable).x + d2, (double)((Point)cloneable).y + d3);
            this.selectedPoint.setScreenPosition(((Point)cloneable).x, ((Point)cloneable).y, this, keyEvent);
        }
        if (this.selectedPoint != null) {
            this.selectedPoint.showCoordinates(this);
        } else {
            this.setMessage("", 0);
        }
        if (this.selectedStep == null) {
            this.repaint();
        }
    }

    public boolean isDefaultConfiguration() {
        return Tracker.areEqual(this.getEnabled(), Tracker.defaultConfig);
    }

    public Set<String> getEnabled() {
        if (this.enabled == null) {
            this.enabled = new TreeSet<String>();
        }
        return this.enabled;
    }

    public void setEnabled(Set<String> set) {
        if (set != null) {
            this.enabled = this.getEnabled();
            this.enabled.clear();
            this.enabled.addAll(set);
        }
    }

    public boolean isEnabled(String string) {
        if (string == null) {
            return false;
        }
        return this.getEnabled().contains(string);
    }

    public void setEnabled(String string, boolean bl) {
        if (string == null) {
            return;
        }
        if (bl) {
            this.getEnabled().add(string);
        } else {
            this.getEnabled().remove(string);
        }
    }

    public boolean isCreateTracksEnabled() {
        return this.isEnabled("new.pointMass") || this.isEnabled("new.cm") || this.isEnabled("new.vector") || this.isEnabled("new.vectorSum") || this.isEnabled("new.lineProfile") || this.isEnabled("new.RGBRegion") || this.isEnabled("new.tapeMeasure") || this.isEnabled("new.protractor") || this.isEnabled("new.circleFitter") || this.isEnabled("new.analyticParticle") || this.isEnabled("new.dynamicParticle") || this.isEnabled("new.dynamicTwoBody") || this.isEnabled("new.dataTrack");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Tracker.logTime(String.valueOf(this.getClass().getSimpleName()) + this.hashCode() + " property change " + string);
        if (string.equals("size")) {
            super.propertyChange(propertyChangeEvent);
        }
        if (string.equals("step") || string.equals("steps")) {
            TPoint tPoint;
            TTrack object3 = (TTrack)propertyChangeEvent.getSource();
            object3.dataValid = false;
            if (!object3.isDependent()) {
                this.changed = true;
            }
            if (object3 == this.getSelectedTrack() && (tPoint = this.getSelectedPoint()) != null) {
                tPoint.showCoordinates(this);
            }
            this.repaint();
            if (string.equals("steps")) {
                TTrackBar.getTrackbar(this).refresh();
            }
        } else if (string.equals("mass")) {
            this.firePropertyChange("mass", null, null);
        } else if (string.equals("name")) {
            this.refreshNotesDialog();
        } else if (string.equals("footprint")) {
            Footprint n = (Footprint)propertyChangeEvent.getNewValue();
            if (n instanceof ArrowFootprint) {
                this.firePropertyChange("footprint", null, null);
            }
        } else if (string.equals("videoclip")) {
            ImageCoordSystem imageCoordSystem = this.coords;
            this.coords.removePropertyChangeListener(this);
            super.propertyChange(propertyChangeEvent);
            this.coords.addPropertyChangeListener(this);
            this.firePropertyChange("coords", imageCoordSystem, this.coords);
            this.firePropertyChange("video", null, null);
            if (this.getMat() != null) {
                this.getMat().isValidMeasure = false;
            }
            if (this.getVideo() != null) {
                this.getVideo().setProperty("measure", null);
                VideoType videoType = (VideoType)this.video.getProperty("video_type");
                if (videoType != null && videoType.getClass().getSimpleName().contains("Xuggle")) {
                    boolean bl = !Tracker.isXuggleFast;
                    try {
                        String string2 = "org.opensourcephysics.media.xuggle.XuggleVideo";
                        Class<?> clazz = Class.forName(string2);
                        Method method = clazz.getMethod("setSmoothPlay", Boolean.class);
                        method.invoke((Object)this.video, bl);
                    }
                    catch (Exception exception) {}
                }
            }
            this.changed = true;
        } else if (string.equals("stepnumber")) {
            this.setSelectedPoint(null);
            if (this.getVideo() != null && !this.getVideo().getFilterStack().isEmpty()) {
                for (Filter filter : this.getVideo().getFilterStack().getFilters()) {
                    if (!(filter instanceof SumFilter)) continue;
                    SumFilter sumFilter = (SumFilter)filter;
                    sumFilter.addNextImage();
                }
            }
            this.repaint();
            VideoGrabber videoGrabber = VideoGrabber.VIDEO_CAPTURE_TOOL;
            if (videoGrabber != null && ((VideoCaptureTool)videoGrabber).isVisible() && ((VideoCaptureTool)videoGrabber).isRecording()) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        TrackerPanel.this.renderMat();
                        VideoGrabber.getTool().addFrame(TrackerPanel.this.matImage);
                    }
                };
                EventQueue.invokeLater(runnable);
            }
            boolean bl = this.isShiftKeyDown;
            this.setCursorForMarking(bl, null);
            this.firePropertyChange("stepnumber", null, propertyChangeEvent.getNewValue());
        } else if (string.equals("coords")) {
            this.coords.removePropertyChangeListener(this);
            this.coords = (ImageCoordSystem)propertyChangeEvent.getNewValue();
            this.coords.addPropertyChangeListener(this);
            this.firePropertyChange("coords", null, this.coords);
            this.firePropertyChange("transform", null, null);
        } else if (string.equals("image")) {
            this.firePropertyChange("image", null, null);
            Video video = this.getVideo();
            TMenuBar.getMenuBar(this).refreshMatSizes(video);
            this.repaint();
        } else if (string.equals("videoVisible")) {
            this.firePropertyChange("videoVisible", null, null);
            this.repaint();
        } else if (string.equals("transform")) {
            this.changed = true;
            this.firePropertyChange("transform", null, null);
        } else if (string.equals("locked")) {
            this.firePropertyChange("locked", null, null);
        } else if (string.equals("playing")) {
            if (!((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                for (ParticleModel particleModel : this.getDrawables(ParticleModel.class)) {
                    particleModel.refreshDerivsIfNeeded();
                }
            }
        } else if (string.equals("startframe") || string.equals("stepsize") || string.equals("stepcount") || string.equals("starttime") || string.equals("adjusting") || string.equals("frameduration")) {
            this.changed = true;
            if (this.modelBuilder != null) {
                this.modelBuilder.refreshSpinners();
            }
            if (this.getMat() != null) {
                this.getMat().isValidMeasure = false;
            }
            if (this.getVideo() != null) {
                this.getVideo().setProperty("measure", null);
            }
            this.firePropertyChange("data", null, null);
            if (string.equals("stepsize") || string.equals("starttime") || string.equals("frameduration") || string.equals("startframe")) {
                this.firePropertyChange(string, null, null);
            } else if (string.equals("adjusting")) {
                this.firePropertyChange("adjusting", null, propertyChangeEvent.getNewValue());
            }
            if (this.getSelectedPoint() != null) {
                this.getSelectedPoint().showCoordinates(this);
                this.getTFrame().getTrackBar(this).refresh();
            }
            for (TTrack tTrack : this.getUserTracks()) {
                tTrack.erase(this);
            }
            this.repaint();
        } else if (this.getVideo() == null && string.equals("framecount")) {
            if (this.modelBuilder != null) {
                this.modelBuilder.refreshSpinners();
            }
        } else if (string.equals("function")) {
            this.changed = true;
            this.firePropertyChange("function", null, propertyChangeEvent.getNewValue());
        } else if (string.equals("panel") && propertyChangeEvent.getSource() == this.modelBuilder) {
            void var4_29;
            TTrack tTrack;
            TTrack tTrack2;
            FunctionPanel functionPanel = (FunctionPanel)propertyChangeEvent.getNewValue();
            if (functionPanel != null && (tTrack2 = this.getTrack(functionPanel.getName())) != null) {
                tTrack = (ParticleModel)tTrack2;
                this.modelBuilder.setSpinnerStartFrame(((ParticleModel)tTrack).getStartFrame());
                int n = ((ParticleModel)tTrack).getEndFrame();
                if (n == Integer.MAX_VALUE) {
                    n = this.getPlayer().getVideoClip().getFrameCount() - 1;
                }
                this.modelBuilder.setSpinnerEndFrame(n);
            }
            this.modelBuilder.refreshSpinners();
            String string3 = TrackerRes.getString("TrackerPanel.ModelBuilder.Title");
            FunctionPanel functionPanel2 = this.modelBuilder.getSelectedPanel();
            if (functionPanel2 != null && (tTrack = this.getTrack(functionPanel2.getName())) != null) {
                String string4 = tTrack.getClass().getSimpleName();
                String string5 = String.valueOf(string3) + ": " + TrackerRes.getString(String.valueOf(string4) + ".Builder.Title");
            }
            this.modelBuilder.setTitle((String)var4_29);
        } else if (string.equals("model_start")) {
            ParticleModel particleModel = (ParticleModel)propertyChangeEvent.getSource();
            if (particleModel.getName().equals(this.getModelBuilder().getSelectedName())) {
                this.modelBuilder.setSpinnerStartFrame(propertyChangeEvent.getNewValue());
            }
        } else if (string.equals("model_end")) {
            ParticleModel particleModel = (ParticleModel)propertyChangeEvent.getSource();
            if (particleModel.getName().equals(this.getModelBuilder().getSelectedName())) {
                int n;
                int n2 = (Integer)propertyChangeEvent.getNewValue();
                if (n2 == Integer.MAX_VALUE) {
                    n = this.getPlayer().getVideoClip().getFrameCount() - 1;
                }
                this.modelBuilder.setSpinnerEndFrame(n);
            }
        } else if (string.equals("radian_angles")) {
            this.firePropertyChange("radian_angles", null, propertyChangeEvent.getNewValue());
        } else if (string.equals("fixed_origin") || string.equals("fixed_angle") || string.equals("fixed_scale")) {
            this.changed = true;
            this.firePropertyChange(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getSource() == this.dataBuilder && string.equals("visible")) {
            this.dataToolVisible = (Boolean)propertyChangeEvent.getNewValue();
        } else if (propertyChangeEvent.getSource() instanceof Filter && string.equals("visible")) {
            this.setSelectedPoint(null);
        } else if (string.equals("perspective")) {
            if (propertyChangeEvent.getNewValue() != null) {
                PerspectiveFilter perspectiveFilter = (PerspectiveFilter)propertyChangeEvent.getNewValue();
                PerspectiveTrack perspectiveTrack = new PerspectiveTrack(perspectiveFilter);
                this.addTrack(perspectiveTrack);
            }
        } else if (Tracker.showHints) {
            Tracker.startupHintShown = false;
            if (string.equals("stepbutton")) {
                if (!((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                    this.setMessage("");
                } else {
                    this.setMessage(TrackerRes.getString("VideoPlayer.Step.Hint"));
                }
            } else if (string.equals("backbutton")) {
                if (!((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                    this.setMessage("");
                } else {
                    this.setMessage(TrackerRes.getString("VideoPlayer.Back.Hint"));
                }
            } else if (string.equals("inframe")) {
                if (!((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                    this.setMessage("");
                } else {
                    this.setMessage(TrackerRes.getString("VideoPlayer.StartFrame.Hint"));
                }
            } else if (string.equals("outframe")) {
                if (!((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                    this.setMessage("");
                } else {
                    this.setMessage(TrackerRes.getString("VideoPlayer.EndFrame.Hint"));
                }
            } else if (string.equals("slider")) {
                if (!((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                    this.setMessage("");
                } else {
                    this.setMessage(TrackerRes.getString("VideoPlayer.Slider.Hint"));
                }
            }
        }
        if (string.equals("videoclip") || string.equals("transform") || string.equals("stepnumber") || string.equals("coords")) {
            int n = this.getFrameNumber();
            this.getSnapPoint().setXY(this.coords.getOriginX(n), this.coords.getOriginY(n));
        }
        Tracker.logTime("end TrackerPanel property change " + string);
    }

    @Override
    public void setImageBorder(double d) {
        super.setImageBorder(d);
        this.defaultImageBorder = this.getImageBorder();
    }

    @Override
    public String getFilePath() {
        if (this.defaultSavePath == null) {
            return super.getFilePath();
        }
        return this.defaultSavePath;
    }

    @Override
    public void scale() {
        TFrame tFrame;
        TMat tMat = this.getMat();
        if (tMat != null) {
            this.xOffset = tMat.getXOffset();
            this.yOffset = tMat.getYOffset();
        }
        super.scale();
        if (!this.pixelTransform.equals(this.prevPixelTransform)) {
            this.prevPixelTransform = this.getPixelTransform();
            this.eraseAll();
        }
        if ((tFrame = this.getTFrame()) != null && this.trackControl == null) {
            this.trackControl = TrackControl.getControl(this);
        }
    }

    @Override
    public void setMouseCursor(Cursor cursor) {
        if (cursor != Cursor.getPredefinedCursor(1) && this.getCursor() != Tracker.zoomOutCursor && this.getCursor() != Tracker.zoomInCursor) {
            super.setMouseCursor(cursor);
        }
    }

    @Override
    public void setFontLevel(int n) {
        Video video;
        TView[] tViewArray;
        super.setFontLevel(n);
        if (this.frame == null) {
            return;
        }
        TView[][] tViewArray2 = this.frame.getTViews(this);
        if (tViewArray2 == null) {
            return;
        }
        Object object = tViewArray2;
        int n2 = tViewArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            tViewArray = object[n3];
            if (tViewArray != null) {
                TView[] tViewArray3 = tViewArray;
                int n4 = tViewArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    TView object2 = tViewArray3[n5];
                    object2.refresh();
                    ++n5;
                }
            }
            ++n3;
        }
        tViewArray = TTrackBar.getTrackbar(this);
        tViewArray.setFontLevel(n);
        tViewArray.refresh();
        TMenuBar tMenuBar = TMenuBar.getMenuBar(this);
        if (tMenuBar.fontSizeGroup != null) {
            Enumeration<AbstractButton> enumeration = tMenuBar.fontSizeGroup.getElements();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                int n6 = Integer.parseInt(((AbstractButton)object).getActionCommand());
                if (n6 != FontSizer.getLevel()) continue;
                ((AbstractButton)object).setSelected(true);
            }
        }
        for (TTrack tTrack : this.getTracks()) {
            tTrack.setFontLevel(n);
        }
        TrackControl.getControl(this).refresh();
        if (this.modelBuilder != null) {
            this.modelBuilder.setFontLevel(n);
        }
        if (this.dataBuilder != null) {
            this.dataBuilder.setFontLevel(n);
        }
        if (this.autoTracker != null) {
            this.autoTracker.getWizard().setFontLevel(n);
        }
        if (this.attachmentDialog != null) {
            this.attachmentDialog.setFontLevel(n);
        }
        if ((video = this.getVideo()) != null) {
            object = video.getFilterStack();
            for (Filter filter : ((FilterStack)object).getFilters()) {
                JDialog jDialog = filter.getInspector();
                if (jDialog == null) continue;
                FontSizer.setFonts(jDialog, n);
                jDialog.pack();
            }
        }
        if (this.algorithmDialog != null) {
            this.algorithmDialog.setFontLevel(n);
        }
    }

    @Override
    public boolean isZoomEvent(MouseEvent mouseEvent) {
        return super.isZoomEvent(mouseEvent) || this.getCursor() == Tracker.zoomInCursor;
    }

    @Override
    public Interactive getInteractive() {
        this.mEvent = this.mouseEvent;
        Interactive interactive = null;
        TTrack tTrack = this.getSelectedTrack();
        if (tTrack != null && this.getCursor() == tTrack.getMarkingCursor(this.mEvent)) {
            return null;
        }
        if (tTrack != null && (tTrack.isDependent() || tTrack == this.getAxes())) {
            interactive = this.getAxes().findInteractive(this, this.mouseEvent.getX(), this.mouseEvent.getY());
        }
        if (interactive == null && tTrack != null && tTrack != this.getAxes() && !this.calibrationTools.contains(tTrack)) {
            interactive = tTrack.findInteractive(this, this.mouseEvent.getX(), this.mouseEvent.getY());
        }
        if (interactive != null) {
            return interactive;
        }
        return super.getInteractive();
    }

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        Window window = null;
        Frame[] frameArray = Frame.getFrames();
        int n = 0;
        int n2 = frameArray.length;
        while (n < n2) {
            if (frameArray[n].getName().equals("LauncherTool")) {
                window = frameArray[n];
                break;
            }
            ++n;
        }
        if (window != null) {
            window.setCursor(Cursor.getPredefinedCursor(3));
        }
        Tracker tracker = Tracker.getTracker();
        final TFrame tFrame = tracker.getFrame();
        final String string = stringArray[0];
        final LaunchNode launchNode = Launcher.activeNode;
        tFrame.addPropertyChangeListener("tab", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                final TrackerPanel trackerPanel = (TrackerPanel)propertyChangeEvent.getNewValue();
                if (trackerPanel.defaultFileName.equals(XML.getName(string))) {
                    tFrame.removePropertyChangeListener("tab", this);
                    tFrame.showTrackControl(trackerPanel);
                    tFrame.showNotes(trackerPanel);
                    tFrame.refresh();
                    int n = tFrame.getTab(trackerPanel);
                    final Component component = tFrame.tabbedPane.getComponentAt(n);
                    if (launchNode != null) {
                        final AbstractAction abstractAction = new AbstractAction(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                tFrame.removeTab(trackerPanel);
                                if (tFrame.getTabCount() == 0) {
                                    tFrame.setVisible(false);
                                }
                            }
                        };
                        launchNode.addTerminateAction(abstractAction);
                        tFrame.tabbedPane.addContainerListener(new ContainerAdapter(){

                            @Override
                            public void componentRemoved(ContainerEvent containerEvent) {
                                if (containerEvent.getChild() == component) {
                                    launchNode.terminate(abstractAction);
                                }
                            }
                        });
                    }
                }
            }
        });
        TrackerIO.open(string, tFrame);
        tFrame.setVisible(true);
        if (tFrame.isIconified()) {
            tFrame.setState(0);
        }
        if (window != null) {
            window.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void addCalibrationTool(String string, TTrack tTrack) {
        this.calibrationTools.add(tTrack);
        this.addTrack(tTrack);
    }

    protected BufferedImage renderMat() {
        if (this.renderedImage == null || this.renderedImage.getWidth() != this.getWidth() || this.renderedImage.getHeight() != this.getHeight()) {
            this.renderedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        }
        this.render(this.renderedImage);
        Rectangle rectangle = this.getMat().drawingBounds;
        if (this.matImage == null || this.matImage.getWidth() != rectangle.width || this.matImage.getHeight() != rectangle.height) {
            this.matImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        }
        Graphics graphics = this.matImage.getGraphics();
        graphics.drawImage(this.renderedImage, -rectangle.x, -rectangle.y, null);
        return this.matImage;
    }

    protected void deletePoint(TPoint tPoint) {
        for (TTrack tTrack : this.getTracks()) {
            Step step = tTrack.getStep(tPoint, this);
            if (step == null) continue;
            step = tTrack.deleteStep(step.n);
            if (step == null) {
                return;
            }
            this.setSelectedPoint(null);
            this.hideMouseBox();
            return;
        }
    }

    protected void deleteSelectedSteps() {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (TTrack tTrack : this.getTracks()) {
            boolean bl = false;
            XMLControlElement xMLControlElement = new XMLControlElement(tTrack);
            for (Step step : this.selectedSteps) {
                if (step.track != tTrack) continue;
                if (tTrack.isLocked()) {
                    step.erase();
                    continue;
                }
                int n = step.getFrameNumber();
                tTrack.steps.setStep(n, null);
                for (String string : tTrack.textColumnNames) {
                    String[] stringArray = tTrack.textColumnEntries.get(string);
                    if (stringArray.length <= n) continue;
                    stringArray[n] = null;
                }
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(new Object[]{tTrack, xMLControlElement});
            tTrack.firePropertyChange("steps", null, null);
        }
        this.selectedSteps.clear();
        if (!arrayList.isEmpty()) {
            Undo.postMultiTrackEdit(arrayList);
        }
    }

    @Override
    protected void scale(ArrayList<Drawable> arrayList) {
        if (this.drawingInImageSpace) {
            if (this.getPreferredSize().width < 2) {
                super.setImageBorder(this.defaultImageBorder);
            } else {
                double d = this.getMagnification() * this.imageWidth;
                double d2 = ((double)this.getWidth() - d) * 0.5 / d;
                double d3 = this.getMagnification() * this.imageHeight;
                double d4 = ((double)this.getHeight() - d3) * 0.5 / d3;
                double d5 = Math.min(d2, d4);
                super.setImageBorder(Math.max(d5, this.defaultImageBorder));
            }
        }
        super.scale(arrayList);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.zoomCenter != null && this.isShowing() && this.getTFrame() != null && this.scrollPane != null) {
            Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
            int n = this.zoomCenter.x - rectangle.width / 2;
            int n2 = this.zoomCenter.y - rectangle.height / 2;
            rectangle.setLocation(n, n2);
            this.zoomCenter = null;
            this.scrollRectToVisible(rectangle);
        }
    }

    protected static double getDefaultImageWidth() {
        return defaultWidth;
    }

    protected static double getDefaultImageHeight() {
        return defaultHeight;
    }

    protected TFrame getTFrame() {
        Container container;
        if (this.frame == null && (container = this.getTopLevelAncestor()) instanceof TFrame) {
            this.frame = (TFrame)container;
        }
        return this.frame;
    }

    protected AutoTracker getAutoTracker() {
        if (this.autoTracker == null) {
            this.autoTracker = new AutoTracker(this);
            this.autoTracker.getWizard().setFontLevel(FontSizer.getLevel());
        }
        return this.autoTracker;
    }

    protected void setTrackName(TTrack tTrack, String string, boolean bl) {
        for (Drawable object2 : this.getDrawables()) {
            String string2;
            if (object2 == tTrack || !(object2 instanceof TTrack) || !string.equals(string2 = ((TTrack)object2).getName())) continue;
            Toolkit.getDefaultToolkit().beep();
            String string3 = "\"" + string + "\" ";
            this.badNameLabel.setText(String.valueOf(string3) + TrackerRes.getString("TTrack.Dialog.Name.BadName"));
            tTrack.nameDialog.getContentPane().add((Component)this.badNameLabel, "South");
            tTrack.nameAction.actionPerformed(null);
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(new TrackProperties(tTrack));
        tTrack.setName(string);
        if (bl) {
            Undo.postTrackDisplayEdit(tTrack, xMLControlElement);
        }
        tTrack.nameDialog.setVisible(false);
        tTrack.nameDialog.getContentPane().remove(this.badNameLabel);
        TMenuBar.getMenuBar(this).refresh();
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            Serializable serializable;
            Object object2;
            PropertyChangeListener propertyChangeListener;
            Object object3;
            Object object4;
            boolean bl = XMLPropertyElement.defaultWriteNullFinalArrayElements;
            XMLPropertyElement.defaultWriteNullFinalArrayElements = false;
            TrackerPanel trackerPanel = (TrackerPanel)object;
            xMLControl.setValue("version", "4.91");
            xMLControl.setValue("width", trackerPanel.getImageWidth());
            xMLControl.setValue("height", trackerPanel.getImageHeight());
            double d = trackerPanel.getPreferredSize().width > 10 ? trackerPanel.getMagnification() : -1.0;
            xMLControl.setValue("magnification", d);
            if (trackerPanel.getTFrame() != null) {
                object4 = trackerPanel.getTFrame().getMainView(trackerPanel);
                object3 = ((MainTView)object4).scrollPane.getViewport().getViewRect();
                xMLControl.setValue("center_x", (int)((RectangularShape)object3).getCenterX());
                xMLControl.setValue("center_y", (int)((RectangularShape)object3).getCenterY());
            }
            if (trackerPanel.hideDescriptionWhenLoaded) {
                xMLControl.setValue("hide_description", true);
            }
            if (!trackerPanel.description.trim().equals("")) {
                xMLControl.setValue("description", trackerPanel.description);
            }
            if (trackerPanel.author != null) {
                xMLControl.setValue("author", trackerPanel.author);
            }
            if (trackerPanel.contact != null) {
                xMLControl.setValue("contact", trackerPanel.contact);
            }
            xMLControl.setValue("videoclip", trackerPanel.getPlayer().getVideoClip());
            xMLControl.setValue("clipcontrol", trackerPanel.getPlayer().getClipControl());
            object4 = trackerPanel.getCoords();
            while (object4 instanceof ReferenceFrame) {
                object3 = (ReferenceFrame)object4;
                propertyChangeListener = ((ReferenceFrame)object3).getOriginTrack();
                xMLControl.setValue("referenceframe", ((TTrack)propertyChangeListener).getName());
                object4 = ((ReferenceFrame)object3).getCoords();
            }
            xMLControl.setValue("coords", object4);
            xMLControl.setValue("tracks", trackerPanel.getTracks());
            object3 = trackerPanel.getSelectedTrack();
            if (object3 != null) {
                xMLControl.setValue("selectedtrack", ((TTrack)object3).getName());
            }
            if (!trackerPanel.isDefaultConfiguration() && trackerPanel.isEnabled("config.saveWithData")) {
                xMLControl.setValue("configuration", new Configuration(trackerPanel));
            }
            if ((propertyChangeListener = trackerPanel.getTFrame()) != null) {
                int n;
                int n2;
                int n3;
                void tViewArray2;
                object2 = new double[4];
                int n4 = 0;
                boolean n5 = false;
                while (tViewArray2 < ((double[])object2).length) {
                    JSplitPane jSplitPane = ((TFrame)propertyChangeListener).getSplitPane(trackerPanel, (int)tViewArray2);
                    if (tViewArray2 == false) {
                        n4 = jSplitPane.getMaximumDividerLocation();
                    }
                    n3 = tViewArray2 == 3 ? n4 : jSplitPane.getMaximumDividerLocation();
                    object2[tViewArray2] = Math.min(1.0, 1.0 * (double)jSplitPane.getDividerLocation() / (double)n3);
                    ++tViewArray2;
                }
                xMLControl.setValue("dividers", object2);
                TView[][] tViewArray = ((TFrame)propertyChangeListener).getTViews(trackerPanel, true);
                int n6 = 0;
                while (n6 < tViewArray.length) {
                    if (tViewArray[n6] != null) {
                        xMLControl.setValue("views", tViewArray);
                        break;
                    }
                    ++n6;
                }
                String[] stringArray = ((TFrame)propertyChangeListener).getSelectedTViews(trackerPanel);
                n3 = 0;
                while (n3 < stringArray.length) {
                    if (stringArray[n3] != null) {
                        xMLControl.setValue("selected_views", stringArray);
                        break;
                    }
                    ++n3;
                }
                serializable = TToolBar.getToolbar(trackerPanel);
                xMLControl.setValue("toolbar", serializable);
                TrackControl trackControl = trackerPanel.trackControl;
                if (trackControl != null && trackControl.isVisible()) {
                    n2 = trackControl.getLocation().x - ((Component)((Object)propertyChangeListener)).getLocation().x;
                    n = trackControl.getLocation().y - ((Component)((Object)propertyChangeListener)).getLocation().y;
                    xMLControl.setValue("track_control_x", n2);
                    xMLControl.setValue("track_control_y", n);
                }
                if (((TFrame)propertyChangeListener).notesDialog.isVisible()) {
                    n2 = ((TFrame)propertyChangeListener).notesDialog.getLocation().x - ((Component)((Object)propertyChangeListener)).getLocation().x;
                    n = ((TFrame)propertyChangeListener).notesDialog.getLocation().y - ((Component)((Object)propertyChangeListener)).getLocation().y;
                    xMLControl.setValue("info_x", n2);
                    xMLControl.setValue("info_y", n);
                }
            }
            object2 = new ArrayList();
            DataTool dataTool = DataTool.getTool();
            for (DataToolTab dataToolTab : dataTool.getTabs()) {
                serializable = trackerPanel.getTracks();
                for (TTrack tTrack : serializable) {
                    DatasetManager datasetManager = tTrack.getData(trackerPanel);
                    if (!dataToolTab.isOwnedBy(datasetManager)) continue;
                    dataToolTab.setOwner(tTrack.getName(), datasetManager);
                    for (TTrack tTrack2 : trackerPanel.getTracks()) {
                        dataToolTab.saveOwnedColumnNames(tTrack2.getName(), tTrack2.getData(trackerPanel));
                    }
                    ((ArrayList)object2).add(dataToolTab);
                }
            }
            if (!((ArrayList)object2).isEmpty()) {
                DataToolTab[] dataToolTabArray = ((ArrayList)object2).toArray(new DataToolTab[((ArrayList)object2).size()]);
                xMLControl.setValue("datatool_tabs", dataToolTabArray);
            }
            XMLPropertyElement.defaultWriteNullFinalArrayElements = bl;
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new TrackerPanel();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            String string;
            XMLProperty xMLProperty;
            Video video;
            List<Object> list;
            Object object2;
            Object object3;
            Object object4;
            double d;
            double d2;
            TrackerPanel trackerPanel = (TrackerPanel)object;
            String string2 = xMLControl.getString("version");
            if (string2 != null && (d2 = Double.parseDouble(string2)) - (d = Double.parseDouble("4.91")) > 0.2) {
                JOptionPane.showMessageDialog(trackerPanel, String.valueOf(TrackerRes.getString("TrackerPanel.Dialog.Version.Message1")) + " " + string2 + " " + TrackerRes.getString("TrackerPanel.Dialog.Version.Message2") + "\n" + TrackerRes.getString("TrackerPanel.Dialog.Version.Message3") + " (" + "4.91" + ")." + "\n\n" + TrackerRes.getString("TrackerPanel.Dialog.Version.Message4") + " " + Tracker.trackerWebsite + ".", TrackerRes.getString("TrackerPanel.Dialog.Version.Title"), 1);
            }
            trackerPanel.hideDescriptionWhenLoaded = xMLControl.getBoolean("hide_description");
            String string3 = xMLControl.getString("description");
            if (string3 != null) {
                trackerPanel.setDescription(string3);
            }
            trackerPanel.author = xMLControl.getString("author");
            trackerPanel.contact = xMLControl.getString("contact");
            XMLControl xMLControl2 = xMLControl.getChildControl("videoclip");
            if (xMLControl2 != null) {
                VideoClip videoClip = (VideoClip)xMLControl.getObject("videoclip");
                trackerPanel.getPlayer().setVideoClip(videoClip);
                object4 = videoClip.getVideo();
                if (object4 != null) {
                    object3 = object4.getFilterStack();
                    object2 = ((FilterStack)object3).getFilters().iterator();
                    while (object2.hasNext()) {
                        list = object2.next();
                        ((Filter)((Object)list)).setVideoPanel(trackerPanel);
                        if (((Filter)((Object)list)).inspectorX == Integer.MIN_VALUE) continue;
                        ((Filter)((Object)list)).inspectorVisible = true;
                        if (trackerPanel.visibleFilters == null) {
                            trackerPanel.visibleFilters = new HashMap<Filter, Point>();
                        }
                        Point point = new Point(((Filter)((Object)list)).inspectorX, ((Filter)((Object)list)).inspectorY);
                        trackerPanel.visibleFilters.put((Filter)((Object)list), point);
                    }
                }
            }
            if ((xMLControl2 = xMLControl.getChildControl("clipcontrol")) != null) {
                ClipControl clipControl = trackerPanel.getPlayer().getClipControl();
                xMLControl2.loadObject(clipControl);
            }
            if ((xMLControl2 = xMLControl.getChildControl("toolbar")) != null) {
                TToolBar tToolBar = TToolBar.getToolbar(trackerPanel);
                xMLControl2.loadObject(tToolBar);
            }
            if ((xMLControl2 = xMLControl.getChildControl("coords")) != null) {
                ImageCoordSystem imageCoordSystem = trackerPanel.getCoords();
                xMLControl2.loadObject(imageCoordSystem);
                int n = trackerPanel.getFrameNumber();
                trackerPanel.getSnapPoint().setXY(imageCoordSystem.getOriginX(n), imageCoordSystem.getOriginY(n));
            }
            if ((video = trackerPanel.getVideo()) != null && video.getClass().getSimpleName().contains("QT") && xMLControl.toXML().contains("ParticleDataTrack")) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if ((object4 = (ArrayList)ArrayList.class.cast(xMLControl.getObject("tracks"))) != null) {
                object2 = ((ArrayList)object4).iterator();
                while (object2.hasNext()) {
                    object3 = object2.next();
                    list = (TTrack)object3;
                    trackerPanel.addTrack((TTrack)((Object)list));
                }
            }
            if ((object3 = xMLControl.getString("referenceframe")) != null) {
                trackerPanel.setReferenceFrame((String)object3);
            }
            if ((object2 = (Configuration)xMLControl.getObject("configuration")) != null) {
                trackerPanel.enabled = ((Configuration)object2).enabled;
            }
            list = xMLControl.getPropertyContent();
            int n = -1;
            int n2 = 0;
            while (n2 < list.size()) {
                xMLProperty = (XMLProperty)list.get(n2);
                if (xMLProperty.getPropertyName().equals("selected_views")) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            trackerPanel.selectedViewsProperty = n > -1 ? (XMLProperty)list.get(n) : null;
            n = -1;
            n2 = 0;
            while (n2 < list.size()) {
                xMLProperty = (XMLProperty)list.get(n2);
                if (xMLProperty.getPropertyName().equals("views")) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            trackerPanel.viewsProperty = n > -1 ? (XMLProperty)list.get(n) : null;
            trackerPanel.dividerLocs = (double[])xMLControl.getObject("dividers");
            trackerPanel.trackControlX = xMLControl.getInt("track_control_x");
            trackerPanel.trackControlY = xMLControl.getInt("track_control_y");
            trackerPanel.infoX = xMLControl.getInt("info_x");
            trackerPanel.infoY = xMLControl.getInt("info_y");
            if (xMLControl.getPropertyNames().contains("width")) {
                trackerPanel.setImageWidth(xMLControl.getDouble("width"));
            }
            if (xMLControl.getPropertyNames().contains("height")) {
                trackerPanel.setImageHeight(xMLControl.getDouble("height"));
            }
            trackerPanel.setMagnification(xMLControl.getDouble("magnification"));
            if (xMLControl.getPropertyNames().contains("center_x")) {
                n2 = xMLControl.getInt("center_x");
                int n3 = xMLControl.getInt("center_y");
                trackerPanel.zoomCenter = new Point(n2, n3);
            }
            trackerPanel.setSelectedTrack((string = xMLControl.getString("selectedtrack")) == null ? null : trackerPanel.getTrack(string));
            if (xMLControl.getPropertyNames().contains("datatool_tabs")) {
                DataTool dataTool = DataTool.getTool();
                for (Object object5 : xMLControl.getPropertyContent()) {
                    XMLProperty xMLProperty2;
                    if (!(object5 instanceof XMLProperty) || !(xMLProperty2 = (XMLProperty)object5).getPropertyName().equals("datatool_tabs")) continue;
                    XMLControl[] xMLControlArray = xMLProperty2.getChildControls();
                    int n4 = xMLControlArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        DataToolTab dataToolTab;
                        String string4;
                        TTrack tTrack;
                        XMLControl xMLControl3 = xMLControlArray[n5];
                        ArrayList<DataToolTab> arrayList = null;
                        try {
                            arrayList = dataTool.addTabs(xMLControl3);
                        }
                        catch (Exception exception) {}
                        if (arrayList != null && !arrayList.isEmpty() && (tTrack = trackerPanel.getTrack(string4 = (dataToolTab = arrayList.get(0)).getOwnerName())) != null) {
                            DatasetManager datasetManager = tTrack.getData(trackerPanel);
                            dataToolTab.setOwner(string4, datasetManager);
                            DataRefreshTool dataRefreshTool = DataRefreshTool.getTool(datasetManager);
                            DatasetManager datasetManager2 = new DatasetManager();
                            datasetManager2.setID(datasetManager.getID());
                            try {
                                dataToolTab.send(new LocalJob(datasetManager2), dataRefreshTool);
                            }
                            catch (RemoteException remoteException) {
                                remoteException.printStackTrace();
                            }
                            for (TTrack tTrack2 : trackerPanel.getTracks()) {
                                DatasetManager datasetManager3 = tTrack2.getData(trackerPanel);
                                if (!dataToolTab.setOwnedColumnIDs(tTrack2.getName(), datasetManager3)) continue;
                                dataRefreshTool.addData(datasetManager3);
                            }
                        }
                        ++n5;
                    }
                }
            }
            return object;
        }
    }

    private class TMouseController
    extends InteractivePanel.IADMouseController {
        private TMouseController() {
            super(TrackerPanel.this);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            if (TrackerPanel.this.getSelectedPoint() != null) {
                TrackerPanel.this.getSelectedPoint().showCoordinates(TrackerPanel.this);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            TrackerPanel.this.setMouseCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            if (TrackerPanel.this.getSelectedPoint() == null) {
                TrackerPanel.this.blMessageBox.setText(null);
            }
            TrackerPanel.this.setMouseCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (TrackerPanel.this.showCoordinates && TrackerPanel.this.getSelectedPoint() == null) {
                String string = TrackerPanel.this.coordinateStrBuilder.getCoordinateString(TrackerPanel.this, mouseEvent);
                TrackerPanel.this.blMessageBox.setText(string);
            }
            super.mouseMoved(mouseEvent);
        }
    }
}

