/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;

public abstract class TrackView
extends JScrollPane
implements PropertyChangeListener {
    protected TTrack track;
    protected TrackerPanel trackerPanel;
    protected ArrayList<Component> toolbarComponents = new ArrayList();

    protected TrackView(TTrack tTrack, TrackerPanel trackerPanel) {
        this.track = tTrack;
        this.trackerPanel = trackerPanel;
        this.trackerPanel.addPropertyChangeListener("selectedpoint", this);
    }

    abstract void refresh(int var1);

    abstract void refreshGUI();

    abstract void dispose();

    abstract boolean isCustomState();

    abstract JButton getViewButton();

    @Override
    public String getName() {
        if (this.track == null) {
            return null;
        }
        return this.track.getName();
    }

    Icon getIcon() {
        if (this.track == null) {
            return null;
        }
        return this.track.getFootprint().getIcon(21, 16);
    }

    TTrack getTrack() {
        return this.track;
    }

    public ArrayList<Component> getToolBarComponents() {
        return this.toolbarComponents;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("step")) {
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            this.refresh(n);
        } else if (string.equals("steps")) {
            this.refresh(this.trackerPanel.getFrameNumber());
        } else if (string.equals("selectedpoint")) {
            Step step = this.trackerPanel.getSelectedStep();
            if (step != null && this.trackerPanel.getSelectedTrack() == this.track) {
                this.refresh(step.getFrameNumber());
            } else {
                this.refresh(this.trackerPanel.getFrameNumber());
            }
        }
    }

    protected boolean isRefreshEnabled() {
        return this.trackerPanel.isAutoRefresh;
    }
}

