/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.cabrillo.tracker.DerivativeAlgorithmDialog;
import org.opensourcephysics.cabrillo.tracker.LineProfile;
import org.opensourcephysics.cabrillo.tracker.PlotTView;
import org.opensourcephysics.cabrillo.tracker.PlotTrackView;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TrackView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.axes.CartesianInteractive;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.DataRefreshTool;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.Tool;

public class TrackPlottingPanel
extends PlottingPanel
implements Tool {
    protected static final String DEFINED_AS = ": ";
    protected TTrack track;
    protected DatasetManager data;
    protected HighlightableDataset dataset = new HighlightableDataset();
    protected ArrayList<TTrack> guests = new ArrayList();
    protected HashMap<TTrack, HighlightableDataset> guestDatasets = new HashMap();
    protected JRadioButtonMenuItem[] xChoices;
    protected JRadioButtonMenuItem[] yChoices;
    protected ButtonGroup xGroup;
    protected ButtonGroup yGroup;
    protected int xIndex = -1;
    protected int yIndex = 0;
    protected JPopupMenu xPopup;
    protected JPopupMenu yPopup;
    protected JPopupMenu popup;
    protected Action dataFunctionListener;
    protected Action guestListener;
    protected JMenuItem copyImageItem;
    protected JMenuItem dataBuilderItem;
    protected JMenuItem dataToolItem;
    protected JMenuItem showXZeroItem;
    protected JMenuItem showYZeroItem;
    protected JMenuItem algorithmItem;
    protected JMenuItem printItem;
    protected JMenuItem helpItem;
    protected JMenuItem mergeYScalesItem;
    protected JCheckBoxMenuItem linesItem;
    protected JCheckBoxMenuItem pointsItem;
    protected JMenu guestMenu;
    protected String xLabel;
    protected String yLabel;
    protected String title;
    protected int highlightIndex;
    protected ItemListener xListener;
    protected ItemListener yListener;
    protected PlotTrackView plotTrackView;
    protected boolean isCustom;
    protected Font font = new JTextField().getFont();
    protected Rectangle hitRect = new Rectangle(24, 24);
    protected ClickableAxes plotAxes;
    protected boolean isZoomMode;
    protected PlotMouseListener mouseListener;
    protected PropertyChangeListener playerListener;
    protected Step clickedStep;

    public TrackPlottingPanel(TTrack tTrack, DatasetManager datasetManager) {
        super(" ", " ", " ");
        this.track = tTrack;
        this.data = datasetManager;
        this.dataset.setConnected(true);
        this.dataset.setMarkerShape(2);
        this.xListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    JMenuItem jMenuItem = (JMenuItem)itemEvent.getSource();
                    TrackPlottingPanel.this.setXVariable(jMenuItem.getText());
                    TrackPlottingPanel.this.plotData();
                    TrackPlottingPanel.this.isCustom = true;
                    TrackPlottingPanel.this.track.trackerPanel.changed = true;
                }
            }
        };
        this.yListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    JMenuItem jMenuItem = (JMenuItem)itemEvent.getSource();
                    TrackPlottingPanel.this.setYVariable(jMenuItem.getText());
                    TrackPlottingPanel.this.plotData();
                    TrackPlottingPanel.this.isCustom = true;
                    TrackPlottingPanel.this.track.trackerPanel.changed = true;
                }
            }
        };
        this.playerListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (TrackPlottingPanel.this.clickedStep == null) {
                    return;
                }
                TPoint tPoint = TrackPlottingPanel.this.clickedStep.getDefaultPoint();
                TrackPlottingPanel.this.plotTrackView.trackerPanel.setSelectedPoint(tPoint);
                tPoint.showCoordinates(TrackPlottingPanel.this.plotTrackView.trackerPanel);
                TrackPlottingPanel.this.clickedStep = null;
                TrackPlottingPanel.this.repaint();
            }
        };
        this.createVarChoices();
        this.plotAxes = new ClickableAxes(this);
        this.setAxes(this.plotAxes);
        this.mouseListener = new PlotMouseListener();
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (!TrackPlottingPanel.this.plotTrackView.trackerPanel.getPlayer().isEnabled()) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 33: {
                        if (keyEvent.isShiftDown()) {
                            int n = TrackPlottingPanel.this.plotTrackView.trackerPanel.getPlayer().getStepNumber() - 5;
                            TrackPlottingPanel.this.plotTrackView.trackerPanel.getPlayer().setStepNumber(n);
                            break;
                        }
                        TrackPlottingPanel.this.plotTrackView.trackerPanel.getPlayer().back();
                        break;
                    }
                    case 34: {
                        if (keyEvent.isShiftDown()) {
                            int n = TrackPlottingPanel.this.plotTrackView.trackerPanel.getPlayer().getStepNumber() + 5;
                            TrackPlottingPanel.this.plotTrackView.trackerPanel.getPlayer().setStepNumber(n);
                            break;
                        }
                        TrackPlottingPanel.this.plotTrackView.trackerPanel.getPlayer().step();
                        break;
                    }
                    case 36: {
                        TrackPlottingPanel.this.plotTrackView.trackerPanel.getPlayer().setStepNumber(0);
                        break;
                    }
                    case 35: {
                        VideoClip videoClip = TrackPlottingPanel.this.plotTrackView.trackerPanel.getPlayer().getVideoClip();
                        TrackPlottingPanel.this.plotTrackView.trackerPanel.getPlayer().setStepNumber(videoClip.getStepCount() - 1);
                        break;
                    }
                    case 127: {
                        TrackPlottingPanel.this.plotTrackView.trackerPanel.deleteSelectedSteps();
                        if (TrackPlottingPanel.this.plotTrackView.trackerPanel.selectedPoint != null && TrackPlottingPanel.this.plotTrackView.trackerPanel.selectingPanel == TrackPlottingPanel.this.plotTrackView.trackerPanel) {
                            TrackPlottingPanel.this.plotTrackView.trackerPanel.deletePoint(TrackPlottingPanel.this.plotTrackView.trackerPanel.selectedPoint);
                        }
                        return;
                    }
                }
            }
        });
    }

    @Override
    public void send(Job job, Tool tool) {
        XMLControlElement xMLControlElement = new XMLControlElement();
        try {
            xMLControlElement.readXML(job.getXML());
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        ArrayList<Dataset> arrayList = this.getObjectOfClass(Dataset.class);
        block2: for (Dataset dataset : xMLControlElement.getObjects(Dataset.class)) {
            int n = dataset.getID();
            int n2 = 0;
            int n3 = arrayList.size();
            while (n2 < n3) {
                if (arrayList.get(n2).getID() == n) {
                    this.copyProperties(dataset, arrayList.get(n2));
                    continue block2;
                }
                ++n2;
            }
        }
        this.repaint();
    }

    public HighlightableDataset getDataset() {
        return this.dataset;
    }

    @Override
    public void setXLabel(String string) {
        super.setXLabel(string);
        this.xLabel = string;
        this.dataset.setXYColumnNames(string, this.yLabel);
        String string2 = String.valueOf(TeXParser.removeSubscripting(this.xLabel)) + "=";
        String string3 = "  " + TeXParser.removeSubscripting(this.yLabel) + "=";
        this.getCoordinateStringBuilder().setCoordinateLabels(string2, string3);
    }

    public String getXLabel() {
        return this.xLabel;
    }

    @Override
    public void setYLabel(String string) {
        super.setYLabel(string);
        this.yLabel = string;
        this.dataset.setXYColumnNames(this.xLabel, string);
        String string2 = String.valueOf(TeXParser.removeSubscripting(this.xLabel)) + "=";
        String string3 = "  " + TeXParser.removeSubscripting(this.yLabel) + "=";
        this.getCoordinateStringBuilder().setCoordinateLabels(string2, string3);
    }

    public String getYLabel() {
        return this.yLabel;
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
        this.title = string;
        this.dataset.setName(string);
    }

    public String getTitle() {
        return this.title;
    }

    public void addGuest(TTrack tTrack) {
        if (this.guests.contains(tTrack)) {
            return;
        }
        this.guests.add(tTrack);
        this.isCustom = true;
        HighlightableDataset highlightableDataset = this.guestDatasets.get(tTrack);
        if (highlightableDataset == null) {
            highlightableDataset = new HighlightableDataset();
            this.guestDatasets.put(tTrack, highlightableDataset);
        }
        tTrack.addPropertyChangeListener("step", this.plotTrackView);
        tTrack.addPropertyChangeListener("steps", this.plotTrackView);
    }

    public void removeGuest(TTrack tTrack) {
        this.guests.remove(tTrack);
        tTrack.removePropertyChangeListener("step", this.plotTrackView);
        tTrack.removePropertyChangeListener("steps", this.plotTrackView);
    }

    @Override
    public void scale(ArrayList<Drawable> arrayList) {
        if (this.autoscaleXMin && !this.autoscaleXMax) {
            this.scaleXMin();
        } else if (!this.autoscaleXMin && this.autoscaleXMax) {
            this.scaleXMax();
        } else if (this.autoscaleXMin && this.autoscaleXMax) {
            this.scaleX(arrayList);
        }
        if (this.autoscaleYMin && !this.autoscaleYMax) {
            this.scaleYMin();
        } else if (!this.autoscaleYMin && this.autoscaleYMax) {
            this.scaleYMax();
        } else if (this.autoscaleYMin && this.autoscaleYMax) {
            this.scaleY(arrayList);
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        Object object;
        this.mergeYScalesItem.setText(TrackerRes.getString("TrackPlottingPanel.Popup.MenuItem.MergeYAxes"));
        this.linesItem.setText(TrackerRes.getString("TrackPlottingPanel.Popup.MenuItem.Lines"));
        this.pointsItem.setText(TrackerRes.getString("TrackPlottingPanel.Popup.MenuItem.Points"));
        this.printItem.setText(TrackerRes.getString("TActions.Action.Print"));
        this.copyImageItem.setText(TrackerRes.getString("TMenuBar.Menu.CopyImage"));
        this.dataBuilderItem.setText(TrackerRes.getString("TView.Menuitem.Define"));
        this.dataToolItem.setText(TrackerRes.getString("TableTrackView.Popup.MenuItem.Analyze"));
        this.algorithmItem.setText(TrackerRes.getString("Popup.MenuItem.Algorithm"));
        this.helpItem.setText(TrackerRes.getString("Tracker.Popup.MenuItem.Help"));
        this.guestMenu.setText(TrackerRes.getString("TrackPlottingPanel.Popup.Menu.CompareWith"));
        if (this.plotTrackView.mainView.getComponentCount() > 1) {
            this.popupmenu.add((Component)this.mergeYScalesItem, 3);
        } else {
            this.popupmenu.remove(this.mergeYScalesItem);
        }
        this.popupmenu.remove(this.showXZeroItem);
        this.popupmenu.remove(this.showYZeroItem);
        if (this.getXMin() * this.getXMax() > 0.0) {
            object = TeXParser.removeSubscripting(this.dataset.getColumnName(0));
            object = String.valueOf(TrackerRes.getString("TrackPlottingPanel.Popup.MenuItem.ShowZero")) + " " + (String)object + "=0";
            this.showXZeroItem.setText((String)object);
            this.popupmenu.insert(this.showXZeroItem, this.popupmenu.getComponentIndex(this.scaleItem));
        }
        if (this.getYMin() * this.getYMax() > 0.0) {
            object = TeXParser.removeSubscripting(this.dataset.getColumnName(1));
            object = String.valueOf(TrackerRes.getString("TrackPlottingPanel.Popup.MenuItem.ShowZero")) + " " + (String)object + "=0";
            this.showYZeroItem.setText((String)object);
            this.popupmenu.insert(this.showYZeroItem, this.popupmenu.getComponentIndex(this.scaleItem));
        }
        object = this.track instanceof PointMass ? PointMass.class : (this.track instanceof Vector ? Vector.class : this.track.getClass());
        ArrayList arrayList = this.track.trackerPanel.getDrawables(object);
        arrayList.removeAll(this.track.trackerPanel.calibrationTools);
        this.guestMenu.removeAll();
        for (TTrack tTrack : arrayList) {
            if (tTrack == this.track) continue;
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(tTrack.getName(), tTrack.getFootprint().getIcon(21, 16));
            jCheckBoxMenuItem.setSelected(this.guests.contains(tTrack));
            jCheckBoxMenuItem.addActionListener(this.guestListener);
            this.guestMenu.add(jCheckBoxMenuItem);
        }
        this.guestMenu.setEnabled(this.guestMenu.getItemCount() > 0);
        FontSizer.setFonts(this.popup, FontSizer.getLevel());
        return this.popupmenu;
    }

    @Override
    public void snapshot() {
        Container container = this;
        Container container2 = this.getParent();
        while (container2 != null) {
            if (container2 instanceof TViewChooser) {
                container = container2;
                break;
            }
            container2 = container2.getParent();
        }
        TrackerIO.ComponentImage componentImage = new TrackerIO.ComponentImage(container);
        BufferedImage bufferedImage = componentImage.getImage();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (n == 0 || n2 == 0) {
            return;
        }
        MeasuredImage measuredImage = new MeasuredImage(bufferedImage, 0.0, n, n2, 0.0);
        OSPFrame oSPFrame = null;
        try {
            Class<?> clazz = Class.forName("org.opensourcephysics.frames.ImageFrame");
            Constructor<?>[] constructorArray = clazz.getConstructors();
            int n3 = 0;
            while (n3 < constructorArray.length) {
                Class<?>[] classArray = constructorArray[n3].getParameterTypes();
                if (classArray.length == 1 && classArray[0] == MeasuredImage.class) {
                    oSPFrame = (OSPFrame)constructorArray[n3].newInstance(measuredImage);
                    break;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (oSPFrame == null) {
            return;
        }
        oSPFrame.setTitle(DisplayRes.getString("Snapshot.Title"));
        oSPFrame.setDefaultCloseOperation(2);
        oSPFrame.setKeepHidden(false);
        FontSizer.setFonts(oSPFrame, FontSizer.getLevel());
        oSPFrame.pack();
        oSPFrame.setVisible(true);
    }

    @Override
    protected void buildPopupmenu() {
        if (this.popup == null) {
            this.popup = new JPopupMenu(){

                @Override
                public void setVisible(boolean bl) {
                    super.setVisible(bl);
                    if (!bl) {
                        TrackPlottingPanel.this.zoomBox.hide();
                    }
                }
            };
            this.setPopupMenu(this.popup);
            super.buildPopupmenu();
            this.linesItem = new JCheckBoxMenuItem();
            this.linesItem.setSelected(true);
            this.linesItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TrackPlottingPanel.this.dataset.setConnected(TrackPlottingPanel.this.linesItem.isSelected());
                    for (TTrack tTrack : TrackPlottingPanel.this.guests) {
                        HighlightableDataset highlightableDataset = TrackPlottingPanel.this.guestDatasets.get(tTrack);
                        highlightableDataset.setConnected(TrackPlottingPanel.this.linesItem.isSelected());
                    }
                    TrackPlottingPanel.this.isCustom = true;
                    TrackPlottingPanel.this.repaint();
                }
            });
            this.pointsItem = new JCheckBoxMenuItem();
            this.pointsItem.setSelected(true);
            this.pointsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (TrackPlottingPanel.this.pointsItem.isSelected()) {
                        TrackPlottingPanel.this.dataset.setMarkerShape(2);
                        for (TTrack tTrack : TrackPlottingPanel.this.guests) {
                            HighlightableDataset highlightableDataset = TrackPlottingPanel.this.guestDatasets.get(tTrack);
                            highlightableDataset.setMarkerShape(2);
                        }
                    } else {
                        TrackPlottingPanel.this.dataset.setMarkerShape(0);
                        for (TTrack tTrack : TrackPlottingPanel.this.guests) {
                            HighlightableDataset highlightableDataset = TrackPlottingPanel.this.guestDatasets.get(tTrack);
                            highlightableDataset.setMarkerShape(0);
                        }
                    }
                    TrackPlottingPanel.this.isCustom = true;
                    TrackPlottingPanel.this.repaint();
                }
            });
            this.showXZeroItem = new JMenuItem();
            this.showXZeroItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TrackPlottingPanel.this.showZeroOnAxis("x");
                }
            });
            this.showYZeroItem = new JMenuItem();
            this.showYZeroItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TrackPlottingPanel.this.showZeroOnAxis("y");
                }
            });
            this.printItem = new JMenuItem();
            this.printItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TViewChooser tViewChooser = TrackPlottingPanel.this.getOwner();
                    if (tViewChooser != null) {
                        new TrackerIO.ComponentImage(tViewChooser).print();
                    }
                }
            });
            this.dataToolItem = new JMenuItem();
            this.dataToolItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    DataTool dataTool = DataTool.getTool();
                    DataToolTab dataToolTab = dataTool.getTab(TrackPlottingPanel.this.data);
                    dataTool.setUseChooser(false);
                    dataTool.setSaveChangesOnClose(false);
                    DatasetManager datasetManager = new DatasetManager();
                    DataRefreshTool dataRefreshTool = DataRefreshTool.getTool(TrackPlottingPanel.this.data);
                    datasetManager.setID(TrackPlottingPanel.this.data.getID());
                    datasetManager.setName(TrackPlottingPanel.this.track.getName());
                    int n = 0;
                    Dataset dataset = TrackPlottingPanel.this.data.getDataset(0);
                    String string = dataset.getXColumnName();
                    XMLControlElement xMLControlElement = new XMLControlElement(dataset);
                    Dataset dataset2 = datasetManager.getDataset(n++);
                    xMLControlElement.loadObject(dataset2, true, true);
                    dataset2.setYColumnVisible(false);
                    dataset2.setConnected(false);
                    dataset2.setMarkerShape(0);
                    double[] dArray = dataset2.getXPoints();
                    if (!TrackPlottingPanel.this.guests.isEmpty()) {
                        object = new TreeSet();
                        double[] dArray2 = dArray;
                        int n2 = dArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            double d = dArray2[n3];
                            ((TreeSet)object).add(d);
                            ++n3;
                        }
                        for (TTrack tTrack : TrackPlottingPanel.this.guests) {
                            DatasetManager datasetManager2 = tTrack.getData(tTrack.trackerPanel);
                            Dataset dataset3 = datasetManager2.getDataset(0);
                            double[] dArray3 = dArray2 = dataset3.getXPoints();
                            int n4 = dArray2.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                double d = dArray3[n5];
                                ((TreeSet)object).add(d);
                                ++n5;
                            }
                        }
                        dArray = new double[((TreeSet)object).size()];
                        Double[] object2 = ((AbstractCollection)object).toArray(new Double[dArray.length]);
                        int n6 = 0;
                        while (n6 < dArray.length) {
                            dArray[n6] = object2[n6];
                            ++n6;
                        }
                        TrackPlottingPanel.this.padDataset(dataset2, dArray);
                    }
                    if (TrackPlottingPanel.this.xIndex >= 0) {
                        dataset = TrackPlottingPanel.this.data.getDataset(TrackPlottingPanel.this.xIndex);
                        string = dataset.getYColumnName();
                        xMLControlElement = new XMLControlElement(dataset);
                        dataset2 = datasetManager.getDataset(n++);
                        xMLControlElement.loadObject(dataset2, true, true);
                        dataset2.setMarkerColor(TrackPlottingPanel.this.track.getColor());
                        dataset2.setLineColor(TrackPlottingPanel.this.track.getColor().darker());
                        dataset2.setConnected(true);
                        dataset2.setXColumnVisible(false);
                        if (!TrackPlottingPanel.this.guests.isEmpty()) {
                            TrackPlottingPanel.this.padDataset(dataset2, dArray);
                        }
                    }
                    dataset = TrackPlottingPanel.this.data.getDataset(TrackPlottingPanel.this.yIndex);
                    object = dataset.getYColumnName();
                    if (TrackPlottingPanel.this.yIndex != TrackPlottingPanel.this.xIndex) {
                        xMLControlElement = new XMLControlElement(dataset);
                        dataset2 = datasetManager.getDataset(n++);
                        xMLControlElement.loadObject(dataset2, true, true);
                        dataset2.setMarkerColor(TrackPlottingPanel.this.track.getColor());
                        dataset2.setLineColor(TrackPlottingPanel.this.track.getColor().darker());
                        dataset2.setConnected(true);
                        dataset2.setXColumnVisible(false);
                        if (!TrackPlottingPanel.this.guests.isEmpty()) {
                            TrackPlottingPanel.this.padDataset(dataset2, dArray);
                        }
                    }
                    for (TTrack tTrack : TrackPlottingPanel.this.guests) {
                        String string2;
                        DatasetManager datasetManager3 = tTrack.getData(tTrack.trackerPanel);
                        dataRefreshTool.addData(datasetManager3);
                        if (TrackPlottingPanel.this.xIndex >= 0) {
                            String string3;
                            dataset = datasetManager3.getDataset(TrackPlottingPanel.this.xIndex);
                            xMLControlElement = new XMLControlElement(dataset);
                            dataset2 = datasetManager.getDataset(n++);
                            xMLControlElement.loadObject(dataset2, true, true);
                            dataset2.setMarkerColor(tTrack.getColor());
                            dataset2.setLineColor(tTrack.getColor().darker());
                            dataset2.setConnected(true);
                            dataset2.setXColumnVisible(false);
                            if (dataToolTab != null) {
                                string3 = dataToolTab.getColumnName(dataset2.getID());
                                if (string3 != null) {
                                    dataset2.setXYColumnNames(dataset2.getXColumnName(), string3);
                                }
                            } else {
                                string3 = String.valueOf(dataset2.getYColumnName()) + "_{" + tTrack.getName() + "}";
                                dataset2.setXYColumnNames(dataset2.getXColumnName(), string3);
                            }
                            TrackPlottingPanel.this.padDataset(dataset2, dArray);
                        }
                        if (TrackPlottingPanel.this.yIndex == TrackPlottingPanel.this.xIndex) continue;
                        dataset = datasetManager3.getDataset(TrackPlottingPanel.this.yIndex);
                        xMLControlElement = new XMLControlElement(dataset);
                        dataset2 = datasetManager.getDataset(n++);
                        xMLControlElement.loadObject(dataset2, true, true);
                        dataset2.setMarkerColor(tTrack.getColor());
                        dataset2.setLineColor(tTrack.getColor().darker());
                        dataset2.setConnected(true);
                        dataset2.setXColumnVisible(false);
                        if (dataToolTab != null) {
                            string2 = dataToolTab.getColumnName(dataset2.getID());
                            if (string2 != null) {
                                dataset2.setXYColumnNames(dataset2.getXColumnName(), string2);
                            }
                        } else {
                            string2 = String.valueOf(dataset2.getYColumnName()) + "_{" + tTrack.getName() + "}";
                            dataset2.setXYColumnNames(dataset2.getXColumnName(), string2);
                        }
                        TrackPlottingPanel.this.padDataset(dataset2, dArray);
                    }
                    try {
                        dataTool.send(new LocalJob(datasetManager), dataRefreshTool);
                        dataToolTab = dataTool.getTab(datasetManager);
                        if (dataToolTab != null) {
                            dataToolTab.setWorkingColumns(string, (String)object);
                        }
                        dataTool.setVisible(true);
                    }
                    catch (RemoteException remoteException) {
                        remoteException.printStackTrace();
                    }
                }
            });
            this.algorithmItem = new JMenuItem();
            this.algorithmItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DerivativeAlgorithmDialog derivativeAlgorithmDialog = TrackPlottingPanel.this.track.trackerPanel.getAlgorithmDialog();
                    FontSizer.setFonts(derivativeAlgorithmDialog, FontSizer.getLevel());
                    derivativeAlgorithmDialog.pack();
                    derivativeAlgorithmDialog.setVisible(true);
                }
            });
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TViewChooser tViewChooser = TrackPlottingPanel.this.getOwner();
                    if (tViewChooser != null) {
                        new TrackerIO.ComponentImage(tViewChooser).copyToClipboard();
                    }
                }
            };
            this.copyImageItem = new JMenuItem(abstractAction);
            this.dataFunctionListener = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (TrackPlottingPanel.this.track.trackerPanel != null) {
                        TrackPlottingPanel.this.track.trackerPanel.getDataBuilder().setSelectedPanel(TrackPlottingPanel.this.track.getName());
                        TrackPlottingPanel.this.track.trackerPanel.getDataBuilder().setVisible(true);
                    }
                }
            };
            this.dataBuilderItem = new JMenuItem();
            this.dataBuilderItem.addActionListener(this.dataFunctionListener);
            this.helpItem = new JMenuItem();
            this.helpItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Container container = TrackPlottingPanel.this.getTopLevelAncestor();
                    if (container instanceof TFrame) {
                        TFrame tFrame = (TFrame)container;
                        tFrame.showHelp("plot", 0);
                    }
                }
            });
            this.mergeYScalesItem = new JMenuItem();
            this.mergeYScalesItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = TrackPlottingPanel.this.plotTrackView.mainView.getComponentCount();
                    if (n == 2) {
                        TrackPlottingPanel.this.plotTrackView.syncYAxes(TrackPlottingPanel.this.plotTrackView.plots[0], TrackPlottingPanel.this.plotTrackView.plots[1]);
                    }
                    if (n == 3) {
                        TrackPlottingPanel.this.plotTrackView.syncYAxes(TrackPlottingPanel.this.plotTrackView.plots);
                    }
                }
            });
        }
        this.guestMenu = new JMenu();
        this.guestListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                TTrack tTrack = TrackPlottingPanel.this.track.trackerPanel.getTrack(jMenuItem.getText());
                if (jMenuItem.isSelected()) {
                    TrackPlottingPanel.this.addGuest(tTrack);
                } else {
                    TrackPlottingPanel.this.removeGuest(tTrack);
                }
                TrackPlottingPanel.this.plotData();
            }
        };
        this.popupmenu.removeAll();
        this.popupmenu.add(this.zoomInItem);
        this.popupmenu.add(this.zoomOutItem);
        this.popupmenu.add(this.autoscaleItem);
        this.popupmenu.add(this.showYZeroItem);
        this.popupmenu.add(this.showXZeroItem);
        this.popupmenu.add(this.scaleItem);
        this.popupmenu.addSeparator();
        this.popupmenu.add(this.pointsItem);
        this.popupmenu.add(this.linesItem);
        if (this.track != null && this.track.trackerPanel != null) {
            if (this.track.trackerPanel.isEnabled("edit.copyImage")) {
                this.popupmenu.addSeparator();
                this.popupmenu.add(this.copyImageItem);
                this.popupmenu.add(this.snapshotItem);
            }
            this.popupmenu.add(this.guestMenu);
            this.popupmenu.addSeparator();
            if (this.track.trackerPanel.isEnabled("data.builder") || this.track.trackerPanel.isEnabled("data.tool")) {
                if (this.track.trackerPanel.isEnabled("data.builder")) {
                    this.popupmenu.add(this.dataBuilderItem);
                }
                if (this.track.trackerPanel.isEnabled("data.tool")) {
                    this.popupmenu.add(this.dataToolItem);
                }
            }
            if (this.track.trackerPanel.isEnabled("data.algorithm")) {
                this.popupmenu.addSeparator();
                this.popupmenu.add(this.algorithmItem);
            }
            if (this.track.trackerPanel.isEnabled("file.print")) {
                this.popupmenu.addSeparator();
                this.popupmenu.add(this.printItem);
            }
        }
        this.popupmenu.addSeparator();
        this.popupmenu.add(this.helpItem);
    }

    @Override
    protected Rectangle findViewRect() {
        Rectangle rectangle = null;
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof JViewport) {
                rectangle = ((JViewport)container).getViewRect();
                Rectangle rectangle2 = this.getBounds();
                rectangle = rectangle.intersection(rectangle2);
                rectangle.y -= rectangle2.y;
                break;
            }
            container = container.getParent();
        }
        return rectangle;
    }

    protected void showZeroOnAxis(String string) {
        if (string.equals("x")) {
            if (this.xmin * this.xmax > 0.0) {
                if (this.xmax > 0.0) {
                    this.xmin = 0.0;
                } else {
                    this.xmax = 0.0;
                }
                this.setPreferredMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
                this.repaint();
                this.isCustom = true;
            }
        } else if (this.ymin * this.ymax > 0.0) {
            if (this.ymax > 0.0) {
                this.ymin = 0.0;
            } else {
                this.ymax = 0.0;
            }
            this.setPreferredMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
            this.repaint();
            this.isCustom = true;
        }
    }

    protected void scaleXMin() {
        double d = Double.MAX_VALUE;
        HighlightableDataset highlightableDataset = this.getDataset();
        if (highlightableDataset != null && highlightableDataset.isMeasured()) {
            if (!Double.isNaN(highlightableDataset.getXMin())) {
                d = Math.min(d, highlightableDataset.getXMin());
            }
            if (d == this.xmaxPreferred) {
                d = 0.9 * d - 0.5;
            }
            double d2 = this.xmaxPreferred - d;
            this.xminPreferred = d - this.autoscaleMargin * d2;
        }
        if (!Double.isNaN(this.xfloor)) {
            this.xminPreferred = Math.min(this.xfloor, this.xminPreferred);
        }
    }

    protected void scaleXMax() {
        double d = -1.7976931348623157E308;
        HighlightableDataset highlightableDataset = this.getDataset();
        if (highlightableDataset != null && highlightableDataset.isMeasured()) {
            if (!Double.isNaN(highlightableDataset.getXMax())) {
                d = Math.max(d, highlightableDataset.getXMax());
            }
            if (this.xminPreferred == d) {
                d = 1.1 * d + 0.5;
            }
            double d2 = d - this.xminPreferred;
            this.xmaxPreferred = d + this.autoscaleMargin * d2;
        }
        if (!Double.isNaN(this.xceil)) {
            this.xmaxPreferred = Math.max(this.xceil, this.xmaxPreferred);
        }
    }

    protected void scaleYMin() {
        double d = Double.MAX_VALUE;
        HighlightableDataset highlightableDataset = this.getDataset();
        if (highlightableDataset != null && highlightableDataset.isMeasured()) {
            if (!Double.isNaN(highlightableDataset.getYMin())) {
                d = Math.min(d, highlightableDataset.getYMin());
            }
            if (d == this.ymaxPreferred) {
                d = 0.9 * d - 0.5;
            }
            double d2 = this.ymaxPreferred - d;
            this.yminPreferred = d - this.autoscaleMargin * d2;
        }
        if (!Double.isNaN(this.yfloor)) {
            this.yminPreferred = Math.min(this.yfloor, this.yminPreferred);
        }
    }

    protected void scaleYMax() {
        double d = -1.7976931348623157E308;
        HighlightableDataset highlightableDataset = this.getDataset();
        if (highlightableDataset != null && highlightableDataset.isMeasured()) {
            if (!Double.isNaN(highlightableDataset.getYMax())) {
                d = Math.max(d, highlightableDataset.getYMax());
            }
            if (this.yminPreferred == d) {
                d = 1.1 * d + 0.5;
            }
            double d2 = d - this.yminPreferred;
            this.ymaxPreferred = d + this.autoscaleMargin * d2;
        }
        if (!Double.isNaN(this.yceil)) {
            this.ymaxPreferred = Math.max(this.yceil, this.ymaxPreferred);
        }
    }

    protected TViewChooser getOwner() {
        if (this.track.trackerPanel == null) {
            return null;
        }
        TFrame tFrame = this.track.trackerPanel.getTFrame();
        if (tFrame == null) {
            return null;
        }
        Container[] containerArray = tFrame.getViews(this.track.trackerPanel);
        int n = 0;
        while (n < containerArray.length) {
            PlotTView plotTView;
            TrackView trackView;
            TViewChooser tViewChooser;
            if (containerArray[n] instanceof TViewChooser && (tViewChooser = (TViewChooser)containerArray[n]).getSelectedView() instanceof PlotTView && (trackView = (plotTView = (PlotTView)tViewChooser.getSelectedView()).getTrackView(plotTView.getSelectedTrack())) != null && trackView.equals(this.plotTrackView)) {
                return tViewChooser;
            }
            ++n;
        }
        return null;
    }

    protected void plotData() {
        this.removeDrawables(Dataset.class);
        Dataset dataset = this.xIndex == -1 ? this.data.getDataset(0) : this.data.getDataset(this.xIndex);
        Dataset dataset2 = this.data.getDataset(this.yIndex);
        String string = this.xIndex == -1 ? dataset.getColumnName(0) : dataset.getColumnName(1);
        String string2 = dataset2.getColumnName(1);
        this.setTitle(String.valueOf(this.track.getName()) + " (" + string + ", " + string2 + ")");
        this.setXLabel(string);
        this.setYLabel(string2);
        boolean bl = string.startsWith(Tracker.THETA) || string.startsWith(Tracker.OMEGA) || string.startsWith(Tracker.ALPHA);
        boolean bl2 = string2.startsWith(Tracker.THETA) || string2.startsWith(Tracker.OMEGA) || string2.startsWith(Tracker.ALPHA);
        boolean bl3 = this.track.trackerPanel != null && this.track.trackerPanel.getTFrame() != null && !this.track.trackerPanel.getTFrame().anglesInRadians;
        this.refreshDataset(this.dataset, this.data, bl, bl2, bl3);
        this.addDrawable(this.dataset);
        for (TTrack tTrack : this.guests) {
            DatasetManager datasetManager = tTrack.getData(tTrack.trackerPanel);
            HighlightableDataset highlightableDataset = this.guestDatasets.get(tTrack);
            highlightableDataset.setMarkerColor(tTrack.getColor());
            highlightableDataset.setHighlightColor(tTrack.getColor());
            this.refreshDataset(highlightableDataset, datasetManager, bl, bl2, bl3);
            this.addDrawable(highlightableDataset);
        }
        this.dataset.clearHighlights();
        if (this.highlightIndex >= 0 && this.dataset.getIndex() > this.highlightIndex) {
            this.dataset.setHighlighted(this.highlightIndex, true);
        }
        this.showPlotCoordinates(this.highlightIndex);
        this.repaint();
    }

    protected void refreshDataset(HighlightableDataset highlightableDataset, DatasetManager datasetManager, boolean bl, boolean bl2, boolean bl3) {
        int n = datasetManager.hashCode() & 0xFFFF;
        highlightableDataset.setID(n + this.xIndex * 100 + this.yIndex * 10);
        highlightableDataset.setConnected(this.dataset.isConnected());
        highlightableDataset.setMarkerShape(this.dataset.getMarkerShape());
        highlightableDataset.clear();
        Dataset dataset = this.xIndex == -1 ? datasetManager.getDataset(0) : datasetManager.getDataset(this.xIndex);
        Dataset dataset2 = datasetManager.getDataset(this.yIndex);
        dataset.setYColumnVisible(true);
        dataset2.setYColumnVisible(true);
        double d = this.getMean(dataset.getXPoints());
        if (this.xIndex > -1) {
            d = this.getMean(dataset.getYPoints());
        }
        Double d2 = null;
        Double d3 = null;
        if (d != Double.NaN) {
            int n2 = dataset2.getRowCount();
            int n3 = 0;
            while (n3 < n2) {
                d3 = (Double)dataset2.getValueAt(n3, 1);
                d2 = this.xIndex == -1 ? (Double)dataset.getValueAt(n3, 0) : (Double)dataset.getValueAt(n3, 1);
                if (d2 != null && d3 != null) {
                    if (bl && bl3) {
                        d2 = d2 * 57.29577951308232;
                    }
                    if (bl2 && bl3) {
                        d3 = d3 * 57.29577951308232;
                    }
                    highlightableDataset.append(d2, d3);
                } else if (d2 != null) {
                    if (bl && bl3) {
                        d2 = d2 * 57.29577951308232;
                    }
                    highlightableDataset.append(d2, Double.NaN);
                } else {
                    highlightableDataset.append(d, Double.NaN);
                }
                ++n3;
            }
        }
    }

    protected void showPlotCoordinates(int n) {
        String string = "";
        if (n >= 0 && this.dataset.getIndex() > n) {
            double d = this.dataset.getXPoints()[n];
            double d2 = this.dataset.getYPoints()[n];
            if (!Double.isNaN(d) && !Double.isNaN(d2)) {
                String string2 = String.valueOf(TeXParser.removeSubscripting(this.xLabel)) + "=";
                String string3 = "  " + TeXParser.removeSubscripting(this.yLabel) + "=";
                string = Math.abs(d) > 100.0 || Math.abs(d) < 0.01 ? String.valueOf(string2) + this.scientificFormat.format(d) : String.valueOf(string2) + this.decimalFormat.format(d);
                string = Math.abs(d2) > 100.0 || Math.abs(d2) < 0.01 ? String.valueOf(string) + string3 + this.scientificFormat.format(d2) : String.valueOf(string) + string3 + this.decimalFormat.format(d2);
            }
        }
        this.setMessage(string, 0);
    }

    @Override
    public void setPreferredMinMax(double d, double d2, double d3, double d4, boolean bl) {
        this.track.trackerPanel.changed = true;
        this.isCustom = true;
        super.setPreferredMinMax(d, d2, d3, d4, bl);
        if (this.plotTrackView != null) {
            this.plotTrackView.syncXAxesTo(this);
        }
    }

    @Override
    public void setPreferredMinMaxX(double d, double d2) {
        this.track.trackerPanel.changed = true;
        this.isCustom = true;
        super.setPreferredMinMaxX(d, d2);
        if (this.plotTrackView != null) {
            this.plotTrackView.syncXAxesTo(this);
        }
    }

    @Override
    public void setPreferredMinMaxY(double d, double d2) {
        this.track.trackerPanel.changed = true;
        this.isCustom = true;
        super.setPreferredMinMaxY(d, d2);
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.plotAxes.getScaleSetter().isVisible()) {
            return false;
        }
        return super.requestFocusInWindow();
    }

    protected void setHighlighted(int n) {
        this.highlightIndex = -1;
        if (this.dataset.getRowCount() == 0) {
            return;
        }
        Step[] stepArray = this.track.getSteps();
        int n2 = -1;
        VideoClip videoClip = null;
        if (this.track.trackerPanel != null) {
            videoClip = this.track.trackerPanel.getPlayer().getVideoClip();
        }
        int n3 = 0;
        while (n3 < stepArray.length) {
            if (stepArray[n3] != null && stepArray[n3].dataVisible && (videoClip == null || videoClip.includesFrame(stepArray[n3].getFrameNumber()))) {
                ++n2;
                if (stepArray[n3].getFrameNumber() == n) {
                    this.highlightIndex = n2;
                    break;
                }
            }
            ++n3;
        }
    }

    protected void setXVariable(String string) {
        if (string == null) {
            return;
        }
        int n = 0;
        while (n < this.xChoices.length) {
            int n2;
            String string2 = this.xChoices[n].getText();
            if (string.indexOf(DEFINED_AS) == -1 && (n2 = string2.indexOf(DEFINED_AS)) > -1) {
                string2 = string2.substring(0, n2);
            }
            if (string2.equals(string)) {
                this.xIndex = n - 1;
                ButtonModel buttonModel = this.xGroup.getSelection();
                ButtonModel buttonModel2 = this.xChoices[n].getModel();
                if (buttonModel != null && buttonModel == buttonModel2) break;
                this.xChoices[n].setSelected(true);
                break;
            }
            ++n;
        }
        if (this.plotTrackView != null) {
            this.plotTrackView.syncXAxesTo(this);
        }
    }

    protected String getXVariable() {
        if (this.xChoices == null) {
            return null;
        }
        int n = 0;
        while (n < this.xChoices.length) {
            if (this.xChoices[n].isSelected()) {
                String string = this.xChoices[n].getText();
                int n2 = string.indexOf(DEFINED_AS);
                if (n2 > -1) {
                    string = string.substring(0, n2);
                }
                return string;
            }
            ++n;
        }
        return null;
    }

    protected void setYVariable(String string) {
        if (string == null) {
            return;
        }
        int n = 0;
        while (n < this.yChoices.length) {
            int n2;
            String string2 = this.yChoices[n].getText();
            if (string.indexOf(DEFINED_AS) == -1 && (n2 = string2.indexOf(DEFINED_AS)) > -1) {
                string2 = string2.substring(0, n2);
            }
            if (string2.equals(string)) {
                this.yIndex = n;
                ButtonModel buttonModel = this.yGroup.getSelection();
                ButtonModel buttonModel2 = this.yChoices[n].getModel();
                if (buttonModel == null || buttonModel != buttonModel2) {
                    this.yChoices[n].setSelected(true);
                }
                super.setPreferredMinMaxY(Double.NaN, Double.NaN);
                break;
            }
            ++n;
        }
    }

    protected String getYVariable() {
        if (this.yChoices == null) {
            return null;
        }
        int n = 0;
        while (n < this.yChoices.length) {
            if (this.yChoices[n].isSelected()) {
                String string = this.yChoices[n].getText();
                int n2 = string.indexOf(DEFINED_AS);
                if (n2 > -1) {
                    string = string.substring(0, n2);
                }
                return string;
            }
            ++n;
        }
        return null;
    }

    protected void setPlotTrackView(PlotTrackView plotTrackView) {
        this.plotTrackView = plotTrackView;
        VideoPlayer videoPlayer = this.plotTrackView.trackerPanel.getPlayer();
        videoPlayer.removePropertyChangeListener("stepnumber", this.playerListener);
        videoPlayer.addPropertyChangeListener("stepnumber", this.playerListener);
    }

    private double getMean(double[] dArray) {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            if (!Double.isNaN(dArray[n2])) {
                ++n;
                d += dArray[n2];
            }
            ++n2;
        }
        return d / (double)n;
    }

    protected void createVarChoices() {
        int n = this.data.getDatasets().size();
        boolean bl = this.yChoices == null ? false : n < this.yChoices.length;
        String string = this.getXVariable();
        String string2 = this.getYVariable();
        this.xGroup = new ButtonGroup();
        this.yGroup = new ButtonGroup();
        this.xPopup = new JPopupMenu();
        this.yPopup = new JPopupMenu();
        this.xChoices = new JRadioButtonMenuItem[n + 1];
        this.yChoices = new JRadioButtonMenuItem[n];
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = this.track.getDataName(0);
        if ((string3 = TeXParser.removeSubscripting(string3)) == string) {
            bl3 = true;
        }
        string3 = String.valueOf(string3) + DEFINED_AS + this.track.getDataDescription(0);
        this.xChoices[0] = new JRadioButtonMenuItem(string3);
        if (bl3) {
            this.xChoices[0].setSelected(true);
            this.xIndex = -1;
        }
        this.xChoices[0].setFont(this.font);
        this.xChoices[0].setBorder(BorderFactory.createEmptyBorder(1, 0, 2, 0));
        this.xChoices[0].addItemListener(this.xListener);
        this.xGroup.add(this.xChoices[0]);
        this.xPopup.add(this.xChoices[0]);
        int n2 = 0;
        while (n2 < n) {
            string3 = this.track.getDataName(n2 + 1);
            string3 = TeXParser.removeSubscripting(string3);
            boolean bl4 = string3.equals(string);
            boolean bl5 = string3.equals(string2);
            bl3 = bl3 || bl4;
            boolean bl6 = bl2 = bl2 || bl5;
            if (!this.track.getDataDescription(n2 + 1).equals("")) {
                string3 = String.valueOf(string3) + DEFINED_AS + this.track.getDataDescription(n2 + 1);
            }
            this.xChoices[n2 + 1] = new JRadioButtonMenuItem(string3);
            if (bl4) {
                this.xChoices[n2 + 1].setSelected(true);
                this.xIndex = n2;
            }
            this.xChoices[n2 + 1].setFont(this.font);
            this.xChoices[n2 + 1].setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
            this.xChoices[n2 + 1].addItemListener(this.xListener);
            this.xGroup.add(this.xChoices[n2 + 1]);
            this.xPopup.add(this.xChoices[n2 + 1]);
            this.yChoices[n2] = new JRadioButtonMenuItem(string3);
            if (bl5) {
                this.yChoices[n2].setSelected(true);
                this.yIndex = n2;
            }
            this.yChoices[n2].setFont(this.font);
            this.yChoices[n2].setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
            this.yChoices[n2].addItemListener(this.yListener);
            this.yGroup.add(this.yChoices[n2]);
            this.yPopup.add(this.yChoices[n2]);
            ++n2;
        }
        JMenuItem jMenuItem = new JMenuItem(TrackerRes.getString("TView.Menuitem.Define"));
        jMenuItem.addActionListener(this.dataFunctionListener);
        this.xPopup.addSeparator();
        this.xPopup.add(jMenuItem);
        jMenuItem = new JMenuItem(TrackerRes.getString("TView.Menuitem.Define"));
        jMenuItem.addActionListener(this.dataFunctionListener);
        this.yPopup.addSeparator();
        this.yPopup.add(jMenuItem);
        if (this.xIndex >= this.xChoices.length - 1 || bl && !bl3) {
            this.xIndex = -1;
        }
        if (this.yIndex >= this.yChoices.length || bl && !bl2) {
            this.yIndex = 0;
        }
        if (!bl3) {
            this.setXVariable(this.xChoices[this.xIndex + 1].getText());
        }
        if (!bl2) {
            this.setYVariable(this.yChoices[this.yIndex].getText());
        }
    }

    private void copyProperties(Dataset dataset, Dataset dataset2) {
        XMLControlElement xMLControlElement = new XMLControlElement(dataset);
        Dataset.getLoader().loadObject(xMLControlElement, dataset2);
    }

    private void padDataset(Dataset dataset, double[] dArray) {
        double[] dArray2 = dataset.getXPoints();
        double[] dArray3 = dataset.getYPoints();
        HashMap<Double, Double> hashMap = new HashMap<Double, Double>();
        int n = 0;
        while (n < dArray2.length) {
            hashMap.put(dArray2[n], dArray3[n]);
            ++n;
        }
        double[] dArray4 = new double[dArray.length];
        int n2 = 0;
        while (n2 < dArray.length) {
            double d = dArray[n2];
            dArray4[n2] = hashMap.keySet().contains(d) ? (Double)hashMap.get(d) : Double.NaN;
            ++n2;
        }
        dataset.clear();
        dataset.append(dArray, dArray4);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    class ClickableAxes
    extends CartesianInteractive {
        ClickableAxes(PlottingPanel plottingPanel) {
            super(plottingPanel);
            this.setDefaultGutters(this.defaultLeftGutter, 30, this.defaultRightGutter, this.defaultBottomGutter);
        }

        @Override
        public CartesianInteractive.ScaleSetter getScaleSetter() {
            CartesianInteractive.ScaleSetter scaleSetter = super.getScaleSetter();
            FontSizer.setFonts(scaleSetter, FontSizer.getLevel());
            return scaleSetter;
        }

        @Override
        protected boolean hasHorzVariablesPopup() {
            return true;
        }

        @Override
        protected JPopupMenu getHorzVariablesPopup() {
            FontSizer.setFonts(TrackPlottingPanel.this.xPopup, FontSizer.getLevel());
            return TrackPlottingPanel.this.xPopup;
        }

        @Override
        protected boolean hasVertVariablesPopup() {
            return true;
        }

        @Override
        protected JPopupMenu getVertVariablesPopup() {
            FontSizer.setFonts(TrackPlottingPanel.this.yPopup, FontSizer.getLevel());
            return TrackPlottingPanel.this.yPopup;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            TrackPlottingPanel trackPlottingPanel = (TrackPlottingPanel)object;
            xMLControl.setValue("x_var", trackPlottingPanel.getXVariable());
            xMLControl.setValue("y_var", trackPlottingPanel.getYVariable());
            if (!trackPlottingPanel.autoscaleXMin) {
                xMLControl.setValue("scaled", true);
                xMLControl.setValue("xmin", trackPlottingPanel.getPreferredXMin());
            }
            if (!trackPlottingPanel.autoscaleXMax) {
                xMLControl.setValue("scaled", true);
                xMLControl.setValue("xmax", trackPlottingPanel.getPreferredXMax());
            }
            if (!trackPlottingPanel.autoscaleYMin) {
                xMLControl.setValue("scaled", true);
                xMLControl.setValue("ymin", trackPlottingPanel.getPreferredYMin());
            }
            if (!trackPlottingPanel.autoscaleYMax) {
                xMLControl.setValue("scaled", true);
                xMLControl.setValue("ymax", trackPlottingPanel.getPreferredYMax());
            }
            xMLControl.setValue("lines", trackPlottingPanel.dataset.isConnected());
            xMLControl.setValue("points", trackPlottingPanel.dataset.getMarkerShape() != 0);
            if (!trackPlottingPanel.guests.isEmpty()) {
                String[] stringArray = new String[trackPlottingPanel.guests.size()];
                int n = 0;
                while (n < stringArray.length) {
                    TTrack tTrack = trackPlottingPanel.guests.get(n);
                    stringArray[n] = tTrack.getName();
                    ++n;
                }
                xMLControl.setValue("guests", stringArray);
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            String[] stringArray;
            TrackPlottingPanel trackPlottingPanel = (TrackPlottingPanel)object;
            String[] stringArray2 = new String[]{xMLControl.getString("x_var"), xMLControl.getString("y_var")};
            int n = 0;
            while (n < 2) {
                if (stringArray2[n] != null) {
                    if (stringArray2[n].equals("theta") && trackPlottingPanel.track instanceof PointMass) {
                        stringArray2[n] = "\u03b8r";
                    } else if (stringArray2[n].equals("theta")) {
                        stringArray2[n] = "\u03b8";
                    } else if (stringArray2[n].equals("theta_v")) {
                        stringArray2[n] = "\u03b8v";
                    } else if (stringArray2[n].equals("theta_a")) {
                        stringArray2[n] = "\u03b8a";
                    } else if (stringArray2[n].equals("theta_p")) {
                        stringArray2[n] = "\u03b8p";
                    } else if (stringArray2[n].equals("n") && trackPlottingPanel.track instanceof PointMass) {
                        stringArray2[n] = "step";
                    } else if (stringArray2[n].equals("KE")) {
                        stringArray2[n] = "K";
                    } else if (stringArray2[n].equals("x-comp")) {
                        stringArray2[n] = "x";
                    } else if (stringArray2[n].equals("y-comp")) {
                        stringArray2[n] = "y";
                    } else if (stringArray2[n].equals("x_tail")) {
                        stringArray2[n] = "xtail";
                    } else if (stringArray2[n].equals("y_tail")) {
                        stringArray2[n] = "ytail";
                    }
                }
                ++n;
            }
            trackPlottingPanel.setXVariable(stringArray2[0]);
            trackPlottingPanel.setYVariable(stringArray2[1]);
            if (xMLControl.getBoolean("scaled")) {
                double d = xMLControl.getDouble("xmin");
                double d2 = xMLControl.getDouble("xmax");
                double d3 = xMLControl.getDouble("ymin");
                double d4 = xMLControl.getDouble("ymax");
                trackPlottingPanel.setPreferredMinMax(d, d2, d3, d4, false);
            }
            if (xMLControl.getPropertyNames().contains("lines")) {
                trackPlottingPanel.dataset.setConnected(xMLControl.getBoolean("lines"));
            }
            if (xMLControl.getPropertyNames().contains("points")) {
                if (xMLControl.getBoolean("points")) {
                    trackPlottingPanel.dataset.setMarkerShape(2);
                } else {
                    trackPlottingPanel.dataset.setMarkerShape(0);
                }
            }
            if ((stringArray = (String[])xMLControl.getObject("guests")) != null) {
                TrackerPanel trackerPanel = trackPlottingPanel.track.trackerPanel;
                String[] stringArray3 = stringArray;
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string = stringArray3[n3];
                    TTrack tTrack = trackerPanel.getTrack(string);
                    trackPlottingPanel.addGuest(tTrack);
                    ++n3;
                }
            }
            trackPlottingPanel.plotData();
            return object;
        }
    }

    class PlotMouseListener
    extends MouseInputAdapter {
        int region;
        Interactive iad;

        PlotMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            TrackPlottingPanel.this.mouseEvent = mouseEvent;
            TrackPlottingPanel.this.mouseAction = 5;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            TrackPlottingPanel.this.mouseEvent = mouseEvent;
            TrackPlottingPanel.this.mouseAction = 6;
            TrackPlottingPanel.this.setMouseCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            TrackPlottingPanel.this.mouseEvent = mouseEvent;
            TrackPlottingPanel.this.mouseAction = 7;
            if (!(TrackPlottingPanel.this.track instanceof LineProfile)) {
                this.iad = TrackPlottingPanel.this.getInteractive();
            }
            Point point = mouseEvent.getPoint();
            this.region = this.getRegion(point);
            TrackPlottingPanel.this.setShowCoordinates(this.region == 0 && TrackPlottingPanel.this.getCursor() == Cursor.getPredefinedCursor(1));
            if (this.region == 0) {
                TrackPlottingPanel.this.setToolTipText(TrackerRes.getString("TrackPlottingPanel.RightDrag.Hint"));
            } else {
                TrackPlottingPanel.this.setToolTipText(null);
            }
            TrackPlottingPanel.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            TrackPlottingPanel.this.mouseEvent = mouseEvent;
            TrackPlottingPanel.this.mouseAction = 1;
            Point point = mouseEvent.getPoint();
            this.region = this.getRegion(point);
            if (this.iad == TrackPlottingPanel.this.dataset) {
                TrackPlottingPanel.this.showPlotCoordinates(TrackPlottingPanel.this.dataset.getHitIndex());
                int n = TrackPlottingPanel.this.track.getFrameForData(TrackPlottingPanel.this.getXLabel(), TrackPlottingPanel.this.dataset.getX());
                if (n > -1) {
                    TrackPlottingPanel.this.clickedStep = TrackPlottingPanel.this.track.getStep(n);
                    VideoPlayer videoPlayer = TrackPlottingPanel.this.plotTrackView.trackerPanel.getPlayer();
                    int n2 = videoPlayer.getVideoClip().frameToStep(n);
                    videoPlayer.setStepNumber(n2);
                    return;
                }
            } else if (this.region == 0 && mouseEvent.getClickCount() == 2 && TrackPlottingPanel.this.track.trackerPanel.isEnabled("data.tool")) {
                TrackPlottingPanel.this.dataToolItem.doClick();
            }
            if (TrackPlottingPanel.this.showCoordinates) {
                String string = TrackPlottingPanel.this.coordinateStrBuilder.getCoordinateString(TrackPlottingPanel.this, mouseEvent);
                TrackPlottingPanel.this.blMessageBox.setText(string);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            TrackPlottingPanel.this.mouseEvent = mouseEvent;
            TrackPlottingPanel.this.mouseAction = 3;
            Point point = mouseEvent.getPoint();
            this.region = this.getRegion(point);
            TrackPlottingPanel.this.setShowCoordinates(this.region == 0);
            if (TrackPlottingPanel.this.getInteractive() == null) {
                if (this.region != 0) {
                    TrackPlottingPanel.this.setMouseCursor(Cursor.getDefaultCursor());
                    TrackPlottingPanel.this.setMessage(null, 0);
                } else {
                    TrackPlottingPanel.this.setMouseCursor(Cursor.getPredefinedCursor(1));
                }
            }
            TrackPlottingPanel.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            TrackPlottingPanel.this.mouseEvent = mouseEvent;
            TrackPlottingPanel.this.mouseAction = 2;
            if (!(TrackPlottingPanel.this.track instanceof LineProfile) && TrackPlottingPanel.this.getInteractive() != null) {
                TrackPlottingPanel.this.setMouseCursor(Cursor.getPredefinedCursor(12));
            }
            if (TrackPlottingPanel.this.getCursor() == Cursor.getPredefinedCursor(1)) {
                TrackPlottingPanel.this.blMessageBox.setText(null);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TrackPlottingPanel.this.mouseEvent = mouseEvent;
            TrackPlottingPanel.this.mouseAction = 4;
        }

        private int getRegion(Point point) {
            int n = TrackPlottingPanel.this.plotAxes.getMouseRegion();
            if (n == 0) {
                int n2 = TrackPlottingPanel.this.getLeftGutter();
                int n3 = TrackPlottingPanel.this.getRightGutter();
                int n4 = TrackPlottingPanel.this.getTopGutter();
                int n5 = TrackPlottingPanel.this.getBottomGutter();
                Dimension dimension = TrackPlottingPanel.this.getSize();
                if (point.x < n2 || point.y < n4 || point.x > dimension.width - n3 || point.y > dimension.height - n5) {
                    return -1;
                }
            }
            return n;
        }
    }
}

