/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FontSizer;

public class TrackControl
extends JDialog
implements PropertyChangeListener {
    protected static Map<TrackerPanel, TrackControl> controls = new HashMap<TrackerPanel, TrackControl>();
    protected JPopupMenu popup;
    protected TrackerPanel trackerPanel;
    protected JPanel trackBarPanel;
    protected JToolBar[] trackBars = new JToolBar[0];
    protected boolean positioned = false;
    protected int trackCount;
    protected boolean isVisible;
    protected KeyListener shiftKeyListener;

    public static synchronized TrackControl getControl(TrackerPanel trackerPanel) {
        TrackControl trackControl = controls.get(trackerPanel);
        if (trackControl == null) {
            trackControl = new TrackControl(trackerPanel);
            controls.put(trackerPanel, trackControl);
            trackerPanel.trackControl = trackControl;
        }
        return trackControl;
    }

    private TrackControl(TrackerPanel trackerPanel) {
        super((Frame)trackerPanel.getTFrame(), false);
        this.trackBarPanel = new JPanel();
        this.setContentPane(this.trackBarPanel);
        this.shiftKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 16) {
                    TrackControl.this.trackerPanel.requestFocus();
                    TrackControl.this.trackerPanel.requestFocusInWindow();
                }
            }
        };
        this.setResizable(false);
        this.pack();
        this.popup = new JPopupMenu();
        this.trackerPanel = trackerPanel;
        this.trackerPanel.addPropertyChangeListener("track", this);
        this.trackerPanel.addPropertyChangeListener("mass", this);
        this.trackerPanel.addPropertyChangeListener("footprint", this);
        this.trackerPanel.addPropertyChangeListener("data", this);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = Math.max(150, dimension.width);
        return dimension;
    }

    @Override
    public void setVisible(boolean bl) {
        JComponent jComponent;
        TFrame tFrame = this.trackerPanel.getTFrame();
        if (!this.positioned && bl) {
            if (tFrame.isVisible()) {
                jComponent = tFrame.getMainView(this.trackerPanel);
                Point point = jComponent.getLocationOnScreen();
                this.setLocation(point.x, point.y);
                this.positioned = true;
            } else {
                return;
            }
        }
        if (bl && this.trackCount == 0 && !this.isEmpty()) {
            this.refresh();
        }
        super.setVisible(bl);
        this.isVisible = bl;
        jComponent = TToolBar.getToolbar(this.trackerPanel);
        ((TToolBar)jComponent).trackControlButton.setSelected(bl);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("tab")) {
            if (propertyChangeEvent.getNewValue() == this.trackerPanel) {
                this.setVisible(this.isVisible);
            } else {
                boolean bl = this.isVisible;
                this.setVisible(false);
                this.isVisible = bl;
            }
        }
        this.refresh();
    }

    @Override
    public void dispose() {
        if (this.trackerPanel != null) {
            this.trackerPanel.removePropertyChangeListener("track", this);
            this.trackerPanel.removePropertyChangeListener("mass", this);
            this.trackerPanel.removePropertyChangeListener("footprint", this);
            this.trackerPanel.removePropertyChangeListener("data", this);
            TFrame tFrame = this.trackerPanel.getTFrame();
            if (tFrame != null) {
                tFrame.removePropertyChangeListener("tab", this);
            }
        }
        super.dispose();
    }

    public boolean isEmpty() {
        if (this.trackCount > 0) {
            return false;
        }
        ArrayList<TTrack> arrayList = this.trackerPanel.getUserTracks();
        return arrayList.isEmpty();
    }

    protected void refresh() {
        TFrame tFrame;
        this.setTitle(TrackerRes.getString("TrackControl.Name"));
        int n = 4;
        ArrayList<TTrack> arrayList = this.trackerPanel.getUserTracks();
        int n2 = 0;
        while (n2 < this.trackBars.length) {
            this.trackBars[n2].removeAll();
            ++n2;
        }
        n2 = (arrayList.size() + n - 1) / n;
        this.trackBarPanel.removeAll();
        this.trackBarPanel.setLayout(new GridLayout(n2, 1));
        if (n2 > this.trackBars.length) {
            JToolBar[] jToolBarArray = new JToolBar[n2];
            System.arraycopy(this.trackBars, 0, jToolBarArray, 0, this.trackBars.length);
            int n3 = this.trackBars.length;
            while (n3 < n2) {
                jToolBarArray[n3] = new JToolBar();
                jToolBarArray[n3].setFloatable(false);
                ++n3;
            }
            this.trackBars = jToolBarArray;
        }
        int n4 = 0;
        while (n4 < n2) {
            this.trackBarPanel.add(this.trackBars[n4]);
            ++n4;
        }
        this.trackCount = 0;
        TTrack tTrack = null;
        Iterator<TTrack> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n5 = this.trackCount / n;
            tTrack = iterator.next();
            tTrack.removePropertyChangeListener("name", this);
            tTrack.addPropertyChangeListener("name", this);
            tTrack.removePropertyChangeListener("color", this);
            tTrack.addPropertyChangeListener("color", this);
            tTrack.removePropertyChangeListener("footprint", this);
            tTrack.addPropertyChangeListener("footprint", this);
            TButton tButton = new TButton(tTrack);
            tButton.addKeyListener(this.shiftKeyListener);
            this.trackBars[n5].add(tButton);
            ++this.trackCount;
        }
        FontSizer.setFonts(this, FontSizer.getLevel());
        this.pack();
        this.repaint();
        if (this.trackCount == 0) {
            this.setVisible(false);
        }
        if ((tFrame = this.trackerPanel.getTFrame()) != null) {
            tFrame.removePropertyChangeListener("tab", this);
            tFrame.addPropertyChangeListener("tab", this);
        }
    }
}

