/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.opensourcephysics.cabrillo.tracker.AttachmentDialog;
import org.opensourcephysics.cabrillo.tracker.DoubleArrowFootprint;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TapeStep;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;

public class TapeMeasure
extends TTrack {
    protected static final double MIN_LENGTH = 1.0E-30;
    public static final float[] BROKEN_LINE = new float[]{10.0f, 1.0f};
    protected boolean fixedPosition = true;
    protected boolean fixedLength = true;
    protected JCheckBoxMenuItem fixedPositionItem;
    protected JCheckBoxMenuItem fixedLengthItem;
    protected boolean editing = false;
    protected final NumberField inputField;
    protected JPanel inputPanel;
    protected JPanel glassPanel;
    protected NumberFormat format;
    protected MouseListener editListener;
    protected boolean readOnly;
    protected boolean stickMode;
    protected boolean isStepChangingScale;
    protected boolean notYetShown = true;
    protected Footprint[] tapeFootprints;
    protected Footprint[] stickFootprints;
    protected TreeSet<Integer> lengthKeyFrames = new TreeSet();
    protected JMenuItem attachmentItem;

    public TapeMeasure() {
        this.setName(TrackerRes.getString("TapeMeasure.New.Name"));
        this.defaultColors = new Color[]{new Color(204, 0, 0)};
        this.setProperty("xVarPlot0", "t");
        this.setProperty("yVarPlot0", "length");
        this.setProperty("xVarPlot1", "t");
        this.setProperty("yVarPlot1", Tracker.THETA);
        this.setProperty("tableVar0", "0");
        this.setProperty("tableVar1", "1");
        this.tapeFootprints = new Footprint[]{LineFootprint.getFootprint("Footprint.DoubleArrow"), LineFootprint.getFootprint("Footprint.BoldDoubleArrow"), LineFootprint.getFootprint("Footprint.Line"), LineFootprint.getFootprint("Footprint.BoldLine")};
        this.stickFootprints = new Footprint[]{LineFootprint.getFootprint("Footprint.BoldDoubleTarget"), LineFootprint.getFootprint("Footprint.DoubleTarget")};
        this.setColor(this.defaultColors[0]);
        this.setViewable(false);
        this.setStickMode(false);
        this.setReadOnly(false);
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("TapeMeasure.Hint");
        this.inputField = new NumberField(9);
        this.inputField.setBorder(null);
        this.format = this.inputField.getFormat();
        this.inputPanel = new JPanel(null);
        this.inputPanel.setOpaque(false);
        this.inputPanel.add(this.inputField);
        this.magField.setMinValue(Double.NaN);
        this.keyFrames.add(0);
        this.lengthKeyFrames.add(0);
        this.inputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TapeMeasure.this.editing) {
                    int n = TapeMeasure.this.trackerPanel.getFrameNumber();
                    TapeStep tapeStep = (TapeStep)TapeMeasure.this.getStep(n);
                    TapeMeasure.this.setEditing(false, tapeStep);
                }
            }
        });
        this.inputField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                TapeMeasure.this.inputField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (TapeMeasure.this.editing) {
                    int n = TapeMeasure.this.trackerPanel.getFrameNumber();
                    TapeStep tapeStep = (TapeStep)TapeMeasure.this.getStep(n);
                    TapeMeasure.this.setEditing(false, tapeStep);
                }
            }
        });
        this.editListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (TapeMeasure.this.editing) {
                    int n = TapeMeasure.this.trackerPanel.getFrameNumber();
                    TapeStep tapeStep = (TapeStep)TapeMeasure.this.getStep(n);
                    TapeMeasure.this.setEditing(false, tapeStep);
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (TapeMeasure.this.isLocked()) {
                    return;
                }
                int n = TapeMeasure.this.trackerPanel.getFrameNumber();
                TapeStep tapeStep = (TapeStep)TapeMeasure.this.getStep(n);
                Rectangle rectangle = tapeStep.layoutBounds.get(TapeMeasure.this.trackerPanel);
                if (rectangle != null && rectangle.contains(mouseEvent.getPoint())) {
                    TapeMeasure.this.setEditing(true, tapeStep);
                }
            }
        };
        this.fixedPositionItem = new JCheckBoxMenuItem(TrackerRes.getString("TapeMeasure.MenuItem.Fixed"));
        this.fixedPositionItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TapeMeasure.this.setFixedPosition(TapeMeasure.this.fixedPositionItem.isSelected());
            }
        });
        this.fixedLengthItem = new JCheckBoxMenuItem(TrackerRes.getString("TapeMeasure.MenuItem.FixedLength"));
        this.fixedLengthItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TapeMeasure.this.setFixedLength(TapeMeasure.this.fixedLengthItem.isSelected());
            }
        });
        final FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (TapeMeasure.this.magField.getBackground() == Color.yellow) {
                    int n = TapeMeasure.this.trackerPanel.getFrameNumber();
                    if (!TapeMeasure.this.isFixedPosition()) {
                        TapeMeasure.this.keyFrames.add(n);
                    }
                    TapeStep tapeStep = (TapeStep)TapeMeasure.this.getStep(n);
                    tapeStep = TapeMeasure.this.getKeyStep(tapeStep);
                    tapeStep.setTapeLength(TapeMeasure.this.magField.getValue());
                    TapeMeasure.this.dataValid = false;
                    TapeMeasure.this.support.firePropertyChange("data", null, null);
                }
            }
        };
        this.magField.addFocusListener(focusAdapter);
        this.magField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                focusAdapter.focusLost(null);
                TapeMeasure.this.magField.requestFocusInWindow();
            }
        });
        final FocusAdapter focusAdapter2 = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (TapeMeasure.this.angleField.getBackground() == Color.yellow) {
                    int n = TapeMeasure.this.trackerPanel.getFrameNumber();
                    if (!TapeMeasure.this.isFixedPosition()) {
                        TapeMeasure.this.keyFrames.add(n);
                    }
                    TapeStep tapeStep = (TapeStep)TapeMeasure.this.getStep(n);
                    tapeStep = TapeMeasure.this.getKeyStep(tapeStep);
                    tapeStep.setTapeAngle(TapeMeasure.this.angleField.getValue());
                    TapeMeasure.this.dataValid = false;
                    TapeMeasure.this.support.firePropertyChange("data", null, null);
                    if (!TapeMeasure.this.isReadOnly()) {
                        TapeMeasure.this.trackerPanel.getAxes().setVisible(true);
                    }
                }
            }
        };
        this.angleField.addFocusListener(focusAdapter2);
        this.angleField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                focusAdapter2.focusLost(null);
                TapeMeasure.this.angleField.requestFocusInWindow();
            }
        });
    }

    public void setFixedPosition(boolean bl) {
        if (this.fixedPosition == bl) {
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        boolean bl2 = false;
        if (this.trackerPanel != null) {
            int n = this.trackerPanel.getFrameNumber();
            this.trackerPanel.changed = true;
            TapeStep tapeStep = (TapeStep)this.getStep(n);
            int n2 = 0;
            while (n2 < this.steps.length) {
                TapeStep tapeStep2 = (TapeStep)this.steps.getStep(n2);
                if (tapeStep2 != null) {
                    tapeStep2.getEnd1().setLocation(tapeStep.getEnd1());
                    tapeStep2.getEnd2().setLocation(tapeStep.getEnd2());
                    bl2 = true;
                }
                ++n2;
            }
            this.trackerPanel.repaint();
        }
        if (bl) {
            this.keyFrames.clear();
            this.keyFrames.add(0);
            this.dataValid = false;
            this.support.firePropertyChange("data", null, null);
            this.erase();
        }
        this.fixedPosition = bl;
        if (bl2) {
            Undo.postTrackEdit(this, xMLControlElement);
        }
    }

    public boolean isFixedPosition() {
        return this.fixedPosition;
    }

    public void setFixedLength(boolean bl) {
        if (this.fixedLength == bl) {
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        if (this.trackerPanel != null) {
            int n = this.trackerPanel.getFrameNumber();
            this.trackerPanel.changed = true;
            TapeStep tapeStep = (TapeStep)this.getStep(n);
            int n2 = 0;
            while (n2 < this.steps.length) {
                TapeStep tapeStep2 = (TapeStep)this.steps.getStep(n2);
                tapeStep2.worldLength = tapeStep.worldLength;
                ++n2;
            }
            this.trackerPanel.repaint();
        }
        if (bl) {
            this.lengthKeyFrames.clear();
            this.lengthKeyFrames.add(0);
        }
        this.fixedLength = bl;
        Undo.postTrackEdit(this, xMLControlElement);
    }

    public boolean isFixedLength() {
        return this.fixedLength;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
        Footprint[] footprintArray = this.getFootprints();
        int n = footprintArray.length;
        int n2 = 0;
        while (n2 < n) {
            Footprint footprint = footprintArray[n2];
            if (footprint instanceof DoubleArrowFootprint) {
                DoubleArrowFootprint doubleArrowFootprint = (DoubleArrowFootprint)footprint;
                doubleArrowFootprint.setSolidHead(!this.isReadOnly());
            }
            ++n2;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setStickMode(boolean bl) {
        this.stickMode = bl;
        Color color = this.getColor();
        if (this.isStickMode()) {
            this.setFootprints(this.stickFootprints);
        } else {
            this.setFootprints(this.tapeFootprints);
        }
        this.defaultFootprint = this.getFootprint();
        this.setColor(color);
        Step[] stepArray = this.getSteps();
        int n = stepArray.length;
        int n2 = 0;
        while (n2 < n) {
            Step step = stepArray[n2];
            if (step != null) {
                TapeStep tapeStep = (TapeStep)step;
                tapeStep.end1.setCoordsEditTrigger(this.isStickMode());
                tapeStep.end2.setCoordsEditTrigger(this.isStickMode());
            }
            ++n2;
        }
        this.repaint();
    }

    public boolean isStickMode() {
        return this.stickMode;
    }

    @Override
    public void setLocked(boolean bl) {
        super.setLocked(bl);
        boolean bl2 = this.isFieldsEnabled();
        this.magField.setEnabled(bl2);
        this.angleField.setEnabled(bl2);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n;
        String string = propertyChangeEvent.getPropertyName();
        if (this.isStickMode() && string.equals("transform") && !this.isStepChangingScale) {
            n = this.trackerPanel.getFrameNumber();
            TapeStep tapeStep = (TapeStep)this.getStep(n);
            tapeStep.adjustTipsToLength();
            if (!this.isFixedPosition()) {
                this.keyFrames.add(n);
            }
        }
        if (string.equals("adjusting") && propertyChangeEvent.getSource() instanceof TrackerPanel) {
            this.refreshDataLater = (Boolean)propertyChangeEvent.getNewValue();
            if (!this.refreshDataLater) {
                this.support.firePropertyChange("data", null, null);
            }
        }
        if (string.equals("stepnumber")) {
            if (this.trackerPanel.getSelectedTrack() == this) {
                TapeStep tapeStep = (TapeStep)this.getStep(this.trackerPanel.getFrameNumber());
                tapeStep.getTapeLength(!this.isStickMode());
                boolean bl = this.isFieldsEnabled();
                this.magField.setEnabled(bl);
                this.angleField.setEnabled(bl);
            }
        } else if (string.equals("locked")) {
            n = this.isFieldsEnabled() ? 1 : 0;
            this.magField.setEnabled(n != 0);
            this.angleField.setEnabled(n != 0);
        } else if (this.isStickMode() && string.equals("fixed_scale") && propertyChangeEvent.getNewValue() == Boolean.FALSE) {
            this.setFixedPosition(false);
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.notYetShown = false;
        }
    }

    @Override
    public void setTrailVisible(boolean bl) {
    }

    @Override
    public boolean isLocked() {
        boolean bl = super.isLocked();
        if (!this.readOnly && this.trackerPanel != null && !(this.trackerPanel.getSelectedPoint() instanceof TapeStep.Handle)) {
            bl = bl || this.trackerPanel.getCoords().isLocked();
        }
        return bl;
    }

    @Override
    public Step createStep(int n, double d, double d2) {
        TPoint tPoint;
        TapeStep tapeStep = (TapeStep)this.getStep(n);
        TPoint[] tPointArray = tapeStep.getPoints();
        TPoint tPoint2 = tPoint = this.trackerPanel == null ? null : this.trackerPanel.getSelectedPoint();
        if (tPoint == null) {
            tPoint = tapeStep.getEnd1();
            if (this.trackerPanel != null) {
                this.trackerPanel.setSelectedPoint(tPoint);
            }
        }
        if (tPoint == tPointArray[0] || tPoint == tPointArray[1]) {
            tPoint.setLocation(d, d2);
            this.keyFrames.add(n);
            tapeStep.worldLength = tapeStep.getTapeLength(true);
        }
        return tapeStep;
    }

    public Step createStep(int n, double d, double d2, double d3, double d4) {
        TapeStep tapeStep = (TapeStep)this.steps.getStep(n);
        if (tapeStep == null) {
            tapeStep = new TapeStep(this, n, d, d2, d3, d4);
            tapeStep.worldLength = tapeStep.getTapeLength(true);
            tapeStep.setFootprint(this.getFootprint());
            this.steps = new TTrack.StepArray(this, tapeStep);
        } else {
            tapeStep.getEnd1().setLocation(d, d2);
            tapeStep.getEnd2().setLocation(d3, d4);
        }
        this.keyFrames.add(n);
        return tapeStep;
    }

    @Override
    public TPoint autoMarkAt(int n, double d, double d2) {
        TapeStep tapeStep = (TapeStep)this.getStep(n);
        int n2 = this.getTargetIndex();
        ImageCoordSystem imageCoordSystem = this.trackerPanel.getCoords();
        imageCoordSystem.setFixedScale(false);
        this.setFixedPosition(false);
        TPoint tPoint = tapeStep.getPoints()[n2];
        tPoint.setAdjusting(true);
        tPoint.setXY(d, d2);
        tPoint.setAdjusting(false);
        return tPoint;
    }

    @Override
    public Step deleteStep(int n) {
        return null;
    }

    @Override
    public Step getStep(int n) {
        TapeStep tapeStep = (TapeStep)this.steps.getStep(n);
        this.refreshStep(tapeStep);
        return tapeStep;
    }

    @Override
    public int getStepLength() {
        return TapeStep.getLength();
    }

    @Override
    public int getFootprintLength() {
        return 2;
    }

    public String getFormattedLength(double d) {
        this.inputField.setFormatFor(d);
        return this.format.format(d);
    }

    @Override
    public boolean isViewable() {
        return this.isReadOnly() && !this.isStickMode();
    }

    @Override
    protected boolean isAutoTrackable() {
        return true;
    }

    @Override
    protected boolean isAutoTrackable(int n) {
        return n < 2;
    }

    @Override
    protected String getTargetDescription(int n) {
        String string = TrackerRes.getString("Calibration.Point.Name");
        return String.valueOf(string) + " " + (n + 1);
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel) {
        JMenu jMenu = super.getMenu(trackerPanel);
        this.lockedItem.setEnabled(!trackerPanel.getCoords().isLocked());
        jMenu.remove(this.deleteTrackItem);
        jMenu.remove(jMenu.getMenuComponent(jMenu.getMenuComponentCount() - 1));
        this.fixedPositionItem.setText(TrackerRes.getString("TapeMeasure.MenuItem.Fixed"));
        this.fixedPositionItem.setSelected(this.isFixedPosition());
        boolean bl = !this.isStickMode() || trackerPanel.getCoords().isFixedScale();
        boolean bl2 = this.attachments == null || this.attachments[0] == null && this.attachments[1] == null;
        this.fixedPositionItem.setEnabled(bl && bl2);
        jMenu.add(this.fixedPositionItem);
        this.attachmentItem = new JMenuItem(TrackerRes.getString("MeasuringTool.MenuItem.Attach"));
        this.attachmentItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                ImageCoordSystem imageCoordSystem = TapeMeasure.this.trackerPanel.getCoords();
                if (TapeMeasure.this.isStickMode() && imageCoordSystem.isFixedScale() && (n = JOptionPane.showConfirmDialog(TapeMeasure.this.trackerPanel.getTFrame(), String.valueOf(TrackerRes.getString("TapeMeasure.Alert.UnfixScale.Message1")) + "\n" + TrackerRes.getString("TapeMeasure.Alert.UnfixScale.Message2"), TrackerRes.getString("TapeMeasure.Alert.UnfixScale.Title"), 0, 3)) != 0) {
                    return;
                }
                imageCoordSystem.setFixedScale(false);
                AttachmentDialog attachmentDialog = TapeMeasure.this.trackerPanel.getAttachmentDialog(TapeMeasure.this);
                attachmentDialog.setVisible(true);
            }
        });
        jMenu.addSeparator();
        jMenu.add(this.attachmentItem);
        jMenu.addSeparator();
        jMenu.add(this.deleteTrackItem);
        return jMenu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> arrayList = super.getToolbarTrackComponents(trackerPanel);
        this.magLabel.setText(TrackerRes.getString("TapeMeasure.Label.Length"));
        this.magField.setToolTipText(TrackerRes.getString("TapeMeasure.Field.Magnitude.Tooltip"));
        arrayList.add(this.stepSeparator);
        arrayList.add(this.magLabel);
        arrayList.add(this.magField);
        this.angleLabel.setText(TrackerRes.getString("TapeMeasure.Label.TapeAngle"));
        this.angleField.setToolTipText(TrackerRes.getString("TapeMeasure.Field.TapeAngle.Tooltip"));
        arrayList.add(this.magSeparator);
        arrayList.add(this.angleLabel);
        arrayList.add(this.angleField);
        boolean bl = this.isFieldsEnabled();
        this.magField.setEnabled(bl);
        this.angleField.setEnabled(bl);
        return arrayList;
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!(drawingPanel instanceof TrackerPanel) || !this.isVisible()) {
            return null;
        }
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        int n3 = trackerPanel.getFrameNumber();
        TapeStep tapeStep = (TapeStep)this.getStep(n3);
        TPoint[] tPointArray = tapeStep.points;
        if (trackerPanel.getPlayer().getVideoClip().includesFrame(n3)) {
            TPoint tPoint = trackerPanel.getSelectedPoint();
            Interactive interactive = tapeStep.findInteractive(trackerPanel, n, n2);
            if (interactive == null) {
                if (tPoint == tPointArray[0] || tPoint == tPointArray[1]) {
                    this.partName = TrackerRes.getString("TapeMeasure.End.Name");
                    this.hint = this.isStickMode() && !this.isReadOnly() ? TrackerRes.getString("CalibrationStick.End.Hint") : TrackerRes.getString("TapeMeasure.End.Hint");
                } else {
                    this.partName = TrackerRes.getString("TTrack.Selected.Hint");
                    this.hint = !this.isReadOnly() ? TrackerRes.getString("CalibrationTapeMeasure.Hint") : TrackerRes.getString("TapeMeasure.Hint");
                }
                return null;
            }
            if (interactive instanceof TapeStep.Tip) {
                this.partName = TrackerRes.getString("TapeMeasure.End.Name");
                this.hint = this.isStickMode() && !this.isReadOnly() ? TrackerRes.getString("CalibrationStick.End.Hint") : TrackerRes.getString("TapeMeasure.End.Hint");
            } else if (interactive instanceof TapeStep.Handle) {
                this.partName = TrackerRes.getString("TapeMeasure.Handle.Name");
                this.hint = TrackerRes.getString("TapeMeasure.Handle.Hint");
            } else if (interactive == this) {
                this.partName = TrackerRes.getString("TapeMeasure.Readout.Magnitude.Name");
                this.hint = !this.isReadOnly() ? TrackerRes.getString("CalibrationTapeMeasure.Readout.Magnitude.Hint") : TrackerRes.getString("TapeMeasure.Readout.Magnitude.Hint");
                trackerPanel.setMessage(this.getMessage());
            }
            return interactive;
        }
        return null;
    }

    @Override
    protected void refreshData(DatasetManager datasetManager, TrackerPanel trackerPanel) {
        int n;
        if (this.refreshDataLater || trackerPanel == null || datasetManager == null) {
            return;
        }
        this.dataFrames.clear();
        int n2 = 0;
        Dataset dataset = datasetManager.getDataset(n2++);
        Dataset dataset2 = datasetManager.getDataset(n2++);
        Dataset dataset3 = datasetManager.getDataset(n2++);
        Dataset dataset4 = datasetManager.getDataset(n2++);
        String string = "t";
        if (!dataset.getColumnName(0).equals(string)) {
            dataset.setXYColumnNames(string, "length");
            dataset2.setXYColumnNames(string, Tracker.THETA);
            dataset3.setXYColumnNames(string, "step");
            dataset4.setXYColumnNames(string, "frame");
        } else {
            n = 0;
            while (n < n2) {
                datasetManager.getDataset(n).clear();
                ++n;
            }
        }
        this.dataDescriptions = new String[n2 + 1];
        n = 0;
        while (n < this.dataDescriptions.length) {
            this.dataDescriptions[n] = TrackerRes.getString("TapeMeasure.Data.Description." + n);
            ++n;
        }
        VideoPlayer videoPlayer = trackerPanel.getPlayer();
        VideoClip videoClip = videoPlayer.getVideoClip();
        int n3 = videoClip.getStepCount();
        double[][] dArray = new double[datasetManager.getDatasets().size() + 1][n3];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = videoClip.stepToFrame(n4);
            TapeStep tapeStep = (TapeStep)this.getStep(n5);
            if (tapeStep != null) {
                double d;
                tapeStep.dataVisible = true;
                dArray[0][n4] = d = videoPlayer.getStepTime(n4) / 1000.0;
                dArray[1][n4] = tapeStep.getTapeLength(true);
                dArray[2][n4] = tapeStep.getTapeAngle();
                dArray[3][n4] = n4;
                dArray[4][n4] = n5;
                this.dataFrames.add(n5);
            }
            ++n4;
        }
        dataset.append(dArray[0], dArray[1]);
        dataset2.append(dArray[0], dArray[2]);
        dataset3.append(dArray[0], dArray[3]);
        dataset4.append(dArray[0], dArray[4]);
    }

    @Override
    public void remark(TrackerPanel trackerPanel) {
        super.remark(trackerPanel);
        this.displayState();
    }

    @Override
    public String toString() {
        return TrackerRes.getString("TapeMeasure.Name");
    }

    @Override
    protected void setTrackerPanel(TrackerPanel trackerPanel) {
        if (this.trackerPanel != null) {
            this.trackerPanel.removeMouseListener(this.editListener);
            this.trackerPanel.removePropertyChangeListener("stepnumber", this);
        }
        super.setTrackerPanel(trackerPanel);
        if (this.trackerPanel != null) {
            this.trackerPanel.addMouseListener(this.editListener);
        }
        boolean bl = !this.isStickMode() || this.trackerPanel.getCoords().isFixedScale();
        this.setFixedPosition(this.isFixedPosition() && bl);
    }

    protected void refreshWorldLengths() {
        int n = 0;
        while (n < this.getSteps().length) {
            TapeStep tapeStep = (TapeStep)this.getSteps()[n];
            if (tapeStep != null) {
                this.refreshStep(tapeStep);
                tapeStep.worldLength = tapeStep.getTapeLength(true);
            }
            ++n;
        }
    }

    protected void refreshStep(TapeStep tapeStep) {
        int n;
        if (tapeStep == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        Iterator<Object> iterator = this.keyFrames.iterator();
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            if (n > tapeStep.n) continue;
            n2 = n;
        }
        iterator = this.lengthKeyFrames.iterator();
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            if (n > tapeStep.n) continue;
            n3 = n;
        }
        n = 0;
        boolean bl = false;
        TapeStep tapeStep2 = (TapeStep)this.steps.getStep(this.isFixedPosition() ? 0 : n2);
        int n4 = n = tapeStep2.getEnd1().getX() == tapeStep.getEnd1().getX() && tapeStep2.getEnd1().getY() == tapeStep.getEnd1().getY() && tapeStep2.getEnd2().getX() == tapeStep.getEnd2().getX() && tapeStep2.getEnd2().getY() == tapeStep.getEnd2().getY() ? 0 : 1;
        if (n != 0) {
            tapeStep.getEnd1().setLocation(tapeStep2.getEnd1());
            tapeStep.getEnd2().setLocation(tapeStep2.getEnd2());
            bl = true;
        }
        if (this.isStickMode()) {
            tapeStep2 = (TapeStep)this.steps.getStep(this.isFixedLength() ? 0 : n3);
            int n5 = n = tapeStep2.worldLength != tapeStep.worldLength ? 1 : 0;
            if (n != 0) {
                tapeStep.worldLength = tapeStep2.worldLength;
                bl = true;
            }
        }
        if (bl) {
            tapeStep.erase();
        }
    }

    private void setEditing(boolean bl, TapeStep tapeStep) {
        this.editing = bl;
        if ((this.readOnly || this.isStickMode()) && !this.editing) {
            if (!this.isFixedPosition()) {
                this.keyFrames.add(tapeStep.n);
            }
            tapeStep = this.getKeyStep(tapeStep);
        }
        final TapeStep tapeStep2 = tapeStep;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (TapeMeasure.this.editing) {
                    Object object;
                    TapeMeasure.this.trackerPanel.setSelectedTrack(TapeMeasure.this);
                    TapeMeasure.this.inputField.setForeground(TapeMeasure.this.footprint.getColor());
                    Rectangle rectangle = tapeStep2.layoutBounds.get(TapeMeasure.this.trackerPanel);
                    rectangle.grow(3, 3);
                    rectangle.setLocation(rectangle.x + 1, rectangle.y);
                    Component[] componentArray = TapeMeasure.this.trackerPanel.getComponents();
                    int n = componentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        object = componentArray[n2];
                        if (object == TapeMeasure.this.trackerPanel.noData) {
                            rectangle.setLocation(rectangle.x, rectangle.y - ((Component)object).getHeight());
                        }
                        ++n2;
                    }
                    TapeMeasure.this.inputField.setBounds(rectangle);
                    TapeMeasure.this.glassPanel = TapeMeasure.this.trackerPanel.getGlassPanel();
                    TapeMeasure.this.trackerPanel.remove(TapeMeasure.this.glassPanel);
                    TapeMeasure.this.trackerPanel.add((Component)TapeMeasure.this.inputPanel, "Center");
                    object = BorderFactory.createEmptyBorder(0, 1, 1, 0);
                    Color color = TapeMeasure.this.getFootprint().getColor();
                    Border border = BorderFactory.createLineBorder(color);
                    TapeMeasure.this.inputField.setBorder(BorderFactory.createCompoundBorder(border, (Border)object));
                    TapeMeasure.this.inputField.setValue(tapeStep2.getTapeLength(!TapeMeasure.this.isStickMode()));
                    TapeMeasure.this.trackerPanel.revalidate();
                    TapeMeasure.this.trackerPanel.repaint();
                    TapeMeasure.this.inputField.requestFocus();
                } else {
                    tapeStep2.drawLayoutBounds = false;
                    tapeStep2.setTapeLength(TapeMeasure.this.inputField.getValue());
                    TapeMeasure.this.inputField.setSigFigs(4);
                    TapeMeasure.this.trackerPanel.add((Component)TapeMeasure.this.glassPanel, "Center");
                    TapeMeasure.this.trackerPanel.remove(TapeMeasure.this.inputPanel);
                    TapeMeasure.this.dataValid = false;
                    TapeMeasure.this.support.firePropertyChange("data", null, null);
                    TapeMeasure.this.trackerPanel.revalidate();
                    TapeMeasure.this.trackerPanel.repaint();
                }
            }
        };
        EventQueue.invokeLater(runnable);
    }

    private TapeStep getKeyStep(TapeStep tapeStep) {
        int n = 0;
        if (!this.isFixedPosition()) {
            Iterator iterator = this.keyFrames.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                if (n2 > tapeStep.n) continue;
                n = n2;
            }
        }
        return (TapeStep)this.getStep(n);
    }

    private void displayState() {
        int n = this.trackerPanel == null ? 0 : this.trackerPanel.getFrameNumber();
        TapeStep tapeStep = (TapeStep)this.getStep(n);
        if (tapeStep != null) {
            tapeStep.getTapeLength(!this.isStickMode());
        }
    }

    protected boolean isFieldsEnabled() {
        if (this.isLocked()) {
            return false;
        }
        if (!this.isReadOnly() && this.trackerPanel != null && this.trackerPanel.getCoords().isLocked()) {
            return false;
        }
        int n = this.trackerPanel == null ? 0 : this.trackerPanel.getFrameNumber();
        TapeStep tapeStep = (TapeStep)this.getStep(n);
        return tapeStep == null || !tapeStep.end1.isAttached() || !tapeStep.end2.isAttached();
    }

    public static XML.ObjectLoader getLoader() {
        XML.setLoader(FrameData.class, new FrameDataLoader());
        return new Loader();
    }

    private static class FrameData {
        double[] data = new double[4];

        FrameData() {
        }

        FrameData(TapeStep tapeStep) {
            this.data[0] = tapeStep.getEnd1().x;
            this.data[1] = tapeStep.getEnd1().y;
            this.data[2] = tapeStep.getEnd2().x;
            this.data[3] = tapeStep.getEnd2().y;
        }
    }

    private static class FrameDataLoader
    implements XML.ObjectLoader {
        private FrameDataLoader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            FrameData frameData = (FrameData)object;
            xMLControl.setValue("x1", frameData.data[0]);
            xMLControl.setValue("y1", frameData.data[1]);
            xMLControl.setValue("x2", frameData.data[2]);
            xMLControl.setValue("y2", frameData.data[3]);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new FrameData();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            FrameData frameData = (FrameData)object;
            if (xMLControl.getPropertyNames().contains("x1")) {
                frameData.data[0] = xMLControl.getDouble("x1");
                frameData.data[1] = xMLControl.getDouble("y1");
                frameData.data[2] = xMLControl.getDouble("x2");
                frameData.data[3] = xMLControl.getDouble("y2");
            }
            return object;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            TapeMeasure tapeMeasure = (TapeMeasure)object;
            XML.getLoader(TTrack.class).saveObject(xMLControl, object);
            xMLControl.setValue("fixedtape", tapeMeasure.isFixedPosition());
            xMLControl.setValue("fixedlength", tapeMeasure.isFixedLength());
            xMLControl.setValue("readonly", tapeMeasure.isReadOnly());
            xMLControl.setValue("stickmode", tapeMeasure.isStickMode());
            Step[] stepArray = tapeMeasure.getSteps();
            int n = tapeMeasure.isFixedPosition() ? 1 : stepArray.length;
            FrameData[] frameDataArray = new FrameData[n];
            int n2 = 0;
            while (n2 < n) {
                if (stepArray[n2] != null && tapeMeasure.keyFrames.contains(n2)) {
                    frameDataArray[n2] = new FrameData((TapeStep)stepArray[n2]);
                }
                ++n2;
            }
            xMLControl.setValue("framedata", frameDataArray);
            n = tapeMeasure.isFixedLength() ? 1 : stepArray.length;
            Double[] doubleArray = new Double[n];
            int n3 = 0;
            while (n3 < n) {
                if (stepArray[n3] != null && tapeMeasure.lengthKeyFrames.contains(n3)) {
                    doubleArray[n3] = ((TapeStep)stepArray[n3]).worldLength;
                }
                ++n3;
            }
            xMLControl.setValue("worldlengths", doubleArray);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new TapeMeasure();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            TapeMeasure tapeMeasure = (TapeMeasure)object;
            tapeMeasure.notYetShown = false;
            boolean bl = tapeMeasure.isLocked();
            tapeMeasure.setLocked(false);
            tapeMeasure.setStickMode(xMLControl.getBoolean("stickmode"));
            XML.getLoader(TTrack.class).loadObject(xMLControl, object);
            tapeMeasure.keyFrames.clear();
            FrameData[] frameDataArray = (FrameData[])xMLControl.getObject("framedata");
            if (frameDataArray != null) {
                int n = 0;
                while (n < frameDataArray.length) {
                    if (frameDataArray[n] != null) {
                        tapeMeasure.createStep(n, frameDataArray[n].data[0], frameDataArray[n].data[1], frameDataArray[n].data[2], frameDataArray[n].data[3]);
                    }
                    ++n;
                }
            }
            tapeMeasure.lengthKeyFrames.clear();
            Double[] doubleArray = (Double[])xMLControl.getObject("worldlengths");
            if (doubleArray != null) {
                int n = 0;
                while (n < doubleArray.length) {
                    if (doubleArray[n] != null) {
                        TapeStep tapeStep = (TapeStep)tapeMeasure.steps.getStep(n);
                        tapeStep.worldLength = doubleArray[n];
                        tapeMeasure.lengthKeyFrames.add(n);
                    }
                    ++n;
                }
            }
            tapeMeasure.fixedPosition = xMLControl.getBoolean("fixedtape");
            if (xMLControl.getPropertyNames().contains("fixedlength")) {
                tapeMeasure.fixedLength = xMLControl.getBoolean("fixedlength");
            }
            tapeMeasure.setReadOnly(xMLControl.getBoolean("readonly"));
            tapeMeasure.setLocked(bl);
            tapeMeasure.displayState();
            return object;
        }
    }
}

