/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.cabrillo.tracker.AutoTracker;
import org.opensourcephysics.cabrillo.tracker.CircleFootprint;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.PerspectiveTrack;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.Protractor;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMouseHandler;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.TrackProperties;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;

public abstract class TTrack
implements Interactive,
Trackable,
PropertyChangeListener {
    protected static String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    protected static JDialog skippedStepWarningDialog;
    protected static JTextPane skippedStepWarningTextpane;
    protected static JCheckBox skippedStepWarningCheckbox;
    protected static JButton closeButton;
    protected static boolean skippedStepWarningOn;
    protected static FontRenderContext frc;
    protected String name = TrackerRes.getString("TTrack.Name.None");
    protected String description = "";
    protected boolean visible = true;
    protected boolean trailVisible = false;
    protected int trailLength;
    protected boolean locked = false;
    protected boolean enabled = true;
    protected boolean viewable = true;
    protected Footprint[] footprints = new Footprint[0];
    protected Footprint footprint;
    protected Footprint defaultFootprint;
    protected Color[] defaultColors = new Color[]{Color.red};
    protected StepArray steps = new StepArray();
    protected Collection<TrackerPanel> panels = new HashSet<TrackerPanel>();
    protected PropertyChangeSupport support;
    protected HashMap<String, Object> properties = new HashMap();
    protected DatasetManager data;
    protected HashMap<TrackerPanel, double[]> worldBounds = new HashMap();
    protected Point2D point = new Point2D.Double();
    protected ArrayList<Component> toolbarTrackComponents = new ArrayList();
    protected ArrayList<Component> toolbarPointComponents = new ArrayList();
    protected JLabel tLabel;
    protected JLabel xLabel;
    protected JLabel yLabel;
    protected JLabel magLabel;
    protected JLabel angleLabel;
    protected JLabel stepLabel;
    protected JLabel tValueLabel;
    protected JLabel stepValueLabel;
    protected NumberField tField;
    protected NumberField xField;
    protected NumberField yField;
    protected NumberField magField;
    protected DecimalField angleField;
    protected Border fieldBorder;
    protected Component tSeparator;
    protected Component xSeparator;
    protected Component ySeparator;
    protected Component magSeparator;
    protected Component angleSeparator;
    protected Component stepSeparator;
    protected JMenu menu;
    protected boolean autoAdvance;
    protected boolean markByDefault = false;
    protected boolean isMarking = false;
    protected JCheckBoxMenuItem visibleItem;
    protected JCheckBoxMenuItem trailVisibleItem;
    protected JCheckBoxMenuItem markByDefaultItem;
    protected JCheckBoxMenuItem autoAdvanceItem;
    protected JCheckBoxMenuItem lockedItem;
    protected JMenuItem nameItem;
    protected JMenuItem colorItem;
    protected JMenu footprintMenu;
    protected ActionListener footprintListener;
    protected ActionListener circleFootprintListener;
    protected JMenuItem deleteTrackItem;
    protected JMenuItem deleteStepItem;
    protected JMenuItem clearStepsItem;
    protected JMenuItem descriptionItem;
    protected JMenuItem dataBuilderItem;
    protected JSpinner xSpinner;
    protected JSpinner ySpinner;
    protected Font labelFont = new Font("arial", 0, 12);
    protected JDialog nameDialog;
    protected JTextField nameField;
    protected Action nameAction;
    protected TrackerPanel trackerPanel;
    protected XMLProperty dataProp;
    protected Object[][] constantsLoadedFromXML;
    protected String[] dataDescriptions;
    protected boolean dataValid;
    protected boolean refreshDataLater;
    protected int[] preferredColumnOrder;
    protected ArrayList<Integer> dataFrames = new ArrayList();
    protected String partName;
    protected String hint;
    protected int stepSizeWhenFirstMarked;
    protected TreeSet<Integer> keyFrames = new TreeSet();
    protected boolean autoTrackerMarking;
    protected int targetIndex;
    protected TTrack[] attachments;
    protected Map<String, String[]> textColumnEntries = new TreeMap<String, String[]>();
    protected ArrayList<String> textColumnNames = new ArrayList();

    static {
        skippedStepWarningOn = true;
        frc = new FontRenderContext(null, false, false);
    }

    protected TTrack() {
        this.support = new SwingPropertyChangeSupport(this);
        this.stepLabel = new JLabel();
        this.stepLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.stepValueLabel = new JLabel();
        this.stepValueLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.tValueLabel = new JLabel();
        this.tValueLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        this.tField = new DecimalField(4, 3){

            @Override
            public void setValue(double d) {
                super.setValue(d);
                TTrack.this.tValueLabel.setText("(" + TTrack.this.tField.getText() + ")");
            }
        };
        this.tField.setUnits("s");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0.0, -100.0, 100.0, 0.1);
        this.xSpinner = new JSpinner(spinnerNumberModel);
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this.xSpinner, "0.00");
        numberEditor.getTextField().setHorizontalAlignment(2);
        this.xSpinner.setEditor(numberEditor);
        spinnerNumberModel = new SpinnerNumberModel(0.0, -100.0, 100.0, 0.1);
        this.ySpinner = new JSpinner(spinnerNumberModel);
        numberEditor = new JSpinner.NumberEditor(this.ySpinner, "0.00");
        numberEditor.getTextField().setHorizontalAlignment(2);
        this.ySpinner.setEditor(numberEditor);
        Border border = BorderFactory.createEmptyBorder(0, 1, 0, 2);
        this.xLabel = new JLabel("x");
        this.xLabel.setBorder(border);
        this.xField = new NumberField(5);
        this.yLabel = new JLabel("y");
        this.yLabel.setBorder(border);
        this.yField = new NumberField(5);
        this.magLabel = new JLabel("r");
        this.magLabel.setBorder(border);
        this.magField = new NumberField(5);
        this.magField.setMinValue(0.0);
        this.angleLabel = new JLabel("theta");
        this.angleLabel.setBorder(border);
        this.angleField = new DecimalField(4, 1);
        this.angleField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem();
                    final boolean bl = TTrack.this.angleField.getConversionFactor() == 1.0;
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            TFrame tFrame = (this).TTrack.this.trackerPanel.getTFrame();
                            tFrame.setAnglesInRadians(!bl);
                        }
                    });
                    jMenuItem.setText(bl ? TrackerRes.getString("TTrack.AngleField.Popup.Degrees") : TrackerRes.getString("TTrack.AngleField.Popup.Radians"));
                    jPopupMenu.add(jMenuItem);
                    FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                    jPopupMenu.show(TTrack.this.angleField, 0, TTrack.this.angleField.getHeight());
                }
            }
        });
        border = BorderFactory.createEmptyBorder(0, 3, 0, 3);
        Color color = new Color(102, 102, 102);
        Border border2 = BorderFactory.createEtchedBorder(Color.white, color);
        this.fieldBorder = BorderFactory.createCompoundBorder(border2, border);
        this.tField.setBorder(this.fieldBorder);
        this.xField.setBorder(this.fieldBorder);
        this.yField.setBorder(this.fieldBorder);
        this.magField.setBorder(this.fieldBorder);
        this.angleField.setBorder(this.fieldBorder);
        this.stepSeparator = Box.createRigidArea(new Dimension(4, 4));
        this.tSeparator = Box.createRigidArea(new Dimension(4, 4));
        this.xSeparator = Box.createRigidArea(new Dimension(6, 4));
        this.ySeparator = Box.createRigidArea(new Dimension(6, 4));
        this.magSeparator = Box.createRigidArea(new Dimension(6, 4));
        this.angleSeparator = Box.createRigidArea(new Dimension(6, 4));
        this.visibleItem = new JCheckBoxMenuItem();
        this.trailVisibleItem = new JCheckBoxMenuItem();
        this.autoAdvanceItem = new JCheckBoxMenuItem();
        this.markByDefaultItem = new JCheckBoxMenuItem();
        this.lockedItem = new JCheckBoxMenuItem();
        this.deleteTrackItem = new JMenuItem();
        this.deleteStepItem = new JMenuItem();
        this.clearStepsItem = new JMenuItem();
        this.colorItem = new JMenuItem();
        this.colorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = TTrack.this.getColor();
                Color color2 = TTrack.this.chooseColor(color, TrackerRes.getString("TTrack.Dialog.Color.Title"));
                if (color2 != color) {
                    XMLControlElement xMLControlElement = new XMLControlElement(new TrackProperties(TTrack.this));
                    TTrack.this.setColor(color2);
                    Undo.postTrackDisplayEdit(TTrack.this, xMLControlElement);
                }
            }
        });
        this.nameDialog = new JDialog(null, null, true);
        this.nameDialog.setDefaultCloseOperation(0);
        this.nameDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                String string = TTrack.this.nameField.getText();
                if (TTrack.this.trackerPanel != null) {
                    TTrack.this.trackerPanel.setTrackName(TTrack.this, string, true);
                }
            }
        });
        this.nameField = new JTextField(20);
        this.nameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = TTrack.this.nameField.getText();
                if (TTrack.this.trackerPanel != null) {
                    TTrack.this.trackerPanel.setTrackName(TTrack.this, string, true);
                }
            }
        });
        final JLabel jLabel = new JLabel();
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(jLabel);
        jToolBar.add(this.nameField);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jToolBar, "Center");
        this.nameDialog.setContentPane(jPanel);
        this.nameDialog.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.nameDialog.getBounds().width) / 2;
        int n2 = (dimension.height - this.nameDialog.getBounds().height) / 2;
        this.nameDialog.setLocation(n, n2);
        this.nameAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontSizer.setFonts(TTrack.this.nameDialog, FontSizer.getLevel());
                TTrack.this.nameDialog.setTitle(TrackerRes.getString("TTrack.Dialog.Name.Title"));
                jLabel.setText(TrackerRes.getString("TTrack.Dialog.Name.Label"));
                TTrack.this.nameField.setText(TTrack.this.getName());
                TTrack.this.nameField.selectAll();
                TTrack.this.nameDialog.pack();
                TTrack.this.nameDialog.setVisible(true);
            }
        };
        this.nameItem = new JMenuItem();
        this.nameItem.addActionListener(this.nameAction);
        this.footprintMenu = new JMenu();
        this.descriptionItem = new JMenuItem();
        this.descriptionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame tFrame;
                if (TTrack.this.trackerPanel != null && (tFrame = TTrack.this.trackerPanel.getTFrame()) != null) {
                    if (tFrame.notesDialog.isVisible()) {
                        tFrame.notesDialog.setVisible(true);
                    } else {
                        tFrame.getToolBar((TrackerPanel)TTrack.this.trackerPanel).notesButton.doClick();
                    }
                }
            }
        });
        this.dataBuilderItem = new JMenuItem();
        this.dataBuilderItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TTrack.this.trackerPanel != null) {
                    TTrack.this.trackerPanel.getDataBuilder().setSelectedPanel(TTrack.this.getName());
                    TTrack.this.trackerPanel.getDataBuilder().setVisible(true);
                }
            }
        });
        this.visibleItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TTrack.this.setVisible(TTrack.this.visibleItem.isSelected());
                TTrack.this.repaint();
            }
        });
        this.trailVisibleItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TTrack.this.setTrailVisible(TTrack.this.trailVisibleItem.isSelected());
                if (!TTrack.this.isTrailVisible()) {
                    for (TrackerPanel trackerPanel : TTrack.this.panels) {
                        Step step = trackerPanel.getSelectedStep();
                        if (step == null || step.getTrack() != TTrack.this || step.getFrameNumber() == trackerPanel.getFrameNumber()) continue;
                        trackerPanel.setSelectedPoint(null);
                    }
                }
                TTrack.this.repaint();
            }
        });
        this.markByDefaultItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TTrack.this.setMarkByDefault(TTrack.this.markByDefaultItem.isSelected());
            }
        });
        this.autoAdvanceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TTrack.this.setAutoAdvance(TTrack.this.autoAdvanceItem.isSelected());
            }
        });
        this.lockedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TTrack.this.setLocked(TTrack.this.lockedItem.isSelected());
            }
        });
        this.deleteTrackItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TTrack.this.delete();
            }
        });
        this.deleteStepItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TTrack.this.trackerPanel.deletePoint(TTrack.this.trackerPanel.getSelectedPoint());
            }
        });
        this.clearStepsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutoTracker autoTracker;
                if (TTrack.this.isLocked()) {
                    return;
                }
                XMLControlElement xMLControlElement = new XMLControlElement(TTrack.this);
                int n = 0;
                while (n < TTrack.this.getSteps().length) {
                    TTrack.this.steps.setStep(n, null);
                    ++n;
                }
                for (String string : TTrack.this.textColumnNames) {
                    TTrack.this.textColumnEntries.put(string, new String[0]);
                }
                Undo.postTrackEdit(TTrack.this, xMLControlElement);
                if (TTrack.this instanceof PointMass) {
                    PointMass pointMass = (PointMass)TTrack.this;
                    pointMass.updateDerivatives();
                }
                if ((autoTracker = TTrack.this.trackerPanel.getAutoTracker()).getTrack() == TTrack.this) {
                    autoTracker.reset();
                }
                autoTracker.getWizard().setVisible(false);
                TTrack.this.firePropertyChange("steps", null, null);
                TTrack.this.trackerPanel.repaint();
            }
        });
        this.footprintListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (TTrack.this.getFootprint().getName().equals(string)) {
                    return;
                }
                XMLControlElement xMLControlElement = new XMLControlElement(new TrackProperties(TTrack.this));
                TTrack.this.setFootprint(string);
                Undo.postTrackDisplayEdit(TTrack.this, xMLControlElement);
            }
        };
        this.circleFootprintListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TTrack.this.footprintListener.actionPerformed(actionEvent);
                CircleFootprint circleFootprint = (CircleFootprint)TTrack.this.getFootprint();
                circleFootprint.showProperties(TTrack.this);
            }
        };
    }

    public void setVisible(boolean bl) {
        Boolean bl2 = new Boolean(this.visible);
        this.visible = bl;
        this.support.firePropertyChange("visible", bl2, new Boolean(bl));
        if (this.trackerPanel != null) {
            this.trackerPanel.repaint();
        }
    }

    public void delete() {
        if (this.isLocked() && !this.isDependent()) {
            return;
        }
        this.cleanup();
        if (this.trackerPanel != null) {
            this.trackerPanel.setSelectedPoint(null);
            Object object = this.trackerPanel.getCoords();
            if (object instanceof ReferenceFrame && ((ReferenceFrame)object).getOriginTrack() == this) {
                object = ((ReferenceFrame)object).getCoords();
                this.trackerPanel.setCoords((ImageCoordSystem)object);
            }
        }
        Undo.postTrackDelete(this);
        for (TrackerPanel trackerPanel : this.panels) {
            trackerPanel.removeTrack(this);
        }
        this.setTrackerPanel(null);
        this.repaint();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setTrailVisible(boolean bl) {
        this.trailVisible = bl;
    }

    public boolean isTrailVisible() {
        return this.trailVisible;
    }

    public void setTrailLength(int n) {
        this.trailLength = Math.max(0, n);
    }

    public int getTrailLength() {
        if (this.isMarking) {
            return 1;
        }
        return this.trailLength;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
        this.support.firePropertyChange("locked", null, new Boolean(bl));
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setAutoAdvance(boolean bl) {
        this.autoAdvance = bl;
    }

    public boolean isAutoAdvance() {
        return this.autoAdvance;
    }

    public void setMarkByDefault(boolean bl) {
        this.markByDefault = bl;
    }

    public boolean isMarkByDefault() {
        return this.markByDefault;
    }

    public Color getColor() {
        if (this.footprint == null) {
            return this.defaultColors[0];
        }
        return this.footprint.getColor();
    }

    public void setColor(Color color) {
        if (color == null) {
            color = this.defaultColors[0];
        }
        int n = 0;
        while (n < this.footprints.length) {
            this.footprints[n].setColor(color);
            ++n;
        }
        this.erase();
        if (this.trackerPanel != null) {
            FunctionPanel functionPanel;
            this.trackerPanel.changed = true;
            if (this.trackerPanel.modelBuilder != null) {
                this.trackerPanel.modelBuilder.refreshDropdown(null);
            }
            if (this.trackerPanel.dataBuilder != null && (functionPanel = this.trackerPanel.dataBuilder.getPanel(this.getName())) != null) {
                functionPanel.setIcon(this.footprint.getIcon(21, 16));
                this.trackerPanel.dataBuilder.refreshDropdown(null);
            }
        }
        this.support.firePropertyChange("color", null, color);
    }

    public void setColorToDefault(int n) {
        int n2 = n % this.defaultColors.length;
        this.setColor(this.defaultColors[n2]);
    }

    public void setDefaultNameAndColor(TrackerPanel trackerPanel, String string) {
        String string2 = this.getName();
        int n = trackerPanel.getAlphabetIndex(string2, string);
        String string3 = TrackerPanel.alphabet.substring(n, n + 1);
        this.setName(String.valueOf(string2) + string + string3);
        this.setColorToDefault(n);
    }

    public Color chooseColor(final Color color, String string) {
        final JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.setColor(color);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jColorChooser.setColor(color);
            }
        };
        JDialog jDialog = JColorChooser.createDialog(null, string, true, jColorChooser, null, actionListener);
        FontSizer.setFonts(jDialog, FontSizer.getLevel());
        jDialog.setVisible(true);
        return jColorChooser.getColor();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string != null && !string.trim().equals("")) {
            String string2 = this.name;
            this.name = string;
            this.repaint();
            if (this.trackerPanel != null) {
                this.trackerPanel.changed = true;
                if (this.trackerPanel.dataBuilder != null) {
                    this.trackerPanel.dataBuilder.renamePanel(string2, string);
                }
                if (this.trackerPanel.modelBuilder != null) {
                    this.trackerPanel.modelBuilder.refreshBoosterDropdown();
                }
            }
            this.support.firePropertyChange("name", string2, this.name);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        if (string == null) {
            string = "";
        }
        this.description = string;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.name;
    }

    public String getMessage() {
        String string = this.getName();
        if (this.partName != null) {
            string = String.valueOf(string) + " " + this.partName;
        }
        if (this.isLocked()) {
            this.hint = TrackerRes.getString("TTrack.Locked.Hint");
        }
        if (Tracker.showHints && this.hint != null) {
            string = String.valueOf(string) + " (" + this.hint + ")";
        }
        return string;
    }

    public void setViewable(boolean bl) {
        this.viewable = bl;
    }

    public boolean isViewable() {
        return this.viewable;
    }

    public boolean isDependent() {
        return false;
    }

    public void setFootprints(Footprint[] footprintArray) {
        ArrayList<Footprint> arrayList = new ArrayList<Footprint>();
        int n = 0;
        while (n < footprintArray.length) {
            if (footprintArray[n] != null && footprintArray[n].getLength() <= this.getFootprintLength()) {
                if (this.getFootprint() != null) {
                    footprintArray[n].setColor(this.getColor());
                }
                arrayList.add(footprintArray[n]);
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            this.footprints = arrayList.toArray(new Footprint[0]);
            this.setFootprint(this.footprints[0].getName());
        }
    }

    public void setFootprints(Footprint[] footprintArray, Step step) {
        this.setFootprints(footprintArray);
    }

    public Footprint[] getFootprints() {
        return this.footprints;
    }

    public Footprint[] getFootprints(Step step) {
        return this.footprints;
    }

    public void addFootprint(Footprint footprint) {
        if (footprint.getLength() == this.getFootprintLength()) {
            Footprint[] footprintArray = new Footprint[this.footprints.length + 1];
            System.arraycopy(this.footprints, 0, footprintArray, 0, this.footprints.length);
            footprintArray[this.footprints.length] = footprint;
            this.footprints = footprintArray;
        }
    }

    public void setFootprint(String string) {
        String string2 = null;
        int n = string.indexOf("#");
        if (n > -1) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        int n2 = 0;
        while (n2 < this.footprints.length) {
            if (string.equals(this.footprints[n2].getName())) {
                this.footprint = this.footprints[n2];
                if (this.footprint instanceof CircleFootprint) {
                    ((CircleFootprint)this.footprint).setProperties(string2);
                }
                Step[] stepArray = this.steps.array;
                int n3 = 0;
                while (n3 < stepArray.length) {
                    if (stepArray[n3] != null) {
                        stepArray[n3].setFootprint(this.footprint);
                    }
                    ++n3;
                }
                this.repaint();
                if (this.trackerPanel != null) {
                    this.trackerPanel.changed = true;
                    if (this.trackerPanel.modelBuilder != null) {
                        this.trackerPanel.modelBuilder.refreshDropdown(null);
                    }
                    if (this.trackerPanel.dataBuilder != null) {
                        FunctionPanel functionPanel = this.trackerPanel.dataBuilder.getPanel(this.getName());
                        functionPanel.setIcon(this.footprint.getIcon(21, 16));
                        this.trackerPanel.dataBuilder.refreshDropdown(null);
                    }
                }
                this.support.firePropertyChange("footprint", null, this.footprint);
                return;
            }
            ++n2;
        }
    }

    public Footprint getFootprint() {
        return this.footprint;
    }

    public void setFootprint(String string, Step step) {
        this.setFootprint(string);
    }

    public Footprint getFootprint(Step step) {
        return this.getFootprint();
    }

    public abstract int getStepLength();

    public abstract int getFootprintLength();

    public abstract Step createStep(int var1, double var2, double var4);

    public Step deleteStep(int n) {
        if (this.locked) {
            return null;
        }
        Step step = this.steps.getStep(n);
        if (step != null) {
            XMLControlElement xMLControlElement = new XMLControlElement(this);
            this.steps.setStep(n, null);
            for (String string : this.textColumnNames) {
                String[] stringArray = this.textColumnEntries.get(string);
                if (stringArray.length <= n) continue;
                stringArray[n] = null;
            }
            Undo.postTrackEdit(this, xMLControlElement);
            this.support.firePropertyChange("step", null, new Integer(n));
        }
        return step;
    }

    public Step getStep(int n) {
        return this.steps.getStep(n);
    }

    public Step getNextVisibleStep(Step step, TrackerPanel trackerPanel) {
        Step[] stepArray = this.getSteps();
        boolean bl = false;
        int n = 0;
        while (n < stepArray.length) {
            if (bl && stepArray[n] != null && this.isStepVisible(stepArray[n], trackerPanel)) {
                return stepArray[n];
            }
            if (stepArray[n] == step) {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            n = 0;
            while (n < stepArray.length) {
                if (stepArray[n] != null && stepArray[n] != step && this.isStepVisible(stepArray[n], trackerPanel)) {
                    return stepArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public Step getPreviousVisibleStep(Step step, TrackerPanel trackerPanel) {
        Step[] stepArray = this.getSteps();
        boolean bl = false;
        int n = stepArray.length - 1;
        while (n > -1) {
            if (bl && stepArray[n] != null && this.isStepVisible(stepArray[n], trackerPanel)) {
                return stepArray[n];
            }
            if (stepArray[n] == step) {
                bl = true;
            }
            --n;
        }
        if (bl) {
            n = stepArray.length - 1;
            while (n > -1) {
                if (stepArray[n] != null && stepArray[n] != step && this.isStepVisible(stepArray[n], trackerPanel)) {
                    return stepArray[n];
                }
                --n;
            }
        }
        return null;
    }

    public Step getStep(TPoint tPoint, TrackerPanel trackerPanel) {
        if (tPoint == null) {
            return null;
        }
        Step[] stepArray = this.steps.array;
        int n = 0;
        while (n < stepArray.length) {
            if (stepArray[n] != null) {
                TPoint[] tPointArray = stepArray[n].getPoints();
                int n2 = 0;
                while (n2 < tPointArray.length) {
                    if (tPointArray[n2] == tPoint) {
                        return stepArray[n];
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    public Step[] getSteps() {
        return this.steps.array;
    }

    public boolean isStepComplete(int n) {
        return false;
    }

    public TPoint autoMarkAt(int n, double d, double d2) {
        this.createStep(n, d, d2);
        return this.getMarkedPoint(n, this.getTargetIndex());
    }

    public TPoint getMarkedPoint(int n, int n2) {
        Step step = this.getStep(n);
        if (step == null) {
            return null;
        }
        return step.getPoints()[n2];
    }

    protected int getTargetIndex() {
        return this.targetIndex;
    }

    protected void setTargetIndex(int n) {
        if (this.isAutoTrackable(n)) {
            this.targetIndex = n;
        }
    }

    protected void setTargetIndex(String string) {
        int n = 0;
        while (n < this.getStepLength()) {
            if (string.equals(this.getTargetDescription(n))) {
                this.setTargetIndex(n);
                break;
            }
            ++n;
        }
    }

    protected void setTargetIndex(TPoint tPoint) {
        Step step = this.getStep(tPoint, this.trackerPanel);
        if (step != null) {
            this.setTargetIndex(step.getPointIndex(tPoint));
        }
    }

    protected String getTargetDescription(int n) {
        return null;
    }

    protected boolean isAutoTrackable(int n) {
        return true;
    }

    protected boolean isAutoTrackable() {
        return false;
    }

    public boolean isEmpty() {
        Step[] stepArray = this.steps.array;
        int n = 0;
        while (n < stepArray.length) {
            if (stepArray[n] != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void setFontLevel(int n) {
        Object[] objectArray = new Object[]{this.tLabel, this.xLabel, this.yLabel, this.magLabel, this.angleLabel, this.stepLabel, this.tValueLabel, this.stepValueLabel, this.tField, this.xField, this.yField, this.magField, this.angleField};
        FontSizer.setFonts(objectArray, n);
    }

    public DatasetManager getData(TrackerPanel trackerPanel) {
        if (this.data == null) {
            this.data = new DatasetManager(true);
            this.data.setSorted(true);
        }
        if (this.refreshDataLater) {
            return this.data;
        }
        if (!this.dataValid) {
            Object object;
            this.dataValid = true;
            this.refreshData(this.data, trackerPanel);
            if (this.dataProp != null) {
                object = this.dataProp.getChildControls();
                int n = 0;
                while (n < ((XMLControl[])object).length) {
                    block12: {
                        Dataset dataset2;
                        String string = object[n].getString("function_name");
                        for (Dataset dataset2 : this.data.getDatasets()) {
                            if (!(dataset2 instanceof DataFunction) || !dataset2.getYColumnName().equals(string)) {
                                continue;
                            }
                            break block12;
                        }
                        dataset2 = new DataFunction(this.data);
                        object[n].loadObject(dataset2);
                        dataset2.setXColumnVisible(false);
                        this.data.addDataset(dataset2);
                    }
                    ++n;
                }
                this.dataProp = null;
            }
            if (this.constantsLoadedFromXML != null) {
                int n = 0;
                while (n < this.constantsLoadedFromXML.length) {
                    String string = (String)this.constantsLoadedFromXML[n][0];
                    double d = (Double)this.constantsLoadedFromXML[n][1];
                    String string2 = (String)this.constantsLoadedFromXML[n][2];
                    String string3 = this.constantsLoadedFromXML[n].length < 4 ? null : (String)this.constantsLoadedFromXML[n][3];
                    this.data.setConstant(string, d, string2, string3);
                    ++n;
                }
                this.constantsLoadedFromXML = null;
            }
            object = this.data.getDatasets();
            int n = 0;
            while (n < ((ArrayList)object).size()) {
                if (((ArrayList)object).get(n) instanceof DataFunction) {
                    ((DataFunction)((ArrayList)object).get(n)).refreshFunctionData();
                }
                ++n;
            }
            DataTool dataTool = DataTool.getTool();
            if (trackerPanel != null && dataTool.isVisible() && dataTool.getSelectedTab() != null && dataTool.getSelectedTab().isInterestedIn(this.data)) {
                dataTool.getSelectedTab().refreshData();
            }
        }
        return this.data;
    }

    protected void refreshData(DatasetManager datasetManager, TrackerPanel trackerPanel) {
    }

    protected void refreshData(DatasetManager datasetManager, TrackerPanel trackerPanel, int n, int n2) {
        this.refreshData(datasetManager, trackerPanel);
    }

    public String getDataName(int n) {
        if (n == 0) {
            return this.data.getDataset(0).getXColumnName();
        }
        if (n < this.data.getDatasets().size() + 1) {
            return this.data.getDataset(n - 1).getYColumnName();
        }
        return null;
    }

    public String getDataDescription(int n) {
        if (this.dataDescriptions == null) {
            return "";
        }
        if (n >= this.dataDescriptions.length) {
            ArrayList<Dataset> arrayList = this.data.getDatasets();
            if (--n < arrayList.size() && arrayList.get(n) instanceof DataFunction) {
                String string = arrayList.get(n).getYColumnDescription();
                if (string == null) {
                    string = "";
                }
                return string;
            }
            return "";
        }
        return this.dataDescriptions[n];
    }

    public ArrayList<Integer> getPreferredDataOrder() {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Dataset> arrayList2 = this.data.getDatasets();
        if (this.preferredColumnOrder != null) {
            n = 0;
            while (n < this.preferredColumnOrder.length) {
                if (!arrayList.contains(this.preferredColumnOrder[n]) && this.preferredColumnOrder[n] < arrayList2.size()) {
                    arrayList.add(this.preferredColumnOrder[n]);
                }
                ++n;
            }
        }
        n = 0;
        while (n < arrayList2.size()) {
            if (!arrayList.contains(n)) {
                arrayList.add(n);
            }
            ++n;
        }
        return arrayList;
    }

    public int getFrameForData(String string, double d) {
        block6: {
            Dataset dataset;
            block5: {
                if (this.dataFrames.isEmpty() || this.data.getDatasets().isEmpty()) {
                    return -1;
                }
                dataset = this.data.getDataset(0);
                if (!string.equals(dataset.getXColumnName())) break block5;
                double[] dArray = dataset.getXPoints();
                int n = 0;
                while (n < dArray.length) {
                    if (d == dArray[n]) {
                        return n < this.dataFrames.size() ? this.dataFrames.get(n) : -1;
                    }
                    ++n;
                }
                break block6;
            }
            int n = this.data.getDatasetIndex(string);
            if (n <= -1) break block6;
            dataset = this.data.getDataset(n);
            double[] dArray = dataset.getYPoints();
            int n2 = 0;
            while (n2 < dArray.length) {
                if (d == dArray[n2]) {
                    return n2 < this.dataFrames.size() ? this.dataFrames.get(n2) : -1;
                }
                ++n2;
            }
        }
        return -1;
    }

    public ArrayList<String> getTextColumnNames() {
        return this.textColumnNames;
    }

    public boolean addTextColumn(String string) {
        if (string == null || string.trim().equals("")) {
            return false;
        }
        string = string.trim();
        for (String object2 : this.textColumnNames) {
            if (!object2.equals(string)) continue;
            return false;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        this.textColumnNames.add(string);
        this.textColumnEntries.put(string, new String[0]);
        Undo.postTrackEdit(this, xMLControlElement);
        this.trackerPanel.changed = true;
        this.firePropertyChange("text_column", null, string);
        return true;
    }

    public boolean removeTextColumn(String string) {
        if (string == null) {
            return false;
        }
        string = string.trim();
        for (String string2 : this.textColumnNames) {
            if (!string2.equals(string)) continue;
            XMLControlElement xMLControlElement = new XMLControlElement(this);
            this.textColumnEntries.remove(string);
            this.textColumnNames.remove(string);
            Undo.postTrackEdit(this, xMLControlElement);
            this.trackerPanel.changed = true;
            this.firePropertyChange("text_column", string, null);
            return true;
        }
        return false;
    }

    public boolean renameTextColumn(String string, String string2) {
        if (string == null) {
            return false;
        }
        string = string.trim();
        if (string2 == null || string2.trim().equals("")) {
            return false;
        }
        string2 = string2.trim();
        for (String string3 : this.textColumnNames) {
            if (!string3.equals(string2)) continue;
            return false;
        }
        int n = 0;
        while (n < this.textColumnNames.size()) {
            String string4 = this.textColumnNames.get(n);
            if (string.equals(string4)) {
                XMLControlElement xMLControlElement = new XMLControlElement(this);
                this.textColumnNames.remove(string);
                this.textColumnNames.add(n, string2);
                String[] stringArray = this.textColumnEntries.remove(string);
                this.textColumnEntries.put(string2, stringArray);
                Undo.postTrackEdit(this, xMLControlElement);
            }
            ++n;
        }
        this.trackerPanel.changed = true;
        this.firePropertyChange("text_column", string, string2);
        return true;
    }

    public String getTextColumnEntry(String string, int n) {
        if (n < 0) {
            return null;
        }
        String[] stringArray = this.textColumnEntries.get(string);
        if (stringArray == null) {
            return null;
        }
        if (n > stringArray.length - 1) {
            return null;
        }
        return stringArray[n];
    }

    public boolean setTextColumnEntry(String string, int n, String string2) {
        String[] stringArray;
        if (this.isLocked()) {
            return false;
        }
        if (n < 0) {
            return false;
        }
        String[] stringArray2 = this.textColumnEntries.get(string);
        if (stringArray2 == null) {
            return false;
        }
        string2 = string2.trim().equals("") ? null : string2.trim();
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        if (n > stringArray2.length - 1) {
            stringArray = new String[n + 1];
            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
            stringArray2 = stringArray;
            this.textColumnEntries.put(string, stringArray2);
        }
        if ((stringArray = stringArray2[n]) == string2 || stringArray != null && stringArray.equals(string2)) {
            return false;
        }
        stringArray2[n] = string2;
        Undo.postTrackEdit(this, xMLControlElement);
        this.trackerPanel.changed = true;
        this.firePropertyChange("text_column", null, null);
        return true;
    }

    public JMenu getMenu(TrackerPanel trackerPanel) {
        this.visibleItem.setText(TrackerRes.getString("TTrack.MenuItem.Visible"));
        this.trailVisibleItem.setText(TrackerRes.getString("TTrack.MenuItem.TrailVisible"));
        this.autoAdvanceItem.setText(TrackerRes.getString("TTrack.MenuItem.Autostep"));
        this.markByDefaultItem.setText(TrackerRes.getString("TTrack.MenuItem.MarkByDefault"));
        this.lockedItem.setText(TrackerRes.getString("TTrack.MenuItem.Locked"));
        this.deleteTrackItem.setText(TrackerRes.getString("TTrack.MenuItem.Delete"));
        this.deleteStepItem.setText(TrackerRes.getString("TTrack.MenuItem.DeletePoint"));
        this.clearStepsItem.setText(TrackerRes.getString("TTrack.MenuItem.ClearSteps"));
        this.colorItem.setText(TrackerRes.getString("TTrack.MenuItem.Color"));
        this.nameItem.setText(TrackerRes.getString("TTrack.MenuItem.Name"));
        this.footprintMenu.setText(TrackerRes.getString("TTrack.MenuItem.Footprint"));
        this.descriptionItem.setText(TrackerRes.getString("TTrack.MenuItem.Description"));
        this.dataBuilderItem.setText(TrackerRes.getString("TView.Menuitem.Define"));
        this.visibleItem.setSelected(this.isVisible());
        this.lockedItem.setSelected(this.isLocked());
        this.trailVisibleItem.setSelected(this.isTrailVisible());
        this.markByDefaultItem.setSelected(this.isMarkByDefault());
        this.autoAdvanceItem.setSelected(this.isAutoAdvance());
        this.lockedItem.setEnabled(true);
        boolean bl = this.isLocked() || this.isDependent();
        TPoint tPoint = trackerPanel.getSelectedPoint();
        Step step = this.getStep(tPoint, trackerPanel);
        this.deleteStepItem.setEnabled(!bl && step != null);
        this.clearStepsItem.setEnabled(!bl);
        this.deleteTrackItem.setEnabled(!this.isLocked() || this.isDependent());
        this.nameItem.setEnabled(!this.isLocked() || this.isDependent());
        this.footprintMenu.removeAll();
        Footprint[] footprintArray = this.getFootprints();
        int n = 0;
        while (n < footprintArray.length) {
            JMenuItem jMenuItem = new JMenuItem(footprintArray[n].getDisplayName(), footprintArray[n].getIcon(21, 16));
            jMenuItem.setActionCommand(footprintArray[n].getName());
            if (footprintArray[n] instanceof CircleFootprint) {
                jMenuItem.setText(String.valueOf(footprintArray[n].getDisplayName()) + "...");
                jMenuItem.addActionListener(this.circleFootprintListener);
            } else {
                jMenuItem.addActionListener(this.footprintListener);
            }
            if (footprintArray[n] == this.footprint) {
                jMenuItem.setBorder(BorderFactory.createLineBorder(jMenuItem.getBackground().darker()));
            }
            this.footprintMenu.add(jMenuItem);
            ++n;
        }
        this.menu = new JMenu(this.getName());
        this.menu.setIcon(this.getFootprint().getIcon(21, 16));
        if (trackerPanel.isEnabled("track.name") || trackerPanel.isEnabled("track.description")) {
            if (this.menu.getItemCount() > 0 && this.menu.getItem(this.menu.getItemCount() - 1) != null) {
                this.menu.addSeparator();
            }
            if (trackerPanel.isEnabled("track.name")) {
                this.menu.add(this.nameItem);
            }
            if (trackerPanel.isEnabled("track.description")) {
                this.menu.add(this.descriptionItem);
            }
        }
        if (trackerPanel.isEnabled("track.color") || trackerPanel.isEnabled("track.footprint")) {
            if (this.menu.getItemCount() > 0 && this.menu.getItem(this.menu.getItemCount() - 1) != null) {
                this.menu.addSeparator();
            }
            if (trackerPanel.isEnabled("track.color")) {
                this.menu.add(this.colorItem);
            }
            if (trackerPanel.isEnabled("track.footprint")) {
                this.menu.add(this.footprintMenu);
            }
        }
        if (trackerPanel.isEnabled("track.visible") || trackerPanel.isEnabled("track.locked")) {
            if (this.menu.getItemCount() > 0 && this.menu.getItem(this.menu.getItemCount() - 1) != null) {
                this.menu.addSeparator();
            }
            if (trackerPanel.isEnabled("track.visible")) {
                this.menu.add(this.visibleItem);
            }
            if (trackerPanel.isEnabled("track.locked")) {
                this.menu.add(this.lockedItem);
            }
        }
        if (this.isViewable() && trackerPanel.isEnabled("data.builder")) {
            if (this.menu.getItemCount() > 0 && this.menu.getItem(this.menu.getItemCount() - 1) != null) {
                this.menu.addSeparator();
            }
            this.menu.add(this.dataBuilderItem);
        }
        if (trackerPanel.isEnabled("track.delete")) {
            if (this.menu.getItemCount() > 0 && this.menu.getItem(this.menu.getItemCount() - 1) != null) {
                this.menu.addSeparator();
            }
            this.menu.add(this.deleteTrackItem);
        }
        return this.menu;
    }

    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        this.toolbarTrackComponents.clear();
        return this.toolbarTrackComponents;
    }

    public ArrayList<Component> getToolbarPointComponents(TrackerPanel trackerPanel, TPoint tPoint) {
        this.toolbarPointComponents.clear();
        this.stepLabel.setText(TrackerRes.getString("TTrack.Label.Step"));
        Step step = this.getStep(tPoint, trackerPanel);
        VideoClip videoClip = trackerPanel.getPlayer().getVideoClip();
        if (step != null && videoClip.includesFrame(step.getFrameNumber())) {
            int n = videoClip.frameToStep(step.getFrameNumber());
            this.stepValueLabel.setText(String.valueOf(n) + ": ");
            double d = trackerPanel.getPlayer().getStepTime(n) / 1000.0;
            if (d >= 0.0) {
                this.tField.setValue(d);
            }
        }
        this.angleField.setToolTipText(this.angleField.getConversionFactor() == 1.0 ? TrackerRes.getString("TTrack.AngleField.Radians.Tooltip") : TrackerRes.getString("TTrack.AngleField.Degrees.Tooltip"));
        return this.toolbarPointComponents;
    }

    public void erase() {
        AutoTracker autoTracker;
        Step[] stepArray = this.steps.array;
        int n = 0;
        while (n < stepArray.length) {
            if (stepArray[n] != null) {
                stepArray[n].erase();
            }
            ++n;
        }
        if (this.trackerPanel != null && this.trackerPanel.autoTracker != null && (autoTracker = this.trackerPanel.getAutoTracker()).getWizard().isVisible() && autoTracker.getTrack() == this) {
            autoTracker.erase();
        }
    }

    public void remark() {
        Step[] stepArray = this.steps.array;
        int n = 0;
        while (n < stepArray.length) {
            if (stepArray[n] != null) {
                stepArray[n].remark();
            }
            ++n;
        }
    }

    public void repaint() {
        this.remark();
        for (TrackerPanel trackerPanel : this.panels) {
            trackerPanel.repaintDirtyRegion();
        }
    }

    public void erase(TrackerPanel trackerPanel) {
        AutoTracker autoTracker;
        Step[] stepArray = this.steps.array;
        int n = 0;
        while (n < stepArray.length) {
            if (stepArray[n] != null) {
                stepArray[n].erase(trackerPanel);
            }
            ++n;
        }
        if (trackerPanel.autoTracker != null && (autoTracker = trackerPanel.getAutoTracker()).getWizard().isVisible() && autoTracker.getTrack() == this) {
            autoTracker.erase();
        }
    }

    public void remark(TrackerPanel trackerPanel) {
        Step[] stepArray = this.steps.array;
        int n = 0;
        while (n < stepArray.length) {
            if (stepArray[n] != null) {
                stepArray[n].remark(trackerPanel);
            }
            ++n;
        }
    }

    public void repaint(TrackerPanel trackerPanel) {
        this.remark(trackerPanel);
        trackerPanel.repaintDirtyRegion();
    }

    public void repaint(Step step) {
        Iterator<TrackerPanel> iterator = this.panels.iterator();
        while (iterator.hasNext()) {
            step.repaint(iterator.next());
        }
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!(drawingPanel instanceof TrackerPanel) || !this.visible) {
            return;
        }
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        this.panels.add(trackerPanel);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = trackerPanel.getFrameNumber();
        int n2 = trackerPanel.getPlayer().getVideoClip().getStepSize();
        if (this.trailVisible) {
            boolean bl = this.getTrailLength() > 0;
            Step[] stepArray = this.steps.array;
            int n3 = 0;
            while (n3 < stepArray.length) {
                if ((!bl || n - n3 <= (this.getTrailLength() - 1) * n2 && n3 <= n) && stepArray[n3] != null && trackerPanel.getPlayer().getVideoClip().includesFrame(n3)) {
                    stepArray[n3].draw(trackerPanel, graphics2D);
                }
                ++n3;
            }
        } else {
            Step step = this.getStep(n);
            if (step != null) {
                step.draw(trackerPanel, graphics2D);
            }
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!(drawingPanel instanceof TrackerPanel) || !this.visible) {
            return null;
        }
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        Interactive interactive = null;
        int n3 = trackerPanel.getFrameNumber();
        int n4 = trackerPanel.getPlayer().getVideoClip().getStepSize();
        if (this.trailVisible) {
            boolean bl = this.getTrailLength() > 0;
            Step[] stepArray = this.steps.array;
            int n5 = 0;
            while (n5 < stepArray.length) {
                if ((!bl || n3 - n5 <= (this.getTrailLength() - 1) * n4 && n5 <= n3) && stepArray[n5] != null && trackerPanel.getPlayer().getVideoClip().includesFrame(n5) && (interactive = stepArray[n5].findInteractive(trackerPanel, n, n2)) != null) {
                    return interactive;
                }
                ++n5;
            }
        } else {
            Step step = this.getStep(n3);
            if (step != null && trackerPanel.getPlayer().getVideoClip().includesFrame(n3) && (interactive = step.findInteractive(trackerPanel, n, n2)) != null) {
                return interactive;
            }
        }
        return null;
    }

    @Override
    public double getX() {
        return 0.0;
    }

    @Override
    public double getY() {
        return 0.0;
    }

    @Override
    public void setX(double d) {
    }

    @Override
    public void setY(double d) {
    }

    @Override
    public void setXY(double d, double d2) {
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isMeasured() {
        return !this.isEmpty();
    }

    @Override
    public double getXMin() {
        return this.getX();
    }

    @Override
    public double getXMax() {
        return this.getX();
    }

    @Override
    public double getYMin() {
        return this.getY();
    }

    @Override
    public double getYMax() {
        return this.getY();
    }

    public double getXMin(TrackerPanel trackerPanel) {
        double[] dArray = this.getWorldBounds(trackerPanel);
        return dArray[2];
    }

    public double getXMax(TrackerPanel trackerPanel) {
        double[] dArray = this.getWorldBounds(trackerPanel);
        return dArray[0];
    }

    public double getYMin(TrackerPanel trackerPanel) {
        double[] dArray = this.getWorldBounds(trackerPanel);
        return dArray[3];
    }

    public double getYMax(TrackerPanel trackerPanel) {
        double[] dArray = this.getWorldBounds(trackerPanel);
        return dArray[1];
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (propertyChangeEvent.getSource() instanceof TrackerPanel) {
            TrackerPanel trackerPanel = (TrackerPanel)propertyChangeEvent.getSource();
            if (string.equals("transform") || string.equals("coords")) {
                this.dataValid = false;
                this.erase();
                trackerPanel.repaint();
            } else if (string.equals("magnification")) {
                this.erase();
                trackerPanel.repaint();
            } else if (string.equals("imagespace")) {
                this.erase(trackerPanel);
            } else if (string.equals("data")) {
                this.dataValid = false;
            } else if (string.equals("radian_angles")) {
                this.setAnglesInRadians((Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.support.firePropertyChange(string, object, object2);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(string, propertyChangeListener);
    }

    protected void setTrackerPanel(TrackerPanel trackerPanel) {
        this.trackerPanel = trackerPanel;
    }

    protected double[] getWorldBounds(TrackerPanel trackerPanel) {
        double[] dArray = this.worldBounds.get(trackerPanel);
        dArray = new double[4];
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Step[] stepArray = this.steps.array;
        int n = 0;
        while (n < stepArray.length) {
            if (stepArray[n] != null) {
                TPoint[] tPointArray = stepArray[n].getPoints();
                int n2 = 0;
                while (n2 < tPointArray.length) {
                    if (tPointArray[n2] != null) {
                        double_.add(tPointArray[n2].getWorldPosition(trackerPanel));
                    }
                    ++n2;
                }
            }
            ++n;
        }
        dArray[0] = ((RectangularShape)double_).getX() + 1.05 * ((RectangularShape)double_).getWidth();
        dArray[1] = ((RectangularShape)double_).getY() + 1.05 * ((RectangularShape)double_).getHeight();
        dArray[2] = ((RectangularShape)double_).getX() - 0.05 * ((RectangularShape)double_).getWidth();
        dArray[3] = ((RectangularShape)double_).getY() - 0.05 * ((RectangularShape)double_).getHeight();
        this.worldBounds.put(trackerPanel, dArray);
        return dArray;
    }

    protected void setAnglesInRadians(boolean bl) {
        this.angleField.setUnits(bl ? null : "\u00ba");
        this.angleField.setDecimalPlaces(bl ? 3 : 1);
        this.angleField.setConversionFactor(bl ? 1.0 : 57.29577951308232);
        this.angleField.setToolTipText(bl ? TrackerRes.getString("TTrack.AngleField.Radians.Tooltip") : TrackerRes.getString("TTrack.AngleField.Degrees.Tooltip"));
    }

    protected void cleanup() {
    }

    protected void setMarking(boolean bl) {
        this.isMarking = bl;
    }

    protected Cursor getMarkingCursor(InputEvent inputEvent) {
        if (inputEvent != null && TMouseHandler.isAutoTrackTrigger(inputEvent) && this.trackerPanel.getVideo() != null && this.isAutoTrackable(this.getTargetIndex())) {
            int n;
            AutoTracker.KeyFrame keyFrame;
            AutoTracker autoTracker;
            Step step = this.getStep(this.trackerPanel.getFrameNumber());
            if (step == null || step.getPoints()[step.getPoints().length - 1] == null) {
                return TMouseHandler.autoTrackMarkCursor;
            }
            if ((this instanceof CoordAxes || this instanceof PerspectiveTrack || this instanceof TapeMeasure || this instanceof Protractor) && ((autoTracker = this.trackerPanel.getAutoTracker()).getTrack() == null || autoTracker.getTrack() == this) && (keyFrame = autoTracker.getFrame(n = this.trackerPanel.getFrameNumber()).getKeyFrame()) == null) {
                return TMouseHandler.autoTrackMarkCursor;
            }
            return TMouseHandler.autoTrackCursor;
        }
        return TMouseHandler.markPointCursor;
    }

    protected void createWarningDialog() {
        if (skippedStepWarningDialog == null && this.trackerPanel != null && this.trackerPanel.getTFrame() != null) {
            skippedStepWarningDialog = new JDialog((Frame)this.trackerPanel.getTFrame(), true);
            skippedStepWarningDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    skippedStepWarningOn = !skippedStepWarningCheckbox.isSelected();
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            skippedStepWarningDialog.setContentPane(jPanel);
            skippedStepWarningTextpane = new JTextPane();
            skippedStepWarningTextpane.setEditable(false);
            skippedStepWarningTextpane.setOpaque(false);
            skippedStepWarningTextpane.setPreferredSize(new Dimension(400, 120));
            skippedStepWarningTextpane.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 12));
            skippedStepWarningTextpane.setContentType("text");
            skippedStepWarningTextpane.setFont(new JLabel().getFont());
            jPanel.add((Component)skippedStepWarningTextpane, "Center");
            skippedStepWarningCheckbox = new JCheckBox();
            skippedStepWarningCheckbox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 30));
            closeButton = new JButton();
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    skippedStepWarningOn = !skippedStepWarningCheckbox.isSelected();
                    skippedStepWarningDialog.setVisible(false);
                }
            });
            JPanel jPanel2 = new JPanel();
            jPanel2.add(skippedStepWarningCheckbox);
            jPanel2.add(closeButton);
            jPanel.add((Component)jPanel2, "South");
        }
    }

    protected JDialog getStepSizeWarningDialog() {
        this.createWarningDialog();
        if (skippedStepWarningDialog == null) {
            return null;
        }
        skippedStepWarningDialog.setTitle(TrackerRes.getString("TTrack.Dialog.StepSizeWarning.Title"));
        String string = TrackerRes.getString("TTrack.Dialog.StepSizeWarning.Message1");
        String string2 = TrackerRes.getString("TTrack.Dialog.StepSizeWarning.Message2");
        String string3 = TrackerRes.getString("TTrack.Dialog.StepSizeWarning.Message3");
        skippedStepWarningTextpane.setText(String.valueOf(string) + "  " + string2 + "  " + string3);
        skippedStepWarningCheckbox.setText(TrackerRes.getString("TTrack.Dialog.SkippedStepWarning.Checkbox"));
        closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
        skippedStepWarningDialog.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - TTrack.skippedStepWarningDialog.getBounds().width) / 2;
        int n2 = (dimension.height - TTrack.skippedStepWarningDialog.getBounds().height) / 2;
        skippedStepWarningDialog.setLocation(n, n2);
        return skippedStepWarningDialog;
    }

    protected JDialog getSkippedStepWarningDialog() {
        this.createWarningDialog();
        if (skippedStepWarningDialog == null) {
            return null;
        }
        skippedStepWarningDialog.setTitle(TrackerRes.getString("TTrack.Dialog.SkippedStepWarning.Title"));
        String string = TrackerRes.getString("TTrack.Dialog.SkippedStepWarning.Message1");
        String string2 = TrackerRes.getString("TTrack.Dialog.StepSizeWarning.Message3");
        skippedStepWarningTextpane.setText(String.valueOf(string) + "  " + string2);
        skippedStepWarningCheckbox.setText(TrackerRes.getString("TTrack.Dialog.SkippedStepWarning.Checkbox"));
        closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
        FontSizer.setFonts(skippedStepWarningDialog, FontSizer.getLevel());
        skippedStepWarningDialog.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - TTrack.skippedStepWarningDialog.getBounds().width) / 2;
        int n2 = (dimension.height - TTrack.skippedStepWarningDialog.getBounds().height) / 2;
        skippedStepWarningDialog.setLocation(n, n2);
        return skippedStepWarningDialog;
    }

    protected Dataset convertTextToDataColumn(String string) {
        if (string == null || this.trackerPanel == null) {
            return null;
        }
        String[] stringArray = this.textColumnEntries.get(string);
        if (stringArray != null && stringArray.length > 0) {
            DatasetManager datasetManager = this.getData(this.trackerPanel);
            double[] dArray = datasetManager.getXPoints(0);
            double[] dArray2 = new double[dArray.length];
            int n = 0;
            while (n < dArray2.length) {
                if (stringArray.length > n) {
                    if (stringArray[n] == null) {
                        dArray2[n] = Double.NaN;
                    } else {
                        try {
                            dArray2[n] = Double.parseDouble(stringArray[n]);
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                } else {
                    dArray2[n] = Double.NaN;
                }
                ++n;
            }
            Dataset dataset = new Dataset();
            dataset.append(dArray, dArray2);
            dataset.setXYColumnNames(datasetManager.getDataset(0).getXColumnName(), string, this.getName());
            dataset.setMarkerColor(this.getColor());
            return dataset;
        }
        return null;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public boolean isStepVisible(Step step, TrackerPanel trackerPanel) {
        if (!this.isVisible()) {
            return false;
        }
        int n = step.getFrameNumber();
        return trackerPanel.getPlayer().getVideoClip().includesFrame(n) && (this.trailVisible || trackerPanel.getFrameNumber() == n);
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            String[][] stringArrayArray;
            Object object2;
            TTrack tTrack = (TTrack)object;
            xMLControl.setValue("name", tTrack.getName());
            if (!tTrack.description.equals("")) {
                xMLControl.setValue("description", tTrack.description);
            }
            xMLControl.setValue("color", tTrack.getColor());
            Footprint footprint = tTrack.getFootprint();
            String string = footprint.getName();
            if (footprint instanceof CircleFootprint) {
                object2 = (String[])footprint;
                string = String.valueOf(string) + "#" + ((CircleFootprint)object2).getProperties();
            }
            xMLControl.setValue("footprint", string);
            xMLControl.setValue("visible", tTrack.isVisible());
            xMLControl.setValue("trail", tTrack.isTrailVisible());
            if (tTrack.isLocked()) {
                xMLControl.setValue("locked", tTrack.isLocked());
            }
            if (!tTrack.getTextColumnNames().isEmpty()) {
                object2 = tTrack.getTextColumnNames().toArray(new String[0]);
                xMLControl.setValue("text_column_names", object2);
                stringArrayArray = new String[((Object)object2).length][];
                int n = 0;
                while (n < ((Object)object2).length) {
                    stringArrayArray[n] = tTrack.textColumnEntries.get(object2[n]);
                    ++n;
                }
                xMLControl.setValue("text_column_entries", stringArrayArray);
            }
            if (tTrack.trackerPanel != null) {
                String[] stringArray;
                object2 = tTrack.getData(tTrack.trackerPanel);
                stringArrayArray = ((DatasetManager)object2).getDatasets().iterator();
                ArrayList<String[]> arrayList = new ArrayList<String[]>();
                while (stringArrayArray.hasNext()) {
                    stringArray = (String[])stringArrayArray.next();
                    if (!(stringArray instanceof DataFunction)) continue;
                    arrayList.add(stringArray);
                }
                if (!arrayList.isEmpty()) {
                    Object[][] objectArray;
                    stringArray = ((DatasetManager)object2).getConstantNames();
                    if (stringArray.length > 0) {
                        objectArray = new Object[stringArray.length][4];
                        int n = 0;
                        String[] stringArray2 = stringArray;
                        int n2 = stringArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            String string2 = stringArray2[n3];
                            objectArray[n][0] = string2;
                            objectArray[n][1] = ((DatasetManager)object2).getConstantValue(string2);
                            objectArray[n][2] = ((DatasetManager)object2).getConstantExpression(string2);
                            objectArray[n][3] = ((DatasetManager)object2).getConstantDescription(string2);
                            ++n;
                            ++n3;
                        }
                        xMLControl.setValue("constants", objectArray);
                    }
                    objectArray = arrayList.toArray(new DataFunction[0]);
                    xMLControl.setValue("data_functions", objectArray);
                }
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            Object object2;
            TTrack tTrack = (TTrack)object;
            boolean bl = tTrack.isLocked();
            tTrack.setLocked(false);
            tTrack.setName(xMLControl.getString("name"));
            tTrack.setDescription(xMLControl.getString("description"));
            tTrack.setColor((Color)xMLControl.getObject("color"));
            String string = xMLControl.getString("footprint");
            if (string != null) {
                tTrack.setFootprint(string.trim());
            }
            tTrack.setVisible(xMLControl.getBoolean("visible"));
            tTrack.setTrailVisible(xMLControl.getBoolean("trail"));
            tTrack.textColumnNames.clear();
            tTrack.textColumnEntries.clear();
            String[] stringArray = (String[])xMLControl.getObject("text_column_names");
            if (stringArray != null && (object2 = (String[][])xMLControl.getObject("text_column_entries")) != null) {
                void xMLProperty;
                boolean n = false;
                while (xMLProperty < stringArray.length) {
                    tTrack.textColumnNames.add(stringArray[xMLProperty]);
                    tTrack.textColumnEntries.put(stringArray[xMLProperty], (String[])object2[xMLProperty]);
                    ++xMLProperty;
                }
            }
            tTrack.constantsLoadedFromXML = (Object[][])xMLControl.getObject("constants");
            for (XMLProperty xMLProperty : xMLControl.getPropertyContent()) {
                if (!xMLProperty.getPropertyName().equals("data_functions")) continue;
                tTrack.dataProp = xMLProperty;
            }
            tTrack.setLocked(bl || xMLControl.getBoolean("locked"));
            return object;
        }
    }

    protected class StepArray {
        protected int length = 5;
        protected Step[] array = new Step[this.length];
        private boolean autofill = false;
        protected int delta = 5;

        public StepArray() {
        }

        public StepArray(Step step) {
            this.autofill = true;
            step.n = 0;
            this.array[0] = step;
            this.fill(step);
        }

        public StepArray(Step step, int n) {
            this.autofill = true;
            step.n = 0;
            this.array[0] = step;
            this.length = n;
            this.delta = n;
            this.fill(step);
        }

        public Step getStep(int n) {
            if (n >= this.length) {
                this.setLength(n + this.delta);
            }
            return this.array[n];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStep(int n, Step step) {
            if (this.autofill && step == null) {
                return;
            }
            if (n >= this.length) {
                this.setLength(n + this.delta);
            }
            Step[] stepArray = this.array;
            synchronized (this.array) {
                this.array[n] = step;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean contains(Step step) {
            Step[] stepArray = this.array;
            synchronized (this.array) {
                int n = 0;
                while (true) {
                    if (n >= this.array.length) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    if (this.array[n] == step) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return true;
                    }
                    ++n;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLength(int n) {
            Step[] stepArray = this.array;
            synchronized (this.array) {
                Step[] stepArray2 = new Step[n];
                System.arraycopy(this.array, 0, stepArray2, 0, Math.min(n, this.length));
                this.array = stepArray2;
                if (n > this.length && this.autofill) {
                    Step step = this.array[this.length - 1];
                    this.length = n;
                    this.fill(step);
                } else {
                    this.length = n;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isEmpty() {
            Step[] stepArray = this.array;
            synchronized (this.array) {
                int n = 0;
                while (true) {
                    if (n >= this.array.length) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return true;
                    }
                    if (this.array[n] != null) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return false;
                    }
                    ++n;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isPreceded(int n) {
            Step[] stepArray = this.array;
            synchronized (this.array) {
                int n2 = Math.min(n, this.array.length);
                int n3 = 0;
                while (true) {
                    if (n3 >= n2) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    if (this.array[n3] != null) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return true;
                    }
                    ++n3;
                }
            }
        }

        public boolean isAutofill() {
            return this.autofill;
        }

        private void fill(Step step) {
            int n = 0;
            while (n < this.length) {
                if (this.array[n] == null) {
                    Step step2 = (Step)step.clone();
                    step2.n = n;
                    this.array[n] = step2;
                }
                ++n;
            }
        }
    }
}

