/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.JTextField;
import org.opensourcephysics.cabrillo.tracker.AutoTracker;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public abstract class Step
implements Cloneable {
    protected static Rectangle hitRect = new Rectangle(-4, -4, 8, 8);
    protected static Shape selectionShape;
    protected static AffineTransform transform;
    protected static NumberFormat format;
    protected static Font textLayoutFont;
    protected static FontRenderContext frc;
    protected TTrack track;
    protected int n;
    protected Footprint footprint;
    protected TPoint[] points;
    protected Point[] screenPoints;
    protected boolean valid;
    protected Map<TrackerPanel, Mark> marks = new HashMap<TrackerPanel, Mark>();
    protected int defaultIndex = 0;
    protected boolean dataVisible = true;

    static {
        transform = new AffineTransform();
        format = NumberFormat.getNumberInstance(Locale.US);
        textLayoutFont = new JTextField().getFont();
        frc = new FontRenderContext(null, false, false);
        BasicStroke basicStroke = new BasicStroke(2.0f);
        selectionShape = basicStroke.createStrokedShape(hitRect);
        format.setMinimumIntegerDigits(1);
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(2);
    }

    protected Step(TTrack tTrack, int n) {
        this.track = tTrack;
        this.n = n;
    }

    public int getFrameNumber() {
        return this.n;
    }

    public void setFootprint(Footprint footprint) {
        this.footprint = footprint;
    }

    public TTrack getTrack() {
        return this.track;
    }

    public TPoint[] getPoints() {
        return this.points;
    }

    public int getPointIndex(TPoint tPoint) {
        int n = 0;
        while (n < this.points.length) {
            if (this.points[n] == tPoint) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public TPoint getDefaultPoint() {
        return this.points[this.defaultIndex];
    }

    public void setDefaultPointIndex(int n) {
        n = Math.min(n, this.points.length - 1);
        this.defaultIndex = Math.max(0, n);
    }

    public void erase(TrackerPanel trackerPanel) {
        if (this.marks.get(trackerPanel) == null) {
            return;
        }
        trackerPanel.addDirtyRegion(this.getBounds(trackerPanel));
        this.marks.put(trackerPanel, null);
    }

    public void remark(TrackerPanel trackerPanel) {
        this.erase(trackerPanel);
        trackerPanel.addDirtyRegion(this.getBounds(trackerPanel));
    }

    public void repaint(TrackerPanel trackerPanel) {
        this.remark(trackerPanel);
        trackerPanel.repaintDirtyRegion();
    }

    public void erase() {
        Iterator<TrackerPanel> iterator = this.marks.keySet().iterator();
        while (iterator.hasNext()) {
            this.erase(iterator.next());
        }
    }

    public void remark() {
        Iterator<TrackerPanel> iterator = this.marks.keySet().iterator();
        while (iterator.hasNext()) {
            this.remark(iterator.next());
        }
    }

    public void repaint() {
        Iterator<TrackerPanel> iterator = this.marks.keySet().iterator();
        while (iterator.hasNext()) {
            this.repaint(iterator.next());
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        boolean bl;
        PropertyChangeListener propertyChangeListener;
        if (this.track.trackerPanel == drawingPanel && ((AutoTracker)(propertyChangeListener = this.track.trackerPanel.getAutoTracker())).isInteracting(this.track)) {
            return;
        }
        propertyChangeListener = (TrackerPanel)drawingPanel;
        boolean bl2 = bl = ((VideoPanel)propertyChangeListener).getFrameNumber() == this.n;
        if (((TrackerPanel)propertyChangeListener).autoTracker != null && ((TrackerPanel)propertyChangeListener).autoTracker.getWizard().isVisible() && ((TrackerPanel)propertyChangeListener).autoTracker.getTrack() == this.track) {
            bl = false;
        }
        this.getMark((TrackerPanel)propertyChangeListener).draw((Graphics2D)graphics, bl);
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        boolean bl = this.track.trackerPanel.getFrameNumber() == this.getFrameNumber();
        AutoTracker autoTracker = this.track.trackerPanel.getAutoTracker();
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        this.setHitRectCenter(n, n2);
        int n3 = 0;
        while (n3 < this.points.length) {
            if (this.points[n3] != null && !Double.isNaN(this.points[n3].getX()) && hitRect.contains(this.points[n3].getScreenPosition(trackerPanel))) {
                if (bl && autoTracker.isDrawingKeyFrameFor(this.track, n3)) {
                    return null;
                }
                return this.points[n3];
            }
            ++n3;
        }
        return null;
    }

    public Rectangle getBounds(TrackerPanel trackerPanel) {
        boolean bl = trackerPanel.getFrameNumber() == this.n;
        return this.getMark(trackerPanel).getBounds(bl);
    }

    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = this.marks.get(trackerPanel);
        TPoint tPoint = null;
        if (mark == null) {
            tPoint = trackerPanel.getSelectedPoint();
            Point point = null;
            this.valid = true;
            int n = 0;
            while (n < this.points.length) {
                if (this.valid) {
                    this.valid = this.valid && !Double.isNaN(this.points[n].getX()) && !Double.isNaN(this.points[n].getY());
                    this.screenPoints[n] = this.points[n].getScreenPosition(trackerPanel);
                    if (this.valid && tPoint == this.points[n]) {
                        point = this.screenPoints[n];
                    }
                }
                ++n;
            }
            mark = this.footprint.getMark(this.screenPoints);
            if (point != null) {
                transform.setToTranslation(point.x, point.y);
                n = FontSizer.getIntegerFactor();
                if (n > 1) {
                    transform.scale(n, n);
                }
                final Color color = this.footprint.getColor();
                final Mark mark2 = mark;
                final Shape shape = transform.createTransformedShape(selectionShape);
                mark = new Mark(){

                    @Override
                    public void draw(Graphics2D graphics2D, boolean bl) {
                        mark2.draw(graphics2D, false);
                        Paint paint = graphics2D.getPaint();
                        graphics2D.setPaint(color);
                        graphics2D.fill(shape);
                        graphics2D.setPaint(paint);
                    }

                    @Override
                    public Rectangle getBounds(boolean bl) {
                        Rectangle rectangle = shape.getBounds();
                        rectangle.add(mark2.getBounds(false));
                        return rectangle;
                    }
                };
            }
            final Mark mark3 = mark;
            mark = new Mark(){

                @Override
                public void draw(Graphics2D graphics2D, boolean bl) {
                    if (!Step.this.valid) {
                        return;
                    }
                    mark3.draw(graphics2D, false);
                }

                @Override
                public Rectangle getBounds(boolean bl) {
                    return mark3.getBounds(bl);
                }
            };
            this.marks.put(trackerPanel, mark);
        }
        return mark;
    }

    public String toString() {
        return "Step " + this.n;
    }

    public Object clone() {
        try {
            Step step = (Step)super.clone();
            step.points = new TPoint[this.points.length];
            step.screenPoints = new Point[this.points.length];
            step.marks = new HashMap<TrackerPanel, Mark>();
            return step;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    protected void setHitRectCenter(int n, int n2) {
        hitRect.setLocation(n - Step.hitRect.width / 2, n2 - Step.hitRect.height / 2);
    }

    public static int getLength() {
        return 1;
    }

    class Handle
    extends TPoint {
        public Handle(double d, double d2) {
            super(d, d2);
        }

        public void setPositionOnLine(int n, int n2, TrackerPanel trackerPanel) {
        }
    }
}

