/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Shape;
import javax.swing.Icon;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.tools.FontSizer;

public class OutlineFootprint
extends LineFootprint {
    private int spread;

    public OutlineFootprint(String string) {
        super(string);
        this.setStroke(this.baseStroke);
    }

    public void setSpread(int n) {
        this.spread = n;
    }

    public int getSpread() {
        return this.spread;
    }

    @Override
    public Icon getIcon(int n, int n2) {
        int n3 = FontSizer.getIntegerFactor();
        Point[] pointArray = new Point[]{new Point(), new Point((n *= n3) - n3 * 2, n3 * 2 - (n2 *= n3))};
        int n4 = this.spread;
        this.spread = n3;
        Shape shape = this.getShape(pointArray);
        ShapeIcon shapeIcon = new ShapeIcon(shape, n, n2);
        shapeIcon.setColor(this.color);
        this.spread = n4;
        return shapeIcon;
    }

    @Override
    public void setStroke(BasicStroke basicStroke) {
        super.setStroke(basicStroke);
    }

    @Override
    public Shape getShape(Point[] pointArray) {
        Point point = pointArray[0];
        Point point2 = pointArray[1];
        double d = Math.atan2(point.y - point2.y, point.x - point2.x);
        this.transform.setToRotation(d, point2.x, point2.y);
        this.transform.translate(point2.x, point2.y);
        float f = (float)point.distance(point2);
        this.path.reset();
        this.path.moveTo(0.0f, -1 - this.spread);
        this.path.lineTo(0.0f, 1 + this.spread);
        this.path.lineTo(f, 1 + this.spread);
        this.path.lineTo(f, -1 - this.spread);
        this.path.closePath();
        int n = Math.min(this.spread + 1, 4);
        this.path.moveTo(f / 2.0f, n);
        this.path.lineTo(f / 2.0f, -n);
        int n2 = FontSizer.getIntegerFactor();
        if (this.getSpread() > 4 + 2 * n2) {
            this.path.moveTo(0.0f, 0.0f);
            this.path.lineTo(f, 0.0f);
        }
        Shape shape = this.transform.createTransformedShape(this.path);
        float f2 = Math.min((float)n2 * this.baseStroke.getLineWidth(), (float)(this.spread + 1));
        f2 = Math.max(f2, this.baseStroke.getLineWidth());
        if (this.stroke == null || this.stroke.getLineWidth() != f2) {
            this.stroke = new BasicStroke(f2);
        }
        shape = this.stroke.createStrokedShape(shape);
        this.path.reset();
        this.path.moveTo(f, -1 - this.spread);
        this.path.lineTo(f, 1 + this.spread);
        this.hitShapes[0] = this.transform.createTransformedShape(this.path);
        this.path.reset();
        this.path.moveTo(0.0f, -1 - this.spread);
        this.path.lineTo(0.0f, 1 + this.spread);
        this.hitShapes[1] = this.transform.createTransformedShape(this.path);
        float f3 = 0.45f;
        this.path.reset();
        this.path.moveTo(f * (0.5f + f3), 0.0f);
        this.path.lineTo(f * (0.5f - f3), 0.0f);
        this.hitShapes[2] = this.transform.createTransformedShape(this.path);
        return shape;
    }
}

