/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.OffsetOrigin;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class OffsetOriginStep
extends Step {
    private OffsetOrigin offset;
    private Position p;
    protected double worldX;
    protected double worldY;

    public OffsetOriginStep(OffsetOrigin offsetOrigin, int n, double d, double d2) {
        super(offsetOrigin, n);
        this.offset = offsetOrigin;
        this.screenPoints = new Point[OffsetOriginStep.getLength()];
        this.points = new TPoint[OffsetOriginStep.getLength()];
        this.p = new Position(d, d2);
        this.points[0] = this.p;
    }

    public Position getPosition() {
        return this.p;
    }

    public void setWorldXY(double d, double d2) {
        Object object;
        if (this.track.isLocked()) {
            return;
        }
        if (this.offset.isFixedCoordinates()) {
            object = (OffsetOriginStep)this.offset.steps.getStep(0);
            ((OffsetOriginStep)object).worldX = d;
            ((OffsetOriginStep)object).worldY = d2;
            ((Step)object).erase();
            this.offset.refreshStep(this);
        } else {
            this.worldX = d;
            this.worldY = d2;
            this.offset.keyFrames.add(this.n);
        }
        if (this.offset.trackerPanel == null) {
            return;
        }
        object = this.offset.trackerPanel.getCoords();
        int n = this.offset.trackerPanel.getFrameNumber();
        double d3 = ((ImageCoordSystem)object).getOriginX(n);
        double d4 = ((ImageCoordSystem)object).getOriginY(n);
        double d5 = ((ImageCoordSystem)object).worldToImageX(n, d, d2);
        double d6 = ((ImageCoordSystem)object).worldToImageY(n, d, d2);
        ((ImageCoordSystem)object).setOriginXY(n, d3 + this.p.x - d5, d4 + this.p.y - d6);
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.marks.get(trackerPanel);
        TPoint tPoint = null;
        if (mark == null) {
            Shape shape;
            ImageCoordSystem imageCoordSystem = trackerPanel.getCoords();
            int n = trackerPanel.getFrameNumber();
            double d = imageCoordSystem.worldToImageX(n, this.worldX, this.worldY);
            double d2 = imageCoordSystem.worldToImageY(n, this.worldX, this.worldY);
            this.p.setLocation(d, d2);
            tPoint = trackerPanel.getSelectedPoint();
            Point point = this.points[0].getScreenPosition(trackerPanel);
            if (tPoint == this.points[0]) {
                transform.setToTranslation(point.x, point.y);
                int n2 = FontSizer.getIntegerFactor();
                if (n2 > 1) {
                    transform.scale(n2, n2);
                }
                shape = transform.createTransformedShape(selectionShape);
            } else {
                shape = this.footprint.getShape(new Point[]{point});
            }
            final Color color = this.footprint.getColor();
            final Shape shape2 = shape;
            mark = new Mark(){

                @Override
                public void draw(Graphics2D graphics2D, boolean bl) {
                    Paint paint = graphics2D.getPaint();
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.setPaint(color);
                    graphics2D.fill(shape2);
                    graphics2D.setPaint(paint);
                }

                @Override
                public Rectangle getBounds(boolean bl) {
                    return shape2.getBounds();
                }
            };
            this.marks.put(trackerPanel, mark);
        }
        return mark;
    }

    @Override
    public Object clone() {
        OffsetOriginStep offsetOriginStep = (OffsetOriginStep)super.clone();
        TPoint[] tPointArray = offsetOriginStep.points;
        OffsetOriginStep offsetOriginStep2 = offsetOriginStep;
        offsetOriginStep2.getClass();
        offsetOriginStep.p = offsetOriginStep2.new Position(this.p.x, this.p.y);
        tPointArray[0] = offsetOriginStep.p;
        return offsetOriginStep;
    }

    @Override
    public String toString() {
        String string = "Offset Origin Step " + this.n + " [" + format.format(this.worldX) + ", " + format.format(this.worldY) + "]";
        return string;
    }

    public class Position
    extends TPoint {
        private double lastX;
        private double lastY;

        public Position(double d, double d2) {
            super.setXY(d, d2);
            this.setCoordsEditTrigger(true);
            if (((OffsetOriginStep)OffsetOriginStep.this).offset.trackerPanel == null) {
                return;
            }
            ImageCoordSystem imageCoordSystem = ((OffsetOriginStep)OffsetOriginStep.this).offset.trackerPanel.getCoords();
            int n = ((OffsetOriginStep)OffsetOriginStep.this).offset.trackerPanel.getFrameNumber();
            OffsetOriginStep.this.worldX = imageCoordSystem.imageToWorldX(n, d, d2);
            OffsetOriginStep.this.worldY = imageCoordSystem.imageToWorldY(n, d, d2);
        }

        @Override
        public void setXY(double d, double d2) {
            if (OffsetOriginStep.this.track.isLocked()) {
                return;
            }
            if (this.isAdjusting()) {
                this.lastX = d;
                this.lastY = d2;
            }
            double d3 = d - this.getX();
            double d4 = d2 - this.getY();
            super.setXY(d, d2);
            if (((OffsetOriginStep)OffsetOriginStep.this).offset.trackerPanel == null) {
                return;
            }
            ImageCoordSystem imageCoordSystem = ((OffsetOriginStep)OffsetOriginStep.this).offset.trackerPanel.getCoords();
            imageCoordSystem.setAdjusting(this.isAdjusting());
            int n = ((OffsetOriginStep)OffsetOriginStep.this).offset.trackerPanel.getFrameNumber();
            double d5 = imageCoordSystem.getOriginX(n);
            double d6 = imageCoordSystem.getOriginY(n);
            imageCoordSystem.setOriginXY(n, d5 + d3, d6 + d4);
            if (this.isAdjusting()) {
                OffsetOriginStep.this.repaint();
            }
        }

        @Override
        public void setAdjusting(boolean bl) {
            boolean bl2 = this.isAdjusting();
            super.setAdjusting(bl);
            if (bl2 && !bl) {
                this.setXY(this.lastX, this.lastY);
                OffsetOriginStep.this.track.firePropertyChange("step", null, OffsetOriginStep.this.n);
            }
        }

        @Override
        public void showCoordinates(VideoPanel videoPanel) {
            ((OffsetOriginStep)OffsetOriginStep.this).offset.xField.setValue(OffsetOriginStep.this.worldX);
            ((OffsetOriginStep)OffsetOriginStep.this).offset.yField.setValue(OffsetOriginStep.this.worldY);
            super.showCoordinates(videoPanel);
        }
    }
}

