/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.OffsetOriginStep;
import org.opensourcephysics.cabrillo.tracker.PointShapeFootprint;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;

public class OffsetOrigin
extends TTrack {
    private Component separator;
    protected boolean fixedCoordinates = true;
    protected JCheckBoxMenuItem fixedCoordinatesItem;
    protected JLabel unmarkedLabel;

    public OffsetOrigin() {
        this.defaultColors = new Color[]{Color.cyan, Color.magenta, Color.yellow.darker()};
        this.setFootprints(new Footprint[]{PointShapeFootprint.getFootprint("Footprint.BoldCrosshair"), PointShapeFootprint.getFootprint("Footprint.Crosshair")});
        this.defaultFootprint = this.getFootprint();
        this.setName(TrackerRes.getString("OffsetOrigin.New.Name"));
        this.setColor(this.defaultColors[0]);
        this.viewable = false;
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("OffsetOrigin.Unmarked.Hint");
        this.keyFrames.add(0);
        this.createGUI();
    }

    @Override
    public Step createStep(int n, double d, double d2) {
        if (this.isLocked()) {
            return null;
        }
        OffsetOriginStep offsetOriginStep = (OffsetOriginStep)this.getStep(n);
        if (offsetOriginStep == null) {
            offsetOriginStep = new OffsetOriginStep(this, n, d, d2);
            offsetOriginStep.setFootprint(this.getFootprint());
            this.steps = new TTrack.StepArray(this, offsetOriginStep);
            this.support.firePropertyChange("step", null, new Integer(n));
        } else if (this.trackerPanel != null) {
            XMLControlElement xMLControlElement = new XMLControlElement(this);
            OffsetOriginStep.Position position = offsetOriginStep.getPosition();
            position.setLocation(d, d2);
            Point2D point2D = position.getWorldPosition(this.trackerPanel);
            offsetOriginStep.worldX = point2D.getX();
            offsetOriginStep.worldY = point2D.getY();
            this.keyFrames.add(n);
            Undo.postTrackEdit(this, xMLControlElement);
        }
        return offsetOriginStep;
    }

    @Override
    public TPoint autoMarkAt(int n, double d, double d2) {
        OffsetOriginStep offsetOriginStep = (OffsetOriginStep)this.getStep(n);
        ImageCoordSystem imageCoordSystem = this.trackerPanel.getCoords();
        imageCoordSystem.setFixedOrigin(false);
        if (offsetOriginStep == null) {
            offsetOriginStep = (OffsetOriginStep)this.createStep(n, d, d2);
            if (offsetOriginStep != null) {
                return offsetOriginStep.getPoints()[0];
            }
        } else {
            TPoint tPoint = offsetOriginStep.getPoints()[0];
            if (tPoint != null) {
                Mark mark = (Mark)offsetOriginStep.marks.get(this.trackerPanel);
                if (mark == null) {
                    double d3 = imageCoordSystem.worldToImageX(n, offsetOriginStep.worldX, offsetOriginStep.worldY);
                    double d4 = imageCoordSystem.worldToImageY(n, offsetOriginStep.worldX, offsetOriginStep.worldY);
                    tPoint.setLocation(d3, d4);
                }
                tPoint.setAdjusting(true);
                tPoint.setXY(d, d2);
                tPoint.setAdjusting(false);
                this.firePropertyChange("step", null, n);
                return tPoint;
            }
        }
        return null;
    }

    @Override
    protected boolean isAutoTrackable() {
        return true;
    }

    public boolean isFixedCoordinates() {
        return this.fixedCoordinates;
    }

    public void setFixedCoordinates(boolean bl) {
        if (this.fixedCoordinates == bl) {
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        if (this.trackerPanel != null) {
            this.trackerPanel.changed = true;
            int n = this.trackerPanel.getFrameNumber();
            this.steps = new TTrack.StepArray(this, this.getStep(n));
            this.trackerPanel.repaint();
        }
        if (bl) {
            this.keyFrames.clear();
            this.keyFrames.add(0);
        }
        this.fixedCoordinates = bl;
        Undo.postTrackEdit(this, xMLControlElement);
    }

    @Override
    public Step getStep(int n) {
        OffsetOriginStep offsetOriginStep = (OffsetOriginStep)this.steps.getStep(n);
        this.refreshStep(offsetOriginStep);
        return offsetOriginStep;
    }

    @Override
    public boolean isLocked() {
        boolean bl = super.isLocked();
        if (this.trackerPanel != null) {
            bl = bl || this.trackerPanel.getCoords().isLocked();
        }
        return bl;
    }

    @Override
    public void setTrailVisible(boolean bl) {
    }

    @Override
    public int getStepLength() {
        return OffsetOriginStep.getLength();
    }

    @Override
    public int getFootprintLength() {
        return 1;
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!(drawingPanel instanceof TrackerPanel && this.isVisible() && this.isEnabled())) {
            return null;
        }
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        Interactive interactive = null;
        Step step = this.getStep(trackerPanel.getFrameNumber());
        if (step != null) {
            interactive = step.findInteractive(trackerPanel, n, n2);
        }
        if (interactive != null) {
            this.partName = TrackerRes.getString("OffsetOrigin.Position.Name");
            this.hint = TrackerRes.getString("OffsetOrigin.Position.Hint");
        } else {
            this.partName = TrackerRes.getString("TTrack.Selected.Hint");
            this.hint = TrackerRes.getString("OffsetOrigin.Unmarked.Hint");
        }
        return interactive;
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel) {
        JMenu jMenu = super.getMenu(trackerPanel);
        this.lockedItem.setEnabled(!trackerPanel.getCoords().isLocked());
        jMenu.remove(this.deleteTrackItem);
        jMenu.remove(jMenu.getMenuComponent(jMenu.getMenuComponentCount() - 1));
        this.fixedCoordinatesItem.setText(TrackerRes.getString("OffsetOrigin.MenuItem.Fixed"));
        this.fixedCoordinatesItem.setSelected(this.isFixedCoordinates());
        jMenu.add(this.fixedCoordinatesItem);
        jMenu.addSeparator();
        jMenu.add(this.deleteTrackItem);
        return jMenu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> arrayList = super.getToolbarTrackComponents(trackerPanel);
        arrayList.add(this.stepSeparator);
        this.unmarkedLabel.setText(TrackerRes.getString("TTrack.Label.Unmarked"));
        int n = trackerPanel.getFrameNumber();
        Step step = this.getStep(n);
        if (step == null) {
            arrayList.add(this.unmarkedLabel);
        } else {
            arrayList.add(this.xLabel);
            arrayList.add(this.xField);
            arrayList.add(this.separator);
            arrayList.add(this.yLabel);
            arrayList.add(this.yField);
        }
        boolean bl = trackerPanel.getCoords().isLocked() || super.isLocked();
        this.xField.setEnabled(!bl);
        this.yField.setEnabled(!bl);
        this.displayWorldCoordinates();
        return arrayList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("stepnumber")) {
            if (this.trackerPanel.getSelectedTrack() == this) {
                this.displayWorldCoordinates();
            }
        } else if (string.equals("locked")) {
            this.xField.setEnabled(!this.isLocked());
            this.yField.setEnabled(!this.isLocked());
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    @Override
    public void setLocked(boolean bl) {
        super.setLocked(bl);
        this.xField.setEnabled(!this.isLocked());
        this.yField.setEnabled(!this.isLocked());
    }

    @Override
    public String toString() {
        return TrackerRes.getString("OffsetOrigin.Name");
    }

    @Override
    protected String getTargetDescription(int n) {
        return TrackerRes.getString("OffsetOrigin.Position.Name");
    }

    protected void refreshStep(OffsetOriginStep offsetOriginStep) {
        boolean bl;
        if (offsetOriginStep == null) {
            return;
        }
        int n = 0;
        Iterator iterator = this.keyFrames.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (n2 > offsetOriginStep.n) continue;
            n = n2;
        }
        OffsetOriginStep offsetOriginStep2 = (OffsetOriginStep)this.steps.getStep(n);
        boolean bl2 = bl = offsetOriginStep2.worldX != offsetOriginStep.worldX || offsetOriginStep2.worldY != offsetOriginStep.worldY;
        if (bl) {
            offsetOriginStep.worldX = offsetOriginStep2.worldX;
            offsetOriginStep.worldY = offsetOriginStep2.worldY;
        }
        offsetOriginStep.erase();
    }

    private void setWorldCoordinatesFromFields() {
        boolean bl;
        if (this.trackerPanel == null) {
            return;
        }
        OffsetOriginStep offsetOriginStep = (OffsetOriginStep)this.getStep(this.trackerPanel.getFrameNumber());
        boolean bl2 = bl = offsetOriginStep.worldX != this.xField.getValue() || offsetOriginStep.worldY != this.yField.getValue();
        if (bl) {
            XMLControlElement xMLControlElement = new XMLControlElement(this);
            XMLControlElement xMLControlElement2 = new XMLControlElement(this.trackerPanel.getCoords());
            offsetOriginStep.setWorldXY(this.xField.getValue(), this.yField.getValue());
            offsetOriginStep.getPosition().showCoordinates(this.trackerPanel);
            Undo.postTrackAndCoordsEdit(this, xMLControlElement, xMLControlElement2);
        }
    }

    private void displayWorldCoordinates() {
        int n = this.trackerPanel == null ? 0 : this.trackerPanel.getFrameNumber();
        OffsetOriginStep offsetOriginStep = (OffsetOriginStep)this.getStep(n);
        if (offsetOriginStep == null) {
            this.xField.setText(null);
            this.yField.setText(null);
        } else {
            this.xField.setValue(offsetOriginStep.worldX);
            this.yField.setValue(offsetOriginStep.worldY);
        }
    }

    private void createGUI() {
        this.unmarkedLabel = new JLabel();
        this.unmarkedLabel.setForeground(Color.red.darker());
        this.fixedCoordinatesItem = new JCheckBoxMenuItem(TrackerRes.getString("OffsetOrigin.MenuItem.Fixed"));
        this.fixedCoordinatesItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OffsetOrigin.this.setFixedCoordinates(OffsetOrigin.this.fixedCoordinatesItem.isSelected());
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OffsetOrigin.this.setWorldCoordinatesFromFields();
                ((NumberField)actionEvent.getSource()).requestFocusInWindow();
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                OffsetOrigin.this.setWorldCoordinatesFromFields();
            }
        };
        this.xField.addActionListener(actionListener);
        this.xField.addFocusListener(focusAdapter);
        this.yField.addActionListener(actionListener);
        this.yField.addFocusListener(focusAdapter);
        this.separator = Box.createRigidArea(new Dimension(4, 4));
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            OffsetOrigin offsetOrigin = (OffsetOrigin)object;
            XML.getLoader(TTrack.class).saveObject(xMLControl, object);
            xMLControl.setValue("fixed_coordinates", offsetOrigin.isFixedCoordinates());
            if (!offsetOrigin.steps.isEmpty()) {
                Step[] stepArray = offsetOrigin.getSteps();
                double[][] dArrayArray = new double[stepArray.length][];
                int n = 0;
                while (n < stepArray.length) {
                    if (stepArray[n] != null && offsetOrigin.keyFrames.contains(n)) {
                        OffsetOriginStep offsetOriginStep = (OffsetOriginStep)stepArray[n];
                        dArrayArray[n] = new double[]{offsetOriginStep.worldX, offsetOriginStep.worldY};
                        if (!xMLControl.getPropertyNames().contains("worldX")) {
                            xMLControl.setValue("worldX", offsetOriginStep.worldX);
                            xMLControl.setValue("worldY", offsetOriginStep.worldY);
                        }
                    }
                    ++n;
                }
                xMLControl.setValue("world_coordinates", dArrayArray);
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new OffsetOrigin();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            OffsetOrigin offsetOrigin = (OffsetOrigin)object;
            XML.getLoader(TTrack.class).loadObject(xMLControl, object);
            boolean bl = offsetOrigin.isLocked();
            offsetOrigin.setLocked(false);
            if (xMLControl.getPropertyNames().contains("fixed_coordinates")) {
                offsetOrigin.fixedCoordinates = xMLControl.getBoolean("fixed_coordinates");
            }
            offsetOrigin.keyFrames.clear();
            if (offsetOrigin.steps.isEmpty()) {
                offsetOrigin.createStep(0, 0.0, 0.0);
            }
            offsetOrigin.keyFrames.clear();
            double[][] dArray = (double[][])xMLControl.getObject("world_coordinates");
            if (dArray != null) {
                int n = 0;
                while (n < dArray.length) {
                    if (dArray[n] != null) {
                        OffsetOriginStep offsetOriginStep = (OffsetOriginStep)offsetOrigin.getStep(n);
                        offsetOriginStep.worldX = dArray[n][0];
                        offsetOriginStep.worldY = dArray[n][1];
                        offsetOrigin.keyFrames.add(n);
                    }
                    ++n;
                }
            } else {
                OffsetOriginStep offsetOriginStep = (OffsetOriginStep)offsetOrigin.getStep(0);
                offsetOriginStep.worldX = xMLControl.getDouble("worldX");
                offsetOriginStep.worldY = xMLControl.getDouble("worldY");
                offsetOrigin.keyFrames.add(0);
            }
            offsetOrigin.setLocked(bl);
            offsetOrigin.displayWorldCoordinates();
            return object;
        }
    }
}

