/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.Calibration;
import org.opensourcephysics.cabrillo.tracker.OffsetOrigin;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TActions;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.ClipInspector;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.tools.FontSizer;

public class MainTView
extends JPanel
implements TView {
    private TrackerPanel trackerPanel;
    JScrollPane scrollPane;
    Rectangle scrollRect = new Rectangle();
    private Point zoomCenter = new Point();
    private JToolBar playerBar;

    public MainTView(TrackerPanel trackerPanel) {
        this.trackerPanel = trackerPanel;
        this.init();
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                TToolBar tToolBar = TToolBar.getToolbar(MainTView.this.trackerPanel);
                tToolBar.refreshZoomButton();
                MainTView.this.trackerPanel.eraseAll();
                MainTView.this.trackerPanel.repaint();
            }
        });
        SwingUtilities.replaceUIActionMap(this.scrollPane, null);
        this.add((Component)this.scrollPane, "Center");
        this.playerBar = new JToolBar();
        this.add((Component)this.playerBar, "South");
        this.trackerPanel.getPlayer().setBorder(null);
        this.trackerPanel.setPlayerVisible(false);
        this.playerBar.add(this.trackerPanel.getPlayer());
        this.scrollPane.setViewportView(this.trackerPanel);
        this.trackerPanel.setScrollPane(this.scrollPane);
        this.trackerPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                MainTView.this.zoomCenter.setLocation(mouseEvent.getPoint());
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (MainTView.this.trackerPanel.getCursor() == Tracker.zoomOutCursor) {
                    MainTView.this.zoomOut(false);
                } else if (MainTView.this.trackerPanel.getCursor() == Tracker.zoomInCursor) {
                    MainTView.this.zoomIn(false);
                }
            }
        });
        this.trackerPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                MainTView.this.zoomCenter.setLocation(mouseWheelEvent.getPoint());
                if (mouseWheelEvent.getWheelRotation() > 0) {
                    MainTView.this.zoomOut(true);
                } else {
                    MainTView.this.zoomIn(true);
                }
            }
        });
        this.trackerPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                JButton jButton = ((MainTView)MainTView.this).trackerPanel.getTFrame().getToolBar((TrackerPanel)((MainTView)MainTView.this).trackerPanel).zoomButton;
                int n = MainTView.this.trackerPanel.getSelectedPoint() == null ? 10 : 0;
                Rectangle rectangle = MainTView.this.scrollPane.getViewport().getViewRect();
                switch (keyEvent.getKeyCode()) {
                    case 90: {
                        if (keyEvent.isControlDown()) break;
                        jButton.setSelected(true);
                        break;
                    }
                    case 18: {
                        break;
                    }
                    case 33: {
                        if (!MainTView.this.trackerPanel.getPlayer().isEnabled()) {
                            return;
                        }
                        if (keyEvent.isShiftDown()) {
                            int n2 = MainTView.this.trackerPanel.getPlayer().getStepNumber() - 5;
                            MainTView.this.trackerPanel.getPlayer().setStepNumber(n2);
                            break;
                        }
                        MainTView.this.trackerPanel.getPlayer().back();
                        break;
                    }
                    case 34: {
                        if (!MainTView.this.trackerPanel.getPlayer().isEnabled()) {
                            return;
                        }
                        if (keyEvent.isShiftDown()) {
                            int n3 = MainTView.this.trackerPanel.getPlayer().getStepNumber() + 5;
                            MainTView.this.trackerPanel.getPlayer().setStepNumber(n3);
                            break;
                        }
                        MainTView.this.trackerPanel.getPlayer().step();
                        break;
                    }
                    case 36: {
                        if (!MainTView.this.trackerPanel.getPlayer().isEnabled()) {
                            return;
                        }
                        MainTView.this.trackerPanel.getPlayer().setStepNumber(0);
                        break;
                    }
                    case 35: {
                        if (!MainTView.this.trackerPanel.getPlayer().isEnabled()) {
                            return;
                        }
                        VideoClip videoClip = MainTView.this.trackerPanel.getPlayer().getVideoClip();
                        MainTView.this.trackerPanel.getPlayer().setStepNumber(videoClip.getStepCount() - 1);
                        break;
                    }
                    case 38: {
                        rectangle.y -= n;
                        MainTView.this.trackerPanel.scrollRectToVisible(rectangle);
                        break;
                    }
                    case 40: {
                        rectangle.y += n;
                        MainTView.this.trackerPanel.scrollRectToVisible(rectangle);
                        break;
                    }
                    case 39: {
                        rectangle.x += n;
                        MainTView.this.trackerPanel.scrollRectToVisible(rectangle);
                        break;
                    }
                    case 37: {
                        rectangle.x -= n;
                        MainTView.this.trackerPanel.scrollRectToVisible(rectangle);
                    }
                }
                if (jButton.isSelected()) {
                    MainTView.this.trackerPanel.setCursor(keyEvent.isAltDown() ? Tracker.getZoomOutCursor() : Tracker.getZoomInCursor());
                }
            }

            @Override
            public void keyReleased(final KeyEvent keyEvent) {
                JButton jButton = ((MainTView)MainTView.this).trackerPanel.getTFrame().getToolBar((TrackerPanel)((MainTView)MainTView.this).trackerPanel).zoomButton;
                if (keyEvent.getKeyCode() == 90) {
                    jButton.setSelected(false);
                    MainTView.this.trackerPanel.setCursor(Cursor.getDefaultCursor());
                }
                if (jButton.isSelected()) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public synchronized void run() {
                            MainTView.this.trackerPanel.setCursor(keyEvent.isAltDown() ? Tracker.getZoomOutCursor() : Tracker.getZoomInCursor());
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    JPopupMenu getPopupMenu() {
        Object object;
        Object object2;
        Trackable trackable;
        if (this.trackerPanel.getCursor() == Tracker.zoomInCursor || this.trackerPanel.getCursor() == Tracker.zoomOutCursor) {
            return null;
        }
        JPopupMenu jPopupMenu = this.trackerPanel.popup;
        boolean bl = false;
        Interactive interactive = this.trackerPanel.getInteractive();
        if (interactive instanceof TPoint) {
            trackable = (TPoint)interactive;
            Object object32 = null;
            object2 = null;
            for (TTrack tTrack : this.trackerPanel.getTracks()) {
                object2 = tTrack.getStep((TPoint)trackable, this.trackerPanel);
                if (object2 != null) break;
            }
            if (object2 != null) {
                void var5_6;
                bl = true;
                object = this.trackerPanel.selectedStep;
                this.trackerPanel.selectedStep = object2;
                jPopupMenu = var5_6.getMenu(this.trackerPanel).getPopupMenu();
                this.trackerPanel.selectedStep = object;
            }
        }
        if (!bl) {
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            jPopupMenu.removeAll();
            trackable = this.trackerPanel.getVideo();
            JMenuItem jMenuItem = new JMenuItem(TrackerRes.getString("MainTView.Popup.MenuItem.ZoomIn"));
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainTView.this.zoomIn(false);
                }
            });
            JMenuItem jMenuItem2 = new JMenuItem(TrackerRes.getString("MainTView.Popup.MenuItem.ZoomOut"));
            jPopupMenu.add(jMenuItem2);
            jMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainTView.this.zoomOut(false);
                }
            });
            JMenuItem jMenuItem3 = new JMenuItem(TrackerRes.getString("MainTView.Popup.MenuItem.ZoomToFit"));
            jPopupMenu.add(jMenuItem3);
            jMenuItem3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainTView.this.trackerPanel.setMagnification(-1.0);
                    TToolBar tToolBar = TToolBar.getToolbar(MainTView.this.trackerPanel);
                    tToolBar.refreshZoomButton();
                }
            });
            object2 = this.trackerPanel.getZoomBox();
            if (((DrawingPanel.ZoomBox)object2).isDragged() && this.isStepsInZoomBox()) {
                jPopupMenu.addSeparator();
                JMenuItem jMenuItem4 = new JMenuItem(TrackerRes.getString("MainTView.Popup.MenuItem.Select"));
                jMenuItem4.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MainTView.this.handleStepsInZoomBox(true);
                    }
                });
                jPopupMenu.add(jMenuItem4);
                JMenuItem jMenuItem5 = new JMenuItem(TrackerRes.getString("MainTView.Popup.MenuItem.Deselect"));
                jMenuItem5.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MainTView.this.handleStepsInZoomBox(false);
                    }
                });
                jPopupMenu.add(jMenuItem5);
            }
            if (this.trackerPanel.isEnabled("button.clipSettings")) {
                if (jPopupMenu.getComponentCount() > 0) {
                    jPopupMenu.addSeparator();
                }
                JMenuItem jMenuItem6 = new JMenuItem(String.valueOf(MediaRes.getString("ClipInspector.Title")) + "...");
                jMenuItem6.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TFrame tFrame;
                        ClipControl clipControl;
                        VideoClip videoClip = MainTView.this.trackerPanel.getPlayer().getVideoClip();
                        ClipInspector clipInspector = videoClip.getClipInspector(clipControl = MainTView.this.trackerPanel.getPlayer().getClipControl(), tFrame = MainTView.this.trackerPanel.getTFrame());
                        if (clipInspector.isVisible()) {
                            return;
                        }
                        FontSizer.setFonts(clipInspector, FontSizer.getLevel());
                        clipInspector.pack();
                        Point point = new Frame().getLocation();
                        Point point2 = clipInspector.getLocation();
                        if (point2.x == point.x && point2.y == point.y) {
                            Rectangle rectangle = MainTView.this.trackerPanel.getVisibleRect();
                            Point point3 = tFrame.getMainView((TrackerPanel)((MainTView)MainTView.this).trackerPanel).scrollPane.getLocationOnScreen();
                            int n = point3.x + (rectangle.width - clipInspector.getBounds().width) / 2;
                            int n2 = point3.y + (rectangle.height - clipInspector.getBounds().height) / 2;
                            clipInspector.setLocation(n, n2);
                        }
                        clipInspector.initialize();
                        clipInspector.setVisible(true);
                        MainTView.this.refresh();
                    }
                });
                jPopupMenu.add(jMenuItem6);
            }
            if (this.trackerPanel.isEnabled("edit.copyImage")) {
                jPopupMenu.addSeparator();
                object6 = new AbstractAction(TrackerRes.getString("TMenuBar.Menu.CopyImage")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        BufferedImage bufferedImage = new TrackerIO.ComponentImage(MainTView.this.trackerPanel).getImage();
                        DrawingPanel.ZoomBox zoomBox = MainTView.this.trackerPanel.getZoomBox();
                        if (zoomBox.isDragged()) {
                            Rectangle rectangle = zoomBox.reportZoom();
                            BufferedImage bufferedImage2 = new BufferedImage(rectangle.width, rectangle.height, bufferedImage.getType());
                            Graphics2D graphics2D = bufferedImage2.createGraphics();
                            graphics2D.drawImage((Image)bufferedImage, -rectangle.x, -rectangle.y, null);
                            TrackerIO.copyImage(bufferedImage2);
                        } else {
                            TrackerIO.copyImage(bufferedImage);
                        }
                    }
                };
                object = new JMenuItem((Action)object6);
                jPopupMenu.add((JMenuItem)object);
                object5 = new AbstractAction(DisplayRes.getString("DisplayPanel.Snapshot_menu_item")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MainTView.this.trackerPanel.snapshot();
                    }
                };
                object4 = new JMenuItem((Action)object5);
                jPopupMenu.add((JMenuItem)object4);
            }
            object6 = TMenuBar.getMenuBar(this.trackerPanel);
            if (trackable != null && this.trackerPanel.isEnabled("video.filters") && ((JMenu)(object = ((TMenuBar)object6).filtersMenu)).getItemCount() > 0) {
                jPopupMenu.addSeparator();
                jPopupMenu.add((JMenuItem)object);
            }
            object = new JMenu(TrackerRes.getString("TMenuBar.Menu.Tracks"));
            if (((TMenuBar)object6).createMenu.getItemCount() == 0) {
                Component[] componentArray = ((TMenuBar)object6).newTrackItems;
                int n = ((TMenuBar)object6).newTrackItems.length;
                int n2 = 0;
                while (n2 < n) {
                    object5 = componentArray[n2];
                    ((TMenuBar)object6).createMenu.add((Component)object5);
                    ++n2;
                }
            }
            if (((TMenuBar)object6).createMenu.getItemCount() > 0) {
                ((JMenu)object).add(((TMenuBar)object6).createMenu);
            }
            if (((TMenuBar)object6).cloneMenu.getItemCount() > 0 && this.trackerPanel.isEnabled("new.clone")) {
                ((JMenu)object).add(((TMenuBar)object6).cloneMenu);
            }
            object5 = null;
            object4 = this.trackerPanel.getAxes();
            ArrayList<TTrack> arrayList = this.trackerPanel.getUserTracks();
            if (!arrayList.isEmpty()) {
                if (((JMenu)object).getItemCount() > 0) {
                    ((JMenu)object).addSeparator();
                }
                Iterator<TTrack> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ((JMenu)object).add(((TMenuBar)object6).getMenu(iterator.next()));
                }
            }
            if (this.trackerPanel.isEnabled("button.axes") || this.trackerPanel.isEnabled("calibration.stick") || this.trackerPanel.isEnabled("calibration.tape") || this.trackerPanel.isEnabled("calibration.points") || this.trackerPanel.isEnabled("calibration.offsetOrigin")) {
                if (((JMenu)object).getItemCount() > 0) {
                    ((JMenu)object).addSeparator();
                }
                if (object4 != null && this.trackerPanel.isEnabled("button.axes")) {
                    object5 = object4;
                    ((JMenu)object).add(((TMenuBar)object6).getMenu((TTrack)object5));
                }
                if (!this.trackerPanel.calibrationTools.isEmpty()) {
                    for (TTrack tTrack : this.trackerPanel.getTracks()) {
                        if (!this.trackerPanel.calibrationTools.contains(tTrack) || tTrack instanceof TapeMeasure && (((TapeMeasure)(object3 = (TapeMeasure)tTrack)).isStickMode() && !this.trackerPanel.isEnabled("calibration.stick") || !((TapeMeasure)object3).isStickMode() && !this.trackerPanel.isEnabled("calibration.tape")) || tTrack instanceof Calibration && !this.trackerPanel.isEnabled("calibration.points") || tTrack instanceof OffsetOrigin && !this.trackerPanel.isEnabled("calibration.offsetOrigin")) continue;
                        ((JMenu)object).add(((TMenuBar)object6).getMenu(tTrack));
                    }
                }
            }
            if (((JMenu)object).getItemCount() > 0) {
                jPopupMenu.addSeparator();
                jPopupMenu.add((JMenuItem)object);
            }
            Action action = TActions.getAction("aboutVideo", this.trackerPanel);
            JMenuItem jMenuItem7 = new JMenuItem(action);
            jPopupMenu.addSeparator();
            jMenuItem7.setText(TrackerRes.getString("TActions.AboutVideo"));
            jPopupMenu.add(jMenuItem7);
            if (this.trackerPanel.isEnabled("file.print")) {
                if (jPopupMenu.getComponentCount() > 0) {
                    jPopupMenu.addSeparator();
                }
                object3 = TActions.getAction("print", this.trackerPanel);
                jPopupMenu.add((Action)object3);
            }
            if (jPopupMenu.getComponentCount() > 0) {
                jPopupMenu.addSeparator();
            }
            object3 = new JMenuItem(TrackerRes.getString("Tracker.Popup.MenuItem.Help"));
            ((AbstractButton)object3).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TFrame tFrame = MainTView.this.trackerPanel.getTFrame();
                    if (tFrame != null) {
                        tFrame.showHelp("GUI", 0);
                    }
                }
            });
            jPopupMenu.add((JMenuItem)object3);
        }
        FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
        return jPopupMenu;
    }

    public void setZoomCenter(int n, int n2) {
        this.zoomCenter.setLocation(n, n2);
    }

    public void scrollToZoomCenter(Dimension dimension, Dimension dimension2, Point point) {
        double d = dimension.getWidth() / dimension2.getWidth();
        double d2 = dimension.getHeight() / dimension2.getHeight();
        Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
        if (dimension2.width < rectangle.width || dimension2.height < rectangle.height) {
            rectangle.setLocation((int)(-d * (double)point.x), (int)(-d2 * (double)point.y));
        }
        double d3 = (double)rectangle.x + (d - 1.0) * this.zoomCenter.getX();
        double d4 = (double)rectangle.y + (d2 - 1.0) * this.zoomCenter.getY();
        rectangle.setLocation((int)d3, (int)d4);
        this.scrollRect.setBounds(rectangle);
        this.trackerPanel.scrollRectToVisible(this.scrollRect);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Rectangle rectangle = MainTView.this.scrollPane.getViewport().getViewRect();
                if (!rectangle.equals(MainTView.this.scrollRect)) {
                    MainTView.this.trackerPanel.scrollRectToVisible(MainTView.this.scrollRect);
                }
                MainTView.this.trackerPanel.eraseAll();
                MainTView.this.trackerPanel.repaint();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public JToolBar getPlayerBar() {
        return this.playerBar;
    }

    @Override
    public void refresh() {
        this.init();
    }

    @Override
    public void init() {
        this.cleanup();
        this.trackerPanel.addPropertyChangeListener("track", this);
        for (TTrack tTrack : this.trackerPanel.getTracks()) {
            tTrack.addPropertyChangeListener("color", this);
        }
    }

    @Override
    public void cleanup() {
        this.trackerPanel.removePropertyChangeListener("track", this);
        for (TTrack tTrack : this.trackerPanel.getTracks()) {
            tTrack.removePropertyChangeListener("color", this);
        }
    }

    @Override
    public TrackerPanel getTrackerPanel() {
        return this.trackerPanel;
    }

    @Override
    public String getViewName() {
        return TrackerRes.getString("TFrame.View.Video");
    }

    @Override
    public Icon getViewIcon() {
        return new ImageIcon(Tracker.class.getResource("resources/images/video_on.gif"));
    }

    @Override
    public ArrayList<Component> getToolBarComponents() {
        return new ArrayList<Component>();
    }

    @Override
    public boolean isCustomState() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("track")) {
            this.refresh();
        } else if (string.equals("color")) {
            this.repaint();
        }
    }

    public void zoomIn(boolean bl) {
        DrawingPanel.ZoomBox zoomBox = this.trackerPanel.getZoomBox();
        double d = this.trackerPanel.getMagnification();
        double d2 = TrackerPanel.ZOOM_STEP * d;
        if (bl) {
            double d3 = Math.sqrt(TrackerPanel.ZOOM_STEP);
            int n = 0;
            while (n < TrackerPanel.ZOOM_LEVELS.length) {
                if (TrackerPanel.ZOOM_LEVELS[n] < d2 * d3 && TrackerPanel.ZOOM_LEVELS[n] > d2 / d3) {
                    d2 = TrackerPanel.ZOOM_LEVELS[n];
                    break;
                }
                ++n;
            }
        } else if (!zoomBox.isDragged()) {
            int n = 0;
            while (n < TrackerPanel.ZOOM_LEVELS.length) {
                if (TrackerPanel.ZOOM_LEVELS[n] >= d2 && TrackerPanel.ZOOM_LEVELS[n] < d2 * 2.0) {
                    d2 = TrackerPanel.ZOOM_LEVELS[n];
                    break;
                }
                ++n;
            }
            if (d2 > TrackerPanel.ZOOM_LEVELS[TrackerPanel.ZOOM_LEVELS.length - 1]) {
                d2 = 12.0;
            }
        } else {
            Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
            Rectangle rectangle2 = zoomBox.reportZoom();
            Dimension dimension = this.trackerPanel.getPreferredSize();
            Point point = new TPoint(0.0, 0.0).getScreenPosition(this.trackerPanel);
            if (dimension.width == 1 && dimension.height == 1) {
                double d4 = this.trackerPanel.getImageWidth();
                double d5 = this.trackerPanel.getImageHeight();
                Point point2 = new TPoint(d4, d5).getScreenPosition(this.trackerPanel);
                dimension.width = point2.x - point.x;
                dimension.height = point2.y - point.y;
            }
            Rectangle rectangle3 = new Rectangle(point.x, point.y, dimension.width, dimension.height);
            if (1.0 * (double)rectangle.width / (double)dimension.width < 1.0) {
                rectangle3.x = -rectangle.x;
            }
            if (1.0 * (double)rectangle.height / (double)dimension.height < 1.0) {
                rectangle3.y = -rectangle.y;
            }
            rectangle2 = rectangle2.intersection(rectangle3);
            double d6 = 1.0 * (double)rectangle.width / (double)rectangle2.width;
            double d7 = 1.0 * (double)rectangle.height / (double)rectangle2.height;
            double d8 = d6 / d7;
            double d9 = d8 < 1.0 ? d6 : d7;
            d2 = d * d9;
            double d10 = 1.011;
            int n = 0;
            while (n < TrackerPanel.ZOOM_LEVELS.length) {
                if (TrackerPanel.ZOOM_LEVELS[n] < d2 * d10 && TrackerPanel.ZOOM_LEVELS[n] > d2 / d10) {
                    d2 = TrackerPanel.ZOOM_LEVELS[n];
                    d9 = d2 / d;
                    break;
                }
                ++n;
            }
            if (d9 * (double)dimension.width > (double)rectangle.width || d9 * (double)dimension.height > (double)rectangle.height) {
                if (d8 < 1.0) {
                    rectangle2.height = (int)((double)rectangle2.height / d8);
                    rectangle2.y -= (int)(0.5 * (double)rectangle2.height * (1.0 - d8));
                    rectangle2.y = Math.max(rectangle2.y, rectangle3.y);
                    rectangle2.y = Math.min(rectangle2.y, rectangle3.y + rectangle3.height - rectangle2.height);
                } else {
                    rectangle2.width = (int)((double)rectangle2.width * d8);
                    rectangle2.x -= (int)(0.5 * (double)rectangle2.width * (1.0 - 1.0 / d8));
                    rectangle2.x = Math.max(rectangle2.x, rectangle3.x);
                    rectangle2.x = Math.min(rectangle2.x, rectangle3.x + rectangle3.width - rectangle2.width);
                }
                n = d * (double)dimension.width < (double)rectangle.width && d * (double)dimension.height < (double)rectangle.height ? 1 : 0;
                double d11 = n != 0 ? 0.0 : d * (double)point.x / (d2 - d);
                double d12 = d2 * (double)rectangle2.x / (d2 - d) + d11;
                d11 = n != 0 ? 0.0 : d * (double)point.y / (d2 - d);
                double d13 = d2 * (double)rectangle2.y / (d2 - d) + d11;
                this.zoomCenter.setLocation(d12, d13);
            }
        }
        this.trackerPanel.setMagnification(d2);
    }

    public void zoomOut(boolean bl) {
        double d = this.trackerPanel.getMagnification();
        double d2 = d / TrackerPanel.ZOOM_STEP;
        if (bl) {
            double d3 = Math.sqrt(TrackerPanel.ZOOM_STEP);
            int n = 0;
            while (n < TrackerPanel.ZOOM_LEVELS.length) {
                if (TrackerPanel.ZOOM_LEVELS[n] < d2 * d3 && TrackerPanel.ZOOM_LEVELS[n] > d2 / d3) {
                    d2 = TrackerPanel.ZOOM_LEVELS[n];
                    break;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < TrackerPanel.ZOOM_LEVELS.length) {
                if (TrackerPanel.ZOOM_LEVELS[n] <= d2 && TrackerPanel.ZOOM_LEVELS[n] > d2 / 2.0) {
                    d2 = TrackerPanel.ZOOM_LEVELS[n];
                    break;
                }
                ++n;
            }
            if (d2 < TrackerPanel.ZOOM_LEVELS[0]) {
                d2 = 0.15;
            }
        }
        this.trackerPanel.setMagnification(d2);
    }

    protected boolean isStepsInZoomBox() {
        DrawingPanel.ZoomBox zoomBox = this.trackerPanel.getZoomBox();
        Rectangle rectangle = zoomBox.reportZoom();
        ArrayList<TTrack> arrayList = this.trackerPanel.getTracks();
        for (TTrack tTrack : arrayList) {
            if (!tTrack.isVisible() || tTrack.getClass() != PointMass.class || !((PointMass)tTrack).isPositionVisible(this.trackerPanel)) continue;
            Step[] stepArray = tTrack.getSteps();
            int n = stepArray.length;
            int n2 = 0;
            while (n2 < n) {
                TPoint tPoint;
                Step step = stepArray[n2];
                if (step != null && (tPoint = step.getPoints()[0]) != null && !Double.isNaN(tPoint.getX()) && rectangle.contains(tPoint.getScreenPosition(this.trackerPanel))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected void handleStepsInZoomBox(boolean bl) {
        DrawingPanel.ZoomBox zoomBox = this.trackerPanel.getZoomBox();
        Rectangle rectangle = zoomBox.reportZoom();
        ArrayList<TTrack> arrayList = this.trackerPanel.getTracks();
        for (TTrack object : arrayList) {
            if (!object.isVisible() || object.getClass() != PointMass.class || !((PointMass)object).isPositionVisible(this.trackerPanel)) continue;
            Step[] stepArray = object.getSteps();
            int n = stepArray.length;
            int n2 = 0;
            while (n2 < n) {
                TPoint tPoint;
                Step step = stepArray[n2];
                if (step != null && (tPoint = step.getPoints()[0]) != null && !Double.isNaN(tPoint.getX()) && rectangle.contains(tPoint.getScreenPosition(this.trackerPanel))) {
                    if (bl) {
                        this.trackerPanel.selectedSteps.add(step);
                    } else {
                        this.trackerPanel.selectedSteps.remove(step);
                    }
                    step.erase();
                }
                ++n2;
            }
        }
        if (bl && this.trackerPanel.selectedSteps.size() == 1) {
            Step step = this.trackerPanel.selectedSteps.toArray(new Step[1])[0];
            this.trackerPanel.setSelectedPoint(step.points[0]);
        } else if (this.trackerPanel.selectedSteps.size() > 1) {
            this.trackerPanel.setSelectedPoint(null);
        }
    }
}

