/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import javax.swing.Icon;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.tools.FontSizer;

public class DoubleCrosshairFootprint
extends LineFootprint {
    protected Shape targetShape;
    protected int size;
    protected Shape hitShape;

    public DoubleCrosshairFootprint(String string) {
        super(string);
        this.setCrosshairSize(4, 0);
    }

    public void setCrosshairSize(int n, int n2) {
        this.size = n;
        this.path.reset();
        this.path.moveTo(-n, 0.0f);
        this.path.lineTo(-n2, 0.0f);
        this.path.moveTo(n, 0.0f);
        this.path.lineTo(n2, 0.0f);
        this.path.moveTo(0.0f, n);
        this.path.lineTo(0.0f, n2);
        this.path.moveTo(0.0f, -n);
        this.path.lineTo(0.0f, -n2);
        this.transform.setToIdentity();
        this.targetShape = this.transform.createTransformedShape(this.path);
        this.hitShape = new Rectangle(-this.size / 2, -this.size / 2, this.size, this.size);
    }

    @Override
    public Icon getIcon(int n, int n2) {
        int n3 = FontSizer.getIntegerFactor();
        n *= n3;
        n2 *= n3;
        if (this.stroke == null || this.stroke.getLineWidth() != (float)n3 * this.baseStroke.getLineWidth()) {
            this.stroke = new BasicStroke((float)n3 * this.baseStroke.getLineWidth());
        }
        this.transform.setToScale(n3, n3);
        Shape shape = this.stroke.createStrokedShape(this.transform.createTransformedShape(this.targetShape));
        Area area = new Area(shape);
        double d = n3 * (this.size + 2) - n;
        double d2 = n2 - n3 * (this.size + 2);
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = d * (double)n3 * (double)this.size / d3;
        double d5 = d2 * (double)n3 * (double)this.size / d3;
        Line2D.Double double_ = new Line2D.Double(d, d2, d4, d5);
        area.add(new Area(this.stroke.createStrokedShape(double_)));
        ShapeIcon shapeIcon = new ShapeIcon(area, n, n2);
        shapeIcon.setColor(this.color);
        return shapeIcon;
    }

    @Override
    public void setStroke(BasicStroke basicStroke) {
        if (basicStroke == null) {
            return;
        }
        this.baseStroke = basicStroke;
    }

    @Override
    public Shape getShape(Point[] pointArray) {
        Point point = pointArray[0];
        Point point2 = pointArray[1];
        this.transform.setToTranslation(point.x, point.y);
        int n = FontSizer.getIntegerFactor();
        if (n > 1) {
            this.transform.scale(n, n);
        }
        Shape shape = this.transform.createTransformedShape(this.targetShape);
        this.hitShapes[0] = this.transform.createTransformedShape(this.hitShape);
        this.transform.setToTranslation(point2.x, point2.y);
        if (n > 1) {
            this.transform.scale(n, n);
        }
        Shape shape2 = this.transform.createTransformedShape(this.targetShape);
        this.hitShapes[1] = this.transform.createTransformedShape(this.hitShape);
        float f = (float)point.distance(point2);
        float f2 = f / 2.0f;
        float f3 = f - (float)(n * 2 * (this.size + 3));
        float f4 = 0.45f;
        this.path.reset();
        this.path.moveTo(f2 - f4 * f3, 0.0f);
        this.path.lineTo(f2 + f4 * f3, 0.0f);
        double d = Math.atan2(point.y - point2.y, point.x - point2.x);
        this.transform.setToRotation(d, point2.x, point2.y);
        this.transform.translate(point2.x, point2.y);
        this.hitShapes[2] = this.transform.createTransformedShape(this.path);
        this.path.reset();
        this.path.moveTo(f2 - f3 / 2.0f, 0.0f);
        this.path.lineTo(f2 + f3 / 2.0f, 0.0f);
        Shape shape3 = this.transform.createTransformedShape(this.path);
        if (this.stroke == null || this.stroke.getLineWidth() != (float)n * this.baseStroke.getLineWidth()) {
            this.stroke = new BasicStroke((float)n * this.baseStroke.getLineWidth());
        }
        Area area = new Area(this.stroke.createStrokedShape(shape));
        area.add(new Area(this.stroke.createStrokedShape(shape2)));
        area.add(new Area(this.stroke.createStrokedShape(shape3)));
        return area;
    }
}

