/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FontSizer;

public class DerivativeAlgorithmDialog
extends JDialog {
    protected TrackerPanel trackerPanel;
    protected ArrayList<PointMass> allMasses = new ArrayList();
    protected ArrayList<PointMass> targetMasses = new ArrayList();
    protected JButton okButton;
    protected JButton cancelButton;
    JTextPane textPane;
    int[] types;
    JRadioButton[] buttons;
    TitledBorder choiceBorder;
    int prevAlgorithm;

    public DerivativeAlgorithmDialog(TrackerPanel trackerPanel) {
        super((Frame)trackerPanel.getTFrame(), false);
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.types = nArray;
        this.buttons = new JRadioButton[this.types.length];
        this.trackerPanel = trackerPanel;
        this.allMasses = trackerPanel.getDrawables(PointMass.class);
        this.targetMasses.addAll(this.allMasses);
        this.createGUI();
        this.pack();
        this.okButton.requestFocusInWindow();
    }

    private void createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        this.textPane = new JTextPane();
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        jPanel.add((Component)jScrollPane, "Center");
        Box box = Box.createHorizontalBox();
        this.choiceBorder = BorderFactory.createTitledBorder("");
        Border border = BorderFactory.createEmptyBorder(3, 2, 3, 2);
        box.setBorder(BorderFactory.createCompoundBorder(border, this.choiceBorder));
        ButtonGroup buttonGroup = new ButtonGroup();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                for (PointMass pointMass : DerivativeAlgorithmDialog.this.targetMasses) {
                    pointMass.setAlgorithm(n);
                }
                DerivativeAlgorithmDialog.this.refreshInfo(n);
            }
        };
        int n = 0;
        while (n < this.types.length) {
            int n2 = this.types[n];
            this.buttons[n] = new JRadioButton();
            this.buttons[n].setActionCommand(String.valueOf(n2));
            this.buttons[n].addActionListener(abstractAction);
            buttonGroup.add(this.buttons[n]);
            box.add(this.buttons[n]);
            ++n;
        }
        jPanel.add((Component)box, "North");
        this.okButton = new JButton();
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DerivativeAlgorithmDialog.this.setVisible(false);
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.setForeground(new Color(0, 0, 102));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DerivativeAlgorithmDialog.this.revert();
                DerivativeAlgorithmDialog.this.setVisible(false);
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(1, 0, 3, 0));
        jPanel.add((Component)jPanel2, "South");
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        this.refreshGUI();
    }

    private void refreshGUI() {
        this.setTitle(TrackerRes.getString("AlgorithmDialog.Title"));
        this.choiceBorder.setTitle(TrackerRes.getString("AlgorithmDialog.TitledBorder.Choose"));
        this.okButton.setText(TrackerRes.getString("Dialog.Button.OK"));
        this.cancelButton.setText(TrackerRes.getString("Dialog.Button.Cancel"));
        int n = 0;
        while (n < this.types.length) {
            int n2 = this.types[n];
            String string = "";
            if (n2 == 0) {
                string = TrackerRes.getString("AlgorithmDialog.Button.FiniteDifference");
            } else if (n2 == 1) {
                string = TrackerRes.getString("AlgorithmDialog.Button.BounceDetect");
            }
            this.buttons[n].setText(string);
            ++n;
        }
    }

    private void refreshInfo(int n) {
        String string = "";
        if (n == 0) {
            string = String.valueOf(TrackerRes.getString("AlgorithmDialog.FiniteDifference.Message1")) + "\n\n    " + TrackerRes.getString("AlgorithmDialog.FiniteDifference.Message2") + "\n\n    " + TrackerRes.getString("AlgorithmDialog.FiniteDifference.Message3");
        } else if (n == 1) {
            String string2 = "http://gasstationwithoutpumps.wordpress.com/2011/11/08/tracker-video-analysis-tool-fixes/";
            string = String.valueOf(TrackerRes.getString("AlgorithmDialog.BounceDetect.Message1")) + " " + TrackerRes.getString("AlgorithmDialog.BounceDetect.Message2") + "\n\n" + string2;
        }
        this.textPane.setText(string);
    }

    private void initialize() {
        if (!this.targetMasses.isEmpty()) {
            PointMass pointMass = this.targetMasses.get(0);
            this.prevAlgorithm = pointMass.algorithm;
        }
        int n = 0;
        while (n < this.types.length) {
            int n2 = this.types[n];
            if (n2 == this.prevAlgorithm) {
                this.buttons[n].setSelected(true);
                this.refreshInfo(n2);
                break;
            }
            ++n;
        }
    }

    private void revert() {
        for (PointMass pointMass : this.targetMasses) {
            pointMass.setAlgorithm(this.prevAlgorithm);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        this.initialize();
        super.setVisible(bl);
    }

    protected void setFontLevel(int n) {
        FontSizer.setFonts(this, n);
        FontSizer.setFonts(this.choiceBorder, n);
        int n2 = (int)(400.0 * (1.0 + (double)n * 0.5));
        int n3 = (int)(100.0 * (1.0 + (double)n * 0.35));
        this.textPane.setPreferredSize(new Dimension(n2, n3));
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n4 = (dimension.width - this.getBounds().width) / 2;
        int n5 = (dimension.height - this.getBounds().height) / 2;
        this.setLocation(n4, n5);
    }
}

